/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function(Drupal,drupalSettings){'use strict';Drupal.behaviors.cartDropdownPositioning={attach:function(context,settings){once('cart-dropdown-positioning','.cart-block__dropdown',context).forEach(function(dropdown){const trigger=context.querySelector('[data-bs-target="#'+dropdown.id+'"]');if(!trigger)return;const hoverEnabled=dropdown.classList.contains('cart-block__dropdown--hover');let hoverTimeout;function adjustPosition(){const computedStyle=window.getComputedStyle(dropdown);const dropdownWidthRem=parseFloat(computedStyle.getPropertyValue('--cart-dropdown-width'))||20;const rootFontSize=parseFloat(getComputedStyle(document.documentElement).fontSize);const dropdownWidth=dropdownWidthRem*rootFontSize;const cartBlock=dropdown.closest('.block-commerce-cart');const cartBlockRect=cartBlock.getBoundingClientRect();const viewportWidth=window.innerWidth;dropdown.style.left='';dropdown.style.right='';const isCentered=dropdown.classList.contains('cart-block__dropdown--center');if(isCentered){const cartBlockCenter=cartBlockRect.left+(cartBlockRect.width/2);const dropdownLeft=cartBlockCenter-(dropdownWidth/2);const dropdownRight=cartBlockCenter+(dropdownWidth/2);if(dropdownLeft<0){const overflowRem=Math.abs(dropdownLeft)/rootFontSize;dropdown.style.left=overflowRem+'rem';}else{if(dropdownRight>viewportWidth){const overflow=dropdownRight-viewportWidth;const overflowRem=overflow/rootFontSize;dropdown.style.left=-overflowRem+'rem';}}}else{const spaceToRight=viewportWidth-cartBlockRect.left;if(dropdownWidth>spaceToRight){const overflow=dropdownWidth-spaceToRight;const overflowRem=overflow/rootFontSize;dropdown.style.left=-overflowRem+'rem';}}}if(hoverEnabled){const cart=dropdown.closest('.cart-block');function showDropdown(){clearTimeout(hoverTimeout);if(!dropdown.classList.contains('show')){const bsCollapse=new bootstrap.Collapse(dropdown,{toggle:true});}}function hideDropdown(){hoverTimeout=setTimeout(function(){if(dropdown.classList.contains('show')){let bsCollapse=bootstrap.Collapse.getInstance(dropdown);if(!bsCollapse)bsCollapse=new bootstrap.Collapse(dropdown);bsCollapse.hide();}},150);}cart.addEventListener('mouseenter',showDropdown);cart.addEventListener('mouseleave',hideDropdown);}if(!dropdown.classList.contains('cart-block__dropdown--left')){adjustPosition();window.addEventListener('resize',adjustPosition);}});}};})(Drupal,drupalSettings);;
