<?php

namespace Drupal\commerce_promotion\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

class CouponForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  protected function prepareEntity() {
    if ($this->entity->isNew()) {
      $promotion = $this->getRouteMatch()->getParameter('commerce_promotion');
      $this->entity->set('promotion_id', $promotion);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $return_save = $this->entity->save();
    $this->messenger()->addMessage($this->t('Saved the %label coupon.', ['%label' => $this->entity->label()]));
    $form_state->setRedirectUrl($this->entity->toUrl('collection'));

    return $return_save;
  }

}
