<?php

/*
 * This file is part of the PHPExifTool package.
 *
 * (c) Alchemy <support@alchemy.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace PHPExiftool\Driver;

class TagProvider extends \Pimple
{

    public function __construct()
    {
        $this['AFCP'] = $this->share(function(){
            return array(
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\AFCP\ThumbnailImage(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\AFCP\PreviewImage(),
                'Text' => new \PHPExiftool\Driver\Tag\AFCP\Text(),
            );
        });
        $this['AIFF'] = $this->share(function(){
            return array(
                'CommentTime' => new \PHPExiftool\Driver\Tag\AIFF\CommentTime(),
                'MarkerID' => new \PHPExiftool\Driver\Tag\AIFF\MarkerID(),
                'Comment' => new \PHPExiftool\Driver\Tag\AIFF\Comment(),
                'NumChannels' => new \PHPExiftool\Driver\Tag\AIFF\NumChannels(),
                'NumSampleFrames' => new \PHPExiftool\Driver\Tag\AIFF\NumSampleFrames(),
                'SampleSize' => new \PHPExiftool\Driver\Tag\AIFF\SampleSize(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\AIFF\SampleRate(),
                'CompressionType' => new \PHPExiftool\Driver\Tag\AIFF\CompressionType(),
                'CompressorName' => new \PHPExiftool\Driver\Tag\AIFF\CompressorName(),
                'FormatVersionTime' => new \PHPExiftool\Driver\Tag\AIFF\FormatVersionTime(),
                'Copyright' => new \PHPExiftool\Driver\Tag\AIFF\Copyright(),
                'Annotation' => new \PHPExiftool\Driver\Tag\AIFF\Annotation(),
                'Author' => new \PHPExiftool\Driver\Tag\AIFF\Author(),
                'Name' => new \PHPExiftool\Driver\Tag\AIFF\Name(),
            );
        });
        $this['APE'] = $this->share(function(){
            return array(
                'Album' => new \PHPExiftool\Driver\Tag\APE\Album(),
                'Artist' => new \PHPExiftool\Driver\Tag\APE\Artist(),
                'Genre' => new \PHPExiftool\Driver\Tag\APE\Genre(),
                'Title' => new \PHPExiftool\Driver\Tag\APE\Title(),
                'ToolName' => new \PHPExiftool\Driver\Tag\APE\ToolName(),
                'ToolVersion' => new \PHPExiftool\Driver\Tag\APE\ToolVersion(),
                'Track' => new \PHPExiftool\Driver\Tag\APE\Track(),
                'Year' => new \PHPExiftool\Driver\Tag\APE\Year(),
            );
        });
        $this['MAC'] = $this->share(function(){
            return array(
                'CompressionLevel' => new \PHPExiftool\Driver\Tag\MAC\CompressionLevel(),
                'BlocksPerFrame' => new \PHPExiftool\Driver\Tag\MAC\BlocksPerFrame(),
                'FinalFrameBlocks' => new \PHPExiftool\Driver\Tag\MAC\FinalFrameBlocks(),
                'TotalFrames' => new \PHPExiftool\Driver\Tag\MAC\TotalFrames(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\MAC\BitsPerSample(),
                'Channels' => new \PHPExiftool\Driver\Tag\MAC\Channels(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\MAC\SampleRate(),
                'APEVersion' => new \PHPExiftool\Driver\Tag\MAC\APEVersion(),
            );
        });
        $this['Ducky'] = $this->share(function(){
            return array(
                'Quality' => new \PHPExiftool\Driver\Tag\Ducky\Quality(),
                'Comment' => new \PHPExiftool\Driver\Tag\Ducky\Comment(),
                'Copyright' => new \PHPExiftool\Driver\Tag\Ducky\Copyright(),
            );
        });
        $this['PictureInfo'] = $this->share(function(){
            return array(
                'Aperture' => new \PHPExiftool\Driver\Tag\PictureInfo\Aperture(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\PictureInfo\ColorMode(),
                'ConTake' => new \PHPExiftool\Driver\Tag\PictureInfo\ConTake(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\PictureInfo\ExposureCompensation(),
                'FNumber' => new \PHPExiftool\Driver\Tag\PictureInfo\FNumber(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\PictureInfo\FirmwareVersion(),
                'Flash' => new \PHPExiftool\Driver\Tag\PictureInfo\Flash(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\PictureInfo\FocusMode(),
                'FocusPos' => new \PHPExiftool\Driver\Tag\PictureInfo\FocusPos(),
                'ID' => new \PHPExiftool\Driver\Tag\PictureInfo\ID(),
                'ImageSize' => new \PHPExiftool\Driver\Tag\PictureInfo\ImageSize(),
                'LightS' => new \PHPExiftool\Driver\Tag\PictureInfo\LightS(),
                'Macro' => new \PHPExiftool\Driver\Tag\PictureInfo\Macro(),
                'Protect' => new \PHPExiftool\Driver\Tag\PictureInfo\Protect(),
                'Quality' => new \PHPExiftool\Driver\Tag\PictureInfo\Quality(),
                'Resolution' => new \PHPExiftool\Driver\Tag\PictureInfo\Resolution(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\PictureInfo\SerialNumber(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\PictureInfo\ExposureTime(),
                'StrobeTime' => new \PHPExiftool\Driver\Tag\PictureInfo\StrobeTime(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\PictureInfo\DateTimeOriginal(),
                'CameraType' => new \PHPExiftool\Driver\Tag\PictureInfo\CameraType(),
                'Version' => new \PHPExiftool\Driver\Tag\PictureInfo\Version(),
                'YTarget' => new \PHPExiftool\Driver\Tag\PictureInfo\YTarget(),
                'Zoom' => new \PHPExiftool\Driver\Tag\PictureInfo\Zoom(),
                'ZoomPos' => new \PHPExiftool\Driver\Tag\PictureInfo\ZoomPos(),
                'YLevel' => new \PHPExiftool\Driver\Tag\PictureInfo\YLevel(),
            );
        });
        $this['ASF'] = $this->share(function(){
            return array(
                'AudioCodecDescription' => new \PHPExiftool\Driver\Tag\ASF\AudioCodecDescription(),
                'AudioCodecName' => new \PHPExiftool\Driver\Tag\ASF\AudioCodecName(),
                'OtherCodecDescription' => new \PHPExiftool\Driver\Tag\ASF\OtherCodecDescription(),
                'OtherCodecName' => new \PHPExiftool\Driver\Tag\ASF\OtherCodecName(),
                'VideoCodecDescription' => new \PHPExiftool\Driver\Tag\ASF\VideoCodecDescription(),
                'VideoCodecName' => new \PHPExiftool\Driver\Tag\ASF\VideoCodecName(),
                'BannerImageType' => new \PHPExiftool\Driver\Tag\ASF\BannerImageType(),
                'BannerImage' => new \PHPExiftool\Driver\Tag\ASF\BannerImage(),
                'BannerImageURL' => new \PHPExiftool\Driver\Tag\ASF\BannerImageURL(),
                'CopyrightURL' => new \PHPExiftool\Driver\Tag\ASF\CopyrightURL(),
                'Title' => new \PHPExiftool\Driver\Tag\ASF\Title(),
                'Author' => new \PHPExiftool\Driver\Tag\ASF\Author(),
                'Copyright' => new \PHPExiftool\Driver\Tag\ASF\Copyright(),
                'Description' => new \PHPExiftool\Driver\Tag\ASF\Description(),
                'Rating' => new \PHPExiftool\Driver\Tag\ASF\Rating(),
                'ASFLeakyBucketPairs' => new \PHPExiftool\Driver\Tag\ASF\ASFLeakyBucketPairs(),
                'ASFPacketCount' => new \PHPExiftool\Driver\Tag\ASF\ASFPacketCount(),
                'ASFSecurityObjectsSize' => new \PHPExiftool\Driver\Tag\ASF\ASFSecurityObjectsSize(),
                'AlbumArtist' => new \PHPExiftool\Driver\Tag\ASF\AlbumArtist(),
                'AlbumCoverURL' => new \PHPExiftool\Driver\Tag\ASF\AlbumCoverURL(),
                'AlbumTitle' => new \PHPExiftool\Driver\Tag\ASF\AlbumTitle(),
                'AspectRatioX' => new \PHPExiftool\Driver\Tag\ASF\AspectRatioX(),
                'AspectRatioY' => new \PHPExiftool\Driver\Tag\ASF\AspectRatioY(),
                'AudioFileURL' => new \PHPExiftool\Driver\Tag\ASF\AudioFileURL(),
                'AudioSourceURL' => new \PHPExiftool\Driver\Tag\ASF\AudioSourceURL(),
                'AuthorURL' => new \PHPExiftool\Driver\Tag\ASF\AuthorURL(),
                'AverageLevel' => new \PHPExiftool\Driver\Tag\ASF\AverageLevel(),
                'BannerImageData' => new \PHPExiftool\Driver\Tag\ASF\BannerImageData(),
                'BeatsPerMinute' => new \PHPExiftool\Driver\Tag\ASF\BeatsPerMinute(),
                'Bitrate' => new \PHPExiftool\Driver\Tag\ASF\Bitrate(),
                'Broadcast' => new \PHPExiftool\Driver\Tag\ASF\Broadcast(),
                'BufferAverage' => new \PHPExiftool\Driver\Tag\ASF\BufferAverage(),
                'Can_Skip_Backward' => new \PHPExiftool\Driver\Tag\ASF\CanSkipBackward(),
                'Can_Skip_Forward' => new \PHPExiftool\Driver\Tag\ASF\CanSkipForward(),
                'Category' => new \PHPExiftool\Driver\Tag\ASF\Category(),
                'Codec' => new \PHPExiftool\Driver\Tag\ASF\Codec(),
                'Composer' => new \PHPExiftool\Driver\Tag\ASF\Composer(),
                'Conductor' => new \PHPExiftool\Driver\Tag\ASF\Conductor(),
                'ContainerFormat' => new \PHPExiftool\Driver\Tag\ASF\ContainerFormat(),
                'ContentDistributor' => new \PHPExiftool\Driver\Tag\ASF\ContentDistributor(),
                'ContentGroupDescription' => new \PHPExiftool\Driver\Tag\ASF\ContentGroupDescription(),
                'CurrentBitrate' => new \PHPExiftool\Driver\Tag\ASF\CurrentBitrate(),
                'DRM' => new \PHPExiftool\Driver\Tag\ASF\DRM(),
                'DRM_ContentID' => new \PHPExiftool\Driver\Tag\ASF\DRMContentID(),
                'DRM_DRMHeader' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeader(),
                'DRM_DRMHeader_ContentDistributor' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeaderContentDistributor(),
                'DRM_DRMHeader_ContentID' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeaderContentID(),
                'DRM_DRMHeader_IndividualizedVersion' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeaderIndividualizedVersion(),
                'DRM_DRMHeader_KeyID' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeaderKeyID(),
                'DRM_DRMHeader_LicenseAcqURL' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeaderLicenseAcqURL(),
                'DRM_DRMHeader_SubscriptionContentID' => new \PHPExiftool\Driver\Tag\ASF\DRMDRMHeaderSubscriptionContentID(),
                'DRM_IndividualizedVersion' => new \PHPExiftool\Driver\Tag\ASF\DRMIndividualizedVersion(),
                'DRM_KeyID' => new \PHPExiftool\Driver\Tag\ASF\DRMKeyID(),
                'DRM_LASignatureCert' => new \PHPExiftool\Driver\Tag\ASF\DRMLASignatureCert(),
                'DRM_LASignatureLicSrvCert' => new \PHPExiftool\Driver\Tag\ASF\DRMLASignatureLicSrvCert(),
                'DRM_LASignaturePrivKey' => new \PHPExiftool\Driver\Tag\ASF\DRMLASignaturePrivKey(),
                'DRM_LASignatureRootCert' => new \PHPExiftool\Driver\Tag\ASF\DRMLASignatureRootCert(),
                'DRM_LicenseAcqURL' => new \PHPExiftool\Driver\Tag\ASF\DRMLicenseAcqURL(),
                'DRM_V1LicenseAcqURL' => new \PHPExiftool\Driver\Tag\ASF\DRMV1LicenseAcqURL(),
                'DVDID' => new \PHPExiftool\Driver\Tag\ASF\DVDID(),
                'Director' => new \PHPExiftool\Driver\Tag\ASF\Director(),
                'Duration' => new \PHPExiftool\Driver\Tag\ASF\Duration(),
                'EncodedBy' => new \PHPExiftool\Driver\Tag\ASF\EncodedBy(),
                'EncodingSettings' => new \PHPExiftool\Driver\Tag\ASF\EncodingSettings(),
                'EncodingTime' => new \PHPExiftool\Driver\Tag\ASF\EncodingTime(),
                'FileSize' => new \PHPExiftool\Driver\Tag\ASF\FileSize(),
                'Genre' => new \PHPExiftool\Driver\Tag\ASF\Genre(),
                'GenreID' => new \PHPExiftool\Driver\Tag\ASF\GenreID(),
                'HasArbitraryDataStream' => new \PHPExiftool\Driver\Tag\ASF\HasArbitraryDataStream(),
                'HasAttachedImages' => new \PHPExiftool\Driver\Tag\ASF\HasAttachedImages(),
                'HasAudio' => new \PHPExiftool\Driver\Tag\ASF\HasAudio(),
                'HasFileTransferStream' => new \PHPExiftool\Driver\Tag\ASF\HasFileTransferStream(),
                'HasImage' => new \PHPExiftool\Driver\Tag\ASF\HasImage(),
                'HasScript' => new \PHPExiftool\Driver\Tag\ASF\HasScript(),
                'HasVideo' => new \PHPExiftool\Driver\Tag\ASF\HasVideo(),
                'ISRC' => new \PHPExiftool\Driver\Tag\ASF\ISRC(),
                'InitialKey' => new \PHPExiftool\Driver\Tag\ASF\InitialKey(),
                'IsVBR' => new \PHPExiftool\Driver\Tag\ASF\IsVBR(),
                'Is_Protected' => new \PHPExiftool\Driver\Tag\ASF\IsProtected(),
                'Is_Trusted' => new \PHPExiftool\Driver\Tag\ASF\IsTrusted(),
                'Language' => new \PHPExiftool\Driver\Tag\ASF\Language(),
                'Lyrics' => new \PHPExiftool\Driver\Tag\ASF\Lyrics(),
                'Lyrics_Synchronised' => new \PHPExiftool\Driver\Tag\ASF\LyricsSynchronised(),
                'MCDI' => new \PHPExiftool\Driver\Tag\ASF\MCDI(),
                'MediaClassPrimaryID' => new \PHPExiftool\Driver\Tag\ASF\MediaClassPrimaryID(),
                'MediaClassSecondaryID' => new \PHPExiftool\Driver\Tag\ASF\MediaClassSecondaryID(),
                'MediaCredits' => new \PHPExiftool\Driver\Tag\ASF\MediaCredits(),
                'MediaIsDelay' => new \PHPExiftool\Driver\Tag\ASF\MediaIsDelay(),
                'MediaIsFinale' => new \PHPExiftool\Driver\Tag\ASF\MediaIsFinale(),
                'MediaIsLive' => new \PHPExiftool\Driver\Tag\ASF\MediaIsLive(),
                'MediaIsPremiere' => new \PHPExiftool\Driver\Tag\ASF\MediaIsPremiere(),
                'MediaIsRepeat' => new \PHPExiftool\Driver\Tag\ASF\MediaIsRepeat(),
                'MediaIsSAP' => new \PHPExiftool\Driver\Tag\ASF\MediaIsSAP(),
                'MediaIsStereo' => new \PHPExiftool\Driver\Tag\ASF\MediaIsStereo(),
                'MediaIsSubtitled' => new \PHPExiftool\Driver\Tag\ASF\MediaIsSubtitled(),
                'MediaIsTape' => new \PHPExiftool\Driver\Tag\ASF\MediaIsTape(),
                'MediaNetworkAffiliation' => new \PHPExiftool\Driver\Tag\ASF\MediaNetworkAffiliation(),
                'MediaOriginalBroadcastDateTime' => new \PHPExiftool\Driver\Tag\ASF\MediaOriginalBroadcastDateTime(),
                'MediaOriginalChannel' => new \PHPExiftool\Driver\Tag\ASF\MediaOriginalChannel(),
                'MediaStationCallSign' => new \PHPExiftool\Driver\Tag\ASF\MediaStationCallSign(),
                'MediaStationName' => new \PHPExiftool\Driver\Tag\ASF\MediaStationName(),
                'ModifiedBy' => new \PHPExiftool\Driver\Tag\ASF\ModifiedBy(),
                'Mood' => new \PHPExiftool\Driver\Tag\ASF\Mood(),
                'NSC_Address' => new \PHPExiftool\Driver\Tag\ASF\NSCAddress(),
                'NSC_Description' => new \PHPExiftool\Driver\Tag\ASF\NSCDescription(),
                'NSC_Email' => new \PHPExiftool\Driver\Tag\ASF\NSCEmail(),
                'NSC_Name' => new \PHPExiftool\Driver\Tag\ASF\NSCName(),
                'NSC_Phone' => new \PHPExiftool\Driver\Tag\ASF\NSCPhone(),
                'NumberOfFrames' => new \PHPExiftool\Driver\Tag\ASF\NumberOfFrames(),
                'OptimalBitrate' => new \PHPExiftool\Driver\Tag\ASF\OptimalBitrate(),
                'OriginalAlbumTitle' => new \PHPExiftool\Driver\Tag\ASF\OriginalAlbumTitle(),
                'OriginalArtist' => new \PHPExiftool\Driver\Tag\ASF\OriginalArtist(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\ASF\OriginalFileName(),
                'OriginalLyricist' => new \PHPExiftool\Driver\Tag\ASF\OriginalLyricist(),
                'OriginalReleaseTime' => new \PHPExiftool\Driver\Tag\ASF\OriginalReleaseTime(),
                'OriginalReleaseYear' => new \PHPExiftool\Driver\Tag\ASF\OriginalReleaseYear(),
                'ParentalRating' => new \PHPExiftool\Driver\Tag\ASF\ParentalRating(),
                'ParentalRatingReason' => new \PHPExiftool\Driver\Tag\ASF\ParentalRatingReason(),
                'PartOfSet' => new \PHPExiftool\Driver\Tag\ASF\PartOfSet(),
                'PeakBitrate' => new \PHPExiftool\Driver\Tag\ASF\PeakBitrate(),
                'PeakValue' => new \PHPExiftool\Driver\Tag\ASF\PeakValue(),
                'Period' => new \PHPExiftool\Driver\Tag\ASF\Period(),
                'PlaylistDelay' => new \PHPExiftool\Driver\Tag\ASF\PlaylistDelay(),
                'Producer' => new \PHPExiftool\Driver\Tag\ASF\Producer(),
                'PromotionURL' => new \PHPExiftool\Driver\Tag\ASF\PromotionURL(),
                'ProtectionType' => new \PHPExiftool\Driver\Tag\ASF\ProtectionType(),
                'Provider' => new \PHPExiftool\Driver\Tag\ASF\Provider(),
                'ProviderCopyright' => new \PHPExiftool\Driver\Tag\ASF\ProviderCopyright(),
                'ProviderRating' => new \PHPExiftool\Driver\Tag\ASF\ProviderRating(),
                'ProviderStyle' => new \PHPExiftool\Driver\Tag\ASF\ProviderStyle(),
                'Publisher' => new \PHPExiftool\Driver\Tag\ASF\Publisher(),
                'RadioStationName' => new \PHPExiftool\Driver\Tag\ASF\RadioStationName(),
                'RadioStationOwner' => new \PHPExiftool\Driver\Tag\ASF\RadioStationOwner(),
                'Seekable' => new \PHPExiftool\Driver\Tag\ASF\Seekable(),
                'SharedUserRating' => new \PHPExiftool\Driver\Tag\ASF\SharedUserRating(),
                'Signature_Name' => new \PHPExiftool\Driver\Tag\ASF\SignatureName(),
                'StreamTypeInfo' => new \PHPExiftool\Driver\Tag\ASF\StreamTypeInfo(),
                'Stridable' => new \PHPExiftool\Driver\Tag\ASF\Stridable(),
                'Subtitle' => new \PHPExiftool\Driver\Tag\ASF\Subtitle(),
                'SubtitleDescription' => new \PHPExiftool\Driver\Tag\ASF\SubtitleDescription(),
                'SubscriptionContentID' => new \PHPExiftool\Driver\Tag\ASF\SubscriptionContentID(),
                'Text' => new \PHPExiftool\Driver\Tag\ASF\Text(),
                'ToolName' => new \PHPExiftool\Driver\Tag\ASF\ToolName(),
                'ToolVersion' => new \PHPExiftool\Driver\Tag\ASF\ToolVersion(),
                'Track' => new \PHPExiftool\Driver\Tag\ASF\Track(),
                'TrackNumber' => new \PHPExiftool\Driver\Tag\ASF\TrackNumber(),
                'UniqueFileIdentifier' => new \PHPExiftool\Driver\Tag\ASF\UniqueFileIdentifier(),
                'UserWebURL' => new \PHPExiftool\Driver\Tag\ASF\UserWebURL(),
                'VBRPeak' => new \PHPExiftool\Driver\Tag\ASF\VBRPeak(),
                'VideoClosedCaptioning' => new \PHPExiftool\Driver\Tag\ASF\VideoClosedCaptioning(),
                'VideoFrameRate' => new \PHPExiftool\Driver\Tag\ASF\VideoFrameRate(),
                'VideoHeight' => new \PHPExiftool\Driver\Tag\ASF\VideoHeight(),
                'VideoWidth' => new \PHPExiftool\Driver\Tag\ASF\VideoWidth(),
                'WMADRCAverageReference' => new \PHPExiftool\Driver\Tag\ASF\WMADRCAverageReference(),
                'WMADRCAverageTarget' => new \PHPExiftool\Driver\Tag\ASF\WMADRCAverageTarget(),
                'WMADRCPeakReference' => new \PHPExiftool\Driver\Tag\ASF\WMADRCPeakReference(),
                'WMADRCPeakTarget' => new \PHPExiftool\Driver\Tag\ASF\WMADRCPeakTarget(),
                'WMCollectionGroupID' => new \PHPExiftool\Driver\Tag\ASF\WMCollectionGroupID(),
                'WMCollectionID' => new \PHPExiftool\Driver\Tag\ASF\WMCollectionID(),
                'WMContentID' => new \PHPExiftool\Driver\Tag\ASF\WMContentID(),
                'Writer' => new \PHPExiftool\Driver\Tag\ASF\Writer(),
                'Year' => new \PHPExiftool\Driver\Tag\ASF\Year(),
                'FileID' => new \PHPExiftool\Driver\Tag\ASF\FileID(),
                'FileLength' => new \PHPExiftool\Driver\Tag\ASF\FileLength(),
                'CreationDate' => new \PHPExiftool\Driver\Tag\ASF\CreationDate(),
                'DataPackets' => new \PHPExiftool\Driver\Tag\ASF\DataPackets(),
                'PlayDuration' => new \PHPExiftool\Driver\Tag\ASF\PlayDuration(),
                'SendDuration' => new \PHPExiftool\Driver\Tag\ASF\SendDuration(),
                'Preroll' => new \PHPExiftool\Driver\Tag\ASF\Preroll(),
                'Flags' => new \PHPExiftool\Driver\Tag\ASF\Flags(),
                'MinPacketSize' => new \PHPExiftool\Driver\Tag\ASF\MinPacketSize(),
                'MaxPacketSize' => new \PHPExiftool\Driver\Tag\ASF\MaxPacketSize(),
                'MaxBitrate' => new \PHPExiftool\Driver\Tag\ASF\MaxBitrate(),
                'Padding' => new \PHPExiftool\Driver\Tag\ASF\Padding(),
                'ScriptCommand' => new \PHPExiftool\Driver\Tag\ASF\ScriptCommand(),
                'ContentEncryption' => new \PHPExiftool\Driver\Tag\ASF\ContentEncryption(),
                'DigitalSignature' => new \PHPExiftool\Driver\Tag\ASF\DigitalSignature(),
                'ExtendedContentEncryption' => new \PHPExiftool\Driver\Tag\ASF\ExtendedContentEncryption(),
                'ErrorCorrection' => new \PHPExiftool\Driver\Tag\ASF\ErrorCorrection(),
                'StreamBitrateProps' => new \PHPExiftool\Driver\Tag\ASF\StreamBitrateProps(),
                'BitrateMutualExclusion' => new \PHPExiftool\Driver\Tag\ASF\BitrateMutualExclusion(),
                'Marker' => new \PHPExiftool\Driver\Tag\ASF\Marker(),
                'ExtendedStreamProps' => new \PHPExiftool\Driver\Tag\ASF\ExtendedStreamProps(),
                'AdvancedContentEncryption' => new \PHPExiftool\Driver\Tag\ASF\AdvancedContentEncryption(),
                'TimecodeIndexParms' => new \PHPExiftool\Driver\Tag\ASF\TimecodeIndexParms(),
                'Compatibility' => new \PHPExiftool\Driver\Tag\ASF\Compatibility(),
                'LanguageList' => new \PHPExiftool\Driver\Tag\ASF\LanguageList(),
                'AdvancedMutualExcl' => new \PHPExiftool\Driver\Tag\ASF\AdvancedMutualExcl(),
                'BandwidthSharing' => new \PHPExiftool\Driver\Tag\ASF\BandwidthSharing(),
                'Reserved1' => new \PHPExiftool\Driver\Tag\ASF\Reserved1(),
                'GroupMutualExclusion' => new \PHPExiftool\Driver\Tag\ASF\GroupMutualExclusion(),
                'StreamPrioritization' => new \PHPExiftool\Driver\Tag\ASF\StreamPrioritization(),
                'IndexParameters' => new \PHPExiftool\Driver\Tag\ASF\IndexParameters(),
                'SimpleIndex' => new \PHPExiftool\Driver\Tag\ASF\SimpleIndex(),
                'TimecodeIndex' => new \PHPExiftool\Driver\Tag\ASF\TimecodeIndex(),
                'Data' => new \PHPExiftool\Driver\Tag\ASF\Data(),
                'Index' => new \PHPExiftool\Driver\Tag\ASF\Index(),
                'MediaIndex' => new \PHPExiftool\Driver\Tag\ASF\MediaIndex(),
                'PictureType' => new \PHPExiftool\Driver\Tag\ASF\PictureType(),
                'PictureMIMEType' => new \PHPExiftool\Driver\Tag\ASF\PictureMIMEType(),
                'PictureDescription' => new \PHPExiftool\Driver\Tag\ASF\PictureDescription(),
                'Picture' => new \PHPExiftool\Driver\Tag\ASF\Picture(),
                'StreamType' => new \PHPExiftool\Driver\Tag\ASF\StreamType(),
                'ErrorCorrectionType' => new \PHPExiftool\Driver\Tag\ASF\ErrorCorrectionType(),
                'TimeOffset' => new \PHPExiftool\Driver\Tag\ASF\TimeOffset(),
                'StreamNumber' => new \PHPExiftool\Driver\Tag\ASF\StreamNumber(),
                'AudioCodecID' => new \PHPExiftool\Driver\Tag\ASF\AudioCodecID(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\ASF\ImageWidth(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\ASF\AudioChannels(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\ASF\AudioSampleRate(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\ASF\ImageHeight(),
            );
        });
        $this['Apple'] = $this->share(function(){
            return array(
                'HDRImageType' => new \PHPExiftool\Driver\Tag\Apple\HDRImageType(),
                'BurstUUID' => new \PHPExiftool\Driver\Tag\Apple\BurstUUID(),
                'RunTimeEpoch' => new \PHPExiftool\Driver\Tag\Apple\RunTimeEpoch(),
                'RunTimeFlags' => new \PHPExiftool\Driver\Tag\Apple\RunTimeFlags(),
                'RunTimeScale' => new \PHPExiftool\Driver\Tag\Apple\RunTimeScale(),
                'RunTimeValue' => new \PHPExiftool\Driver\Tag\Apple\RunTimeValue(),
            );
        });
        $this['Audible'] = $this->share(function(){
            return array(
                'ChapterCount' => new \PHPExiftool\Driver\Tag\Audible\ChapterCount(),
                'CoverArt' => new \PHPExiftool\Driver\Tag\Audible\CoverArt(),
                'Author' => new \PHPExiftool\Driver\Tag\Audible\Author(),
                'Copyright' => new \PHPExiftool\Driver\Tag\Audible\Copyright(),
                'PublishDateStart' => new \PHPExiftool\Driver\Tag\Audible\PublishDateStart(),
                'PublishDate' => new \PHPExiftool\Driver\Tag\Audible\PublishDate(),
                'CoverArtType' => new \PHPExiftool\Driver\Tag\Audible\CoverArtType(),
                'AlbumArtist' => new \PHPExiftool\Driver\Tag\Audible\AlbumArtist(),
                'Album' => new \PHPExiftool\Driver\Tag\Audible\Album(),
                'Artist' => new \PHPExiftool\Driver\Tag\Audible\Artist(),
                'Comment' => new \PHPExiftool\Driver\Tag\Audible\Comment(),
                'Genre' => new \PHPExiftool\Driver\Tag\Audible\Genre(),
                'Subtitle' => new \PHPExiftool\Driver\Tag\Audible\Subtitle(),
                'CreatorTool' => new \PHPExiftool\Driver\Tag\Audible\CreatorTool(),
                'Title' => new \PHPExiftool\Driver\Tag\Audible\Title(),
                'Year' => new \PHPExiftool\Driver\Tag\Audible\Year(),
                'iTunesMediaType' => new \PHPExiftool\Driver\Tag\Audible\ITunesMediaType(),
                'ChapterName' => new \PHPExiftool\Driver\Tag\Audible\ChapterName(),
                'ChapterNumber' => new \PHPExiftool\Driver\Tag\Audible\ChapterNumber(),
            );
        });
        $this['File'] = $this->share(function(){
            return array(
                'ImageWidth' => new \PHPExiftool\Driver\Tag\File\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\File\ImageHeight(),
                'Planes' => new \PHPExiftool\Driver\Tag\File\Planes(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\File\BitDepth(),
                'Compression' => new \PHPExiftool\Driver\Tag\File\Compression(),
                'ImageLength' => new \PHPExiftool\Driver\Tag\File\ImageLength(),
                'PixelsPerMeterX' => new \PHPExiftool\Driver\Tag\File\PixelsPerMeterX(),
                'PixelsPerMeterY' => new \PHPExiftool\Driver\Tag\File\PixelsPerMeterY(),
                'NumColors' => new \PHPExiftool\Driver\Tag\File\NumColors(),
                'NumImportantColors' => new \PHPExiftool\Driver\Tag\File\NumImportantColors(),
                'ByteOrder' => new \PHPExiftool\Driver\Tag\File\ByteOrder(),
                'HeaderVersion' => new \PHPExiftool\Driver\Tag\File\HeaderVersion(),
                'DPXFileSize' => new \PHPExiftool\Driver\Tag\File\DPXFileSize(),
                'DittoKey' => new \PHPExiftool\Driver\Tag\File\DittoKey(),
                'ImageFileName' => new \PHPExiftool\Driver\Tag\File\ImageFileName(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\File\CreateDate(),
                'Creator' => new \PHPExiftool\Driver\Tag\File\Creator(),
                'Project' => new \PHPExiftool\Driver\Tag\File\Project(),
                'Copyright' => new \PHPExiftool\Driver\Tag\File\Copyright(),
                'EncryptionKey' => new \PHPExiftool\Driver\Tag\File\EncryptionKey(),
                'Orientation' => new \PHPExiftool\Driver\Tag\File\Orientation(),
                'ImageElements' => new \PHPExiftool\Driver\Tag\File\ImageElements(),
                'DataSign' => new \PHPExiftool\Driver\Tag\File\DataSign(),
                'ComponentsConfiguration' => new \PHPExiftool\Driver\Tag\File\ComponentsConfiguration(),
                'ImageDescription' => new \PHPExiftool\Driver\Tag\File\ImageDescription(),
                'Image2Description' => new \PHPExiftool\Driver\Tag\File\Image2Description(),
                'Image3Description' => new \PHPExiftool\Driver\Tag\File\Image3Description(),
                'Image4Description' => new \PHPExiftool\Driver\Tag\File\Image4Description(),
                'Image5Description' => new \PHPExiftool\Driver\Tag\File\Image5Description(),
                'Image6Description' => new \PHPExiftool\Driver\Tag\File\Image6Description(),
                'Image7Description' => new \PHPExiftool\Driver\Tag\File\Image7Description(),
                'Image8Description' => new \PHPExiftool\Driver\Tag\File\Image8Description(),
                'SourceFileName' => new \PHPExiftool\Driver\Tag\File\SourceFileName(),
                'SourceCreateDate' => new \PHPExiftool\Driver\Tag\File\SourceCreateDate(),
                'InputDeviceName' => new \PHPExiftool\Driver\Tag\File\InputDeviceName(),
                'InputDeviceSerialNumber' => new \PHPExiftool\Driver\Tag\File\InputDeviceSerialNumber(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\File\FrameRate(),
                'FrameID' => new \PHPExiftool\Driver\Tag\File\FrameID(),
                'SlateInformation' => new \PHPExiftool\Driver\Tag\File\SlateInformation(),
                'UserID' => new \PHPExiftool\Driver\Tag\File\UserID(),
                'Comment' => new \PHPExiftool\Driver\Tag\File\Comment(),
                'CurrentIPTCDigest' => new \PHPExiftool\Driver\Tag\File\CurrentIPTCDigest(),
                'ExifByteOrder' => new \PHPExiftool\Driver\Tag\File\ExifByteOrder(),
                'ExifUnicodeByteOrder' => new \PHPExiftool\Driver\Tag\File\ExifUnicodeByteOrder(),
                'FileType' => new \PHPExiftool\Driver\Tag\File\FileType(),
                'FileTypeExtension' => new \PHPExiftool\Driver\Tag\File\FileTypeExtension(),
                'Geosync' => new \PHPExiftool\Driver\Tag\File\Geosync(),
                'Geotag' => new \PHPExiftool\Driver\Tag\File\Geotag(),
                'Geotime' => new \PHPExiftool\Driver\Tag\File\Geotime(),
                'HardLink' => new \PHPExiftool\Driver\Tag\File\HardLink(),
                'ID3Size' => new \PHPExiftool\Driver\Tag\File\ID3Size(),
                'JPEGDigest' => new \PHPExiftool\Driver\Tag\File\JPEGDigest(),
                'JPEGQualityEstimate' => new \PHPExiftool\Driver\Tag\File\JPEGQualityEstimate(),
                'MIMEType' => new \PHPExiftool\Driver\Tag\File\MIMEType(),
                'MaxVal' => new \PHPExiftool\Driver\Tag\File\MaxVal(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\File\PreviewImage(),
                'PreviewPNG' => new \PHPExiftool\Driver\Tag\File\PreviewPNG(),
                'PreviewWMF' => new \PHPExiftool\Driver\Tag\File\PreviewWMF(),
                'RAFVersion' => new \PHPExiftool\Driver\Tag\File\RAFVersion(),
                'TestName' => new \PHPExiftool\Driver\Tag\File\TestName(),
                'XResolution' => new \PHPExiftool\Driver\Tag\File\XResolution(),
                'YResolution' => new \PHPExiftool\Driver\Tag\File\YResolution(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\File\BitsPerSample(),
                'ColorComponents' => new \PHPExiftool\Driver\Tag\File\ColorComponents(),
                'EncodingProcess' => new \PHPExiftool\Driver\Tag\File\EncodingProcess(),
                'YCbCrSubSampling' => new \PHPExiftool\Driver\Tag\File\YCbCrSubSampling(),
                'PGFVersion' => new \PHPExiftool\Driver\Tag\File\PGFVersion(),
                'PyramidLevels' => new \PHPExiftool\Driver\Tag\File\PyramidLevels(),
                'Quality' => new \PHPExiftool\Driver\Tag\File\Quality(),
                'BitsPerPixel' => new \PHPExiftool\Driver\Tag\File\BitsPerPixel(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\File\ColorMode(),
                'BackgroundColor' => new \PHPExiftool\Driver\Tag\File\BackgroundColor(),
            );
        });
        $this['Canon'] = $this->share(function(){
            return array(
                'AFConfigTool' => new \PHPExiftool\Driver\Tag\Canon\AFConfigTool(),
                'AFTrackingSensitivity' => new \PHPExiftool\Driver\Tag\Canon\AFTrackingSensitivity(),
                'AFAccelDecelTracking' => new \PHPExiftool\Driver\Tag\Canon\AFAccelDecelTracking(),
                'AFPointSwitching' => new \PHPExiftool\Driver\Tag\Canon\AFPointSwitching(),
                'NumAFPoints' => new \PHPExiftool\Driver\Tag\Canon\NumAFPoints(),
                'ValidAFPoints' => new \PHPExiftool\Driver\Tag\Canon\ValidAFPoints(),
                'CanonImageWidth' => new \PHPExiftool\Driver\Tag\Canon\CanonImageWidth(),
                'CanonImageHeight' => new \PHPExiftool\Driver\Tag\Canon\CanonImageHeight(),
                'AFImageWidth' => new \PHPExiftool\Driver\Tag\Canon\AFImageWidth(),
                'AFImageHeight' => new \PHPExiftool\Driver\Tag\Canon\AFImageHeight(),
                'AFAreaWidth' => new \PHPExiftool\Driver\Tag\Canon\AFAreaWidth(),
                'AFAreaHeight' => new \PHPExiftool\Driver\Tag\Canon\AFAreaHeight(),
                'AFAreaXPositions' => new \PHPExiftool\Driver\Tag\Canon\AFAreaXPositions(),
                'AFAreaYPositions' => new \PHPExiftool\Driver\Tag\Canon\AFAreaYPositions(),
                'AFPointsInFocus' => new \PHPExiftool\Driver\Tag\Canon\AFPointsInFocus(),
                'PrimaryAFPoint' => new \PHPExiftool\Driver\Tag\Canon\PrimaryAFPoint(),
                'Canon_AFInfo_0x000b' => new \PHPExiftool\Driver\Tag\Canon\CanonAFInfo0x000b(),
                'AFInfoSize' => new \PHPExiftool\Driver\Tag\Canon\AFInfoSize(),
                'AFAreaMode' => new \PHPExiftool\Driver\Tag\Canon\AFAreaMode(),
                'AFAreaWidths' => new \PHPExiftool\Driver\Tag\Canon\AFAreaWidths(),
                'AFAreaHeights' => new \PHPExiftool\Driver\Tag\Canon\AFAreaHeights(),
                'AFPointsSelected' => new \PHPExiftool\Driver\Tag\Canon\AFPointsSelected(),
                'Canon_AFInfo2_0x000d' => new \PHPExiftool\Driver\Tag\Canon\CanonAFInfo20x000d(),
                'AFMicroAdjMode' => new \PHPExiftool\Driver\Tag\Canon\AFMicroAdjMode(),
                'AFMicroAdjValue' => new \PHPExiftool\Driver\Tag\Canon\AFMicroAdjValue(),
                'AmbienceSelection' => new \PHPExiftool\Driver\Tag\Canon\AmbienceSelection(),
                'AspectRatio' => new \PHPExiftool\Driver\Tag\Canon\AspectRatio(),
                'CroppedImageWidth' => new \PHPExiftool\Driver\Tag\Canon\CroppedImageWidth(),
                'CroppedImageHeight' => new \PHPExiftool\Driver\Tag\Canon\CroppedImageHeight(),
                'CroppedImageLeft' => new \PHPExiftool\Driver\Tag\Canon\CroppedImageLeft(),
                'CroppedImageTop' => new \PHPExiftool\Driver\Tag\Canon\CroppedImageTop(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\Canon\ThumbnailImage(),
                'FNumber' => new \PHPExiftool\Driver\Tag\Canon\FNumber(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\Canon\ExposureTime(),
                'ISO' => new \PHPExiftool\Driver\Tag\Canon\ISO(),
                'FlashMeteringMode' => new \PHPExiftool\Driver\Tag\Canon\FlashMeteringMode(),
                'CameraTemperature' => new \PHPExiftool\Driver\Tag\Canon\CameraTemperature(),
                'MacroMagnification' => new \PHPExiftool\Driver\Tag\Canon\MacroMagnification(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Canon\FocalLength(),
                'CameraOrientation' => new \PHPExiftool\Driver\Tag\Canon\CameraOrientation(),
                'FocusDistanceUpper' => new \PHPExiftool\Driver\Tag\Canon\FocusDistanceUpper(),
                'FocusDistanceLower' => new \PHPExiftool\Driver\Tag\Canon\FocusDistanceLower(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\Canon\WhiteBalance(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\Canon\ColorTemperature(),
                'LensType' => new \PHPExiftool\Driver\Tag\Canon\LensType(),
                'MinFocalLength' => new \PHPExiftool\Driver\Tag\Canon\MinFocalLength(),
                'MaxFocalLength' => new \PHPExiftool\Driver\Tag\Canon\MaxFocalLength(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\Canon\FirmwareVersion(),
                'DirectoryIndex' => new \PHPExiftool\Driver\Tag\Canon\DirectoryIndex(),
                'FileIndex' => new \PHPExiftool\Driver\Tag\Canon\FileIndex(),
                'LensModel' => new \PHPExiftool\Driver\Tag\Canon\LensModel(),
                'SharpnessFrequency' => new \PHPExiftool\Driver\Tag\Canon\SharpnessFrequency(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\Canon\Sharpness(),
                'PictureStyle' => new \PHPExiftool\Driver\Tag\Canon\PictureStyle(),
                'FirmwareVersionLookAhead' => new \PHPExiftool\Driver\Tag\Canon\FirmwareVersionLookAhead(),
                'FocalType' => new \PHPExiftool\Driver\Tag\Canon\FocalType(),
                'CanonImageSize' => new \PHPExiftool\Driver\Tag\Canon\CanonImageSize(),
                'JPEGQuality' => new \PHPExiftool\Driver\Tag\Canon\JPEGQuality(),
                'Saturation' => new \PHPExiftool\Driver\Tag\Canon\Saturation(),
                'ColorTone' => new \PHPExiftool\Driver\Tag\Canon\ColorTone(),
                'Contrast' => new \PHPExiftool\Driver\Tag\Canon\Contrast(),
                'ShutterCount' => new \PHPExiftool\Driver\Tag\Canon\ShutterCount(),
                'TimeStamp1' => new \PHPExiftool\Driver\Tag\Canon\TimeStamp1(),
                'TimeStamp' => new \PHPExiftool\Driver\Tag\Canon\TimeStamp(),
                'HighlightTonePriority' => new \PHPExiftool\Driver\Tag\Canon\HighlightTonePriority(),
                'MeasuredEV2' => new \PHPExiftool\Driver\Tag\Canon\MeasuredEV2(),
                'MeasuredEV3' => new \PHPExiftool\Driver\Tag\Canon\MeasuredEV3(),
                'OwnerName' => new \PHPExiftool\Driver\Tag\Canon\OwnerName(),
                'HighISONoiseReduction' => new \PHPExiftool\Driver\Tag\Canon\HighISONoiseReduction(),
                'AutoLightingOptimizer' => new \PHPExiftool\Driver\Tag\Canon\AutoLightingOptimizer(),
                'AFPointsInFocus5D' => new \PHPExiftool\Driver\Tag\Canon\AFPointsInFocus5D(),
                'FirmwareRevision' => new \PHPExiftool\Driver\Tag\Canon\FirmwareRevision(),
                'ShortOwnerName' => new \PHPExiftool\Driver\Tag\Canon\ShortOwnerName(),
                'ContrastStandard' => new \PHPExiftool\Driver\Tag\Canon\ContrastStandard(),
                'ContrastPortrait' => new \PHPExiftool\Driver\Tag\Canon\ContrastPortrait(),
                'ContrastLandscape' => new \PHPExiftool\Driver\Tag\Canon\ContrastLandscape(),
                'ContrastNeutral' => new \PHPExiftool\Driver\Tag\Canon\ContrastNeutral(),
                'ContrastFaithful' => new \PHPExiftool\Driver\Tag\Canon\ContrastFaithful(),
                'ContrastMonochrome' => new \PHPExiftool\Driver\Tag\Canon\ContrastMonochrome(),
                'ContrastUserDef1' => new \PHPExiftool\Driver\Tag\Canon\ContrastUserDef1(),
                'ContrastUserDef2' => new \PHPExiftool\Driver\Tag\Canon\ContrastUserDef2(),
                'ContrastUserDef3' => new \PHPExiftool\Driver\Tag\Canon\ContrastUserDef3(),
                'SharpnessStandard' => new \PHPExiftool\Driver\Tag\Canon\SharpnessStandard(),
                'SharpnessPortrait' => new \PHPExiftool\Driver\Tag\Canon\SharpnessPortrait(),
                'SharpnessLandscape' => new \PHPExiftool\Driver\Tag\Canon\SharpnessLandscape(),
                'SharpnessNeutral' => new \PHPExiftool\Driver\Tag\Canon\SharpnessNeutral(),
                'SharpnessFaithful' => new \PHPExiftool\Driver\Tag\Canon\SharpnessFaithful(),
                'SharpnessMonochrome' => new \PHPExiftool\Driver\Tag\Canon\SharpnessMonochrome(),
                'SharpnessUserDef1' => new \PHPExiftool\Driver\Tag\Canon\SharpnessUserDef1(),
                'SharpnessUserDef2' => new \PHPExiftool\Driver\Tag\Canon\SharpnessUserDef2(),
                'SharpnessUserDef3' => new \PHPExiftool\Driver\Tag\Canon\SharpnessUserDef3(),
                'SaturationStandard' => new \PHPExiftool\Driver\Tag\Canon\SaturationStandard(),
                'SaturationPortrait' => new \PHPExiftool\Driver\Tag\Canon\SaturationPortrait(),
                'SaturationLandscape' => new \PHPExiftool\Driver\Tag\Canon\SaturationLandscape(),
                'SaturationNeutral' => new \PHPExiftool\Driver\Tag\Canon\SaturationNeutral(),
                'SaturationFaithful' => new \PHPExiftool\Driver\Tag\Canon\SaturationFaithful(),
                'FilterEffectMonochrome' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectMonochrome(),
                'SaturationUserDef1' => new \PHPExiftool\Driver\Tag\Canon\SaturationUserDef1(),
                'SaturationUserDef2' => new \PHPExiftool\Driver\Tag\Canon\SaturationUserDef2(),
                'SaturationUserDef3' => new \PHPExiftool\Driver\Tag\Canon\SaturationUserDef3(),
                'ColorToneStandard' => new \PHPExiftool\Driver\Tag\Canon\ColorToneStandard(),
                'ColorTonePortrait' => new \PHPExiftool\Driver\Tag\Canon\ColorTonePortrait(),
                'ColorToneLandscape' => new \PHPExiftool\Driver\Tag\Canon\ColorToneLandscape(),
                'ColorToneNeutral' => new \PHPExiftool\Driver\Tag\Canon\ColorToneNeutral(),
                'ColorToneFaithful' => new \PHPExiftool\Driver\Tag\Canon\ColorToneFaithful(),
                'ToningEffectMonochrome' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectMonochrome(),
                'ColorToneUserDef1' => new \PHPExiftool\Driver\Tag\Canon\ColorToneUserDef1(),
                'ColorToneUserDef2' => new \PHPExiftool\Driver\Tag\Canon\ColorToneUserDef2(),
                'ColorToneUserDef3' => new \PHPExiftool\Driver\Tag\Canon\ColorToneUserDef3(),
                'UserDef1PictureStyle' => new \PHPExiftool\Driver\Tag\Canon\UserDef1PictureStyle(),
                'UserDef2PictureStyle' => new \PHPExiftool\Driver\Tag\Canon\UserDef2PictureStyle(),
                'UserDef3PictureStyle' => new \PHPExiftool\Driver\Tag\Canon\UserDef3PictureStyle(),
                'LensSerialNumber' => new \PHPExiftool\Driver\Tag\Canon\LensSerialNumber(),
                'FileIndex2' => new \PHPExiftool\Driver\Tag\Canon\FileIndex2(),
                'DirectoryIndex2' => new \PHPExiftool\Driver\Tag\Canon\DirectoryIndex2(),
                'MeasuredEV' => new \PHPExiftool\Driver\Tag\Canon\MeasuredEV(),
                'Rotation' => new \PHPExiftool\Driver\Tag\Canon\Rotation(),
                'MacroMode' => new \PHPExiftool\Driver\Tag\Canon\MacroMode(),
                'SelfTimer' => new \PHPExiftool\Driver\Tag\Canon\SelfTimer(),
                'Quality' => new \PHPExiftool\Driver\Tag\Canon\Quality(),
                'CanonFlashMode' => new \PHPExiftool\Driver\Tag\Canon\CanonFlashMode(),
                'ContinuousDrive' => new \PHPExiftool\Driver\Tag\Canon\ContinuousDrive(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\Canon\FocusMode(),
                'RecordMode' => new \PHPExiftool\Driver\Tag\Canon\RecordMode(),
                'EasyMode' => new \PHPExiftool\Driver\Tag\Canon\EasyMode(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\Canon\DigitalZoom(),
                'CameraISO' => new \PHPExiftool\Driver\Tag\Canon\CameraISO(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\Canon\MeteringMode(),
                'FocusRange' => new \PHPExiftool\Driver\Tag\Canon\FocusRange(),
                'AFPoint' => new \PHPExiftool\Driver\Tag\Canon\AFPoint(),
                'CanonExposureMode' => new \PHPExiftool\Driver\Tag\Canon\CanonExposureMode(),
                'FocalUnits' => new \PHPExiftool\Driver\Tag\Canon\FocalUnits(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\Canon\MaxAperture(),
                'MinAperture' => new \PHPExiftool\Driver\Tag\Canon\MinAperture(),
                'FlashActivity' => new \PHPExiftool\Driver\Tag\Canon\FlashActivity(),
                'FlashBits' => new \PHPExiftool\Driver\Tag\Canon\FlashBits(),
                'FocusContinuous' => new \PHPExiftool\Driver\Tag\Canon\FocusContinuous(),
                'AESetting' => new \PHPExiftool\Driver\Tag\Canon\AESetting(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\Canon\ImageStabilization(),
                'DisplayAperture' => new \PHPExiftool\Driver\Tag\Canon\DisplayAperture(),
                'ZoomSourceWidth' => new \PHPExiftool\Driver\Tag\Canon\ZoomSourceWidth(),
                'ZoomTargetWidth' => new \PHPExiftool\Driver\Tag\Canon\ZoomTargetWidth(),
                'SpotMeteringMode' => new \PHPExiftool\Driver\Tag\Canon\SpotMeteringMode(),
                'PhotoEffect' => new \PHPExiftool\Driver\Tag\Canon\PhotoEffect(),
                'ManualFlashOutput' => new \PHPExiftool\Driver\Tag\Canon\ManualFlashOutput(),
                'SRAWQuality' => new \PHPExiftool\Driver\Tag\Canon\SRAWQuality(),
                'WB_RGGBLevelsAuto' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsAuto(),
                'WB_RGGBLevelsDaylight' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsDaylight(),
                'WB_RGGBLevelsShade' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsShade(),
                'WB_RGGBLevelsCloudy' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsCloudy(),
                'WB_RGGBLevelsTungsten' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsTungsten(),
                'WB_RGGBLevelsFluorescent' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsFluorescent(),
                'WB_RGGBLevelsFlash' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsFlash(),
                'WB_RGGBLevelsCustom' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsCustom(),
                'WB_RGGBLevelsKelvin' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsKelvin(),
                'WB_RGGBBlackLevels' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBBlackLevels(),
                'CameraColorCalibration01' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration01(),
                'CameraColorCalibration02' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration02(),
                'CameraColorCalibration03' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration03(),
                'CameraColorCalibration04' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration04(),
                'CameraColorCalibration05' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration05(),
                'CameraColorCalibration06' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration06(),
                'CameraColorCalibration07' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration07(),
                'CameraColorCalibration08' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration08(),
                'CameraColorCalibration09' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration09(),
                'CameraColorCalibration10' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration10(),
                'CameraColorCalibration11' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration11(),
                'CameraColorCalibration12' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration12(),
                'CameraColorCalibration13' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration13(),
                'CameraColorCalibration14' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration14(),
                'CameraColorCalibration15' => new \PHPExiftool\Driver\Tag\Canon\CameraColorCalibration15(),
                'WB_RGGBLevelsAsShot' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsAsShot(),
                'ColorTempAsShot' => new \PHPExiftool\Driver\Tag\Canon\ColorTempAsShot(),
                'ColorTempAuto' => new \PHPExiftool\Driver\Tag\Canon\ColorTempAuto(),
                'WB_RGGBLevelsMeasured' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsMeasured(),
                'ColorTempMeasured' => new \PHPExiftool\Driver\Tag\Canon\ColorTempMeasured(),
                'WB_RGGBLevelsUnknown' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown(),
                'ColorTempUnknown' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown(),
                'ColorTempDaylight' => new \PHPExiftool\Driver\Tag\Canon\ColorTempDaylight(),
                'ColorTempShade' => new \PHPExiftool\Driver\Tag\Canon\ColorTempShade(),
                'ColorTempCloudy' => new \PHPExiftool\Driver\Tag\Canon\ColorTempCloudy(),
                'ColorTempTungsten' => new \PHPExiftool\Driver\Tag\Canon\ColorTempTungsten(),
                'ColorTempFluorescent' => new \PHPExiftool\Driver\Tag\Canon\ColorTempFluorescent(),
                'ColorTempKelvin' => new \PHPExiftool\Driver\Tag\Canon\ColorTempKelvin(),
                'ColorTempFlash' => new \PHPExiftool\Driver\Tag\Canon\ColorTempFlash(),
                'WB_RGGBLevelsUnknown2' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown2(),
                'ColorTempUnknown2' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown2(),
                'WB_RGGBLevelsUnknown3' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown3(),
                'ColorTempUnknown3' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown3(),
                'WB_RGGBLevelsUnknown4' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown4(),
                'ColorTempUnknown4' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown4(),
                'WB_RGGBLevelsUnknown5' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown5(),
                'ColorTempUnknown5' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown5(),
                'WB_RGGBLevelsUnknown6' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown6(),
                'ColorTempUnknown6' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown6(),
                'WB_RGGBLevelsUnknown7' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown7(),
                'ColorTempUnknown7' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown7(),
                'WB_RGGBLevelsUnknown8' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown8(),
                'ColorTempUnknown8' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown8(),
                'WB_RGGBLevelsUnknown9' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown9(),
                'ColorTempUnknown9' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown9(),
                'WB_RGGBLevelsUnknown10' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown10(),
                'ColorTempUnknown10' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown10(),
                'WB_RGGBLevelsUnknown11' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown11(),
                'ColorTempUnknown11' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown11(),
                'WB_RGGBLevelsUnknown12' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown12(),
                'ColorTempUnknown12' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown12(),
                'WB_RGGBLevelsUnknown13' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown13(),
                'ColorTempUnknown13' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown13(),
                'WB_RGGBLevelsCustom1' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsCustom1(),
                'ColorTempCustom1' => new \PHPExiftool\Driver\Tag\Canon\ColorTempCustom1(),
                'WB_RGGBLevelsCustom2' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsCustom2(),
                'ColorTempCustom2' => new \PHPExiftool\Driver\Tag\Canon\ColorTempCustom2(),
                'WB_RGGBLevelsUnknown14' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown14(),
                'ColorTempUnknown14' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown14(),
                'WB_RGGBLevelsUnknown15' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown15(),
                'ColorTempUnknown15' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown15(),
                'WB_RGGBLevelsPC1' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsPC1(),
                'ColorTempPC1' => new \PHPExiftool\Driver\Tag\Canon\ColorTempPC1(),
                'WB_RGGBLevelsPC2' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsPC2(),
                'ColorTempPC2' => new \PHPExiftool\Driver\Tag\Canon\ColorTempPC2(),
                'WB_RGGBLevelsPC3' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsPC3(),
                'ColorTempPC3' => new \PHPExiftool\Driver\Tag\Canon\ColorTempPC3(),
                'WB_RGGBLevelsUnknown16' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown16(),
                'ColorTempUnknown16' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown16(),
                'RawMeasuredRGGB' => new \PHPExiftool\Driver\Tag\Canon\RawMeasuredRGGB(),
                'ColorDataVersion' => new \PHPExiftool\Driver\Tag\Canon\ColorDataVersion(),
                'ColorTempCustom' => new \PHPExiftool\Driver\Tag\Canon\ColorTempCustom(),
                'PerChannelBlackLevel' => new \PHPExiftool\Driver\Tag\Canon\PerChannelBlackLevel(),
                'FlashOutput' => new \PHPExiftool\Driver\Tag\Canon\FlashOutput(),
                'FlashBatteryLevel' => new \PHPExiftool\Driver\Tag\Canon\FlashBatteryLevel(),
                'ColorTempFlashData' => new \PHPExiftool\Driver\Tag\Canon\ColorTempFlashData(),
                'MeasuredRGGBData' => new \PHPExiftool\Driver\Tag\Canon\MeasuredRGGBData(),
                'AverageBlackLevel' => new \PHPExiftool\Driver\Tag\Canon\AverageBlackLevel(),
                'NormalWhiteLevel' => new \PHPExiftool\Driver\Tag\Canon\NormalWhiteLevel(),
                'SpecularWhiteLevel' => new \PHPExiftool\Driver\Tag\Canon\SpecularWhiteLevel(),
                'LinearityUpperMargin' => new \PHPExiftool\Driver\Tag\Canon\LinearityUpperMargin(),
                'WB_RGGBLevelsUnknown17' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown17(),
                'ColorTempUnknown17' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown17(),
                'WB_RGGBLevelsUnknown18' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown18(),
                'ColorTempUnknown18' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown18(),
                'WB_RGGBLevelsUnknown19' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown19(),
                'ColorTempUnknown19' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown19(),
                'WB_RGGBLevelsUnknown20' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown20(),
                'ColorTempUnknown20' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown20(),
                'WB_RGGBLevelsUnknown21' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown21(),
                'ColorTempUnknown21' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown21(),
                'WB_RGGBLevelsUnknown22' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown22(),
                'ColorTempUnknown22' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown22(),
                'WB_RGGBLevelsUnknown23' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown23(),
                'ColorTempUnknown23' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown23(),
                'WB_RGGBLevelsUnknown24' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown24(),
                'ColorTempUnknown24' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown24(),
                'WB_RGGBLevelsUnknown25' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown25(),
                'ColorTempUnknown25' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown25(),
                'WB_RGGBLevelsUnknown26' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown26(),
                'ColorTempUnknown26' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown26(),
                'WB_RGGBLevelsUnknown27' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown27(),
                'ColorTempUnknown27' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown27(),
                'WB_RGGBLevelsUnknown28' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown28(),
                'ColorTempUnknown28' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown28(),
                'WB_RGGBLevelsUnknown29' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown29(),
                'ColorTempUnknown29' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown29(),
                'WB_RGGBLevelsUnknown30' => new \PHPExiftool\Driver\Tag\Canon\WBRGGBLevelsUnknown30(),
                'ColorTempUnknown30' => new \PHPExiftool\Driver\Tag\Canon\ColorTempUnknown30(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\Canon\ColorSpace(),
                'IntelligentContrast' => new \PHPExiftool\Driver\Tag\Canon\IntelligentContrast(),
                'CropLeftMargin' => new \PHPExiftool\Driver\Tag\Canon\CropLeftMargin(),
                'CropRightMargin' => new \PHPExiftool\Driver\Tag\Canon\CropRightMargin(),
                'CropTopMargin' => new \PHPExiftool\Driver\Tag\Canon\CropTopMargin(),
                'CropBottomMargin' => new \PHPExiftool\Driver\Tag\Canon\CropBottomMargin(),
                'FacesDetected' => new \PHPExiftool\Driver\Tag\Canon\FacesDetected(),
                'FaceDetectFrameSize' => new \PHPExiftool\Driver\Tag\Canon\FaceDetectFrameSize(),
                'Face1Position' => new \PHPExiftool\Driver\Tag\Canon\Face1Position(),
                'Face2Position' => new \PHPExiftool\Driver\Tag\Canon\Face2Position(),
                'Face3Position' => new \PHPExiftool\Driver\Tag\Canon\Face3Position(),
                'Face4Position' => new \PHPExiftool\Driver\Tag\Canon\Face4Position(),
                'Face5Position' => new \PHPExiftool\Driver\Tag\Canon\Face5Position(),
                'Face6Position' => new \PHPExiftool\Driver\Tag\Canon\Face6Position(),
                'Face7Position' => new \PHPExiftool\Driver\Tag\Canon\Face7Position(),
                'Face8Position' => new \PHPExiftool\Driver\Tag\Canon\Face8Position(),
                'Face9Position' => new \PHPExiftool\Driver\Tag\Canon\Face9Position(),
                'FaceWidth' => new \PHPExiftool\Driver\Tag\Canon\FaceWidth(),
                'FileNumber' => new \PHPExiftool\Driver\Tag\Canon\FileNumber(),
                'BracketMode' => new \PHPExiftool\Driver\Tag\Canon\BracketMode(),
                'BracketValue' => new \PHPExiftool\Driver\Tag\Canon\BracketValue(),
                'BracketShotNumber' => new \PHPExiftool\Driver\Tag\Canon\BracketShotNumber(),
                'RawJpgQuality' => new \PHPExiftool\Driver\Tag\Canon\RawJpgQuality(),
                'RawJpgSize' => new \PHPExiftool\Driver\Tag\Canon\RawJpgSize(),
                'LongExposureNoiseReduction2' => new \PHPExiftool\Driver\Tag\Canon\LongExposureNoiseReduction2(),
                'WBBracketMode' => new \PHPExiftool\Driver\Tag\Canon\WBBracketMode(),
                'WBBracketValueAB' => new \PHPExiftool\Driver\Tag\Canon\WBBracketValueAB(),
                'WBBracketValueGM' => new \PHPExiftool\Driver\Tag\Canon\WBBracketValueGM(),
                'FilterEffect' => new \PHPExiftool\Driver\Tag\Canon\FilterEffect(),
                'ToningEffect' => new \PHPExiftool\Driver\Tag\Canon\ToningEffect(),
                'LiveViewShooting' => new \PHPExiftool\Driver\Tag\Canon\LiveViewShooting(),
                'FlashExposureLock' => new \PHPExiftool\Driver\Tag\Canon\FlashExposureLock(),
                'GrainyBWFilter' => new \PHPExiftool\Driver\Tag\Canon\GrainyBWFilter(),
                'SoftFocusFilter' => new \PHPExiftool\Driver\Tag\Canon\SoftFocusFilter(),
                'ToyCameraFilter' => new \PHPExiftool\Driver\Tag\Canon\ToyCameraFilter(),
                'MiniatureFilter' => new \PHPExiftool\Driver\Tag\Canon\MiniatureFilter(),
                'MiniatureFilterOrientation' => new \PHPExiftool\Driver\Tag\Canon\MiniatureFilterOrientation(),
                'MiniatureFilterPosition' => new \PHPExiftool\Driver\Tag\Canon\MiniatureFilterPosition(),
                'MiniatureFilterParameter' => new \PHPExiftool\Driver\Tag\Canon\MiniatureFilterParameter(),
                'FisheyeFilter' => new \PHPExiftool\Driver\Tag\Canon\FisheyeFilter(),
                'PaintingFilter' => new \PHPExiftool\Driver\Tag\Canon\PaintingFilter(),
                'WatercolorFilter' => new \PHPExiftool\Driver\Tag\Canon\WatercolorFilter(),
                'ModifiedParamFlag' => new \PHPExiftool\Driver\Tag\Canon\ModifiedParamFlag(),
                'FocalPlaneXSize' => new \PHPExiftool\Driver\Tag\Canon\FocalPlaneXSize(),
                'FocalPlaneXUnknown' => new \PHPExiftool\Driver\Tag\Canon\FocalPlaneXUnknown(),
                'FocalPlaneYSize' => new \PHPExiftool\Driver\Tag\Canon\FocalPlaneYSize(),
                'FocalPlaneYUnknown' => new \PHPExiftool\Driver\Tag\Canon\FocalPlaneYUnknown(),
                'HDR' => new \PHPExiftool\Driver\Tag\Canon\HDR(),
                'HDREffect' => new \PHPExiftool\Driver\Tag\Canon\HDREffect(),
                'PeripheralIlluminationCorr' => new \PHPExiftool\Driver\Tag\Canon\PeripheralIlluminationCorr(),
                'LongExposureNoiseReduction' => new \PHPExiftool\Driver\Tag\Canon\LongExposureNoiseReduction(),
                'CanonFlashInfo' => new \PHPExiftool\Driver\Tag\Canon\CanonFlashInfo(),
                'CanonImageType' => new \PHPExiftool\Driver\Tag\Canon\CanonImageType(),
                'CanonFirmwareVersion' => new \PHPExiftool\Driver\Tag\Canon\CanonFirmwareVersion(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\Canon\SerialNumber(),
                'CanonFileLength' => new \PHPExiftool\Driver\Tag\Canon\CanonFileLength(),
                'CanonModelID' => new \PHPExiftool\Driver\Tag\Canon\CanonModelID(),
                'ThumbnailImageValidArea' => new \PHPExiftool\Driver\Tag\Canon\ThumbnailImageValidArea(),
                'SerialNumberFormat' => new \PHPExiftool\Driver\Tag\Canon\SerialNumberFormat(),
                'SuperMacro' => new \PHPExiftool\Driver\Tag\Canon\SuperMacro(),
                'DateStampMode' => new \PHPExiftool\Driver\Tag\Canon\DateStampMode(),
                'Categories' => new \PHPExiftool\Driver\Tag\Canon\Categories(),
                'ImageUniqueID' => new \PHPExiftool\Driver\Tag\Canon\ImageUniqueID(),
                'RawDataOffset' => new \PHPExiftool\Driver\Tag\Canon\RawDataOffset(),
                'OriginalDecisionDataOffset' => new \PHPExiftool\Driver\Tag\Canon\OriginalDecisionDataOffset(),
                'AFPointsInFocus1D' => new \PHPExiftool\Driver\Tag\Canon\AFPointsInFocus1D(),
                'InternalSerialNumber' => new \PHPExiftool\Driver\Tag\Canon\InternalSerialNumber(),
                'DustRemovalData' => new \PHPExiftool\Driver\Tag\Canon\DustRemovalData(),
                'ToneCurveTable' => new \PHPExiftool\Driver\Tag\Canon\ToneCurveTable(),
                'SharpnessTable' => new \PHPExiftool\Driver\Tag\Canon\SharpnessTable(),
                'SharpnessFreqTable' => new \PHPExiftool\Driver\Tag\Canon\SharpnessFreqTable(),
                'WhiteBalanceTable' => new \PHPExiftool\Driver\Tag\Canon\WhiteBalanceTable(),
                'ToneCurveMatching' => new \PHPExiftool\Driver\Tag\Canon\ToneCurveMatching(),
                'WhiteBalanceMatching' => new \PHPExiftool\Driver\Tag\Canon\WhiteBalanceMatching(),
                'VRDOffset' => new \PHPExiftool\Driver\Tag\Canon\VRDOffset(),
                'CRWParam' => new \PHPExiftool\Driver\Tag\Canon\CRWParam(),
                'Flavor' => new \PHPExiftool\Driver\Tag\Canon\Flavor(),
                'BlackLevel' => new \PHPExiftool\Driver\Tag\Canon\BlackLevel(),
                'CustomPictureStyleFileName' => new \PHPExiftool\Driver\Tag\Canon\CustomPictureStyleFileName(),
                'MeasuredRGGB' => new \PHPExiftool\Driver\Tag\Canon\MeasuredRGGB(),
                'ModifiedToneCurve' => new \PHPExiftool\Driver\Tag\Canon\ModifiedToneCurve(),
                'ModifiedSharpness' => new \PHPExiftool\Driver\Tag\Canon\ModifiedSharpness(),
                'ModifiedSharpnessFreq' => new \PHPExiftool\Driver\Tag\Canon\ModifiedSharpnessFreq(),
                'ModifiedSensorRedLevel' => new \PHPExiftool\Driver\Tag\Canon\ModifiedSensorRedLevel(),
                'ModifiedSensorBlueLevel' => new \PHPExiftool\Driver\Tag\Canon\ModifiedSensorBlueLevel(),
                'ModifiedWhiteBalanceRed' => new \PHPExiftool\Driver\Tag\Canon\ModifiedWhiteBalanceRed(),
                'ModifiedWhiteBalanceBlue' => new \PHPExiftool\Driver\Tag\Canon\ModifiedWhiteBalanceBlue(),
                'ModifiedWhiteBalance' => new \PHPExiftool\Driver\Tag\Canon\ModifiedWhiteBalance(),
                'ModifiedColorTemp' => new \PHPExiftool\Driver\Tag\Canon\ModifiedColorTemp(),
                'ModifiedPictureStyle' => new \PHPExiftool\Driver\Tag\Canon\ModifiedPictureStyle(),
                'ModifiedDigitalGain' => new \PHPExiftool\Driver\Tag\Canon\ModifiedDigitalGain(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\Canon\FrameRate(),
                'FrameCount' => new \PHPExiftool\Driver\Tag\Canon\FrameCount(),
                'Duration' => new \PHPExiftool\Driver\Tag\Canon\Duration(),
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\Canon\AudioBitrate(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\Canon\AudioSampleRate(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\Canon\AudioChannels(),
                'VideoCodec' => new \PHPExiftool\Driver\Tag\Canon\VideoCodec(),
                'MultiExposure' => new \PHPExiftool\Driver\Tag\Canon\MultiExposure(),
                'MultiExposureControl' => new \PHPExiftool\Driver\Tag\Canon\MultiExposureControl(),
                'MultiExposureShots' => new \PHPExiftool\Driver\Tag\Canon\MultiExposureShots(),
                'MyColorMode' => new \PHPExiftool\Driver\Tag\Canon\MyColorMode(),
                'FilterEffectStandard' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectStandard(),
                'ToningEffectStandard' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectStandard(),
                'FilterEffectPortrait' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectPortrait(),
                'ToningEffectPortrait' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectPortrait(),
                'FilterEffectLandscape' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectLandscape(),
                'ToningEffectLandscape' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectLandscape(),
                'FilterEffectNeutral' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectNeutral(),
                'ToningEffectNeutral' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectNeutral(),
                'FilterEffectFaithful' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectFaithful(),
                'ToningEffectFaithful' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectFaithful(),
                'SaturationMonochrome' => new \PHPExiftool\Driver\Tag\Canon\SaturationMonochrome(),
                'ColorToneMonochrome' => new \PHPExiftool\Driver\Tag\Canon\ColorToneMonochrome(),
                'FilterEffectUserDef1' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectUserDef1(),
                'ToningEffectUserDef1' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectUserDef1(),
                'FilterEffectUserDef2' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectUserDef2(),
                'ToningEffectUserDef2' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectUserDef2(),
                'FilterEffectUserDef3' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectUserDef3(),
                'ToningEffectUserDef3' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectUserDef3(),
                'ContrastAuto' => new \PHPExiftool\Driver\Tag\Canon\ContrastAuto(),
                'SharpnessAuto' => new \PHPExiftool\Driver\Tag\Canon\SharpnessAuto(),
                'SaturationAuto' => new \PHPExiftool\Driver\Tag\Canon\SaturationAuto(),
                'ColorToneAuto' => new \PHPExiftool\Driver\Tag\Canon\ColorToneAuto(),
                'FilterEffectAuto' => new \PHPExiftool\Driver\Tag\Canon\FilterEffectAuto(),
                'ToningEffectAuto' => new \PHPExiftool\Driver\Tag\Canon\ToningEffectAuto(),
                'PanoramaFrameNumber' => new \PHPExiftool\Driver\Tag\Canon\PanoramaFrameNumber(),
                'PanoramaDirection' => new \PHPExiftool\Driver\Tag\Canon\PanoramaDirection(),
                'PreviewQuality' => new \PHPExiftool\Driver\Tag\Canon\PreviewQuality(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\Canon\PreviewImageLength(),
                'PreviewImageWidth' => new \PHPExiftool\Driver\Tag\Canon\PreviewImageWidth(),
                'PreviewImageHeight' => new \PHPExiftool\Driver\Tag\Canon\PreviewImageHeight(),
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\Canon\PreviewImageStart(),
                'ToneCurve' => new \PHPExiftool\Driver\Tag\Canon\ToneCurve(),
                'SensorRedLevel' => new \PHPExiftool\Driver\Tag\Canon\SensorRedLevel(),
                'SensorBlueLevel' => new \PHPExiftool\Driver\Tag\Canon\SensorBlueLevel(),
                'WhiteBalanceRed' => new \PHPExiftool\Driver\Tag\Canon\WhiteBalanceRed(),
                'WhiteBalanceBlue' => new \PHPExiftool\Driver\Tag\Canon\WhiteBalanceBlue(),
                'DigitalGain' => new \PHPExiftool\Driver\Tag\Canon\DigitalGain(),
                'WBShiftAB' => new \PHPExiftool\Driver\Tag\Canon\WBShiftAB(),
                'WBShiftGM' => new \PHPExiftool\Driver\Tag\Canon\WBShiftGM(),
                'SensorWidth' => new \PHPExiftool\Driver\Tag\Canon\SensorWidth(),
                'SensorHeight' => new \PHPExiftool\Driver\Tag\Canon\SensorHeight(),
                'SensorLeftBorder' => new \PHPExiftool\Driver\Tag\Canon\SensorLeftBorder(),
                'SensorTopBorder' => new \PHPExiftool\Driver\Tag\Canon\SensorTopBorder(),
                'SensorRightBorder' => new \PHPExiftool\Driver\Tag\Canon\SensorRightBorder(),
                'SensorBottomBorder' => new \PHPExiftool\Driver\Tag\Canon\SensorBottomBorder(),
                'BlackMaskLeftBorder' => new \PHPExiftool\Driver\Tag\Canon\BlackMaskLeftBorder(),
                'BlackMaskTopBorder' => new \PHPExiftool\Driver\Tag\Canon\BlackMaskTopBorder(),
                'BlackMaskRightBorder' => new \PHPExiftool\Driver\Tag\Canon\BlackMaskRightBorder(),
                'BlackMaskBottomBorder' => new \PHPExiftool\Driver\Tag\Canon\BlackMaskBottomBorder(),
                'AutoISO' => new \PHPExiftool\Driver\Tag\Canon\AutoISO(),
                'BaseISO' => new \PHPExiftool\Driver\Tag\Canon\BaseISO(),
                'TargetAperture' => new \PHPExiftool\Driver\Tag\Canon\TargetAperture(),
                'TargetExposureTime' => new \PHPExiftool\Driver\Tag\Canon\TargetExposureTime(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\Canon\ExposureCompensation(),
                'SlowShutter' => new \PHPExiftool\Driver\Tag\Canon\SlowShutter(),
                'SequenceNumber' => new \PHPExiftool\Driver\Tag\Canon\SequenceNumber(),
                'OpticalZoomCode' => new \PHPExiftool\Driver\Tag\Canon\OpticalZoomCode(),
                'FlashGuideNumber' => new \PHPExiftool\Driver\Tag\Canon\FlashGuideNumber(),
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\Canon\FlashExposureComp(),
                'AutoExposureBracketing' => new \PHPExiftool\Driver\Tag\Canon\AutoExposureBracketing(),
                'AEBBracketValue' => new \PHPExiftool\Driver\Tag\Canon\AEBBracketValue(),
                'ControlMode' => new \PHPExiftool\Driver\Tag\Canon\ControlMode(),
                'BulbDuration' => new \PHPExiftool\Driver\Tag\Canon\BulbDuration(),
                'CameraType' => new \PHPExiftool\Driver\Tag\Canon\CameraType(),
                'AutoRotate' => new \PHPExiftool\Driver\Tag\Canon\AutoRotate(),
                'NDFilter' => new \PHPExiftool\Driver\Tag\Canon\NDFilter(),
                'SelfTimer2' => new \PHPExiftool\Driver\Tag\Canon\SelfTimer2(),
                'Unknown_CNDB' => new \PHPExiftool\Driver\Tag\Canon\UnknownCNDB(),
                'TimeZone' => new \PHPExiftool\Driver\Tag\Canon\TimeZone(),
                'TimeZoneCity' => new \PHPExiftool\Driver\Tag\Canon\TimeZoneCity(),
                'DaylightSavings' => new \PHPExiftool\Driver\Tag\Canon\DaylightSavings(),
                'VignettingCorrVersion' => new \PHPExiftool\Driver\Tag\Canon\VignettingCorrVersion(),
                'PeripheralLighting' => new \PHPExiftool\Driver\Tag\Canon\PeripheralLighting(),
                'ChromaticAberrationCorr' => new \PHPExiftool\Driver\Tag\Canon\ChromaticAberrationCorr(),
                'PeripheralLightingValue' => new \PHPExiftool\Driver\Tag\Canon\PeripheralLightingValue(),
                'OriginalImageWidth' => new \PHPExiftool\Driver\Tag\Canon\OriginalImageWidth(),
                'OriginalImageHeight' => new \PHPExiftool\Driver\Tag\Canon\OriginalImageHeight(),
                'PeripheralLightingSetting' => new \PHPExiftool\Driver\Tag\Canon\PeripheralLightingSetting(),
                'ChromaticAberrationSetting' => new \PHPExiftool\Driver\Tag\Canon\ChromaticAberrationSetting(),
                'CompressorVersion' => new \PHPExiftool\Driver\Tag\Canon\CompressorVersion(),
            );
        });
        $this['CanonCustom'] = $this->share(function(){
            return array(
                'SetButtonWhenShooting' => new \PHPExiftool\Driver\Tag\CanonCustom\SetButtonWhenShooting(),
                'ShutterReleaseNoCFCard' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterReleaseNoCFCard(),
                'FlashSyncSpeedAv' => new \PHPExiftool\Driver\Tag\CanonCustom\FlashSyncSpeedAv(),
                'Shutter-AELock' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterAELock(),
                'AFAssist' => new \PHPExiftool\Driver\Tag\CanonCustom\AFAssist(),
                'ExposureLevelIncrements' => new \PHPExiftool\Driver\Tag\CanonCustom\ExposureLevelIncrements(),
                'AFPointRegistration' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointRegistration(),
                'RawAndJpgRecording' => new \PHPExiftool\Driver\Tag\CanonCustom\RawAndJpgRecording(),
                'AEBSequenceAutoCancel' => new \PHPExiftool\Driver\Tag\CanonCustom\AEBSequenceAutoCancel(),
                'SuperimposedDisplay' => new \PHPExiftool\Driver\Tag\CanonCustom\SuperimposedDisplay(),
                'MenuButtonDisplayPosition' => new \PHPExiftool\Driver\Tag\CanonCustom\MenuButtonDisplayPosition(),
                'MirrorLockup' => new \PHPExiftool\Driver\Tag\CanonCustom\MirrorLockup(),
                'AssistButtonFunction' => new \PHPExiftool\Driver\Tag\CanonCustom\AssistButtonFunction(),
                'FillFlashAutoReduction' => new \PHPExiftool\Driver\Tag\CanonCustom\FillFlashAutoReduction(),
                'ShutterCurtainSync' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterCurtainSync(),
                'SafetyShiftInAvOrTv' => new \PHPExiftool\Driver\Tag\CanonCustom\SafetyShiftInAvOrTv(),
                'LensAFStopButton' => new \PHPExiftool\Driver\Tag\CanonCustom\LensAFStopButton(),
                'FocusingScreen' => new \PHPExiftool\Driver\Tag\CanonCustom\FocusingScreen(),
                'FinderDisplayDuringExposure' => new \PHPExiftool\Driver\Tag\CanonCustom\FinderDisplayDuringExposure(),
                'ISOSpeedExpansion' => new \PHPExiftool\Driver\Tag\CanonCustom\ISOSpeedExpansion(),
                'ShutterAELButton' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterAELButton(),
                'ManualTv' => new \PHPExiftool\Driver\Tag\CanonCustom\ManualTv(),
                'USMLensElectronicMF' => new \PHPExiftool\Driver\Tag\CanonCustom\USMLensElectronicMF(),
                'LCDPanels' => new \PHPExiftool\Driver\Tag\CanonCustom\LCDPanels(),
                'AFPointIllumination' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointIllumination(),
                'AFPointSelection' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointSelection(),
                'AFPointSpotMetering' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointSpotMetering(),
                'AFPointActivationArea' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointActivationArea(),
                'SwitchToRegisteredAFPoint' => new \PHPExiftool\Driver\Tag\CanonCustom\SwitchToRegisteredAFPoint(),
                'AIServoTrackingSensitivity' => new \PHPExiftool\Driver\Tag\CanonCustom\AIServoTrackingSensitivity(),
                'AIServoContinuousShooting' => new \PHPExiftool\Driver\Tag\CanonCustom\AIServoContinuousShooting(),
                'ISOSpeedIncrements' => new \PHPExiftool\Driver\Tag\CanonCustom\ISOSpeedIncrements(),
                'ISOSpeedRange' => new \PHPExiftool\Driver\Tag\CanonCustom\ISOSpeedRange(),
                'ISOExpansion' => new \PHPExiftool\Driver\Tag\CanonCustom\ISOExpansion(),
                'AEBAutoCancel' => new \PHPExiftool\Driver\Tag\CanonCustom\AEBAutoCancel(),
                'AEBSequence' => new \PHPExiftool\Driver\Tag\CanonCustom\AEBSequence(),
                'AEBShotCount' => new \PHPExiftool\Driver\Tag\CanonCustom\AEBShotCount(),
                'SpotMeterLinkToAFPoint' => new \PHPExiftool\Driver\Tag\CanonCustom\SpotMeterLinkToAFPoint(),
                'SafetyShift' => new \PHPExiftool\Driver\Tag\CanonCustom\SafetyShift(),
                'UsableShootingModes' => new \PHPExiftool\Driver\Tag\CanonCustom\UsableShootingModes(),
                'UsableMeteringModes' => new \PHPExiftool\Driver\Tag\CanonCustom\UsableMeteringModes(),
                'ExposureModeInManual' => new \PHPExiftool\Driver\Tag\CanonCustom\ExposureModeInManual(),
                'ShutterSpeedRange' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterSpeedRange(),
                'ApertureRange' => new \PHPExiftool\Driver\Tag\CanonCustom\ApertureRange(),
                'ApplyShootingMeteringMode' => new \PHPExiftool\Driver\Tag\CanonCustom\ApplyShootingMeteringMode(),
                'AEMicroadjustment' => new \PHPExiftool\Driver\Tag\CanonCustom\AEMicroadjustment(),
                'FEMicroadjustment' => new \PHPExiftool\Driver\Tag\CanonCustom\FEMicroadjustment(),
                'SameExposureForNewAperture' => new \PHPExiftool\Driver\Tag\CanonCustom\SameExposureForNewAperture(),
                'LongExposureNoiseReduction' => new \PHPExiftool\Driver\Tag\CanonCustom\LongExposureNoiseReduction(),
                'HighISONoiseReduction' => new \PHPExiftool\Driver\Tag\CanonCustom\HighISONoiseReduction(),
                'HighlightTonePriority' => new \PHPExiftool\Driver\Tag\CanonCustom\HighlightTonePriority(),
                'AutoLightingOptimizer' => new \PHPExiftool\Driver\Tag\CanonCustom\AutoLightingOptimizer(),
                'ETTLII' => new \PHPExiftool\Driver\Tag\CanonCustom\ETTLII(),
                'FlashFiring' => new \PHPExiftool\Driver\Tag\CanonCustom\FlashFiring(),
                'ViewInfoDuringExposure' => new \PHPExiftool\Driver\Tag\CanonCustom\ViewInfoDuringExposure(),
                'LCDIlluminationDuringBulb' => new \PHPExiftool\Driver\Tag\CanonCustom\LCDIlluminationDuringBulb(),
                'InfoButtonWhenShooting' => new \PHPExiftool\Driver\Tag\CanonCustom\InfoButtonWhenShooting(),
                'ViewfinderWarnings' => new \PHPExiftool\Driver\Tag\CanonCustom\ViewfinderWarnings(),
                'LVShootingAreaDisplay' => new \PHPExiftool\Driver\Tag\CanonCustom\LVShootingAreaDisplay(),
                'AIServoImagePriority' => new \PHPExiftool\Driver\Tag\CanonCustom\AIServoImagePriority(),
                'AIServoTrackingMethod' => new \PHPExiftool\Driver\Tag\CanonCustom\AIServoTrackingMethod(),
                'LensDriveNoAF' => new \PHPExiftool\Driver\Tag\CanonCustom\LensDriveNoAF(),
                'AFMicroadjustment' => new \PHPExiftool\Driver\Tag\CanonCustom\AFMicroadjustment(),
                'AFPointAreaExpansion' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointAreaExpansion(),
                'SelectableAFPoint' => new \PHPExiftool\Driver\Tag\CanonCustom\SelectableAFPoint(),
                'AFPointAutoSelection' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointAutoSelection(),
                'AFPointDisplayDuringFocus' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointDisplayDuringFocus(),
                'AFPointBrightness' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointBrightness(),
                'AFAssistBeam' => new \PHPExiftool\Driver\Tag\CanonCustom\AFAssistBeam(),
                'AFPointSelectionMethod' => new \PHPExiftool\Driver\Tag\CanonCustom\AFPointSelectionMethod(),
                'VFDisplayIllumination' => new \PHPExiftool\Driver\Tag\CanonCustom\VFDisplayIllumination(),
                'AFDuringLiveView' => new \PHPExiftool\Driver\Tag\CanonCustom\AFDuringLiveView(),
                'SelectAFAreaSelectMode' => new \PHPExiftool\Driver\Tag\CanonCustom\SelectAFAreaSelectMode(),
                'ManualAFPointSelectPattern' => new \PHPExiftool\Driver\Tag\CanonCustom\ManualAFPointSelectPattern(),
                'DisplayAllAFPoints' => new \PHPExiftool\Driver\Tag\CanonCustom\DisplayAllAFPoints(),
                'FocusDisplayAIServoAndMF' => new \PHPExiftool\Driver\Tag\CanonCustom\FocusDisplayAIServoAndMF(),
                'OrientationLinkedAFPoint' => new \PHPExiftool\Driver\Tag\CanonCustom\OrientationLinkedAFPoint(),
                'MultiControllerWhileMetering' => new \PHPExiftool\Driver\Tag\CanonCustom\MultiControllerWhileMetering(),
                'AccelerationTracking' => new \PHPExiftool\Driver\Tag\CanonCustom\AccelerationTracking(),
                'AIServoFirstImagePriority' => new \PHPExiftool\Driver\Tag\CanonCustom\AIServoFirstImagePriority(),
                'AIServoSecondImagePriority' => new \PHPExiftool\Driver\Tag\CanonCustom\AIServoSecondImagePriority(),
                'AFAreaSelectMethod' => new \PHPExiftool\Driver\Tag\CanonCustom\AFAreaSelectMethod(),
                'AutoAFPointColorTracking' => new \PHPExiftool\Driver\Tag\CanonCustom\AutoAFPointColorTracking(),
                'ContinuousShootingSpeed' => new \PHPExiftool\Driver\Tag\CanonCustom\ContinuousShootingSpeed(),
                'ContinuousShotLimit' => new \PHPExiftool\Driver\Tag\CanonCustom\ContinuousShotLimit(),
                'RestrictDriveModes' => new \PHPExiftool\Driver\Tag\CanonCustom\RestrictDriveModes(),
                'AFAndMeteringButtons' => new \PHPExiftool\Driver\Tag\CanonCustom\AFAndMeteringButtons(),
                'ShutterButtonAFOnButton' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterButtonAFOnButton(),
                'AFOnAELockButtonSwitch' => new \PHPExiftool\Driver\Tag\CanonCustom\AFOnAELockButtonSwitch(),
                'QuickControlDialInMeter' => new \PHPExiftool\Driver\Tag\CanonCustom\QuickControlDialInMeter(),
                'DialDirectionTvAv' => new \PHPExiftool\Driver\Tag\CanonCustom\DialDirectionTvAv(),
                'AvSettingWithoutLens' => new \PHPExiftool\Driver\Tag\CanonCustom\AvSettingWithoutLens(),
                'WBMediaImageSizeSetting' => new \PHPExiftool\Driver\Tag\CanonCustom\WBMediaImageSizeSetting(),
                'LockMicrophoneButton' => new \PHPExiftool\Driver\Tag\CanonCustom\LockMicrophoneButton(),
                'ButtonFunctionControlOff' => new \PHPExiftool\Driver\Tag\CanonCustom\ButtonFunctionControlOff(),
                'AssignFuncButton' => new \PHPExiftool\Driver\Tag\CanonCustom\AssignFuncButton(),
                'CustomControls' => new \PHPExiftool\Driver\Tag\CanonCustom\CustomControls(),
                'StartMovieShooting' => new \PHPExiftool\Driver\Tag\CanonCustom\StartMovieShooting(),
                'FlashButtonFunction' => new \PHPExiftool\Driver\Tag\CanonCustom\FlashButtonFunction(),
                'MultiFunctionLock' => new \PHPExiftool\Driver\Tag\CanonCustom\MultiFunctionLock(),
                'TrashButtonFunction' => new \PHPExiftool\Driver\Tag\CanonCustom\TrashButtonFunction(),
                'ShutterReleaseWithoutLens' => new \PHPExiftool\Driver\Tag\CanonCustom\ShutterReleaseWithoutLens(),
                'TimerLength' => new \PHPExiftool\Driver\Tag\CanonCustom\TimerLength(),
                'ShortReleaseTimeLag' => new \PHPExiftool\Driver\Tag\CanonCustom\ShortReleaseTimeLag(),
                'AddAspectRatioInfo' => new \PHPExiftool\Driver\Tag\CanonCustom\AddAspectRatioInfo(),
                'AddOriginalDecisionData' => new \PHPExiftool\Driver\Tag\CanonCustom\AddOriginalDecisionData(),
                'LiveViewExposureSimulation' => new \PHPExiftool\Driver\Tag\CanonCustom\LiveViewExposureSimulation(),
                'LCDDisplayAtPowerOn' => new \PHPExiftool\Driver\Tag\CanonCustom\LCDDisplayAtPowerOn(),
                'MemoAudioQuality' => new \PHPExiftool\Driver\Tag\CanonCustom\MemoAudioQuality(),
                'DefaultEraseOption' => new \PHPExiftool\Driver\Tag\CanonCustom\DefaultEraseOption(),
                'RetractLensOnPowerOff' => new \PHPExiftool\Driver\Tag\CanonCustom\RetractLensOnPowerOff(),
                'SetFunctionWhenShooting' => new \PHPExiftool\Driver\Tag\CanonCustom\SetFunctionWhenShooting(),
                'MagnifiedView' => new \PHPExiftool\Driver\Tag\CanonCustom\MagnifiedView(),
                'SetButtonCrossKeysFunc' => new \PHPExiftool\Driver\Tag\CanonCustom\SetButtonCrossKeysFunc(),
                'LCDDisplayReturnToShoot' => new \PHPExiftool\Driver\Tag\CanonCustom\LCDDisplayReturnToShoot(),
                'MenuButtonReturn' => new \PHPExiftool\Driver\Tag\CanonCustom\MenuButtonReturn(),
                'SensorCleaning' => new \PHPExiftool\Driver\Tag\CanonCustom\SensorCleaning(),
                'PF1Value' => new \PHPExiftool\Driver\Tag\CanonCustom\PF1Value(),
                'PF2Value' => new \PHPExiftool\Driver\Tag\CanonCustom\PF2Value(),
                'PF3Value' => new \PHPExiftool\Driver\Tag\CanonCustom\PF3Value(),
                'PF4ExposureTimeMin' => new \PHPExiftool\Driver\Tag\CanonCustom\PF4ExposureTimeMin(),
                'PF4ExposureTimeMax' => new \PHPExiftool\Driver\Tag\CanonCustom\PF4ExposureTimeMax(),
                'PF5ApertureMin' => new \PHPExiftool\Driver\Tag\CanonCustom\PF5ApertureMin(),
                'PF5ApertureMax' => new \PHPExiftool\Driver\Tag\CanonCustom\PF5ApertureMax(),
                'PF8BracketShots' => new \PHPExiftool\Driver\Tag\CanonCustom\PF8BracketShots(),
                'PF19ShootingSpeedLow' => new \PHPExiftool\Driver\Tag\CanonCustom\PF19ShootingSpeedLow(),
                'PF19ShootingSpeedHigh' => new \PHPExiftool\Driver\Tag\CanonCustom\PF19ShootingSpeedHigh(),
                'PF20MaxContinousShots' => new \PHPExiftool\Driver\Tag\CanonCustom\PF20MaxContinousShots(),
                'PF23ShutterButtonTime' => new \PHPExiftool\Driver\Tag\CanonCustom\PF23ShutterButtonTime(),
                'PF23FELockTime' => new \PHPExiftool\Driver\Tag\CanonCustom\PF23FELockTime(),
                'PF23PostReleaseTime' => new \PHPExiftool\Driver\Tag\CanonCustom\PF23PostReleaseTime(),
                'PF25AEMode' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25AEMode(),
                'PF25MeteringMode' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25MeteringMode(),
                'PF25DriveMode' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25DriveMode(),
                'PF25AFMode' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25AFMode(),
                'PF25AFPointSel' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25AFPointSel(),
                'PF25ImageSize' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25ImageSize(),
                'PF25WBMode' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25WBMode(),
                'PF25Parameters' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25Parameters(),
                'PF25ColorMatrix' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25ColorMatrix(),
                'PF27Value' => new \PHPExiftool\Driver\Tag\CanonCustom\PF27Value(),
                'PF0CustomFuncRegistration' => new \PHPExiftool\Driver\Tag\CanonCustom\PF0CustomFuncRegistration(),
                'PF1DisableShootingModes' => new \PHPExiftool\Driver\Tag\CanonCustom\PF1DisableShootingModes(),
                'PF2DisableMeteringModes' => new \PHPExiftool\Driver\Tag\CanonCustom\PF2DisableMeteringModes(),
                'PF3ManualExposureMetering' => new \PHPExiftool\Driver\Tag\CanonCustom\PF3ManualExposureMetering(),
                'PF4ExposureTimeLimits' => new \PHPExiftool\Driver\Tag\CanonCustom\PF4ExposureTimeLimits(),
                'PF5ApertureLimits' => new \PHPExiftool\Driver\Tag\CanonCustom\PF5ApertureLimits(),
                'PF6PresetShootingModes' => new \PHPExiftool\Driver\Tag\CanonCustom\PF6PresetShootingModes(),
                'PF7BracketContinuousShoot' => new \PHPExiftool\Driver\Tag\CanonCustom\PF7BracketContinuousShoot(),
                'PF8SetBracketShots' => new \PHPExiftool\Driver\Tag\CanonCustom\PF8SetBracketShots(),
                'PF9ChangeBracketSequence' => new \PHPExiftool\Driver\Tag\CanonCustom\PF9ChangeBracketSequence(),
                'PF10RetainProgramShift' => new \PHPExiftool\Driver\Tag\CanonCustom\PF10RetainProgramShift(),
                'PF13DrivePriority' => new \PHPExiftool\Driver\Tag\CanonCustom\PF13DrivePriority(),
                'PF14DisableFocusSearch' => new \PHPExiftool\Driver\Tag\CanonCustom\PF14DisableFocusSearch(),
                'PF15DisableAFAssistBeam' => new \PHPExiftool\Driver\Tag\CanonCustom\PF15DisableAFAssistBeam(),
                'PF16AutoFocusPointShoot' => new \PHPExiftool\Driver\Tag\CanonCustom\PF16AutoFocusPointShoot(),
                'PF17DisableAFPointSel' => new \PHPExiftool\Driver\Tag\CanonCustom\PF17DisableAFPointSel(),
                'PF18EnableAutoAFPointSel' => new \PHPExiftool\Driver\Tag\CanonCustom\PF18EnableAutoAFPointSel(),
                'PF19ContinuousShootSpeed' => new \PHPExiftool\Driver\Tag\CanonCustom\PF19ContinuousShootSpeed(),
                'PF20LimitContinousShots' => new \PHPExiftool\Driver\Tag\CanonCustom\PF20LimitContinousShots(),
                'PF21EnableQuietOperation' => new \PHPExiftool\Driver\Tag\CanonCustom\PF21EnableQuietOperation(),
                'PF23SetTimerLengths' => new \PHPExiftool\Driver\Tag\CanonCustom\PF23SetTimerLengths(),
                'PF24LightLCDDuringBulb' => new \PHPExiftool\Driver\Tag\CanonCustom\PF24LightLCDDuringBulb(),
                'PF25DefaultClearSettings' => new \PHPExiftool\Driver\Tag\CanonCustom\PF25DefaultClearSettings(),
                'PF26ShortenReleaseLag' => new \PHPExiftool\Driver\Tag\CanonCustom\PF26ShortenReleaseLag(),
                'PF27ReverseDialRotation' => new \PHPExiftool\Driver\Tag\CanonCustom\PF27ReverseDialRotation(),
                'PF28NoQuickDialExpComp' => new \PHPExiftool\Driver\Tag\CanonCustom\PF28NoQuickDialExpComp(),
                'PF29QuickDialSwitchOff' => new \PHPExiftool\Driver\Tag\CanonCustom\PF29QuickDialSwitchOff(),
                'PF30EnlargementMode' => new \PHPExiftool\Driver\Tag\CanonCustom\PF30EnlargementMode(),
                'PF31OriginalDecisionData' => new \PHPExiftool\Driver\Tag\CanonCustom\PF31OriginalDecisionData(),
            );
        });
        $this['CanonRaw'] = $this->share(function(){
            return array(
                'DecoderTableNumber' => new \PHPExiftool\Driver\Tag\CanonRaw\DecoderTableNumber(),
                'CompressedDataOffset' => new \PHPExiftool\Driver\Tag\CanonRaw\CompressedDataOffset(),
                'CompressedDataLength' => new \PHPExiftool\Driver\Tag\CanonRaw\CompressedDataLength(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\CanonRaw\ExposureCompensation(),
                'ShutterSpeedValue' => new \PHPExiftool\Driver\Tag\CanonRaw\ShutterSpeedValue(),
                'ApertureValue' => new \PHPExiftool\Driver\Tag\CanonRaw\ApertureValue(),
                'FlashGuideNumber' => new \PHPExiftool\Driver\Tag\CanonRaw\FlashGuideNumber(),
                'FlashThreshold' => new \PHPExiftool\Driver\Tag\CanonRaw\FlashThreshold(),
                'FileFormat' => new \PHPExiftool\Driver\Tag\CanonRaw\FileFormat(),
                'TargetCompressionRatio' => new \PHPExiftool\Driver\Tag\CanonRaw\TargetCompressionRatio(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\CanonRaw\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\CanonRaw\ImageHeight(),
                'PixelAspectRatio' => new \PHPExiftool\Driver\Tag\CanonRaw\PixelAspectRatio(),
                'Rotation' => new \PHPExiftool\Driver\Tag\CanonRaw\Rotation(),
                'ComponentBitDepth' => new \PHPExiftool\Driver\Tag\CanonRaw\ComponentBitDepth(),
                'ColorBitDepth' => new \PHPExiftool\Driver\Tag\CanonRaw\ColorBitDepth(),
                'ColorBW' => new \PHPExiftool\Driver\Tag\CanonRaw\ColorBW(),
                'NullRecord' => new \PHPExiftool\Driver\Tag\CanonRaw\NullRecord(),
                'FreeBytes' => new \PHPExiftool\Driver\Tag\CanonRaw\FreeBytes(),
                'CanonColorInfo1' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonColorInfo1(),
                'CanonFileDescription' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonFileDescription(),
                'UserComment' => new \PHPExiftool\Driver\Tag\CanonRaw\UserComment(),
                'CanonFirmwareVersion' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonFirmwareVersion(),
                'ComponentVersion' => new \PHPExiftool\Driver\Tag\CanonRaw\ComponentVersion(),
                'ROMOperationMode' => new \PHPExiftool\Driver\Tag\CanonRaw\ROMOperationMode(),
                'OwnerName' => new \PHPExiftool\Driver\Tag\CanonRaw\OwnerName(),
                'CanonImageType' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonImageType(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\CanonRaw\OriginalFileName(),
                'ThumbnailFileName' => new \PHPExiftool\Driver\Tag\CanonRaw\ThumbnailFileName(),
                'TargetImageType' => new \PHPExiftool\Driver\Tag\CanonRaw\TargetImageType(),
                'ShutterReleaseMethod' => new \PHPExiftool\Driver\Tag\CanonRaw\ShutterReleaseMethod(),
                'ShutterReleaseTiming' => new \PHPExiftool\Driver\Tag\CanonRaw\ShutterReleaseTiming(),
                'ReleaseSetting' => new \PHPExiftool\Driver\Tag\CanonRaw\ReleaseSetting(),
                'BaseISO' => new \PHPExiftool\Driver\Tag\CanonRaw\BaseISO(),
                'CanonFlashInfo' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonFlashInfo(),
                'CanonColorInfo2' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonColorInfo2(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\CanonRaw\ColorTemperature(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\CanonRaw\ColorSpace(),
                'RecordID' => new \PHPExiftool\Driver\Tag\CanonRaw\RecordID(),
                'SelfTimerTime' => new \PHPExiftool\Driver\Tag\CanonRaw\SelfTimerTime(),
                'TargetDistanceSetting' => new \PHPExiftool\Driver\Tag\CanonRaw\TargetDistanceSetting(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\CanonRaw\SerialNumber(),
                'UnknownNumber' => new \PHPExiftool\Driver\Tag\CanonRaw\UnknownNumber(),
                'MeasuredEV' => new \PHPExiftool\Driver\Tag\CanonRaw\MeasuredEV(),
                'FileNumber' => new \PHPExiftool\Driver\Tag\CanonRaw\FileNumber(),
                'CanonModelID' => new \PHPExiftool\Driver\Tag\CanonRaw\CanonModelID(),
                'SerialNumberFormat' => new \PHPExiftool\Driver\Tag\CanonRaw\SerialNumberFormat(),
                'RawData' => new \PHPExiftool\Driver\Tag\CanonRaw\RawData(),
                'JpgFromRaw' => new \PHPExiftool\Driver\Tag\CanonRaw\JpgFromRaw(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\CanonRaw\ThumbnailImage(),
                'Make' => new \PHPExiftool\Driver\Tag\CanonRaw\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\CanonRaw\Model(),
                'RawJpgQuality' => new \PHPExiftool\Driver\Tag\CanonRaw\RawJpgQuality(),
                'RawJpgSize' => new \PHPExiftool\Driver\Tag\CanonRaw\RawJpgSize(),
                'RawJpgWidth' => new \PHPExiftool\Driver\Tag\CanonRaw\RawJpgWidth(),
                'RawJpgHeight' => new \PHPExiftool\Driver\Tag\CanonRaw\RawJpgHeight(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\CanonRaw\DateTimeOriginal(),
                'TimeZoneCode' => new \PHPExiftool\Driver\Tag\CanonRaw\TimeZoneCode(),
                'TimeZoneInfo' => new \PHPExiftool\Driver\Tag\CanonRaw\TimeZoneInfo(),
                'WhiteSampleWidth' => new \PHPExiftool\Driver\Tag\CanonRaw\WhiteSampleWidth(),
                'WhiteSampleHeight' => new \PHPExiftool\Driver\Tag\CanonRaw\WhiteSampleHeight(),
                'WhiteSampleLeftBorder' => new \PHPExiftool\Driver\Tag\CanonRaw\WhiteSampleLeftBorder(),
                'WhiteSampleTopBorder' => new \PHPExiftool\Driver\Tag\CanonRaw\WhiteSampleTopBorder(),
                'WhiteSampleBits' => new \PHPExiftool\Driver\Tag\CanonRaw\WhiteSampleBits(),
            );
        });
        $this['CanonVRD'] = $this->share(function(){
            return array(
                'CropActive' => new \PHPExiftool\Driver\Tag\CanonVRD\CropActive(),
                'CropRotatedOriginalWidth' => new \PHPExiftool\Driver\Tag\CanonVRD\CropRotatedOriginalWidth(),
                'CropRotatedOriginalHeight' => new \PHPExiftool\Driver\Tag\CanonVRD\CropRotatedOriginalHeight(),
                'CropX' => new \PHPExiftool\Driver\Tag\CanonVRD\CropX(),
                'CropY' => new \PHPExiftool\Driver\Tag\CanonVRD\CropY(),
                'CropWidth' => new \PHPExiftool\Driver\Tag\CanonVRD\CropWidth(),
                'CropHeight' => new \PHPExiftool\Driver\Tag\CanonVRD\CropHeight(),
                'CropRotation' => new \PHPExiftool\Driver\Tag\CanonVRD\CropRotation(),
                'CropOriginalWidth' => new \PHPExiftool\Driver\Tag\CanonVRD\CropOriginalWidth(),
                'CropOriginalHeight' => new \PHPExiftool\Driver\Tag\CanonVRD\CropOriginalHeight(),
                'DLOSettingApplied' => new \PHPExiftool\Driver\Tag\CanonVRD\DLOSettingApplied(),
                'DLOVersion' => new \PHPExiftool\Driver\Tag\CanonVRD\DLOVersion(),
                'DLOData' => new \PHPExiftool\Driver\Tag\CanonVRD\DLOData(),
                'Rotation' => new \PHPExiftool\Driver\Tag\CanonVRD\Rotation(),
                'AngleAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\AngleAdj(),
                'CustomPictureStyle' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomPictureStyle(),
                'CheckMark' => new \PHPExiftool\Driver\Tag\CanonVRD\CheckMark(),
                'WorkColorSpace' => new \PHPExiftool\Driver\Tag\CanonVRD\WorkColorSpace(),
                'RawBrightnessAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\RawBrightnessAdj(),
                'WhiteBalanceAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\WhiteBalanceAdj(),
                'WBAdjColorTemp' => new \PHPExiftool\Driver\Tag\CanonVRD\WBAdjColorTemp(),
                'WBAdjMagentaGreen' => new \PHPExiftool\Driver\Tag\CanonVRD\WBAdjMagentaGreen(),
                'WBAdjBlueAmber' => new \PHPExiftool\Driver\Tag\CanonVRD\WBAdjBlueAmber(),
                'WBAdjRGGBLevels' => new \PHPExiftool\Driver\Tag\CanonVRD\WBAdjRGGBLevels(),
                'GammaLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaLinear(),
                'PictureStyle' => new \PHPExiftool\Driver\Tag\CanonVRD\PictureStyle(),
                'ContrastAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\ContrastAdj(),
                'ColorToneAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\ColorToneAdj(),
                'ColorSaturationAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\ColorSaturationAdj(),
                'MonochromeToningEffect' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeToningEffect(),
                'MonochromeFilterEffect' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeFilterEffect(),
                'UnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\UnsharpMaskStrength(),
                'UnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\UnsharpMaskFineness(),
                'UnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\UnsharpMaskThreshold(),
                'ShadowAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\ShadowAdj(),
                'HighlightAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\HighlightAdj(),
                'SharpnessAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\SharpnessAdj(),
                'SharpnessStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\SharpnessStrength(),
                'ToneCurveBrightness' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveBrightness(),
                'ToneCurveContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveContrast(),
                'AutoLightingOptimizer' => new \PHPExiftool\Driver\Tag\CanonVRD\AutoLightingOptimizer(),
                'LuminanceNoiseReduction' => new \PHPExiftool\Driver\Tag\CanonVRD\LuminanceNoiseReduction(),
                'ChrominanceNoiseReduction' => new \PHPExiftool\Driver\Tag\CanonVRD\ChrominanceNoiseReduction(),
                'ShootingDistance' => new \PHPExiftool\Driver\Tag\CanonVRD\ShootingDistance(),
                'PeripheralIllumination' => new \PHPExiftool\Driver\Tag\CanonVRD\PeripheralIllumination(),
                'ChromaticAberration' => new \PHPExiftool\Driver\Tag\CanonVRD\ChromaticAberration(),
                'ColorBlurOn' => new \PHPExiftool\Driver\Tag\CanonVRD\ColorBlurOn(),
                'DistortionCorrection' => new \PHPExiftool\Driver\Tag\CanonVRD\DistortionCorrection(),
                'DLOSetting' => new \PHPExiftool\Driver\Tag\CanonVRD\DLOSetting(),
                'ChromaticAberrationRed' => new \PHPExiftool\Driver\Tag\CanonVRD\ChromaticAberrationRed(),
                'ChromaticAberrationBlue' => new \PHPExiftool\Driver\Tag\CanonVRD\ChromaticAberrationBlue(),
                'DistortionEffect' => new \PHPExiftool\Driver\Tag\CanonVRD\DistortionEffect(),
                'ColorHue' => new \PHPExiftool\Driver\Tag\CanonVRD\ColorHue(),
                'SaturationAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\SaturationAdj(),
                'RedHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\RedHSL(),
                'OrangeHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\OrangeHSL(),
                'GreenHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\GreenHSL(),
                'AquaHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\AquaHSL(),
                'BlueHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\BlueHSL(),
                'PurpleHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\PurpleHSL(),
                'MagentaHSL' => new \PHPExiftool\Driver\Tag\CanonVRD\MagentaHSL(),
                'CropAspectRatio' => new \PHPExiftool\Driver\Tag\CanonVRD\CropAspectRatio(),
                'CropAspectRatioCustom' => new \PHPExiftool\Driver\Tag\CanonVRD\CropAspectRatioCustom(),
                'CustomPictureStyleData' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomPictureStyleData(),
                'LensFocalLength' => new \PHPExiftool\Driver\Tag\CanonVRD\LensFocalLength(),
                'SharpnessAdjOn' => new \PHPExiftool\Driver\Tag\CanonVRD\SharpnessAdjOn(),
                'ToneCurveOriginal' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveOriginal(),
                'AutoLightingOptimizerOn' => new \PHPExiftool\Driver\Tag\CanonVRD\AutoLightingOptimizerOn(),
                'PeripheralIlluminationOn' => new \PHPExiftool\Driver\Tag\CanonVRD\PeripheralIlluminationOn(),
                'ChromaticAberrationOn' => new \PHPExiftool\Driver\Tag\CanonVRD\ChromaticAberrationOn(),
                'DistortionCorrectionOn' => new \PHPExiftool\Driver\Tag\CanonVRD\DistortionCorrectionOn(),
                'DLOOn' => new \PHPExiftool\Driver\Tag\CanonVRD\DLOOn(),
                'DR4CameraModel' => new \PHPExiftool\Driver\Tag\CanonVRD\DR4CameraModel(),
                'DustDeleteApplied' => new \PHPExiftool\Driver\Tag\CanonVRD\DustDeleteApplied(),
                'GammaContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaContrast(),
                'GammaColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaColorTone(),
                'GammaSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaSaturation(),
                'GammaUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaUnsharpMaskStrength(),
                'GammaUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaUnsharpMaskFineness(),
                'GammaUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaUnsharpMaskThreshold(),
                'GammaSharpnessStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaSharpnessStrength(),
                'GammaShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaShadow(),
                'GammaHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaHighlight(),
                'GammaBlackPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaBlackPoint(),
                'GammaWhitePoint' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaWhitePoint(),
                'GammaMidPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaMidPoint(),
                'GammaCurveOutputRange' => new \PHPExiftool\Driver\Tag\CanonVRD\GammaCurveOutputRange(),
                'IHL_EXIF' => new \PHPExiftool\Driver\Tag\CanonVRD\IHLEXIF(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\CanonVRD\ThumbnailImage(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\CanonVRD\PreviewImage(),
                'RawCodecVersion' => new \PHPExiftool\Driver\Tag\CanonVRD\RawCodecVersion(),
                'CRCDevelParams' => new \PHPExiftool\Driver\Tag\CanonVRD\CRCDevelParams(),
                'XMP' => new \PHPExiftool\Driver\Tag\CanonVRD\XMP(),
                'StampToolCount' => new \PHPExiftool\Driver\Tag\CanonVRD\StampToolCount(),
                'ToneCurveColorSpace' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveColorSpace(),
                'ToneCurveShape' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveShape(),
                'ToneCurveInputRange' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveInputRange(),
                'ToneCurveOutputRange' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveOutputRange(),
                'RGBCurvePoints' => new \PHPExiftool\Driver\Tag\CanonVRD\RGBCurvePoints(),
                'ToneCurveX' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveX(),
                'ToneCurveY' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveY(),
                'RedCurvePoints' => new \PHPExiftool\Driver\Tag\CanonVRD\RedCurvePoints(),
                'GreenCurvePoints' => new \PHPExiftool\Driver\Tag\CanonVRD\GreenCurvePoints(),
                'BlueCurvePoints' => new \PHPExiftool\Driver\Tag\CanonVRD\BlueCurvePoints(),
                'VRDVersion' => new \PHPExiftool\Driver\Tag\CanonVRD\VRDVersion(),
                'WBFineTuneActive' => new \PHPExiftool\Driver\Tag\CanonVRD\WBFineTuneActive(),
                'WBFineTuneSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\WBFineTuneSaturation(),
                'WBFineTuneTone' => new \PHPExiftool\Driver\Tag\CanonVRD\WBFineTuneTone(),
                'RawColorAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\RawColorAdj(),
                'RawCustomSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\RawCustomSaturation(),
                'RawCustomTone' => new \PHPExiftool\Driver\Tag\CanonVRD\RawCustomTone(),
                'ToneCurveProperty' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveProperty(),
                'DynamicRangeMin' => new \PHPExiftool\Driver\Tag\CanonVRD\DynamicRangeMin(),
                'DynamicRangeMax' => new \PHPExiftool\Driver\Tag\CanonVRD\DynamicRangeMax(),
                'ToneCurveActive' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveActive(),
                'ToneCurveMode' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveMode(),
                'BrightnessAdj' => new \PHPExiftool\Driver\Tag\CanonVRD\BrightnessAdj(),
                'LuminanceCurvePoints' => new \PHPExiftool\Driver\Tag\CanonVRD\LuminanceCurvePoints(),
                'LuminanceCurveLimits' => new \PHPExiftool\Driver\Tag\CanonVRD\LuminanceCurveLimits(),
                'ToneCurveInterpolation' => new \PHPExiftool\Driver\Tag\CanonVRD\ToneCurveInterpolation(),
                'RedCurveLimits' => new \PHPExiftool\Driver\Tag\CanonVRD\RedCurveLimits(),
                'GreenCurveLimits' => new \PHPExiftool\Driver\Tag\CanonVRD\GreenCurveLimits(),
                'BlueCurveLimits' => new \PHPExiftool\Driver\Tag\CanonVRD\BlueCurveLimits(),
                'RGBCurveLimits' => new \PHPExiftool\Driver\Tag\CanonVRD\RGBCurveLimits(),
                'CropLeft' => new \PHPExiftool\Driver\Tag\CanonVRD\CropLeft(),
                'CropTop' => new \PHPExiftool\Driver\Tag\CanonVRD\CropTop(),
                'ConstrainedCropWidth' => new \PHPExiftool\Driver\Tag\CanonVRD\ConstrainedCropWidth(),
                'ConstrainedCropHeight' => new \PHPExiftool\Driver\Tag\CanonVRD\ConstrainedCropHeight(),
                'IsCustomPictureStyle' => new \PHPExiftool\Driver\Tag\CanonVRD\IsCustomPictureStyle(),
                'StandardRawColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawColorTone(),
                'StandardRawSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawSaturation(),
                'StandardRawContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawContrast(),
                'StandardRawLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawLinear(),
                'StandardRawSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawSharpness(),
                'StandardRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawHighlightPoint(),
                'StandardRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawShadowPoint(),
                'StandardOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardOutputHighlightPoint(),
                'StandardOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardOutputShadowPoint(),
                'PortraitRawColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawColorTone(),
                'PortraitRawSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawSaturation(),
                'PortraitRawContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawContrast(),
                'PortraitRawLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawLinear(),
                'PortraitRawSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawSharpness(),
                'PortraitRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawHighlightPoint(),
                'PortraitRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawShadowPoint(),
                'PortraitOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitOutputHighlightPoint(),
                'PortraitOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitOutputShadowPoint(),
                'LandscapeRawColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawColorTone(),
                'LandscapeRawSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawSaturation(),
                'LandscapeRawContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawContrast(),
                'LandscapeRawLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawLinear(),
                'LandscapeRawSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawSharpness(),
                'LandscapeRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawHighlightPoint(),
                'LandscapeRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawShadowPoint(),
                'LandscapeOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeOutputHighlightPoint(),
                'LandscapeOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeOutputShadowPoint(),
                'NeutralRawColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawColorTone(),
                'NeutralRawSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawSaturation(),
                'NeutralRawContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawContrast(),
                'NeutralRawLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawLinear(),
                'NeutralRawSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawSharpness(),
                'NeutralRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawHighlightPoint(),
                'NeutralRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawShadowPoint(),
                'NeutralOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralOutputHighlightPoint(),
                'NeutralOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralOutputShadowPoint(),
                'FaithfulRawColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawColorTone(),
                'FaithfulRawSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawSaturation(),
                'FaithfulRawContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawContrast(),
                'FaithfulRawLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawLinear(),
                'FaithfulRawSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawSharpness(),
                'FaithfulRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawHighlightPoint(),
                'FaithfulRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawShadowPoint(),
                'FaithfulOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulOutputHighlightPoint(),
                'FaithfulOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulOutputShadowPoint(),
                'MonochromeContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeContrast(),
                'MonochromeLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeLinear(),
                'MonochromeSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeSharpness(),
                'MonochromeRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeRawHighlightPoint(),
                'MonochromeRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeRawShadowPoint(),
                'MonochromeOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeOutputHighlightPoint(),
                'MonochromeOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeOutputShadowPoint(),
                'UnknownContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownContrast(),
                'UnknownLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownLinear(),
                'UnknownSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownSharpness(),
                'UnknownRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownRawHighlightPoint(),
                'UnknownRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownRawShadowPoint(),
                'UnknownOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownOutputHighlightPoint(),
                'UnknownOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownOutputShadowPoint(),
                'CustomColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomColorTone(),
                'CustomSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomSaturation(),
                'CustomContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomContrast(),
                'CustomLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomLinear(),
                'CustomSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomSharpness(),
                'CustomRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomRawHighlightPoint(),
                'CustomRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomRawShadowPoint(),
                'CustomOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomOutputHighlightPoint(),
                'CustomOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomOutputShadowPoint(),
                'ChrominanceNR_TIFF_JPEG' => new \PHPExiftool\Driver\Tag\CanonVRD\ChrominanceNRTIFFJPEG(),
                'ColorBlur' => new \PHPExiftool\Driver\Tag\CanonVRD\ColorBlur(),
                'AberrationCorrectionDistance' => new \PHPExiftool\Driver\Tag\CanonVRD\AberrationCorrectionDistance(),
                'LuminanceNR_TIFF_JPEG' => new \PHPExiftool\Driver\Tag\CanonVRD\LuminanceNRTIFFJPEG(),
                'StandardRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawHighlight(),
                'PortraitRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawHighlight(),
                'LandscapeRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawHighlight(),
                'NeutralRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawHighlight(),
                'FaithfulRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawHighlight(),
                'MonochromeRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeRawHighlight(),
                'UnknownRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownRawHighlight(),
                'CustomRawHighlight' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomRawHighlight(),
                'StandardRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardRawShadow(),
                'PortraitRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitRawShadow(),
                'LandscapeRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeRawShadow(),
                'NeutralRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralRawShadow(),
                'FaithfulRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulRawShadow(),
                'MonochromeRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeRawShadow(),
                'UnknownRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\UnknownRawShadow(),
                'CustomRawShadow' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomRawShadow(),
                'CheckMark2' => new \PHPExiftool\Driver\Tag\CanonVRD\CheckMark2(),
                'UnsharpMask' => new \PHPExiftool\Driver\Tag\CanonVRD\UnsharpMask(),
                'StandardUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardUnsharpMaskStrength(),
                'StandardUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardUnsharpMaskFineness(),
                'StandardUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\StandardUnsharpMaskThreshold(),
                'PortraitUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitUnsharpMaskStrength(),
                'PortraitUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitUnsharpMaskFineness(),
                'PortraitUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\PortraitUnsharpMaskThreshold(),
                'LandscapeUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeUnsharpMaskStrength(),
                'LandscapeUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeUnsharpMaskFineness(),
                'LandscapeUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\LandscapeUnsharpMaskThreshold(),
                'NeutraUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutraUnsharpMaskStrength(),
                'NeutralUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralUnsharpMaskFineness(),
                'NeutralUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\NeutralUnsharpMaskThreshold(),
                'FaithfulUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulUnsharpMaskStrength(),
                'FaithfulUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulUnsharpMaskFineness(),
                'FaithfulUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\FaithfulUnsharpMaskThreshold(),
                'MonochromeUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeUnsharpMaskStrength(),
                'MonochromeUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeUnsharpMaskFineness(),
                'MonochromeUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\MonochromeUnsharpMaskThreshold(),
                'CustomUnsharpMaskStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomUnsharpMaskStrength(),
                'CustomUnsharpMaskFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomUnsharpMaskFineness(),
                'CustomUnsharpMaskThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomUnsharpMaskThreshold(),
                'CustomDefaultUnsharpStrength' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomDefaultUnsharpStrength(),
                'CustomDefaultUnsharpFineness' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomDefaultUnsharpFineness(),
                'CustomDefaultUnsharpThreshold' => new \PHPExiftool\Driver\Tag\CanonVRD\CustomDefaultUnsharpThreshold(),
                'CropCircleActive' => new \PHPExiftool\Driver\Tag\CanonVRD\CropCircleActive(),
                'CropCircleX' => new \PHPExiftool\Driver\Tag\CanonVRD\CropCircleX(),
                'CropCircleY' => new \PHPExiftool\Driver\Tag\CanonVRD\CropCircleY(),
                'CropCircleRadius' => new \PHPExiftool\Driver\Tag\CanonVRD\CropCircleRadius(),
                'DLOShootingDistance' => new \PHPExiftool\Driver\Tag\CanonVRD\DLOShootingDistance(),
                'DLODataLength' => new \PHPExiftool\Driver\Tag\CanonVRD\DLODataLength(),
                'CameraRawColorTone' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawColorTone(),
                'CameraRawSaturation' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawSaturation(),
                'CameraRawContrast' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawContrast(),
                'CameraRawLinear' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawLinear(),
                'CameraRawSharpness' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawSharpness(),
                'CameraRawHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawHighlightPoint(),
                'CameraRawShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawShadowPoint(),
                'CameraRawOutputHighlightPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawOutputHighlightPoint(),
                'CameraRawOutputShadowPoint' => new \PHPExiftool\Driver\Tag\CanonVRD\CameraRawOutputShadowPoint(),
                'CanonDR4' => new \PHPExiftool\Driver\Tag\CanonVRD\CanonDR4(),
                'CanonVRD' => new \PHPExiftool\Driver\Tag\CanonVRD\CanonVRD(),
            );
        });
        $this['Casio'] = $this->share(function(){
            return array(
                'Software' => new \PHPExiftool\Driver\Tag\Casio\Software(),
                'FacesDetected' => new \PHPExiftool\Driver\Tag\Casio\FacesDetected(),
                'FaceDetectFrameSize' => new \PHPExiftool\Driver\Tag\Casio\FaceDetectFrameSize(),
                'Face1Position' => new \PHPExiftool\Driver\Tag\Casio\Face1Position(),
                'Face2Position' => new \PHPExiftool\Driver\Tag\Casio\Face2Position(),
                'Face3Position' => new \PHPExiftool\Driver\Tag\Casio\Face3Position(),
                'Face4Position' => new \PHPExiftool\Driver\Tag\Casio\Face4Position(),
                'Face5Position' => new \PHPExiftool\Driver\Tag\Casio\Face5Position(),
                'Face6Position' => new \PHPExiftool\Driver\Tag\Casio\Face6Position(),
                'Face7Position' => new \PHPExiftool\Driver\Tag\Casio\Face7Position(),
                'Face8Position' => new \PHPExiftool\Driver\Tag\Casio\Face8Position(),
                'Face9Position' => new \PHPExiftool\Driver\Tag\Casio\Face9Position(),
                'Face10Position' => new \PHPExiftool\Driver\Tag\Casio\Face10Position(),
                'FaceOrientation' => new \PHPExiftool\Driver\Tag\Casio\FaceOrientation(),
                'RecordingMode' => new \PHPExiftool\Driver\Tag\Casio\RecordingMode(),
                'Quality' => new \PHPExiftool\Driver\Tag\Casio\Quality(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\Casio\FocusMode(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\Casio\FlashMode(),
                'FlashIntensity' => new \PHPExiftool\Driver\Tag\Casio\FlashIntensity(),
                'ObjectDistance' => new \PHPExiftool\Driver\Tag\Casio\ObjectDistance(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\Casio\WhiteBalance(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\Casio\DigitalZoom(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\Casio\Sharpness(),
                'Contrast' => new \PHPExiftool\Driver\Tag\Casio\Contrast(),
                'Saturation' => new \PHPExiftool\Driver\Tag\Casio\Saturation(),
                'ISO' => new \PHPExiftool\Driver\Tag\Casio\ISO(),
                'FirmwareDate' => new \PHPExiftool\Driver\Tag\Casio\FirmwareDate(),
                'Enhancement' => new \PHPExiftool\Driver\Tag\Casio\Enhancement(),
                'ColorFilter' => new \PHPExiftool\Driver\Tag\Casio\ColorFilter(),
                'AFPoint' => new \PHPExiftool\Driver\Tag\Casio\AFPoint(),
                'CasioQuality' => new \PHPExiftool\Driver\Tag\Casio\CasioQuality(),
                'FocalRange' => new \PHPExiftool\Driver\Tag\Casio\FocalRange(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\Casio\DateTimeOriginal(),
                'ModelType' => new \PHPExiftool\Driver\Tag\Casio\ModelType(),
                'ManufactureIndex' => new \PHPExiftool\Driver\Tag\Casio\ManufactureIndex(),
                'ManufactureCode' => new \PHPExiftool\Driver\Tag\Casio\ManufactureCode(),
                'PreviewImageSize' => new \PHPExiftool\Driver\Tag\Casio\PreviewImageSize(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\Casio\PreviewImageLength(),
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\Casio\PreviewImageStart(),
                'QualityMode' => new \PHPExiftool\Driver\Tag\Casio\QualityMode(),
                'CasioImageSize' => new \PHPExiftool\Driver\Tag\Casio\CasioImageSize(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Casio\FocalLength(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\Casio\PreviewImage(),
                'WhiteBalanceBias' => new \PHPExiftool\Driver\Tag\Casio\WhiteBalanceBias(),
                'AFPointPosition' => new \PHPExiftool\Driver\Tag\Casio\AFPointPosition(),
                'FlashDistance' => new \PHPExiftool\Driver\Tag\Casio\FlashDistance(),
                'SpecialEffectMode' => new \PHPExiftool\Driver\Tag\Casio\SpecialEffectMode(),
                'FaceInfoUnknown' => new \PHPExiftool\Driver\Tag\Casio\FaceInfoUnknown(),
                'RecordMode' => new \PHPExiftool\Driver\Tag\Casio\RecordMode(),
                'ReleaseMode' => new \PHPExiftool\Driver\Tag\Casio\ReleaseMode(),
                'HometownCity' => new \PHPExiftool\Driver\Tag\Casio\HometownCity(),
                'BestShotMode' => new \PHPExiftool\Driver\Tag\Casio\BestShotMode(),
                'AutoISO' => new \PHPExiftool\Driver\Tag\Casio\AutoISO(),
                'AFMode' => new \PHPExiftool\Driver\Tag\Casio\AFMode(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\Casio\ColorMode(),
                'ArtMode' => new \PHPExiftool\Driver\Tag\Casio\ArtMode(),
                'SequenceNumber' => new \PHPExiftool\Driver\Tag\Casio\SequenceNumber(),
                'BracketSequence' => new \PHPExiftool\Driver\Tag\Casio\BracketSequence(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\Casio\ImageStabilization(),
                'LightingMode' => new \PHPExiftool\Driver\Tag\Casio\LightingMode(),
                'PortraitRefiner' => new \PHPExiftool\Driver\Tag\Casio\PortraitRefiner(),
                'SpecialEffectLevel' => new \PHPExiftool\Driver\Tag\Casio\SpecialEffectLevel(),
                'SpecialEffectSetting' => new \PHPExiftool\Driver\Tag\Casio\SpecialEffectSetting(),
                'DriveMode' => new \PHPExiftool\Driver\Tag\Casio\DriveMode(),
                'ArtModeParameters' => new \PHPExiftool\Driver\Tag\Casio\ArtModeParameters(),
                'CaptureFrameRate' => new \PHPExiftool\Driver\Tag\Casio\CaptureFrameRate(),
                'VideoQuality' => new \PHPExiftool\Driver\Tag\Casio\VideoQuality(),
            );
        });
        $this['Composite'] = $this->share(function(){
            return array(
                'AdvancedSceneMode' => new \PHPExiftool\Driver\Tag\Composite\AdvancedSceneMode(),
                'Aperture' => new \PHPExiftool\Driver\Tag\Composite\Aperture(),
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\Composite\AudioBitrate(),
                'AutoFocus' => new \PHPExiftool\Driver\Tag\Composite\AutoFocus(),
                'AvgBitrate' => new \PHPExiftool\Driver\Tag\Composite\AvgBitrate(),
                'BlueBalance' => new \PHPExiftool\Driver\Tag\Composite\BlueBalance(),
                'CDDBDiscPlayTime' => new \PHPExiftool\Driver\Tag\Composite\CDDBDiscPlayTime(),
                'CDDBDiscTracks' => new \PHPExiftool\Driver\Tag\Composite\CDDBDiscTracks(),
                'CFAPattern' => new \PHPExiftool\Driver\Tag\Composite\CFAPattern(),
                'CircleOfConfusion' => new \PHPExiftool\Driver\Tag\Composite\CircleOfConfusion(),
                'ConditionalFEC' => new \PHPExiftool\Driver\Tag\Composite\ConditionalFEC(),
                'DOF' => new \PHPExiftool\Driver\Tag\Composite\DOF(),
                'DateCreated' => new \PHPExiftool\Driver\Tag\Composite\DateCreated(),
                'DateTimeCreated' => new \PHPExiftool\Driver\Tag\Composite\DateTimeCreated(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\Composite\DateTimeOriginal(),
                'DigitalCreationDateTime' => new \PHPExiftool\Driver\Tag\Composite\DigitalCreationDateTime(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\Composite\DigitalZoom(),
                'DriveMode' => new \PHPExiftool\Driver\Tag\Composite\DriveMode(),
                'Duration' => new \PHPExiftool\Driver\Tag\Composite\Duration(),
                'ExtenderStatus' => new \PHPExiftool\Driver\Tag\Composite\ExtenderStatus(),
                'FOV' => new \PHPExiftool\Driver\Tag\Composite\FOV(),
                'FileNumber' => new \PHPExiftool\Driver\Tag\Composite\FileNumber(),
                'Flash' => new \PHPExiftool\Driver\Tag\Composite\Flash(),
                'FlashType' => new \PHPExiftool\Driver\Tag\Composite\FlashType(),
                'FocalLength35efl' => new \PHPExiftool\Driver\Tag\Composite\FocalLength35efl(),
                'FocusDistance' => new \PHPExiftool\Driver\Tag\Composite\FocusDistance(),
                'FocusDistance2' => new \PHPExiftool\Driver\Tag\Composite\FocusDistance2(),
                'GPSAltitude' => new \PHPExiftool\Driver\Tag\Composite\GPSAltitude(),
                'GPSAltitudeRef' => new \PHPExiftool\Driver\Tag\Composite\GPSAltitudeRef(),
                'GPSDateTime' => new \PHPExiftool\Driver\Tag\Composite\GPSDateTime(),
                'GPSLatitude' => new \PHPExiftool\Driver\Tag\Composite\GPSLatitude(),
                'GPSLatitudeRef' => new \PHPExiftool\Driver\Tag\Composite\GPSLatitudeRef(),
                'GPSLongitude' => new \PHPExiftool\Driver\Tag\Composite\GPSLongitude(),
                'GPSLongitudeRef' => new \PHPExiftool\Driver\Tag\Composite\GPSLongitudeRef(),
                'GPSPosition' => new \PHPExiftool\Driver\Tag\Composite\GPSPosition(),
                'HyperfocalDistance' => new \PHPExiftool\Driver\Tag\Composite\HyperfocalDistance(),
                'IDCPreviewImage' => new \PHPExiftool\Driver\Tag\Composite\IDCPreviewImage(),
                'ISO' => new \PHPExiftool\Driver\Tag\Composite\ISO(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\Composite\ImageHeight(),
                'ImageSize' => new \PHPExiftool\Driver\Tag\Composite\ImageSize(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\Composite\ImageWidth(),
                'JpgFromRaw' => new \PHPExiftool\Driver\Tag\Composite\JpgFromRaw(),
                'Lens' => new \PHPExiftool\Driver\Tag\Composite\Lens(),
                'Lens35efl' => new \PHPExiftool\Driver\Tag\Composite\Lens35efl(),
                'LensID' => new \PHPExiftool\Driver\Tag\Composite\LensID(),
                'LensSpec' => new \PHPExiftool\Driver\Tag\Composite\LensSpec(),
                'LightValue' => new \PHPExiftool\Driver\Tag\Composite\LightValue(),
                'MPImage' => new \PHPExiftool\Driver\Tag\Composite\MPImage(),
                'Megapixels' => new \PHPExiftool\Driver\Tag\Composite\Megapixels(),
                'OriginalDecisionData' => new \PHPExiftool\Driver\Tag\Composite\OriginalDecisionData(),
                'OtherImage' => new \PHPExiftool\Driver\Tag\Composite\OtherImage(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\Composite\PreviewImage(),
                'PreviewImageSize' => new \PHPExiftool\Driver\Tag\Composite\PreviewImageSize(),
                'RedBalance' => new \PHPExiftool\Driver\Tag\Composite\RedBalance(),
                'RedEyeReduction' => new \PHPExiftool\Driver\Tag\Composite\RedEyeReduction(),
                'RicohPitch' => new \PHPExiftool\Driver\Tag\Composite\RicohPitch(),
                'RicohRoll' => new \PHPExiftool\Driver\Tag\Composite\RicohRoll(),
                'Rotation' => new \PHPExiftool\Driver\Tag\Composite\Rotation(),
                'RunTimeSincePowerUp' => new \PHPExiftool\Driver\Tag\Composite\RunTimeSincePowerUp(),
                'ScaleFactor35efl' => new \PHPExiftool\Driver\Tag\Composite\ScaleFactor35efl(),
                'ShootingMode' => new \PHPExiftool\Driver\Tag\Composite\ShootingMode(),
                'ShutterCurtainHack' => new \PHPExiftool\Driver\Tag\Composite\ShutterCurtainHack(),
                'ShutterSpeed' => new \PHPExiftool\Driver\Tag\Composite\ShutterSpeed(),
                'SubSecCreateDate' => new \PHPExiftool\Driver\Tag\Composite\SubSecCreateDate(),
                'SubSecDateTimeOriginal' => new \PHPExiftool\Driver\Tag\Composite\SubSecDateTimeOriginal(),
                'SubSecModifyDate' => new \PHPExiftool\Driver\Tag\Composite\SubSecModifyDate(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\Composite\ThumbnailImage(),
                'WB_RGBLevels' => new \PHPExiftool\Driver\Tag\Composite\WBRGBLevels(),
                'WB_RGGBLevels' => new \PHPExiftool\Driver\Tag\Composite\WBRGGBLevels(),
                'ZoomedPreviewImage' => new \PHPExiftool\Driver\Tag\Composite\ZoomedPreviewImage(),
            );
        });
        $this['MWG'] = $this->share(function(){
            return array(
                'City' => new \PHPExiftool\Driver\Tag\MWG\City(),
                'Copyright' => new \PHPExiftool\Driver\Tag\MWG\Copyright(),
                'Country' => new \PHPExiftool\Driver\Tag\MWG\Country(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\MWG\CreateDate(),
                'Creator' => new \PHPExiftool\Driver\Tag\MWG\Creator(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\MWG\DateTimeOriginal(),
                'Description' => new \PHPExiftool\Driver\Tag\MWG\Description(),
                'Keywords' => new \PHPExiftool\Driver\Tag\MWG\Keywords(),
                'Location' => new \PHPExiftool\Driver\Tag\MWG\Location(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\MWG\ModifyDate(),
                'Orientation' => new \PHPExiftool\Driver\Tag\MWG\Orientation(),
                'Rating' => new \PHPExiftool\Driver\Tag\MWG\Rating(),
                'State' => new \PHPExiftool\Driver\Tag\MWG\State(),
            );
        });
        $this['FLIR'] = $this->share(function(){
            return array(
                'PeakSpectralSensitivity' => new \PHPExiftool\Driver\Tag\FLIR\PeakSpectralSensitivity(),
                'RawDataByteOrder' => new \PHPExiftool\Driver\Tag\FLIR\RawDataByteOrder(),
                'SensorWidth' => new \PHPExiftool\Driver\Tag\FLIR\SensorWidth(),
                'SensorHeight' => new \PHPExiftool\Driver\Tag\FLIR\SensorHeight(),
                'CameraInfoByteOrder' => new \PHPExiftool\Driver\Tag\FLIR\CameraInfoByteOrder(),
                'Emissivity' => new \PHPExiftool\Driver\Tag\FLIR\Emissivity(),
                'ObjectDistance' => new \PHPExiftool\Driver\Tag\FLIR\ObjectDistance(),
                'ReflectedApparentTemperature' => new \PHPExiftool\Driver\Tag\FLIR\ReflectedApparentTemperature(),
                'AtmosphericTemperature' => new \PHPExiftool\Driver\Tag\FLIR\AtmosphericTemperature(),
                'IRWindowTemperature' => new \PHPExiftool\Driver\Tag\FLIR\IRWindowTemperature(),
                'IRWindowTransmission' => new \PHPExiftool\Driver\Tag\FLIR\IRWindowTransmission(),
                'RelativeHumidity' => new \PHPExiftool\Driver\Tag\FLIR\RelativeHumidity(),
                'PlanckR1' => new \PHPExiftool\Driver\Tag\FLIR\PlanckR1(),
                'PlanckB' => new \PHPExiftool\Driver\Tag\FLIR\PlanckB(),
                'PlanckF' => new \PHPExiftool\Driver\Tag\FLIR\PlanckF(),
                'AtmosphericTransAlpha1' => new \PHPExiftool\Driver\Tag\FLIR\AtmosphericTransAlpha1(),
                'AtmosphericTransAlpha2' => new \PHPExiftool\Driver\Tag\FLIR\AtmosphericTransAlpha2(),
                'AtmosphericTransBeta1' => new \PHPExiftool\Driver\Tag\FLIR\AtmosphericTransBeta1(),
                'AtmosphericTransBeta2' => new \PHPExiftool\Driver\Tag\FLIR\AtmosphericTransBeta2(),
                'AtmosphericTransX' => new \PHPExiftool\Driver\Tag\FLIR\AtmosphericTransX(),
                'CameraTemperatureRangeMax' => new \PHPExiftool\Driver\Tag\FLIR\CameraTemperatureRangeMax(),
                'CameraTemperatureRangeMin' => new \PHPExiftool\Driver\Tag\FLIR\CameraTemperatureRangeMin(),
                'UnknownTemperature1' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature1(),
                'UnknownTemperature2' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature2(),
                'UnknownTemperature3' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature3(),
                'UnknownTemperature4' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature4(),
                'UnknownTemperature5' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature5(),
                'UnknownTemperature6' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature6(),
                'CameraModel' => new \PHPExiftool\Driver\Tag\FLIR\CameraModel(),
                'CameraPartNumber' => new \PHPExiftool\Driver\Tag\FLIR\CameraPartNumber(),
                'CameraSerialNumber' => new \PHPExiftool\Driver\Tag\FLIR\CameraSerialNumber(),
                'CameraSoftware' => new \PHPExiftool\Driver\Tag\FLIR\CameraSoftware(),
                'LensModel' => new \PHPExiftool\Driver\Tag\FLIR\LensModel(),
                'LensPartNumber' => new \PHPExiftool\Driver\Tag\FLIR\LensPartNumber(),
                'LensSerialNumber' => new \PHPExiftool\Driver\Tag\FLIR\LensSerialNumber(),
                'FieldOfView' => new \PHPExiftool\Driver\Tag\FLIR\FieldOfView(),
                'FilterModel' => new \PHPExiftool\Driver\Tag\FLIR\FilterModel(),
                'FilterPartNumber' => new \PHPExiftool\Driver\Tag\FLIR\FilterPartNumber(),
                'FilterSerialNumber' => new \PHPExiftool\Driver\Tag\FLIR\FilterSerialNumber(),
                'PlanckO' => new \PHPExiftool\Driver\Tag\FLIR\PlanckO(),
                'PlanckR2' => new \PHPExiftool\Driver\Tag\FLIR\PlanckR2(),
                'RawValueMedian' => new \PHPExiftool\Driver\Tag\FLIR\RawValueMedian(),
                'RawValueRange' => new \PHPExiftool\Driver\Tag\FLIR\RawValueRange(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\FLIR\DateTimeOriginal(),
                'FocusStepCount' => new \PHPExiftool\Driver\Tag\FLIR\FocusStepCount(),
                'FocusDistance' => new \PHPExiftool\Driver\Tag\FLIR\FocusDistance(),
                'CoarseMapByteOrder' => new \PHPExiftool\Driver\Tag\FLIR\CoarseMapByteOrder(),
                'CoarseMapImageWidth' => new \PHPExiftool\Driver\Tag\FLIR\CoarseMapImageWidth(),
                'CoarseMapImageHeight' => new \PHPExiftool\Driver\Tag\FLIR\CoarseMapImageHeight(),
                'CoarseMapImageType' => new \PHPExiftool\Driver\Tag\FLIR\CoarseMapImageType(),
                'CoarseMapImage' => new \PHPExiftool\Driver\Tag\FLIR\CoarseMapImage(),
                'EmbeddedImageByteOrder' => new \PHPExiftool\Driver\Tag\FLIR\EmbeddedImageByteOrder(),
                'EmbeddedImageWidth' => new \PHPExiftool\Driver\Tag\FLIR\EmbeddedImageWidth(),
                'EmbeddedImageHeight' => new \PHPExiftool\Driver\Tag\FLIR\EmbeddedImageHeight(),
                'EmbeddedImageType' => new \PHPExiftool\Driver\Tag\FLIR\EmbeddedImageType(),
                'EmbeddedImage' => new \PHPExiftool\Driver\Tag\FLIR\EmbeddedImage(),
                'EmbeddedAudioFile' => new \PHPExiftool\Driver\Tag\FLIR\EmbeddedAudioFile(),
                'FPFVersion' => new \PHPExiftool\Driver\Tag\FLIR\FPFVersion(),
                'ImageDataOffset' => new \PHPExiftool\Driver\Tag\FLIR\ImageDataOffset(),
                'ImageType' => new \PHPExiftool\Driver\Tag\FLIR\ImageType(),
                'ImagePixelFormat' => new \PHPExiftool\Driver\Tag\FLIR\ImagePixelFormat(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\FLIR\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\FLIR\ImageHeight(),
                'ExternalTriggerCount' => new \PHPExiftool\Driver\Tag\FLIR\ExternalTriggerCount(),
                'SequenceFrameNumber' => new \PHPExiftool\Driver\Tag\FLIR\SequenceFrameNumber(),
                'ComputedAtmosphericTrans' => new \PHPExiftool\Driver\Tag\FLIR\ComputedAtmosphericTrans(),
                'EstimatedAtmosphericTrans' => new \PHPExiftool\Driver\Tag\FLIR\EstimatedAtmosphericTrans(),
                'ReferenceTemperature' => new \PHPExiftool\Driver\Tag\FLIR\ReferenceTemperature(),
                'CameraScaleMin' => new \PHPExiftool\Driver\Tag\FLIR\CameraScaleMin(),
                'CameraScaleMax' => new \PHPExiftool\Driver\Tag\FLIR\CameraScaleMax(),
                'CalculatedScaleMin' => new \PHPExiftool\Driver\Tag\FLIR\CalculatedScaleMin(),
                'CalculatedScaleMax' => new \PHPExiftool\Driver\Tag\FLIR\CalculatedScaleMax(),
                'ActualScaleMin' => new \PHPExiftool\Driver\Tag\FLIR\ActualScaleMin(),
                'ActualScaleMax' => new \PHPExiftool\Driver\Tag\FLIR\ActualScaleMax(),
                'GPSMapDatum' => new \PHPExiftool\Driver\Tag\FLIR\GPSMapDatum(),
                'GPSLatitude' => new \PHPExiftool\Driver\Tag\FLIR\GPSLatitude(),
                'GPSLongitude' => new \PHPExiftool\Driver\Tag\FLIR\GPSLongitude(),
                'GPSAltitude' => new \PHPExiftool\Driver\Tag\FLIR\GPSAltitude(),
                'GainDeadMapByteOrder' => new \PHPExiftool\Driver\Tag\FLIR\GainDeadMapByteOrder(),
                'GainDeadMapImageWidth' => new \PHPExiftool\Driver\Tag\FLIR\GainDeadMapImageWidth(),
                'GainDeadMapImageHeight' => new \PHPExiftool\Driver\Tag\FLIR\GainDeadMapImageHeight(),
                'GainDeadMapImageType' => new \PHPExiftool\Driver\Tag\FLIR\GainDeadMapImageType(),
                'GainDeadMapImage' => new \PHPExiftool\Driver\Tag\FLIR\GainDeadMapImage(),
                'CreatorSoftware' => new \PHPExiftool\Driver\Tag\FLIR\CreatorSoftware(),
                'ImageTemperatureMax' => new \PHPExiftool\Driver\Tag\FLIR\ImageTemperatureMax(),
                'ImageTemperatureMin' => new \PHPExiftool\Driver\Tag\FLIR\ImageTemperatureMin(),
                'UnknownTemperature' => new \PHPExiftool\Driver\Tag\FLIR\UnknownTemperature(),
                'Meas1Label' => new \PHPExiftool\Driver\Tag\FLIR\Meas1Label(),
                'Meas1Params' => new \PHPExiftool\Driver\Tag\FLIR\Meas1Params(),
                'Meas1Type' => new \PHPExiftool\Driver\Tag\FLIR\Meas1Type(),
                'Reading1Units' => new \PHPExiftool\Driver\Tag\FLIR\Reading1Units(),
                'Reading1Description' => new \PHPExiftool\Driver\Tag\FLIR\Reading1Description(),
                'Reading1Device' => new \PHPExiftool\Driver\Tag\FLIR\Reading1Device(),
                'Reading1Value' => new \PHPExiftool\Driver\Tag\FLIR\Reading1Value(),
                'Reading2Units' => new \PHPExiftool\Driver\Tag\FLIR\Reading2Units(),
                'Reading2Description' => new \PHPExiftool\Driver\Tag\FLIR\Reading2Description(),
                'Reading2Device' => new \PHPExiftool\Driver\Tag\FLIR\Reading2Device(),
                'Reading2Value' => new \PHPExiftool\Driver\Tag\FLIR\Reading2Value(),
                'Reading3Units' => new \PHPExiftool\Driver\Tag\FLIR\Reading3Units(),
                'Reading3Description' => new \PHPExiftool\Driver\Tag\FLIR\Reading3Description(),
                'Reading3Device' => new \PHPExiftool\Driver\Tag\FLIR\Reading3Device(),
                'Reading3Value' => new \PHPExiftool\Driver\Tag\FLIR\Reading3Value(),
                'Reading4Units' => new \PHPExiftool\Driver\Tag\FLIR\Reading4Units(),
                'Reading4Description' => new \PHPExiftool\Driver\Tag\FLIR\Reading4Description(),
                'Reading4Device' => new \PHPExiftool\Driver\Tag\FLIR\Reading4Device(),
                'Reading4Value' => new \PHPExiftool\Driver\Tag\FLIR\Reading4Value(),
                'PaintByteOrder' => new \PHPExiftool\Driver\Tag\FLIR\PaintByteOrder(),
                'PaintImageWidth' => new \PHPExiftool\Driver\Tag\FLIR\PaintImageWidth(),
                'PaintImageHeight' => new \PHPExiftool\Driver\Tag\FLIR\PaintImageHeight(),
                'PaintImageType' => new \PHPExiftool\Driver\Tag\FLIR\PaintImageType(),
                'PaintImage' => new \PHPExiftool\Driver\Tag\FLIR\PaintImage(),
                'PaletteColors' => new \PHPExiftool\Driver\Tag\FLIR\PaletteColors(),
                'AboveColor' => new \PHPExiftool\Driver\Tag\FLIR\AboveColor(),
                'BelowColor' => new \PHPExiftool\Driver\Tag\FLIR\BelowColor(),
                'OverflowColor' => new \PHPExiftool\Driver\Tag\FLIR\OverflowColor(),
                'UnderflowColor' => new \PHPExiftool\Driver\Tag\FLIR\UnderflowColor(),
                'Isotherm1Color' => new \PHPExiftool\Driver\Tag\FLIR\Isotherm1Color(),
                'Isotherm2Color' => new \PHPExiftool\Driver\Tag\FLIR\Isotherm2Color(),
                'PaletteMethod' => new \PHPExiftool\Driver\Tag\FLIR\PaletteMethod(),
                'PaletteStretch' => new \PHPExiftool\Driver\Tag\FLIR\PaletteStretch(),
                'PaletteFileName' => new \PHPExiftool\Driver\Tag\FLIR\PaletteFileName(),
                'PaletteName' => new \PHPExiftool\Driver\Tag\FLIR\PaletteName(),
                'Palette' => new \PHPExiftool\Driver\Tag\FLIR\Palette(),
                'DateTimeGenerated' => new \PHPExiftool\Driver\Tag\FLIR\DateTimeGenerated(),
                'Param0' => new \PHPExiftool\Driver\Tag\FLIR\Param0(),
                'Param1' => new \PHPExiftool\Driver\Tag\FLIR\Param1(),
                'Param2' => new \PHPExiftool\Driver\Tag\FLIR\Param2(),
                'Param3' => new \PHPExiftool\Driver\Tag\FLIR\Param3(),
                'BAHPVer' => new \PHPExiftool\Driver\Tag\FLIR\BAHPVer(),
                'BALPVer' => new \PHPExiftool\Driver\Tag\FLIR\BALPVer(),
                'Battery' => new \PHPExiftool\Driver\Tag\FLIR\Battery(),
                'BAVPVer' => new \PHPExiftool\Driver\Tag\FLIR\BAVPVer(),
                'CamCore' => new \PHPExiftool\Driver\Tag\FLIR\CamCore(),
                'DetectorBoard' => new \PHPExiftool\Driver\Tag\FLIR\DetectorBoard(),
                'Detector' => new \PHPExiftool\Driver\Tag\FLIR\Detector(),
                'GIDCVer' => new \PHPExiftool\Driver\Tag\FLIR\GIDCVer(),
                'GIDPVer' => new \PHPExiftool\Driver\Tag\FLIR\GIDPVer(),
                'GIPC_CPLD' => new \PHPExiftool\Driver\Tag\FLIR\GIPCCPLD(),
                'GIPCVer' => new \PHPExiftool\Driver\Tag\FLIR\GIPCVer(),
                'GIXIVer' => new \PHPExiftool\Driver\Tag\FLIR\GIXIVer(),
                'MainBoard' => new \PHPExiftool\Driver\Tag\FLIR\MainBoard(),
                'Optics' => new \PHPExiftool\Driver\Tag\FLIR\Optics(),
                'PartNumber' => new \PHPExiftool\Driver\Tag\FLIR\PartNumber(),
                'Real2IR' => new \PHPExiftool\Driver\Tag\FLIR\Real2IR(),
                'OffsetX' => new \PHPExiftool\Driver\Tag\FLIR\OffsetX(),
                'OffsetY' => new \PHPExiftool\Driver\Tag\FLIR\OffsetY(),
                'PiPX1' => new \PHPExiftool\Driver\Tag\FLIR\PiPX1(),
                'PiPX2' => new \PHPExiftool\Driver\Tag\FLIR\PiPX2(),
                'PiPY1' => new \PHPExiftool\Driver\Tag\FLIR\PiPY1(),
                'PiPY2' => new \PHPExiftool\Driver\Tag\FLIR\PiPY2(),
                'RawThermalImageWidth' => new \PHPExiftool\Driver\Tag\FLIR\RawThermalImageWidth(),
                'RawThermalImageHeight' => new \PHPExiftool\Driver\Tag\FLIR\RawThermalImageHeight(),
                'RawThermalImageType' => new \PHPExiftool\Driver\Tag\FLIR\RawThermalImageType(),
                'RawThermalImage' => new \PHPExiftool\Driver\Tag\FLIR\RawThermalImage(),
                'UnknownSerial1' => new \PHPExiftool\Driver\Tag\FLIR\UnknownSerial1(),
                'UnknownSerial2' => new \PHPExiftool\Driver\Tag\FLIR\UnknownSerial2(),
                'UnknownSerial3' => new \PHPExiftool\Driver\Tag\FLIR\UnknownSerial3(),
                'UnknownSerial4' => new \PHPExiftool\Driver\Tag\FLIR\UnknownSerial4(),
                'UnknownNumber' => new \PHPExiftool\Driver\Tag\FLIR\UnknownNumber(),
                'Label0' => new \PHPExiftool\Driver\Tag\FLIR\Label0(),
                'Label1' => new \PHPExiftool\Driver\Tag\FLIR\Label1(),
                'Label2' => new \PHPExiftool\Driver\Tag\FLIR\Label2(),
                'Label3' => new \PHPExiftool\Driver\Tag\FLIR\Label3(),
                'Value0' => new \PHPExiftool\Driver\Tag\FLIR\Value0(),
                'Value1' => new \PHPExiftool\Driver\Tag\FLIR\Value1(),
                'Value2' => new \PHPExiftool\Driver\Tag\FLIR\Value2(),
                'Value3' => new \PHPExiftool\Driver\Tag\FLIR\Value3(),
                'SoftwareComponents' => new \PHPExiftool\Driver\Tag\FLIR\SoftwareComponents(),
                'FLIR_Unknown' => new \PHPExiftool\Driver\Tag\FLIR\FLIRUnknown(),
                'Units' => new \PHPExiftool\Driver\Tag\FLIR\Units(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\FLIR\ThumbnailImage(),
            );
        });
        $this['DICOM'] = $this->share(function(){
            return array(
                'FileMetaInfoGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\FileMetaInfoGroupLength(),
                'FileMetaInfoVersion' => new \PHPExiftool\Driver\Tag\DICOM\FileMetaInfoVersion(),
                'MediaStorageSOPClassUID' => new \PHPExiftool\Driver\Tag\DICOM\MediaStorageSOPClassUID(),
                'MediaStorageSOPInstanceUID' => new \PHPExiftool\Driver\Tag\DICOM\MediaStorageSOPInstanceUID(),
                'TransferSyntaxUID' => new \PHPExiftool\Driver\Tag\DICOM\TransferSyntaxUID(),
                'ImplementationClassUID' => new \PHPExiftool\Driver\Tag\DICOM\ImplementationClassUID(),
                'ImplementationVersionName' => new \PHPExiftool\Driver\Tag\DICOM\ImplementationVersionName(),
                'SourceApplicationEntityTitle' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicationEntityTitle(),
                'PrivateInformationCreatorUID' => new \PHPExiftool\Driver\Tag\DICOM\PrivateInformationCreatorUID(),
                'PrivateInformation' => new \PHPExiftool\Driver\Tag\DICOM\PrivateInformation(),
                'FileSetID' => new \PHPExiftool\Driver\Tag\DICOM\FileSetID(),
                'FileSetDescriptorFileID' => new \PHPExiftool\Driver\Tag\DICOM\FileSetDescriptorFileID(),
                'SpecificCharacterSetOfFile' => new \PHPExiftool\Driver\Tag\DICOM\SpecificCharacterSetOfFile(),
                'FirstDirectoryRecordOffset' => new \PHPExiftool\Driver\Tag\DICOM\FirstDirectoryRecordOffset(),
                'LastDirectoryRecordOffset' => new \PHPExiftool\Driver\Tag\DICOM\LastDirectoryRecordOffset(),
                'FileSetConsistencyFlag' => new \PHPExiftool\Driver\Tag\DICOM\FileSetConsistencyFlag(),
                'DirectoryRecordSequence' => new \PHPExiftool\Driver\Tag\DICOM\DirectoryRecordSequence(),
                'OffsetOfNextDirectoryRecord' => new \PHPExiftool\Driver\Tag\DICOM\OffsetOfNextDirectoryRecord(),
                'RecordInUseFlag' => new \PHPExiftool\Driver\Tag\DICOM\RecordInUseFlag(),
                'LowerLevelDirectoryEntityOffset' => new \PHPExiftool\Driver\Tag\DICOM\LowerLevelDirectoryEntityOffset(),
                'DirectoryRecordType' => new \PHPExiftool\Driver\Tag\DICOM\DirectoryRecordType(),
                'PrivateRecordUID' => new \PHPExiftool\Driver\Tag\DICOM\PrivateRecordUID(),
                'ReferencedFileID' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFileID(),
                'MRDRDirectoryRecordOffset' => new \PHPExiftool\Driver\Tag\DICOM\MRDRDirectoryRecordOffset(),
                'ReferencedSOPClassUIDInFile' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSOPClassUIDInFile(),
                'ReferencedSOPInstanceUIDInFile' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSOPInstanceUIDInFile(),
                'ReferencedTransferSyntaxUIDInFile' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedTransferSyntaxUIDInFile(),
                'ReferencedRelatedSOPClassUIDInFile' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedRelatedSOPClassUIDInFile(),
                'NumberOfReferences' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfReferences(),
                'IdentifyingGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\IdentifyingGroupLength(),
                'LengthToEnd' => new \PHPExiftool\Driver\Tag\DICOM\LengthToEnd(),
                'SpecificCharacterSet' => new \PHPExiftool\Driver\Tag\DICOM\SpecificCharacterSet(),
                'LanguageCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\LanguageCodeSequence(),
                'ImageType' => new \PHPExiftool\Driver\Tag\DICOM\ImageType(),
                'RecognitionCode' => new \PHPExiftool\Driver\Tag\DICOM\RecognitionCode(),
                'InstanceCreationDate' => new \PHPExiftool\Driver\Tag\DICOM\InstanceCreationDate(),
                'InstanceCreationTime' => new \PHPExiftool\Driver\Tag\DICOM\InstanceCreationTime(),
                'InstanceCreatorUID' => new \PHPExiftool\Driver\Tag\DICOM\InstanceCreatorUID(),
                'SOPClassUID' => new \PHPExiftool\Driver\Tag\DICOM\SOPClassUID(),
                'SOPInstanceUID' => new \PHPExiftool\Driver\Tag\DICOM\SOPInstanceUID(),
                'RelatedGeneralSOPClassUID' => new \PHPExiftool\Driver\Tag\DICOM\RelatedGeneralSOPClassUID(),
                'OriginalSpecializedSOPClassUID' => new \PHPExiftool\Driver\Tag\DICOM\OriginalSpecializedSOPClassUID(),
                'StudyDate' => new \PHPExiftool\Driver\Tag\DICOM\StudyDate(),
                'SeriesDate' => new \PHPExiftool\Driver\Tag\DICOM\SeriesDate(),
                'AcquisitionDate' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionDate(),
                'ContentDate' => new \PHPExiftool\Driver\Tag\DICOM\ContentDate(),
                'OverlayDate' => new \PHPExiftool\Driver\Tag\DICOM\OverlayDate(),
                'CurveDate' => new \PHPExiftool\Driver\Tag\DICOM\CurveDate(),
                'AcquisitionDateTime' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionDateTime(),
                'StudyTime' => new \PHPExiftool\Driver\Tag\DICOM\StudyTime(),
                'SeriesTime' => new \PHPExiftool\Driver\Tag\DICOM\SeriesTime(),
                'AcquisitionTime' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionTime(),
                'ContentTime' => new \PHPExiftool\Driver\Tag\DICOM\ContentTime(),
                'OverlayTime' => new \PHPExiftool\Driver\Tag\DICOM\OverlayTime(),
                'CurveTime' => new \PHPExiftool\Driver\Tag\DICOM\CurveTime(),
                'DataSetType' => new \PHPExiftool\Driver\Tag\DICOM\DataSetType(),
                'DataSetSubtype' => new \PHPExiftool\Driver\Tag\DICOM\DataSetSubtype(),
                'NuclearMedicineSeriesType' => new \PHPExiftool\Driver\Tag\DICOM\NuclearMedicineSeriesType(),
                'AccessionNumber' => new \PHPExiftool\Driver\Tag\DICOM\AccessionNumber(),
                'QueryRetrieveLevel' => new \PHPExiftool\Driver\Tag\DICOM\QueryRetrieveLevel(),
                'RetrieveAETitle' => new \PHPExiftool\Driver\Tag\DICOM\RetrieveAETitle(),
                'InstanceAvailability' => new \PHPExiftool\Driver\Tag\DICOM\InstanceAvailability(),
                'FailedSOPInstanceUIDList' => new \PHPExiftool\Driver\Tag\DICOM\FailedSOPInstanceUIDList(),
                'Modality' => new \PHPExiftool\Driver\Tag\DICOM\Modality(),
                'ModalitiesInStudy' => new \PHPExiftool\Driver\Tag\DICOM\ModalitiesInStudy(),
                'SOPClassesInStudy' => new \PHPExiftool\Driver\Tag\DICOM\SOPClassesInStudy(),
                'ConversionType' => new \PHPExiftool\Driver\Tag\DICOM\ConversionType(),
                'PresentationIntentType' => new \PHPExiftool\Driver\Tag\DICOM\PresentationIntentType(),
                'Manufacturer' => new \PHPExiftool\Driver\Tag\DICOM\Manufacturer(),
                'InstitutionName' => new \PHPExiftool\Driver\Tag\DICOM\InstitutionName(),
                'InstitutionAddress' => new \PHPExiftool\Driver\Tag\DICOM\InstitutionAddress(),
                'InstitutionCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\InstitutionCodeSequence(),
                'ReferringPhysicianName' => new \PHPExiftool\Driver\Tag\DICOM\ReferringPhysicianName(),
                'ReferringPhysicianAddress' => new \PHPExiftool\Driver\Tag\DICOM\ReferringPhysicianAddress(),
                'ReferringPhysicianTelephoneNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferringPhysicianTelephoneNumber(),
                'ReferringPhysicianIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferringPhysicianIDSequence(),
                'CodeValue' => new \PHPExiftool\Driver\Tag\DICOM\CodeValue(),
                'CodingSchemeDesignator' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeDesignator(),
                'CodingSchemeVersion' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeVersion(),
                'CodeMeaning' => new \PHPExiftool\Driver\Tag\DICOM\CodeMeaning(),
                'MappingResource' => new \PHPExiftool\Driver\Tag\DICOM\MappingResource(),
                'ContextGroupVersion' => new \PHPExiftool\Driver\Tag\DICOM\ContextGroupVersion(),
                'ContextGroupLocalVersion' => new \PHPExiftool\Driver\Tag\DICOM\ContextGroupLocalVersion(),
                'ContextGroupExtensionFlag' => new \PHPExiftool\Driver\Tag\DICOM\ContextGroupExtensionFlag(),
                'CodingSchemeUID' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeUID(),
                'ContextGroupExtensionCreatorUID' => new \PHPExiftool\Driver\Tag\DICOM\ContextGroupExtensionCreatorUID(),
                'ContextIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\ContextIdentifier(),
                'CodingSchemeIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeIDSequence(),
                'CodingSchemeRegistry' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeRegistry(),
                'CodingSchemeExternalID' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeExternalID(),
                'CodingSchemeName' => new \PHPExiftool\Driver\Tag\DICOM\CodingSchemeName(),
                'ResponsibleOrganization' => new \PHPExiftool\Driver\Tag\DICOM\ResponsibleOrganization(),
                'ContextUID' => new \PHPExiftool\Driver\Tag\DICOM\ContextUID(),
                'TimezoneOffsetFromUTC' => new \PHPExiftool\Driver\Tag\DICOM\TimezoneOffsetFromUTC(),
                'NetworkID' => new \PHPExiftool\Driver\Tag\DICOM\NetworkID(),
                'StationName' => new \PHPExiftool\Driver\Tag\DICOM\StationName(),
                'StudyDescription' => new \PHPExiftool\Driver\Tag\DICOM\StudyDescription(),
                'ProcedureCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ProcedureCodeSequence(),
                'SeriesDescription' => new \PHPExiftool\Driver\Tag\DICOM\SeriesDescription(),
                'InstitutionalDepartmentName' => new \PHPExiftool\Driver\Tag\DICOM\InstitutionalDepartmentName(),
                'PhysiciansOfRecord' => new \PHPExiftool\Driver\Tag\DICOM\PhysiciansOfRecord(),
                'PhysiciansOfRecordIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\PhysiciansOfRecordIDSequence(),
                'PerformingPhysicianName' => new \PHPExiftool\Driver\Tag\DICOM\PerformingPhysicianName(),
                'PerformingPhysicianIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformingPhysicianIDSequence(),
                'NameOfPhysicianReadingStudy' => new \PHPExiftool\Driver\Tag\DICOM\NameOfPhysicianReadingStudy(),
                'PhysicianReadingStudyIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\PhysicianReadingStudyIDSequence(),
                'OperatorsName' => new \PHPExiftool\Driver\Tag\DICOM\OperatorsName(),
                'OperatorIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\OperatorIDSequence(),
                'AdmittingDiagnosesDescription' => new \PHPExiftool\Driver\Tag\DICOM\AdmittingDiagnosesDescription(),
                'AdmittingDiagnosesCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\AdmittingDiagnosesCodeSequence(),
                'ManufacturersModelName' => new \PHPExiftool\Driver\Tag\DICOM\ManufacturersModelName(),
                'ReferencedResultsSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedResultsSequence(),
                'ReferencedStudySequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedStudySequence(),
                'ReferencedProcedureStepSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedProcedureStepSequence(),
                'ReferencedSeriesSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSeriesSequence(),
                'ReferencedPatientSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedPatientSequence(),
                'ReferencedVisitSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedVisitSequence(),
                'ReferencedOverlaySequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedOverlaySequence(),
                'ReferencedWaveformSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedWaveformSequence(),
                'ReferencedImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedImageSequence(),
                'ReferencedCurveSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedCurveSequence(),
                'ReferencedInstanceSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedInstanceSequence(),
                'ReferencedSOPClassUID' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSOPClassUID(),
                'ReferencedSOPInstanceUID' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSOPInstanceUID(),
                'SOPClassesSupported' => new \PHPExiftool\Driver\Tag\DICOM\SOPClassesSupported(),
                'ReferencedFrameNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFrameNumber(),
                'SimpleFrameList' => new \PHPExiftool\Driver\Tag\DICOM\SimpleFrameList(),
                'CalculatedFrameList' => new \PHPExiftool\Driver\Tag\DICOM\CalculatedFrameList(),
                'TimeRange' => new \PHPExiftool\Driver\Tag\DICOM\TimeRange(),
                'FrameExtractionSequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameExtractionSequence(),
                'TransactionUID' => new \PHPExiftool\Driver\Tag\DICOM\TransactionUID(),
                'FailureReason' => new \PHPExiftool\Driver\Tag\DICOM\FailureReason(),
                'FailedSOPSequence' => new \PHPExiftool\Driver\Tag\DICOM\FailedSOPSequence(),
                'ReferencedSOPSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSOPSequence(),
                'OtherReferencedStudiesSequence' => new \PHPExiftool\Driver\Tag\DICOM\OtherReferencedStudiesSequence(),
                'RelatedSeriesSequence' => new \PHPExiftool\Driver\Tag\DICOM\RelatedSeriesSequence(),
                'LossyImageCompression' => new \PHPExiftool\Driver\Tag\DICOM\LossyImageCompression(),
                'DerivationDescription' => new \PHPExiftool\Driver\Tag\DICOM\DerivationDescription(),
                'SourceImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\SourceImageSequence(),
                'StageName' => new \PHPExiftool\Driver\Tag\DICOM\StageName(),
                'StageNumber' => new \PHPExiftool\Driver\Tag\DICOM\StageNumber(),
                'NumberOfStages' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfStages(),
                'ViewName' => new \PHPExiftool\Driver\Tag\DICOM\ViewName(),
                'ViewNumber' => new \PHPExiftool\Driver\Tag\DICOM\ViewNumber(),
                'NumberOfEventTimers' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfEventTimers(),
                'NumberOfViewsInStage' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViewsInStage(),
                'EventElapsedTimes' => new \PHPExiftool\Driver\Tag\DICOM\EventElapsedTimes(),
                'EventTimerNames' => new \PHPExiftool\Driver\Tag\DICOM\EventTimerNames(),
                'EventTimerSequence' => new \PHPExiftool\Driver\Tag\DICOM\EventTimerSequence(),
                'EventTimeOffset' => new \PHPExiftool\Driver\Tag\DICOM\EventTimeOffset(),
                'EventCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\EventCodeSequence(),
                'StartTrim' => new \PHPExiftool\Driver\Tag\DICOM\StartTrim(),
                'StopTrim' => new \PHPExiftool\Driver\Tag\DICOM\StopTrim(),
                'RecommendedDisplayFrameRate' => new \PHPExiftool\Driver\Tag\DICOM\RecommendedDisplayFrameRate(),
                'TransducerPosition' => new \PHPExiftool\Driver\Tag\DICOM\TransducerPosition(),
                'TransducerOrientation' => new \PHPExiftool\Driver\Tag\DICOM\TransducerOrientation(),
                'AnatomicStructure' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicStructure(),
                'AnatomicRegionSequence' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicRegionSequence(),
                'AnatomicRegionModifierSequence' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicRegionModifierSequence(),
                'PrimaryAnatomicStructureSequence' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryAnatomicStructureSequence(),
                'AnatomicStructureOrRegionSequence' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicStructureOrRegionSequence(),
                'AnatomicStructureModifierSequence' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicStructureModifierSequence(),
                'TransducerPositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\TransducerPositionSequence(),
                'TransducerPositionModifierSequence' => new \PHPExiftool\Driver\Tag\DICOM\TransducerPositionModifierSequence(),
                'TransducerOrientationSequence' => new \PHPExiftool\Driver\Tag\DICOM\TransducerOrientationSequence(),
                'TransducerOrientationModifierSeq' => new \PHPExiftool\Driver\Tag\DICOM\TransducerOrientationModifierSeq(),
                'AnatomicEntrancePortalCodeSeqTrial' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicEntrancePortalCodeSeqTrial(),
                'AnatomicApproachDirCodeSeqTrial' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicApproachDirCodeSeqTrial(),
                'AnatomicPerspectiveDescrTrial' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicPerspectiveDescrTrial(),
                'AnatomicPerspectiveCodeSeqTrial' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicPerspectiveCodeSeqTrial(),
                'AlternateRepresentationSequence' => new \PHPExiftool\Driver\Tag\DICOM\AlternateRepresentationSequence(),
                'IrradiationEventUID' => new \PHPExiftool\Driver\Tag\DICOM\IrradiationEventUID(),
                'IdentifyingComments' => new \PHPExiftool\Driver\Tag\DICOM\IdentifyingComments(),
                'FrameType' => new \PHPExiftool\Driver\Tag\DICOM\FrameType(),
                'ReferencedImageEvidenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedImageEvidenceSequence(),
                'ReferencedRawDataSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedRawDataSequence(),
                'CreatorVersionUID' => new \PHPExiftool\Driver\Tag\DICOM\CreatorVersionUID(),
                'DerivationImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\DerivationImageSequence(),
                'SourceImageEvidenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\SourceImageEvidenceSequence(),
                'PixelPresentation' => new \PHPExiftool\Driver\Tag\DICOM\PixelPresentation(),
                'VolumetricProperties' => new \PHPExiftool\Driver\Tag\DICOM\VolumetricProperties(),
                'VolumeBasedCalculationTechnique' => new \PHPExiftool\Driver\Tag\DICOM\VolumeBasedCalculationTechnique(),
                'ComplexImageComponent' => new \PHPExiftool\Driver\Tag\DICOM\ComplexImageComponent(),
                'AcquisitionContrast' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionContrast(),
                'DerivationCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\DerivationCodeSequence(),
                'GrayscalePresentationStateSequence' => new \PHPExiftool\Driver\Tag\DICOM\GrayscalePresentationStateSequence(),
                'ReferencedOtherPlaneSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedOtherPlaneSequence(),
                'FrameDisplaySequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameDisplaySequence(),
                'RecommendedDisplayFrameRateInFloat' => new \PHPExiftool\Driver\Tag\DICOM\RecommendedDisplayFrameRateInFloat(),
                'SkipFrameRangeFlag' => new \PHPExiftool\Driver\Tag\DICOM\SkipFrameRangeFlag(),
                'FullFidelity' => new \PHPExiftool\Driver\Tag\DICOM\FullFidelity(),
                'SuiteID' => new \PHPExiftool\Driver\Tag\DICOM\SuiteID(),
                'ProductID' => new \PHPExiftool\Driver\Tag\DICOM\ProductID(),
                'ImageActualDate' => new \PHPExiftool\Driver\Tag\DICOM\ImageActualDate(),
                'ServiceID' => new \PHPExiftool\Driver\Tag\DICOM\ServiceID(),
                'MobileLocationNumber' => new \PHPExiftool\Driver\Tag\DICOM\MobileLocationNumber(),
                'EquipmentUID' => new \PHPExiftool\Driver\Tag\DICOM\EquipmentUID(),
                'GenesisVersionNow' => new \PHPExiftool\Driver\Tag\DICOM\GenesisVersionNow(),
                'ExamRecordChecksum' => new \PHPExiftool\Driver\Tag\DICOM\ExamRecordChecksum(),
                'ActualSeriesDataTimeStamp' => new \PHPExiftool\Driver\Tag\DICOM\ActualSeriesDataTimeStamp(),
                'PatientGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\PatientGroupLength(),
                'PatientName' => new \PHPExiftool\Driver\Tag\DICOM\PatientName(),
                'PatientID' => new \PHPExiftool\Driver\Tag\DICOM\PatientID(),
                'IssuerOfPatientID' => new \PHPExiftool\Driver\Tag\DICOM\IssuerOfPatientID(),
                'TypeOfPatientID' => new \PHPExiftool\Driver\Tag\DICOM\TypeOfPatientID(),
                'PatientBirthDate' => new \PHPExiftool\Driver\Tag\DICOM\PatientBirthDate(),
                'PatientBirthTime' => new \PHPExiftool\Driver\Tag\DICOM\PatientBirthTime(),
                'PatientSex' => new \PHPExiftool\Driver\Tag\DICOM\PatientSex(),
                'PatientInsurancePlanCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PatientInsurancePlanCodeSequence(),
                'PatientPrimaryLanguageCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\PatientPrimaryLanguageCodeSeq(),
                'PatientPrimaryLanguageCodeModSeq' => new \PHPExiftool\Driver\Tag\DICOM\PatientPrimaryLanguageCodeModSeq(),
                'OtherPatientIDs' => new \PHPExiftool\Driver\Tag\DICOM\OtherPatientIDs(),
                'OtherPatientNames' => new \PHPExiftool\Driver\Tag\DICOM\OtherPatientNames(),
                'OtherPatientIDsSequence' => new \PHPExiftool\Driver\Tag\DICOM\OtherPatientIDsSequence(),
                'PatientBirthName' => new \PHPExiftool\Driver\Tag\DICOM\PatientBirthName(),
                'PatientAge' => new \PHPExiftool\Driver\Tag\DICOM\PatientAge(),
                'PatientSize' => new \PHPExiftool\Driver\Tag\DICOM\PatientSize(),
                'PatientWeight' => new \PHPExiftool\Driver\Tag\DICOM\PatientWeight(),
                'PatientAddress' => new \PHPExiftool\Driver\Tag\DICOM\PatientAddress(),
                'InsurancePlanIdentification' => new \PHPExiftool\Driver\Tag\DICOM\InsurancePlanIdentification(),
                'PatientMotherBirthName' => new \PHPExiftool\Driver\Tag\DICOM\PatientMotherBirthName(),
                'MilitaryRank' => new \PHPExiftool\Driver\Tag\DICOM\MilitaryRank(),
                'BranchOfService' => new \PHPExiftool\Driver\Tag\DICOM\BranchOfService(),
                'MedicalRecordLocator' => new \PHPExiftool\Driver\Tag\DICOM\MedicalRecordLocator(),
                'MedicalAlerts' => new \PHPExiftool\Driver\Tag\DICOM\MedicalAlerts(),
                'Allergies' => new \PHPExiftool\Driver\Tag\DICOM\Allergies(),
                'CountryOfResidence' => new \PHPExiftool\Driver\Tag\DICOM\CountryOfResidence(),
                'RegionOfResidence' => new \PHPExiftool\Driver\Tag\DICOM\RegionOfResidence(),
                'PatientTelephoneNumbers' => new \PHPExiftool\Driver\Tag\DICOM\PatientTelephoneNumbers(),
                'EthnicGroup' => new \PHPExiftool\Driver\Tag\DICOM\EthnicGroup(),
                'Occupation' => new \PHPExiftool\Driver\Tag\DICOM\Occupation(),
                'SmokingStatus' => new \PHPExiftool\Driver\Tag\DICOM\SmokingStatus(),
                'AdditionalPatientHistory' => new \PHPExiftool\Driver\Tag\DICOM\AdditionalPatientHistory(),
                'PregnancyStatus' => new \PHPExiftool\Driver\Tag\DICOM\PregnancyStatus(),
                'LastMenstrualDate' => new \PHPExiftool\Driver\Tag\DICOM\LastMenstrualDate(),
                'PatientReligiousPreference' => new \PHPExiftool\Driver\Tag\DICOM\PatientReligiousPreference(),
                'PatientSpeciesDescription' => new \PHPExiftool\Driver\Tag\DICOM\PatientSpeciesDescription(),
                'PatientSpeciesCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PatientSpeciesCodeSequence(),
                'PatientSexNeutered' => new \PHPExiftool\Driver\Tag\DICOM\PatientSexNeutered(),
                'AnatomicalOrientationType' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicalOrientationType(),
                'PatientBreedDescription' => new \PHPExiftool\Driver\Tag\DICOM\PatientBreedDescription(),
                'PatientBreedCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PatientBreedCodeSequence(),
                'BreedRegistrationSequence' => new \PHPExiftool\Driver\Tag\DICOM\BreedRegistrationSequence(),
                'BreedRegistrationNumber' => new \PHPExiftool\Driver\Tag\DICOM\BreedRegistrationNumber(),
                'BreedRegistryCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\BreedRegistryCodeSequence(),
                'ResponsiblePerson' => new \PHPExiftool\Driver\Tag\DICOM\ResponsiblePerson(),
                'ResponsiblePersonRole' => new \PHPExiftool\Driver\Tag\DICOM\ResponsiblePersonRole(),
                'PatientComments' => new \PHPExiftool\Driver\Tag\DICOM\PatientComments(),
                'ExaminedBodyThickness' => new \PHPExiftool\Driver\Tag\DICOM\ExaminedBodyThickness(),
                'PatientStatus' => new \PHPExiftool\Driver\Tag\DICOM\PatientStatus(),
                'ClinicalTrialSponsorName' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSponsorName(),
                'ClinicalTrialProtocolID' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialProtocolID(),
                'ClinicalTrialProtocolName' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialProtocolName(),
                'ClinicalTrialSiteID' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSiteID(),
                'ClinicalTrialSiteName' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSiteName(),
                'ClinicalTrialSubjectID' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSubjectID(),
                'ClinicalTrialSubjectReadingID' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSubjectReadingID(),
                'ClinicalTrialTimePointID' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialTimePointID(),
                'ClinicalTrialTimePointDescription' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialTimePointDescription(),
                'ClinicalTrialCoordinatingCenter' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialCoordinatingCenter(),
                'PatientIdentityRemoved' => new \PHPExiftool\Driver\Tag\DICOM\PatientIdentityRemoved(),
                'DeidentificationMethod' => new \PHPExiftool\Driver\Tag\DICOM\DeidentificationMethod(),
                'DeidentificationMethodCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\DeidentificationMethodCodeSequence(),
                'ClinicalTrialSeriesID' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSeriesID(),
                'ClinicalTrialSeriesDescription' => new \PHPExiftool\Driver\Tag\DICOM\ClinicalTrialSeriesDescription(),
                'DistributionType' => new \PHPExiftool\Driver\Tag\DICOM\DistributionType(),
                'ConsentForDistributionFlag' => new \PHPExiftool\Driver\Tag\DICOM\ConsentForDistributionFlag(),
                'AcquisitionGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionGroupLength(),
                'ContrastBolusAgent' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAgent(),
                'ContrastBolusAgentSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAgentSequence(),
                'ContrastBolusAdministrationRoute' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAdministrationRoute(),
                'BodyPartExamined' => new \PHPExiftool\Driver\Tag\DICOM\BodyPartExamined(),
                'ScanningSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScanningSequence(),
                'SequenceVariant' => new \PHPExiftool\Driver\Tag\DICOM\SequenceVariant(),
                'ScanOptions' => new \PHPExiftool\Driver\Tag\DICOM\ScanOptions(),
                'MRAcquisitionType' => new \PHPExiftool\Driver\Tag\DICOM\MRAcquisitionType(),
                'SequenceName' => new \PHPExiftool\Driver\Tag\DICOM\SequenceName(),
                'AngioFlag' => new \PHPExiftool\Driver\Tag\DICOM\AngioFlag(),
                'InterventionDrugInformationSeq' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDrugInformationSeq(),
                'InterventionDrugStopTime' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDrugStopTime(),
                'InterventionDrugDose' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDrugDose(),
                'InterventionDrugSequence' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDrugSequence(),
                'AdditionalDrugSequence' => new \PHPExiftool\Driver\Tag\DICOM\AdditionalDrugSequence(),
                'Radionuclide' => new \PHPExiftool\Driver\Tag\DICOM\Radionuclide(),
                'Radiopharmaceutical' => new \PHPExiftool\Driver\Tag\DICOM\Radiopharmaceutical(),
                'EnergyWindowCenterline' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowCenterline(),
                'EnergyWindowTotalWidth' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowTotalWidth(),
                'InterventionDrugName' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDrugName(),
                'InterventionDrugStartTime' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDrugStartTime(),
                'InterventionSequence' => new \PHPExiftool\Driver\Tag\DICOM\InterventionSequence(),
                'TherapyType' => new \PHPExiftool\Driver\Tag\DICOM\TherapyType(),
                'InterventionStatus' => new \PHPExiftool\Driver\Tag\DICOM\InterventionStatus(),
                'TherapyDescription' => new \PHPExiftool\Driver\Tag\DICOM\TherapyDescription(),
                'InterventionDescription' => new \PHPExiftool\Driver\Tag\DICOM\InterventionDescription(),
                'CineRate' => new \PHPExiftool\Driver\Tag\DICOM\CineRate(),
                'InitialCineRunState' => new \PHPExiftool\Driver\Tag\DICOM\InitialCineRunState(),
                'SliceThickness' => new \PHPExiftool\Driver\Tag\DICOM\SliceThickness(),
                'KVP' => new \PHPExiftool\Driver\Tag\DICOM\KVP(),
                'CountsAccumulated' => new \PHPExiftool\Driver\Tag\DICOM\CountsAccumulated(),
                'AcquisitionTerminationCondition' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionTerminationCondition(),
                'EffectiveDuration' => new \PHPExiftool\Driver\Tag\DICOM\EffectiveDuration(),
                'AcquisitionStartCondition' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionStartCondition(),
                'AcquisitionStartConditionData' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionStartConditionData(),
                'AcquisitionEndConditionData' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionEndConditionData(),
                'RepetitionTime' => new \PHPExiftool\Driver\Tag\DICOM\RepetitionTime(),
                'EchoTime' => new \PHPExiftool\Driver\Tag\DICOM\EchoTime(),
                'InversionTime' => new \PHPExiftool\Driver\Tag\DICOM\InversionTime(),
                'NumberOfAverages' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfAverages(),
                'ImagingFrequency' => new \PHPExiftool\Driver\Tag\DICOM\ImagingFrequency(),
                'ImagedNucleus' => new \PHPExiftool\Driver\Tag\DICOM\ImagedNucleus(),
                'EchoNumber' => new \PHPExiftool\Driver\Tag\DICOM\EchoNumber(),
                'MagneticFieldStrength' => new \PHPExiftool\Driver\Tag\DICOM\MagneticFieldStrength(),
                'SpacingBetweenSlices' => new \PHPExiftool\Driver\Tag\DICOM\SpacingBetweenSlices(),
                'NumberOfPhaseEncodingSteps' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPhaseEncodingSteps(),
                'DataCollectionDiameter' => new \PHPExiftool\Driver\Tag\DICOM\DataCollectionDiameter(),
                'EchoTrainLength' => new \PHPExiftool\Driver\Tag\DICOM\EchoTrainLength(),
                'PercentSampling' => new \PHPExiftool\Driver\Tag\DICOM\PercentSampling(),
                'PercentPhaseFieldOfView' => new \PHPExiftool\Driver\Tag\DICOM\PercentPhaseFieldOfView(),
                'PixelBandwidth' => new \PHPExiftool\Driver\Tag\DICOM\PixelBandwidth(),
                'DeviceSerialNumber' => new \PHPExiftool\Driver\Tag\DICOM\DeviceSerialNumber(),
                'DeviceUID' => new \PHPExiftool\Driver\Tag\DICOM\DeviceUID(),
                'DeviceID' => new \PHPExiftool\Driver\Tag\DICOM\DeviceID(),
                'PlateID' => new \PHPExiftool\Driver\Tag\DICOM\PlateID(),
                'GeneratorID' => new \PHPExiftool\Driver\Tag\DICOM\GeneratorID(),
                'GridID' => new \PHPExiftool\Driver\Tag\DICOM\GridID(),
                'CassetteID' => new \PHPExiftool\Driver\Tag\DICOM\CassetteID(),
                'GantryID' => new \PHPExiftool\Driver\Tag\DICOM\GantryID(),
                'SecondaryCaptureDeviceID' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryCaptureDeviceID(),
                'HardcopyCreationDeviceID' => new \PHPExiftool\Driver\Tag\DICOM\HardcopyCreationDeviceID(),
                'DateOfSecondaryCapture' => new \PHPExiftool\Driver\Tag\DICOM\DateOfSecondaryCapture(),
                'TimeOfSecondaryCapture' => new \PHPExiftool\Driver\Tag\DICOM\TimeOfSecondaryCapture(),
                'SecondaryCaptureDeviceManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryCaptureDeviceManufacturer(),
                'HardcopyDeviceManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\HardcopyDeviceManufacturer(),
                'SecondaryCaptureDeviceModelName' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryCaptureDeviceModelName(),
                'SecondaryCaptureDeviceSoftwareVers' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryCaptureDeviceSoftwareVers(),
                'HardcopyDeviceSoftwareVersion' => new \PHPExiftool\Driver\Tag\DICOM\HardcopyDeviceSoftwareVersion(),
                'HardcopyDeviceModelName' => new \PHPExiftool\Driver\Tag\DICOM\HardcopyDeviceModelName(),
                'SoftwareVersion' => new \PHPExiftool\Driver\Tag\DICOM\SoftwareVersion(),
                'VideoImageFormatAcquired' => new \PHPExiftool\Driver\Tag\DICOM\VideoImageFormatAcquired(),
                'DigitalImageFormatAcquired' => new \PHPExiftool\Driver\Tag\DICOM\DigitalImageFormatAcquired(),
                'ProtocolName' => new \PHPExiftool\Driver\Tag\DICOM\ProtocolName(),
                'ContrastBolusRoute' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusRoute(),
                'ContrastBolusVolume' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusVolume(),
                'ContrastBolusStartTime' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusStartTime(),
                'ContrastBolusStopTime' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusStopTime(),
                'ContrastBolusTotalDose' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusTotalDose(),
                'SyringeCounts' => new \PHPExiftool\Driver\Tag\DICOM\SyringeCounts(),
                'ContrastFlowRate' => new \PHPExiftool\Driver\Tag\DICOM\ContrastFlowRate(),
                'ContrastFlowDuration' => new \PHPExiftool\Driver\Tag\DICOM\ContrastFlowDuration(),
                'ContrastBolusIngredient' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusIngredient(),
                'ContrastBolusConcentration' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusConcentration(),
                'SpatialResolution' => new \PHPExiftool\Driver\Tag\DICOM\SpatialResolution(),
                'TriggerTime' => new \PHPExiftool\Driver\Tag\DICOM\TriggerTime(),
                'TriggerSourceOrType' => new \PHPExiftool\Driver\Tag\DICOM\TriggerSourceOrType(),
                'NominalInterval' => new \PHPExiftool\Driver\Tag\DICOM\NominalInterval(),
                'FrameTime' => new \PHPExiftool\Driver\Tag\DICOM\FrameTime(),
                'CardiacFramingType' => new \PHPExiftool\Driver\Tag\DICOM\CardiacFramingType(),
                'FrameTimeVector' => new \PHPExiftool\Driver\Tag\DICOM\FrameTimeVector(),
                'FrameDelay' => new \PHPExiftool\Driver\Tag\DICOM\FrameDelay(),
                'ImageTriggerDelay' => new \PHPExiftool\Driver\Tag\DICOM\ImageTriggerDelay(),
                'MultiplexGroupTimeOffset' => new \PHPExiftool\Driver\Tag\DICOM\MultiplexGroupTimeOffset(),
                'TriggerTimeOffset' => new \PHPExiftool\Driver\Tag\DICOM\TriggerTimeOffset(),
                'SynchronizationTrigger' => new \PHPExiftool\Driver\Tag\DICOM\SynchronizationTrigger(),
                'SynchronizationChannel' => new \PHPExiftool\Driver\Tag\DICOM\SynchronizationChannel(),
                'TriggerSamplePosition' => new \PHPExiftool\Driver\Tag\DICOM\TriggerSamplePosition(),
                'RadiopharmaceuticalRoute' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalRoute(),
                'RadiopharmaceuticalVolume' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalVolume(),
                'RadiopharmaceuticalStartTime' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalStartTime(),
                'RadiopharmaceuticalStopTime' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalStopTime(),
                'RadionuclideTotalDose' => new \PHPExiftool\Driver\Tag\DICOM\RadionuclideTotalDose(),
                'RadionuclideHalfLife' => new \PHPExiftool\Driver\Tag\DICOM\RadionuclideHalfLife(),
                'RadionuclidePositronFraction' => new \PHPExiftool\Driver\Tag\DICOM\RadionuclidePositronFraction(),
                'RadiopharmaceuticalSpecActivity' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalSpecActivity(),
                'RadiopharmaceuticalStartDateTime' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalStartDateTime(),
                'RadiopharmaceuticalStopDateTime' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalStopDateTime(),
                'BeatRejectionFlag' => new \PHPExiftool\Driver\Tag\DICOM\BeatRejectionFlag(),
                'LowRRValue' => new \PHPExiftool\Driver\Tag\DICOM\LowRRValue(),
                'HighRRValue' => new \PHPExiftool\Driver\Tag\DICOM\HighRRValue(),
                'IntervalsAcquired' => new \PHPExiftool\Driver\Tag\DICOM\IntervalsAcquired(),
                'IntervalsRejected' => new \PHPExiftool\Driver\Tag\DICOM\IntervalsRejected(),
                'PVCRejection' => new \PHPExiftool\Driver\Tag\DICOM\PVCRejection(),
                'SkipBeats' => new \PHPExiftool\Driver\Tag\DICOM\SkipBeats(),
                'HeartRate' => new \PHPExiftool\Driver\Tag\DICOM\HeartRate(),
                'CardiacNumberOfImages' => new \PHPExiftool\Driver\Tag\DICOM\CardiacNumberOfImages(),
                'TriggerWindow' => new \PHPExiftool\Driver\Tag\DICOM\TriggerWindow(),
                'ReconstructionDiameter' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionDiameter(),
                'DistanceSourceToDetector' => new \PHPExiftool\Driver\Tag\DICOM\DistanceSourceToDetector(),
                'DistanceSourceToPatient' => new \PHPExiftool\Driver\Tag\DICOM\DistanceSourceToPatient(),
                'EstimatedRadiographicMagnification' => new \PHPExiftool\Driver\Tag\DICOM\EstimatedRadiographicMagnification(),
                'GantryDetectorTilt' => new \PHPExiftool\Driver\Tag\DICOM\GantryDetectorTilt(),
                'GantryDetectorSlew' => new \PHPExiftool\Driver\Tag\DICOM\GantryDetectorSlew(),
                'TableHeight' => new \PHPExiftool\Driver\Tag\DICOM\TableHeight(),
                'TableTraverse' => new \PHPExiftool\Driver\Tag\DICOM\TableTraverse(),
                'TableMotion' => new \PHPExiftool\Driver\Tag\DICOM\TableMotion(),
                'TableVerticalIncrement' => new \PHPExiftool\Driver\Tag\DICOM\TableVerticalIncrement(),
                'TableLateralIncrement' => new \PHPExiftool\Driver\Tag\DICOM\TableLateralIncrement(),
                'TableLongitudinalIncrement' => new \PHPExiftool\Driver\Tag\DICOM\TableLongitudinalIncrement(),
                'TableAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableAngle(),
                'TableType' => new \PHPExiftool\Driver\Tag\DICOM\TableType(),
                'RotationDirection' => new \PHPExiftool\Driver\Tag\DICOM\RotationDirection(),
                'AngularPosition' => new \PHPExiftool\Driver\Tag\DICOM\AngularPosition(),
                'RadialPosition' => new \PHPExiftool\Driver\Tag\DICOM\RadialPosition(),
                'ScanArc' => new \PHPExiftool\Driver\Tag\DICOM\ScanArc(),
                'AngularStep' => new \PHPExiftool\Driver\Tag\DICOM\AngularStep(),
                'CenterOfRotationOffset' => new \PHPExiftool\Driver\Tag\DICOM\CenterOfRotationOffset(),
                'RotationOffset' => new \PHPExiftool\Driver\Tag\DICOM\RotationOffset(),
                'FieldOfViewShape' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewShape(),
                'FieldOfViewDimensions' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewDimensions(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\DICOM\ExposureTime(),
                'XRayTubeCurrent' => new \PHPExiftool\Driver\Tag\DICOM\XRayTubeCurrent(),
                'Exposure' => new \PHPExiftool\Driver\Tag\DICOM\Exposure(),
                'ExposureInMicroAmpSec' => new \PHPExiftool\Driver\Tag\DICOM\ExposureInMicroAmpSec(),
                'AveragePulseWidth' => new \PHPExiftool\Driver\Tag\DICOM\AveragePulseWidth(),
                'RadiationSetting' => new \PHPExiftool\Driver\Tag\DICOM\RadiationSetting(),
                'RectificationType' => new \PHPExiftool\Driver\Tag\DICOM\RectificationType(),
                'RadiationMode' => new \PHPExiftool\Driver\Tag\DICOM\RadiationMode(),
                'ImageAreaDoseProduct' => new \PHPExiftool\Driver\Tag\DICOM\ImageAreaDoseProduct(),
                'FilterType' => new \PHPExiftool\Driver\Tag\DICOM\FilterType(),
                'TypeOfFilters' => new \PHPExiftool\Driver\Tag\DICOM\TypeOfFilters(),
                'IntensifierSize' => new \PHPExiftool\Driver\Tag\DICOM\IntensifierSize(),
                'ImagerPixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\ImagerPixelSpacing(),
                'Grid' => new \PHPExiftool\Driver\Tag\DICOM\Grid(),
                'GeneratorPower' => new \PHPExiftool\Driver\Tag\DICOM\GeneratorPower(),
                'CollimatorGridName' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorGridName(),
                'CollimatorType' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorType(),
                'FocalDistance' => new \PHPExiftool\Driver\Tag\DICOM\FocalDistance(),
                'XFocusCenter' => new \PHPExiftool\Driver\Tag\DICOM\XFocusCenter(),
                'YFocusCenter' => new \PHPExiftool\Driver\Tag\DICOM\YFocusCenter(),
                'FocalSpots' => new \PHPExiftool\Driver\Tag\DICOM\FocalSpots(),
                'AnodeTargetMaterial' => new \PHPExiftool\Driver\Tag\DICOM\AnodeTargetMaterial(),
                'BodyPartThickness' => new \PHPExiftool\Driver\Tag\DICOM\BodyPartThickness(),
                'CompressionForce' => new \PHPExiftool\Driver\Tag\DICOM\CompressionForce(),
                'DateOfLastCalibration' => new \PHPExiftool\Driver\Tag\DICOM\DateOfLastCalibration(),
                'TimeOfLastCalibration' => new \PHPExiftool\Driver\Tag\DICOM\TimeOfLastCalibration(),
                'ConvolutionKernel' => new \PHPExiftool\Driver\Tag\DICOM\ConvolutionKernel(),
                'UpperLowerPixelValues' => new \PHPExiftool\Driver\Tag\DICOM\UpperLowerPixelValues(),
                'ActualFrameDuration' => new \PHPExiftool\Driver\Tag\DICOM\ActualFrameDuration(),
                'CountRate' => new \PHPExiftool\Driver\Tag\DICOM\CountRate(),
                'PreferredPlaybackSequencing' => new \PHPExiftool\Driver\Tag\DICOM\PreferredPlaybackSequencing(),
                'ReceiveCoilName' => new \PHPExiftool\Driver\Tag\DICOM\ReceiveCoilName(),
                'TransmitCoilName' => new \PHPExiftool\Driver\Tag\DICOM\TransmitCoilName(),
                'PlateType' => new \PHPExiftool\Driver\Tag\DICOM\PlateType(),
                'PhosphorType' => new \PHPExiftool\Driver\Tag\DICOM\PhosphorType(),
                'ScanVelocity' => new \PHPExiftool\Driver\Tag\DICOM\ScanVelocity(),
                'WholeBodyTechnique' => new \PHPExiftool\Driver\Tag\DICOM\WholeBodyTechnique(),
                'ScanLength' => new \PHPExiftool\Driver\Tag\DICOM\ScanLength(),
                'AcquisitionMatrix' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionMatrix(),
                'InPlanePhaseEncodingDirection' => new \PHPExiftool\Driver\Tag\DICOM\InPlanePhaseEncodingDirection(),
                'FlipAngle' => new \PHPExiftool\Driver\Tag\DICOM\FlipAngle(),
                'VariableFlipAngleFlag' => new \PHPExiftool\Driver\Tag\DICOM\VariableFlipAngleFlag(),
                'SAR' => new \PHPExiftool\Driver\Tag\DICOM\SAR(),
                'DB-Dt' => new \PHPExiftool\Driver\Tag\DICOM\DBDt(),
                'AcquisitionDeviceProcessingDescr' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionDeviceProcessingDescr(),
                'AcquisitionDeviceProcessingCode' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionDeviceProcessingCode(),
                'CassetteOrientation' => new \PHPExiftool\Driver\Tag\DICOM\CassetteOrientation(),
                'CassetteSize' => new \PHPExiftool\Driver\Tag\DICOM\CassetteSize(),
                'ExposuresOnPlate' => new \PHPExiftool\Driver\Tag\DICOM\ExposuresOnPlate(),
                'RelativeXRayExposure' => new \PHPExiftool\Driver\Tag\DICOM\RelativeXRayExposure(),
                'ColumnAngulation' => new \PHPExiftool\Driver\Tag\DICOM\ColumnAngulation(),
                'TomoLayerHeight' => new \PHPExiftool\Driver\Tag\DICOM\TomoLayerHeight(),
                'TomoAngle' => new \PHPExiftool\Driver\Tag\DICOM\TomoAngle(),
                'TomoTime' => new \PHPExiftool\Driver\Tag\DICOM\TomoTime(),
                'TomoType' => new \PHPExiftool\Driver\Tag\DICOM\TomoType(),
                'TomoClass' => new \PHPExiftool\Driver\Tag\DICOM\TomoClass(),
                'NumberOfTomosynthesisSourceImages' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTomosynthesisSourceImages(),
                'PositionerMotion' => new \PHPExiftool\Driver\Tag\DICOM\PositionerMotion(),
                'PositionerType' => new \PHPExiftool\Driver\Tag\DICOM\PositionerType(),
                'PositionerPrimaryAngle' => new \PHPExiftool\Driver\Tag\DICOM\PositionerPrimaryAngle(),
                'PositionerSecondaryAngle' => new \PHPExiftool\Driver\Tag\DICOM\PositionerSecondaryAngle(),
                'PositionerPrimaryAngleIncrement' => new \PHPExiftool\Driver\Tag\DICOM\PositionerPrimaryAngleIncrement(),
                'PositionerSecondaryAngleIncrement' => new \PHPExiftool\Driver\Tag\DICOM\PositionerSecondaryAngleIncrement(),
                'DetectorPrimaryAngle' => new \PHPExiftool\Driver\Tag\DICOM\DetectorPrimaryAngle(),
                'DetectorSecondaryAngle' => new \PHPExiftool\Driver\Tag\DICOM\DetectorSecondaryAngle(),
                'ShutterShape' => new \PHPExiftool\Driver\Tag\DICOM\ShutterShape(),
                'ShutterLeftVerticalEdge' => new \PHPExiftool\Driver\Tag\DICOM\ShutterLeftVerticalEdge(),
                'ShutterRightVerticalEdge' => new \PHPExiftool\Driver\Tag\DICOM\ShutterRightVerticalEdge(),
                'ShutterUpperHorizontalEdge' => new \PHPExiftool\Driver\Tag\DICOM\ShutterUpperHorizontalEdge(),
                'ShutterLowerHorizontalEdge' => new \PHPExiftool\Driver\Tag\DICOM\ShutterLowerHorizontalEdge(),
                'CenterOfCircularShutter' => new \PHPExiftool\Driver\Tag\DICOM\CenterOfCircularShutter(),
                'RadiusOfCircularShutter' => new \PHPExiftool\Driver\Tag\DICOM\RadiusOfCircularShutter(),
                'VerticesOfPolygonalShutter' => new \PHPExiftool\Driver\Tag\DICOM\VerticesOfPolygonalShutter(),
                'ShutterPresentationValue' => new \PHPExiftool\Driver\Tag\DICOM\ShutterPresentationValue(),
                'ShutterOverlayGroup' => new \PHPExiftool\Driver\Tag\DICOM\ShutterOverlayGroup(),
                'ShutterPresentationColorCIELabVal' => new \PHPExiftool\Driver\Tag\DICOM\ShutterPresentationColorCIELabVal(),
                'CollimatorShape' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorShape(),
                'CollimatorLeftVerticalEdge' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorLeftVerticalEdge(),
                'CollimatorRightVerticalEdge' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorRightVerticalEdge(),
                'CollimatorUpperHorizontalEdge' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorUpperHorizontalEdge(),
                'CollimatorLowerHorizontalEdge' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorLowerHorizontalEdge(),
                'CenterOfCircularCollimator' => new \PHPExiftool\Driver\Tag\DICOM\CenterOfCircularCollimator(),
                'RadiusOfCircularCollimator' => new \PHPExiftool\Driver\Tag\DICOM\RadiusOfCircularCollimator(),
                'VerticesOfPolygonalCollimator' => new \PHPExiftool\Driver\Tag\DICOM\VerticesOfPolygonalCollimator(),
                'AcquisitionTimeSynchronized' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionTimeSynchronized(),
                'TimeSource' => new \PHPExiftool\Driver\Tag\DICOM\TimeSource(),
                'TimeDistributionProtocol' => new \PHPExiftool\Driver\Tag\DICOM\TimeDistributionProtocol(),
                'NTPSourceAddress' => new \PHPExiftool\Driver\Tag\DICOM\NTPSourceAddress(),
                'PageNumberVector' => new \PHPExiftool\Driver\Tag\DICOM\PageNumberVector(),
                'FrameLabelVector' => new \PHPExiftool\Driver\Tag\DICOM\FrameLabelVector(),
                'FramePrimaryAngleVector' => new \PHPExiftool\Driver\Tag\DICOM\FramePrimaryAngleVector(),
                'FrameSecondaryAngleVector' => new \PHPExiftool\Driver\Tag\DICOM\FrameSecondaryAngleVector(),
                'SliceLocationVector' => new \PHPExiftool\Driver\Tag\DICOM\SliceLocationVector(),
                'DisplayWindowLabelVector' => new \PHPExiftool\Driver\Tag\DICOM\DisplayWindowLabelVector(),
                'NominalScannedPixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\NominalScannedPixelSpacing(),
                'DigitizingDeviceTransportDirection' => new \PHPExiftool\Driver\Tag\DICOM\DigitizingDeviceTransportDirection(),
                'RotationOfScannedFilm' => new \PHPExiftool\Driver\Tag\DICOM\RotationOfScannedFilm(),
                'IVUSAcquisition' => new \PHPExiftool\Driver\Tag\DICOM\IVUSAcquisition(),
                'IVUSPullbackRate' => new \PHPExiftool\Driver\Tag\DICOM\IVUSPullbackRate(),
                'IVUSGatedRate' => new \PHPExiftool\Driver\Tag\DICOM\IVUSGatedRate(),
                'IVUSPullbackStartFrameNumber' => new \PHPExiftool\Driver\Tag\DICOM\IVUSPullbackStartFrameNumber(),
                'IVUSPullbackStopFrameNumber' => new \PHPExiftool\Driver\Tag\DICOM\IVUSPullbackStopFrameNumber(),
                'LesionNumber' => new \PHPExiftool\Driver\Tag\DICOM\LesionNumber(),
                'AcquisitionComments' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionComments(),
                'OutputPower' => new \PHPExiftool\Driver\Tag\DICOM\OutputPower(),
                'TransducerData' => new \PHPExiftool\Driver\Tag\DICOM\TransducerData(),
                'FocusDepth' => new \PHPExiftool\Driver\Tag\DICOM\FocusDepth(),
                'ProcessingFunction' => new \PHPExiftool\Driver\Tag\DICOM\ProcessingFunction(),
                'PostprocessingFunction' => new \PHPExiftool\Driver\Tag\DICOM\PostprocessingFunction(),
                'MechanicalIndex' => new \PHPExiftool\Driver\Tag\DICOM\MechanicalIndex(),
                'BoneThermalIndex' => new \PHPExiftool\Driver\Tag\DICOM\BoneThermalIndex(),
                'CranialThermalIndex' => new \PHPExiftool\Driver\Tag\DICOM\CranialThermalIndex(),
                'SoftTissueThermalIndex' => new \PHPExiftool\Driver\Tag\DICOM\SoftTissueThermalIndex(),
                'SoftTissueFocusThermalIndex' => new \PHPExiftool\Driver\Tag\DICOM\SoftTissueFocusThermalIndex(),
                'SoftTissueSurfaceThermalIndex' => new \PHPExiftool\Driver\Tag\DICOM\SoftTissueSurfaceThermalIndex(),
                'DynamicRange' => new \PHPExiftool\Driver\Tag\DICOM\DynamicRange(),
                'TotalGain' => new \PHPExiftool\Driver\Tag\DICOM\TotalGain(),
                'DepthOfScanField' => new \PHPExiftool\Driver\Tag\DICOM\DepthOfScanField(),
                'PatientPosition' => new \PHPExiftool\Driver\Tag\DICOM\PatientPosition(),
                'ViewPosition' => new \PHPExiftool\Driver\Tag\DICOM\ViewPosition(),
                'ProjectionEponymousNameCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\ProjectionEponymousNameCodeSeq(),
                'ImageTransformationMatrix' => new \PHPExiftool\Driver\Tag\DICOM\ImageTransformationMatrix(),
                'ImageTranslationVector' => new \PHPExiftool\Driver\Tag\DICOM\ImageTranslationVector(),
                'Sensitivity' => new \PHPExiftool\Driver\Tag\DICOM\Sensitivity(),
                'SequenceOfUltrasoundRegions' => new \PHPExiftool\Driver\Tag\DICOM\SequenceOfUltrasoundRegions(),
                'RegionSpatialFormat' => new \PHPExiftool\Driver\Tag\DICOM\RegionSpatialFormat(),
                'RegionDataType' => new \PHPExiftool\Driver\Tag\DICOM\RegionDataType(),
                'RegionFlags' => new \PHPExiftool\Driver\Tag\DICOM\RegionFlags(),
                'RegionLocationMinX0' => new \PHPExiftool\Driver\Tag\DICOM\RegionLocationMinX0(),
                'RegionLocationMinY0' => new \PHPExiftool\Driver\Tag\DICOM\RegionLocationMinY0(),
                'RegionLocationMaxX1' => new \PHPExiftool\Driver\Tag\DICOM\RegionLocationMaxX1(),
                'RegionLocationMaxY1' => new \PHPExiftool\Driver\Tag\DICOM\RegionLocationMaxY1(),
                'ReferencePixelX0' => new \PHPExiftool\Driver\Tag\DICOM\ReferencePixelX0(),
                'ReferencePixelY0' => new \PHPExiftool\Driver\Tag\DICOM\ReferencePixelY0(),
                'PhysicalUnitsXDirection' => new \PHPExiftool\Driver\Tag\DICOM\PhysicalUnitsXDirection(),
                'PhysicalUnitsYDirection' => new \PHPExiftool\Driver\Tag\DICOM\PhysicalUnitsYDirection(),
                'ReferencePixelPhysicalValueX' => new \PHPExiftool\Driver\Tag\DICOM\ReferencePixelPhysicalValueX(),
                'ReferencePixelPhysicalValueY' => new \PHPExiftool\Driver\Tag\DICOM\ReferencePixelPhysicalValueY(),
                'PhysicalDeltaX' => new \PHPExiftool\Driver\Tag\DICOM\PhysicalDeltaX(),
                'PhysicalDeltaY' => new \PHPExiftool\Driver\Tag\DICOM\PhysicalDeltaY(),
                'TransducerFrequency' => new \PHPExiftool\Driver\Tag\DICOM\TransducerFrequency(),
                'TransducerType' => new \PHPExiftool\Driver\Tag\DICOM\TransducerType(),
                'PulseRepetitionFrequency' => new \PHPExiftool\Driver\Tag\DICOM\PulseRepetitionFrequency(),
                'DopplerCorrectionAngle' => new \PHPExiftool\Driver\Tag\DICOM\DopplerCorrectionAngle(),
                'SteeringAngle' => new \PHPExiftool\Driver\Tag\DICOM\SteeringAngle(),
                'DopplerSampleVolumeXPosRetired' => new \PHPExiftool\Driver\Tag\DICOM\DopplerSampleVolumeXPosRetired(),
                'DopplerSampleVolumeXPosition' => new \PHPExiftool\Driver\Tag\DICOM\DopplerSampleVolumeXPosition(),
                'DopplerSampleVolumeYPosRetired' => new \PHPExiftool\Driver\Tag\DICOM\DopplerSampleVolumeYPosRetired(),
                'DopplerSampleVolumeYPosition' => new \PHPExiftool\Driver\Tag\DICOM\DopplerSampleVolumeYPosition(),
                'TMLinePositionX0Retired' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionX0Retired(),
                'TMLinePositionX0' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionX0(),
                'TMLinePositionY0Retired' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionY0Retired(),
                'TMLinePositionY0' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionY0(),
                'TMLinePositionX1Retired' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionX1Retired(),
                'TMLinePositionX1' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionX1(),
                'TMLinePositionY1Retired' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionY1Retired(),
                'TMLinePositionY1' => new \PHPExiftool\Driver\Tag\DICOM\TMLinePositionY1(),
                'PixelComponentOrganization' => new \PHPExiftool\Driver\Tag\DICOM\PixelComponentOrganization(),
                'PixelComponentMask' => new \PHPExiftool\Driver\Tag\DICOM\PixelComponentMask(),
                'PixelComponentRangeStart' => new \PHPExiftool\Driver\Tag\DICOM\PixelComponentRangeStart(),
                'PixelComponentRangeStop' => new \PHPExiftool\Driver\Tag\DICOM\PixelComponentRangeStop(),
                'PixelComponentPhysicalUnits' => new \PHPExiftool\Driver\Tag\DICOM\PixelComponentPhysicalUnits(),
                'PixelComponentDataType' => new \PHPExiftool\Driver\Tag\DICOM\PixelComponentDataType(),
                'NumberOfTableBreakPoints' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTableBreakPoints(),
                'TableOfXBreakPoints' => new \PHPExiftool\Driver\Tag\DICOM\TableOfXBreakPoints(),
                'TableOfYBreakPoints' => new \PHPExiftool\Driver\Tag\DICOM\TableOfYBreakPoints(),
                'NumberOfTableEntries' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTableEntries(),
                'TableOfPixelValues' => new \PHPExiftool\Driver\Tag\DICOM\TableOfPixelValues(),
                'TableOfParameterValues' => new \PHPExiftool\Driver\Tag\DICOM\TableOfParameterValues(),
                'RWaveTimeVector' => new \PHPExiftool\Driver\Tag\DICOM\RWaveTimeVector(),
                'DetectorConditionsNominalFlag' => new \PHPExiftool\Driver\Tag\DICOM\DetectorConditionsNominalFlag(),
                'DetectorTemperature' => new \PHPExiftool\Driver\Tag\DICOM\DetectorTemperature(),
                'DetectorType' => new \PHPExiftool\Driver\Tag\DICOM\DetectorType(),
                'DetectorConfiguration' => new \PHPExiftool\Driver\Tag\DICOM\DetectorConfiguration(),
                'DetectorDescription' => new \PHPExiftool\Driver\Tag\DICOM\DetectorDescription(),
                'DetectorMode' => new \PHPExiftool\Driver\Tag\DICOM\DetectorMode(),
                'DetectorID' => new \PHPExiftool\Driver\Tag\DICOM\DetectorID(),
                'DateOfLastDetectorCalibration' => new \PHPExiftool\Driver\Tag\DICOM\DateOfLastDetectorCalibration(),
                'TimeOfLastDetectorCalibration' => new \PHPExiftool\Driver\Tag\DICOM\TimeOfLastDetectorCalibration(),
                'DetectorExposuresSinceCalibration' => new \PHPExiftool\Driver\Tag\DICOM\DetectorExposuresSinceCalibration(),
                'DetectorExposuresSinceManufactured' => new \PHPExiftool\Driver\Tag\DICOM\DetectorExposuresSinceManufactured(),
                'DetectorTimeSinceLastExposure' => new \PHPExiftool\Driver\Tag\DICOM\DetectorTimeSinceLastExposure(),
                'DetectorActiveTime' => new \PHPExiftool\Driver\Tag\DICOM\DetectorActiveTime(),
                'DetectorActiveOffsetFromExposure' => new \PHPExiftool\Driver\Tag\DICOM\DetectorActiveOffsetFromExposure(),
                'DetectorBinning' => new \PHPExiftool\Driver\Tag\DICOM\DetectorBinning(),
                'DetectorElementPhysicalSize' => new \PHPExiftool\Driver\Tag\DICOM\DetectorElementPhysicalSize(),
                'DetectorElementSpacing' => new \PHPExiftool\Driver\Tag\DICOM\DetectorElementSpacing(),
                'DetectorActiveShape' => new \PHPExiftool\Driver\Tag\DICOM\DetectorActiveShape(),
                'DetectorActiveDimensions' => new \PHPExiftool\Driver\Tag\DICOM\DetectorActiveDimensions(),
                'DetectorActiveOrigin' => new \PHPExiftool\Driver\Tag\DICOM\DetectorActiveOrigin(),
                'DetectorManufacturerName' => new \PHPExiftool\Driver\Tag\DICOM\DetectorManufacturerName(),
                'DetectorManufacturersModelName' => new \PHPExiftool\Driver\Tag\DICOM\DetectorManufacturersModelName(),
                'FieldOfViewOrigin' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewOrigin(),
                'FieldOfViewRotation' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewRotation(),
                'FieldOfViewHorizontalFlip' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewHorizontalFlip(),
                'GridAbsorbingMaterial' => new \PHPExiftool\Driver\Tag\DICOM\GridAbsorbingMaterial(),
                'GridSpacingMaterial' => new \PHPExiftool\Driver\Tag\DICOM\GridSpacingMaterial(),
                'GridThickness' => new \PHPExiftool\Driver\Tag\DICOM\GridThickness(),
                'GridPitch' => new \PHPExiftool\Driver\Tag\DICOM\GridPitch(),
                'GridAspectRatio' => new \PHPExiftool\Driver\Tag\DICOM\GridAspectRatio(),
                'GridPeriod' => new \PHPExiftool\Driver\Tag\DICOM\GridPeriod(),
                'GridFocalDistance' => new \PHPExiftool\Driver\Tag\DICOM\GridFocalDistance(),
                'FilterMaterial' => new \PHPExiftool\Driver\Tag\DICOM\FilterMaterial(),
                'FilterThicknessMinimum' => new \PHPExiftool\Driver\Tag\DICOM\FilterThicknessMinimum(),
                'FilterThicknessMaximum' => new \PHPExiftool\Driver\Tag\DICOM\FilterThicknessMaximum(),
                'ExposureControlMode' => new \PHPExiftool\Driver\Tag\DICOM\ExposureControlMode(),
                'ExposureControlModeDescription' => new \PHPExiftool\Driver\Tag\DICOM\ExposureControlModeDescription(),
                'ExposureStatus' => new \PHPExiftool\Driver\Tag\DICOM\ExposureStatus(),
                'PhototimerSetting' => new \PHPExiftool\Driver\Tag\DICOM\PhototimerSetting(),
                'ExposureTimeInMicroSec' => new \PHPExiftool\Driver\Tag\DICOM\ExposureTimeInMicroSec(),
                'XRayTubeCurrentInMicroAmps' => new \PHPExiftool\Driver\Tag\DICOM\XRayTubeCurrentInMicroAmps(),
                'ContentQualification' => new \PHPExiftool\Driver\Tag\DICOM\ContentQualification(),
                'PulseSequenceName' => new \PHPExiftool\Driver\Tag\DICOM\PulseSequenceName(),
                'MRImagingModifierSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRImagingModifierSequence(),
                'EchoPulseSequence' => new \PHPExiftool\Driver\Tag\DICOM\EchoPulseSequence(),
                'InversionRecovery' => new \PHPExiftool\Driver\Tag\DICOM\InversionRecovery(),
                'FlowCompensation' => new \PHPExiftool\Driver\Tag\DICOM\FlowCompensation(),
                'MultipleSpinEcho' => new \PHPExiftool\Driver\Tag\DICOM\MultipleSpinEcho(),
                'MultiPlanarExcitation' => new \PHPExiftool\Driver\Tag\DICOM\MultiPlanarExcitation(),
                'PhaseContrast' => new \PHPExiftool\Driver\Tag\DICOM\PhaseContrast(),
                'TimeOfFlightContrast' => new \PHPExiftool\Driver\Tag\DICOM\TimeOfFlightContrast(),
                'Spoiling' => new \PHPExiftool\Driver\Tag\DICOM\Spoiling(),
                'SteadyStatePulseSequence' => new \PHPExiftool\Driver\Tag\DICOM\SteadyStatePulseSequence(),
                'EchoPlanarPulseSequence' => new \PHPExiftool\Driver\Tag\DICOM\EchoPlanarPulseSequence(),
                'TagAngleFirstAxis' => new \PHPExiftool\Driver\Tag\DICOM\TagAngleFirstAxis(),
                'MagnetizationTransfer' => new \PHPExiftool\Driver\Tag\DICOM\MagnetizationTransfer(),
                'T2Preparation' => new \PHPExiftool\Driver\Tag\DICOM\T2Preparation(),
                'BloodSignalNulling' => new \PHPExiftool\Driver\Tag\DICOM\BloodSignalNulling(),
                'SaturationRecovery' => new \PHPExiftool\Driver\Tag\DICOM\SaturationRecovery(),
                'SpectrallySelectedSuppression' => new \PHPExiftool\Driver\Tag\DICOM\SpectrallySelectedSuppression(),
                'SpectrallySelectedExcitation' => new \PHPExiftool\Driver\Tag\DICOM\SpectrallySelectedExcitation(),
                'SpatialPresaturation' => new \PHPExiftool\Driver\Tag\DICOM\SpatialPresaturation(),
                'Tagging' => new \PHPExiftool\Driver\Tag\DICOM\Tagging(),
                'OversamplingPhase' => new \PHPExiftool\Driver\Tag\DICOM\OversamplingPhase(),
                'TagSpacingFirstDimension' => new \PHPExiftool\Driver\Tag\DICOM\TagSpacingFirstDimension(),
                'GeometryOfKSpaceTraversal' => new \PHPExiftool\Driver\Tag\DICOM\GeometryOfKSpaceTraversal(),
                'SegmentedKSpaceTraversal' => new \PHPExiftool\Driver\Tag\DICOM\SegmentedKSpaceTraversal(),
                'RectilinearPhaseEncodeReordering' => new \PHPExiftool\Driver\Tag\DICOM\RectilinearPhaseEncodeReordering(),
                'TagThickness' => new \PHPExiftool\Driver\Tag\DICOM\TagThickness(),
                'PartialFourierDirection' => new \PHPExiftool\Driver\Tag\DICOM\PartialFourierDirection(),
                'CardiacSynchronizationTechnique' => new \PHPExiftool\Driver\Tag\DICOM\CardiacSynchronizationTechnique(),
                'ReceiveCoilManufacturerName' => new \PHPExiftool\Driver\Tag\DICOM\ReceiveCoilManufacturerName(),
                'MRReceiveCoilSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRReceiveCoilSequence(),
                'ReceiveCoilType' => new \PHPExiftool\Driver\Tag\DICOM\ReceiveCoilType(),
                'QuadratureReceiveCoil' => new \PHPExiftool\Driver\Tag\DICOM\QuadratureReceiveCoil(),
                'MultiCoilDefinitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\MultiCoilDefinitionSequence(),
                'MultiCoilConfiguration' => new \PHPExiftool\Driver\Tag\DICOM\MultiCoilConfiguration(),
                'MultiCoilElementName' => new \PHPExiftool\Driver\Tag\DICOM\MultiCoilElementName(),
                'MultiCoilElementUsed' => new \PHPExiftool\Driver\Tag\DICOM\MultiCoilElementUsed(),
                'MRTransmitCoilSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRTransmitCoilSequence(),
                'TransmitCoilManufacturerName' => new \PHPExiftool\Driver\Tag\DICOM\TransmitCoilManufacturerName(),
                'TransmitCoilType' => new \PHPExiftool\Driver\Tag\DICOM\TransmitCoilType(),
                'SpectralWidth' => new \PHPExiftool\Driver\Tag\DICOM\SpectralWidth(),
                'ChemicalShiftReference' => new \PHPExiftool\Driver\Tag\DICOM\ChemicalShiftReference(),
                'VolumeLocalizationTechnique' => new \PHPExiftool\Driver\Tag\DICOM\VolumeLocalizationTechnique(),
                'MRAcquisitionFrequencyEncodeSteps' => new \PHPExiftool\Driver\Tag\DICOM\MRAcquisitionFrequencyEncodeSteps(),
                'Decoupling' => new \PHPExiftool\Driver\Tag\DICOM\Decoupling(),
                'DecoupledNucleus' => new \PHPExiftool\Driver\Tag\DICOM\DecoupledNucleus(),
                'DecouplingFrequency' => new \PHPExiftool\Driver\Tag\DICOM\DecouplingFrequency(),
                'DecouplingMethod' => new \PHPExiftool\Driver\Tag\DICOM\DecouplingMethod(),
                'DecouplingChemicalShiftReference' => new \PHPExiftool\Driver\Tag\DICOM\DecouplingChemicalShiftReference(),
                'KSpaceFiltering' => new \PHPExiftool\Driver\Tag\DICOM\KSpaceFiltering(),
                'TimeDomainFiltering' => new \PHPExiftool\Driver\Tag\DICOM\TimeDomainFiltering(),
                'NumberOfZeroFills' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfZeroFills(),
                'BaselineCorrection' => new \PHPExiftool\Driver\Tag\DICOM\BaselineCorrection(),
                'ParallelReductionFactorInPlane' => new \PHPExiftool\Driver\Tag\DICOM\ParallelReductionFactorInPlane(),
                'CardiacRRIntervalSpecified' => new \PHPExiftool\Driver\Tag\DICOM\CardiacRRIntervalSpecified(),
                'AcquisitionDuration' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionDuration(),
                'FrameAcquisitionDateTime' => new \PHPExiftool\Driver\Tag\DICOM\FrameAcquisitionDateTime(),
                'DiffusionDirectionality' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionDirectionality(),
                'DiffusionGradientDirectionSequence' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionGradientDirectionSequence(),
                'ParallelAcquisition' => new \PHPExiftool\Driver\Tag\DICOM\ParallelAcquisition(),
                'ParallelAcquisitionTechnique' => new \PHPExiftool\Driver\Tag\DICOM\ParallelAcquisitionTechnique(),
                'InversionTimes' => new \PHPExiftool\Driver\Tag\DICOM\InversionTimes(),
                'MetaboliteMapDescription' => new \PHPExiftool\Driver\Tag\DICOM\MetaboliteMapDescription(),
                'PartialFourier' => new \PHPExiftool\Driver\Tag\DICOM\PartialFourier(),
                'EffectiveEchoTime' => new \PHPExiftool\Driver\Tag\DICOM\EffectiveEchoTime(),
                'MetaboliteMapCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\MetaboliteMapCodeSequence(),
                'ChemicalShiftSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChemicalShiftSequence(),
                'CardiacSignalSource' => new \PHPExiftool\Driver\Tag\DICOM\CardiacSignalSource(),
                'DiffusionBValue' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValue(),
                'DiffusionGradientOrientation' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionGradientOrientation(),
                'VelocityEncodingDirection' => new \PHPExiftool\Driver\Tag\DICOM\VelocityEncodingDirection(),
                'VelocityEncodingMinimumValue' => new \PHPExiftool\Driver\Tag\DICOM\VelocityEncodingMinimumValue(),
                'NumberOfKSpaceTrajectories' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfKSpaceTrajectories(),
                'CoverageOfKSpace' => new \PHPExiftool\Driver\Tag\DICOM\CoverageOfKSpace(),
                'SpectroscopyAcquisitionPhaseRows' => new \PHPExiftool\Driver\Tag\DICOM\SpectroscopyAcquisitionPhaseRows(),
                'ParallelReductFactorInPlaneRetired' => new \PHPExiftool\Driver\Tag\DICOM\ParallelReductFactorInPlaneRetired(),
                'TransmitterFrequency' => new \PHPExiftool\Driver\Tag\DICOM\TransmitterFrequency(),
                'ResonantNucleus' => new \PHPExiftool\Driver\Tag\DICOM\ResonantNucleus(),
                'FrequencyCorrection' => new \PHPExiftool\Driver\Tag\DICOM\FrequencyCorrection(),
                'MRSpectroscopyFOV-GeometrySequence' => new \PHPExiftool\Driver\Tag\DICOM\MRSpectroscopyFOVGeometrySequence(),
                'SlabThickness' => new \PHPExiftool\Driver\Tag\DICOM\SlabThickness(),
                'SlabOrientation' => new \PHPExiftool\Driver\Tag\DICOM\SlabOrientation(),
                'MidSlabPosition' => new \PHPExiftool\Driver\Tag\DICOM\MidSlabPosition(),
                'MRSpatialSaturationSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRSpatialSaturationSequence(),
                'MRTimingAndRelatedParametersSeq' => new \PHPExiftool\Driver\Tag\DICOM\MRTimingAndRelatedParametersSeq(),
                'MREchoSequence' => new \PHPExiftool\Driver\Tag\DICOM\MREchoSequence(),
                'MRModifierSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRModifierSequence(),
                'MRDiffusionSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRDiffusionSequence(),
                'CardiacTriggerSequence' => new \PHPExiftool\Driver\Tag\DICOM\CardiacTriggerSequence(),
                'MRAveragesSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRAveragesSequence(),
                'MRFOV-GeometrySequence' => new \PHPExiftool\Driver\Tag\DICOM\MRFOVGeometrySequence(),
                'VolumeLocalizationSequence' => new \PHPExiftool\Driver\Tag\DICOM\VolumeLocalizationSequence(),
                'SpectroscopyAcquisitionDataColumns' => new \PHPExiftool\Driver\Tag\DICOM\SpectroscopyAcquisitionDataColumns(),
                'DiffusionAnisotropyType' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionAnisotropyType(),
                'FrameReferenceDateTime' => new \PHPExiftool\Driver\Tag\DICOM\FrameReferenceDateTime(),
                'MRMetaboliteMapSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRMetaboliteMapSequence(),
                'ParallelReductionFactorOutOfPlane' => new \PHPExiftool\Driver\Tag\DICOM\ParallelReductionFactorOutOfPlane(),
                'SpectroscopyOutOfPlanePhaseSteps' => new \PHPExiftool\Driver\Tag\DICOM\SpectroscopyOutOfPlanePhaseSteps(),
                'BulkMotionStatus' => new \PHPExiftool\Driver\Tag\DICOM\BulkMotionStatus(),
                'ParallelReductionFactSecondInPlane' => new \PHPExiftool\Driver\Tag\DICOM\ParallelReductionFactSecondInPlane(),
                'CardiacBeatRejectionTechnique' => new \PHPExiftool\Driver\Tag\DICOM\CardiacBeatRejectionTechnique(),
                'RespiratoryMotionCompTechnique' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryMotionCompTechnique(),
                'RespiratorySignalSource' => new \PHPExiftool\Driver\Tag\DICOM\RespiratorySignalSource(),
                'BulkMotionCompensationTechnique' => new \PHPExiftool\Driver\Tag\DICOM\BulkMotionCompensationTechnique(),
                'BulkMotionSignalSource' => new \PHPExiftool\Driver\Tag\DICOM\BulkMotionSignalSource(),
                'ApplicableSafetyStandardAgency' => new \PHPExiftool\Driver\Tag\DICOM\ApplicableSafetyStandardAgency(),
                'ApplicableSafetyStandardDescr' => new \PHPExiftool\Driver\Tag\DICOM\ApplicableSafetyStandardDescr(),
                'OperatingModeSequence' => new \PHPExiftool\Driver\Tag\DICOM\OperatingModeSequence(),
                'OperatingModeType' => new \PHPExiftool\Driver\Tag\DICOM\OperatingModeType(),
                'OperatingMode' => new \PHPExiftool\Driver\Tag\DICOM\OperatingMode(),
                'SpecificAbsorptionRateDefinition' => new \PHPExiftool\Driver\Tag\DICOM\SpecificAbsorptionRateDefinition(),
                'GradientOutputType' => new \PHPExiftool\Driver\Tag\DICOM\GradientOutputType(),
                'SpecificAbsorptionRateValue' => new \PHPExiftool\Driver\Tag\DICOM\SpecificAbsorptionRateValue(),
                'GradientOutput' => new \PHPExiftool\Driver\Tag\DICOM\GradientOutput(),
                'FlowCompensationDirection' => new \PHPExiftool\Driver\Tag\DICOM\FlowCompensationDirection(),
                'TaggingDelay' => new \PHPExiftool\Driver\Tag\DICOM\TaggingDelay(),
                'RespiratoryMotionCompTechDescr' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryMotionCompTechDescr(),
                'RespiratorySignalSourceID' => new \PHPExiftool\Driver\Tag\DICOM\RespiratorySignalSourceID(),
                'ChemicalShiftsMinIntegrateLimitHz' => new \PHPExiftool\Driver\Tag\DICOM\ChemicalShiftsMinIntegrateLimitHz(),
                'ChemicalShiftsMaxIntegrateLimitHz' => new \PHPExiftool\Driver\Tag\DICOM\ChemicalShiftsMaxIntegrateLimitHz(),
                'MRVelocityEncodingSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRVelocityEncodingSequence(),
                'FirstOrderPhaseCorrection' => new \PHPExiftool\Driver\Tag\DICOM\FirstOrderPhaseCorrection(),
                'WaterReferencedPhaseCorrection' => new \PHPExiftool\Driver\Tag\DICOM\WaterReferencedPhaseCorrection(),
                'MRSpectroscopyAcquisitionType' => new \PHPExiftool\Driver\Tag\DICOM\MRSpectroscopyAcquisitionType(),
                'RespiratoryCyclePosition' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryCyclePosition(),
                'VelocityEncodingMaximumValue' => new \PHPExiftool\Driver\Tag\DICOM\VelocityEncodingMaximumValue(),
                'TagSpacingSecondDimension' => new \PHPExiftool\Driver\Tag\DICOM\TagSpacingSecondDimension(),
                'TagAngleSecondAxis' => new \PHPExiftool\Driver\Tag\DICOM\TagAngleSecondAxis(),
                'FrameAcquisitionDuration' => new \PHPExiftool\Driver\Tag\DICOM\FrameAcquisitionDuration(),
                'MRImageFrameTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRImageFrameTypeSequence(),
                'MRSpectroscopyFrameTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\MRSpectroscopyFrameTypeSequence(),
                'MRAcqPhaseEncodingStepsInPlane' => new \PHPExiftool\Driver\Tag\DICOM\MRAcqPhaseEncodingStepsInPlane(),
                'MRAcqPhaseEncodingStepsOutOfPlane' => new \PHPExiftool\Driver\Tag\DICOM\MRAcqPhaseEncodingStepsOutOfPlane(),
                'SpectroscopyAcqPhaseColumns' => new \PHPExiftool\Driver\Tag\DICOM\SpectroscopyAcqPhaseColumns(),
                'CardiacCyclePosition' => new \PHPExiftool\Driver\Tag\DICOM\CardiacCyclePosition(),
                'SpecificAbsorptionRateSequence' => new \PHPExiftool\Driver\Tag\DICOM\SpecificAbsorptionRateSequence(),
                'RFEchoTrainLength' => new \PHPExiftool\Driver\Tag\DICOM\RFEchoTrainLength(),
                'GradientEchoTrainLength' => new \PHPExiftool\Driver\Tag\DICOM\GradientEchoTrainLength(),
                'ChemicalShiftsMinIntegrateLimitPPM' => new \PHPExiftool\Driver\Tag\DICOM\ChemicalShiftsMinIntegrateLimitPPM(),
                'ChemicalShiftsMaxIntegrateLimitPPM' => new \PHPExiftool\Driver\Tag\DICOM\ChemicalShiftsMaxIntegrateLimitPPM(),
                'CTAcquisitionTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTAcquisitionTypeSequence(),
                'AcquisitionType' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionType(),
                'TubeAngle' => new \PHPExiftool\Driver\Tag\DICOM\TubeAngle(),
                'CTAcquisitionDetailsSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTAcquisitionDetailsSequence(),
                'RevolutionTime' => new \PHPExiftool\Driver\Tag\DICOM\RevolutionTime(),
                'SingleCollimationWidth' => new \PHPExiftool\Driver\Tag\DICOM\SingleCollimationWidth(),
                'TotalCollimationWidth' => new \PHPExiftool\Driver\Tag\DICOM\TotalCollimationWidth(),
                'CTTableDynamicsSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTTableDynamicsSequence(),
                'TableSpeed' => new \PHPExiftool\Driver\Tag\DICOM\TableSpeed(),
                'TableFeedPerRotation' => new \PHPExiftool\Driver\Tag\DICOM\TableFeedPerRotation(),
                'SpiralPitchFactor' => new \PHPExiftool\Driver\Tag\DICOM\SpiralPitchFactor(),
                'CTGeometrySequence' => new \PHPExiftool\Driver\Tag\DICOM\CTGeometrySequence(),
                'DataCollectionCenterPatient' => new \PHPExiftool\Driver\Tag\DICOM\DataCollectionCenterPatient(),
                'CTReconstructionSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTReconstructionSequence(),
                'ReconstructionAlgorithm' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionAlgorithm(),
                'ConvolutionKernelGroup' => new \PHPExiftool\Driver\Tag\DICOM\ConvolutionKernelGroup(),
                'ReconstructionFieldOfView' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionFieldOfView(),
                'ReconstructionTargetCenterPatient' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionTargetCenterPatient(),
                'ReconstructionAngle' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionAngle(),
                'ImageFilter' => new \PHPExiftool\Driver\Tag\DICOM\ImageFilter(),
                'CTExposureSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTExposureSequence(),
                'ReconstructionPixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionPixelSpacing(),
                'ExposureModulationType' => new \PHPExiftool\Driver\Tag\DICOM\ExposureModulationType(),
                'EstimatedDoseSaving' => new \PHPExiftool\Driver\Tag\DICOM\EstimatedDoseSaving(),
                'CTXRayDetailsSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTXRayDetailsSequence(),
                'CTPositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTPositionSequence(),
                'TablePosition' => new \PHPExiftool\Driver\Tag\DICOM\TablePosition(),
                'ExposureTimeInMilliSec' => new \PHPExiftool\Driver\Tag\DICOM\ExposureTimeInMilliSec(),
                'CTImageFrameTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTImageFrameTypeSequence(),
                'XRayTubeCurrentInMilliAmps' => new \PHPExiftool\Driver\Tag\DICOM\XRayTubeCurrentInMilliAmps(),
                'ExposureInMilliAmpSec' => new \PHPExiftool\Driver\Tag\DICOM\ExposureInMilliAmpSec(),
                'ConstantVolumeFlag' => new \PHPExiftool\Driver\Tag\DICOM\ConstantVolumeFlag(),
                'FluoroscopyFlag' => new \PHPExiftool\Driver\Tag\DICOM\FluoroscopyFlag(),
                'SourceToDataCollectionCenterDist' => new \PHPExiftool\Driver\Tag\DICOM\SourceToDataCollectionCenterDist(),
                'ContrastBolusAgentNumber' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAgentNumber(),
                'ContrastBolusIngredientCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusIngredientCodeSeq(),
                'ContrastAdministrationProfileSeq' => new \PHPExiftool\Driver\Tag\DICOM\ContrastAdministrationProfileSeq(),
                'ContrastBolusUsageSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusUsageSequence(),
                'ContrastBolusAgentAdministered' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAgentAdministered(),
                'ContrastBolusAgentDetected' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAgentDetected(),
                'ContrastBolusAgentPhase' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusAgentPhase(),
                'CTDIvol' => new \PHPExiftool\Driver\Tag\DICOM\CTDIvol(),
                'CTDIPhantomTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTDIPhantomTypeCodeSequence(),
                'CalciumScoringMassFactorPatient' => new \PHPExiftool\Driver\Tag\DICOM\CalciumScoringMassFactorPatient(),
                'CalciumScoringMassFactorDevice' => new \PHPExiftool\Driver\Tag\DICOM\CalciumScoringMassFactorDevice(),
                'EnergyWeightingFactor' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWeightingFactor(),
                'CTAdditionalXRaySourceSequence' => new \PHPExiftool\Driver\Tag\DICOM\CTAdditionalXRaySourceSequence(),
                'ProjectionPixelCalibrationSequence' => new \PHPExiftool\Driver\Tag\DICOM\ProjectionPixelCalibrationSequence(),
                'DistanceSourceToIsocenter' => new \PHPExiftool\Driver\Tag\DICOM\DistanceSourceToIsocenter(),
                'DistanceObjectToTableTop' => new \PHPExiftool\Driver\Tag\DICOM\DistanceObjectToTableTop(),
                'ObjectPixelSpacingInCenterOfBeam' => new \PHPExiftool\Driver\Tag\DICOM\ObjectPixelSpacingInCenterOfBeam(),
                'PositionerPositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\PositionerPositionSequence(),
                'TablePositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\TablePositionSequence(),
                'CollimatorShapeSequence' => new \PHPExiftool\Driver\Tag\DICOM\CollimatorShapeSequence(),
                'XA-XRFFrameCharacteristicsSequence' => new \PHPExiftool\Driver\Tag\DICOM\XAXRFFrameCharacteristicsSequence(),
                'FrameAcquisitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameAcquisitionSequence(),
                'XRayReceptorType' => new \PHPExiftool\Driver\Tag\DICOM\XRayReceptorType(),
                'AcquisitionProtocolName' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionProtocolName(),
                'AcquisitionProtocolDescription' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionProtocolDescription(),
                'ContrastBolusIngredientOpaque' => new \PHPExiftool\Driver\Tag\DICOM\ContrastBolusIngredientOpaque(),
                'DistanceReceptorPlaneToDetHousing' => new \PHPExiftool\Driver\Tag\DICOM\DistanceReceptorPlaneToDetHousing(),
                'IntensifierActiveShape' => new \PHPExiftool\Driver\Tag\DICOM\IntensifierActiveShape(),
                'IntensifierActiveDimensions' => new \PHPExiftool\Driver\Tag\DICOM\IntensifierActiveDimensions(),
                'PhysicalDetectorSize' => new \PHPExiftool\Driver\Tag\DICOM\PhysicalDetectorSize(),
                'PositionOfIsocenterProjection' => new \PHPExiftool\Driver\Tag\DICOM\PositionOfIsocenterProjection(),
                'FieldOfViewSequence' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewSequence(),
                'FieldOfViewDescription' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewDescription(),
                'ExposureControlSensingRegionsSeq' => new \PHPExiftool\Driver\Tag\DICOM\ExposureControlSensingRegionsSeq(),
                'ExposureControlSensingRegionShape' => new \PHPExiftool\Driver\Tag\DICOM\ExposureControlSensingRegionShape(),
                'ExposureControlSensRegionLeftEdge' => new \PHPExiftool\Driver\Tag\DICOM\ExposureControlSensRegionLeftEdge(),
                'ExposureControlSensRegionRightEdge' => new \PHPExiftool\Driver\Tag\DICOM\ExposureControlSensRegionRightEdge(),
                'CenterOfCircExposControlSensRegion' => new \PHPExiftool\Driver\Tag\DICOM\CenterOfCircExposControlSensRegion(),
                'RadiusOfCircExposControlSensRegion' => new \PHPExiftool\Driver\Tag\DICOM\RadiusOfCircExposControlSensRegion(),
                'ColumnAngulationPatient' => new \PHPExiftool\Driver\Tag\DICOM\ColumnAngulationPatient(),
                'BeamAngle' => new \PHPExiftool\Driver\Tag\DICOM\BeamAngle(),
                'FrameDetectorParametersSequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameDetectorParametersSequence(),
                'CalculatedAnatomyThickness' => new \PHPExiftool\Driver\Tag\DICOM\CalculatedAnatomyThickness(),
                'CalibrationSequence' => new \PHPExiftool\Driver\Tag\DICOM\CalibrationSequence(),
                'ObjectThicknessSequence' => new \PHPExiftool\Driver\Tag\DICOM\ObjectThicknessSequence(),
                'PlaneIdentification' => new \PHPExiftool\Driver\Tag\DICOM\PlaneIdentification(),
                'FieldOfViewDimensionsInFloat' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewDimensionsInFloat(),
                'IsocenterReferenceSystemSequence' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterReferenceSystemSequence(),
                'PositionerIsocenterPrimaryAngle' => new \PHPExiftool\Driver\Tag\DICOM\PositionerIsocenterPrimaryAngle(),
                'PositionerIsocenterSecondaryAngle' => new \PHPExiftool\Driver\Tag\DICOM\PositionerIsocenterSecondaryAngle(),
                'PositionerIsocenterDetRotAngle' => new \PHPExiftool\Driver\Tag\DICOM\PositionerIsocenterDetRotAngle(),
                'TableXPositionToIsocenter' => new \PHPExiftool\Driver\Tag\DICOM\TableXPositionToIsocenter(),
                'TableYPositionToIsocenter' => new \PHPExiftool\Driver\Tag\DICOM\TableYPositionToIsocenter(),
                'TableZPositionToIsocenter' => new \PHPExiftool\Driver\Tag\DICOM\TableZPositionToIsocenter(),
                'TableHorizontalRotationAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableHorizontalRotationAngle(),
                'TableHeadTiltAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableHeadTiltAngle(),
                'TableCradleTiltAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableCradleTiltAngle(),
                'FrameDisplayShutterSequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameDisplayShutterSequence(),
                'AcquiredImageAreaDoseProduct' => new \PHPExiftool\Driver\Tag\DICOM\AcquiredImageAreaDoseProduct(),
                'CArmPositionerTabletopRelationship' => new \PHPExiftool\Driver\Tag\DICOM\CArmPositionerTabletopRelationship(),
                'XRayGeometrySequence' => new \PHPExiftool\Driver\Tag\DICOM\XRayGeometrySequence(),
                'IrradiationEventIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\IrradiationEventIDSequence(),
                'XRay3DFrameTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\XRay3DFrameTypeSequence(),
                'ContributingSourcesSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContributingSourcesSequence(),
                'XRay3DAcquisitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\XRay3DAcquisitionSequence(),
                'PrimaryPositionerScanArc' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryPositionerScanArc(),
                'SecondaryPositionerScanArc' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryPositionerScanArc(),
                'PrimaryPositionerScanStartAngle' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryPositionerScanStartAngle(),
                'SecondaryPositionerScanStartAngle' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryPositionerScanStartAngle(),
                'PrimaryPositionerIncrement' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryPositionerIncrement(),
                'SecondaryPositionerIncrement' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryPositionerIncrement(),
                'StartAcquisitionDateTime' => new \PHPExiftool\Driver\Tag\DICOM\StartAcquisitionDateTime(),
                'EndAcquisitionDateTime' => new \PHPExiftool\Driver\Tag\DICOM\EndAcquisitionDateTime(),
                'ApplicationName' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationName(),
                'ApplicationVersion' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationVersion(),
                'ApplicationManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationManufacturer(),
                'AlgorithmType' => new \PHPExiftool\Driver\Tag\DICOM\AlgorithmType(),
                'AlgorithmDescription' => new \PHPExiftool\Driver\Tag\DICOM\AlgorithmDescription(),
                'XRay3DReconstructionSequence' => new \PHPExiftool\Driver\Tag\DICOM\XRay3DReconstructionSequence(),
                'ReconstructionDescription' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionDescription(),
                'PerProjectionAcquisitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerProjectionAcquisitionSequence(),
                'DiffusionBMatrixSequence' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBMatrixSequence(),
                'DiffusionBValueXX' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValueXX(),
                'DiffusionBValueXY' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValueXY(),
                'DiffusionBValueXZ' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValueXZ(),
                'DiffusionBValueYY' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValueYY(),
                'DiffusionBValueYZ' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValueYZ(),
                'DiffusionBValueZZ' => new \PHPExiftool\Driver\Tag\DICOM\DiffusionBValueZZ(),
                'DecayCorrectionDateTime' => new \PHPExiftool\Driver\Tag\DICOM\DecayCorrectionDateTime(),
                'StartDensityThreshold' => new \PHPExiftool\Driver\Tag\DICOM\StartDensityThreshold(),
                'TerminationTimeThreshold' => new \PHPExiftool\Driver\Tag\DICOM\TerminationTimeThreshold(),
                'DetectorGeometry' => new \PHPExiftool\Driver\Tag\DICOM\DetectorGeometry(),
                'AxialDetectorDimension' => new \PHPExiftool\Driver\Tag\DICOM\AxialDetectorDimension(),
                'PETPositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\PETPositionSequence(),
                'NumberOfIterations' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfIterations(),
                'NumberOfSubsets' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSubsets(),
                'PETFrameTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PETFrameTypeSequence(),
                'ReconstructionType' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionType(),
                'DecayCorrected' => new \PHPExiftool\Driver\Tag\DICOM\DecayCorrected(),
                'AttenuationCorrected' => new \PHPExiftool\Driver\Tag\DICOM\AttenuationCorrected(),
                'ScatterCorrected' => new \PHPExiftool\Driver\Tag\DICOM\ScatterCorrected(),
                'DeadTimeCorrected' => new \PHPExiftool\Driver\Tag\DICOM\DeadTimeCorrected(),
                'GantryMotionCorrected' => new \PHPExiftool\Driver\Tag\DICOM\GantryMotionCorrected(),
                'PatientMotionCorrected' => new \PHPExiftool\Driver\Tag\DICOM\PatientMotionCorrected(),
                'RandomsCorrected' => new \PHPExiftool\Driver\Tag\DICOM\RandomsCorrected(),
                'SensitivityCalibrated' => new \PHPExiftool\Driver\Tag\DICOM\SensitivityCalibrated(),
                'DepthsOfFocus' => new \PHPExiftool\Driver\Tag\DICOM\DepthsOfFocus(),
                'ExclusionStartDatetime' => new \PHPExiftool\Driver\Tag\DICOM\ExclusionStartDatetime(),
                'ExclusionDuration' => new \PHPExiftool\Driver\Tag\DICOM\ExclusionDuration(),
                'ImageDataTypeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ImageDataTypeSequence(),
                'DataType' => new \PHPExiftool\Driver\Tag\DICOM\DataType(),
                'AliasedDataType' => new \PHPExiftool\Driver\Tag\DICOM\AliasedDataType(),
                'ContributingEquipmentSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContributingEquipmentSequence(),
                'ContributionDateTime' => new \PHPExiftool\Driver\Tag\DICOM\ContributionDateTime(),
                'ContributionDescription' => new \PHPExiftool\Driver\Tag\DICOM\ContributionDescription(),
                'NumberOfCellsIInDetector' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfCellsIInDetector(),
                'CellNumberAtTheta' => new \PHPExiftool\Driver\Tag\DICOM\CellNumberAtTheta(),
                'CellSpacing' => new \PHPExiftool\Driver\Tag\DICOM\CellSpacing(),
                'HorizFrameOfRef' => new \PHPExiftool\Driver\Tag\DICOM\HorizFrameOfRef(),
                'SeriesContrast' => new \PHPExiftool\Driver\Tag\DICOM\SeriesContrast(),
                'LastPseq' => new \PHPExiftool\Driver\Tag\DICOM\LastPseq(),
                'StartNumberForBaseline' => new \PHPExiftool\Driver\Tag\DICOM\StartNumberForBaseline(),
                'EndNumberForBaseline' => new \PHPExiftool\Driver\Tag\DICOM\EndNumberForBaseline(),
                'StartNumberForEnhancedScans' => new \PHPExiftool\Driver\Tag\DICOM\StartNumberForEnhancedScans(),
                'EndNumberForEnhancedScans' => new \PHPExiftool\Driver\Tag\DICOM\EndNumberForEnhancedScans(),
                'SeriesPlane' => new \PHPExiftool\Driver\Tag\DICOM\SeriesPlane(),
                'FirstScanRas' => new \PHPExiftool\Driver\Tag\DICOM\FirstScanRas(),
                'FirstScanLocation' => new \PHPExiftool\Driver\Tag\DICOM\FirstScanLocation(),
                'LastScanRas' => new \PHPExiftool\Driver\Tag\DICOM\LastScanRas(),
                'LastScanLoc' => new \PHPExiftool\Driver\Tag\DICOM\LastScanLoc(),
                'DisplayFieldOfView' => new \PHPExiftool\Driver\Tag\DICOM\DisplayFieldOfView(),
                'MidScanTime' => new \PHPExiftool\Driver\Tag\DICOM\MidScanTime(),
                'MidScanFlag' => new \PHPExiftool\Driver\Tag\DICOM\MidScanFlag(),
                'DegreesOfAzimuth' => new \PHPExiftool\Driver\Tag\DICOM\DegreesOfAzimuth(),
                'GantryPeriod' => new \PHPExiftool\Driver\Tag\DICOM\GantryPeriod(),
                'XRayOnPosition' => new \PHPExiftool\Driver\Tag\DICOM\XRayOnPosition(),
                'XRayOffPosition' => new \PHPExiftool\Driver\Tag\DICOM\XRayOffPosition(),
                'NumberOfTriggers' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTriggers(),
                'AngleOfFirstView' => new \PHPExiftool\Driver\Tag\DICOM\AngleOfFirstView(),
                'TriggerFrequency' => new \PHPExiftool\Driver\Tag\DICOM\TriggerFrequency(),
                'ScanFOVType' => new \PHPExiftool\Driver\Tag\DICOM\ScanFOVType(),
                'StatReconFlag' => new \PHPExiftool\Driver\Tag\DICOM\StatReconFlag(),
                'ComputeType' => new \PHPExiftool\Driver\Tag\DICOM\ComputeType(),
                'SegmentNumber' => new \PHPExiftool\Driver\Tag\DICOM\SegmentNumber(),
                'TotalSegmentsRequested' => new \PHPExiftool\Driver\Tag\DICOM\TotalSegmentsRequested(),
                'InterscanDelay' => new \PHPExiftool\Driver\Tag\DICOM\InterscanDelay(),
                'ViewCompressionFactor' => new \PHPExiftool\Driver\Tag\DICOM\ViewCompressionFactor(),
                'TotalNoOfRefChannels' => new \PHPExiftool\Driver\Tag\DICOM\TotalNoOfRefChannels(),
                'DataSizeForScanData' => new \PHPExiftool\Driver\Tag\DICOM\DataSizeForScanData(),
                'ReconPostProcflag' => new \PHPExiftool\Driver\Tag\DICOM\ReconPostProcflag(),
                'CTWaterNumber' => new \PHPExiftool\Driver\Tag\DICOM\CTWaterNumber(),
                'CTBoneNumber' => new \PHPExiftool\Driver\Tag\DICOM\CTBoneNumber(),
                'NumberOfChannels' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfChannels(),
                'IncrementBetweenChannels' => new \PHPExiftool\Driver\Tag\DICOM\IncrementBetweenChannels(),
                'StartingView' => new \PHPExiftool\Driver\Tag\DICOM\StartingView(),
                'NumberOfViews' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViews(),
                'IncrementBetweenViews' => new \PHPExiftool\Driver\Tag\DICOM\IncrementBetweenViews(),
                'DependantOnNoViewsProcessed' => new \PHPExiftool\Driver\Tag\DICOM\DependantOnNoViewsProcessed(),
                'FieldOfViewInDetectorCells' => new \PHPExiftool\Driver\Tag\DICOM\FieldOfViewInDetectorCells(),
                'ValueOfBackProjectionButton' => new \PHPExiftool\Driver\Tag\DICOM\ValueOfBackProjectionButton(),
                'SetIfFatqEstimatesWereUsed' => new \PHPExiftool\Driver\Tag\DICOM\SetIfFatqEstimatesWereUsed(),
                'ZChanAvgOverViews' => new \PHPExiftool\Driver\Tag\DICOM\ZChanAvgOverViews(),
                'AvgOfLeftRefChansOverViews' => new \PHPExiftool\Driver\Tag\DICOM\AvgOfLeftRefChansOverViews(),
                'MaxLeftChanOverViews' => new \PHPExiftool\Driver\Tag\DICOM\MaxLeftChanOverViews(),
                'AvgOfRightRefChansOverViews' => new \PHPExiftool\Driver\Tag\DICOM\AvgOfRightRefChansOverViews(),
                'MaxRightChanOverViews' => new \PHPExiftool\Driver\Tag\DICOM\MaxRightChanOverViews(),
                'SecondEcho' => new \PHPExiftool\Driver\Tag\DICOM\SecondEcho(),
                'NumberOfEchoes' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfEchoes(),
                'TableDelta' => new \PHPExiftool\Driver\Tag\DICOM\TableDelta(),
                'Contiguous' => new \PHPExiftool\Driver\Tag\DICOM\Contiguous(),
                'PeakSAR' => new \PHPExiftool\Driver\Tag\DICOM\PeakSAR(),
                'MonitorSAR' => new \PHPExiftool\Driver\Tag\DICOM\MonitorSAR(),
                'CardiacRepetitionTime' => new \PHPExiftool\Driver\Tag\DICOM\CardiacRepetitionTime(),
                'ImagesPerCardiacCycle' => new \PHPExiftool\Driver\Tag\DICOM\ImagesPerCardiacCycle(),
                'ActualReceiveGainAnalog' => new \PHPExiftool\Driver\Tag\DICOM\ActualReceiveGainAnalog(),
                'ActualReceiveGainDigital' => new \PHPExiftool\Driver\Tag\DICOM\ActualReceiveGainDigital(),
                'DelayAfterTrigger' => new \PHPExiftool\Driver\Tag\DICOM\DelayAfterTrigger(),
                'Swappf' => new \PHPExiftool\Driver\Tag\DICOM\Swappf(),
                'PauseInterval' => new \PHPExiftool\Driver\Tag\DICOM\PauseInterval(),
                'PulseTime' => new \PHPExiftool\Driver\Tag\DICOM\PulseTime(),
                'SliceOffsetOnFreqAxis' => new \PHPExiftool\Driver\Tag\DICOM\SliceOffsetOnFreqAxis(),
                'CenterFrequency' => new \PHPExiftool\Driver\Tag\DICOM\CenterFrequency(),
                'TransmitGain' => new \PHPExiftool\Driver\Tag\DICOM\TransmitGain(),
                'AnalogReceiverGain' => new \PHPExiftool\Driver\Tag\DICOM\AnalogReceiverGain(),
                'DigitalReceiverGain' => new \PHPExiftool\Driver\Tag\DICOM\DigitalReceiverGain(),
                'BitmapDefiningCVs' => new \PHPExiftool\Driver\Tag\DICOM\BitmapDefiningCVs(),
                'CenterFreqMethod' => new \PHPExiftool\Driver\Tag\DICOM\CenterFreqMethod(),
                'PulseSeqMode' => new \PHPExiftool\Driver\Tag\DICOM\PulseSeqMode(),
                'PulseSeqName' => new \PHPExiftool\Driver\Tag\DICOM\PulseSeqName(),
                'PulseSeqDate' => new \PHPExiftool\Driver\Tag\DICOM\PulseSeqDate(),
                'InternalPulseSeqName' => new \PHPExiftool\Driver\Tag\DICOM\InternalPulseSeqName(),
                'TransmittingCoil' => new \PHPExiftool\Driver\Tag\DICOM\TransmittingCoil(),
                'SurfaceCoilType' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceCoilType(),
                'ExtremityCoilFlag' => new \PHPExiftool\Driver\Tag\DICOM\ExtremityCoilFlag(),
                'RawDataRunNumber' => new \PHPExiftool\Driver\Tag\DICOM\RawDataRunNumber(),
                'CalibratedFieldStrength' => new \PHPExiftool\Driver\Tag\DICOM\CalibratedFieldStrength(),
                'SATFatWaterBone' => new \PHPExiftool\Driver\Tag\DICOM\SATFatWaterBone(),
                'ReceiveBandwidth' => new \PHPExiftool\Driver\Tag\DICOM\ReceiveBandwidth(),
                'UserData01' => new \PHPExiftool\Driver\Tag\DICOM\UserData01(),
                'UserData02' => new \PHPExiftool\Driver\Tag\DICOM\UserData02(),
                'UserData03' => new \PHPExiftool\Driver\Tag\DICOM\UserData03(),
                'UserData04' => new \PHPExiftool\Driver\Tag\DICOM\UserData04(),
                'UserData05' => new \PHPExiftool\Driver\Tag\DICOM\UserData05(),
                'UserData06' => new \PHPExiftool\Driver\Tag\DICOM\UserData06(),
                'UserData07' => new \PHPExiftool\Driver\Tag\DICOM\UserData07(),
                'UserData08' => new \PHPExiftool\Driver\Tag\DICOM\UserData08(),
                'UserData09' => new \PHPExiftool\Driver\Tag\DICOM\UserData09(),
                'UserData10' => new \PHPExiftool\Driver\Tag\DICOM\UserData10(),
                'UserData11' => new \PHPExiftool\Driver\Tag\DICOM\UserData11(),
                'UserData12' => new \PHPExiftool\Driver\Tag\DICOM\UserData12(),
                'UserData13' => new \PHPExiftool\Driver\Tag\DICOM\UserData13(),
                'UserData14' => new \PHPExiftool\Driver\Tag\DICOM\UserData14(),
                'UserData15' => new \PHPExiftool\Driver\Tag\DICOM\UserData15(),
                'UserData16' => new \PHPExiftool\Driver\Tag\DICOM\UserData16(),
                'UserData17' => new \PHPExiftool\Driver\Tag\DICOM\UserData17(),
                'UserData18' => new \PHPExiftool\Driver\Tag\DICOM\UserData18(),
                'UserData19' => new \PHPExiftool\Driver\Tag\DICOM\UserData19(),
                'UserData20' => new \PHPExiftool\Driver\Tag\DICOM\UserData20(),
                'UserData21' => new \PHPExiftool\Driver\Tag\DICOM\UserData21(),
                'UserData22' => new \PHPExiftool\Driver\Tag\DICOM\UserData22(),
                'UserData23' => new \PHPExiftool\Driver\Tag\DICOM\UserData23(),
                'ProjectionAngle' => new \PHPExiftool\Driver\Tag\DICOM\ProjectionAngle(),
                'SaturationPlanes' => new \PHPExiftool\Driver\Tag\DICOM\SaturationPlanes(),
                'SurfaceCoilIntensity' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceCoilIntensity(),
                'SATLocationR' => new \PHPExiftool\Driver\Tag\DICOM\SATLocationR(),
                'SATLocationL' => new \PHPExiftool\Driver\Tag\DICOM\SATLocationL(),
                'SATLocationA' => new \PHPExiftool\Driver\Tag\DICOM\SATLocationA(),
                'SATLocationP' => new \PHPExiftool\Driver\Tag\DICOM\SATLocationP(),
                'SATLocationH' => new \PHPExiftool\Driver\Tag\DICOM\SATLocationH(),
                'SATLocationF' => new \PHPExiftool\Driver\Tag\DICOM\SATLocationF(),
                'SATThicknessR-L' => new \PHPExiftool\Driver\Tag\DICOM\SATThicknessRL(),
                'SATThicknessA-P' => new \PHPExiftool\Driver\Tag\DICOM\SATThicknessAP(),
                'SATThicknessH-F' => new \PHPExiftool\Driver\Tag\DICOM\SATThicknessHF(),
                'PrescribedFlowAxis' => new \PHPExiftool\Driver\Tag\DICOM\PrescribedFlowAxis(),
                'VelocityEncoding' => new \PHPExiftool\Driver\Tag\DICOM\VelocityEncoding(),
                'ThicknessDisclaimer' => new \PHPExiftool\Driver\Tag\DICOM\ThicknessDisclaimer(),
                'PrescanType' => new \PHPExiftool\Driver\Tag\DICOM\PrescanType(),
                'PrescanStatus' => new \PHPExiftool\Driver\Tag\DICOM\PrescanStatus(),
                'RawDataType' => new \PHPExiftool\Driver\Tag\DICOM\RawDataType(),
                'ProjectionAlgorithm' => new \PHPExiftool\Driver\Tag\DICOM\ProjectionAlgorithm(),
                'FractionalEcho' => new \PHPExiftool\Driver\Tag\DICOM\FractionalEcho(),
                'PrepPulse' => new \PHPExiftool\Driver\Tag\DICOM\PrepPulse(),
                'CardiacPhases' => new \PHPExiftool\Driver\Tag\DICOM\CardiacPhases(),
                'VariableEchoflag' => new \PHPExiftool\Driver\Tag\DICOM\VariableEchoflag(),
                'ConcatenatedSAT' => new \PHPExiftool\Driver\Tag\DICOM\ConcatenatedSAT(),
                'ReferenceChannelUsed' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceChannelUsed(),
                'BackProjectorCoefficient' => new \PHPExiftool\Driver\Tag\DICOM\BackProjectorCoefficient(),
                'PrimarySpeedCorrectionUsed' => new \PHPExiftool\Driver\Tag\DICOM\PrimarySpeedCorrectionUsed(),
                'OverrangeCorrectionUsed' => new \PHPExiftool\Driver\Tag\DICOM\OverrangeCorrectionUsed(),
                'DynamicZAlphaValue' => new \PHPExiftool\Driver\Tag\DICOM\DynamicZAlphaValue(),
                'UserData' => new \PHPExiftool\Driver\Tag\DICOM\UserData(),
                'VelocityEncodeScale' => new \PHPExiftool\Driver\Tag\DICOM\VelocityEncodeScale(),
                'FastPhases' => new \PHPExiftool\Driver\Tag\DICOM\FastPhases(),
                'TransmissionGain' => new \PHPExiftool\Driver\Tag\DICOM\TransmissionGain(),
                'RelationshipGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\RelationshipGroupLength(),
                'StudyInstanceUID' => new \PHPExiftool\Driver\Tag\DICOM\StudyInstanceUID(),
                'SeriesInstanceUID' => new \PHPExiftool\Driver\Tag\DICOM\SeriesInstanceUID(),
                'StudyID' => new \PHPExiftool\Driver\Tag\DICOM\StudyID(),
                'SeriesNumber' => new \PHPExiftool\Driver\Tag\DICOM\SeriesNumber(),
                'AcquisitionNumber' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionNumber(),
                'InstanceNumber' => new \PHPExiftool\Driver\Tag\DICOM\InstanceNumber(),
                'IsotopeNumber' => new \PHPExiftool\Driver\Tag\DICOM\IsotopeNumber(),
                'PhaseNumber' => new \PHPExiftool\Driver\Tag\DICOM\PhaseNumber(),
                'IntervalNumber' => new \PHPExiftool\Driver\Tag\DICOM\IntervalNumber(),
                'TimeSlotNumber' => new \PHPExiftool\Driver\Tag\DICOM\TimeSlotNumber(),
                'AngleNumber' => new \PHPExiftool\Driver\Tag\DICOM\AngleNumber(),
                'ItemNumber' => new \PHPExiftool\Driver\Tag\DICOM\ItemNumber(),
                'PatientOrientation' => new \PHPExiftool\Driver\Tag\DICOM\PatientOrientation(),
                'OverlayNumber' => new \PHPExiftool\Driver\Tag\DICOM\OverlayNumber(),
                'CurveNumber' => new \PHPExiftool\Driver\Tag\DICOM\CurveNumber(),
                'LookupTableNumber' => new \PHPExiftool\Driver\Tag\DICOM\LookupTableNumber(),
                'ImagePosition' => new \PHPExiftool\Driver\Tag\DICOM\ImagePosition(),
                'ImagePositionPatient' => new \PHPExiftool\Driver\Tag\DICOM\ImagePositionPatient(),
                'ImageOrientation' => new \PHPExiftool\Driver\Tag\DICOM\ImageOrientation(),
                'ImageOrientationPatient' => new \PHPExiftool\Driver\Tag\DICOM\ImageOrientationPatient(),
                'Location' => new \PHPExiftool\Driver\Tag\DICOM\Location(),
                'FrameOfReferenceUID' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfReferenceUID(),
                'Laterality' => new \PHPExiftool\Driver\Tag\DICOM\Laterality(),
                'ImageLaterality' => new \PHPExiftool\Driver\Tag\DICOM\ImageLaterality(),
                'ImageGeometryType' => new \PHPExiftool\Driver\Tag\DICOM\ImageGeometryType(),
                'MaskingImage' => new \PHPExiftool\Driver\Tag\DICOM\MaskingImage(),
                'TemporalPositionIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\TemporalPositionIdentifier(),
                'NumberOfTemporalPositions' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTemporalPositions(),
                'TemporalResolution' => new \PHPExiftool\Driver\Tag\DICOM\TemporalResolution(),
                'SynchronizationFrameOfReferenceUID' => new \PHPExiftool\Driver\Tag\DICOM\SynchronizationFrameOfReferenceUID(),
                'SeriesInStudy' => new \PHPExiftool\Driver\Tag\DICOM\SeriesInStudy(),
                'AcquisitionsInSeries' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionsInSeries(),
                'ImagesInAcquisition' => new \PHPExiftool\Driver\Tag\DICOM\ImagesInAcquisition(),
                'ImagesInSeries' => new \PHPExiftool\Driver\Tag\DICOM\ImagesInSeries(),
                'AcquisitionsInStudy' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionsInStudy(),
                'ImagesInStudy' => new \PHPExiftool\Driver\Tag\DICOM\ImagesInStudy(),
                'Reference' => new \PHPExiftool\Driver\Tag\DICOM\Reference(),
                'PositionReferenceIndicator' => new \PHPExiftool\Driver\Tag\DICOM\PositionReferenceIndicator(),
                'SliceLocation' => new \PHPExiftool\Driver\Tag\DICOM\SliceLocation(),
                'OtherStudyNumbers' => new \PHPExiftool\Driver\Tag\DICOM\OtherStudyNumbers(),
                'NumberOfPatientRelatedStudies' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPatientRelatedStudies(),
                'NumberOfPatientRelatedSeries' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPatientRelatedSeries(),
                'NumberOfPatientRelatedInstances' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPatientRelatedInstances(),
                'NumberOfStudyRelatedSeries' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfStudyRelatedSeries(),
                'NumberOfStudyRelatedInstances' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfStudyRelatedInstances(),
                'NumberOfSeriesRelatedInstances' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSeriesRelatedInstances(),
                'SourceImageIDs' => new \PHPExiftool\Driver\Tag\DICOM\SourceImageIDs(),
                'ModifyingDeviceID' => new \PHPExiftool\Driver\Tag\DICOM\ModifyingDeviceID(),
                'ModifiedImageID' => new \PHPExiftool\Driver\Tag\DICOM\ModifiedImageID(),
                'ModifiedImageDate' => new \PHPExiftool\Driver\Tag\DICOM\ModifiedImageDate(),
                'ModifyingDeviceManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\ModifyingDeviceManufacturer(),
                'ModifiedImageTime' => new \PHPExiftool\Driver\Tag\DICOM\ModifiedImageTime(),
                'ModifiedImageDescription' => new \PHPExiftool\Driver\Tag\DICOM\ModifiedImageDescription(),
                'ImageComments' => new \PHPExiftool\Driver\Tag\DICOM\ImageComments(),
                'OriginalImageIdentification' => new \PHPExiftool\Driver\Tag\DICOM\OriginalImageIdentification(),
                'OriginalImageIdentNomenclature' => new \PHPExiftool\Driver\Tag\DICOM\OriginalImageIdentNomenclature(),
                'StackID' => new \PHPExiftool\Driver\Tag\DICOM\StackID(),
                'InStackPositionNumber' => new \PHPExiftool\Driver\Tag\DICOM\InStackPositionNumber(),
                'FrameAnatomySequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameAnatomySequence(),
                'FrameLaterality' => new \PHPExiftool\Driver\Tag\DICOM\FrameLaterality(),
                'FrameContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameContentSequence(),
                'PlanePositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\PlanePositionSequence(),
                'PlaneOrientationSequence' => new \PHPExiftool\Driver\Tag\DICOM\PlaneOrientationSequence(),
                'TemporalPositionIndex' => new \PHPExiftool\Driver\Tag\DICOM\TemporalPositionIndex(),
                'TriggerDelayTime' => new \PHPExiftool\Driver\Tag\DICOM\TriggerDelayTime(),
                'FrameAcquisitionNumber' => new \PHPExiftool\Driver\Tag\DICOM\FrameAcquisitionNumber(),
                'DimensionIndexValues' => new \PHPExiftool\Driver\Tag\DICOM\DimensionIndexValues(),
                'FrameComments' => new \PHPExiftool\Driver\Tag\DICOM\FrameComments(),
                'ConcatenationUID' => new \PHPExiftool\Driver\Tag\DICOM\ConcatenationUID(),
                'InConcatenationNumber' => new \PHPExiftool\Driver\Tag\DICOM\InConcatenationNumber(),
                'InConcatenationTotalNumber' => new \PHPExiftool\Driver\Tag\DICOM\InConcatenationTotalNumber(),
                'DimensionOrganizationUID' => new \PHPExiftool\Driver\Tag\DICOM\DimensionOrganizationUID(),
                'DimensionIndexPointer' => new \PHPExiftool\Driver\Tag\DICOM\DimensionIndexPointer(),
                'FunctionalGroupPointer' => new \PHPExiftool\Driver\Tag\DICOM\FunctionalGroupPointer(),
                'DimensionIndexPrivateCreator' => new \PHPExiftool\Driver\Tag\DICOM\DimensionIndexPrivateCreator(),
                'DimensionOrganizationSequence' => new \PHPExiftool\Driver\Tag\DICOM\DimensionOrganizationSequence(),
                'DimensionIndexSequence' => new \PHPExiftool\Driver\Tag\DICOM\DimensionIndexSequence(),
                'ConcatenationFrameOffsetNumber' => new \PHPExiftool\Driver\Tag\DICOM\ConcatenationFrameOffsetNumber(),
                'FunctionalGroupPrivateCreator' => new \PHPExiftool\Driver\Tag\DICOM\FunctionalGroupPrivateCreator(),
                'NominalPercentageOfCardiacPhase' => new \PHPExiftool\Driver\Tag\DICOM\NominalPercentageOfCardiacPhase(),
                'NominalPercentOfRespiratoryPhase' => new \PHPExiftool\Driver\Tag\DICOM\NominalPercentOfRespiratoryPhase(),
                'StartingRespiratoryAmplitude' => new \PHPExiftool\Driver\Tag\DICOM\StartingRespiratoryAmplitude(),
                'StartingRespiratoryPhase' => new \PHPExiftool\Driver\Tag\DICOM\StartingRespiratoryPhase(),
                'EndingRespiratoryAmplitude' => new \PHPExiftool\Driver\Tag\DICOM\EndingRespiratoryAmplitude(),
                'EndingRespiratoryPhase' => new \PHPExiftool\Driver\Tag\DICOM\EndingRespiratoryPhase(),
                'RespiratoryTriggerType' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryTriggerType(),
                'RRIntervalTimeNominal' => new \PHPExiftool\Driver\Tag\DICOM\RRIntervalTimeNominal(),
                'ActualCardiacTriggerDelayTime' => new \PHPExiftool\Driver\Tag\DICOM\ActualCardiacTriggerDelayTime(),
                'RespiratorySynchronizationSequence' => new \PHPExiftool\Driver\Tag\DICOM\RespiratorySynchronizationSequence(),
                'RespiratoryIntervalTime' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryIntervalTime(),
                'NominalRespiratoryTriggerDelayTime' => new \PHPExiftool\Driver\Tag\DICOM\NominalRespiratoryTriggerDelayTime(),
                'RespiratoryTriggerDelayThreshold' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryTriggerDelayThreshold(),
                'ActualRespiratoryTriggerDelayTime' => new \PHPExiftool\Driver\Tag\DICOM\ActualRespiratoryTriggerDelayTime(),
                'ImagePositionVolume' => new \PHPExiftool\Driver\Tag\DICOM\ImagePositionVolume(),
                'ImageOrientationVolume' => new \PHPExiftool\Driver\Tag\DICOM\ImageOrientationVolume(),
                'ApexPosition' => new \PHPExiftool\Driver\Tag\DICOM\ApexPosition(),
                'DimensionDescriptionLabel' => new \PHPExiftool\Driver\Tag\DICOM\DimensionDescriptionLabel(),
                'PatientOrientationInFrameSequence' => new \PHPExiftool\Driver\Tag\DICOM\PatientOrientationInFrameSequence(),
                'FrameLabel' => new \PHPExiftool\Driver\Tag\DICOM\FrameLabel(),
                'AcquisitionIndex' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionIndex(),
                'ContributingSOPInstancesRefSeq' => new \PHPExiftool\Driver\Tag\DICOM\ContributingSOPInstancesRefSeq(),
                'ReconstructionIndex' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionIndex(),
                'SeriesFromWhichPrescribed' => new \PHPExiftool\Driver\Tag\DICOM\SeriesFromWhichPrescribed(),
                'SeriesRecordChecksum' => new \PHPExiftool\Driver\Tag\DICOM\SeriesRecordChecksum(),
                'AcqreconRecordChecksum' => new \PHPExiftool\Driver\Tag\DICOM\AcqreconRecordChecksum(),
                'TableStartLocation' => new \PHPExiftool\Driver\Tag\DICOM\TableStartLocation(),
                'ImageFromWhichPrescribed' => new \PHPExiftool\Driver\Tag\DICOM\ImageFromWhichPrescribed(),
                'ScreenFormat' => new \PHPExiftool\Driver\Tag\DICOM\ScreenFormat(),
                'AnatomicalReferenceForScout' => new \PHPExiftool\Driver\Tag\DICOM\AnatomicalReferenceForScout(),
                'LocationsInAcquisition' => new \PHPExiftool\Driver\Tag\DICOM\LocationsInAcquisition(),
                'GraphicallyPrescribed' => new \PHPExiftool\Driver\Tag\DICOM\GraphicallyPrescribed(),
                'RotationFromSourceXRot' => new \PHPExiftool\Driver\Tag\DICOM\RotationFromSourceXRot(),
                'RotationFromSourceYRot' => new \PHPExiftool\Driver\Tag\DICOM\RotationFromSourceYRot(),
                'RotationFromSourceZRot' => new \PHPExiftool\Driver\Tag\DICOM\RotationFromSourceZRot(),
                'IntegerSlop' => new \PHPExiftool\Driver\Tag\DICOM\IntegerSlop(),
                'FloatSlop' => new \PHPExiftool\Driver\Tag\DICOM\FloatSlop(),
                'AutoWindowLevelAlpha' => new \PHPExiftool\Driver\Tag\DICOM\AutoWindowLevelAlpha(),
                'AutoWindowLevelBeta' => new \PHPExiftool\Driver\Tag\DICOM\AutoWindowLevelBeta(),
                'AutoWindowLevelWindow' => new \PHPExiftool\Driver\Tag\DICOM\AutoWindowLevelWindow(),
                'ToWindowLevelLevel' => new \PHPExiftool\Driver\Tag\DICOM\ToWindowLevelLevel(),
                'TubeFocalSpotPosition' => new \PHPExiftool\Driver\Tag\DICOM\TubeFocalSpotPosition(),
                'BiopsyPosition' => new \PHPExiftool\Driver\Tag\DICOM\BiopsyPosition(),
                'BiopsyTLocation' => new \PHPExiftool\Driver\Tag\DICOM\BiopsyTLocation(),
                'BiopsyRefLocation' => new \PHPExiftool\Driver\Tag\DICOM\BiopsyRefLocation(),
                'LightPathFilterPassThroughWavelen' => new \PHPExiftool\Driver\Tag\DICOM\LightPathFilterPassThroughWavelen(),
                'LightPathFilterPassBand' => new \PHPExiftool\Driver\Tag\DICOM\LightPathFilterPassBand(),
                'ImagePathFilterPassThroughWavelen' => new \PHPExiftool\Driver\Tag\DICOM\ImagePathFilterPassThroughWavelen(),
                'ImagePathFilterPassBand' => new \PHPExiftool\Driver\Tag\DICOM\ImagePathFilterPassBand(),
                'PatientEyeMovementCommanded' => new \PHPExiftool\Driver\Tag\DICOM\PatientEyeMovementCommanded(),
                'PatientEyeMovementCommandCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\PatientEyeMovementCommandCodeSeq(),
                'SphericalLensPower' => new \PHPExiftool\Driver\Tag\DICOM\SphericalLensPower(),
                'CylinderLensPower' => new \PHPExiftool\Driver\Tag\DICOM\CylinderLensPower(),
                'CylinderAxis' => new \PHPExiftool\Driver\Tag\DICOM\CylinderAxis(),
                'EmmetropicMagnification' => new \PHPExiftool\Driver\Tag\DICOM\EmmetropicMagnification(),
                'IntraOcularPressure' => new \PHPExiftool\Driver\Tag\DICOM\IntraOcularPressure(),
                'HorizontalFieldOfView' => new \PHPExiftool\Driver\Tag\DICOM\HorizontalFieldOfView(),
                'PupilDilated' => new \PHPExiftool\Driver\Tag\DICOM\PupilDilated(),
                'DegreeOfDilation' => new \PHPExiftool\Driver\Tag\DICOM\DegreeOfDilation(),
                'StereoBaselineAngle' => new \PHPExiftool\Driver\Tag\DICOM\StereoBaselineAngle(),
                'StereoBaselineDisplacement' => new \PHPExiftool\Driver\Tag\DICOM\StereoBaselineDisplacement(),
                'StereoHorizontalPixelOffset' => new \PHPExiftool\Driver\Tag\DICOM\StereoHorizontalPixelOffset(),
                'StereoVerticalPixelOffset' => new \PHPExiftool\Driver\Tag\DICOM\StereoVerticalPixelOffset(),
                'StereoRotation' => new \PHPExiftool\Driver\Tag\DICOM\StereoRotation(),
                'AcquisitionDeviceTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionDeviceTypeCodeSequence(),
                'IlluminationTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\IlluminationTypeCodeSequence(),
                'LightPathFilterTypeStackCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\LightPathFilterTypeStackCodeSeq(),
                'ImagePathFilterTypeStackCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\ImagePathFilterTypeStackCodeSeq(),
                'LensesCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\LensesCodeSequence(),
                'ChannelDescriptionCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelDescriptionCodeSequence(),
                'RefractiveStateSequence' => new \PHPExiftool\Driver\Tag\DICOM\RefractiveStateSequence(),
                'MydriaticAgentCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\MydriaticAgentCodeSequence(),
                'RelativeImagePositionCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RelativeImagePositionCodeSequence(),
                'StereoPairsSequence' => new \PHPExiftool\Driver\Tag\DICOM\StereoPairsSequence(),
                'LeftImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\LeftImageSequence(),
                'RightImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\RightImageSequence(),
                'AxialLengthOfTheEye' => new \PHPExiftool\Driver\Tag\DICOM\AxialLengthOfTheEye(),
                'OphthalmicFrameLocationSequence' => new \PHPExiftool\Driver\Tag\DICOM\OphthalmicFrameLocationSequence(),
                'ReferenceCoordinates' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceCoordinates(),
                'DepthSpatialResolution' => new \PHPExiftool\Driver\Tag\DICOM\DepthSpatialResolution(),
                'MaximumDepthDistortion' => new \PHPExiftool\Driver\Tag\DICOM\MaximumDepthDistortion(),
                'AlongScanSpatialResolution' => new \PHPExiftool\Driver\Tag\DICOM\AlongScanSpatialResolution(),
                'MaximumAlongScanDistortion' => new \PHPExiftool\Driver\Tag\DICOM\MaximumAlongScanDistortion(),
                'OphthalmicImageOrientation' => new \PHPExiftool\Driver\Tag\DICOM\OphthalmicImageOrientation(),
                'DepthOfTransverseImage' => new \PHPExiftool\Driver\Tag\DICOM\DepthOfTransverseImage(),
                'MydriaticAgentConcUnitsSeq' => new \PHPExiftool\Driver\Tag\DICOM\MydriaticAgentConcUnitsSeq(),
                'AcrossScanSpatialResolution' => new \PHPExiftool\Driver\Tag\DICOM\AcrossScanSpatialResolution(),
                'MaximumAcrossScanDistortion' => new \PHPExiftool\Driver\Tag\DICOM\MaximumAcrossScanDistortion(),
                'MydriaticAgentConcentration' => new \PHPExiftool\Driver\Tag\DICOM\MydriaticAgentConcentration(),
                'IlluminationWaveLength' => new \PHPExiftool\Driver\Tag\DICOM\IlluminationWaveLength(),
                'IlluminationPower' => new \PHPExiftool\Driver\Tag\DICOM\IlluminationPower(),
                'IlluminationBandwidth' => new \PHPExiftool\Driver\Tag\DICOM\IlluminationBandwidth(),
                'MydriaticAgentSequence' => new \PHPExiftool\Driver\Tag\DICOM\MydriaticAgentSequence(),
                'NumberOfSeriesInStudy' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSeriesInStudy(),
                'NumberOfUnarchivedSeries' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfUnarchivedSeries(),
                'ReferenceImageField' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceImageField(),
                'SummaryImage' => new \PHPExiftool\Driver\Tag\DICOM\SummaryImage(),
                'StartTimeSecsInFirstAxial' => new \PHPExiftool\Driver\Tag\DICOM\StartTimeSecsInFirstAxial(),
                'NoofUpdatesToHeader' => new \PHPExiftool\Driver\Tag\DICOM\NoofUpdatesToHeader(),
                'IndicatesIfTheStudyHasCompleteInfo' => new \PHPExiftool\Driver\Tag\DICOM\IndicatesIfTheStudyHasCompleteInfo(),
                'LastPulseSequenceUsed' => new \PHPExiftool\Driver\Tag\DICOM\LastPulseSequenceUsed(),
                'LandmarkCounter' => new \PHPExiftool\Driver\Tag\DICOM\LandmarkCounter(),
                'NumberOfAcquisitions' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfAcquisitions(),
                'IndicatesNoofUpdatesToHeader' => new \PHPExiftool\Driver\Tag\DICOM\IndicatesNoofUpdatesToHeader(),
                'SeriesCompleteFlag' => new \PHPExiftool\Driver\Tag\DICOM\SeriesCompleteFlag(),
                'NumberOfImagesArchived' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfImagesArchived(),
                'LastImageNumberUsed' => new \PHPExiftool\Driver\Tag\DICOM\LastImageNumberUsed(),
                'PrimaryReceiverSuiteAndHost' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryReceiverSuiteAndHost(),
                'ImageArchiveFlag' => new \PHPExiftool\Driver\Tag\DICOM\ImageArchiveFlag(),
                'ScoutType' => new \PHPExiftool\Driver\Tag\DICOM\ScoutType(),
                'VmaMamp' => new \PHPExiftool\Driver\Tag\DICOM\VmaMamp(),
                'VmaPhase' => new \PHPExiftool\Driver\Tag\DICOM\VmaPhase(),
                'VmaMod' => new \PHPExiftool\Driver\Tag\DICOM\VmaMod(),
                'VmaClip' => new \PHPExiftool\Driver\Tag\DICOM\VmaClip(),
                'SmartScanOnOffFlag' => new \PHPExiftool\Driver\Tag\DICOM\SmartScanOnOffFlag(),
                'ForeignImageRevision' => new \PHPExiftool\Driver\Tag\DICOM\ForeignImageRevision(),
                'ImagingMode' => new \PHPExiftool\Driver\Tag\DICOM\ImagingMode(),
                'PulseSequence' => new \PHPExiftool\Driver\Tag\DICOM\PulseSequence(),
                'ImagingOptions' => new \PHPExiftool\Driver\Tag\DICOM\ImagingOptions(),
                'PlaneType' => new \PHPExiftool\Driver\Tag\DICOM\PlaneType(),
                'ObliquePlane' => new \PHPExiftool\Driver\Tag\DICOM\ObliquePlane(),
                'RASLetterOfImageLocation' => new \PHPExiftool\Driver\Tag\DICOM\RASLetterOfImageLocation(),
                'ImageLocation' => new \PHPExiftool\Driver\Tag\DICOM\ImageLocation(),
                'CenterRCoordOfPlaneImage' => new \PHPExiftool\Driver\Tag\DICOM\CenterRCoordOfPlaneImage(),
                'CenterACoordOfPlaneImage' => new \PHPExiftool\Driver\Tag\DICOM\CenterACoordOfPlaneImage(),
                'CenterSCoordOfPlaneImage' => new \PHPExiftool\Driver\Tag\DICOM\CenterSCoordOfPlaneImage(),
                'NormalRCoord' => new \PHPExiftool\Driver\Tag\DICOM\NormalRCoord(),
                'NormalACoord' => new \PHPExiftool\Driver\Tag\DICOM\NormalACoord(),
                'NormalSCoord' => new \PHPExiftool\Driver\Tag\DICOM\NormalSCoord(),
                'RCoordOfTopRightCorner' => new \PHPExiftool\Driver\Tag\DICOM\RCoordOfTopRightCorner(),
                'ACoordOfTopRightCorner' => new \PHPExiftool\Driver\Tag\DICOM\ACoordOfTopRightCorner(),
                'SCoordOfTopRightCorner' => new \PHPExiftool\Driver\Tag\DICOM\SCoordOfTopRightCorner(),
                'RCoordOfBottomRightCorner' => new \PHPExiftool\Driver\Tag\DICOM\RCoordOfBottomRightCorner(),
                'ACoordOfBottomRightCorner' => new \PHPExiftool\Driver\Tag\DICOM\ACoordOfBottomRightCorner(),
                'SCoordOfBottomRightCorner' => new \PHPExiftool\Driver\Tag\DICOM\SCoordOfBottomRightCorner(),
                'TableEndLocation' => new \PHPExiftool\Driver\Tag\DICOM\TableEndLocation(),
                'RASLetterForSideOfImage' => new \PHPExiftool\Driver\Tag\DICOM\RASLetterForSideOfImage(),
                'RASLetterForAnteriorPosterior' => new \PHPExiftool\Driver\Tag\DICOM\RASLetterForAnteriorPosterior(),
                'RASLetterForScoutStartLoc' => new \PHPExiftool\Driver\Tag\DICOM\RASLetterForScoutStartLoc(),
                'RASLetterForScoutEndLoc' => new \PHPExiftool\Driver\Tag\DICOM\RASLetterForScoutEndLoc(),
                'ImageDimensionX' => new \PHPExiftool\Driver\Tag\DICOM\ImageDimensionX(),
                'ImageDimensionY' => new \PHPExiftool\Driver\Tag\DICOM\ImageDimensionY(),
                'NumberOfExcitations' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfExcitations(),
                'ImagePresentationGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\ImagePresentationGroupLength(),
                'SamplesPerPixel' => new \PHPExiftool\Driver\Tag\DICOM\SamplesPerPixel(),
                'SamplesPerPixelUsed' => new \PHPExiftool\Driver\Tag\DICOM\SamplesPerPixelUsed(),
                'PhotometricInterpretation' => new \PHPExiftool\Driver\Tag\DICOM\PhotometricInterpretation(),
                'ImageDimensions' => new \PHPExiftool\Driver\Tag\DICOM\ImageDimensions(),
                'PlanarConfiguration' => new \PHPExiftool\Driver\Tag\DICOM\PlanarConfiguration(),
                'NumberOfFrames' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFrames(),
                'FrameIncrementPointer' => new \PHPExiftool\Driver\Tag\DICOM\FrameIncrementPointer(),
                'FrameDimensionPointer' => new \PHPExiftool\Driver\Tag\DICOM\FrameDimensionPointer(),
                'Rows' => new \PHPExiftool\Driver\Tag\DICOM\Rows(),
                'Columns' => new \PHPExiftool\Driver\Tag\DICOM\Columns(),
                'Planes' => new \PHPExiftool\Driver\Tag\DICOM\Planes(),
                'UltrasoundColorDataPresent' => new \PHPExiftool\Driver\Tag\DICOM\UltrasoundColorDataPresent(),
                'PixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\PixelSpacing(),
                'ZoomFactor' => new \PHPExiftool\Driver\Tag\DICOM\ZoomFactor(),
                'ZoomCenter' => new \PHPExiftool\Driver\Tag\DICOM\ZoomCenter(),
                'PixelAspectRatio' => new \PHPExiftool\Driver\Tag\DICOM\PixelAspectRatio(),
                'ImageFormat' => new \PHPExiftool\Driver\Tag\DICOM\ImageFormat(),
                'ManipulatedImage' => new \PHPExiftool\Driver\Tag\DICOM\ManipulatedImage(),
                'CorrectedImage' => new \PHPExiftool\Driver\Tag\DICOM\CorrectedImage(),
                'CompressionRecognitionCode' => new \PHPExiftool\Driver\Tag\DICOM\CompressionRecognitionCode(),
                'CompressionCode' => new \PHPExiftool\Driver\Tag\DICOM\CompressionCode(),
                'CompressionOriginator' => new \PHPExiftool\Driver\Tag\DICOM\CompressionOriginator(),
                'CompressionLabel' => new \PHPExiftool\Driver\Tag\DICOM\CompressionLabel(),
                'CompressionDescription' => new \PHPExiftool\Driver\Tag\DICOM\CompressionDescription(),
                'CompressionSequence' => new \PHPExiftool\Driver\Tag\DICOM\CompressionSequence(),
                'CompressionStepPointers' => new \PHPExiftool\Driver\Tag\DICOM\CompressionStepPointers(),
                'RepeatInterval' => new \PHPExiftool\Driver\Tag\DICOM\RepeatInterval(),
                'BitsGrouped' => new \PHPExiftool\Driver\Tag\DICOM\BitsGrouped(),
                'PerimeterTable' => new \PHPExiftool\Driver\Tag\DICOM\PerimeterTable(),
                'PerimeterValue' => new \PHPExiftool\Driver\Tag\DICOM\PerimeterValue(),
                'PredictorRows' => new \PHPExiftool\Driver\Tag\DICOM\PredictorRows(),
                'PredictorColumns' => new \PHPExiftool\Driver\Tag\DICOM\PredictorColumns(),
                'PredictorConstants' => new \PHPExiftool\Driver\Tag\DICOM\PredictorConstants(),
                'BlockedPixels' => new \PHPExiftool\Driver\Tag\DICOM\BlockedPixels(),
                'BlockRows' => new \PHPExiftool\Driver\Tag\DICOM\BlockRows(),
                'BlockColumns' => new \PHPExiftool\Driver\Tag\DICOM\BlockColumns(),
                'RowOverlap' => new \PHPExiftool\Driver\Tag\DICOM\RowOverlap(),
                'ColumnOverlap' => new \PHPExiftool\Driver\Tag\DICOM\ColumnOverlap(),
                'BitsAllocated' => new \PHPExiftool\Driver\Tag\DICOM\BitsAllocated(),
                'BitsStored' => new \PHPExiftool\Driver\Tag\DICOM\BitsStored(),
                'HighBit' => new \PHPExiftool\Driver\Tag\DICOM\HighBit(),
                'PixelRepresentation' => new \PHPExiftool\Driver\Tag\DICOM\PixelRepresentation(),
                'SmallestValidPixelValue' => new \PHPExiftool\Driver\Tag\DICOM\SmallestValidPixelValue(),
                'LargestValidPixelValue' => new \PHPExiftool\Driver\Tag\DICOM\LargestValidPixelValue(),
                'SmallestImagePixelValue' => new \PHPExiftool\Driver\Tag\DICOM\SmallestImagePixelValue(),
                'LargestImagePixelValue' => new \PHPExiftool\Driver\Tag\DICOM\LargestImagePixelValue(),
                'SmallestPixelValueInSeries' => new \PHPExiftool\Driver\Tag\DICOM\SmallestPixelValueInSeries(),
                'LargestPixelValueInSeries' => new \PHPExiftool\Driver\Tag\DICOM\LargestPixelValueInSeries(),
                'SmallestImagePixelValueInPlane' => new \PHPExiftool\Driver\Tag\DICOM\SmallestImagePixelValueInPlane(),
                'LargestImagePixelValueInPlane' => new \PHPExiftool\Driver\Tag\DICOM\LargestImagePixelValueInPlane(),
                'PixelPaddingValue' => new \PHPExiftool\Driver\Tag\DICOM\PixelPaddingValue(),
                'PixelPaddingRangeLimit' => new \PHPExiftool\Driver\Tag\DICOM\PixelPaddingRangeLimit(),
                'QualityControlImage' => new \PHPExiftool\Driver\Tag\DICOM\QualityControlImage(),
                'BurnedInAnnotation' => new \PHPExiftool\Driver\Tag\DICOM\BurnedInAnnotation(),
                'TransformLabel' => new \PHPExiftool\Driver\Tag\DICOM\TransformLabel(),
                'TransformVersionNumber' => new \PHPExiftool\Driver\Tag\DICOM\TransformVersionNumber(),
                'NumberOfTransformSteps' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTransformSteps(),
                'SequenceOfCompressedData' => new \PHPExiftool\Driver\Tag\DICOM\SequenceOfCompressedData(),
                'DetailsOfCoefficients' => new \PHPExiftool\Driver\Tag\DICOM\DetailsOfCoefficients(),
                'CoefficientCoding' => new \PHPExiftool\Driver\Tag\DICOM\CoefficientCoding(),
                'CoefficientCodingPointers' => new \PHPExiftool\Driver\Tag\DICOM\CoefficientCodingPointers(),
                'DCTLabel' => new \PHPExiftool\Driver\Tag\DICOM\DCTLabel(),
                'DataBlockDescription' => new \PHPExiftool\Driver\Tag\DICOM\DataBlockDescription(),
                'DataBlock' => new \PHPExiftool\Driver\Tag\DICOM\DataBlock(),
                'NormalizationFactorFormat' => new \PHPExiftool\Driver\Tag\DICOM\NormalizationFactorFormat(),
                'ZonalMapNumberFormat' => new \PHPExiftool\Driver\Tag\DICOM\ZonalMapNumberFormat(),
                'ZonalMapLocation' => new \PHPExiftool\Driver\Tag\DICOM\ZonalMapLocation(),
                'ZonalMapFormat' => new \PHPExiftool\Driver\Tag\DICOM\ZonalMapFormat(),
                'AdaptiveMapFormat' => new \PHPExiftool\Driver\Tag\DICOM\AdaptiveMapFormat(),
                'CodeNumberFormat' => new \PHPExiftool\Driver\Tag\DICOM\CodeNumberFormat(),
                'CodeLabel' => new \PHPExiftool\Driver\Tag\DICOM\CodeLabel(),
                'NumberOfTables' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTables(),
                'CodeTableLocation' => new \PHPExiftool\Driver\Tag\DICOM\CodeTableLocation(),
                'BitsForCodeWord' => new \PHPExiftool\Driver\Tag\DICOM\BitsForCodeWord(),
                'ImageDataLocation' => new \PHPExiftool\Driver\Tag\DICOM\ImageDataLocation(),
                'PixelSpacingCalibrationType' => new \PHPExiftool\Driver\Tag\DICOM\PixelSpacingCalibrationType(),
                'PixelSpacingCalibrationDescription' => new \PHPExiftool\Driver\Tag\DICOM\PixelSpacingCalibrationDescription(),
                'PixelIntensityRelationship' => new \PHPExiftool\Driver\Tag\DICOM\PixelIntensityRelationship(),
                'PixelIntensityRelationshipSign' => new \PHPExiftool\Driver\Tag\DICOM\PixelIntensityRelationshipSign(),
                'WindowCenter' => new \PHPExiftool\Driver\Tag\DICOM\WindowCenter(),
                'WindowWidth' => new \PHPExiftool\Driver\Tag\DICOM\WindowWidth(),
                'RescaleIntercept' => new \PHPExiftool\Driver\Tag\DICOM\RescaleIntercept(),
                'RescaleSlope' => new \PHPExiftool\Driver\Tag\DICOM\RescaleSlope(),
                'RescaleType' => new \PHPExiftool\Driver\Tag\DICOM\RescaleType(),
                'WindowCenterAndWidthExplanation' => new \PHPExiftool\Driver\Tag\DICOM\WindowCenterAndWidthExplanation(),
                'VOI_LUTFunction' => new \PHPExiftool\Driver\Tag\DICOM\VOILUTFunction(),
                'GrayScale' => new \PHPExiftool\Driver\Tag\DICOM\GrayScale(),
                'RecommendedViewingMode' => new \PHPExiftool\Driver\Tag\DICOM\RecommendedViewingMode(),
                'GrayLookupTableDescriptor' => new \PHPExiftool\Driver\Tag\DICOM\GrayLookupTableDescriptor(),
                'RedPaletteColorTableDescriptor' => new \PHPExiftool\Driver\Tag\DICOM\RedPaletteColorTableDescriptor(),
                'GreenPaletteColorTableDescriptor' => new \PHPExiftool\Driver\Tag\DICOM\GreenPaletteColorTableDescriptor(),
                'BluePaletteColorTableDescriptor' => new \PHPExiftool\Driver\Tag\DICOM\BluePaletteColorTableDescriptor(),
                'LargeRedPaletteColorTableDescr' => new \PHPExiftool\Driver\Tag\DICOM\LargeRedPaletteColorTableDescr(),
                'LargeGreenPaletteColorTableDescr' => new \PHPExiftool\Driver\Tag\DICOM\LargeGreenPaletteColorTableDescr(),
                'LargeBluePaletteColorTableDescr' => new \PHPExiftool\Driver\Tag\DICOM\LargeBluePaletteColorTableDescr(),
                'PaletteColorTableUID' => new \PHPExiftool\Driver\Tag\DICOM\PaletteColorTableUID(),
                'GrayLookupTableData' => new \PHPExiftool\Driver\Tag\DICOM\GrayLookupTableData(),
                'RedPaletteColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\RedPaletteColorTableData(),
                'GreenPaletteColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\GreenPaletteColorTableData(),
                'BluePaletteColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\BluePaletteColorTableData(),
                'LargeRedPaletteColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\LargeRedPaletteColorTableData(),
                'LargeGreenPaletteColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\LargeGreenPaletteColorTableData(),
                'LargeBluePaletteColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\LargeBluePaletteColorTableData(),
                'LargePaletteColorLookupTableUID' => new \PHPExiftool\Driver\Tag\DICOM\LargePaletteColorLookupTableUID(),
                'SegmentedRedColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\SegmentedRedColorTableData(),
                'SegmentedGreenColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\SegmentedGreenColorTableData(),
                'SegmentedBlueColorTableData' => new \PHPExiftool\Driver\Tag\DICOM\SegmentedBlueColorTableData(),
                'BreastImplantPresent' => new \PHPExiftool\Driver\Tag\DICOM\BreastImplantPresent(),
                'PartialView' => new \PHPExiftool\Driver\Tag\DICOM\PartialView(),
                'PartialViewDescription' => new \PHPExiftool\Driver\Tag\DICOM\PartialViewDescription(),
                'PartialViewCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PartialViewCodeSequence(),
                'SpatialLocationsPreserved' => new \PHPExiftool\Driver\Tag\DICOM\SpatialLocationsPreserved(),
                'DataPathAssignment' => new \PHPExiftool\Driver\Tag\DICOM\DataPathAssignment(),
                'BlendingLUT1Sequence' => new \PHPExiftool\Driver\Tag\DICOM\BlendingLUT1Sequence(),
                'BlendingWeightConstant' => new \PHPExiftool\Driver\Tag\DICOM\BlendingWeightConstant(),
                'BlendingLookupTableData' => new \PHPExiftool\Driver\Tag\DICOM\BlendingLookupTableData(),
                'BlendingLUT2Sequence' => new \PHPExiftool\Driver\Tag\DICOM\BlendingLUT2Sequence(),
                'DataPathID' => new \PHPExiftool\Driver\Tag\DICOM\DataPathID(),
                'RGBLUTTransferFunction' => new \PHPExiftool\Driver\Tag\DICOM\RGBLUTTransferFunction(),
                'AlphaLUTTransferFunction' => new \PHPExiftool\Driver\Tag\DICOM\AlphaLUTTransferFunction(),
                'ICCProfile' => new \PHPExiftool\Driver\Tag\DICOM\ICCProfile(),
                'LossyImageCompressionRatio' => new \PHPExiftool\Driver\Tag\DICOM\LossyImageCompressionRatio(),
                'LossyImageCompressionMethod' => new \PHPExiftool\Driver\Tag\DICOM\LossyImageCompressionMethod(),
                'ModalityLUTSequence' => new \PHPExiftool\Driver\Tag\DICOM\ModalityLUTSequence(),
                'LUTDescriptor' => new \PHPExiftool\Driver\Tag\DICOM\LUTDescriptor(),
                'LUTExplanation' => new \PHPExiftool\Driver\Tag\DICOM\LUTExplanation(),
                'ModalityLUTType' => new \PHPExiftool\Driver\Tag\DICOM\ModalityLUTType(),
                'LUTData' => new \PHPExiftool\Driver\Tag\DICOM\LUTData(),
                'VOILUTSequence' => new \PHPExiftool\Driver\Tag\DICOM\VOILUTSequence(),
                'SoftcopyVOILUTSequence' => new \PHPExiftool\Driver\Tag\DICOM\SoftcopyVOILUTSequence(),
                'ImagePresentationComments' => new \PHPExiftool\Driver\Tag\DICOM\ImagePresentationComments(),
                'BiPlaneAcquisitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\BiPlaneAcquisitionSequence(),
                'RepresentativeFrameNumber' => new \PHPExiftool\Driver\Tag\DICOM\RepresentativeFrameNumber(),
                'FrameNumbersOfInterest' => new \PHPExiftool\Driver\Tag\DICOM\FrameNumbersOfInterest(),
                'FrameOfInterestDescription' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfInterestDescription(),
                'FrameOfInterestType' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfInterestType(),
                'MaskPointers' => new \PHPExiftool\Driver\Tag\DICOM\MaskPointers(),
                'RWavePointer' => new \PHPExiftool\Driver\Tag\DICOM\RWavePointer(),
                'MaskSubtractionSequence' => new \PHPExiftool\Driver\Tag\DICOM\MaskSubtractionSequence(),
                'MaskOperation' => new \PHPExiftool\Driver\Tag\DICOM\MaskOperation(),
                'ApplicableFrameRange' => new \PHPExiftool\Driver\Tag\DICOM\ApplicableFrameRange(),
                'MaskFrameNumbers' => new \PHPExiftool\Driver\Tag\DICOM\MaskFrameNumbers(),
                'ContrastFrameAveraging' => new \PHPExiftool\Driver\Tag\DICOM\ContrastFrameAveraging(),
                'MaskSubPixelShift' => new \PHPExiftool\Driver\Tag\DICOM\MaskSubPixelShift(),
                'TIDOffset' => new \PHPExiftool\Driver\Tag\DICOM\TIDOffset(),
                'MaskOperationExplanation' => new \PHPExiftool\Driver\Tag\DICOM\MaskOperationExplanation(),
                'PixelDataProviderURL' => new \PHPExiftool\Driver\Tag\DICOM\PixelDataProviderURL(),
                'DataPointRows' => new \PHPExiftool\Driver\Tag\DICOM\DataPointRows(),
                'DataPointColumns' => new \PHPExiftool\Driver\Tag\DICOM\DataPointColumns(),
                'SignalDomainColumns' => new \PHPExiftool\Driver\Tag\DICOM\SignalDomainColumns(),
                'LargestMonochromePixelValue' => new \PHPExiftool\Driver\Tag\DICOM\LargestMonochromePixelValue(),
                'DataRepresentation' => new \PHPExiftool\Driver\Tag\DICOM\DataRepresentation(),
                'PixelMeasuresSequence' => new \PHPExiftool\Driver\Tag\DICOM\PixelMeasuresSequence(),
                'FrameVOILUTSequence' => new \PHPExiftool\Driver\Tag\DICOM\FrameVOILUTSequence(),
                'PixelValueTransformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\PixelValueTransformationSequence(),
                'SignalDomainRows' => new \PHPExiftool\Driver\Tag\DICOM\SignalDomainRows(),
                'DisplayFilterPercentage' => new \PHPExiftool\Driver\Tag\DICOM\DisplayFilterPercentage(),
                'FramePixelShiftSequence' => new \PHPExiftool\Driver\Tag\DICOM\FramePixelShiftSequence(),
                'SubtractionItemID' => new \PHPExiftool\Driver\Tag\DICOM\SubtractionItemID(),
                'PixelIntensityRelationshipLUTSeq' => new \PHPExiftool\Driver\Tag\DICOM\PixelIntensityRelationshipLUTSeq(),
                'FramePixelDataPropertiesSequence' => new \PHPExiftool\Driver\Tag\DICOM\FramePixelDataPropertiesSequence(),
                'GeometricalProperties' => new \PHPExiftool\Driver\Tag\DICOM\GeometricalProperties(),
                'GeometricMaximumDistortion' => new \PHPExiftool\Driver\Tag\DICOM\GeometricMaximumDistortion(),
                'ImageProcessingApplied' => new \PHPExiftool\Driver\Tag\DICOM\ImageProcessingApplied(),
                'MaskSelectionMode' => new \PHPExiftool\Driver\Tag\DICOM\MaskSelectionMode(),
                'LUTFunction' => new \PHPExiftool\Driver\Tag\DICOM\LUTFunction(),
                'MaskVisibilityPercentage' => new \PHPExiftool\Driver\Tag\DICOM\MaskVisibilityPercentage(),
                'PixelShiftSequence' => new \PHPExiftool\Driver\Tag\DICOM\PixelShiftSequence(),
                'RegionPixelShiftSequence' => new \PHPExiftool\Driver\Tag\DICOM\RegionPixelShiftSequence(),
                'VerticesOfTheRegion' => new \PHPExiftool\Driver\Tag\DICOM\VerticesOfTheRegion(),
                'PixelShiftFrameRange' => new \PHPExiftool\Driver\Tag\DICOM\PixelShiftFrameRange(),
                'LUTFrameRange' => new \PHPExiftool\Driver\Tag\DICOM\LUTFrameRange(),
                'ImageToEquipmentMappingMatrix' => new \PHPExiftool\Driver\Tag\DICOM\ImageToEquipmentMappingMatrix(),
                'EquipmentCoordinateSystemID' => new \PHPExiftool\Driver\Tag\DICOM\EquipmentCoordinateSystemID(),
                'LowerRangeOfPixels1a' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1a(),
                'LowerRangeOfPixels1b' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1b(),
                'LowerRangeOfPixels1c' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1c(),
                'LowerRangeOfPixels1d' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1d(),
                'LowerRangeOfPixels1e' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1e(),
                'LowerRangeOfPixels1f' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1f(),
                'LowerRangeOfPixels1g' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1g(),
                'LowerRangeOfPixels1h' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1h(),
                'LowerRangeOfPixels1i' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels1i(),
                'LowerRangeOfPixels2' => new \PHPExiftool\Driver\Tag\DICOM\LowerRangeOfPixels2(),
                'UpperRangeOfPixels2' => new \PHPExiftool\Driver\Tag\DICOM\UpperRangeOfPixels2(),
                'LenOfTotHdrInBytes' => new \PHPExiftool\Driver\Tag\DICOM\LenOfTotHdrInBytes(),
                'VersionOfTheHdrStruct' => new \PHPExiftool\Driver\Tag\DICOM\VersionOfTheHdrStruct(),
                'AdvantageCompOverflow' => new \PHPExiftool\Driver\Tag\DICOM\AdvantageCompOverflow(),
                'AdvantageCompUnderflow' => new \PHPExiftool\Driver\Tag\DICOM\AdvantageCompUnderflow(),
                'StudyGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\StudyGroupLength(),
                'StudyStatusID' => new \PHPExiftool\Driver\Tag\DICOM\StudyStatusID(),
                'StudyPriorityID' => new \PHPExiftool\Driver\Tag\DICOM\StudyPriorityID(),
                'StudyIDIssuer' => new \PHPExiftool\Driver\Tag\DICOM\StudyIDIssuer(),
                'StudyVerifiedDate' => new \PHPExiftool\Driver\Tag\DICOM\StudyVerifiedDate(),
                'StudyVerifiedTime' => new \PHPExiftool\Driver\Tag\DICOM\StudyVerifiedTime(),
                'StudyReadDate' => new \PHPExiftool\Driver\Tag\DICOM\StudyReadDate(),
                'StudyReadTime' => new \PHPExiftool\Driver\Tag\DICOM\StudyReadTime(),
                'ScheduledStudyStartDate' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStudyStartDate(),
                'ScheduledStudyStartTime' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStudyStartTime(),
                'ScheduledStudyStopDate' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStudyStopDate(),
                'ScheduledStudyStopTime' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStudyStopTime(),
                'ScheduledStudyLocation' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStudyLocation(),
                'ScheduledStudyLocationAETitle' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStudyLocationAETitle(),
                'ReasonForStudy' => new \PHPExiftool\Driver\Tag\DICOM\ReasonForStudy(),
                'RequestingPhysicianIDSequence' => new \PHPExiftool\Driver\Tag\DICOM\RequestingPhysicianIDSequence(),
                'RequestingPhysician' => new \PHPExiftool\Driver\Tag\DICOM\RequestingPhysician(),
                'RequestingService' => new \PHPExiftool\Driver\Tag\DICOM\RequestingService(),
                'StudyArrivalDate' => new \PHPExiftool\Driver\Tag\DICOM\StudyArrivalDate(),
                'StudyArrivalTime' => new \PHPExiftool\Driver\Tag\DICOM\StudyArrivalTime(),
                'StudyCompletionDate' => new \PHPExiftool\Driver\Tag\DICOM\StudyCompletionDate(),
                'StudyCompletionTime' => new \PHPExiftool\Driver\Tag\DICOM\StudyCompletionTime(),
                'StudyComponentStatusID' => new \PHPExiftool\Driver\Tag\DICOM\StudyComponentStatusID(),
                'RequestedProcedureDescription' => new \PHPExiftool\Driver\Tag\DICOM\RequestedProcedureDescription(),
                'RequestedProcedureCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RequestedProcedureCodeSequence(),
                'RequestedContrastAgent' => new \PHPExiftool\Driver\Tag\DICOM\RequestedContrastAgent(),
                'StudyComments' => new \PHPExiftool\Driver\Tag\DICOM\StudyComments(),
                'ReferencedPatientAliasSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedPatientAliasSequence(),
                'VisitStatusID' => new \PHPExiftool\Driver\Tag\DICOM\VisitStatusID(),
                'AdmissionID' => new \PHPExiftool\Driver\Tag\DICOM\AdmissionID(),
                'IssuerOfAdmissionID' => new \PHPExiftool\Driver\Tag\DICOM\IssuerOfAdmissionID(),
                'RouteOfAdmissions' => new \PHPExiftool\Driver\Tag\DICOM\RouteOfAdmissions(),
                'ScheduledAdmissionDate' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledAdmissionDate(),
                'ScheduledAdmissionTime' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledAdmissionTime(),
                'ScheduledDischargeDate' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledDischargeDate(),
                'ScheduledDischargeTime' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledDischargeTime(),
                'ScheduledPatientInstitResidence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledPatientInstitResidence(),
                'AdmittingDate' => new \PHPExiftool\Driver\Tag\DICOM\AdmittingDate(),
                'AdmittingTime' => new \PHPExiftool\Driver\Tag\DICOM\AdmittingTime(),
                'DischargeDate' => new \PHPExiftool\Driver\Tag\DICOM\DischargeDate(),
                'DischargeTime' => new \PHPExiftool\Driver\Tag\DICOM\DischargeTime(),
                'DischargeDiagnosisDescription' => new \PHPExiftool\Driver\Tag\DICOM\DischargeDiagnosisDescription(),
                'DischargeDiagnosisCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\DischargeDiagnosisCodeSequence(),
                'SpecialNeeds' => new \PHPExiftool\Driver\Tag\DICOM\SpecialNeeds(),
                'ServiceEpisodeID' => new \PHPExiftool\Driver\Tag\DICOM\ServiceEpisodeID(),
                'IssuerOfServiceEpisodeID' => new \PHPExiftool\Driver\Tag\DICOM\IssuerOfServiceEpisodeID(),
                'ServiceEpisodeDescription' => new \PHPExiftool\Driver\Tag\DICOM\ServiceEpisodeDescription(),
                'PertinentDocumentsSequence' => new \PHPExiftool\Driver\Tag\DICOM\PertinentDocumentsSequence(),
                'CurrentPatientLocation' => new \PHPExiftool\Driver\Tag\DICOM\CurrentPatientLocation(),
                'PatientInstitutionResidence' => new \PHPExiftool\Driver\Tag\DICOM\PatientInstitutionResidence(),
                'PatientState' => new \PHPExiftool\Driver\Tag\DICOM\PatientState(),
                'PatientClinicalTrialParticipSeq' => new \PHPExiftool\Driver\Tag\DICOM\PatientClinicalTrialParticipSeq(),
                'VisitComments' => new \PHPExiftool\Driver\Tag\DICOM\VisitComments(),
                'WaveformOriginality' => new \PHPExiftool\Driver\Tag\DICOM\WaveformOriginality(),
                'NumberOfWaveformChannels' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfWaveformChannels(),
                'NumberOfWaveformSamples' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfWaveformSamples(),
                'SamplingFrequency' => new \PHPExiftool\Driver\Tag\DICOM\SamplingFrequency(),
                'MultiplexGroupLabel' => new \PHPExiftool\Driver\Tag\DICOM\MultiplexGroupLabel(),
                'ChannelDefinitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelDefinitionSequence(),
                'WaveformChannelNumber' => new \PHPExiftool\Driver\Tag\DICOM\WaveformChannelNumber(),
                'ChannelLabel' => new \PHPExiftool\Driver\Tag\DICOM\ChannelLabel(),
                'ChannelStatus' => new \PHPExiftool\Driver\Tag\DICOM\ChannelStatus(),
                'ChannelSourceSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSourceSequence(),
                'ChannelSourceModifiersSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSourceModifiersSequence(),
                'SourceWaveformSequence' => new \PHPExiftool\Driver\Tag\DICOM\SourceWaveformSequence(),
                'ChannelDerivationDescription' => new \PHPExiftool\Driver\Tag\DICOM\ChannelDerivationDescription(),
                'ChannelSensitivity' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSensitivity(),
                'ChannelSensitivityUnitsSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSensitivityUnitsSequence(),
                'ChannelSensitivityCorrectionFactor' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSensitivityCorrectionFactor(),
                'ChannelBaseline' => new \PHPExiftool\Driver\Tag\DICOM\ChannelBaseline(),
                'ChannelTimeSkew' => new \PHPExiftool\Driver\Tag\DICOM\ChannelTimeSkew(),
                'ChannelSampleSkew' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSampleSkew(),
                'ChannelOffset' => new \PHPExiftool\Driver\Tag\DICOM\ChannelOffset(),
                'WaveformBitsStored' => new \PHPExiftool\Driver\Tag\DICOM\WaveformBitsStored(),
                'FilterLowFrequency' => new \PHPExiftool\Driver\Tag\DICOM\FilterLowFrequency(),
                'FilterHighFrequency' => new \PHPExiftool\Driver\Tag\DICOM\FilterHighFrequency(),
                'NotchFilterFrequency' => new \PHPExiftool\Driver\Tag\DICOM\NotchFilterFrequency(),
                'NotchFilterBandwidth' => new \PHPExiftool\Driver\Tag\DICOM\NotchFilterBandwidth(),
                'WaveformDataDisplayScale' => new \PHPExiftool\Driver\Tag\DICOM\WaveformDataDisplayScale(),
                'WaveformDisplayBkgCIELabValue' => new \PHPExiftool\Driver\Tag\DICOM\WaveformDisplayBkgCIELabValue(),
                'WaveformPresentationGroupSequence' => new \PHPExiftool\Driver\Tag\DICOM\WaveformPresentationGroupSequence(),
                'PresentationGroupNumber' => new \PHPExiftool\Driver\Tag\DICOM\PresentationGroupNumber(),
                'ChannelDisplaySequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelDisplaySequence(),
                'ChannelRecommendDisplayCIELabValue' => new \PHPExiftool\Driver\Tag\DICOM\ChannelRecommendDisplayCIELabValue(),
                'ChannelPosition' => new \PHPExiftool\Driver\Tag\DICOM\ChannelPosition(),
                'DisplayShadingFlag' => new \PHPExiftool\Driver\Tag\DICOM\DisplayShadingFlag(),
                'FractionalChannelDisplayScale' => new \PHPExiftool\Driver\Tag\DICOM\FractionalChannelDisplayScale(),
                'AbsoluteChannelDisplayScale' => new \PHPExiftool\Driver\Tag\DICOM\AbsoluteChannelDisplayScale(),
                'MultiplexAudioChannelsDescrCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\MultiplexAudioChannelsDescrCodeSeq(),
                'ChannelIdentificationCode' => new \PHPExiftool\Driver\Tag\DICOM\ChannelIdentificationCode(),
                'ChannelMode' => new \PHPExiftool\Driver\Tag\DICOM\ChannelMode(),
                'ScheduledStationAETitle' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStationAETitle(),
                'ScheduledProcedureStepStartDate' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepStartDate(),
                'ScheduledProcedureStepStartTime' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepStartTime(),
                'ScheduledProcedureStepEndDate' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepEndDate(),
                'ScheduledProcedureStepEndTime' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepEndTime(),
                'ScheduledPerformingPhysiciansName' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledPerformingPhysiciansName(),
                'ScheduledProcedureStepDescription' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepDescription(),
                'ScheduledProtocolCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProtocolCodeSequence(),
                'ScheduledProcedureStepID' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepID(),
                'StageCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\StageCodeSequence(),
                'ScheduledPerformingPhysicianIDSeq' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledPerformingPhysicianIDSeq(),
                'ScheduledStationName' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStationName(),
                'ScheduledProcedureStepLocation' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepLocation(),
                'PreMedication' => new \PHPExiftool\Driver\Tag\DICOM\PreMedication(),
                'ScheduledProcedureStepStatus' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepStatus(),
                'LocalNamespaceEntityID' => new \PHPExiftool\Driver\Tag\DICOM\LocalNamespaceEntityID(),
                'UniversalEntityID' => new \PHPExiftool\Driver\Tag\DICOM\UniversalEntityID(),
                'UniversalEntityIDType' => new \PHPExiftool\Driver\Tag\DICOM\UniversalEntityIDType(),
                'IdentifierTypeCode' => new \PHPExiftool\Driver\Tag\DICOM\IdentifierTypeCode(),
                'AssigningFacilitySequence' => new \PHPExiftool\Driver\Tag\DICOM\AssigningFacilitySequence(),
                'ScheduledProcedureStepSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepSequence(),
                'ReferencedNonImageCompositeSOPSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedNonImageCompositeSOPSeq(),
                'PerformedStationAETitle' => new \PHPExiftool\Driver\Tag\DICOM\PerformedStationAETitle(),
                'PerformedStationName' => new \PHPExiftool\Driver\Tag\DICOM\PerformedStationName(),
                'PerformedLocation' => new \PHPExiftool\Driver\Tag\DICOM\PerformedLocation(),
                'PerformedProcedureStepStartDate' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepStartDate(),
                'PerformedProcedureStepStartTime' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepStartTime(),
                'PerformedProcedureStepEndDate' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepEndDate(),
                'PerformedProcedureStepEndTime' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepEndTime(),
                'PerformedProcedureStepStatus' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepStatus(),
                'PerformedProcedureStepID' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepID(),
                'PerformedProcedureStepDescription' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureStepDescription(),
                'PerformedProcedureTypeDescription' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureTypeDescription(),
                'PerformedProtocolCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProtocolCodeSequence(),
                'PerformedProtocolType' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProtocolType(),
                'ScheduledStepAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStepAttributesSequence(),
                'RequestAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\RequestAttributesSequence(),
                'CommentsOnPerformedProcedureStep' => new \PHPExiftool\Driver\Tag\DICOM\CommentsOnPerformedProcedureStep(),
                'ProcStepDiscontinueReasonCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\ProcStepDiscontinueReasonCodeSeq(),
                'QuantitySequence' => new \PHPExiftool\Driver\Tag\DICOM\QuantitySequence(),
                'Quantity' => new \PHPExiftool\Driver\Tag\DICOM\Quantity(),
                'MeasuringUnitsSequence' => new \PHPExiftool\Driver\Tag\DICOM\MeasuringUnitsSequence(),
                'BillingItemSequence' => new \PHPExiftool\Driver\Tag\DICOM\BillingItemSequence(),
                'TotalTimeOfFluoroscopy' => new \PHPExiftool\Driver\Tag\DICOM\TotalTimeOfFluoroscopy(),
                'TotalNumberOfExposures' => new \PHPExiftool\Driver\Tag\DICOM\TotalNumberOfExposures(),
                'EntranceDose' => new \PHPExiftool\Driver\Tag\DICOM\EntranceDose(),
                'ExposedArea' => new \PHPExiftool\Driver\Tag\DICOM\ExposedArea(),
                'DistanceSourceToEntrance' => new \PHPExiftool\Driver\Tag\DICOM\DistanceSourceToEntrance(),
                'DistanceSourceToSupport' => new \PHPExiftool\Driver\Tag\DICOM\DistanceSourceToSupport(),
                'ExposureDoseSequence' => new \PHPExiftool\Driver\Tag\DICOM\ExposureDoseSequence(),
                'CommentsOnRadiationDose' => new \PHPExiftool\Driver\Tag\DICOM\CommentsOnRadiationDose(),
                'XRayOutput' => new \PHPExiftool\Driver\Tag\DICOM\XRayOutput(),
                'HalfValueLayer' => new \PHPExiftool\Driver\Tag\DICOM\HalfValueLayer(),
                'OrganDose' => new \PHPExiftool\Driver\Tag\DICOM\OrganDose(),
                'OrganExposed' => new \PHPExiftool\Driver\Tag\DICOM\OrganExposed(),
                'BillingProcedureStepSequence' => new \PHPExiftool\Driver\Tag\DICOM\BillingProcedureStepSequence(),
                'FilmConsumptionSequence' => new \PHPExiftool\Driver\Tag\DICOM\FilmConsumptionSequence(),
                'BillingSuppliesAndDevicesSequence' => new \PHPExiftool\Driver\Tag\DICOM\BillingSuppliesAndDevicesSequence(),
                'PerformedSeriesSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformedSeriesSequence(),
                'CommentsOnScheduledProcedureStep' => new \PHPExiftool\Driver\Tag\DICOM\CommentsOnScheduledProcedureStep(),
                'ProtocolContextSequence' => new \PHPExiftool\Driver\Tag\DICOM\ProtocolContextSequence(),
                'ContentItemModifierSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContentItemModifierSequence(),
                'SpecimenAccessionNumber' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenAccessionNumber(),
                'ContainerIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\ContainerIdentifier(),
                'ContainerDescription' => new \PHPExiftool\Driver\Tag\DICOM\ContainerDescription(),
                'SpecimenSequence' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenSequence(),
                'SpecimenIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenIdentifier(),
                'SpecimenDescriptionSequenceTrial' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenDescriptionSequenceTrial(),
                'SpecimenDescriptionTrial' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenDescriptionTrial(),
                'SpecimenUID' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenUID(),
                'AcquisitionContextSequence' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionContextSequence(),
                'AcquisitionContextDescription' => new \PHPExiftool\Driver\Tag\DICOM\AcquisitionContextDescription(),
                'SpecimenTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenTypeCodeSequence(),
                'SpecimenShortDescription' => new \PHPExiftool\Driver\Tag\DICOM\SpecimenShortDescription(),
                'SlideIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\SlideIdentifier(),
                'ImageCenterPointCoordinatesSeq' => new \PHPExiftool\Driver\Tag\DICOM\ImageCenterPointCoordinatesSeq(),
                'XOffsetInSlideCoordinateSystem' => new \PHPExiftool\Driver\Tag\DICOM\XOffsetInSlideCoordinateSystem(),
                'YOffsetInSlideCoordinateSystem' => new \PHPExiftool\Driver\Tag\DICOM\YOffsetInSlideCoordinateSystem(),
                'ZOffsetInSlideCoordinateSystem' => new \PHPExiftool\Driver\Tag\DICOM\ZOffsetInSlideCoordinateSystem(),
                'PixelSpacingSequence' => new \PHPExiftool\Driver\Tag\DICOM\PixelSpacingSequence(),
                'CoordinateSystemAxisCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\CoordinateSystemAxisCodeSequence(),
                'MeasurementUnitsCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\MeasurementUnitsCodeSequence(),
                'VitalStainCodeSequenceTrial' => new \PHPExiftool\Driver\Tag\DICOM\VitalStainCodeSequenceTrial(),
                'RequestedProcedureID' => new \PHPExiftool\Driver\Tag\DICOM\RequestedProcedureID(),
                'ReasonForRequestedProcedure' => new \PHPExiftool\Driver\Tag\DICOM\ReasonForRequestedProcedure(),
                'RequestedProcedurePriority' => new \PHPExiftool\Driver\Tag\DICOM\RequestedProcedurePriority(),
                'PatientTransportArrangements' => new \PHPExiftool\Driver\Tag\DICOM\PatientTransportArrangements(),
                'RequestedProcedureLocation' => new \PHPExiftool\Driver\Tag\DICOM\RequestedProcedureLocation(),
                'PlacerOrderNumber-Procedure' => new \PHPExiftool\Driver\Tag\DICOM\PlacerOrderNumberProcedure(),
                'FillerOrderNumber-Procedure' => new \PHPExiftool\Driver\Tag\DICOM\FillerOrderNumberProcedure(),
                'ConfidentialityCode' => new \PHPExiftool\Driver\Tag\DICOM\ConfidentialityCode(),
                'ReportingPriority' => new \PHPExiftool\Driver\Tag\DICOM\ReportingPriority(),
                'ReasonForRequestedProcedureCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReasonForRequestedProcedureCodeSeq(),
                'NamesOfIntendedRecipientsOfResults' => new \PHPExiftool\Driver\Tag\DICOM\NamesOfIntendedRecipientsOfResults(),
                'IntendedRecipientsOfResultsIDSeq' => new \PHPExiftool\Driver\Tag\DICOM\IntendedRecipientsOfResultsIDSeq(),
                'PersonIdentificationCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PersonIdentificationCodeSequence(),
                'PersonAddress' => new \PHPExiftool\Driver\Tag\DICOM\PersonAddress(),
                'PersonTelephoneNumbers' => new \PHPExiftool\Driver\Tag\DICOM\PersonTelephoneNumbers(),
                'RequestedProcedureComments' => new \PHPExiftool\Driver\Tag\DICOM\RequestedProcedureComments(),
                'ReasonForImagingServiceRequest' => new \PHPExiftool\Driver\Tag\DICOM\ReasonForImagingServiceRequest(),
                'IssueDateOfImagingServiceRequest' => new \PHPExiftool\Driver\Tag\DICOM\IssueDateOfImagingServiceRequest(),
                'IssueTimeOfImagingServiceRequest' => new \PHPExiftool\Driver\Tag\DICOM\IssueTimeOfImagingServiceRequest(),
                'PlacerOrderNum-ImagingServiceReq' => new \PHPExiftool\Driver\Tag\DICOM\PlacerOrderNumImagingServiceReq(),
                'FillerOrderNum-ImagingServiceReq' => new \PHPExiftool\Driver\Tag\DICOM\FillerOrderNumImagingServiceReq(),
                'OrderEnteredBy' => new \PHPExiftool\Driver\Tag\DICOM\OrderEnteredBy(),
                'OrderEntererLocation' => new \PHPExiftool\Driver\Tag\DICOM\OrderEntererLocation(),
                'OrderCallbackPhoneNumber' => new \PHPExiftool\Driver\Tag\DICOM\OrderCallbackPhoneNumber(),
                'ImagingServiceRequestComments' => new \PHPExiftool\Driver\Tag\DICOM\ImagingServiceRequestComments(),
                'ConfidentialityOnPatientDataDescr' => new \PHPExiftool\Driver\Tag\DICOM\ConfidentialityOnPatientDataDescr(),
                'GenPurposeScheduledProcStepStatus' => new \PHPExiftool\Driver\Tag\DICOM\GenPurposeScheduledProcStepStatus(),
                'GenPurposePerformedProcStepStatus' => new \PHPExiftool\Driver\Tag\DICOM\GenPurposePerformedProcStepStatus(),
                'GenPurposeSchedProcStepPriority' => new \PHPExiftool\Driver\Tag\DICOM\GenPurposeSchedProcStepPriority(),
                'SchedProcessingApplicationsCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\SchedProcessingApplicationsCodeSeq(),
                'SchedProcedureStepStartDateAndTime' => new \PHPExiftool\Driver\Tag\DICOM\SchedProcedureStepStartDateAndTime(),
                'MultipleCopiesFlag' => new \PHPExiftool\Driver\Tag\DICOM\MultipleCopiesFlag(),
                'PerformedProcessingAppsCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcessingAppsCodeSeq(),
                'HumanPerformerCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\HumanPerformerCodeSequence(),
                'SchedProcStepModificationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\SchedProcStepModificationDateTime(),
                'ExpectedCompletionDateAndTime' => new \PHPExiftool\Driver\Tag\DICOM\ExpectedCompletionDateAndTime(),
                'ResultingGenPurposePerfProcStepSeq' => new \PHPExiftool\Driver\Tag\DICOM\ResultingGenPurposePerfProcStepSeq(),
                'RefGenPurposeSchedProcStepSeq' => new \PHPExiftool\Driver\Tag\DICOM\RefGenPurposeSchedProcStepSeq(),
                'ScheduledWorkitemCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledWorkitemCodeSequence(),
                'PerformedWorkitemCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformedWorkitemCodeSequence(),
                'InputAvailabilityFlag' => new \PHPExiftool\Driver\Tag\DICOM\InputAvailabilityFlag(),
                'InputInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\InputInformationSequence(),
                'RelevantInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\RelevantInformationSequence(),
                'RefGenPurSchedProcStepTransUID' => new \PHPExiftool\Driver\Tag\DICOM\RefGenPurSchedProcStepTransUID(),
                'ScheduledStationNameCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStationNameCodeSequence(),
                'ScheduledStationClassCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledStationClassCodeSequence(),
                'SchedStationGeographicLocCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\SchedStationGeographicLocCodeSeq(),
                'PerformedStationNameCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformedStationNameCodeSequence(),
                'PerformedStationClassCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformedStationClassCodeSequence(),
                'PerformedStationGeogLocCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\PerformedStationGeogLocCodeSeq(),
                'RequestedSubsequentWorkItemCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\RequestedSubsequentWorkItemCodeSeq(),
                'NonDICOMOutputCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\NonDICOMOutputCodeSequence(),
                'OutputInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\OutputInformationSequence(),
                'ScheduledHumanPerformersSequence' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledHumanPerformersSequence(),
                'ActualHumanPerformersSequence' => new \PHPExiftool\Driver\Tag\DICOM\ActualHumanPerformersSequence(),
                'HumanPerformersOrganization' => new \PHPExiftool\Driver\Tag\DICOM\HumanPerformersOrganization(),
                'HumanPerformerName' => new \PHPExiftool\Driver\Tag\DICOM\HumanPerformerName(),
                'RawDataHandling' => new \PHPExiftool\Driver\Tag\DICOM\RawDataHandling(),
                'EntranceDoseInMilliGy' => new \PHPExiftool\Driver\Tag\DICOM\EntranceDoseInMilliGy(),
                'RefImageRealWorldValueMappingSeq' => new \PHPExiftool\Driver\Tag\DICOM\RefImageRealWorldValueMappingSeq(),
                'RealWorldValueMappingSequence' => new \PHPExiftool\Driver\Tag\DICOM\RealWorldValueMappingSequence(),
                'PixelValueMappingCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PixelValueMappingCodeSequence(),
                'LUTLabel' => new \PHPExiftool\Driver\Tag\DICOM\LUTLabel(),
                'RealWorldValueLastValueMapped' => new \PHPExiftool\Driver\Tag\DICOM\RealWorldValueLastValueMapped(),
                'RealWorldValueLUTData' => new \PHPExiftool\Driver\Tag\DICOM\RealWorldValueLUTData(),
                'RealWorldValueFirstValueMapped' => new \PHPExiftool\Driver\Tag\DICOM\RealWorldValueFirstValueMapped(),
                'RealWorldValueIntercept' => new \PHPExiftool\Driver\Tag\DICOM\RealWorldValueIntercept(),
                'RealWorldValueSlope' => new \PHPExiftool\Driver\Tag\DICOM\RealWorldValueSlope(),
                'RelationshipType' => new \PHPExiftool\Driver\Tag\DICOM\RelationshipType(),
                'VerifyingOrganization' => new \PHPExiftool\Driver\Tag\DICOM\VerifyingOrganization(),
                'VerificationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\VerificationDateTime(),
                'ObservationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\ObservationDateTime(),
                'ValueType' => new \PHPExiftool\Driver\Tag\DICOM\ValueType(),
                'ConceptNameCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ConceptNameCodeSequence(),
                'ContinuityOfContent' => new \PHPExiftool\Driver\Tag\DICOM\ContinuityOfContent(),
                'VerifyingObserverSequence' => new \PHPExiftool\Driver\Tag\DICOM\VerifyingObserverSequence(),
                'VerifyingObserverName' => new \PHPExiftool\Driver\Tag\DICOM\VerifyingObserverName(),
                'AuthorObserverSequence' => new \PHPExiftool\Driver\Tag\DICOM\AuthorObserverSequence(),
                'ParticipantSequence' => new \PHPExiftool\Driver\Tag\DICOM\ParticipantSequence(),
                'CustodialOrganizationSequence' => new \PHPExiftool\Driver\Tag\DICOM\CustodialOrganizationSequence(),
                'ParticipationType' => new \PHPExiftool\Driver\Tag\DICOM\ParticipationType(),
                'ParticipationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\ParticipationDateTime(),
                'ObserverType' => new \PHPExiftool\Driver\Tag\DICOM\ObserverType(),
                'VerifyingObserverIdentCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\VerifyingObserverIdentCodeSequence(),
                'EquivalentCDADocumentSequence' => new \PHPExiftool\Driver\Tag\DICOM\EquivalentCDADocumentSequence(),
                'ReferencedWaveformChannels' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedWaveformChannels(),
                'DateTime' => new \PHPExiftool\Driver\Tag\DICOM\DateTime(),
                'Date' => new \PHPExiftool\Driver\Tag\DICOM\Date(),
                'Time' => new \PHPExiftool\Driver\Tag\DICOM\Time(),
                'PersonName' => new \PHPExiftool\Driver\Tag\DICOM\PersonName(),
                'UID' => new \PHPExiftool\Driver\Tag\DICOM\UID(),
                'TemporalRangeType' => new \PHPExiftool\Driver\Tag\DICOM\TemporalRangeType(),
                'ReferencedSamplePositions' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSamplePositions(),
                'ReferencedFrameNumbers' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFrameNumbers(),
                'ReferencedTimeOffsets' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedTimeOffsets(),
                'ReferencedDateTime' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedDateTime(),
                'TextValue' => new \PHPExiftool\Driver\Tag\DICOM\TextValue(),
                'ConceptCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ConceptCodeSequence(),
                'PurposeOfReferenceCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PurposeOfReferenceCodeSequence(),
                'AnnotationGroupNumber' => new \PHPExiftool\Driver\Tag\DICOM\AnnotationGroupNumber(),
                'ModifierCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ModifierCodeSequence(),
                'MeasuredValueSequence' => new \PHPExiftool\Driver\Tag\DICOM\MeasuredValueSequence(),
                'NumericValueQualifierCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\NumericValueQualifierCodeSequence(),
                'NumericValue' => new \PHPExiftool\Driver\Tag\DICOM\NumericValue(),
                'AddressTrial' => new \PHPExiftool\Driver\Tag\DICOM\AddressTrial(),
                'TelephoneNumberTrial' => new \PHPExiftool\Driver\Tag\DICOM\TelephoneNumberTrial(),
                'PredecessorDocumentsSequence' => new \PHPExiftool\Driver\Tag\DICOM\PredecessorDocumentsSequence(),
                'ReferencedRequestSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedRequestSequence(),
                'PerformedProcedureCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcedureCodeSequence(),
                'CurrentRequestedProcEvidenceSeq' => new \PHPExiftool\Driver\Tag\DICOM\CurrentRequestedProcEvidenceSeq(),
                'PertinentOtherEvidenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\PertinentOtherEvidenceSequence(),
                'HL7StructuredDocumentRefSeq' => new \PHPExiftool\Driver\Tag\DICOM\HL7StructuredDocumentRefSeq(),
                'CompletionFlag' => new \PHPExiftool\Driver\Tag\DICOM\CompletionFlag(),
                'CompletionFlagDescription' => new \PHPExiftool\Driver\Tag\DICOM\CompletionFlagDescription(),
                'VerificationFlag' => new \PHPExiftool\Driver\Tag\DICOM\VerificationFlag(),
                'ArchiveRequested' => new \PHPExiftool\Driver\Tag\DICOM\ArchiveRequested(),
                'PreliminaryFlag' => new \PHPExiftool\Driver\Tag\DICOM\PreliminaryFlag(),
                'ContentTemplateSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContentTemplateSequence(),
                'IdenticalDocumentsSequence' => new \PHPExiftool\Driver\Tag\DICOM\IdenticalDocumentsSequence(),
                'ContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContentSequence(),
                'AnnotationSequence' => new \PHPExiftool\Driver\Tag\DICOM\AnnotationSequence(),
                'TemplateIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\TemplateIdentifier(),
                'TemplateVersion' => new \PHPExiftool\Driver\Tag\DICOM\TemplateVersion(),
                'TemplateLocalVersion' => new \PHPExiftool\Driver\Tag\DICOM\TemplateLocalVersion(),
                'TemplateExtensionFlag' => new \PHPExiftool\Driver\Tag\DICOM\TemplateExtensionFlag(),
                'TemplateExtensionOrganizationUID' => new \PHPExiftool\Driver\Tag\DICOM\TemplateExtensionOrganizationUID(),
                'TemplateExtensionCreatorUID' => new \PHPExiftool\Driver\Tag\DICOM\TemplateExtensionCreatorUID(),
                'ReferencedContentItemIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedContentItemIdentifier(),
                'HL7InstanceIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\HL7InstanceIdentifier(),
                'HL7DocumentEffectiveTime' => new \PHPExiftool\Driver\Tag\DICOM\HL7DocumentEffectiveTime(),
                'HL7DocumentTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\HL7DocumentTypeCodeSequence(),
                'RetrieveURI' => new \PHPExiftool\Driver\Tag\DICOM\RetrieveURI(),
                'RetrieveLocationUID' => new \PHPExiftool\Driver\Tag\DICOM\RetrieveLocationUID(),
                'DocumentTitle' => new \PHPExiftool\Driver\Tag\DICOM\DocumentTitle(),
                'EncapsulatedDocument' => new \PHPExiftool\Driver\Tag\DICOM\EncapsulatedDocument(),
                'MIMETypeOfEncapsulatedDocument' => new \PHPExiftool\Driver\Tag\DICOM\MIMETypeOfEncapsulatedDocument(),
                'SourceInstanceSequence' => new \PHPExiftool\Driver\Tag\DICOM\SourceInstanceSequence(),
                'ListOfMIMETypes' => new \PHPExiftool\Driver\Tag\DICOM\ListOfMIMETypes(),
                'BitmapOfPrescanOptions' => new \PHPExiftool\Driver\Tag\DICOM\BitmapOfPrescanOptions(),
                'GradientOffsetInX' => new \PHPExiftool\Driver\Tag\DICOM\GradientOffsetInX(),
                'GradientOffsetInY' => new \PHPExiftool\Driver\Tag\DICOM\GradientOffsetInY(),
                'GradientOffsetInZ' => new \PHPExiftool\Driver\Tag\DICOM\GradientOffsetInZ(),
                'ImgIsOriginalOrUnoriginal' => new \PHPExiftool\Driver\Tag\DICOM\ImgIsOriginalOrUnoriginal(),
                'NumberOfEPIShots' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfEPIShots(),
                'ViewsPerSegment' => new \PHPExiftool\Driver\Tag\DICOM\ViewsPerSegment(),
                'RespiratoryRateBpm' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryRateBpm(),
                'RespiratoryTriggerPoint' => new \PHPExiftool\Driver\Tag\DICOM\RespiratoryTriggerPoint(),
                'TypeOfReceiverUsed' => new \PHPExiftool\Driver\Tag\DICOM\TypeOfReceiverUsed(),
                'PeakRateOfChangeOfGradientField' => new \PHPExiftool\Driver\Tag\DICOM\PeakRateOfChangeOfGradientField(),
                'LimitsInUnitsOfPercent' => new \PHPExiftool\Driver\Tag\DICOM\LimitsInUnitsOfPercent(),
                'PSDEstimatedLimit' => new \PHPExiftool\Driver\Tag\DICOM\PSDEstimatedLimit(),
                'PSDEstimatedLimitInTeslaPerSecond' => new \PHPExiftool\Driver\Tag\DICOM\PSDEstimatedLimitInTeslaPerSecond(),
                'Saravghead' => new \PHPExiftool\Driver\Tag\DICOM\Saravghead(),
                'WindowValue' => new \PHPExiftool\Driver\Tag\DICOM\WindowValue(),
                'TotalInputViews' => new \PHPExiftool\Driver\Tag\DICOM\TotalInputViews(),
                'X-RayChain' => new \PHPExiftool\Driver\Tag\DICOM\XRayChain(),
                'DeconKernelParameters' => new \PHPExiftool\Driver\Tag\DICOM\DeconKernelParameters(),
                'CalibrationParameters' => new \PHPExiftool\Driver\Tag\DICOM\CalibrationParameters(),
                'TotalOutputViews' => new \PHPExiftool\Driver\Tag\DICOM\TotalOutputViews(),
                'NumberOfOverranges' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfOverranges(),
                'IBHImageScaleFactors' => new \PHPExiftool\Driver\Tag\DICOM\IBHImageScaleFactors(),
                'BBHCoefficients' => new \PHPExiftool\Driver\Tag\DICOM\BBHCoefficients(),
                'NumberOfBBHChainsToBlend' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfBBHChainsToBlend(),
                'StartingChannelNumber' => new \PHPExiftool\Driver\Tag\DICOM\StartingChannelNumber(),
                'PpscanParameters' => new \PHPExiftool\Driver\Tag\DICOM\PpscanParameters(),
                'GEImageIntegrity' => new \PHPExiftool\Driver\Tag\DICOM\GEImageIntegrity(),
                'LevelValue' => new \PHPExiftool\Driver\Tag\DICOM\LevelValue(),
                'DeltaStartTime' => new \PHPExiftool\Driver\Tag\DICOM\DeltaStartTime(),
                'MaxOverrangesInAView' => new \PHPExiftool\Driver\Tag\DICOM\MaxOverrangesInAView(),
                'AvgOverrangesAllViews' => new \PHPExiftool\Driver\Tag\DICOM\AvgOverrangesAllViews(),
                'CorrectedAfterGlowTerms' => new \PHPExiftool\Driver\Tag\DICOM\CorrectedAfterGlowTerms(),
                'ReferenceChannels' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceChannels(),
                'NoViewsRefChansBlocked' => new \PHPExiftool\Driver\Tag\DICOM\NoViewsRefChansBlocked(),
                'ScanPitchRatio' => new \PHPExiftool\Driver\Tag\DICOM\ScanPitchRatio(),
                'UniqueImageIden' => new \PHPExiftool\Driver\Tag\DICOM\UniqueImageIden(),
                'HistogramTables' => new \PHPExiftool\Driver\Tag\DICOM\HistogramTables(),
                'UserDefinedData' => new \PHPExiftool\Driver\Tag\DICOM\UserDefinedData(),
                'PrivateScanOptions' => new \PHPExiftool\Driver\Tag\DICOM\PrivateScanOptions(),
                'EffectiveEchoSpacing' => new \PHPExiftool\Driver\Tag\DICOM\EffectiveEchoSpacing(),
                'StringSlopField1' => new \PHPExiftool\Driver\Tag\DICOM\StringSlopField1(),
                'StringSlopField2' => new \PHPExiftool\Driver\Tag\DICOM\StringSlopField2(),
                'RACordOfTargetReconCenter' => new \PHPExiftool\Driver\Tag\DICOM\RACordOfTargetReconCenter(),
                'NegScanspacing' => new \PHPExiftool\Driver\Tag\DICOM\NegScanspacing(),
                'OffsetFrequency' => new \PHPExiftool\Driver\Tag\DICOM\OffsetFrequency(),
                'UserUsageTag' => new \PHPExiftool\Driver\Tag\DICOM\UserUsageTag(),
                'UserFillMapMSW' => new \PHPExiftool\Driver\Tag\DICOM\UserFillMapMSW(),
                'UserFillMapLSW' => new \PHPExiftool\Driver\Tag\DICOM\UserFillMapLSW(),
                'User25-48' => new \PHPExiftool\Driver\Tag\DICOM\User2548(),
                'SlopInt6-9' => new \PHPExiftool\Driver\Tag\DICOM\SlopInt69(),
                'TriggerOnPosition' => new \PHPExiftool\Driver\Tag\DICOM\TriggerOnPosition(),
                'DegreeOfRotation' => new \PHPExiftool\Driver\Tag\DICOM\DegreeOfRotation(),
                'DASTriggerSource' => new \PHPExiftool\Driver\Tag\DICOM\DASTriggerSource(),
                'DASFpaGain' => new \PHPExiftool\Driver\Tag\DICOM\DASFpaGain(),
                'DASOutputSource' => new \PHPExiftool\Driver\Tag\DICOM\DASOutputSource(),
                'DASAdInput' => new \PHPExiftool\Driver\Tag\DICOM\DASAdInput(),
                'DASCalMode' => new \PHPExiftool\Driver\Tag\DICOM\DASCalMode(),
                'DASCalFrequency' => new \PHPExiftool\Driver\Tag\DICOM\DASCalFrequency(),
                'DASRegXm' => new \PHPExiftool\Driver\Tag\DICOM\DASRegXm(),
                'DASAutoZero' => new \PHPExiftool\Driver\Tag\DICOM\DASAutoZero(),
                'StartingChannelOfView' => new \PHPExiftool\Driver\Tag\DICOM\StartingChannelOfView(),
                'DASXmPattern' => new \PHPExiftool\Driver\Tag\DICOM\DASXmPattern(),
                'TGGCTriggerMode' => new \PHPExiftool\Driver\Tag\DICOM\TGGCTriggerMode(),
                'StartScanToXrayOnDelay' => new \PHPExiftool\Driver\Tag\DICOM\StartScanToXrayOnDelay(),
                'DurationOfXrayOn' => new \PHPExiftool\Driver\Tag\DICOM\DurationOfXrayOn(),
                'SlopInt10-17' => new \PHPExiftool\Driver\Tag\DICOM\SlopInt1017(),
                'ScannerStudyEntityUID' => new \PHPExiftool\Driver\Tag\DICOM\ScannerStudyEntityUID(),
                'ScannerStudyID' => new \PHPExiftool\Driver\Tag\DICOM\ScannerStudyID(),
                'ScannerTableEntry' => new \PHPExiftool\Driver\Tag\DICOM\ScannerTableEntry(),
                'ProductPackageIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\ProductPackageIdentifier(),
                'SubstanceAdministrationApproval' => new \PHPExiftool\Driver\Tag\DICOM\SubstanceAdministrationApproval(),
                'ApprovalStatusFurtherDescription' => new \PHPExiftool\Driver\Tag\DICOM\ApprovalStatusFurtherDescription(),
                'ApprovalStatusDateTime' => new \PHPExiftool\Driver\Tag\DICOM\ApprovalStatusDateTime(),
                'ProductTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ProductTypeCodeSequence(),
                'ProductName' => new \PHPExiftool\Driver\Tag\DICOM\ProductName(),
                'ProductDescription' => new \PHPExiftool\Driver\Tag\DICOM\ProductDescription(),
                'ProductLotIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\ProductLotIdentifier(),
                'ProductExpirationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\ProductExpirationDateTime(),
                'SubstanceAdministrationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\SubstanceAdministrationDateTime(),
                'SubstanceAdministrationNotes' => new \PHPExiftool\Driver\Tag\DICOM\SubstanceAdministrationNotes(),
                'SubstanceAdministrationDeviceID' => new \PHPExiftool\Driver\Tag\DICOM\SubstanceAdministrationDeviceID(),
                'ProductParameterSequence' => new \PHPExiftool\Driver\Tag\DICOM\ProductParameterSequence(),
                'SubstanceAdminParameterSeq' => new \PHPExiftool\Driver\Tag\DICOM\SubstanceAdminParameterSeq(),
                'NumberOfMacroRowsInDetector' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfMacroRowsInDetector(),
                'MacroWidthAtISOCenter' => new \PHPExiftool\Driver\Tag\DICOM\MacroWidthAtISOCenter(),
                'DASType' => new \PHPExiftool\Driver\Tag\DICOM\DASType(),
                'DASGain' => new \PHPExiftool\Driver\Tag\DICOM\DASGain(),
                'DASTemperature' => new \PHPExiftool\Driver\Tag\DICOM\DASTemperature(),
                'TableDirectionInOrOut' => new \PHPExiftool\Driver\Tag\DICOM\TableDirectionInOrOut(),
                'ZSmoothingFactor' => new \PHPExiftool\Driver\Tag\DICOM\ZSmoothingFactor(),
                'ViewWeightingMode' => new \PHPExiftool\Driver\Tag\DICOM\ViewWeightingMode(),
                'SigmaRowNumberWhichRowsWereUsed' => new \PHPExiftool\Driver\Tag\DICOM\SigmaRowNumberWhichRowsWereUsed(),
                'MinimumDasValueFoundInTheScanData' => new \PHPExiftool\Driver\Tag\DICOM\MinimumDasValueFoundInTheScanData(),
                'MaximumOffsetShiftValueUsed' => new \PHPExiftool\Driver\Tag\DICOM\MaximumOffsetShiftValueUsed(),
                'NumberOfViewsShifted' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViewsShifted(),
                'ZTrackingFlag' => new \PHPExiftool\Driver\Tag\DICOM\ZTrackingFlag(),
                'MeanZError' => new \PHPExiftool\Driver\Tag\DICOM\MeanZError(),
                'ZTrackingMaximumError' => new \PHPExiftool\Driver\Tag\DICOM\ZTrackingMaximumError(),
                'StartingViewForRow2a' => new \PHPExiftool\Driver\Tag\DICOM\StartingViewForRow2a(),
                'NumberOfViewsInRow2a' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViewsInRow2a(),
                'StartingViewForRow1a' => new \PHPExiftool\Driver\Tag\DICOM\StartingViewForRow1a(),
                'SigmaMode' => new \PHPExiftool\Driver\Tag\DICOM\SigmaMode(),
                'NumberOfViewsInRow1a' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViewsInRow1a(),
                'StartingViewForRow2b' => new \PHPExiftool\Driver\Tag\DICOM\StartingViewForRow2b(),
                'NumberOfViewsInRow2b' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViewsInRow2b(),
                'StartingViewForRow1b' => new \PHPExiftool\Driver\Tag\DICOM\StartingViewForRow1b(),
                'NumberOfViewsInRow1b' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfViewsInRow1b(),
                'AirFilterCalibrationDate' => new \PHPExiftool\Driver\Tag\DICOM\AirFilterCalibrationDate(),
                'AirFilterCalibrationTime' => new \PHPExiftool\Driver\Tag\DICOM\AirFilterCalibrationTime(),
                'PhantomCalibrationDate' => new \PHPExiftool\Driver\Tag\DICOM\PhantomCalibrationDate(),
                'PhantomCalibrationTime' => new \PHPExiftool\Driver\Tag\DICOM\PhantomCalibrationTime(),
                'ZSlopeCalibrationDate' => new \PHPExiftool\Driver\Tag\DICOM\ZSlopeCalibrationDate(),
                'ZSlopeCalibrationTime' => new \PHPExiftool\Driver\Tag\DICOM\ZSlopeCalibrationTime(),
                'CrosstalkCalibrationDate' => new \PHPExiftool\Driver\Tag\DICOM\CrosstalkCalibrationDate(),
                'CrosstalkCalibrationTime' => new \PHPExiftool\Driver\Tag\DICOM\CrosstalkCalibrationTime(),
                'IterboneOptionFlag' => new \PHPExiftool\Driver\Tag\DICOM\IterboneOptionFlag(),
                'PeristalticFlagOption' => new \PHPExiftool\Driver\Tag\DICOM\PeristalticFlagOption(),
                'LensDescription' => new \PHPExiftool\Driver\Tag\DICOM\LensDescription(),
                'RightLensSequence' => new \PHPExiftool\Driver\Tag\DICOM\RightLensSequence(),
                'LeftLensSequence' => new \PHPExiftool\Driver\Tag\DICOM\LeftLensSequence(),
                'CylinderSequence' => new \PHPExiftool\Driver\Tag\DICOM\CylinderSequence(),
                'PrismSequence' => new \PHPExiftool\Driver\Tag\DICOM\PrismSequence(),
                'HorizontalPrismPower' => new \PHPExiftool\Driver\Tag\DICOM\HorizontalPrismPower(),
                'HorizontalPrismBase' => new \PHPExiftool\Driver\Tag\DICOM\HorizontalPrismBase(),
                'VerticalPrismPower' => new \PHPExiftool\Driver\Tag\DICOM\VerticalPrismPower(),
                'VerticalPrismBase' => new \PHPExiftool\Driver\Tag\DICOM\VerticalPrismBase(),
                'LensSegmentType' => new \PHPExiftool\Driver\Tag\DICOM\LensSegmentType(),
                'OpticalTransmittance' => new \PHPExiftool\Driver\Tag\DICOM\OpticalTransmittance(),
                'ChannelWidth' => new \PHPExiftool\Driver\Tag\DICOM\ChannelWidth(),
                'PupilSize' => new \PHPExiftool\Driver\Tag\DICOM\PupilSize(),
                'CornealSize' => new \PHPExiftool\Driver\Tag\DICOM\CornealSize(),
                'DistancePupillaryDistance' => new \PHPExiftool\Driver\Tag\DICOM\DistancePupillaryDistance(),
                'NearPupillaryDistance' => new \PHPExiftool\Driver\Tag\DICOM\NearPupillaryDistance(),
                'OtherPupillaryDistance' => new \PHPExiftool\Driver\Tag\DICOM\OtherPupillaryDistance(),
                'RadiusOfCurvature' => new \PHPExiftool\Driver\Tag\DICOM\RadiusOfCurvature(),
                'KeratometricPower' => new \PHPExiftool\Driver\Tag\DICOM\KeratometricPower(),
                'KeratometricAxis' => new \PHPExiftool\Driver\Tag\DICOM\KeratometricAxis(),
                'BackgroundColor' => new \PHPExiftool\Driver\Tag\DICOM\BackgroundColor(),
                'Optotype' => new \PHPExiftool\Driver\Tag\DICOM\Optotype(),
                'OptotypePresentation' => new \PHPExiftool\Driver\Tag\DICOM\OptotypePresentation(),
                'AddNearSequence' => new \PHPExiftool\Driver\Tag\DICOM\AddNearSequence(),
                'AddIntermediateSequence' => new \PHPExiftool\Driver\Tag\DICOM\AddIntermediateSequence(),
                'AddOtherSequence' => new \PHPExiftool\Driver\Tag\DICOM\AddOtherSequence(),
                'AddPower' => new \PHPExiftool\Driver\Tag\DICOM\AddPower(),
                'ViewingDistance' => new \PHPExiftool\Driver\Tag\DICOM\ViewingDistance(),
                'ViewingDistanceType' => new \PHPExiftool\Driver\Tag\DICOM\ViewingDistanceType(),
                'VisualAcuityModifiers' => new \PHPExiftool\Driver\Tag\DICOM\VisualAcuityModifiers(),
                'DecimalVisualAcuity' => new \PHPExiftool\Driver\Tag\DICOM\DecimalVisualAcuity(),
                'OptotypeDetailedDefinition' => new \PHPExiftool\Driver\Tag\DICOM\OptotypeDetailedDefinition(),
                'SpherePower' => new \PHPExiftool\Driver\Tag\DICOM\SpherePower(),
                'CylinderPower' => new \PHPExiftool\Driver\Tag\DICOM\CylinderPower(),
                'CalibrationImage' => new \PHPExiftool\Driver\Tag\DICOM\CalibrationImage(),
                'DeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\DeviceSequence(),
                'DeviceLength' => new \PHPExiftool\Driver\Tag\DICOM\DeviceLength(),
                'ContainerComponentWidth' => new \PHPExiftool\Driver\Tag\DICOM\ContainerComponentWidth(),
                'DeviceDiameter' => new \PHPExiftool\Driver\Tag\DICOM\DeviceDiameter(),
                'DeviceDiameterUnits' => new \PHPExiftool\Driver\Tag\DICOM\DeviceDiameterUnits(),
                'DeviceVolume' => new \PHPExiftool\Driver\Tag\DICOM\DeviceVolume(),
                'InterMarkerDistance' => new \PHPExiftool\Driver\Tag\DICOM\InterMarkerDistance(),
                'ContainerComponentID' => new \PHPExiftool\Driver\Tag\DICOM\ContainerComponentID(),
                'DeviceDescription' => new \PHPExiftool\Driver\Tag\DICOM\DeviceDescription(),
                'EnergyWindowVector' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowVector(),
                'NumberOfEnergyWindows' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfEnergyWindows(),
                'EnergyWindowInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowInformationSequence(),
                'EnergyWindowRangeSequence' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowRangeSequence(),
                'EnergyWindowLowerLimit' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowLowerLimit(),
                'EnergyWindowUpperLimit' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowUpperLimit(),
                'RadiopharmaceuticalInformationSeq' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalInformationSeq(),
                'ResidualSyringeCounts' => new \PHPExiftool\Driver\Tag\DICOM\ResidualSyringeCounts(),
                'EnergyWindowName' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowName(),
                'DetectorVector' => new \PHPExiftool\Driver\Tag\DICOM\DetectorVector(),
                'NumberOfDetectors' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfDetectors(),
                'DetectorInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\DetectorInformationSequence(),
                'PhaseVector' => new \PHPExiftool\Driver\Tag\DICOM\PhaseVector(),
                'NumberOfPhases' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPhases(),
                'PhaseInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\PhaseInformationSequence(),
                'NumberOfFramesInPhase' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFramesInPhase(),
                'PhaseDelay' => new \PHPExiftool\Driver\Tag\DICOM\PhaseDelay(),
                'PauseBetweenFrames' => new \PHPExiftool\Driver\Tag\DICOM\PauseBetweenFrames(),
                'PhaseDescription' => new \PHPExiftool\Driver\Tag\DICOM\PhaseDescription(),
                'RotationVector' => new \PHPExiftool\Driver\Tag\DICOM\RotationVector(),
                'NumberOfRotations' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfRotations(),
                'RotationInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\RotationInformationSequence(),
                'NumberOfFramesInRotation' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFramesInRotation(),
                'RRIntervalVector' => new \PHPExiftool\Driver\Tag\DICOM\RRIntervalVector(),
                'NumberOfRRIntervals' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfRRIntervals(),
                'GatedInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\GatedInformationSequence(),
                'DataInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\DataInformationSequence(),
                'TimeSlotVector' => new \PHPExiftool\Driver\Tag\DICOM\TimeSlotVector(),
                'NumberOfTimeSlots' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTimeSlots(),
                'TimeSlotInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\TimeSlotInformationSequence(),
                'TimeSlotTime' => new \PHPExiftool\Driver\Tag\DICOM\TimeSlotTime(),
                'SliceVector' => new \PHPExiftool\Driver\Tag\DICOM\SliceVector(),
                'NumberOfSlices' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSlices(),
                'AngularViewVector' => new \PHPExiftool\Driver\Tag\DICOM\AngularViewVector(),
                'TimeSliceVector' => new \PHPExiftool\Driver\Tag\DICOM\TimeSliceVector(),
                'NumberOfTimeSlices' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTimeSlices(),
                'StartAngle' => new \PHPExiftool\Driver\Tag\DICOM\StartAngle(),
                'TypeOfDetectorMotion' => new \PHPExiftool\Driver\Tag\DICOM\TypeOfDetectorMotion(),
                'TriggerVector' => new \PHPExiftool\Driver\Tag\DICOM\TriggerVector(),
                'NumberOfTriggersInPhase' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfTriggersInPhase(),
                'ViewCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ViewCodeSequence(),
                'ViewModifierCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ViewModifierCodeSequence(),
                'RadionuclideCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RadionuclideCodeSequence(),
                'AdministrationRouteCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\AdministrationRouteCodeSequence(),
                'RadiopharmaceuticalCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RadiopharmaceuticalCodeSequence(),
                'CalibrationDataSequence' => new \PHPExiftool\Driver\Tag\DICOM\CalibrationDataSequence(),
                'EnergyWindowNumber' => new \PHPExiftool\Driver\Tag\DICOM\EnergyWindowNumber(),
                'ImageID' => new \PHPExiftool\Driver\Tag\DICOM\ImageID(),
                'PatientOrientationCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\PatientOrientationCodeSequence(),
                'PatientOrientationModifierCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\PatientOrientationModifierCodeSeq(),
                'PatientGantryRelationshipCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\PatientGantryRelationshipCodeSeq(),
                'SliceProgressionDirection' => new \PHPExiftool\Driver\Tag\DICOM\SliceProgressionDirection(),
                'SeriesType' => new \PHPExiftool\Driver\Tag\DICOM\SeriesType(),
                'Units' => new \PHPExiftool\Driver\Tag\DICOM\Units(),
                'CountsSource' => new \PHPExiftool\Driver\Tag\DICOM\CountsSource(),
                'ReprojectionMethod' => new \PHPExiftool\Driver\Tag\DICOM\ReprojectionMethod(),
                'RandomsCorrectionMethod' => new \PHPExiftool\Driver\Tag\DICOM\RandomsCorrectionMethod(),
                'AttenuationCorrectionMethod' => new \PHPExiftool\Driver\Tag\DICOM\AttenuationCorrectionMethod(),
                'DecayCorrection' => new \PHPExiftool\Driver\Tag\DICOM\DecayCorrection(),
                'ReconstructionMethod' => new \PHPExiftool\Driver\Tag\DICOM\ReconstructionMethod(),
                'DetectorLinesOfResponseUsed' => new \PHPExiftool\Driver\Tag\DICOM\DetectorLinesOfResponseUsed(),
                'ScatterCorrectionMethod' => new \PHPExiftool\Driver\Tag\DICOM\ScatterCorrectionMethod(),
                'AxialAcceptance' => new \PHPExiftool\Driver\Tag\DICOM\AxialAcceptance(),
                'AxialMash' => new \PHPExiftool\Driver\Tag\DICOM\AxialMash(),
                'TransverseMash' => new \PHPExiftool\Driver\Tag\DICOM\TransverseMash(),
                'DetectorElementSize' => new \PHPExiftool\Driver\Tag\DICOM\DetectorElementSize(),
                'CoincidenceWindowWidth' => new \PHPExiftool\Driver\Tag\DICOM\CoincidenceWindowWidth(),
                'SecondaryCountsType' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryCountsType(),
                'FrameReferenceTime' => new \PHPExiftool\Driver\Tag\DICOM\FrameReferenceTime(),
                'PrimaryCountsAccumulated' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryCountsAccumulated(),
                'SecondaryCountsAccumulated' => new \PHPExiftool\Driver\Tag\DICOM\SecondaryCountsAccumulated(),
                'SliceSensitivityFactor' => new \PHPExiftool\Driver\Tag\DICOM\SliceSensitivityFactor(),
                'DecayFactor' => new \PHPExiftool\Driver\Tag\DICOM\DecayFactor(),
                'DoseCalibrationFactor' => new \PHPExiftool\Driver\Tag\DICOM\DoseCalibrationFactor(),
                'ScatterFractionFactor' => new \PHPExiftool\Driver\Tag\DICOM\ScatterFractionFactor(),
                'DeadTimeFactor' => new \PHPExiftool\Driver\Tag\DICOM\DeadTimeFactor(),
                'ImageIndex' => new \PHPExiftool\Driver\Tag\DICOM\ImageIndex(),
                'CountsIncluded' => new \PHPExiftool\Driver\Tag\DICOM\CountsIncluded(),
                'DeadTimeCorrectionFlag' => new \PHPExiftool\Driver\Tag\DICOM\DeadTimeCorrectionFlag(),
                'HistogramSequence' => new \PHPExiftool\Driver\Tag\DICOM\HistogramSequence(),
                'HistogramNumberOfBins' => new \PHPExiftool\Driver\Tag\DICOM\HistogramNumberOfBins(),
                'HistogramFirstBinValue' => new \PHPExiftool\Driver\Tag\DICOM\HistogramFirstBinValue(),
                'HistogramLastBinValue' => new \PHPExiftool\Driver\Tag\DICOM\HistogramLastBinValue(),
                'HistogramBinWidth' => new \PHPExiftool\Driver\Tag\DICOM\HistogramBinWidth(),
                'HistogramExplanation' => new \PHPExiftool\Driver\Tag\DICOM\HistogramExplanation(),
                'HistogramData' => new \PHPExiftool\Driver\Tag\DICOM\HistogramData(),
                'SegmentationType' => new \PHPExiftool\Driver\Tag\DICOM\SegmentationType(),
                'SegmentSequence' => new \PHPExiftool\Driver\Tag\DICOM\SegmentSequence(),
                'SegmentedPropertyCategoryCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\SegmentedPropertyCategoryCodeSeq(),
                'SegmentLabel' => new \PHPExiftool\Driver\Tag\DICOM\SegmentLabel(),
                'SegmentDescription' => new \PHPExiftool\Driver\Tag\DICOM\SegmentDescription(),
                'SegmentAlgorithmType' => new \PHPExiftool\Driver\Tag\DICOM\SegmentAlgorithmType(),
                'SegmentAlgorithmName' => new \PHPExiftool\Driver\Tag\DICOM\SegmentAlgorithmName(),
                'SegmentIdentificationSequence' => new \PHPExiftool\Driver\Tag\DICOM\SegmentIdentificationSequence(),
                'ReferencedSegmentNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSegmentNumber(),
                'RecommendedDisplayGrayscaleValue' => new \PHPExiftool\Driver\Tag\DICOM\RecommendedDisplayGrayscaleValue(),
                'RecommendedDisplayCIELabValue' => new \PHPExiftool\Driver\Tag\DICOM\RecommendedDisplayCIELabValue(),
                'MaximumFractionalValue' => new \PHPExiftool\Driver\Tag\DICOM\MaximumFractionalValue(),
                'SegmentedPropertyTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\SegmentedPropertyTypeCodeSequence(),
                'SegmentationFractionalType' => new \PHPExiftool\Driver\Tag\DICOM\SegmentationFractionalType(),
                'DeformableRegistrationSequence' => new \PHPExiftool\Driver\Tag\DICOM\DeformableRegistrationSequence(),
                'SourceFrameOfReferenceUID' => new \PHPExiftool\Driver\Tag\DICOM\SourceFrameOfReferenceUID(),
                'DeformableRegistrationGridSequence' => new \PHPExiftool\Driver\Tag\DICOM\DeformableRegistrationGridSequence(),
                'GridDimensions' => new \PHPExiftool\Driver\Tag\DICOM\GridDimensions(),
                'GridResolution' => new \PHPExiftool\Driver\Tag\DICOM\GridResolution(),
                'VectorGridData' => new \PHPExiftool\Driver\Tag\DICOM\VectorGridData(),
                'PreDeformationMatrixRegistSeq' => new \PHPExiftool\Driver\Tag\DICOM\PreDeformationMatrixRegistSeq(),
                'PostDeformationMatrixRegistSeq' => new \PHPExiftool\Driver\Tag\DICOM\PostDeformationMatrixRegistSeq(),
                'NumberOfSurfaces' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSurfaces(),
                'SurfaceSequence' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceSequence(),
                'SurfaceNumber' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceNumber(),
                'SurfaceComments' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceComments(),
                'SurfaceProcessing' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceProcessing(),
                'SurfaceProcessingRatio' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceProcessingRatio(),
                'FiniteVolume' => new \PHPExiftool\Driver\Tag\DICOM\FiniteVolume(),
                'Manifold' => new \PHPExiftool\Driver\Tag\DICOM\Manifold(),
                'SurfacePointsSequence' => new \PHPExiftool\Driver\Tag\DICOM\SurfacePointsSequence(),
                'NumberOfSurfacePoints' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSurfacePoints(),
                'PointCoordinatesData' => new \PHPExiftool\Driver\Tag\DICOM\PointCoordinatesData(),
                'PointPositionAccuracy' => new \PHPExiftool\Driver\Tag\DICOM\PointPositionAccuracy(),
                'MeanPointDistance' => new \PHPExiftool\Driver\Tag\DICOM\MeanPointDistance(),
                'MaximumPointDistance' => new \PHPExiftool\Driver\Tag\DICOM\MaximumPointDistance(),
                'AxisOfRotation' => new \PHPExiftool\Driver\Tag\DICOM\AxisOfRotation(),
                'CenterOfRotation' => new \PHPExiftool\Driver\Tag\DICOM\CenterOfRotation(),
                'NumberOfVectors' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfVectors(),
                'VectorDimensionality' => new \PHPExiftool\Driver\Tag\DICOM\VectorDimensionality(),
                'VectorAccuracy' => new \PHPExiftool\Driver\Tag\DICOM\VectorAccuracy(),
                'VectorCoordinateData' => new \PHPExiftool\Driver\Tag\DICOM\VectorCoordinateData(),
                'TrianglePointIndexList' => new \PHPExiftool\Driver\Tag\DICOM\TrianglePointIndexList(),
                'EdgePointIndexList' => new \PHPExiftool\Driver\Tag\DICOM\EdgePointIndexList(),
                'VertexPointIndexList' => new \PHPExiftool\Driver\Tag\DICOM\VertexPointIndexList(),
                'TriangleStripSequence' => new \PHPExiftool\Driver\Tag\DICOM\TriangleStripSequence(),
                'TriangleFanSequence' => new \PHPExiftool\Driver\Tag\DICOM\TriangleFanSequence(),
                'LineSequence' => new \PHPExiftool\Driver\Tag\DICOM\LineSequence(),
                'PrimitivePointIndexList' => new \PHPExiftool\Driver\Tag\DICOM\PrimitivePointIndexList(),
                'SurfaceCount' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceCount(),
                'AlgorithmFamilyCodeSequ' => new \PHPExiftool\Driver\Tag\DICOM\AlgorithmFamilyCodeSequ(),
                'AlgorithmVersion' => new \PHPExiftool\Driver\Tag\DICOM\AlgorithmVersion(),
                'AlgorithmParameters' => new \PHPExiftool\Driver\Tag\DICOM\AlgorithmParameters(),
                'FacetSequence' => new \PHPExiftool\Driver\Tag\DICOM\FacetSequence(),
                'AlgorithmName' => new \PHPExiftool\Driver\Tag\DICOM\AlgorithmName(),
                'GraphicAnnotationSequence' => new \PHPExiftool\Driver\Tag\DICOM\GraphicAnnotationSequence(),
                'GraphicLayer' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayer(),
                'BoundingBoxAnnotationUnits' => new \PHPExiftool\Driver\Tag\DICOM\BoundingBoxAnnotationUnits(),
                'AnchorPointAnnotationUnits' => new \PHPExiftool\Driver\Tag\DICOM\AnchorPointAnnotationUnits(),
                'GraphicAnnotationUnits' => new \PHPExiftool\Driver\Tag\DICOM\GraphicAnnotationUnits(),
                'UnformattedTextValue' => new \PHPExiftool\Driver\Tag\DICOM\UnformattedTextValue(),
                'TextObjectSequence' => new \PHPExiftool\Driver\Tag\DICOM\TextObjectSequence(),
                'GraphicObjectSequence' => new \PHPExiftool\Driver\Tag\DICOM\GraphicObjectSequence(),
                'BoundingBoxTopLeftHandCorner' => new \PHPExiftool\Driver\Tag\DICOM\BoundingBoxTopLeftHandCorner(),
                'BoundingBoxBottomRightHandCorner' => new \PHPExiftool\Driver\Tag\DICOM\BoundingBoxBottomRightHandCorner(),
                'BoundingBoxTextHorizJustification' => new \PHPExiftool\Driver\Tag\DICOM\BoundingBoxTextHorizJustification(),
                'AnchorPoint' => new \PHPExiftool\Driver\Tag\DICOM\AnchorPoint(),
                'AnchorPointVisibility' => new \PHPExiftool\Driver\Tag\DICOM\AnchorPointVisibility(),
                'GraphicDimensions' => new \PHPExiftool\Driver\Tag\DICOM\GraphicDimensions(),
                'NumberOfGraphicPoints' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfGraphicPoints(),
                'GraphicData' => new \PHPExiftool\Driver\Tag\DICOM\GraphicData(),
                'GraphicType' => new \PHPExiftool\Driver\Tag\DICOM\GraphicType(),
                'GraphicFilled' => new \PHPExiftool\Driver\Tag\DICOM\GraphicFilled(),
                'ImageRotationRetired' => new \PHPExiftool\Driver\Tag\DICOM\ImageRotationRetired(),
                'ImageHorizontalFlip' => new \PHPExiftool\Driver\Tag\DICOM\ImageHorizontalFlip(),
                'ImageRotation' => new \PHPExiftool\Driver\Tag\DICOM\ImageRotation(),
                'DisplayedAreaTopLeftTrial' => new \PHPExiftool\Driver\Tag\DICOM\DisplayedAreaTopLeftTrial(),
                'DisplayedAreaBottomRightTrial' => new \PHPExiftool\Driver\Tag\DICOM\DisplayedAreaBottomRightTrial(),
                'DisplayedAreaTopLeft' => new \PHPExiftool\Driver\Tag\DICOM\DisplayedAreaTopLeft(),
                'DisplayedAreaBottomRight' => new \PHPExiftool\Driver\Tag\DICOM\DisplayedAreaBottomRight(),
                'DisplayedAreaSelectionSequence' => new \PHPExiftool\Driver\Tag\DICOM\DisplayedAreaSelectionSequence(),
                'GraphicLayerSequence' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayerSequence(),
                'GraphicLayerOrder' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayerOrder(),
                'GraphicLayerRecDisplayGraysclValue' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayerRecDisplayGraysclValue(),
                'GraphicLayerRecDisplayRGBValue' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayerRecDisplayRGBValue(),
                'GraphicLayerDescription' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayerDescription(),
                'ContentLabel' => new \PHPExiftool\Driver\Tag\DICOM\ContentLabel(),
                'ContentDescription' => new \PHPExiftool\Driver\Tag\DICOM\ContentDescription(),
                'PresentationCreationDate' => new \PHPExiftool\Driver\Tag\DICOM\PresentationCreationDate(),
                'PresentationCreationTime' => new \PHPExiftool\Driver\Tag\DICOM\PresentationCreationTime(),
                'ContentCreatorName' => new \PHPExiftool\Driver\Tag\DICOM\ContentCreatorName(),
                'ContentCreatorIDCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContentCreatorIDCodeSequence(),
                'PresentationSizeMode' => new \PHPExiftool\Driver\Tag\DICOM\PresentationSizeMode(),
                'PresentationPixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\PresentationPixelSpacing(),
                'PresentationPixelAspectRatio' => new \PHPExiftool\Driver\Tag\DICOM\PresentationPixelAspectRatio(),
                'PresentationPixelMagRatio' => new \PHPExiftool\Driver\Tag\DICOM\PresentationPixelMagRatio(),
                'ShapeType' => new \PHPExiftool\Driver\Tag\DICOM\ShapeType(),
                'RegistrationSequence' => new \PHPExiftool\Driver\Tag\DICOM\RegistrationSequence(),
                'MatrixRegistrationSequence' => new \PHPExiftool\Driver\Tag\DICOM\MatrixRegistrationSequence(),
                'MatrixSequence' => new \PHPExiftool\Driver\Tag\DICOM\MatrixSequence(),
                'FrameOfRefTransformationMatrixType' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfRefTransformationMatrixType(),
                'RegistrationTypeCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RegistrationTypeCodeSequence(),
                'FiducialDescription' => new \PHPExiftool\Driver\Tag\DICOM\FiducialDescription(),
                'FiducialIdentifier' => new \PHPExiftool\Driver\Tag\DICOM\FiducialIdentifier(),
                'FiducialIdentifierCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\FiducialIdentifierCodeSequence(),
                'ContourUncertaintyRadius' => new \PHPExiftool\Driver\Tag\DICOM\ContourUncertaintyRadius(),
                'UsedFiducialsSequence' => new \PHPExiftool\Driver\Tag\DICOM\UsedFiducialsSequence(),
                'GraphicCoordinatesDataSequence' => new \PHPExiftool\Driver\Tag\DICOM\GraphicCoordinatesDataSequence(),
                'FiducialUID' => new \PHPExiftool\Driver\Tag\DICOM\FiducialUID(),
                'FiducialSetSequence' => new \PHPExiftool\Driver\Tag\DICOM\FiducialSetSequence(),
                'FiducialSequence' => new \PHPExiftool\Driver\Tag\DICOM\FiducialSequence(),
                'GraphicLayerRecomDisplayCIELabVal' => new \PHPExiftool\Driver\Tag\DICOM\GraphicLayerRecomDisplayCIELabVal(),
                'BlendingSequence' => new \PHPExiftool\Driver\Tag\DICOM\BlendingSequence(),
                'RelativeOpacity' => new \PHPExiftool\Driver\Tag\DICOM\RelativeOpacity(),
                'ReferencedSpatialRegistrationSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSpatialRegistrationSeq(),
                'BlendingPosition' => new \PHPExiftool\Driver\Tag\DICOM\BlendingPosition(),
                'HangingProtocolName' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolName(),
                'HangingProtocolDescription' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolDescription(),
                'HangingProtocolLevel' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolLevel(),
                'HangingProtocolCreator' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolCreator(),
                'HangingProtocolCreationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolCreationDateTime(),
                'HangingProtocolDefinitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolDefinitionSequence(),
                'HangingProtocolUserIDCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolUserIDCodeSequence(),
                'HangingProtocolUserGroupName' => new \PHPExiftool\Driver\Tag\DICOM\HangingProtocolUserGroupName(),
                'SourceHangingProtocolSequence' => new \PHPExiftool\Driver\Tag\DICOM\SourceHangingProtocolSequence(),
                'NumberOfPriorsReferenced' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPriorsReferenced(),
                'ImageSetsSequence' => new \PHPExiftool\Driver\Tag\DICOM\ImageSetsSequence(),
                'ImageSetSelectorSequence' => new \PHPExiftool\Driver\Tag\DICOM\ImageSetSelectorSequence(),
                'ImageSetSelectorUsageFlag' => new \PHPExiftool\Driver\Tag\DICOM\ImageSetSelectorUsageFlag(),
                'SelectorAttribute' => new \PHPExiftool\Driver\Tag\DICOM\SelectorAttribute(),
                'SelectorValueNumber' => new \PHPExiftool\Driver\Tag\DICOM\SelectorValueNumber(),
                'TimeBasedImageSetsSequence' => new \PHPExiftool\Driver\Tag\DICOM\TimeBasedImageSetsSequence(),
                'ImageSetNumber' => new \PHPExiftool\Driver\Tag\DICOM\ImageSetNumber(),
                'ImageSetSelectorCategory' => new \PHPExiftool\Driver\Tag\DICOM\ImageSetSelectorCategory(),
                'RelativeTime' => new \PHPExiftool\Driver\Tag\DICOM\RelativeTime(),
                'RelativeTimeUnits' => new \PHPExiftool\Driver\Tag\DICOM\RelativeTimeUnits(),
                'AbstractPriorValue' => new \PHPExiftool\Driver\Tag\DICOM\AbstractPriorValue(),
                'AbstractPriorCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\AbstractPriorCodeSequence(),
                'ImageSetLabel' => new \PHPExiftool\Driver\Tag\DICOM\ImageSetLabel(),
                'SelectorAttributeVR' => new \PHPExiftool\Driver\Tag\DICOM\SelectorAttributeVR(),
                'SelectorSequencePointer' => new \PHPExiftool\Driver\Tag\DICOM\SelectorSequencePointer(),
                'SelectorSeqPointerPrivateCreator' => new \PHPExiftool\Driver\Tag\DICOM\SelectorSeqPointerPrivateCreator(),
                'SelectorAttributePrivateCreator' => new \PHPExiftool\Driver\Tag\DICOM\SelectorAttributePrivateCreator(),
                'SelectorATValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorATValue(),
                'SelectorCSValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorCSValue(),
                'SelectorISValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorISValue(),
                'SelectorLOValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorLOValue(),
                'SelectorLTValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorLTValue(),
                'SelectorPNValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorPNValue(),
                'SelectorSHValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorSHValue(),
                'SelectorSTValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorSTValue(),
                'SelectorUTValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorUTValue(),
                'SelectorDSValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorDSValue(),
                'SelectorFDValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorFDValue(),
                'SelectorFLValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorFLValue(),
                'SelectorULValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorULValue(),
                'SelectorUSValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorUSValue(),
                'SelectorSLValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorSLValue(),
                'SelectorSSValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorSSValue(),
                'SelectorCodeSequenceValue' => new \PHPExiftool\Driver\Tag\DICOM\SelectorCodeSequenceValue(),
                'NumberOfScreens' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfScreens(),
                'NominalScreenDefinitionSequence' => new \PHPExiftool\Driver\Tag\DICOM\NominalScreenDefinitionSequence(),
                'NumberOfVerticalPixels' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfVerticalPixels(),
                'NumberOfHorizontalPixels' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfHorizontalPixels(),
                'DisplayEnvironmentSpatialPosition' => new \PHPExiftool\Driver\Tag\DICOM\DisplayEnvironmentSpatialPosition(),
                'ScreenMinimumGrayscaleBitDepth' => new \PHPExiftool\Driver\Tag\DICOM\ScreenMinimumGrayscaleBitDepth(),
                'ScreenMinimumColorBitDepth' => new \PHPExiftool\Driver\Tag\DICOM\ScreenMinimumColorBitDepth(),
                'ApplicationMaximumRepaintTime' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationMaximumRepaintTime(),
                'DisplaySetsSequence' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetsSequence(),
                'DisplaySetNumber' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetNumber(),
                'DisplaySetLabel' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetLabel(),
                'DisplaySetPresentationGroup' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetPresentationGroup(),
                'DisplaySetPresentationGroupDescr' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetPresentationGroupDescr(),
                'PartialDataDisplayHandling' => new \PHPExiftool\Driver\Tag\DICOM\PartialDataDisplayHandling(),
                'SynchronizedScrollingSequence' => new \PHPExiftool\Driver\Tag\DICOM\SynchronizedScrollingSequence(),
                'DisplaySetScrollingGroup' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetScrollingGroup(),
                'NavigationIndicatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\NavigationIndicatorSequence(),
                'NavigationDisplaySet' => new \PHPExiftool\Driver\Tag\DICOM\NavigationDisplaySet(),
                'ReferenceDisplaySets' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceDisplaySets(),
                'ImageBoxesSequence' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxesSequence(),
                'ImageBoxNumber' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxNumber(),
                'ImageBoxLayoutType' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxLayoutType(),
                'ImageBoxTileHorizontalDimension' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxTileHorizontalDimension(),
                'ImageBoxTileVerticalDimension' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxTileVerticalDimension(),
                'ImageBoxScrollDirection' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxScrollDirection(),
                'ImageBoxSmallScrollType' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxSmallScrollType(),
                'ImageBoxSmallScrollAmount' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxSmallScrollAmount(),
                'ImageBoxLargeScrollType' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxLargeScrollType(),
                'ImageBoxLargeScrollAmount' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxLargeScrollAmount(),
                'ImageBoxOverlapPriority' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxOverlapPriority(),
                'CineRelativeToRealTime' => new \PHPExiftool\Driver\Tag\DICOM\CineRelativeToRealTime(),
                'FilterOperationsSequence' => new \PHPExiftool\Driver\Tag\DICOM\FilterOperationsSequence(),
                'FilterByCategory' => new \PHPExiftool\Driver\Tag\DICOM\FilterByCategory(),
                'FilterByAttributePresence' => new \PHPExiftool\Driver\Tag\DICOM\FilterByAttributePresence(),
                'FilterByOperator' => new \PHPExiftool\Driver\Tag\DICOM\FilterByOperator(),
                'SynchronizedImageBoxList' => new \PHPExiftool\Driver\Tag\DICOM\SynchronizedImageBoxList(),
                'TypeOfSynchronization' => new \PHPExiftool\Driver\Tag\DICOM\TypeOfSynchronization(),
                'BlendingOperationType' => new \PHPExiftool\Driver\Tag\DICOM\BlendingOperationType(),
                'ReformattingOperationType' => new \PHPExiftool\Driver\Tag\DICOM\ReformattingOperationType(),
                'ReformattingThickness' => new \PHPExiftool\Driver\Tag\DICOM\ReformattingThickness(),
                'ReformattingInterval' => new \PHPExiftool\Driver\Tag\DICOM\ReformattingInterval(),
                'ReformattingOpInitialViewDir' => new \PHPExiftool\Driver\Tag\DICOM\ReformattingOpInitialViewDir(),
                'RenderingType3D' => new \PHPExiftool\Driver\Tag\DICOM\RenderingType3D(),
                'SortingOperationsSequence' => new \PHPExiftool\Driver\Tag\DICOM\SortingOperationsSequence(),
                'SortByCategory' => new \PHPExiftool\Driver\Tag\DICOM\SortByCategory(),
                'SortingDirection' => new \PHPExiftool\Driver\Tag\DICOM\SortingDirection(),
                'DisplaySetPatientOrientation' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetPatientOrientation(),
                'VOIType' => new \PHPExiftool\Driver\Tag\DICOM\VOIType(),
                'PseudoColorType' => new \PHPExiftool\Driver\Tag\DICOM\PseudoColorType(),
                'ShowGrayscaleInverted' => new \PHPExiftool\Driver\Tag\DICOM\ShowGrayscaleInverted(),
                'ShowImageTrueSizeFlag' => new \PHPExiftool\Driver\Tag\DICOM\ShowImageTrueSizeFlag(),
                'ShowGraphicAnnotationFlag' => new \PHPExiftool\Driver\Tag\DICOM\ShowGraphicAnnotationFlag(),
                'ShowPatientDemographicsFlag' => new \PHPExiftool\Driver\Tag\DICOM\ShowPatientDemographicsFlag(),
                'ShowAcquisitionTechniquesFlag' => new \PHPExiftool\Driver\Tag\DICOM\ShowAcquisitionTechniquesFlag(),
                'DisplaySetHorizontalJustification' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetHorizontalJustification(),
                'DisplaySetVerticalJustification' => new \PHPExiftool\Driver\Tag\DICOM\DisplaySetVerticalJustification(),
                'UnifiedProcedureStepState' => new \PHPExiftool\Driver\Tag\DICOM\UnifiedProcedureStepState(),
                'UPSProgressInformationSequence' => new \PHPExiftool\Driver\Tag\DICOM\UPSProgressInformationSequence(),
                'UnifiedProcedureStepProgress' => new \PHPExiftool\Driver\Tag\DICOM\UnifiedProcedureStepProgress(),
                'UnifiedProcedureStepProgressDescr' => new \PHPExiftool\Driver\Tag\DICOM\UnifiedProcedureStepProgressDescr(),
                'UnifiedProcedureStepComURISeq' => new \PHPExiftool\Driver\Tag\DICOM\UnifiedProcedureStepComURISeq(),
                'ContactURI' => new \PHPExiftool\Driver\Tag\DICOM\ContactURI(),
                'ContactDisplayName' => new \PHPExiftool\Driver\Tag\DICOM\ContactDisplayName(),
                'BeamTaskSequence' => new \PHPExiftool\Driver\Tag\DICOM\BeamTaskSequence(),
                'BeamTaskType' => new \PHPExiftool\Driver\Tag\DICOM\BeamTaskType(),
                'BeamOrderIndex' => new \PHPExiftool\Driver\Tag\DICOM\BeamOrderIndex(),
                'DeliveryVerificationImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\DeliveryVerificationImageSequence(),
                'VerificationImageTiming' => new \PHPExiftool\Driver\Tag\DICOM\VerificationImageTiming(),
                'DoubleExposureFlag' => new \PHPExiftool\Driver\Tag\DICOM\DoubleExposureFlag(),
                'DoubleExposureOrdering' => new \PHPExiftool\Driver\Tag\DICOM\DoubleExposureOrdering(),
                'DoubleExposureMeterset' => new \PHPExiftool\Driver\Tag\DICOM\DoubleExposureMeterset(),
                'DoubleExposureFieldDelta' => new \PHPExiftool\Driver\Tag\DICOM\DoubleExposureFieldDelta(),
                'RelatedReferenceRTImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\RelatedReferenceRTImageSequence(),
                'GeneralMachineVerificationSequence' => new \PHPExiftool\Driver\Tag\DICOM\GeneralMachineVerificationSequence(),
                'ConventionalMachineVerificationSeq' => new \PHPExiftool\Driver\Tag\DICOM\ConventionalMachineVerificationSeq(),
                'IonMachineVerificationSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonMachineVerificationSequence(),
                'FailedAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\FailedAttributesSequence(),
                'OverriddenAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\OverriddenAttributesSequence(),
                'ConventionalControlPointVerifySeq' => new \PHPExiftool\Driver\Tag\DICOM\ConventionalControlPointVerifySeq(),
                'IonControlPointVerificationSeq' => new \PHPExiftool\Driver\Tag\DICOM\IonControlPointVerificationSeq(),
                'AttributeOccurrenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\AttributeOccurrenceSequence(),
                'AttributeOccurrencePointer' => new \PHPExiftool\Driver\Tag\DICOM\AttributeOccurrencePointer(),
                'AttributeItemSelector' => new \PHPExiftool\Driver\Tag\DICOM\AttributeItemSelector(),
                'AttributeOccurrencePrivateCreator' => new \PHPExiftool\Driver\Tag\DICOM\AttributeOccurrencePrivateCreator(),
                'ScheduledProcedureStepPriority' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcedureStepPriority(),
                'WorklistLabel' => new \PHPExiftool\Driver\Tag\DICOM\WorklistLabel(),
                'ProcedureStepLabel' => new \PHPExiftool\Driver\Tag\DICOM\ProcedureStepLabel(),
                'ScheduledProcessingParametersSeq' => new \PHPExiftool\Driver\Tag\DICOM\ScheduledProcessingParametersSeq(),
                'PerformedProcessingParametersSeq' => new \PHPExiftool\Driver\Tag\DICOM\PerformedProcessingParametersSeq(),
                'UPSPerformedProcedureSequence' => new \PHPExiftool\Driver\Tag\DICOM\UPSPerformedProcedureSequence(),
                'RelatedProcedureStepSequence' => new \PHPExiftool\Driver\Tag\DICOM\RelatedProcedureStepSequence(),
                'ProcedureStepRelationshipType' => new \PHPExiftool\Driver\Tag\DICOM\ProcedureStepRelationshipType(),
                'DeletionLock' => new \PHPExiftool\Driver\Tag\DICOM\DeletionLock(),
                'ReceivingAE' => new \PHPExiftool\Driver\Tag\DICOM\ReceivingAE(),
                'RequestingAE' => new \PHPExiftool\Driver\Tag\DICOM\RequestingAE(),
                'ReasonForCancellation' => new \PHPExiftool\Driver\Tag\DICOM\ReasonForCancellation(),
                'SCPStatus' => new \PHPExiftool\Driver\Tag\DICOM\SCPStatus(),
                'SubscriptionListStatus' => new \PHPExiftool\Driver\Tag\DICOM\SubscriptionListStatus(),
                'UPSListStatus' => new \PHPExiftool\Driver\Tag\DICOM\UPSListStatus(),
                'StorageMediaFileSetID' => new \PHPExiftool\Driver\Tag\DICOM\StorageMediaFileSetID(),
                'StorageMediaFileSetUID' => new \PHPExiftool\Driver\Tag\DICOM\StorageMediaFileSetUID(),
                'IconImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\IconImageSequence(),
                'TopicTitle' => new \PHPExiftool\Driver\Tag\DICOM\TopicTitle(),
                'TopicSubject' => new \PHPExiftool\Driver\Tag\DICOM\TopicSubject(),
                'TopicAuthor' => new \PHPExiftool\Driver\Tag\DICOM\TopicAuthor(),
                'TopicKeywords' => new \PHPExiftool\Driver\Tag\DICOM\TopicKeywords(),
                'SOPInstanceStatus' => new \PHPExiftool\Driver\Tag\DICOM\SOPInstanceStatus(),
                'SOPAuthorizationDateAndTime' => new \PHPExiftool\Driver\Tag\DICOM\SOPAuthorizationDateAndTime(),
                'SOPAuthorizationComment' => new \PHPExiftool\Driver\Tag\DICOM\SOPAuthorizationComment(),
                'AuthorizationEquipmentCertNumber' => new \PHPExiftool\Driver\Tag\DICOM\AuthorizationEquipmentCertNumber(),
                'MACIDNumber' => new \PHPExiftool\Driver\Tag\DICOM\MACIDNumber(),
                'MACCalculationTransferSyntaxUID' => new \PHPExiftool\Driver\Tag\DICOM\MACCalculationTransferSyntaxUID(),
                'MACAlgorithm' => new \PHPExiftool\Driver\Tag\DICOM\MACAlgorithm(),
                'DataElementsSigned' => new \PHPExiftool\Driver\Tag\DICOM\DataElementsSigned(),
                'DigitalSignatureUID' => new \PHPExiftool\Driver\Tag\DICOM\DigitalSignatureUID(),
                'DigitalSignatureDateTime' => new \PHPExiftool\Driver\Tag\DICOM\DigitalSignatureDateTime(),
                'CertificateType' => new \PHPExiftool\Driver\Tag\DICOM\CertificateType(),
                'CertificateOfSigner' => new \PHPExiftool\Driver\Tag\DICOM\CertificateOfSigner(),
                'Signature' => new \PHPExiftool\Driver\Tag\DICOM\Signature(),
                'CertifiedTimestampType' => new \PHPExiftool\Driver\Tag\DICOM\CertifiedTimestampType(),
                'CertifiedTimestamp' => new \PHPExiftool\Driver\Tag\DICOM\CertifiedTimestamp(),
                'DigitalSignaturePurposeCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\DigitalSignaturePurposeCodeSeq(),
                'ReferencedDigitalSignatureSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedDigitalSignatureSeq(),
                'ReferencedSOPInstanceMACSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSOPInstanceMACSeq(),
                'MAC' => new \PHPExiftool\Driver\Tag\DICOM\MAC(),
                'EncryptedAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\EncryptedAttributesSequence(),
                'EncryptedContentTransferSyntaxUID' => new \PHPExiftool\Driver\Tag\DICOM\EncryptedContentTransferSyntaxUID(),
                'EncryptedContent' => new \PHPExiftool\Driver\Tag\DICOM\EncryptedContent(),
                'ModifiedAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\ModifiedAttributesSequence(),
                'OriginalAttributesSequence' => new \PHPExiftool\Driver\Tag\DICOM\OriginalAttributesSequence(),
                'AttributeModificationDateTime' => new \PHPExiftool\Driver\Tag\DICOM\AttributeModificationDateTime(),
                'ModifyingSystem' => new \PHPExiftool\Driver\Tag\DICOM\ModifyingSystem(),
                'SourceOfPreviousValues' => new \PHPExiftool\Driver\Tag\DICOM\SourceOfPreviousValues(),
                'ReasonForTheAttributeModification' => new \PHPExiftool\Driver\Tag\DICOM\ReasonForTheAttributeModification(),
                'EscapeTriplet' => new \PHPExiftool\Driver\Tag\DICOM\EscapeTriplet(),
                'RunLengthTriplet' => new \PHPExiftool\Driver\Tag\DICOM\RunLengthTriplet(),
                'HuffmanTableSize' => new \PHPExiftool\Driver\Tag\DICOM\HuffmanTableSize(),
                'HuffmanTableTriplet' => new \PHPExiftool\Driver\Tag\DICOM\HuffmanTableTriplet(),
                'ShiftTableSize' => new \PHPExiftool\Driver\Tag\DICOM\ShiftTableSize(),
                'ShiftTableTriplet' => new \PHPExiftool\Driver\Tag\DICOM\ShiftTableTriplet(),
                'ZonalMap' => new \PHPExiftool\Driver\Tag\DICOM\ZonalMap(),
                'NumberOfCopies' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfCopies(),
                'PrinterConfigurationSequence' => new \PHPExiftool\Driver\Tag\DICOM\PrinterConfigurationSequence(),
                'PrintPriority' => new \PHPExiftool\Driver\Tag\DICOM\PrintPriority(),
                'MediumType' => new \PHPExiftool\Driver\Tag\DICOM\MediumType(),
                'FilmDestination' => new \PHPExiftool\Driver\Tag\DICOM\FilmDestination(),
                'FilmSessionLabel' => new \PHPExiftool\Driver\Tag\DICOM\FilmSessionLabel(),
                'MemoryAllocation' => new \PHPExiftool\Driver\Tag\DICOM\MemoryAllocation(),
                'MaximumMemoryAllocation' => new \PHPExiftool\Driver\Tag\DICOM\MaximumMemoryAllocation(),
                'ColorImagePrintingFlag' => new \PHPExiftool\Driver\Tag\DICOM\ColorImagePrintingFlag(),
                'CollationFlag' => new \PHPExiftool\Driver\Tag\DICOM\CollationFlag(),
                'AnnotationFlag' => new \PHPExiftool\Driver\Tag\DICOM\AnnotationFlag(),
                'ImageOverlayFlag' => new \PHPExiftool\Driver\Tag\DICOM\ImageOverlayFlag(),
                'PresentationLUTFlag' => new \PHPExiftool\Driver\Tag\DICOM\PresentationLUTFlag(),
                'ImageBoxPresentationLUTFlag' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxPresentationLUTFlag(),
                'MemoryBitDepth' => new \PHPExiftool\Driver\Tag\DICOM\MemoryBitDepth(),
                'PrintingBitDepth' => new \PHPExiftool\Driver\Tag\DICOM\PrintingBitDepth(),
                'MediaInstalledSequence' => new \PHPExiftool\Driver\Tag\DICOM\MediaInstalledSequence(),
                'OtherMediaAvailableSequence' => new \PHPExiftool\Driver\Tag\DICOM\OtherMediaAvailableSequence(),
                'SupportedImageDisplayFormatSeq' => new \PHPExiftool\Driver\Tag\DICOM\SupportedImageDisplayFormatSeq(),
                'ReferencedFilmBoxSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFilmBoxSequence(),
                'ReferencedStoredPrintSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedStoredPrintSequence(),
                'ImageDisplayFormat' => new \PHPExiftool\Driver\Tag\DICOM\ImageDisplayFormat(),
                'AnnotationDisplayFormatID' => new \PHPExiftool\Driver\Tag\DICOM\AnnotationDisplayFormatID(),
                'FilmOrientation' => new \PHPExiftool\Driver\Tag\DICOM\FilmOrientation(),
                'FilmSizeID' => new \PHPExiftool\Driver\Tag\DICOM\FilmSizeID(),
                'PrinterResolutionID' => new \PHPExiftool\Driver\Tag\DICOM\PrinterResolutionID(),
                'DefaultPrinterResolutionID' => new \PHPExiftool\Driver\Tag\DICOM\DefaultPrinterResolutionID(),
                'MagnificationType' => new \PHPExiftool\Driver\Tag\DICOM\MagnificationType(),
                'SmoothingType' => new \PHPExiftool\Driver\Tag\DICOM\SmoothingType(),
                'DefaultMagnificationType' => new \PHPExiftool\Driver\Tag\DICOM\DefaultMagnificationType(),
                'OtherMagnificationTypesAvailable' => new \PHPExiftool\Driver\Tag\DICOM\OtherMagnificationTypesAvailable(),
                'DefaultSmoothingType' => new \PHPExiftool\Driver\Tag\DICOM\DefaultSmoothingType(),
                'OtherSmoothingTypesAvailable' => new \PHPExiftool\Driver\Tag\DICOM\OtherSmoothingTypesAvailable(),
                'BorderDensity' => new \PHPExiftool\Driver\Tag\DICOM\BorderDensity(),
                'EmptyImageDensity' => new \PHPExiftool\Driver\Tag\DICOM\EmptyImageDensity(),
                'MinDensity' => new \PHPExiftool\Driver\Tag\DICOM\MinDensity(),
                'MaxDensity' => new \PHPExiftool\Driver\Tag\DICOM\MaxDensity(),
                'Trim' => new \PHPExiftool\Driver\Tag\DICOM\Trim(),
                'ConfigurationInformation' => new \PHPExiftool\Driver\Tag\DICOM\ConfigurationInformation(),
                'ConfigurationInformationDescr' => new \PHPExiftool\Driver\Tag\DICOM\ConfigurationInformationDescr(),
                'MaximumCollatedFilms' => new \PHPExiftool\Driver\Tag\DICOM\MaximumCollatedFilms(),
                'Illumination' => new \PHPExiftool\Driver\Tag\DICOM\Illumination(),
                'ReflectedAmbientLight' => new \PHPExiftool\Driver\Tag\DICOM\ReflectedAmbientLight(),
                'PrinterPixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\PrinterPixelSpacing(),
                'ReferencedFilmSessionSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFilmSessionSequence(),
                'ReferencedImageBoxSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedImageBoxSequence(),
                'ReferencedBasicAnnotationBoxSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBasicAnnotationBoxSeq(),
                'ImageBoxPosition' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxPosition(),
                'Polarity' => new \PHPExiftool\Driver\Tag\DICOM\Polarity(),
                'RequestedImageSize' => new \PHPExiftool\Driver\Tag\DICOM\RequestedImageSize(),
                'RequestedDecimate-CropBehavior' => new \PHPExiftool\Driver\Tag\DICOM\RequestedDecimateCropBehavior(),
                'RequestedResolutionID' => new \PHPExiftool\Driver\Tag\DICOM\RequestedResolutionID(),
                'RequestedImageSizeFlag' => new \PHPExiftool\Driver\Tag\DICOM\RequestedImageSizeFlag(),
                'DecimateCropResult' => new \PHPExiftool\Driver\Tag\DICOM\DecimateCropResult(),
                'BasicGrayscaleImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\BasicGrayscaleImageSequence(),
                'BasicColorImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\BasicColorImageSequence(),
                'ReferencedImageOverlayBoxSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedImageOverlayBoxSequence(),
                'ReferencedVOILUTBoxSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedVOILUTBoxSequence(),
                'AnnotationPosition' => new \PHPExiftool\Driver\Tag\DICOM\AnnotationPosition(),
                'TextString' => new \PHPExiftool\Driver\Tag\DICOM\TextString(),
                'ReferencedOverlayPlaneSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedOverlayPlaneSequence(),
                'ReferencedOverlayPlaneGroups' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedOverlayPlaneGroups(),
                'OverlayPixelDataSequence' => new \PHPExiftool\Driver\Tag\DICOM\OverlayPixelDataSequence(),
                'OverlayMagnificationType' => new \PHPExiftool\Driver\Tag\DICOM\OverlayMagnificationType(),
                'OverlaySmoothingType' => new \PHPExiftool\Driver\Tag\DICOM\OverlaySmoothingType(),
                'OverlayOrImageMagnification' => new \PHPExiftool\Driver\Tag\DICOM\OverlayOrImageMagnification(),
                'MagnifyToNumberOfColumns' => new \PHPExiftool\Driver\Tag\DICOM\MagnifyToNumberOfColumns(),
                'OverlayForegroundDensity' => new \PHPExiftool\Driver\Tag\DICOM\OverlayForegroundDensity(),
                'OverlayBackgroundDensity' => new \PHPExiftool\Driver\Tag\DICOM\OverlayBackgroundDensity(),
                'OverlayMode' => new \PHPExiftool\Driver\Tag\DICOM\OverlayMode(),
                'ThresholdDensity' => new \PHPExiftool\Driver\Tag\DICOM\ThresholdDensity(),
                'PresentationLUTSequence' => new \PHPExiftool\Driver\Tag\DICOM\PresentationLUTSequence(),
                'PresentationLUTShape' => new \PHPExiftool\Driver\Tag\DICOM\PresentationLUTShape(),
                'ReferencedPresentationLUTSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedPresentationLUTSequence(),
                'PrintJobID' => new \PHPExiftool\Driver\Tag\DICOM\PrintJobID(),
                'ExecutionStatus' => new \PHPExiftool\Driver\Tag\DICOM\ExecutionStatus(),
                'ExecutionStatusInfo' => new \PHPExiftool\Driver\Tag\DICOM\ExecutionStatusInfo(),
                'CreationDate' => new \PHPExiftool\Driver\Tag\DICOM\CreationDate(),
                'CreationTime' => new \PHPExiftool\Driver\Tag\DICOM\CreationTime(),
                'Originator' => new \PHPExiftool\Driver\Tag\DICOM\Originator(),
                'DestinationAE' => new \PHPExiftool\Driver\Tag\DICOM\DestinationAE(),
                'OwnerID' => new \PHPExiftool\Driver\Tag\DICOM\OwnerID(),
                'NumberOfFilms' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFilms(),
                'ReferencedPrintJobSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedPrintJobSequence(),
                'PrinterStatus' => new \PHPExiftool\Driver\Tag\DICOM\PrinterStatus(),
                'PrinterStatusInfo' => new \PHPExiftool\Driver\Tag\DICOM\PrinterStatusInfo(),
                'PrinterName' => new \PHPExiftool\Driver\Tag\DICOM\PrinterName(),
                'PrintQueueID' => new \PHPExiftool\Driver\Tag\DICOM\PrintQueueID(),
                'QueueStatus' => new \PHPExiftool\Driver\Tag\DICOM\QueueStatus(),
                'PrintJobDescriptionSequence' => new \PHPExiftool\Driver\Tag\DICOM\PrintJobDescriptionSequence(),
                'PrintManagementCapabilitiesSeq' => new \PHPExiftool\Driver\Tag\DICOM\PrintManagementCapabilitiesSeq(),
                'PrinterCharacteristicsSequence' => new \PHPExiftool\Driver\Tag\DICOM\PrinterCharacteristicsSequence(),
                'FilmBoxContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\FilmBoxContentSequence(),
                'ImageBoxContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\ImageBoxContentSequence(),
                'AnnotationContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\AnnotationContentSequence(),
                'ImageOverlayBoxContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\ImageOverlayBoxContentSequence(),
                'PresentationLUTContentSequence' => new \PHPExiftool\Driver\Tag\DICOM\PresentationLUTContentSequence(),
                'ProposedStudySequence' => new \PHPExiftool\Driver\Tag\DICOM\ProposedStudySequence(),
                'OriginalImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\OriginalImageSequence(),
                'LabelFromInfoExtractedFromInstance' => new \PHPExiftool\Driver\Tag\DICOM\LabelFromInfoExtractedFromInstance(),
                'LabelText' => new \PHPExiftool\Driver\Tag\DICOM\LabelText(),
                'LabelStyleSelection' => new \PHPExiftool\Driver\Tag\DICOM\LabelStyleSelection(),
                'MediaDisposition' => new \PHPExiftool\Driver\Tag\DICOM\MediaDisposition(),
                'BarcodeValue' => new \PHPExiftool\Driver\Tag\DICOM\BarcodeValue(),
                'BarcodeSymbology' => new \PHPExiftool\Driver\Tag\DICOM\BarcodeSymbology(),
                'AllowMediaSplitting' => new \PHPExiftool\Driver\Tag\DICOM\AllowMediaSplitting(),
                'IncludeNonDICOMObjects' => new \PHPExiftool\Driver\Tag\DICOM\IncludeNonDICOMObjects(),
                'IncludeDisplayApplication' => new \PHPExiftool\Driver\Tag\DICOM\IncludeDisplayApplication(),
                'SaveCompInstancesAfterMediaCreate' => new \PHPExiftool\Driver\Tag\DICOM\SaveCompInstancesAfterMediaCreate(),
                'TotalNumberMediaPiecesCreated' => new \PHPExiftool\Driver\Tag\DICOM\TotalNumberMediaPiecesCreated(),
                'RequestedMediaApplicationProfile' => new \PHPExiftool\Driver\Tag\DICOM\RequestedMediaApplicationProfile(),
                'ReferencedStorageMediaSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedStorageMediaSequence(),
                'FailureAttributes' => new \PHPExiftool\Driver\Tag\DICOM\FailureAttributes(),
                'AllowLossyCompression' => new \PHPExiftool\Driver\Tag\DICOM\AllowLossyCompression(),
                'RequestPriority' => new \PHPExiftool\Driver\Tag\DICOM\RequestPriority(),
                'RTImageLabel' => new \PHPExiftool\Driver\Tag\DICOM\RTImageLabel(),
                'RTImageName' => new \PHPExiftool\Driver\Tag\DICOM\RTImageName(),
                'RTImageDescription' => new \PHPExiftool\Driver\Tag\DICOM\RTImageDescription(),
                'ReportedValuesOrigin' => new \PHPExiftool\Driver\Tag\DICOM\ReportedValuesOrigin(),
                'RTImagePlane' => new \PHPExiftool\Driver\Tag\DICOM\RTImagePlane(),
                'XRayImageReceptorTranslation' => new \PHPExiftool\Driver\Tag\DICOM\XRayImageReceptorTranslation(),
                'XRayImageReceptorAngle' => new \PHPExiftool\Driver\Tag\DICOM\XRayImageReceptorAngle(),
                'RTImageOrientation' => new \PHPExiftool\Driver\Tag\DICOM\RTImageOrientation(),
                'ImagePlanePixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\ImagePlanePixelSpacing(),
                'RTImagePosition' => new \PHPExiftool\Driver\Tag\DICOM\RTImagePosition(),
                'RadiationMachineName' => new \PHPExiftool\Driver\Tag\DICOM\RadiationMachineName(),
                'RadiationMachineSAD' => new \PHPExiftool\Driver\Tag\DICOM\RadiationMachineSAD(),
                'RadiationMachineSSD' => new \PHPExiftool\Driver\Tag\DICOM\RadiationMachineSSD(),
                'RTImageSID' => new \PHPExiftool\Driver\Tag\DICOM\RTImageSID(),
                'SourceToReferenceObjectDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToReferenceObjectDistance(),
                'FractionNumber' => new \PHPExiftool\Driver\Tag\DICOM\FractionNumber(),
                'ExposureSequence' => new \PHPExiftool\Driver\Tag\DICOM\ExposureSequence(),
                'MetersetExposure' => new \PHPExiftool\Driver\Tag\DICOM\MetersetExposure(),
                'DiaphragmPosition' => new \PHPExiftool\Driver\Tag\DICOM\DiaphragmPosition(),
                'FluenceMapSequence' => new \PHPExiftool\Driver\Tag\DICOM\FluenceMapSequence(),
                'FluenceDataSource' => new \PHPExiftool\Driver\Tag\DICOM\FluenceDataSource(),
                'FluenceDataScale' => new \PHPExiftool\Driver\Tag\DICOM\FluenceDataScale(),
                'FluenceMode' => new \PHPExiftool\Driver\Tag\DICOM\FluenceMode(),
                'FluenceModeID' => new \PHPExiftool\Driver\Tag\DICOM\FluenceModeID(),
                'DVHType' => new \PHPExiftool\Driver\Tag\DICOM\DVHType(),
                'DoseUnits' => new \PHPExiftool\Driver\Tag\DICOM\DoseUnits(),
                'DoseType' => new \PHPExiftool\Driver\Tag\DICOM\DoseType(),
                'DoseComment' => new \PHPExiftool\Driver\Tag\DICOM\DoseComment(),
                'NormalizationPoint' => new \PHPExiftool\Driver\Tag\DICOM\NormalizationPoint(),
                'DoseSummationType' => new \PHPExiftool\Driver\Tag\DICOM\DoseSummationType(),
                'GridFrameOffsetVector' => new \PHPExiftool\Driver\Tag\DICOM\GridFrameOffsetVector(),
                'DoseGridScaling' => new \PHPExiftool\Driver\Tag\DICOM\DoseGridScaling(),
                'RTDoseROISequence' => new \PHPExiftool\Driver\Tag\DICOM\RTDoseROISequence(),
                'DoseValue' => new \PHPExiftool\Driver\Tag\DICOM\DoseValue(),
                'TissueHeterogeneityCorrection' => new \PHPExiftool\Driver\Tag\DICOM\TissueHeterogeneityCorrection(),
                'DVHNormalizationPoint' => new \PHPExiftool\Driver\Tag\DICOM\DVHNormalizationPoint(),
                'DVHNormalizationDoseValue' => new \PHPExiftool\Driver\Tag\DICOM\DVHNormalizationDoseValue(),
                'DVHSequence' => new \PHPExiftool\Driver\Tag\DICOM\DVHSequence(),
                'DVHDoseScaling' => new \PHPExiftool\Driver\Tag\DICOM\DVHDoseScaling(),
                'DVHVolumeUnits' => new \PHPExiftool\Driver\Tag\DICOM\DVHVolumeUnits(),
                'DVHNumberOfBins' => new \PHPExiftool\Driver\Tag\DICOM\DVHNumberOfBins(),
                'DVHData' => new \PHPExiftool\Driver\Tag\DICOM\DVHData(),
                'DVHReferencedROISequence' => new \PHPExiftool\Driver\Tag\DICOM\DVHReferencedROISequence(),
                'DVHROIContributionType' => new \PHPExiftool\Driver\Tag\DICOM\DVHROIContributionType(),
                'DVHMinimumDose' => new \PHPExiftool\Driver\Tag\DICOM\DVHMinimumDose(),
                'DVHMaximumDose' => new \PHPExiftool\Driver\Tag\DICOM\DVHMaximumDose(),
                'DVHMeanDose' => new \PHPExiftool\Driver\Tag\DICOM\DVHMeanDose(),
                'StructureSetLabel' => new \PHPExiftool\Driver\Tag\DICOM\StructureSetLabel(),
                'StructureSetName' => new \PHPExiftool\Driver\Tag\DICOM\StructureSetName(),
                'StructureSetDescription' => new \PHPExiftool\Driver\Tag\DICOM\StructureSetDescription(),
                'StructureSetDate' => new \PHPExiftool\Driver\Tag\DICOM\StructureSetDate(),
                'StructureSetTime' => new \PHPExiftool\Driver\Tag\DICOM\StructureSetTime(),
                'ReferencedFrameOfReferenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFrameOfReferenceSequence(),
                'RTReferencedStudySequence' => new \PHPExiftool\Driver\Tag\DICOM\RTReferencedStudySequence(),
                'RTReferencedSeriesSequence' => new \PHPExiftool\Driver\Tag\DICOM\RTReferencedSeriesSequence(),
                'ContourImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContourImageSequence(),
                'StructureSetROISequence' => new \PHPExiftool\Driver\Tag\DICOM\StructureSetROISequence(),
                'ROINumber' => new \PHPExiftool\Driver\Tag\DICOM\ROINumber(),
                'ReferencedFrameOfReferenceUID' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFrameOfReferenceUID(),
                'ROIName' => new \PHPExiftool\Driver\Tag\DICOM\ROIName(),
                'ROIDescription' => new \PHPExiftool\Driver\Tag\DICOM\ROIDescription(),
                'ROIDisplayColor' => new \PHPExiftool\Driver\Tag\DICOM\ROIDisplayColor(),
                'ROIVolume' => new \PHPExiftool\Driver\Tag\DICOM\ROIVolume(),
                'RTRelatedROISequence' => new \PHPExiftool\Driver\Tag\DICOM\RTRelatedROISequence(),
                'RTROIRelationship' => new \PHPExiftool\Driver\Tag\DICOM\RTROIRelationship(),
                'ROIGenerationAlgorithm' => new \PHPExiftool\Driver\Tag\DICOM\ROIGenerationAlgorithm(),
                'ROIGenerationDescription' => new \PHPExiftool\Driver\Tag\DICOM\ROIGenerationDescription(),
                'ROIContourSequence' => new \PHPExiftool\Driver\Tag\DICOM\ROIContourSequence(),
                'ContourSequence' => new \PHPExiftool\Driver\Tag\DICOM\ContourSequence(),
                'ContourGeometricType' => new \PHPExiftool\Driver\Tag\DICOM\ContourGeometricType(),
                'ContourSlabThickness' => new \PHPExiftool\Driver\Tag\DICOM\ContourSlabThickness(),
                'ContourOffsetVector' => new \PHPExiftool\Driver\Tag\DICOM\ContourOffsetVector(),
                'NumberOfContourPoints' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfContourPoints(),
                'ContourNumber' => new \PHPExiftool\Driver\Tag\DICOM\ContourNumber(),
                'AttachedContours' => new \PHPExiftool\Driver\Tag\DICOM\AttachedContours(),
                'ContourData' => new \PHPExiftool\Driver\Tag\DICOM\ContourData(),
                'RTROIObservationsSequence' => new \PHPExiftool\Driver\Tag\DICOM\RTROIObservationsSequence(),
                'ObservationNumber' => new \PHPExiftool\Driver\Tag\DICOM\ObservationNumber(),
                'ReferencedROINumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedROINumber(),
                'ROIObservationLabel' => new \PHPExiftool\Driver\Tag\DICOM\ROIObservationLabel(),
                'RTROIIdentificationCodeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RTROIIdentificationCodeSequence(),
                'ROIObservationDescription' => new \PHPExiftool\Driver\Tag\DICOM\ROIObservationDescription(),
                'RelatedRTROIObservationsSequence' => new \PHPExiftool\Driver\Tag\DICOM\RelatedRTROIObservationsSequence(),
                'RTROIInterpretedType' => new \PHPExiftool\Driver\Tag\DICOM\RTROIInterpretedType(),
                'ROIInterpreter' => new \PHPExiftool\Driver\Tag\DICOM\ROIInterpreter(),
                'ROIPhysicalPropertiesSequence' => new \PHPExiftool\Driver\Tag\DICOM\ROIPhysicalPropertiesSequence(),
                'ROIPhysicalProperty' => new \PHPExiftool\Driver\Tag\DICOM\ROIPhysicalProperty(),
                'ROIPhysicalPropertyValue' => new \PHPExiftool\Driver\Tag\DICOM\ROIPhysicalPropertyValue(),
                'ROIElementalCompositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\ROIElementalCompositionSequence(),
                'ROIElementalCompAtomicNumber' => new \PHPExiftool\Driver\Tag\DICOM\ROIElementalCompAtomicNumber(),
                'ROIElementalCompAtomicMassFraction' => new \PHPExiftool\Driver\Tag\DICOM\ROIElementalCompAtomicMassFraction(),
                'FrameOfReferenceRelationshipSeq' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfReferenceRelationshipSeq(),
                'RelatedFrameOfReferenceUID' => new \PHPExiftool\Driver\Tag\DICOM\RelatedFrameOfReferenceUID(),
                'FrameOfReferenceTransformType' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfReferenceTransformType(),
                'FrameOfReferenceTransformMatrix' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfReferenceTransformMatrix(),
                'FrameOfReferenceTransformComment' => new \PHPExiftool\Driver\Tag\DICOM\FrameOfReferenceTransformComment(),
                'MeasuredDoseReferenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\MeasuredDoseReferenceSequence(),
                'MeasuredDoseDescription' => new \PHPExiftool\Driver\Tag\DICOM\MeasuredDoseDescription(),
                'MeasuredDoseType' => new \PHPExiftool\Driver\Tag\DICOM\MeasuredDoseType(),
                'MeasuredDoseValue' => new \PHPExiftool\Driver\Tag\DICOM\MeasuredDoseValue(),
                'TreatmentSessionBeamSequence' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentSessionBeamSequence(),
                'TreatmentSessionIonBeamSequence' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentSessionIonBeamSequence(),
                'CurrentFractionNumber' => new \PHPExiftool\Driver\Tag\DICOM\CurrentFractionNumber(),
                'TreatmentControlPointDate' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentControlPointDate(),
                'TreatmentControlPointTime' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentControlPointTime(),
                'TreatmentTerminationStatus' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentTerminationStatus(),
                'TreatmentTerminationCode' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentTerminationCode(),
                'TreatmentVerificationStatus' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentVerificationStatus(),
                'ReferencedTreatmentRecordSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedTreatmentRecordSequence(),
                'SpecifiedPrimaryMeterset' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedPrimaryMeterset(),
                'SpecifiedSecondaryMeterset' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedSecondaryMeterset(),
                'DeliveredPrimaryMeterset' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredPrimaryMeterset(),
                'DeliveredSecondaryMeterset' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredSecondaryMeterset(),
                'SpecifiedTreatmentTime' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedTreatmentTime(),
                'DeliveredTreatmentTime' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredTreatmentTime(),
                'ControlPointDeliverySequence' => new \PHPExiftool\Driver\Tag\DICOM\ControlPointDeliverySequence(),
                'IonControlPointDeliverySequence' => new \PHPExiftool\Driver\Tag\DICOM\IonControlPointDeliverySequence(),
                'SpecifiedMeterset' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedMeterset(),
                'DeliveredMeterset' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredMeterset(),
                'MetersetRateSet' => new \PHPExiftool\Driver\Tag\DICOM\MetersetRateSet(),
                'MetersetRateDelivered' => new \PHPExiftool\Driver\Tag\DICOM\MetersetRateDelivered(),
                'ScanSpotMetersetsDelivered' => new \PHPExiftool\Driver\Tag\DICOM\ScanSpotMetersetsDelivered(),
                'DoseRateDelivered' => new \PHPExiftool\Driver\Tag\DICOM\DoseRateDelivered(),
                'TreatmentSummaryCalcDoseRefSeq' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentSummaryCalcDoseRefSeq(),
                'CumulativeDoseToDoseReference' => new \PHPExiftool\Driver\Tag\DICOM\CumulativeDoseToDoseReference(),
                'FirstTreatmentDate' => new \PHPExiftool\Driver\Tag\DICOM\FirstTreatmentDate(),
                'MostRecentTreatmentDate' => new \PHPExiftool\Driver\Tag\DICOM\MostRecentTreatmentDate(),
                'NumberOfFractionsDelivered' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFractionsDelivered(),
                'OverrideSequence' => new \PHPExiftool\Driver\Tag\DICOM\OverrideSequence(),
                'ParameterSequencePointer' => new \PHPExiftool\Driver\Tag\DICOM\ParameterSequencePointer(),
                'OverrideParameterPointer' => new \PHPExiftool\Driver\Tag\DICOM\OverrideParameterPointer(),
                'ParameterItemIndex' => new \PHPExiftool\Driver\Tag\DICOM\ParameterItemIndex(),
                'MeasuredDoseReferenceNumber' => new \PHPExiftool\Driver\Tag\DICOM\MeasuredDoseReferenceNumber(),
                'ParameterPointer' => new \PHPExiftool\Driver\Tag\DICOM\ParameterPointer(),
                'OverrideReason' => new \PHPExiftool\Driver\Tag\DICOM\OverrideReason(),
                'CorrectedParameterSequence' => new \PHPExiftool\Driver\Tag\DICOM\CorrectedParameterSequence(),
                'CorrectionValue' => new \PHPExiftool\Driver\Tag\DICOM\CorrectionValue(),
                'CalculatedDoseReferenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\CalculatedDoseReferenceSequence(),
                'CalculatedDoseReferenceNumber' => new \PHPExiftool\Driver\Tag\DICOM\CalculatedDoseReferenceNumber(),
                'CalculatedDoseReferenceDescription' => new \PHPExiftool\Driver\Tag\DICOM\CalculatedDoseReferenceDescription(),
                'CalculatedDoseReferenceDoseValue' => new \PHPExiftool\Driver\Tag\DICOM\CalculatedDoseReferenceDoseValue(),
                'StartMeterset' => new \PHPExiftool\Driver\Tag\DICOM\StartMeterset(),
                'EndMeterset' => new \PHPExiftool\Driver\Tag\DICOM\EndMeterset(),
                'ReferencedMeasuredDoseReferenceSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedMeasuredDoseReferenceSeq(),
                'ReferencedMeasuredDoseReferenceNum' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedMeasuredDoseReferenceNum(),
                'ReferencedCalculatedDoseRefSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedCalculatedDoseRefSeq(),
                'ReferencedCalculatedDoseRefNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedCalculatedDoseRefNumber(),
                'BeamLimitingDeviceLeafPairsSeq' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDeviceLeafPairsSeq(),
                'RecordedWedgeSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedWedgeSequence(),
                'RecordedCompensatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedCompensatorSequence(),
                'RecordedBlockSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedBlockSequence(),
                'TreatmentSummaryMeasuredDoseRefSeq' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentSummaryMeasuredDoseRefSeq(),
                'RecordedSnoutSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedSnoutSequence(),
                'RecordedRangeShifterSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedRangeShifterSequence(),
                'RecordedLateralSpreadingDeviceSeq' => new \PHPExiftool\Driver\Tag\DICOM\RecordedLateralSpreadingDeviceSeq(),
                'RecordedRangeModulatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedRangeModulatorSequence(),
                'RecordedSourceSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedSourceSequence(),
                'SourceSerialNumber' => new \PHPExiftool\Driver\Tag\DICOM\SourceSerialNumber(),
                'TreatmentSessionAppSetupSeq' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentSessionAppSetupSeq(),
                'ApplicationSetupCheck' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationSetupCheck(),
                'RecordedBrachyAccessoryDeviceSeq' => new \PHPExiftool\Driver\Tag\DICOM\RecordedBrachyAccessoryDeviceSeq(),
                'ReferencedBrachyAccessoryDeviceNum' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBrachyAccessoryDeviceNum(),
                'RecordedChannelSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedChannelSequence(),
                'SpecifiedChannelTotalTime' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedChannelTotalTime(),
                'DeliveredChannelTotalTime' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredChannelTotalTime(),
                'SpecifiedNumberOfPulses' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedNumberOfPulses(),
                'DeliveredNumberOfPulses' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredNumberOfPulses(),
                'SpecifiedPulseRepetitionInterval' => new \PHPExiftool\Driver\Tag\DICOM\SpecifiedPulseRepetitionInterval(),
                'DeliveredPulseRepetitionInterval' => new \PHPExiftool\Driver\Tag\DICOM\DeliveredPulseRepetitionInterval(),
                'RecordedSourceApplicatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedSourceApplicatorSequence(),
                'ReferencedSourceApplicatorNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSourceApplicatorNumber(),
                'RecordedChannelShieldSequence' => new \PHPExiftool\Driver\Tag\DICOM\RecordedChannelShieldSequence(),
                'ReferencedChannelShieldNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedChannelShieldNumber(),
                'BrachyControlPointDeliveredSeq' => new \PHPExiftool\Driver\Tag\DICOM\BrachyControlPointDeliveredSeq(),
                'SafePositionExitDate' => new \PHPExiftool\Driver\Tag\DICOM\SafePositionExitDate(),
                'SafePositionExitTime' => new \PHPExiftool\Driver\Tag\DICOM\SafePositionExitTime(),
                'SafePositionReturnDate' => new \PHPExiftool\Driver\Tag\DICOM\SafePositionReturnDate(),
                'SafePositionReturnTime' => new \PHPExiftool\Driver\Tag\DICOM\SafePositionReturnTime(),
                'CurrentTreatmentStatus' => new \PHPExiftool\Driver\Tag\DICOM\CurrentTreatmentStatus(),
                'TreatmentStatusComment' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentStatusComment(),
                'FractionGroupSummarySequence' => new \PHPExiftool\Driver\Tag\DICOM\FractionGroupSummarySequence(),
                'ReferencedFractionNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFractionNumber(),
                'FractionGroupType' => new \PHPExiftool\Driver\Tag\DICOM\FractionGroupType(),
                'BeamStopperPosition' => new \PHPExiftool\Driver\Tag\DICOM\BeamStopperPosition(),
                'FractionStatusSummarySequence' => new \PHPExiftool\Driver\Tag\DICOM\FractionStatusSummarySequence(),
                'TreatmentDate' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentDate(),
                'TreatmentTime' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentTime(),
                'RTPlanLabel' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanLabel(),
                'RTPlanName' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanName(),
                'RTPlanDescription' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanDescription(),
                'RTPlanDate' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanDate(),
                'RTPlanTime' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanTime(),
                'TreatmentProtocols' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentProtocols(),
                'PlanIntent' => new \PHPExiftool\Driver\Tag\DICOM\PlanIntent(),
                'TreatmentSites' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentSites(),
                'RTPlanGeometry' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanGeometry(),
                'PrescriptionDescription' => new \PHPExiftool\Driver\Tag\DICOM\PrescriptionDescription(),
                'DoseReferenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferenceSequence(),
                'DoseReferenceNumber' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferenceNumber(),
                'DoseReferenceUID' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferenceUID(),
                'DoseReferenceStructureType' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferenceStructureType(),
                'NominalBeamEnergyUnit' => new \PHPExiftool\Driver\Tag\DICOM\NominalBeamEnergyUnit(),
                'DoseReferenceDescription' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferenceDescription(),
                'DoseReferencePointCoordinates' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferencePointCoordinates(),
                'NominalPriorDose' => new \PHPExiftool\Driver\Tag\DICOM\NominalPriorDose(),
                'DoseReferenceType' => new \PHPExiftool\Driver\Tag\DICOM\DoseReferenceType(),
                'ConstraintWeight' => new \PHPExiftool\Driver\Tag\DICOM\ConstraintWeight(),
                'DeliveryWarningDose' => new \PHPExiftool\Driver\Tag\DICOM\DeliveryWarningDose(),
                'DeliveryMaximumDose' => new \PHPExiftool\Driver\Tag\DICOM\DeliveryMaximumDose(),
                'TargetMinimumDose' => new \PHPExiftool\Driver\Tag\DICOM\TargetMinimumDose(),
                'TargetPrescriptionDose' => new \PHPExiftool\Driver\Tag\DICOM\TargetPrescriptionDose(),
                'TargetMaximumDose' => new \PHPExiftool\Driver\Tag\DICOM\TargetMaximumDose(),
                'TargetUnderdoseVolumeFraction' => new \PHPExiftool\Driver\Tag\DICOM\TargetUnderdoseVolumeFraction(),
                'OrganAtRiskFullVolumeDose' => new \PHPExiftool\Driver\Tag\DICOM\OrganAtRiskFullVolumeDose(),
                'OrganAtRiskLimitDose' => new \PHPExiftool\Driver\Tag\DICOM\OrganAtRiskLimitDose(),
                'OrganAtRiskMaximumDose' => new \PHPExiftool\Driver\Tag\DICOM\OrganAtRiskMaximumDose(),
                'OrganAtRiskOverdoseVolumeFraction' => new \PHPExiftool\Driver\Tag\DICOM\OrganAtRiskOverdoseVolumeFraction(),
                'ToleranceTableSequence' => new \PHPExiftool\Driver\Tag\DICOM\ToleranceTableSequence(),
                'ToleranceTableNumber' => new \PHPExiftool\Driver\Tag\DICOM\ToleranceTableNumber(),
                'ToleranceTableLabel' => new \PHPExiftool\Driver\Tag\DICOM\ToleranceTableLabel(),
                'GantryAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\GantryAngleTolerance(),
                'BeamLimitingDeviceAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDeviceAngleTolerance(),
                'BeamLimitingDeviceToleranceSeq' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDeviceToleranceSeq(),
                'BeamLimitingDevicePositionTol' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDevicePositionTol(),
                'SnoutPositionTolerance' => new \PHPExiftool\Driver\Tag\DICOM\SnoutPositionTolerance(),
                'PatientSupportAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\PatientSupportAngleTolerance(),
                'TableTopEccentricAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\TableTopEccentricAngleTolerance(),
                'TableTopPitchAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\TableTopPitchAngleTolerance(),
                'TableTopRollAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\TableTopRollAngleTolerance(),
                'TableTopVerticalPositionTolerance' => new \PHPExiftool\Driver\Tag\DICOM\TableTopVerticalPositionTolerance(),
                'TableTopLongitudinalPositionTol' => new \PHPExiftool\Driver\Tag\DICOM\TableTopLongitudinalPositionTol(),
                'TableTopLateralPositionTolerance' => new \PHPExiftool\Driver\Tag\DICOM\TableTopLateralPositionTolerance(),
                'RTPlanRelationship' => new \PHPExiftool\Driver\Tag\DICOM\RTPlanRelationship(),
                'FractionGroupSequence' => new \PHPExiftool\Driver\Tag\DICOM\FractionGroupSequence(),
                'FractionGroupNumber' => new \PHPExiftool\Driver\Tag\DICOM\FractionGroupNumber(),
                'FractionGroupDescription' => new \PHPExiftool\Driver\Tag\DICOM\FractionGroupDescription(),
                'NumberOfFractionsPlanned' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFractionsPlanned(),
                'NumberFractionPatternDigitsPerDay' => new \PHPExiftool\Driver\Tag\DICOM\NumberFractionPatternDigitsPerDay(),
                'RepeatFractionCycleLength' => new \PHPExiftool\Driver\Tag\DICOM\RepeatFractionCycleLength(),
                'FractionPattern' => new \PHPExiftool\Driver\Tag\DICOM\FractionPattern(),
                'NumberOfBeams' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfBeams(),
                'BeamDoseSpecificationPoint' => new \PHPExiftool\Driver\Tag\DICOM\BeamDoseSpecificationPoint(),
                'BeamDose' => new \PHPExiftool\Driver\Tag\DICOM\BeamDose(),
                'BeamMeterset' => new \PHPExiftool\Driver\Tag\DICOM\BeamMeterset(),
                'BeamDosePointDepth' => new \PHPExiftool\Driver\Tag\DICOM\BeamDosePointDepth(),
                'BeamDosePointEquivalentDepth' => new \PHPExiftool\Driver\Tag\DICOM\BeamDosePointEquivalentDepth(),
                'BeamDosePointSSD' => new \PHPExiftool\Driver\Tag\DICOM\BeamDosePointSSD(),
                'NumberOfBrachyApplicationSetups' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfBrachyApplicationSetups(),
                'BrachyAppSetupDoseSpecPoint' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAppSetupDoseSpecPoint(),
                'BrachyApplicationSetupDose' => new \PHPExiftool\Driver\Tag\DICOM\BrachyApplicationSetupDose(),
                'BeamSequence' => new \PHPExiftool\Driver\Tag\DICOM\BeamSequence(),
                'TreatmentMachineName' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentMachineName(),
                'PrimaryDosimeterUnit' => new \PHPExiftool\Driver\Tag\DICOM\PrimaryDosimeterUnit(),
                'SourceAxisDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceAxisDistance(),
                'BeamLimitingDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDeviceSequence(),
                'RTBeamLimitingDeviceType' => new \PHPExiftool\Driver\Tag\DICOM\RTBeamLimitingDeviceType(),
                'SourceToBeamLimitingDeviceDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToBeamLimitingDeviceDistance(),
                'IsocenterToBeamLimitingDeviceDist' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToBeamLimitingDeviceDist(),
                'NumberOfLeafJawPairs' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfLeafJawPairs(),
                'LeafPositionBoundaries' => new \PHPExiftool\Driver\Tag\DICOM\LeafPositionBoundaries(),
                'BeamNumber' => new \PHPExiftool\Driver\Tag\DICOM\BeamNumber(),
                'BeamName' => new \PHPExiftool\Driver\Tag\DICOM\BeamName(),
                'BeamDescription' => new \PHPExiftool\Driver\Tag\DICOM\BeamDescription(),
                'BeamType' => new \PHPExiftool\Driver\Tag\DICOM\BeamType(),
                'RadiationType' => new \PHPExiftool\Driver\Tag\DICOM\RadiationType(),
                'HighDoseTechniqueType' => new \PHPExiftool\Driver\Tag\DICOM\HighDoseTechniqueType(),
                'ReferenceImageNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceImageNumber(),
                'PlannedVerificationImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\PlannedVerificationImageSequence(),
                'ImagingDeviceSpecificAcqParams' => new \PHPExiftool\Driver\Tag\DICOM\ImagingDeviceSpecificAcqParams(),
                'TreatmentDeliveryType' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentDeliveryType(),
                'NumberOfWedges' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfWedges(),
                'WedgeSequence' => new \PHPExiftool\Driver\Tag\DICOM\WedgeSequence(),
                'WedgeNumber' => new \PHPExiftool\Driver\Tag\DICOM\WedgeNumber(),
                'WedgeType' => new \PHPExiftool\Driver\Tag\DICOM\WedgeType(),
                'WedgeID' => new \PHPExiftool\Driver\Tag\DICOM\WedgeID(),
                'WedgeAngle' => new \PHPExiftool\Driver\Tag\DICOM\WedgeAngle(),
                'WedgeFactor' => new \PHPExiftool\Driver\Tag\DICOM\WedgeFactor(),
                'TotalWedgeTrayWaterEquivThickness' => new \PHPExiftool\Driver\Tag\DICOM\TotalWedgeTrayWaterEquivThickness(),
                'WedgeOrientation' => new \PHPExiftool\Driver\Tag\DICOM\WedgeOrientation(),
                'IsocenterToWedgeTrayDistance' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToWedgeTrayDistance(),
                'SourceToWedgeTrayDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToWedgeTrayDistance(),
                'WedgeThinEdgePosition' => new \PHPExiftool\Driver\Tag\DICOM\WedgeThinEdgePosition(),
                'BolusID' => new \PHPExiftool\Driver\Tag\DICOM\BolusID(),
                'BolusDescription' => new \PHPExiftool\Driver\Tag\DICOM\BolusDescription(),
                'NumberOfCompensators' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfCompensators(),
                'MaterialID' => new \PHPExiftool\Driver\Tag\DICOM\MaterialID(),
                'TotalCompensatorTrayFactor' => new \PHPExiftool\Driver\Tag\DICOM\TotalCompensatorTrayFactor(),
                'CompensatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorSequence(),
                'CompensatorNumber' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorNumber(),
                'CompensatorID' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorID(),
                'SourceToCompensatorTrayDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToCompensatorTrayDistance(),
                'CompensatorRows' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorRows(),
                'CompensatorColumns' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorColumns(),
                'CompensatorPixelSpacing' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorPixelSpacing(),
                'CompensatorPosition' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorPosition(),
                'CompensatorTransmissionData' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorTransmissionData(),
                'CompensatorThicknessData' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorThicknessData(),
                'NumberOfBoli' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfBoli(),
                'CompensatorType' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorType(),
                'NumberOfBlocks' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfBlocks(),
                'TotalBlockTrayFactor' => new \PHPExiftool\Driver\Tag\DICOM\TotalBlockTrayFactor(),
                'TotalBlockTrayWaterEquivThickness' => new \PHPExiftool\Driver\Tag\DICOM\TotalBlockTrayWaterEquivThickness(),
                'BlockSequence' => new \PHPExiftool\Driver\Tag\DICOM\BlockSequence(),
                'BlockTrayID' => new \PHPExiftool\Driver\Tag\DICOM\BlockTrayID(),
                'SourceToBlockTrayDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToBlockTrayDistance(),
                'IsocenterToBlockTrayDistance' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToBlockTrayDistance(),
                'BlockType' => new \PHPExiftool\Driver\Tag\DICOM\BlockType(),
                'AccessoryCode' => new \PHPExiftool\Driver\Tag\DICOM\AccessoryCode(),
                'BlockDivergence' => new \PHPExiftool\Driver\Tag\DICOM\BlockDivergence(),
                'BlockMountingPosition' => new \PHPExiftool\Driver\Tag\DICOM\BlockMountingPosition(),
                'BlockNumber' => new \PHPExiftool\Driver\Tag\DICOM\BlockNumber(),
                'BlockName' => new \PHPExiftool\Driver\Tag\DICOM\BlockName(),
                'BlockThickness' => new \PHPExiftool\Driver\Tag\DICOM\BlockThickness(),
                'BlockTransmission' => new \PHPExiftool\Driver\Tag\DICOM\BlockTransmission(),
                'BlockNumberOfPoints' => new \PHPExiftool\Driver\Tag\DICOM\BlockNumberOfPoints(),
                'BlockData' => new \PHPExiftool\Driver\Tag\DICOM\BlockData(),
                'ApplicatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\ApplicatorSequence(),
                'ApplicatorID' => new \PHPExiftool\Driver\Tag\DICOM\ApplicatorID(),
                'ApplicatorType' => new \PHPExiftool\Driver\Tag\DICOM\ApplicatorType(),
                'ApplicatorDescription' => new \PHPExiftool\Driver\Tag\DICOM\ApplicatorDescription(),
                'CumulativeDoseReferenceCoefficient' => new \PHPExiftool\Driver\Tag\DICOM\CumulativeDoseReferenceCoefficient(),
                'FinalCumulativeMetersetWeight' => new \PHPExiftool\Driver\Tag\DICOM\FinalCumulativeMetersetWeight(),
                'NumberOfControlPoints' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfControlPoints(),
                'ControlPointSequence' => new \PHPExiftool\Driver\Tag\DICOM\ControlPointSequence(),
                'ControlPointIndex' => new \PHPExiftool\Driver\Tag\DICOM\ControlPointIndex(),
                'NominalBeamEnergy' => new \PHPExiftool\Driver\Tag\DICOM\NominalBeamEnergy(),
                'DoseRateSet' => new \PHPExiftool\Driver\Tag\DICOM\DoseRateSet(),
                'WedgePositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\WedgePositionSequence(),
                'WedgePosition' => new \PHPExiftool\Driver\Tag\DICOM\WedgePosition(),
                'BeamLimitingDevicePositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDevicePositionSequence(),
                'LeafJawPositions' => new \PHPExiftool\Driver\Tag\DICOM\LeafJawPositions(),
                'GantryAngle' => new \PHPExiftool\Driver\Tag\DICOM\GantryAngle(),
                'GantryRotationDirection' => new \PHPExiftool\Driver\Tag\DICOM\GantryRotationDirection(),
                'BeamLimitingDeviceAngle' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDeviceAngle(),
                'BeamLimitingDeviceRotateDirection' => new \PHPExiftool\Driver\Tag\DICOM\BeamLimitingDeviceRotateDirection(),
                'PatientSupportAngle' => new \PHPExiftool\Driver\Tag\DICOM\PatientSupportAngle(),
                'PatientSupportRotationDirection' => new \PHPExiftool\Driver\Tag\DICOM\PatientSupportRotationDirection(),
                'TableTopEccentricAxisDistance' => new \PHPExiftool\Driver\Tag\DICOM\TableTopEccentricAxisDistance(),
                'TableTopEccentricAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableTopEccentricAngle(),
                'TableTopEccentricRotateDirection' => new \PHPExiftool\Driver\Tag\DICOM\TableTopEccentricRotateDirection(),
                'TableTopVerticalPosition' => new \PHPExiftool\Driver\Tag\DICOM\TableTopVerticalPosition(),
                'TableTopLongitudinalPosition' => new \PHPExiftool\Driver\Tag\DICOM\TableTopLongitudinalPosition(),
                'TableTopLateralPosition' => new \PHPExiftool\Driver\Tag\DICOM\TableTopLateralPosition(),
                'IsocenterPosition' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterPosition(),
                'SurfaceEntryPoint' => new \PHPExiftool\Driver\Tag\DICOM\SurfaceEntryPoint(),
                'SourceToSurfaceDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToSurfaceDistance(),
                'CumulativeMetersetWeight' => new \PHPExiftool\Driver\Tag\DICOM\CumulativeMetersetWeight(),
                'TableTopPitchAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableTopPitchAngle(),
                'TableTopPitchRotationDirection' => new \PHPExiftool\Driver\Tag\DICOM\TableTopPitchRotationDirection(),
                'TableTopRollAngle' => new \PHPExiftool\Driver\Tag\DICOM\TableTopRollAngle(),
                'TableTopRollRotationDirection' => new \PHPExiftool\Driver\Tag\DICOM\TableTopRollRotationDirection(),
                'HeadFixationAngle' => new \PHPExiftool\Driver\Tag\DICOM\HeadFixationAngle(),
                'GantryPitchAngle' => new \PHPExiftool\Driver\Tag\DICOM\GantryPitchAngle(),
                'GantryPitchRotationDirection' => new \PHPExiftool\Driver\Tag\DICOM\GantryPitchRotationDirection(),
                'GantryPitchAngleTolerance' => new \PHPExiftool\Driver\Tag\DICOM\GantryPitchAngleTolerance(),
                'PatientSetupSequence' => new \PHPExiftool\Driver\Tag\DICOM\PatientSetupSequence(),
                'PatientSetupNumber' => new \PHPExiftool\Driver\Tag\DICOM\PatientSetupNumber(),
                'PatientSetupLabel' => new \PHPExiftool\Driver\Tag\DICOM\PatientSetupLabel(),
                'PatientAdditionalPosition' => new \PHPExiftool\Driver\Tag\DICOM\PatientAdditionalPosition(),
                'FixationDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\FixationDeviceSequence(),
                'FixationDeviceType' => new \PHPExiftool\Driver\Tag\DICOM\FixationDeviceType(),
                'FixationDeviceLabel' => new \PHPExiftool\Driver\Tag\DICOM\FixationDeviceLabel(),
                'FixationDeviceDescription' => new \PHPExiftool\Driver\Tag\DICOM\FixationDeviceDescription(),
                'FixationDevicePosition' => new \PHPExiftool\Driver\Tag\DICOM\FixationDevicePosition(),
                'FixationDevicePitchAngle' => new \PHPExiftool\Driver\Tag\DICOM\FixationDevicePitchAngle(),
                'FixationDeviceRollAngle' => new \PHPExiftool\Driver\Tag\DICOM\FixationDeviceRollAngle(),
                'ShieldingDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\ShieldingDeviceSequence(),
                'ShieldingDeviceType' => new \PHPExiftool\Driver\Tag\DICOM\ShieldingDeviceType(),
                'ShieldingDeviceLabel' => new \PHPExiftool\Driver\Tag\DICOM\ShieldingDeviceLabel(),
                'ShieldingDeviceDescription' => new \PHPExiftool\Driver\Tag\DICOM\ShieldingDeviceDescription(),
                'ShieldingDevicePosition' => new \PHPExiftool\Driver\Tag\DICOM\ShieldingDevicePosition(),
                'SetupTechnique' => new \PHPExiftool\Driver\Tag\DICOM\SetupTechnique(),
                'SetupTechniqueDescription' => new \PHPExiftool\Driver\Tag\DICOM\SetupTechniqueDescription(),
                'SetupDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\SetupDeviceSequence(),
                'SetupDeviceType' => new \PHPExiftool\Driver\Tag\DICOM\SetupDeviceType(),
                'SetupDeviceLabel' => new \PHPExiftool\Driver\Tag\DICOM\SetupDeviceLabel(),
                'SetupDeviceDescription' => new \PHPExiftool\Driver\Tag\DICOM\SetupDeviceDescription(),
                'SetupDeviceParameter' => new \PHPExiftool\Driver\Tag\DICOM\SetupDeviceParameter(),
                'SetupReferenceDescription' => new \PHPExiftool\Driver\Tag\DICOM\SetupReferenceDescription(),
                'TableTopVerticalSetupDisplacement' => new \PHPExiftool\Driver\Tag\DICOM\TableTopVerticalSetupDisplacement(),
                'TableTopLongitudinalSetupDisplace' => new \PHPExiftool\Driver\Tag\DICOM\TableTopLongitudinalSetupDisplace(),
                'TableTopLateralSetupDisplacement' => new \PHPExiftool\Driver\Tag\DICOM\TableTopLateralSetupDisplacement(),
                'BrachyTreatmentTechnique' => new \PHPExiftool\Driver\Tag\DICOM\BrachyTreatmentTechnique(),
                'BrachyTreatmentType' => new \PHPExiftool\Driver\Tag\DICOM\BrachyTreatmentType(),
                'TreatmentMachineSequence' => new \PHPExiftool\Driver\Tag\DICOM\TreatmentMachineSequence(),
                'SourceSequence' => new \PHPExiftool\Driver\Tag\DICOM\SourceSequence(),
                'SourceNumber' => new \PHPExiftool\Driver\Tag\DICOM\SourceNumber(),
                'SourceType' => new \PHPExiftool\Driver\Tag\DICOM\SourceType(),
                'SourceManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\SourceManufacturer(),
                'ActiveSourceDiameter' => new \PHPExiftool\Driver\Tag\DICOM\ActiveSourceDiameter(),
                'ActiveSourceLength' => new \PHPExiftool\Driver\Tag\DICOM\ActiveSourceLength(),
                'SourceEncapsulationNomThickness' => new \PHPExiftool\Driver\Tag\DICOM\SourceEncapsulationNomThickness(),
                'SourceEncapsulationNomTransmission' => new \PHPExiftool\Driver\Tag\DICOM\SourceEncapsulationNomTransmission(),
                'SourceIsotopeName' => new \PHPExiftool\Driver\Tag\DICOM\SourceIsotopeName(),
                'SourceIsotopeHalfLife' => new \PHPExiftool\Driver\Tag\DICOM\SourceIsotopeHalfLife(),
                'SourceStrengthUnits' => new \PHPExiftool\Driver\Tag\DICOM\SourceStrengthUnits(),
                'ReferenceAirKermaRate' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceAirKermaRate(),
                'SourceStrength' => new \PHPExiftool\Driver\Tag\DICOM\SourceStrength(),
                'SourceStrengthReferenceDate' => new \PHPExiftool\Driver\Tag\DICOM\SourceStrengthReferenceDate(),
                'SourceStrengthReferenceTime' => new \PHPExiftool\Driver\Tag\DICOM\SourceStrengthReferenceTime(),
                'ApplicationSetupSequence' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationSetupSequence(),
                'ApplicationSetupType' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationSetupType(),
                'ApplicationSetupNumber' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationSetupNumber(),
                'ApplicationSetupName' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationSetupName(),
                'ApplicationSetupManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\ApplicationSetupManufacturer(),
                'TemplateNumber' => new \PHPExiftool\Driver\Tag\DICOM\TemplateNumber(),
                'TemplateType' => new \PHPExiftool\Driver\Tag\DICOM\TemplateType(),
                'TemplateName' => new \PHPExiftool\Driver\Tag\DICOM\TemplateName(),
                'TotalReferenceAirKerma' => new \PHPExiftool\Driver\Tag\DICOM\TotalReferenceAirKerma(),
                'BrachyAccessoryDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDeviceSequence(),
                'BrachyAccessoryDeviceNumber' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDeviceNumber(),
                'BrachyAccessoryDeviceID' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDeviceID(),
                'BrachyAccessoryDeviceType' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDeviceType(),
                'BrachyAccessoryDeviceName' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDeviceName(),
                'BrachyAccessoryDeviceNomThickness' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDeviceNomThickness(),
                'BrachyAccessoryDevNomTransmission' => new \PHPExiftool\Driver\Tag\DICOM\BrachyAccessoryDevNomTransmission(),
                'ChannelSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelSequence(),
                'ChannelNumber' => new \PHPExiftool\Driver\Tag\DICOM\ChannelNumber(),
                'ChannelLength' => new \PHPExiftool\Driver\Tag\DICOM\ChannelLength(),
                'ChannelTotalTime' => new \PHPExiftool\Driver\Tag\DICOM\ChannelTotalTime(),
                'SourceMovementType' => new \PHPExiftool\Driver\Tag\DICOM\SourceMovementType(),
                'NumberOfPulses' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPulses(),
                'PulseRepetitionInterval' => new \PHPExiftool\Driver\Tag\DICOM\PulseRepetitionInterval(),
                'SourceApplicatorNumber' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorNumber(),
                'SourceApplicatorID' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorID(),
                'SourceApplicatorType' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorType(),
                'SourceApplicatorName' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorName(),
                'SourceApplicatorLength' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorLength(),
                'SourceApplicatorManufacturer' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorManufacturer(),
                'SourceApplicatorWallNomThickness' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorWallNomThickness(),
                'SourceApplicatorWallNomTrans' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorWallNomTrans(),
                'SourceApplicatorStepSize' => new \PHPExiftool\Driver\Tag\DICOM\SourceApplicatorStepSize(),
                'TransferTubeNumber' => new \PHPExiftool\Driver\Tag\DICOM\TransferTubeNumber(),
                'TransferTubeLength' => new \PHPExiftool\Driver\Tag\DICOM\TransferTubeLength(),
                'ChannelShieldSequence' => new \PHPExiftool\Driver\Tag\DICOM\ChannelShieldSequence(),
                'ChannelShieldNumber' => new \PHPExiftool\Driver\Tag\DICOM\ChannelShieldNumber(),
                'ChannelShieldID' => new \PHPExiftool\Driver\Tag\DICOM\ChannelShieldID(),
                'ChannelShieldName' => new \PHPExiftool\Driver\Tag\DICOM\ChannelShieldName(),
                'ChannelShieldNominalThickness' => new \PHPExiftool\Driver\Tag\DICOM\ChannelShieldNominalThickness(),
                'ChannelShieldNominalTransmission' => new \PHPExiftool\Driver\Tag\DICOM\ChannelShieldNominalTransmission(),
                'FinalCumulativeTimeWeight' => new \PHPExiftool\Driver\Tag\DICOM\FinalCumulativeTimeWeight(),
                'BrachyControlPointSequence' => new \PHPExiftool\Driver\Tag\DICOM\BrachyControlPointSequence(),
                'ControlPointRelativePosition' => new \PHPExiftool\Driver\Tag\DICOM\ControlPointRelativePosition(),
                'ControlPoint3DPosition' => new \PHPExiftool\Driver\Tag\DICOM\ControlPoint3DPosition(),
                'CumulativeTimeWeight' => new \PHPExiftool\Driver\Tag\DICOM\CumulativeTimeWeight(),
                'CompensatorDivergence' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorDivergence(),
                'CompensatorMountingPosition' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorMountingPosition(),
                'SourceToCompensatorDistance' => new \PHPExiftool\Driver\Tag\DICOM\SourceToCompensatorDistance(),
                'TotalCompTrayWaterEquivThickness' => new \PHPExiftool\Driver\Tag\DICOM\TotalCompTrayWaterEquivThickness(),
                'IsocenterToCompensatorTrayDistance' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToCompensatorTrayDistance(),
                'CompensatorColumnOffset' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorColumnOffset(),
                'IsocenterToCompensatorDistances' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToCompensatorDistances(),
                'CompensatorRelStoppingPowerRatio' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorRelStoppingPowerRatio(),
                'CompensatorMillingToolDiameter' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorMillingToolDiameter(),
                'IonRangeCompensatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonRangeCompensatorSequence(),
                'CompensatorDescription' => new \PHPExiftool\Driver\Tag\DICOM\CompensatorDescription(),
                'RadiationMassNumber' => new \PHPExiftool\Driver\Tag\DICOM\RadiationMassNumber(),
                'RadiationAtomicNumber' => new \PHPExiftool\Driver\Tag\DICOM\RadiationAtomicNumber(),
                'RadiationChargeState' => new \PHPExiftool\Driver\Tag\DICOM\RadiationChargeState(),
                'ScanMode' => new \PHPExiftool\Driver\Tag\DICOM\ScanMode(),
                'VirtualSourceAxisDistances' => new \PHPExiftool\Driver\Tag\DICOM\VirtualSourceAxisDistances(),
                'SnoutSequence' => new \PHPExiftool\Driver\Tag\DICOM\SnoutSequence(),
                'SnoutPosition' => new \PHPExiftool\Driver\Tag\DICOM\SnoutPosition(),
                'SnoutID' => new \PHPExiftool\Driver\Tag\DICOM\SnoutID(),
                'NumberOfRangeShifters' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfRangeShifters(),
                'RangeShifterSequence' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterSequence(),
                'RangeShifterNumber' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterNumber(),
                'RangeShifterID' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterID(),
                'RangeShifterType' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterType(),
                'RangeShifterDescription' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterDescription(),
                'NumberOfLateralSpreadingDevices' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfLateralSpreadingDevices(),
                'LateralSpreadingDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceSequence(),
                'LateralSpreadingDeviceNumber' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceNumber(),
                'LateralSpreadingDeviceID' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceID(),
                'LateralSpreadingDeviceType' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceType(),
                'LateralSpreadingDeviceDescription' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceDescription(),
                'LateralSpreadingDevWaterEquivThick' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDevWaterEquivThick(),
                'NumberOfRangeModulators' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfRangeModulators(),
                'RangeModulatorSequence' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorSequence(),
                'RangeModulatorNumber' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorNumber(),
                'RangeModulatorID' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorID(),
                'RangeModulatorType' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorType(),
                'RangeModulatorDescription' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorDescription(),
                'BeamCurrentModulationID' => new \PHPExiftool\Driver\Tag\DICOM\BeamCurrentModulationID(),
                'PatientSupportType' => new \PHPExiftool\Driver\Tag\DICOM\PatientSupportType(),
                'PatientSupportID' => new \PHPExiftool\Driver\Tag\DICOM\PatientSupportID(),
                'PatientSupportAccessoryCode' => new \PHPExiftool\Driver\Tag\DICOM\PatientSupportAccessoryCode(),
                'FixationLightAzimuthalAngle' => new \PHPExiftool\Driver\Tag\DICOM\FixationLightAzimuthalAngle(),
                'FixationLightPolarAngle' => new \PHPExiftool\Driver\Tag\DICOM\FixationLightPolarAngle(),
                'MetersetRate' => new \PHPExiftool\Driver\Tag\DICOM\MetersetRate(),
                'RangeShifterSettingsSequence' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterSettingsSequence(),
                'RangeShifterSetting' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterSetting(),
                'IsocenterToRangeShifterDistance' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToRangeShifterDistance(),
                'RangeShifterWaterEquivThickness' => new \PHPExiftool\Driver\Tag\DICOM\RangeShifterWaterEquivThickness(),
                'LateralSpreadingDeviceSettingsSeq' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceSettingsSeq(),
                'LateralSpreadingDeviceSetting' => new \PHPExiftool\Driver\Tag\DICOM\LateralSpreadingDeviceSetting(),
                'IsocenterToLateralSpreadingDevDist' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToLateralSpreadingDevDist(),
                'RangeModulatorSettingsSequence' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorSettingsSequence(),
                'RangeModulatorGatingStartValue' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorGatingStartValue(),
                'RangeModulatorGatingStopValue' => new \PHPExiftool\Driver\Tag\DICOM\RangeModulatorGatingStopValue(),
                'IsocenterToRangeModulatorDistance' => new \PHPExiftool\Driver\Tag\DICOM\IsocenterToRangeModulatorDistance(),
                'ScanSpotTuneID' => new \PHPExiftool\Driver\Tag\DICOM\ScanSpotTuneID(),
                'NumberOfScanSpotPositions' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfScanSpotPositions(),
                'ScanSpotPositionMap' => new \PHPExiftool\Driver\Tag\DICOM\ScanSpotPositionMap(),
                'ScanSpotMetersetWeights' => new \PHPExiftool\Driver\Tag\DICOM\ScanSpotMetersetWeights(),
                'ScanningSpotSize' => new \PHPExiftool\Driver\Tag\DICOM\ScanningSpotSize(),
                'NumberOfPaintings' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPaintings(),
                'IonToleranceTableSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonToleranceTableSequence(),
                'IonBeamSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonBeamSequence(),
                'IonBeamLimitingDeviceSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonBeamLimitingDeviceSequence(),
                'IonBlockSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonBlockSequence(),
                'IonControlPointSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonControlPointSequence(),
                'IonWedgeSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonWedgeSequence(),
                'IonWedgePositionSequence' => new \PHPExiftool\Driver\Tag\DICOM\IonWedgePositionSequence(),
                'ReferencedSetupImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSetupImageSequence(),
                'SetupImageComment' => new \PHPExiftool\Driver\Tag\DICOM\SetupImageComment(),
                'MotionSynchronizationSequence' => new \PHPExiftool\Driver\Tag\DICOM\MotionSynchronizationSequence(),
                'ControlPointOrientation' => new \PHPExiftool\Driver\Tag\DICOM\ControlPointOrientation(),
                'GeneralAccessorySequence' => new \PHPExiftool\Driver\Tag\DICOM\GeneralAccessorySequence(),
                'GeneralAccessoryID' => new \PHPExiftool\Driver\Tag\DICOM\GeneralAccessoryID(),
                'GeneralAccessoryDescription' => new \PHPExiftool\Driver\Tag\DICOM\GeneralAccessoryDescription(),
                'GeneralAccessoryType' => new \PHPExiftool\Driver\Tag\DICOM\GeneralAccessoryType(),
                'GeneralAccessoryNumber' => new \PHPExiftool\Driver\Tag\DICOM\GeneralAccessoryNumber(),
                'ReferencedRTPlanSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedRTPlanSequence(),
                'ReferencedBeamSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBeamSequence(),
                'ReferencedBeamNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBeamNumber(),
                'ReferencedReferenceImageNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedReferenceImageNumber(),
                'StartCumulativeMetersetWeight' => new \PHPExiftool\Driver\Tag\DICOM\StartCumulativeMetersetWeight(),
                'EndCumulativeMetersetWeight' => new \PHPExiftool\Driver\Tag\DICOM\EndCumulativeMetersetWeight(),
                'ReferencedBrachyAppSetupSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBrachyAppSetupSeq(),
                'ReferencedBrachyAppSetupNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBrachyAppSetupNumber(),
                'ReferencedSourceNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedSourceNumber(),
                'ReferencedFractionGroupSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFractionGroupSequence(),
                'ReferencedFractionGroupNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedFractionGroupNumber(),
                'ReferencedVerificationImageSeq' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedVerificationImageSeq(),
                'ReferencedReferenceImageSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedReferenceImageSequence(),
                'ReferencedDoseReferenceSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedDoseReferenceSequence(),
                'ReferencedDoseReferenceNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedDoseReferenceNumber(),
                'BrachyReferencedDoseReferenceSeq' => new \PHPExiftool\Driver\Tag\DICOM\BrachyReferencedDoseReferenceSeq(),
                'ReferencedStructureSetSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedStructureSetSequence(),
                'ReferencedPatientSetupNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedPatientSetupNumber(),
                'ReferencedDoseSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedDoseSequence(),
                'ReferencedToleranceTableNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedToleranceTableNumber(),
                'ReferencedBolusSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBolusSequence(),
                'ReferencedWedgeNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedWedgeNumber(),
                'ReferencedCompensatorNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedCompensatorNumber(),
                'ReferencedBlockNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedBlockNumber(),
                'ReferencedControlPointIndex' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedControlPointIndex(),
                'ReferencedControlPointSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedControlPointSequence(),
                'ReferencedStartControlPointIndex' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedStartControlPointIndex(),
                'ReferencedStopControlPointIndex' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedStopControlPointIndex(),
                'ReferencedRangeShifterNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedRangeShifterNumber(),
                'ReferencedLateralSpreadingDevNum' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedLateralSpreadingDevNum(),
                'ReferencedRangeModulatorNumber' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedRangeModulatorNumber(),
                'ApprovalStatus' => new \PHPExiftool\Driver\Tag\DICOM\ApprovalStatus(),
                'ReviewDate' => new \PHPExiftool\Driver\Tag\DICOM\ReviewDate(),
                'ReviewTime' => new \PHPExiftool\Driver\Tag\DICOM\ReviewTime(),
                'ReviewerName' => new \PHPExiftool\Driver\Tag\DICOM\ReviewerName(),
                'TextGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\TextGroupLength(),
                'Arbitrary' => new \PHPExiftool\Driver\Tag\DICOM\Arbitrary(),
                'TextComments' => new \PHPExiftool\Driver\Tag\DICOM\TextComments(),
                'ResultsID' => new \PHPExiftool\Driver\Tag\DICOM\ResultsID(),
                'ResultsIDIssuer' => new \PHPExiftool\Driver\Tag\DICOM\ResultsIDIssuer(),
                'ReferencedInterpretationSequence' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedInterpretationSequence(),
                'InterpretationRecordedDate' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationRecordedDate(),
                'InterpretationRecordedTime' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationRecordedTime(),
                'InterpretationRecorder' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationRecorder(),
                'ReferenceToRecordedSound' => new \PHPExiftool\Driver\Tag\DICOM\ReferenceToRecordedSound(),
                'InterpretationTranscriptionDate' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationTranscriptionDate(),
                'InterpretationTranscriptionTime' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationTranscriptionTime(),
                'InterpretationTranscriber' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationTranscriber(),
                'InterpretationText' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationText(),
                'InterpretationAuthor' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationAuthor(),
                'InterpretationApproverSequence' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationApproverSequence(),
                'InterpretationApprovalDate' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationApprovalDate(),
                'InterpretationApprovalTime' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationApprovalTime(),
                'PhysicianApprovingInterpretation' => new \PHPExiftool\Driver\Tag\DICOM\PhysicianApprovingInterpretation(),
                'InterpretationDiagnosisDescription' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationDiagnosisDescription(),
                'InterpretationDiagnosisCodeSeq' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationDiagnosisCodeSeq(),
                'ResultsDistributionListSequence' => new \PHPExiftool\Driver\Tag\DICOM\ResultsDistributionListSequence(),
                'DistributionName' => new \PHPExiftool\Driver\Tag\DICOM\DistributionName(),
                'DistributionAddress' => new \PHPExiftool\Driver\Tag\DICOM\DistributionAddress(),
                'InterpretationID' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationID(),
                'InterpretationIDIssuer' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationIDIssuer(),
                'InterpretationTypeID' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationTypeID(),
                'InterpretationStatusID' => new \PHPExiftool\Driver\Tag\DICOM\InterpretationStatusID(),
                'Impressions' => new \PHPExiftool\Driver\Tag\DICOM\Impressions(),
                'ResultsComments' => new \PHPExiftool\Driver\Tag\DICOM\ResultsComments(),
                'MACParametersSequence' => new \PHPExiftool\Driver\Tag\DICOM\MACParametersSequence(),
                'CurveDimensions' => new \PHPExiftool\Driver\Tag\DICOM\CurveDimensions(),
                'NumberOfPoints' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfPoints(),
                'TypeOfData' => new \PHPExiftool\Driver\Tag\DICOM\TypeOfData(),
                'CurveDescription' => new \PHPExiftool\Driver\Tag\DICOM\CurveDescription(),
                'AxisUnits' => new \PHPExiftool\Driver\Tag\DICOM\AxisUnits(),
                'AxisLabels' => new \PHPExiftool\Driver\Tag\DICOM\AxisLabels(),
                'DataValueRepresentation' => new \PHPExiftool\Driver\Tag\DICOM\DataValueRepresentation(),
                'MinimumCoordinateValue' => new \PHPExiftool\Driver\Tag\DICOM\MinimumCoordinateValue(),
                'MaximumCoordinateValue' => new \PHPExiftool\Driver\Tag\DICOM\MaximumCoordinateValue(),
                'CurveRange' => new \PHPExiftool\Driver\Tag\DICOM\CurveRange(),
                'CurveDataDescriptor' => new \PHPExiftool\Driver\Tag\DICOM\CurveDataDescriptor(),
                'CoordinateStartValue' => new \PHPExiftool\Driver\Tag\DICOM\CoordinateStartValue(),
                'CoordinateStepValue' => new \PHPExiftool\Driver\Tag\DICOM\CoordinateStepValue(),
                'CurveActivationLayer' => new \PHPExiftool\Driver\Tag\DICOM\CurveActivationLayer(),
                'AudioType' => new \PHPExiftool\Driver\Tag\DICOM\AudioType(),
                'AudioSampleFormat' => new \PHPExiftool\Driver\Tag\DICOM\AudioSampleFormat(),
                'NumberOfSamples' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfSamples(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\DICOM\SampleRate(),
                'TotalTime' => new \PHPExiftool\Driver\Tag\DICOM\TotalTime(),
                'AudioSampleData' => new \PHPExiftool\Driver\Tag\DICOM\AudioSampleData(),
                'AudioComments' => new \PHPExiftool\Driver\Tag\DICOM\AudioComments(),
                'CurveLabel' => new \PHPExiftool\Driver\Tag\DICOM\CurveLabel(),
                'ReferencedOverlayGroup' => new \PHPExiftool\Driver\Tag\DICOM\ReferencedOverlayGroup(),
                'CurveData' => new \PHPExiftool\Driver\Tag\DICOM\CurveData(),
                'SharedFunctionalGroupsSequence' => new \PHPExiftool\Driver\Tag\DICOM\SharedFunctionalGroupsSequence(),
                'PerFrameFunctionalGroupsSequence' => new \PHPExiftool\Driver\Tag\DICOM\PerFrameFunctionalGroupsSequence(),
                'WaveformSequence' => new \PHPExiftool\Driver\Tag\DICOM\WaveformSequence(),
                'ChannelMinimumValue' => new \PHPExiftool\Driver\Tag\DICOM\ChannelMinimumValue(),
                'ChannelMaximumValue' => new \PHPExiftool\Driver\Tag\DICOM\ChannelMaximumValue(),
                'WaveformBitsAllocated' => new \PHPExiftool\Driver\Tag\DICOM\WaveformBitsAllocated(),
                'WaveformSampleInterpretation' => new \PHPExiftool\Driver\Tag\DICOM\WaveformSampleInterpretation(),
                'WaveformPaddingValue' => new \PHPExiftool\Driver\Tag\DICOM\WaveformPaddingValue(),
                'WaveformData' => new \PHPExiftool\Driver\Tag\DICOM\WaveformData(),
                'FirstOrderPhaseCorrectionAngle' => new \PHPExiftool\Driver\Tag\DICOM\FirstOrderPhaseCorrectionAngle(),
                'SpectroscopyData' => new \PHPExiftool\Driver\Tag\DICOM\SpectroscopyData(),
                'OverlayGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\OverlayGroupLength(),
                'OverlayRows' => new \PHPExiftool\Driver\Tag\DICOM\OverlayRows(),
                'OverlayColumns' => new \PHPExiftool\Driver\Tag\DICOM\OverlayColumns(),
                'OverlayPlanes' => new \PHPExiftool\Driver\Tag\DICOM\OverlayPlanes(),
                'NumberOfFramesInOverlay' => new \PHPExiftool\Driver\Tag\DICOM\NumberOfFramesInOverlay(),
                'OverlayDescription' => new \PHPExiftool\Driver\Tag\DICOM\OverlayDescription(),
                'OverlayType' => new \PHPExiftool\Driver\Tag\DICOM\OverlayType(),
                'OverlaySubtype' => new \PHPExiftool\Driver\Tag\DICOM\OverlaySubtype(),
                'OverlayOrigin' => new \PHPExiftool\Driver\Tag\DICOM\OverlayOrigin(),
                'ImageFrameOrigin' => new \PHPExiftool\Driver\Tag\DICOM\ImageFrameOrigin(),
                'OverlayPlaneOrigin' => new \PHPExiftool\Driver\Tag\DICOM\OverlayPlaneOrigin(),
                'OverlayCompressionCode' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCompressionCode(),
                'OverlayCompressionOriginator' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCompressionOriginator(),
                'OverlayCompressionLabel' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCompressionLabel(),
                'OverlayCompressionDescription' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCompressionDescription(),
                'OverlayCompressionStepPointers' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCompressionStepPointers(),
                'OverlayRepeatInterval' => new \PHPExiftool\Driver\Tag\DICOM\OverlayRepeatInterval(),
                'OverlayBitsGrouped' => new \PHPExiftool\Driver\Tag\DICOM\OverlayBitsGrouped(),
                'OverlayBitsAllocated' => new \PHPExiftool\Driver\Tag\DICOM\OverlayBitsAllocated(),
                'OverlayBitPosition' => new \PHPExiftool\Driver\Tag\DICOM\OverlayBitPosition(),
                'OverlayFormat' => new \PHPExiftool\Driver\Tag\DICOM\OverlayFormat(),
                'OverlayLocation' => new \PHPExiftool\Driver\Tag\DICOM\OverlayLocation(),
                'OverlayCodeLabel' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCodeLabel(),
                'OverlayNumberOfTables' => new \PHPExiftool\Driver\Tag\DICOM\OverlayNumberOfTables(),
                'OverlayCodeTableLocation' => new \PHPExiftool\Driver\Tag\DICOM\OverlayCodeTableLocation(),
                'OverlayBitsForCodeWord' => new \PHPExiftool\Driver\Tag\DICOM\OverlayBitsForCodeWord(),
                'OverlayActivationLayer' => new \PHPExiftool\Driver\Tag\DICOM\OverlayActivationLayer(),
                'OverlayDescriptorGray' => new \PHPExiftool\Driver\Tag\DICOM\OverlayDescriptorGray(),
                'OverlayDescriptorRed' => new \PHPExiftool\Driver\Tag\DICOM\OverlayDescriptorRed(),
                'OverlayDescriptorGreen' => new \PHPExiftool\Driver\Tag\DICOM\OverlayDescriptorGreen(),
                'OverlayDescriptorBlue' => new \PHPExiftool\Driver\Tag\DICOM\OverlayDescriptorBlue(),
                'OverlaysGray' => new \PHPExiftool\Driver\Tag\DICOM\OverlaysGray(),
                'OverlaysRed' => new \PHPExiftool\Driver\Tag\DICOM\OverlaysRed(),
                'OverlaysGreen' => new \PHPExiftool\Driver\Tag\DICOM\OverlaysGreen(),
                'OverlaysBlue' => new \PHPExiftool\Driver\Tag\DICOM\OverlaysBlue(),
                'ROIArea' => new \PHPExiftool\Driver\Tag\DICOM\ROIArea(),
                'ROIMean' => new \PHPExiftool\Driver\Tag\DICOM\ROIMean(),
                'ROIStandardDeviation' => new \PHPExiftool\Driver\Tag\DICOM\ROIStandardDeviation(),
                'OverlayLabel' => new \PHPExiftool\Driver\Tag\DICOM\OverlayLabel(),
                'OverlayData' => new \PHPExiftool\Driver\Tag\DICOM\OverlayData(),
                'OverlayComments' => new \PHPExiftool\Driver\Tag\DICOM\OverlayComments(),
                'PixelDataGroupLength' => new \PHPExiftool\Driver\Tag\DICOM\PixelDataGroupLength(),
                'PixelData' => new \PHPExiftool\Driver\Tag\DICOM\PixelData(),
                'VariableNextDataGroup' => new \PHPExiftool\Driver\Tag\DICOM\VariableNextDataGroup(),
                'VariableCoefficientsSDVN' => new \PHPExiftool\Driver\Tag\DICOM\VariableCoefficientsSDVN(),
                'VariableCoefficientsSDHN' => new \PHPExiftool\Driver\Tag\DICOM\VariableCoefficientsSDHN(),
                'VariableCoefficientsSDDN' => new \PHPExiftool\Driver\Tag\DICOM\VariableCoefficientsSDDN(),
                'DigitalSignaturesSequence' => new \PHPExiftool\Driver\Tag\DICOM\DigitalSignaturesSequence(),
                'DataSetTrailingPadding' => new \PHPExiftool\Driver\Tag\DICOM\DataSetTrailingPadding(),
                'StartOfItem' => new \PHPExiftool\Driver\Tag\DICOM\StartOfItem(),
                'EndOfItems' => new \PHPExiftool\Driver\Tag\DICOM\EndOfItems(),
                'EndOfSequence' => new \PHPExiftool\Driver\Tag\DICOM\EndOfSequence(),
            );
        });
        $this['ExifIFD'] = $this->share(function(){
            return array(
                'MakerNoteApple' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteApple(),
                'MakerNoteNikon' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteNikon(),
                'MakerNoteCanon' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteCanon(),
                'MakerNoteCasio' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteCasio(),
                'MakerNoteCasio2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteCasio2(),
                'MakerNoteFLIR' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteFLIR(),
                'MakerNoteFujiFilm' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteFujiFilm(),
                'MakerNoteGE' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteGE(),
                'MakerNoteGE2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteGE2(),
                'MakerNoteHasselblad' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteHasselblad(),
                'MakerNoteHP' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteHP(),
                'MakerNoteHP2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteHP2(),
                'MakerNoteHP4' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteHP4(),
                'MakerNoteHP6' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteHP6(),
                'MakerNoteISL' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteISL(),
                'MakerNoteJVC' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteJVC(),
                'MakerNoteJVCText' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteJVCText(),
                'MakerNoteKodak1a' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak1a(),
                'MakerNoteKodak1b' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak1b(),
                'MakerNoteKodak2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak2(),
                'MakerNoteKodak3' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak3(),
                'MakerNoteKodak4' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak4(),
                'MakerNoteKodak5' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak5(),
                'MakerNoteKodak6a' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak6a(),
                'MakerNoteKodak6b' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak6b(),
                'MakerNoteKodak7' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak7(),
                'MakerNoteKodak8a' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak8a(),
                'MakerNoteKodak8b' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak8b(),
                'MakerNoteKodak8c' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak8c(),
                'MakerNoteKodak9' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak9(),
                'MakerNoteKodak10' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak10(),
                'MakerNoteKodak11' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodak11(),
                'MakerNoteKodakUnknown' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKodakUnknown(),
                'MakerNoteKyocera' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteKyocera(),
                'MakerNoteMinolta' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteMinolta(),
                'MakerNoteMinolta2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteMinolta2(),
                'MakerNoteMinolta3' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteMinolta3(),
                'MakerNoteMotorola' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteMotorola(),
                'MakerNoteNikon2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteNikon2(),
                'MakerNoteNikon3' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteNikon3(),
                'MakerNoteNintendo' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteNintendo(),
                'MakerNoteOlympus' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteOlympus(),
                'MakerNoteOlympus2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteOlympus2(),
                'MakerNoteLeica' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica(),
                'MakerNoteLeica2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica2(),
                'MakerNoteLeica3' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica3(),
                'MakerNoteLeica4' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica4(),
                'MakerNoteLeica5' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica5(),
                'MakerNoteLeica6' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica6(),
                'MakerNoteLeica7' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica7(),
                'MakerNoteLeica8' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica8(),
                'MakerNoteLeica9' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteLeica9(),
                'MakerNotePanasonic' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePanasonic(),
                'MakerNotePanasonic2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePanasonic2(),
                'MakerNotePentax' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePentax(),
                'MakerNotePentax2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePentax2(),
                'MakerNotePentax3' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePentax3(),
                'MakerNotePentax4' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePentax4(),
                'MakerNotePentax5' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePentax5(),
                'MakerNotePentax6' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePentax6(),
                'MakerNotePhaseOne' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNotePhaseOne(),
                'MakerNoteReconyx' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteReconyx(),
                'MakerNoteRicoh' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteRicoh(),
                'MakerNoteRicoh2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteRicoh2(),
                'MakerNoteRicohText' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteRicohText(),
                'MakerNoteSamsung1a' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSamsung1a(),
                'MakerNoteSamsung1b' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSamsung1b(),
                'MakerNoteSamsung2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSamsung2(),
                'MakerNoteSanyo' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSanyo(),
                'MakerNoteSanyoC4' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSanyoC4(),
                'MakerNoteSanyoPatch' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSanyoPatch(),
                'MakerNoteSigma' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSigma(),
                'MakerNoteSony' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSony(),
                'MakerNoteSony2' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSony2(),
                'MakerNoteSony3' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSony3(),
                'MakerNoteSony4' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSony4(),
                'MakerNoteSony5' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSony5(),
                'MakerNoteSonyEricsson' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSonyEricsson(),
                'MakerNoteSonySRF' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteSonySRF(),
                'MakerNoteUnknownText' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteUnknownText(),
                'MakerNoteUnknownBinary' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteUnknownBinary(),
                'MakerNoteUnknown' => new \PHPExiftool\Driver\Tag\ExifIFD\MakerNoteUnknown(),
                'StripOffsets' => new \PHPExiftool\Driver\Tag\ExifIFD\StripOffsets(),
                'StripByteCounts' => new \PHPExiftool\Driver\Tag\ExifIFD\StripByteCounts(),
                'FreeOffsets' => new \PHPExiftool\Driver\Tag\ExifIFD\FreeOffsets(),
                'FreeByteCounts' => new \PHPExiftool\Driver\Tag\ExifIFD\FreeByteCounts(),
                'GrayResponseCurve' => new \PHPExiftool\Driver\Tag\ExifIFD\GrayResponseCurve(),
                'T4Options' => new \PHPExiftool\Driver\Tag\ExifIFD\T4Options(),
                'T6Options' => new \PHPExiftool\Driver\Tag\ExifIFD\T6Options(),
                'ColorResponseUnit' => new \PHPExiftool\Driver\Tag\ExifIFD\ColorResponseUnit(),
                'ColorMap' => new \PHPExiftool\Driver\Tag\ExifIFD\ColorMap(),
                'TileOffsets' => new \PHPExiftool\Driver\Tag\ExifIFD\TileOffsets(),
                'TileByteCounts' => new \PHPExiftool\Driver\Tag\ExifIFD\TileByteCounts(),
                'BadFaxLines' => new \PHPExiftool\Driver\Tag\ExifIFD\BadFaxLines(),
                'CleanFaxData' => new \PHPExiftool\Driver\Tag\ExifIFD\CleanFaxData(),
                'ConsecutiveBadFaxLines' => new \PHPExiftool\Driver\Tag\ExifIFD\ConsecutiveBadFaxLines(),
                'A100DataOffset' => new \PHPExiftool\Driver\Tag\ExifIFD\A100DataOffset(),
                'InkNames' => new \PHPExiftool\Driver\Tag\ExifIFD\InkNames(),
                'NumberofInks' => new \PHPExiftool\Driver\Tag\ExifIFD\NumberofInks(),
                'TargetPrinter' => new \PHPExiftool\Driver\Tag\ExifIFD\TargetPrinter(),
                'ExtraSamples' => new \PHPExiftool\Driver\Tag\ExifIFD\ExtraSamples(),
                'SampleFormat' => new \PHPExiftool\Driver\Tag\ExifIFD\SampleFormat(),
                'SMinSampleValue' => new \PHPExiftool\Driver\Tag\ExifIFD\SMinSampleValue(),
                'SMaxSampleValue' => new \PHPExiftool\Driver\Tag\ExifIFD\SMaxSampleValue(),
                'TransferRange' => new \PHPExiftool\Driver\Tag\ExifIFD\TransferRange(),
                'ClipPath' => new \PHPExiftool\Driver\Tag\ExifIFD\ClipPath(),
                'XClipPathUnits' => new \PHPExiftool\Driver\Tag\ExifIFD\XClipPathUnits(),
                'YClipPathUnits' => new \PHPExiftool\Driver\Tag\ExifIFD\YClipPathUnits(),
                'Indexed' => new \PHPExiftool\Driver\Tag\ExifIFD\Indexed(),
                'JPEGTables' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGTables(),
                'OPIProxy' => new \PHPExiftool\Driver\Tag\ExifIFD\OPIProxy(),
                'ProfileType' => new \PHPExiftool\Driver\Tag\ExifIFD\ProfileType(),
                'FaxProfile' => new \PHPExiftool\Driver\Tag\ExifIFD\FaxProfile(),
                'CodingMethods' => new \PHPExiftool\Driver\Tag\ExifIFD\CodingMethods(),
                'VersionYear' => new \PHPExiftool\Driver\Tag\ExifIFD\VersionYear(),
                'ModeNumber' => new \PHPExiftool\Driver\Tag\ExifIFD\ModeNumber(),
                'Decode' => new \PHPExiftool\Driver\Tag\ExifIFD\Decode(),
                'DefaultImageColor' => new \PHPExiftool\Driver\Tag\ExifIFD\DefaultImageColor(),
                'T82Options' => new \PHPExiftool\Driver\Tag\ExifIFD\T82Options(),
                'JPEGProc' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGProc(),
                'OtherImageStart' => new \PHPExiftool\Driver\Tag\ExifIFD\OtherImageStart(),
                'OtherImageLength' => new \PHPExiftool\Driver\Tag\ExifIFD\OtherImageLength(),
                'JPEGRestartInterval' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGRestartInterval(),
                'JPEGLosslessPredictors' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGLosslessPredictors(),
                'JPEGPointTransforms' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGPointTransforms(),
                'JPEGQTables' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGQTables(),
                'JPEGDCTables' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGDCTables(),
                'JPEGACTables' => new \PHPExiftool\Driver\Tag\ExifIFD\JPEGACTables(),
                'StripRowCounts' => new \PHPExiftool\Driver\Tag\ExifIFD\StripRowCounts(),
                'ApplicationNotes' => new \PHPExiftool\Driver\Tag\ExifIFD\ApplicationNotes(),
                'USPTOMiscellaneous' => new \PHPExiftool\Driver\Tag\ExifIFD\USPTOMiscellaneous(),
                'XP_DIP_XML' => new \PHPExiftool\Driver\Tag\ExifIFD\XPDIPXML(),
                'ChromaticAberrationCorrParams' => new \PHPExiftool\Driver\Tag\ExifIFD\ChromaticAberrationCorrParams(),
                'DistortionCorrParams' => new \PHPExiftool\Driver\Tag\ExifIFD\DistortionCorrParams(),
                'ImageID' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageID(),
                'WangTag1' => new \PHPExiftool\Driver\Tag\ExifIFD\WangTag1(),
                'WangAnnotation' => new \PHPExiftool\Driver\Tag\ExifIFD\WangAnnotation(),
                'WangTag3' => new \PHPExiftool\Driver\Tag\ExifIFD\WangTag3(),
                'WangTag4' => new \PHPExiftool\Driver\Tag\ExifIFD\WangTag4(),
                'ImageReferencePoints' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageReferencePoints(),
                'RegionXformTackPoint' => new \PHPExiftool\Driver\Tag\ExifIFD\RegionXformTackPoint(),
                'WarpQuadrilateral' => new \PHPExiftool\Driver\Tag\ExifIFD\WarpQuadrilateral(),
                'AffineTransformMat' => new \PHPExiftool\Driver\Tag\ExifIFD\AffineTransformMat(),
                'Matteing' => new \PHPExiftool\Driver\Tag\ExifIFD\Matteing(),
                'DataType' => new \PHPExiftool\Driver\Tag\ExifIFD\DataType(),
                'ImageDepth' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageDepth(),
                'TileDepth' => new \PHPExiftool\Driver\Tag\ExifIFD\TileDepth(),
                'ImageFullWidth' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageFullWidth(),
                'ImageFullHeight' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageFullHeight(),
                'TextureFormat' => new \PHPExiftool\Driver\Tag\ExifIFD\TextureFormat(),
                'WrapModes' => new \PHPExiftool\Driver\Tag\ExifIFD\WrapModes(),
                'FovCot' => new \PHPExiftool\Driver\Tag\ExifIFD\FovCot(),
                'MatrixWorldToScreen' => new \PHPExiftool\Driver\Tag\ExifIFD\MatrixWorldToScreen(),
                'MatrixWorldToCamera' => new \PHPExiftool\Driver\Tag\ExifIFD\MatrixWorldToCamera(),
                'Model2' => new \PHPExiftool\Driver\Tag\ExifIFD\Model2(),
                'BatteryLevel' => new \PHPExiftool\Driver\Tag\ExifIFD\BatteryLevel(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\ExifIFD\ExposureTime(),
                'FNumber' => new \PHPExiftool\Driver\Tag\ExifIFD\FNumber(),
                'MDFileTag' => new \PHPExiftool\Driver\Tag\ExifIFD\MDFileTag(),
                'MDScalePixel' => new \PHPExiftool\Driver\Tag\ExifIFD\MDScalePixel(),
                'MDColorTable' => new \PHPExiftool\Driver\Tag\ExifIFD\MDColorTable(),
                'MDLabName' => new \PHPExiftool\Driver\Tag\ExifIFD\MDLabName(),
                'MDSampleInfo' => new \PHPExiftool\Driver\Tag\ExifIFD\MDSampleInfo(),
                'MDPrepDate' => new \PHPExiftool\Driver\Tag\ExifIFD\MDPrepDate(),
                'MDPrepTime' => new \PHPExiftool\Driver\Tag\ExifIFD\MDPrepTime(),
                'MDFileUnits' => new \PHPExiftool\Driver\Tag\ExifIFD\MDFileUnits(),
                'PixelScale' => new \PHPExiftool\Driver\Tag\ExifIFD\PixelScale(),
                'AdventScale' => new \PHPExiftool\Driver\Tag\ExifIFD\AdventScale(),
                'AdventRevision' => new \PHPExiftool\Driver\Tag\ExifIFD\AdventRevision(),
                'UIC1Tag' => new \PHPExiftool\Driver\Tag\ExifIFD\UIC1Tag(),
                'UIC2Tag' => new \PHPExiftool\Driver\Tag\ExifIFD\UIC2Tag(),
                'UIC3Tag' => new \PHPExiftool\Driver\Tag\ExifIFD\UIC3Tag(),
                'UIC4Tag' => new \PHPExiftool\Driver\Tag\ExifIFD\UIC4Tag(),
                'IntergraphPacketData' => new \PHPExiftool\Driver\Tag\ExifIFD\IntergraphPacketData(),
                'IntergraphFlagRegisters' => new \PHPExiftool\Driver\Tag\ExifIFD\IntergraphFlagRegisters(),
                'IntergraphMatrix' => new \PHPExiftool\Driver\Tag\ExifIFD\IntergraphMatrix(),
                'INGRReserved' => new \PHPExiftool\Driver\Tag\ExifIFD\INGRReserved(),
                'ModelTiePoint' => new \PHPExiftool\Driver\Tag\ExifIFD\ModelTiePoint(),
                'Site' => new \PHPExiftool\Driver\Tag\ExifIFD\Site(),
                'ColorSequence' => new \PHPExiftool\Driver\Tag\ExifIFD\ColorSequence(),
                'IT8Header' => new \PHPExiftool\Driver\Tag\ExifIFD\IT8Header(),
                'RasterPadding' => new \PHPExiftool\Driver\Tag\ExifIFD\RasterPadding(),
                'BitsPerRunLength' => new \PHPExiftool\Driver\Tag\ExifIFD\BitsPerRunLength(),
                'BitsPerExtendedRunLength' => new \PHPExiftool\Driver\Tag\ExifIFD\BitsPerExtendedRunLength(),
                'ColorTable' => new \PHPExiftool\Driver\Tag\ExifIFD\ColorTable(),
                'ImageColorIndicator' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageColorIndicator(),
                'BackgroundColorIndicator' => new \PHPExiftool\Driver\Tag\ExifIFD\BackgroundColorIndicator(),
                'ImageColorValue' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageColorValue(),
                'BackgroundColorValue' => new \PHPExiftool\Driver\Tag\ExifIFD\BackgroundColorValue(),
                'PixelIntensityRange' => new \PHPExiftool\Driver\Tag\ExifIFD\PixelIntensityRange(),
                'TransparencyIndicator' => new \PHPExiftool\Driver\Tag\ExifIFD\TransparencyIndicator(),
                'ColorCharacterization' => new \PHPExiftool\Driver\Tag\ExifIFD\ColorCharacterization(),
                'HCUsage' => new \PHPExiftool\Driver\Tag\ExifIFD\HCUsage(),
                'TrapIndicator' => new \PHPExiftool\Driver\Tag\ExifIFD\TrapIndicator(),
                'CMYKEquivalent' => new \PHPExiftool\Driver\Tag\ExifIFD\CMYKEquivalent(),
                'PixelMagicJBIGOptions' => new \PHPExiftool\Driver\Tag\ExifIFD\PixelMagicJBIGOptions(),
                'JPLCartoIFD' => new \PHPExiftool\Driver\Tag\ExifIFD\JPLCartoIFD(),
                'ModelTransform' => new \PHPExiftool\Driver\Tag\ExifIFD\ModelTransform(),
                'WB_GRGBLevels' => new \PHPExiftool\Driver\Tag\ExifIFD\WBGRGBLevels(),
                'TIFF_FXExtensions' => new \PHPExiftool\Driver\Tag\ExifIFD\TIFFFXExtensions(),
                'MultiProfiles' => new \PHPExiftool\Driver\Tag\ExifIFD\MultiProfiles(),
                'SharedData' => new \PHPExiftool\Driver\Tag\ExifIFD\SharedData(),
                'T88Options' => new \PHPExiftool\Driver\Tag\ExifIFD\T88Options(),
                'ImageLayer' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageLayer(),
                'JBIGOptions' => new \PHPExiftool\Driver\Tag\ExifIFD\JBIGOptions(),
                'ExposureProgram' => new \PHPExiftool\Driver\Tag\ExifIFD\ExposureProgram(),
                'SpectralSensitivity' => new \PHPExiftool\Driver\Tag\ExifIFD\SpectralSensitivity(),
                'ISO' => new \PHPExiftool\Driver\Tag\ExifIFD\ISO(),
                'Opto-ElectricConvFactor' => new \PHPExiftool\Driver\Tag\ExifIFD\OptoElectricConvFactor(),
                'Interlace' => new \PHPExiftool\Driver\Tag\ExifIFD\Interlace(),
                'TimeZoneOffset' => new \PHPExiftool\Driver\Tag\ExifIFD\TimeZoneOffset(),
                'SelfTimerMode' => new \PHPExiftool\Driver\Tag\ExifIFD\SelfTimerMode(),
                'SensitivityType' => new \PHPExiftool\Driver\Tag\ExifIFD\SensitivityType(),
                'StandardOutputSensitivity' => new \PHPExiftool\Driver\Tag\ExifIFD\StandardOutputSensitivity(),
                'RecommendedExposureIndex' => new \PHPExiftool\Driver\Tag\ExifIFD\RecommendedExposureIndex(),
                'ISOSpeed' => new \PHPExiftool\Driver\Tag\ExifIFD\ISOSpeed(),
                'ISOSpeedLatitudeyyy' => new \PHPExiftool\Driver\Tag\ExifIFD\ISOSpeedLatitudeyyy(),
                'ISOSpeedLatitudezzz' => new \PHPExiftool\Driver\Tag\ExifIFD\ISOSpeedLatitudezzz(),
                'FaxRecvParams' => new \PHPExiftool\Driver\Tag\ExifIFD\FaxRecvParams(),
                'FaxSubAddress' => new \PHPExiftool\Driver\Tag\ExifIFD\FaxSubAddress(),
                'FaxRecvTime' => new \PHPExiftool\Driver\Tag\ExifIFD\FaxRecvTime(),
                'FedexEDR' => new \PHPExiftool\Driver\Tag\ExifIFD\FedexEDR(),
                'ExifVersion' => new \PHPExiftool\Driver\Tag\ExifIFD\ExifVersion(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\ExifIFD\DateTimeOriginal(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\ExifIFD\CreateDate(),
                'GooglePlusUploadCode' => new \PHPExiftool\Driver\Tag\ExifIFD\GooglePlusUploadCode(),
                'ComponentsConfiguration' => new \PHPExiftool\Driver\Tag\ExifIFD\ComponentsConfiguration(),
                'CompressedBitsPerPixel' => new \PHPExiftool\Driver\Tag\ExifIFD\CompressedBitsPerPixel(),
                'ShutterSpeedValue' => new \PHPExiftool\Driver\Tag\ExifIFD\ShutterSpeedValue(),
                'ApertureValue' => new \PHPExiftool\Driver\Tag\ExifIFD\ApertureValue(),
                'BrightnessValue' => new \PHPExiftool\Driver\Tag\ExifIFD\BrightnessValue(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\ExifIFD\ExposureCompensation(),
                'MaxApertureValue' => new \PHPExiftool\Driver\Tag\ExifIFD\MaxApertureValue(),
                'SubjectDistance' => new \PHPExiftool\Driver\Tag\ExifIFD\SubjectDistance(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\ExifIFD\MeteringMode(),
                'LightSource' => new \PHPExiftool\Driver\Tag\ExifIFD\LightSource(),
                'Flash' => new \PHPExiftool\Driver\Tag\ExifIFD\Flash(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\ExifIFD\FocalLength(),
                'FlashEnergy' => new \PHPExiftool\Driver\Tag\ExifIFD\FlashEnergy(),
                'SpatialFrequencyResponse' => new \PHPExiftool\Driver\Tag\ExifIFD\SpatialFrequencyResponse(),
                'Noise' => new \PHPExiftool\Driver\Tag\ExifIFD\Noise(),
                'FocalPlaneXResolution' => new \PHPExiftool\Driver\Tag\ExifIFD\FocalPlaneXResolution(),
                'FocalPlaneYResolution' => new \PHPExiftool\Driver\Tag\ExifIFD\FocalPlaneYResolution(),
                'FocalPlaneResolutionUnit' => new \PHPExiftool\Driver\Tag\ExifIFD\FocalPlaneResolutionUnit(),
                'ImageNumber' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageNumber(),
                'SecurityClassification' => new \PHPExiftool\Driver\Tag\ExifIFD\SecurityClassification(),
                'ImageHistory' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageHistory(),
                'SubjectArea' => new \PHPExiftool\Driver\Tag\ExifIFD\SubjectArea(),
                'ExposureIndex' => new \PHPExiftool\Driver\Tag\ExifIFD\ExposureIndex(),
                'TIFF-EPStandardID' => new \PHPExiftool\Driver\Tag\ExifIFD\TIFFEPStandardID(),
                'SensingMethod' => new \PHPExiftool\Driver\Tag\ExifIFD\SensingMethod(),
                'CIP3DataFile' => new \PHPExiftool\Driver\Tag\ExifIFD\CIP3DataFile(),
                'CIP3Sheet' => new \PHPExiftool\Driver\Tag\ExifIFD\CIP3Sheet(),
                'CIP3Side' => new \PHPExiftool\Driver\Tag\ExifIFD\CIP3Side(),
                'StoNits' => new \PHPExiftool\Driver\Tag\ExifIFD\StoNits(),
                'UserComment' => new \PHPExiftool\Driver\Tag\ExifIFD\UserComment(),
                'SubSecTime' => new \PHPExiftool\Driver\Tag\ExifIFD\SubSecTime(),
                'SubSecTimeOriginal' => new \PHPExiftool\Driver\Tag\ExifIFD\SubSecTimeOriginal(),
                'SubSecTimeDigitized' => new \PHPExiftool\Driver\Tag\ExifIFD\SubSecTimeDigitized(),
                'MSDocumentText' => new \PHPExiftool\Driver\Tag\ExifIFD\MSDocumentText(),
                'MSPropertySetStorage' => new \PHPExiftool\Driver\Tag\ExifIFD\MSPropertySetStorage(),
                'MSDocumentTextPosition' => new \PHPExiftool\Driver\Tag\ExifIFD\MSDocumentTextPosition(),
                'FlashpixVersion' => new \PHPExiftool\Driver\Tag\ExifIFD\FlashpixVersion(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\ExifIFD\ColorSpace(),
                'ExifImageWidth' => new \PHPExiftool\Driver\Tag\ExifIFD\ExifImageWidth(),
                'ExifImageHeight' => new \PHPExiftool\Driver\Tag\ExifIFD\ExifImageHeight(),
                'RelatedSoundFile' => new \PHPExiftool\Driver\Tag\ExifIFD\RelatedSoundFile(),
                'SubjectLocation' => new \PHPExiftool\Driver\Tag\ExifIFD\SubjectLocation(),
                'FileSource' => new \PHPExiftool\Driver\Tag\ExifIFD\FileSource(),
                'SceneType' => new \PHPExiftool\Driver\Tag\ExifIFD\SceneType(),
                'CFAPattern' => new \PHPExiftool\Driver\Tag\ExifIFD\CFAPattern(),
                'CustomRendered' => new \PHPExiftool\Driver\Tag\ExifIFD\CustomRendered(),
                'ExposureMode' => new \PHPExiftool\Driver\Tag\ExifIFD\ExposureMode(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\ExifIFD\WhiteBalance(),
                'DigitalZoomRatio' => new \PHPExiftool\Driver\Tag\ExifIFD\DigitalZoomRatio(),
                'FocalLengthIn35mmFormat' => new \PHPExiftool\Driver\Tag\ExifIFD\FocalLengthIn35mmFormat(),
                'SceneCaptureType' => new \PHPExiftool\Driver\Tag\ExifIFD\SceneCaptureType(),
                'GainControl' => new \PHPExiftool\Driver\Tag\ExifIFD\GainControl(),
                'Contrast' => new \PHPExiftool\Driver\Tag\ExifIFD\Contrast(),
                'Saturation' => new \PHPExiftool\Driver\Tag\ExifIFD\Saturation(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\ExifIFD\Sharpness(),
                'DeviceSettingDescription' => new \PHPExiftool\Driver\Tag\ExifIFD\DeviceSettingDescription(),
                'SubjectDistanceRange' => new \PHPExiftool\Driver\Tag\ExifIFD\SubjectDistanceRange(),
                'ImageUniqueID' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageUniqueID(),
                'OwnerName' => new \PHPExiftool\Driver\Tag\ExifIFD\OwnerName(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\ExifIFD\SerialNumber(),
                'LensInfo' => new \PHPExiftool\Driver\Tag\ExifIFD\LensInfo(),
                'LensMake' => new \PHPExiftool\Driver\Tag\ExifIFD\LensMake(),
                'LensModel' => new \PHPExiftool\Driver\Tag\ExifIFD\LensModel(),
                'LensSerialNumber' => new \PHPExiftool\Driver\Tag\ExifIFD\LensSerialNumber(),
                'GDALMetadata' => new \PHPExiftool\Driver\Tag\ExifIFD\GDALMetadata(),
                'GDALNoData' => new \PHPExiftool\Driver\Tag\ExifIFD\GDALNoData(),
                'Gamma' => new \PHPExiftool\Driver\Tag\ExifIFD\Gamma(),
                'ExpandSoftware' => new \PHPExiftool\Driver\Tag\ExifIFD\ExpandSoftware(),
                'ExpandLens' => new \PHPExiftool\Driver\Tag\ExifIFD\ExpandLens(),
                'ExpandFilm' => new \PHPExiftool\Driver\Tag\ExifIFD\ExpandFilm(),
                'ExpandFilterLens' => new \PHPExiftool\Driver\Tag\ExifIFD\ExpandFilterLens(),
                'ExpandScanner' => new \PHPExiftool\Driver\Tag\ExifIFD\ExpandScanner(),
                'ExpandFlashLamp' => new \PHPExiftool\Driver\Tag\ExifIFD\ExpandFlashLamp(),
                'PixelFormat' => new \PHPExiftool\Driver\Tag\ExifIFD\PixelFormat(),
                'Transformation' => new \PHPExiftool\Driver\Tag\ExifIFD\Transformation(),
                'Uncompressed' => new \PHPExiftool\Driver\Tag\ExifIFD\Uncompressed(),
                'ImageType' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageType(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageHeight(),
                'WidthResolution' => new \PHPExiftool\Driver\Tag\ExifIFD\WidthResolution(),
                'HeightResolution' => new \PHPExiftool\Driver\Tag\ExifIFD\HeightResolution(),
                'ImageOffset' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageOffset(),
                'ImageByteCount' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageByteCount(),
                'AlphaOffset' => new \PHPExiftool\Driver\Tag\ExifIFD\AlphaOffset(),
                'AlphaByteCount' => new \PHPExiftool\Driver\Tag\ExifIFD\AlphaByteCount(),
                'ImageDataDiscard' => new \PHPExiftool\Driver\Tag\ExifIFD\ImageDataDiscard(),
                'AlphaDataDiscard' => new \PHPExiftool\Driver\Tag\ExifIFD\AlphaDataDiscard(),
                'OceScanjobDesc' => new \PHPExiftool\Driver\Tag\ExifIFD\OceScanjobDesc(),
                'OceApplicationSelector' => new \PHPExiftool\Driver\Tag\ExifIFD\OceApplicationSelector(),
                'OceIDNumber' => new \PHPExiftool\Driver\Tag\ExifIFD\OceIDNumber(),
                'OceImageLogic' => new \PHPExiftool\Driver\Tag\ExifIFD\OceImageLogic(),
                'Annotations' => new \PHPExiftool\Driver\Tag\ExifIFD\Annotations(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\ExifIFD\OriginalFileName(),
                'USPTOOriginalContentType' => new \PHPExiftool\Driver\Tag\ExifIFD\USPTOOriginalContentType(),
                'CFAPlaneColor' => new \PHPExiftool\Driver\Tag\ExifIFD\CFAPlaneColor(),
                'CFALayout' => new \PHPExiftool\Driver\Tag\ExifIFD\CFALayout(),
                'RawImageSegmentation' => new \PHPExiftool\Driver\Tag\ExifIFD\RawImageSegmentation(),
                'AliasLayerMetadata' => new \PHPExiftool\Driver\Tag\ExifIFD\AliasLayerMetadata(),
                'SRawType' => new \PHPExiftool\Driver\Tag\ExifIFD\SRawType(),
                'SubTileBlockSize' => new \PHPExiftool\Driver\Tag\ExifIFD\SubTileBlockSize(),
                'RowInterleaveFactor' => new \PHPExiftool\Driver\Tag\ExifIFD\RowInterleaveFactor(),
                'OpcodeList1' => new \PHPExiftool\Driver\Tag\ExifIFD\OpcodeList1(),
                'OpcodeList2' => new \PHPExiftool\Driver\Tag\ExifIFD\OpcodeList2(),
                'OpcodeList3' => new \PHPExiftool\Driver\Tag\ExifIFD\OpcodeList3(),
                'Padding' => new \PHPExiftool\Driver\Tag\ExifIFD\Padding(),
                'OffsetSchema' => new \PHPExiftool\Driver\Tag\ExifIFD\OffsetSchema(),
                'Lens' => new \PHPExiftool\Driver\Tag\ExifIFD\Lens(),
                'RawFile' => new \PHPExiftool\Driver\Tag\ExifIFD\RawFile(),
                'Converter' => new \PHPExiftool\Driver\Tag\ExifIFD\Converter(),
                'Exposure' => new \PHPExiftool\Driver\Tag\ExifIFD\Exposure(),
                'Shadows' => new \PHPExiftool\Driver\Tag\ExifIFD\Shadows(),
                'Brightness' => new \PHPExiftool\Driver\Tag\ExifIFD\Brightness(),
                'Smoothness' => new \PHPExiftool\Driver\Tag\ExifIFD\Smoothness(),
                'MoireFilter' => new \PHPExiftool\Driver\Tag\ExifIFD\MoireFilter(),
            );
        });
        $this['DNG'] = $this->share(function(){
            return array(
                'OriginalRawImage' => new \PHPExiftool\Driver\Tag\DNG\OriginalRawImage(),
                'OriginalRawResource' => new \PHPExiftool\Driver\Tag\DNG\OriginalRawResource(),
                'OriginalRawFileType' => new \PHPExiftool\Driver\Tag\DNG\OriginalRawFileType(),
                'OriginalRawCreator' => new \PHPExiftool\Driver\Tag\DNG\OriginalRawCreator(),
                'OriginalTHMImage' => new \PHPExiftool\Driver\Tag\DNG\OriginalTHMImage(),
                'OriginalTHMResource' => new \PHPExiftool\Driver\Tag\DNG\OriginalTHMResource(),
                'OriginalTHMFileType' => new \PHPExiftool\Driver\Tag\DNG\OriginalTHMFileType(),
                'OriginalTHMCreator' => new \PHPExiftool\Driver\Tag\DNG\OriginalTHMCreator(),
            );
        });
        $this['DV'] = $this->share(function(){
            return array(
                'AspectRatio' => new \PHPExiftool\Driver\Tag\DV\AspectRatio(),
                'AudioBitsPerSample' => new \PHPExiftool\Driver\Tag\DV\AudioBitsPerSample(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\DV\AudioChannels(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\DV\AudioSampleRate(),
                'Colorimetry' => new \PHPExiftool\Driver\Tag\DV\Colorimetry(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\DV\DateTimeOriginal(),
                'Duration' => new \PHPExiftool\Driver\Tag\DV\Duration(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\DV\FrameRate(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\DV\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\DV\ImageWidth(),
                'TotalBitrate' => new \PHPExiftool\Driver\Tag\DV\TotalBitrate(),
                'VideoFormat' => new \PHPExiftool\Driver\Tag\DV\VideoFormat(),
                'VideoScanType' => new \PHPExiftool\Driver\Tag\DV\VideoScanType(),
            );
        });
        $this['XMP-dwc'] = $this->share(function(){
            return array(
                'DCEvent' => new \PHPExiftool\Driver\Tag\XMPDwc\DCEvent(),
                'EventDay' => new \PHPExiftool\Driver\Tag\XMPDwc\EventDay(),
                'EventEarliestDate' => new \PHPExiftool\Driver\Tag\XMPDwc\EventEarliestDate(),
                'EventEndDayOfYear' => new \PHPExiftool\Driver\Tag\XMPDwc\EventEndDayOfYear(),
                'EventID' => new \PHPExiftool\Driver\Tag\XMPDwc\EventID(),
                'EventRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\EventRemarks(),
                'EventTime' => new \PHPExiftool\Driver\Tag\XMPDwc\EventTime(),
                'EventFieldNotes' => new \PHPExiftool\Driver\Tag\XMPDwc\EventFieldNotes(),
                'EventFieldNumber' => new \PHPExiftool\Driver\Tag\XMPDwc\EventFieldNumber(),
                'EventHabitat' => new \PHPExiftool\Driver\Tag\XMPDwc\EventHabitat(),
                'EventLatestDate' => new \PHPExiftool\Driver\Tag\XMPDwc\EventLatestDate(),
                'EventMonth' => new \PHPExiftool\Driver\Tag\XMPDwc\EventMonth(),
                'EventSamplingEffort' => new \PHPExiftool\Driver\Tag\XMPDwc\EventSamplingEffort(),
                'EventSamplingProtocol' => new \PHPExiftool\Driver\Tag\XMPDwc\EventSamplingProtocol(),
                'EventStartDayOfYear' => new \PHPExiftool\Driver\Tag\XMPDwc\EventStartDayOfYear(),
                'EventVerbatimEventDate' => new \PHPExiftool\Driver\Tag\XMPDwc\EventVerbatimEventDate(),
                'EventYear' => new \PHPExiftool\Driver\Tag\XMPDwc\EventYear(),
                'GeologicalContext' => new \PHPExiftool\Driver\Tag\XMPDwc\GeologicalContext(),
                'GeologicalContextBed' => new \PHPExiftool\Driver\Tag\XMPDwc\GeologicalContextBed(),
                'EarliestAgeOrLowestStage' => new \PHPExiftool\Driver\Tag\XMPDwc\EarliestAgeOrLowestStage(),
                'EarliestEonOrLowestEonothem' => new \PHPExiftool\Driver\Tag\XMPDwc\EarliestEonOrLowestEonothem(),
                'EarliestEpochOrLowestSeries' => new \PHPExiftool\Driver\Tag\XMPDwc\EarliestEpochOrLowestSeries(),
                'EarliestEraOrLowestErathem' => new \PHPExiftool\Driver\Tag\XMPDwc\EarliestEraOrLowestErathem(),
                'EarliestPeriodOrLowestSystem' => new \PHPExiftool\Driver\Tag\XMPDwc\EarliestPeriodOrLowestSystem(),
                'GeologicalContextFormation' => new \PHPExiftool\Driver\Tag\XMPDwc\GeologicalContextFormation(),
                'GeologicalContextID' => new \PHPExiftool\Driver\Tag\XMPDwc\GeologicalContextID(),
                'GeologicalContextGroup' => new \PHPExiftool\Driver\Tag\XMPDwc\GeologicalContextGroup(),
                'HighestBiostratigraphicZone' => new \PHPExiftool\Driver\Tag\XMPDwc\HighestBiostratigraphicZone(),
                'LatestAgeOrHighestStage' => new \PHPExiftool\Driver\Tag\XMPDwc\LatestAgeOrHighestStage(),
                'LatestEonOrHighestEonothem' => new \PHPExiftool\Driver\Tag\XMPDwc\LatestEonOrHighestEonothem(),
                'LatestEpochOrHighestSeries' => new \PHPExiftool\Driver\Tag\XMPDwc\LatestEpochOrHighestSeries(),
                'LatestEraOrHighestErathem' => new \PHPExiftool\Driver\Tag\XMPDwc\LatestEraOrHighestErathem(),
                'LatestPeriodOrHighestSystem' => new \PHPExiftool\Driver\Tag\XMPDwc\LatestPeriodOrHighestSystem(),
                'LithostratigraphicTerms' => new \PHPExiftool\Driver\Tag\XMPDwc\LithostratigraphicTerms(),
                'LowestBiostratigraphicZone' => new \PHPExiftool\Driver\Tag\XMPDwc\LowestBiostratigraphicZone(),
                'GeologicalContextMember' => new \PHPExiftool\Driver\Tag\XMPDwc\GeologicalContextMember(),
                'Identification' => new \PHPExiftool\Driver\Tag\XMPDwc\Identification(),
                'DateIdentified' => new \PHPExiftool\Driver\Tag\XMPDwc\DateIdentified(),
                'IdentificationID' => new \PHPExiftool\Driver\Tag\XMPDwc\IdentificationID(),
                'IdentificationQualifier' => new \PHPExiftool\Driver\Tag\XMPDwc\IdentificationQualifier(),
                'IdentificationReferences' => new \PHPExiftool\Driver\Tag\XMPDwc\IdentificationReferences(),
                'IdentificationRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\IdentificationRemarks(),
                'IdentificationVerificationStatus' => new \PHPExiftool\Driver\Tag\XMPDwc\IdentificationVerificationStatus(),
                'IdentifiedBy' => new \PHPExiftool\Driver\Tag\XMPDwc\IdentifiedBy(),
                'TypeStatus' => new \PHPExiftool\Driver\Tag\XMPDwc\TypeStatus(),
                'MeasurementOrFact' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementOrFact(),
                'MeasurementAccuracy' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementAccuracy(),
                'MeasurementDeterminedBy' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementDeterminedBy(),
                'MeasurementDeterminedDate' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementDeterminedDate(),
                'MeasurementID' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementID(),
                'MeasurementMethod' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementMethod(),
                'MeasurementRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementRemarks(),
                'MeasurementType' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementType(),
                'MeasurementUnit' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementUnit(),
                'MeasurementValue' => new \PHPExiftool\Driver\Tag\XMPDwc\MeasurementValue(),
                'Occurrence' => new \PHPExiftool\Driver\Tag\XMPDwc\Occurrence(),
                'OccurrenceAssociatedMedia' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceAssociatedMedia(),
                'OccurrenceAssociatedOccurrences' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceAssociatedOccurrences(),
                'OccurrenceAssociatedReferences' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceAssociatedReferences(),
                'OccurrenceAssociatedSequences' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceAssociatedSequences(),
                'OccurrenceAssociatedTaxa' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceAssociatedTaxa(),
                'OccurrenceBehavior' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceBehavior(),
                'OccurrenceCatalogNumber' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceCatalogNumber(),
                'OccurrenceDisposition' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceDisposition(),
                'OccurrenceEstablishmentMeans' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceEstablishmentMeans(),
                'OccurrenceIndividualCount' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceIndividualCount(),
                'OccurrenceIndividualID' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceIndividualID(),
                'OccurrenceLifeStage' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceLifeStage(),
                'OccurrenceDetails' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceDetails(),
                'OccurrenceID' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceID(),
                'OccurrenceRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceRemarks(),
                'OccurrenceStatus' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceStatus(),
                'OccurrenceOtherCatalogNumbers' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceOtherCatalogNumbers(),
                'OccurrencePreparations' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrencePreparations(),
                'OccurrencePreviousIdentifications' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrencePreviousIdentifications(),
                'OccurrenceRecordNumber' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceRecordNumber(),
                'OccurrenceRecordedBy' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceRecordedBy(),
                'OccurrenceReproductiveCondition' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceReproductiveCondition(),
                'OccurrenceSex' => new \PHPExiftool\Driver\Tag\XMPDwc\OccurrenceSex(),
                'Record' => new \PHPExiftool\Driver\Tag\XMPDwc\Record(),
                'RecordBasisOfRecord' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordBasisOfRecord(),
                'RecordCollectionCode' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordCollectionCode(),
                'RecordCollectionID' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordCollectionID(),
                'RecordDataGeneralizations' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordDataGeneralizations(),
                'RecordDatasetID' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordDatasetID(),
                'RecordDatasetName' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordDatasetName(),
                'RecordDynamicProperties' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordDynamicProperties(),
                'RecordInformationWithheld' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordInformationWithheld(),
                'RecordInstitutionCode' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordInstitutionCode(),
                'RecordInstitutionID' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordInstitutionID(),
                'RecordOwnerInstitutionCode' => new \PHPExiftool\Driver\Tag\XMPDwc\RecordOwnerInstitutionCode(),
                'ResourceRelationship' => new \PHPExiftool\Driver\Tag\XMPDwc\ResourceRelationship(),
                'RelatedResourceID' => new \PHPExiftool\Driver\Tag\XMPDwc\RelatedResourceID(),
                'RelationshipAccordingTo' => new \PHPExiftool\Driver\Tag\XMPDwc\RelationshipAccordingTo(),
                'RelationshipEstablishedDate' => new \PHPExiftool\Driver\Tag\XMPDwc\RelationshipEstablishedDate(),
                'RelationshipOfResource' => new \PHPExiftool\Driver\Tag\XMPDwc\RelationshipOfResource(),
                'RelationshipRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\RelationshipRemarks(),
                'ResourceID' => new \PHPExiftool\Driver\Tag\XMPDwc\ResourceID(),
                'ResourceRelationshipID' => new \PHPExiftool\Driver\Tag\XMPDwc\ResourceRelationshipID(),
                'Taxon' => new \PHPExiftool\Driver\Tag\XMPDwc\Taxon(),
                'TaxonAcceptedNameUsage' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonAcceptedNameUsage(),
                'TaxonAcceptedNameUsageID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonAcceptedNameUsageID(),
                'TaxonClass' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonClass(),
                'TaxonFamily' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonFamily(),
                'TaxonGenus' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonGenus(),
                'TaxonHigherClassification' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonHigherClassification(),
                'TaxonInfraspecificEpithet' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonInfraspecificEpithet(),
                'TaxonKingdom' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonKingdom(),
                'TaxonNameAccordingTo' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNameAccordingTo(),
                'TaxonNameAccordingToID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNameAccordingToID(),
                'TaxonNamePublishedIn' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNamePublishedIn(),
                'TaxonNamePublishedInID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNamePublishedInID(),
                'TaxonNamePublishedInYear' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNamePublishedInYear(),
                'TaxonNomenclaturalCode' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNomenclaturalCode(),
                'TaxonNomenclaturalStatus' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonNomenclaturalStatus(),
                'TaxonOrder' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonOrder(),
                'TaxonOriginalNameUsage' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonOriginalNameUsage(),
                'TaxonOriginalNameUsageID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonOriginalNameUsageID(),
                'TaxonParentNameUsage' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonParentNameUsage(),
                'TaxonParentNameUsageID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonParentNameUsageID(),
                'TaxonPhylum' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonPhylum(),
                'TaxonScientificName' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonScientificName(),
                'TaxonScientificNameAuthorship' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonScientificNameAuthorship(),
                'TaxonScientificNameID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonScientificNameID(),
                'TaxonSpecificEpithet' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonSpecificEpithet(),
                'TaxonSubgenus' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonSubgenus(),
                'TaxonConceptID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonConceptID(),
                'TaxonID' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonID(),
                'TaxonRank' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonRank(),
                'TaxonRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonRemarks(),
                'TaxonTaxonomicStatus' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonTaxonomicStatus(),
                'TaxonVerbatimTaxonRank' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonVerbatimTaxonRank(),
                'TaxonVernacularName' => new \PHPExiftool\Driver\Tag\XMPDwc\TaxonVernacularName(),
                'DCTermsLocation' => new \PHPExiftool\Driver\Tag\XMPDwc\DCTermsLocation(),
                'DCContinent' => new \PHPExiftool\Driver\Tag\XMPDwc\DCContinent(),
                'DCCoordinatePrecision' => new \PHPExiftool\Driver\Tag\XMPDwc\DCCoordinatePrecision(),
                'DCCoordinateUncertaintyInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCCoordinateUncertaintyInMeters(),
                'DCCountry' => new \PHPExiftool\Driver\Tag\XMPDwc\DCCountry(),
                'DCCountryCode' => new \PHPExiftool\Driver\Tag\XMPDwc\DCCountryCode(),
                'DCCounty' => new \PHPExiftool\Driver\Tag\XMPDwc\DCCounty(),
                'DCDecimalLatitude' => new \PHPExiftool\Driver\Tag\XMPDwc\DCDecimalLatitude(),
                'DCDecimalLongitude' => new \PHPExiftool\Driver\Tag\XMPDwc\DCDecimalLongitude(),
                'DCFootprintSRS' => new \PHPExiftool\Driver\Tag\XMPDwc\DCFootprintSRS(),
                'DCFootprintSpatialFit' => new \PHPExiftool\Driver\Tag\XMPDwc\DCFootprintSpatialFit(),
                'DCFootprintWKT' => new \PHPExiftool\Driver\Tag\XMPDwc\DCFootprintWKT(),
                'DCGeodeticDatum' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeodeticDatum(),
                'DCGeoreferenceProtocol' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeoreferenceProtocol(),
                'DCGeoreferenceRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeoreferenceRemarks(),
                'DCGeoreferenceSources' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeoreferenceSources(),
                'DCGeoreferenceVerificationStatus' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeoreferenceVerificationStatus(),
                'DCGeoreferencedBy' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeoreferencedBy(),
                'DCGeoreferencedDate' => new \PHPExiftool\Driver\Tag\XMPDwc\DCGeoreferencedDate(),
                'DCHigherGeography' => new \PHPExiftool\Driver\Tag\XMPDwc\DCHigherGeography(),
                'DCHigherGeographyID' => new \PHPExiftool\Driver\Tag\XMPDwc\DCHigherGeographyID(),
                'DCIsland' => new \PHPExiftool\Driver\Tag\XMPDwc\DCIsland(),
                'DCIslandGroup' => new \PHPExiftool\Driver\Tag\XMPDwc\DCIslandGroup(),
                'DCLocality' => new \PHPExiftool\Driver\Tag\XMPDwc\DCLocality(),
                'DCLocationAccordingTo' => new \PHPExiftool\Driver\Tag\XMPDwc\DCLocationAccordingTo(),
                'DCLocationID' => new \PHPExiftool\Driver\Tag\XMPDwc\DCLocationID(),
                'DCLocationRemarks' => new \PHPExiftool\Driver\Tag\XMPDwc\DCLocationRemarks(),
                'DCMaximumDepthInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMaximumDepthInMeters(),
                'DCMaximumDistanceAboveSurfaceInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMaximumDistanceAboveSurfaceInMeters(),
                'DCMaximumElevationInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMaximumElevationInMeters(),
                'DCMinimumDepthInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMinimumDepthInMeters(),
                'DCMinimumDistanceAboveSurfaceInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMinimumDistanceAboveSurfaceInMeters(),
                'DCMinimumElevationInMeters' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMinimumElevationInMeters(),
                'DCMunicipality' => new \PHPExiftool\Driver\Tag\XMPDwc\DCMunicipality(),
                'DCPointRadiusSpatialFit' => new \PHPExiftool\Driver\Tag\XMPDwc\DCPointRadiusSpatialFit(),
                'DCStateProvince' => new \PHPExiftool\Driver\Tag\XMPDwc\DCStateProvince(),
                'DCVerbatimCoordinateSystem' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimCoordinateSystem(),
                'DCVerbatimCoordinates' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimCoordinates(),
                'DCVerbatimDepth' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimDepth(),
                'DCVerbatimElevation' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimElevation(),
                'DCVerbatimLatitude' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimLatitude(),
                'DCVerbatimLocality' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimLocality(),
                'DCVerbatimLongitude' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimLongitude(),
                'DCVerbatimSRS' => new \PHPExiftool\Driver\Tag\XMPDwc\DCVerbatimSRS(),
                'DCWaterBody' => new \PHPExiftool\Driver\Tag\XMPDwc\DCWaterBody(),
            );
        });
        $this['DjVu'] = $this->share(function(){
            return array(
                'SubfileType' => new \PHPExiftool\Driver\Tag\DjVu\SubfileType(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\DjVu\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\DjVu\ImageHeight(),
                'DjVuVersion' => new \PHPExiftool\Driver\Tag\DjVu\DjVuVersion(),
                'SpatialResolution' => new \PHPExiftool\Driver\Tag\DjVu\SpatialResolution(),
                'Gamma' => new \PHPExiftool\Driver\Tag\DjVu\Gamma(),
                'Orientation' => new \PHPExiftool\Driver\Tag\DjVu\Orientation(),
                'IncludedFileID' => new \PHPExiftool\Driver\Tag\DjVu\IncludedFileID(),
            );
        });
        $this['DjVu-Meta'] = $this->share(function(){
            return array(
                'Author' => new \PHPExiftool\Driver\Tag\DjVuMeta\Author(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\DjVuMeta\CreateDate(),
                'Creator' => new \PHPExiftool\Driver\Tag\DjVuMeta\Creator(),
                'Keywords' => new \PHPExiftool\Driver\Tag\DjVuMeta\Keywords(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\DjVuMeta\ModifyDate(),
                'Producer' => new \PHPExiftool\Driver\Tag\DjVuMeta\Producer(),
                'Subject' => new \PHPExiftool\Driver\Tag\DjVuMeta\Subject(),
                'Title' => new \PHPExiftool\Driver\Tag\DjVuMeta\Title(),
                'Trapped' => new \PHPExiftool\Driver\Tag\DjVuMeta\Trapped(),
                'Address' => new \PHPExiftool\Driver\Tag\DjVuMeta\Address(),
                'Annotation' => new \PHPExiftool\Driver\Tag\DjVuMeta\Annotation(),
                'BookTitle' => new \PHPExiftool\Driver\Tag\DjVuMeta\BookTitle(),
                'Chapter' => new \PHPExiftool\Driver\Tag\DjVuMeta\Chapter(),
                'CrossRef' => new \PHPExiftool\Driver\Tag\DjVuMeta\CrossRef(),
                'Edition' => new \PHPExiftool\Driver\Tag\DjVuMeta\Edition(),
                'EPrint' => new \PHPExiftool\Driver\Tag\DjVuMeta\EPrint(),
                'HowPublished' => new \PHPExiftool\Driver\Tag\DjVuMeta\HowPublished(),
                'Institution' => new \PHPExiftool\Driver\Tag\DjVuMeta\Institution(),
                'Journal' => new \PHPExiftool\Driver\Tag\DjVuMeta\Journal(),
                'Key' => new \PHPExiftool\Driver\Tag\DjVuMeta\Key(),
                'Month' => new \PHPExiftool\Driver\Tag\DjVuMeta\Month(),
                'Note' => new \PHPExiftool\Driver\Tag\DjVuMeta\Note(),
                'Number' => new \PHPExiftool\Driver\Tag\DjVuMeta\Number(),
                'Organization' => new \PHPExiftool\Driver\Tag\DjVuMeta\Organization(),
                'Pages' => new \PHPExiftool\Driver\Tag\DjVuMeta\Pages(),
                'Publisher' => new \PHPExiftool\Driver\Tag\DjVuMeta\Publisher(),
                'School' => new \PHPExiftool\Driver\Tag\DjVuMeta\School(),
                'Series' => new \PHPExiftool\Driver\Tag\DjVuMeta\Series(),
                'Type' => new \PHPExiftool\Driver\Tag\DjVuMeta\Type(),
                'URL' => new \PHPExiftool\Driver\Tag\DjVuMeta\URL(),
                'Volume' => new \PHPExiftool\Driver\Tag\DjVuMeta\Volume(),
                'Year' => new \PHPExiftool\Driver\Tag\DjVuMeta\Year(),
            );
        });
        $this['EXE'] = $this->share(function(){
            return array(
                'CHMVersion' => new \PHPExiftool\Driver\Tag\EXE\CHMVersion(),
                'LanguageCode' => new \PHPExiftool\Driver\Tag\EXE\LanguageCode(),
                'CPUArchitecture' => new \PHPExiftool\Driver\Tag\EXE\CPUArchitecture(),
                'CPUByteOrder' => new \PHPExiftool\Driver\Tag\EXE\CPUByteOrder(),
                'ObjectFileType' => new \PHPExiftool\Driver\Tag\EXE\ObjectFileType(),
                'CPUType' => new \PHPExiftool\Driver\Tag\EXE\CPUType(),
                'CPUCount' => new \PHPExiftool\Driver\Tag\EXE\CPUCount(),
                'CPUSubtype' => new \PHPExiftool\Driver\Tag\EXE\CPUSubtype(),
                'MachineType' => new \PHPExiftool\Driver\Tag\EXE\MachineType(),
                'TimeStamp' => new \PHPExiftool\Driver\Tag\EXE\TimeStamp(),
                'PEType' => new \PHPExiftool\Driver\Tag\EXE\PEType(),
                'LinkerVersion' => new \PHPExiftool\Driver\Tag\EXE\LinkerVersion(),
                'CodeSize' => new \PHPExiftool\Driver\Tag\EXE\CodeSize(),
                'InitializedDataSize' => new \PHPExiftool\Driver\Tag\EXE\InitializedDataSize(),
                'UninitializedDataSize' => new \PHPExiftool\Driver\Tag\EXE\UninitializedDataSize(),
                'EntryPoint' => new \PHPExiftool\Driver\Tag\EXE\EntryPoint(),
                'OSVersion' => new \PHPExiftool\Driver\Tag\EXE\OSVersion(),
                'ImageVersion' => new \PHPExiftool\Driver\Tag\EXE\ImageVersion(),
                'SubsystemVersion' => new \PHPExiftool\Driver\Tag\EXE\SubsystemVersion(),
                'Subsystem' => new \PHPExiftool\Driver\Tag\EXE\Subsystem(),
                'PEFVersion' => new \PHPExiftool\Driver\Tag\EXE\PEFVersion(),
                'BuildDate' => new \PHPExiftool\Driver\Tag\EXE\BuildDate(),
                'BuildVersion' => new \PHPExiftool\Driver\Tag\EXE\BuildVersion(),
                'CharacterSet' => new \PHPExiftool\Driver\Tag\EXE\CharacterSet(),
                'Comments' => new \PHPExiftool\Driver\Tag\EXE\Comments(),
                'CompanyName' => new \PHPExiftool\Driver\Tag\EXE\CompanyName(),
                'Copyright' => new \PHPExiftool\Driver\Tag\EXE\Copyright(),
                'FileDescription' => new \PHPExiftool\Driver\Tag\EXE\FileDescription(),
                'FileVersion' => new \PHPExiftool\Driver\Tag\EXE\FileVersion(),
                'InternalName' => new \PHPExiftool\Driver\Tag\EXE\InternalName(),
                'LegalCopyright' => new \PHPExiftool\Driver\Tag\EXE\LegalCopyright(),
                'LegalTrademarks' => new \PHPExiftool\Driver\Tag\EXE\LegalTrademarks(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\EXE\OriginalFileName(),
                'PrivateBuild' => new \PHPExiftool\Driver\Tag\EXE\PrivateBuild(),
                'ProductName' => new \PHPExiftool\Driver\Tag\EXE\ProductName(),
                'ProductVersion' => new \PHPExiftool\Driver\Tag\EXE\ProductVersion(),
                'SpecialBuild' => new \PHPExiftool\Driver\Tag\EXE\SpecialBuild(),
                'FileVersionNumber' => new \PHPExiftool\Driver\Tag\EXE\FileVersionNumber(),
                'ProductVersionNumber' => new \PHPExiftool\Driver\Tag\EXE\ProductVersionNumber(),
                'FileFlagsMask' => new \PHPExiftool\Driver\Tag\EXE\FileFlagsMask(),
                'FileFlags' => new \PHPExiftool\Driver\Tag\EXE\FileFlags(),
                'FileOS' => new \PHPExiftool\Driver\Tag\EXE\FileOS(),
                'FileSubtype' => new \PHPExiftool\Driver\Tag\EXE\FileSubtype(),
            );
        });
        $this['InteropIFD'] = $this->share(function(){
            return array(
                'InteropIndex' => new \PHPExiftool\Driver\Tag\InteropIFD\InteropIndex(),
                'InteropVersion' => new \PHPExiftool\Driver\Tag\InteropIFD\InteropVersion(),
                'RelatedImageFileFormat' => new \PHPExiftool\Driver\Tag\InteropIFD\RelatedImageFileFormat(),
                'RelatedImageWidth' => new \PHPExiftool\Driver\Tag\InteropIFD\RelatedImageWidth(),
                'RelatedImageHeight' => new \PHPExiftool\Driver\Tag\InteropIFD\RelatedImageHeight(),
            );
        });
        $this['IFD0'] = $this->share(function(){
            return array(
                'ProcessingSoftware' => new \PHPExiftool\Driver\Tag\IFD0\ProcessingSoftware(),
                'SubfileType' => new \PHPExiftool\Driver\Tag\IFD0\SubfileType(),
                'OldSubfileType' => new \PHPExiftool\Driver\Tag\IFD0\OldSubfileType(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\IFD0\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\IFD0\ImageHeight(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\IFD0\BitsPerSample(),
                'Compression' => new \PHPExiftool\Driver\Tag\IFD0\Compression(),
                'PhotometricInterpretation' => new \PHPExiftool\Driver\Tag\IFD0\PhotometricInterpretation(),
                'Thresholding' => new \PHPExiftool\Driver\Tag\IFD0\Thresholding(),
                'CellWidth' => new \PHPExiftool\Driver\Tag\IFD0\CellWidth(),
                'CellLength' => new \PHPExiftool\Driver\Tag\IFD0\CellLength(),
                'FillOrder' => new \PHPExiftool\Driver\Tag\IFD0\FillOrder(),
                'DocumentName' => new \PHPExiftool\Driver\Tag\IFD0\DocumentName(),
                'ImageDescription' => new \PHPExiftool\Driver\Tag\IFD0\ImageDescription(),
                'Make' => new \PHPExiftool\Driver\Tag\IFD0\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\IFD0\Model(),
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\IFD0\PreviewImageStart(),
                'Orientation' => new \PHPExiftool\Driver\Tag\IFD0\Orientation(),
                'SamplesPerPixel' => new \PHPExiftool\Driver\Tag\IFD0\SamplesPerPixel(),
                'RowsPerStrip' => new \PHPExiftool\Driver\Tag\IFD0\RowsPerStrip(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\IFD0\PreviewImageLength(),
                'MinSampleValue' => new \PHPExiftool\Driver\Tag\IFD0\MinSampleValue(),
                'MaxSampleValue' => new \PHPExiftool\Driver\Tag\IFD0\MaxSampleValue(),
                'XResolution' => new \PHPExiftool\Driver\Tag\IFD0\XResolution(),
                'YResolution' => new \PHPExiftool\Driver\Tag\IFD0\YResolution(),
                'PlanarConfiguration' => new \PHPExiftool\Driver\Tag\IFD0\PlanarConfiguration(),
                'PageName' => new \PHPExiftool\Driver\Tag\IFD0\PageName(),
                'XPosition' => new \PHPExiftool\Driver\Tag\IFD0\XPosition(),
                'YPosition' => new \PHPExiftool\Driver\Tag\IFD0\YPosition(),
                'GrayResponseUnit' => new \PHPExiftool\Driver\Tag\IFD0\GrayResponseUnit(),
                'ResolutionUnit' => new \PHPExiftool\Driver\Tag\IFD0\ResolutionUnit(),
                'PageNumber' => new \PHPExiftool\Driver\Tag\IFD0\PageNumber(),
                'TransferFunction' => new \PHPExiftool\Driver\Tag\IFD0\TransferFunction(),
                'Software' => new \PHPExiftool\Driver\Tag\IFD0\Software(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\IFD0\ModifyDate(),
                'Artist' => new \PHPExiftool\Driver\Tag\IFD0\Artist(),
                'HostComputer' => new \PHPExiftool\Driver\Tag\IFD0\HostComputer(),
                'Predictor' => new \PHPExiftool\Driver\Tag\IFD0\Predictor(),
                'WhitePoint' => new \PHPExiftool\Driver\Tag\IFD0\WhitePoint(),
                'PrimaryChromaticities' => new \PHPExiftool\Driver\Tag\IFD0\PrimaryChromaticities(),
                'HalftoneHints' => new \PHPExiftool\Driver\Tag\IFD0\HalftoneHints(),
                'TileWidth' => new \PHPExiftool\Driver\Tag\IFD0\TileWidth(),
                'TileLength' => new \PHPExiftool\Driver\Tag\IFD0\TileLength(),
                'InkSet' => new \PHPExiftool\Driver\Tag\IFD0\InkSet(),
                'DotRange' => new \PHPExiftool\Driver\Tag\IFD0\DotRange(),
                'ThumbnailOffset' => new \PHPExiftool\Driver\Tag\IFD0\ThumbnailOffset(),
                'ThumbnailLength' => new \PHPExiftool\Driver\Tag\IFD0\ThumbnailLength(),
                'YCbCrCoefficients' => new \PHPExiftool\Driver\Tag\IFD0\YCbCrCoefficients(),
                'YCbCrSubSampling' => new \PHPExiftool\Driver\Tag\IFD0\YCbCrSubSampling(),
                'YCbCrPositioning' => new \PHPExiftool\Driver\Tag\IFD0\YCbCrPositioning(),
                'ReferenceBlackWhite' => new \PHPExiftool\Driver\Tag\IFD0\ReferenceBlackWhite(),
                'Rating' => new \PHPExiftool\Driver\Tag\IFD0\Rating(),
                'RatingPercent' => new \PHPExiftool\Driver\Tag\IFD0\RatingPercent(),
                'Copyright' => new \PHPExiftool\Driver\Tag\IFD0\Copyright(),
                'IPTC-NAA' => new \PHPExiftool\Driver\Tag\IFD0\IPTCNAA(),
                'SEMInfo' => new \PHPExiftool\Driver\Tag\IFD0\SEMInfo(),
                'GeoTiffDirectory' => new \PHPExiftool\Driver\Tag\IFD0\GeoTiffDirectory(),
                'GeoTiffDoubleParams' => new \PHPExiftool\Driver\Tag\IFD0\GeoTiffDoubleParams(),
                'GeoTiffAsciiParams' => new \PHPExiftool\Driver\Tag\IFD0\GeoTiffAsciiParams(),
                'ImageSourceData' => new \PHPExiftool\Driver\Tag\IFD0\ImageSourceData(),
                'XPTitle' => new \PHPExiftool\Driver\Tag\IFD0\XPTitle(),
                'XPComment' => new \PHPExiftool\Driver\Tag\IFD0\XPComment(),
                'XPAuthor' => new \PHPExiftool\Driver\Tag\IFD0\XPAuthor(),
                'XPKeywords' => new \PHPExiftool\Driver\Tag\IFD0\XPKeywords(),
                'XPSubject' => new \PHPExiftool\Driver\Tag\IFD0\XPSubject(),
                'PrintIM' => new \PHPExiftool\Driver\Tag\IFD0\PrintIM(),
                'DNGVersion' => new \PHPExiftool\Driver\Tag\IFD0\DNGVersion(),
                'DNGBackwardVersion' => new \PHPExiftool\Driver\Tag\IFD0\DNGBackwardVersion(),
                'UniqueCameraModel' => new \PHPExiftool\Driver\Tag\IFD0\UniqueCameraModel(),
                'LocalizedCameraModel' => new \PHPExiftool\Driver\Tag\IFD0\LocalizedCameraModel(),
                'ColorMatrix1' => new \PHPExiftool\Driver\Tag\IFD0\ColorMatrix1(),
                'ColorMatrix2' => new \PHPExiftool\Driver\Tag\IFD0\ColorMatrix2(),
                'CameraCalibration1' => new \PHPExiftool\Driver\Tag\IFD0\CameraCalibration1(),
                'CameraCalibration2' => new \PHPExiftool\Driver\Tag\IFD0\CameraCalibration2(),
                'ReductionMatrix1' => new \PHPExiftool\Driver\Tag\IFD0\ReductionMatrix1(),
                'ReductionMatrix2' => new \PHPExiftool\Driver\Tag\IFD0\ReductionMatrix2(),
                'AnalogBalance' => new \PHPExiftool\Driver\Tag\IFD0\AnalogBalance(),
                'AsShotNeutral' => new \PHPExiftool\Driver\Tag\IFD0\AsShotNeutral(),
                'AsShotWhiteXY' => new \PHPExiftool\Driver\Tag\IFD0\AsShotWhiteXY(),
                'BaselineExposure' => new \PHPExiftool\Driver\Tag\IFD0\BaselineExposure(),
                'BaselineNoise' => new \PHPExiftool\Driver\Tag\IFD0\BaselineNoise(),
                'BaselineSharpness' => new \PHPExiftool\Driver\Tag\IFD0\BaselineSharpness(),
                'LinearResponseLimit' => new \PHPExiftool\Driver\Tag\IFD0\LinearResponseLimit(),
                'CameraSerialNumber' => new \PHPExiftool\Driver\Tag\IFD0\CameraSerialNumber(),
                'DNGLensInfo' => new \PHPExiftool\Driver\Tag\IFD0\DNGLensInfo(),
                'ShadowScale' => new \PHPExiftool\Driver\Tag\IFD0\ShadowScale(),
                'DNGAdobeData' => new \PHPExiftool\Driver\Tag\IFD0\DNGAdobeData(),
                'DNGPrivateData' => new \PHPExiftool\Driver\Tag\IFD0\DNGPrivateData(),
                'MakerNoteSafety' => new \PHPExiftool\Driver\Tag\IFD0\MakerNoteSafety(),
                'CalibrationIlluminant1' => new \PHPExiftool\Driver\Tag\IFD0\CalibrationIlluminant1(),
                'CalibrationIlluminant2' => new \PHPExiftool\Driver\Tag\IFD0\CalibrationIlluminant2(),
                'RawDataUniqueID' => new \PHPExiftool\Driver\Tag\IFD0\RawDataUniqueID(),
                'OriginalRawFileName' => new \PHPExiftool\Driver\Tag\IFD0\OriginalRawFileName(),
                'OriginalRawFileData' => new \PHPExiftool\Driver\Tag\IFD0\OriginalRawFileData(),
                'AsShotICCProfile' => new \PHPExiftool\Driver\Tag\IFD0\AsShotICCProfile(),
                'AsShotPreProfileMatrix' => new \PHPExiftool\Driver\Tag\IFD0\AsShotPreProfileMatrix(),
                'CurrentICCProfile' => new \PHPExiftool\Driver\Tag\IFD0\CurrentICCProfile(),
                'CurrentPreProfileMatrix' => new \PHPExiftool\Driver\Tag\IFD0\CurrentPreProfileMatrix(),
                'ColorimetricReference' => new \PHPExiftool\Driver\Tag\IFD0\ColorimetricReference(),
                'PanasonicTitle' => new \PHPExiftool\Driver\Tag\IFD0\PanasonicTitle(),
                'PanasonicTitle2' => new \PHPExiftool\Driver\Tag\IFD0\PanasonicTitle2(),
                'CameraCalibrationSig' => new \PHPExiftool\Driver\Tag\IFD0\CameraCalibrationSig(),
                'ProfileCalibrationSig' => new \PHPExiftool\Driver\Tag\IFD0\ProfileCalibrationSig(),
                'AsShotProfileName' => new \PHPExiftool\Driver\Tag\IFD0\AsShotProfileName(),
                'ProfileName' => new \PHPExiftool\Driver\Tag\IFD0\ProfileName(),
                'ProfileHueSatMapDims' => new \PHPExiftool\Driver\Tag\IFD0\ProfileHueSatMapDims(),
                'ProfileHueSatMapData1' => new \PHPExiftool\Driver\Tag\IFD0\ProfileHueSatMapData1(),
                'ProfileHueSatMapData2' => new \PHPExiftool\Driver\Tag\IFD0\ProfileHueSatMapData2(),
                'ProfileToneCurve' => new \PHPExiftool\Driver\Tag\IFD0\ProfileToneCurve(),
                'ProfileEmbedPolicy' => new \PHPExiftool\Driver\Tag\IFD0\ProfileEmbedPolicy(),
                'ProfileCopyright' => new \PHPExiftool\Driver\Tag\IFD0\ProfileCopyright(),
                'ForwardMatrix1' => new \PHPExiftool\Driver\Tag\IFD0\ForwardMatrix1(),
                'ForwardMatrix2' => new \PHPExiftool\Driver\Tag\IFD0\ForwardMatrix2(),
                'PreviewApplicationName' => new \PHPExiftool\Driver\Tag\IFD0\PreviewApplicationName(),
                'PreviewApplicationVersion' => new \PHPExiftool\Driver\Tag\IFD0\PreviewApplicationVersion(),
                'PreviewSettingsName' => new \PHPExiftool\Driver\Tag\IFD0\PreviewSettingsName(),
                'PreviewSettingsDigest' => new \PHPExiftool\Driver\Tag\IFD0\PreviewSettingsDigest(),
                'PreviewColorSpace' => new \PHPExiftool\Driver\Tag\IFD0\PreviewColorSpace(),
                'PreviewDateTime' => new \PHPExiftool\Driver\Tag\IFD0\PreviewDateTime(),
                'RawImageDigest' => new \PHPExiftool\Driver\Tag\IFD0\RawImageDigest(),
                'OriginalRawFileDigest' => new \PHPExiftool\Driver\Tag\IFD0\OriginalRawFileDigest(),
                'ProfileLookTableDims' => new \PHPExiftool\Driver\Tag\IFD0\ProfileLookTableDims(),
                'ProfileLookTableData' => new \PHPExiftool\Driver\Tag\IFD0\ProfileLookTableData(),
                'TimeCodes' => new \PHPExiftool\Driver\Tag\IFD0\TimeCodes(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\IFD0\FrameRate(),
                'TStop' => new \PHPExiftool\Driver\Tag\IFD0\TStop(),
                'ReelName' => new \PHPExiftool\Driver\Tag\IFD0\ReelName(),
                'OriginalDefaultFinalSize' => new \PHPExiftool\Driver\Tag\IFD0\OriginalDefaultFinalSize(),
                'OriginalBestQualitySize' => new \PHPExiftool\Driver\Tag\IFD0\OriginalBestQualitySize(),
                'OriginalDefaultCropSize' => new \PHPExiftool\Driver\Tag\IFD0\OriginalDefaultCropSize(),
                'CameraLabel' => new \PHPExiftool\Driver\Tag\IFD0\CameraLabel(),
                'ProfileHueSatMapEncoding' => new \PHPExiftool\Driver\Tag\IFD0\ProfileHueSatMapEncoding(),
                'ProfileLookTableEncoding' => new \PHPExiftool\Driver\Tag\IFD0\ProfileLookTableEncoding(),
                'BaselineExposureOffset' => new \PHPExiftool\Driver\Tag\IFD0\BaselineExposureOffset(),
                'DefaultBlackRender' => new \PHPExiftool\Driver\Tag\IFD0\DefaultBlackRender(),
                'NewRawImageDigest' => new \PHPExiftool\Driver\Tag\IFD0\NewRawImageDigest(),
                'RawToPreviewGain' => new \PHPExiftool\Driver\Tag\IFD0\RawToPreviewGain(),
                'PanasonicRawVersion' => new \PHPExiftool\Driver\Tag\IFD0\PanasonicRawVersion(),
                'SensorWidth' => new \PHPExiftool\Driver\Tag\IFD0\SensorWidth(),
                'SensorHeight' => new \PHPExiftool\Driver\Tag\IFD0\SensorHeight(),
                'SensorTopBorder' => new \PHPExiftool\Driver\Tag\IFD0\SensorTopBorder(),
                'SensorLeftBorder' => new \PHPExiftool\Driver\Tag\IFD0\SensorLeftBorder(),
                'SensorBottomBorder' => new \PHPExiftool\Driver\Tag\IFD0\SensorBottomBorder(),
                'SensorRightBorder' => new \PHPExiftool\Driver\Tag\IFD0\SensorRightBorder(),
                'BlackLevel1' => new \PHPExiftool\Driver\Tag\IFD0\BlackLevel1(),
                'BlackLevel2' => new \PHPExiftool\Driver\Tag\IFD0\BlackLevel2(),
                'BlackLevel3' => new \PHPExiftool\Driver\Tag\IFD0\BlackLevel3(),
                'LinearityLimitRed' => new \PHPExiftool\Driver\Tag\IFD0\LinearityLimitRed(),
                'LinearityLimitGreen' => new \PHPExiftool\Driver\Tag\IFD0\LinearityLimitGreen(),
                'LinearityLimitBlue' => new \PHPExiftool\Driver\Tag\IFD0\LinearityLimitBlue(),
                'RedBalance' => new \PHPExiftool\Driver\Tag\IFD0\RedBalance(),
                'BlueBalance' => new \PHPExiftool\Driver\Tag\IFD0\BlueBalance(),
                'ISO' => new \PHPExiftool\Driver\Tag\IFD0\ISO(),
                'HighISOMultiplierRed' => new \PHPExiftool\Driver\Tag\IFD0\HighISOMultiplierRed(),
                'HighISOMultiplierGreen' => new \PHPExiftool\Driver\Tag\IFD0\HighISOMultiplierGreen(),
                'HighISOMultiplierBlue' => new \PHPExiftool\Driver\Tag\IFD0\HighISOMultiplierBlue(),
                'BlackLevelRed' => new \PHPExiftool\Driver\Tag\IFD0\BlackLevelRed(),
                'BlackLevelGreen' => new \PHPExiftool\Driver\Tag\IFD0\BlackLevelGreen(),
                'BlackLevelBlue' => new \PHPExiftool\Driver\Tag\IFD0\BlackLevelBlue(),
                'WBRedLevel' => new \PHPExiftool\Driver\Tag\IFD0\WBRedLevel(),
                'WBGreenLevel' => new \PHPExiftool\Driver\Tag\IFD0\WBGreenLevel(),
                'WBBlueLevel' => new \PHPExiftool\Driver\Tag\IFD0\WBBlueLevel(),
                'JpgFromRaw' => new \PHPExiftool\Driver\Tag\IFD0\JpgFromRaw(),
                'CropTop' => new \PHPExiftool\Driver\Tag\IFD0\CropTop(),
                'CropLeft' => new \PHPExiftool\Driver\Tag\IFD0\CropLeft(),
                'CropBottom' => new \PHPExiftool\Driver\Tag\IFD0\CropBottom(),
                'CropRight' => new \PHPExiftool\Driver\Tag\IFD0\CropRight(),
                'StripOffsets' => new \PHPExiftool\Driver\Tag\IFD0\StripOffsets(),
                'StripByteCounts' => new \PHPExiftool\Driver\Tag\IFD0\StripByteCounts(),
                'RawDataOffset' => new \PHPExiftool\Driver\Tag\IFD0\RawDataOffset(),
                'ApplicationNotes' => new \PHPExiftool\Driver\Tag\IFD0\ApplicationNotes(),
            );
        });
        $this['SubIFD1'] = $this->share(function(){
            return array(
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\SubIFD1\PreviewImageStart(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\SubIFD1\PreviewImageLength(),
                'OtherImageStart' => new \PHPExiftool\Driver\Tag\SubIFD1\OtherImageStart(),
                'OtherImageLength' => new \PHPExiftool\Driver\Tag\SubIFD1\OtherImageLength(),
            );
        });
        $this['SubIFD2'] = $this->share(function(){
            return array(
                'JpgFromRawStart' => new \PHPExiftool\Driver\Tag\SubIFD2\JpgFromRawStart(),
                'JpgFromRawLength' => new \PHPExiftool\Driver\Tag\SubIFD2\JpgFromRawLength(),
                'OtherImageStart' => new \PHPExiftool\Driver\Tag\SubIFD2\OtherImageStart(),
                'OtherImageLength' => new \PHPExiftool\Driver\Tag\SubIFD2\OtherImageLength(),
            );
        });
        $this['IFD1'] = $this->share(function(){
            return array(
                'ThumbnailOffset' => new \PHPExiftool\Driver\Tag\IFD1\ThumbnailOffset(),
                'ThumbnailLength' => new \PHPExiftool\Driver\Tag\IFD1\ThumbnailLength(),
            );
        });
        $this['SubIFD'] = $this->share(function(){
            return array(
                'ThumbnailOffset' => new \PHPExiftool\Driver\Tag\SubIFD\ThumbnailOffset(),
                'JpgFromRawStart' => new \PHPExiftool\Driver\Tag\SubIFD\JpgFromRawStart(),
                'ThumbnailLength' => new \PHPExiftool\Driver\Tag\SubIFD\ThumbnailLength(),
                'JpgFromRawLength' => new \PHPExiftool\Driver\Tag\SubIFD\JpgFromRawLength(),
                'CFARepeatPatternDim' => new \PHPExiftool\Driver\Tag\SubIFD\CFARepeatPatternDim(),
                'CFAPattern2' => new \PHPExiftool\Driver\Tag\SubIFD\CFAPattern2(),
                'LinearizationTable' => new \PHPExiftool\Driver\Tag\SubIFD\LinearizationTable(),
                'BlackLevelRepeatDim' => new \PHPExiftool\Driver\Tag\SubIFD\BlackLevelRepeatDim(),
                'BlackLevel' => new \PHPExiftool\Driver\Tag\SubIFD\BlackLevel(),
                'BlackLevelDeltaH' => new \PHPExiftool\Driver\Tag\SubIFD\BlackLevelDeltaH(),
                'BlackLevelDeltaV' => new \PHPExiftool\Driver\Tag\SubIFD\BlackLevelDeltaV(),
                'WhiteLevel' => new \PHPExiftool\Driver\Tag\SubIFD\WhiteLevel(),
                'DefaultScale' => new \PHPExiftool\Driver\Tag\SubIFD\DefaultScale(),
                'DefaultCropOrigin' => new \PHPExiftool\Driver\Tag\SubIFD\DefaultCropOrigin(),
                'DefaultCropSize' => new \PHPExiftool\Driver\Tag\SubIFD\DefaultCropSize(),
                'BayerGreenSplit' => new \PHPExiftool\Driver\Tag\SubIFD\BayerGreenSplit(),
                'ChromaBlurRadius' => new \PHPExiftool\Driver\Tag\SubIFD\ChromaBlurRadius(),
                'AntiAliasStrength' => new \PHPExiftool\Driver\Tag\SubIFD\AntiAliasStrength(),
                'BestQualityScale' => new \PHPExiftool\Driver\Tag\SubIFD\BestQualityScale(),
                'ActiveArea' => new \PHPExiftool\Driver\Tag\SubIFD\ActiveArea(),
                'MaskedAreas' => new \PHPExiftool\Driver\Tag\SubIFD\MaskedAreas(),
                'NoiseReductionApplied' => new \PHPExiftool\Driver\Tag\SubIFD\NoiseReductionApplied(),
                'NoiseProfile' => new \PHPExiftool\Driver\Tag\SubIFD\NoiseProfile(),
                'DefaultUserCrop' => new \PHPExiftool\Driver\Tag\SubIFD\DefaultUserCrop(),
            );
        });
        $this['IFD2'] = $this->share(function(){
            return array(
                'JpgFromRawStart' => new \PHPExiftool\Driver\Tag\IFD2\JpgFromRawStart(),
                'JpgFromRawLength' => new \PHPExiftool\Driver\Tag\IFD2\JpgFromRawLength(),
            );
        });
        $this['Adobe'] = $this->share(function(){
            return array(
                'Adobe' => new \PHPExiftool\Driver\Tag\Adobe\Adobe(),
                'DCTEncodeVersion' => new \PHPExiftool\Driver\Tag\Adobe\DCTEncodeVersion(),
                'APP14Flags0' => new \PHPExiftool\Driver\Tag\Adobe\APP14Flags0(),
                'APP14Flags1' => new \PHPExiftool\Driver\Tag\Adobe\APP14Flags1(),
                'ColorTransform' => new \PHPExiftool\Driver\Tag\Adobe\ColorTransform(),
            );
        });
        $this['System'] = $this->share(function(){
            return array(
                'Directory' => new \PHPExiftool\Driver\Tag\System\Directory(),
                'FileAccessDate' => new \PHPExiftool\Driver\Tag\System\FileAccessDate(),
                'FileAttributes' => new \PHPExiftool\Driver\Tag\System\FileAttributes(),
                'FileBlockCount' => new \PHPExiftool\Driver\Tag\System\FileBlockCount(),
                'FileBlockSize' => new \PHPExiftool\Driver\Tag\System\FileBlockSize(),
                'FileCreateDate' => new \PHPExiftool\Driver\Tag\System\FileCreateDate(),
                'FileDeviceID' => new \PHPExiftool\Driver\Tag\System\FileDeviceID(),
                'FileDeviceNumber' => new \PHPExiftool\Driver\Tag\System\FileDeviceNumber(),
                'FileGroupID' => new \PHPExiftool\Driver\Tag\System\FileGroupID(),
                'FileHardLinks' => new \PHPExiftool\Driver\Tag\System\FileHardLinks(),
                'FileInodeChangeDate' => new \PHPExiftool\Driver\Tag\System\FileInodeChangeDate(),
                'FileInodeNumber' => new \PHPExiftool\Driver\Tag\System\FileInodeNumber(),
                'FileModifyDate' => new \PHPExiftool\Driver\Tag\System\FileModifyDate(),
                'FileName' => new \PHPExiftool\Driver\Tag\System\FileName(),
                'FilePath' => new \PHPExiftool\Driver\Tag\System\FilePath(),
                'FilePermissions' => new \PHPExiftool\Driver\Tag\System\FilePermissions(),
                'FileSize' => new \PHPExiftool\Driver\Tag\System\FileSize(),
                'FileUserID' => new \PHPExiftool\Driver\Tag\System\FileUserID(),
                'MDItemTags' => new \PHPExiftool\Driver\Tag\System\MDItemTags(),
                'ResourceForkSize' => new \PHPExiftool\Driver\Tag\System\ResourceForkSize(),
            );
        });
        $this['EXIF'] = $this->share(function(){
            return array(
                'EXIF' => new \PHPExiftool\Driver\Tag\EXIF\EXIF(),
            );
        });
        $this['ExifTool'] = $this->share(function(){
            return array(
                'Error' => new \PHPExiftool\Driver\Tag\ExifTool\Error(),
                'ExifToolVersion' => new \PHPExiftool\Driver\Tag\ExifTool\ExifToolVersion(),
                'FileSequence' => new \PHPExiftool\Driver\Tag\ExifTool\FileSequence(),
                'NewGUID' => new \PHPExiftool\Driver\Tag\ExifTool\NewGUID(),
                'Now' => new \PHPExiftool\Driver\Tag\ExifTool\Now(),
                'ProcessingTime' => new \PHPExiftool\Driver\Tag\ExifTool\ProcessingTime(),
                'Warning' => new \PHPExiftool\Driver\Tag\ExifTool\Warning(),
            );
        });
        $this['ICC_Profile'] = $this->share(function(){
            return array(
                'ICC_Profile' => new \PHPExiftool\Driver\Tag\ICCProfile\ICCProfile(),
                'AToB0' => new \PHPExiftool\Driver\Tag\ICCProfile\AToB0(),
                'AToB1' => new \PHPExiftool\Driver\Tag\ICCProfile\AToB1(),
                'AToB2' => new \PHPExiftool\Driver\Tag\ICCProfile\AToB2(),
                'BToA0' => new \PHPExiftool\Driver\Tag\ICCProfile\BToA0(),
                'BToA1' => new \PHPExiftool\Driver\Tag\ICCProfile\BToA1(),
                'BToA2' => new \PHPExiftool\Driver\Tag\ICCProfile\BToA2(),
                'BToD0' => new \PHPExiftool\Driver\Tag\ICCProfile\BToD0(),
                'BToD1' => new \PHPExiftool\Driver\Tag\ICCProfile\BToD1(),
                'BToD2' => new \PHPExiftool\Driver\Tag\ICCProfile\BToD2(),
                'BToD3' => new \PHPExiftool\Driver\Tag\ICCProfile\BToD3(),
                'DToB0' => new \PHPExiftool\Driver\Tag\ICCProfile\DToB0(),
                'DToB1' => new \PHPExiftool\Driver\Tag\ICCProfile\DToB1(),
                'DToB2' => new \PHPExiftool\Driver\Tag\ICCProfile\DToB2(),
                'DToB3' => new \PHPExiftool\Driver\Tag\ICCProfile\DToB3(),
                'WCSProfiles' => new \PHPExiftool\Driver\Tag\ICCProfile\WCSProfiles(),
                'BlueTRC' => new \PHPExiftool\Driver\Tag\ICCProfile\BlueTRC(),
                'BlueMatrixColumn' => new \PHPExiftool\Driver\Tag\ICCProfile\BlueMatrixColumn(),
                'UCRBG' => new \PHPExiftool\Driver\Tag\ICCProfile\UCRBG(),
                'MediaBlackPoint' => new \PHPExiftool\Driver\Tag\ICCProfile\MediaBlackPoint(),
                'CalibrationDateTime' => new \PHPExiftool\Driver\Tag\ICCProfile\CalibrationDateTime(),
                'ChromaticAdaptation' => new \PHPExiftool\Driver\Tag\ICCProfile\ChromaticAdaptation(),
                'ColorimetricIntentImageState' => new \PHPExiftool\Driver\Tag\ICCProfile\ColorimetricIntentImageState(),
                'ColorantTableOut' => new \PHPExiftool\Driver\Tag\ICCProfile\ColorantTableOut(),
                'ColorantOrder' => new \PHPExiftool\Driver\Tag\ICCProfile\ColorantOrder(),
                'ProfileCopyright' => new \PHPExiftool\Driver\Tag\ICCProfile\ProfileCopyright(),
                'CRDInfo' => new \PHPExiftool\Driver\Tag\ICCProfile\CRDInfo(),
                'ProfileDescription' => new \PHPExiftool\Driver\Tag\ICCProfile\ProfileDescription(),
                'DeviceSettings' => new \PHPExiftool\Driver\Tag\ICCProfile\DeviceSettings(),
                'DeviceModelDesc' => new \PHPExiftool\Driver\Tag\ICCProfile\DeviceModelDesc(),
                'DeviceMfgDesc' => new \PHPExiftool\Driver\Tag\ICCProfile\DeviceMfgDesc(),
                'ProfileDescriptionML' => new \PHPExiftool\Driver\Tag\ICCProfile\ProfileDescriptionML(),
                'FocalPlaneColorimetryEstimates' => new \PHPExiftool\Driver\Tag\ICCProfile\FocalPlaneColorimetryEstimates(),
                'GreenTRC' => new \PHPExiftool\Driver\Tag\ICCProfile\GreenTRC(),
                'GreenMatrixColumn' => new \PHPExiftool\Driver\Tag\ICCProfile\GreenMatrixColumn(),
                'Gamut' => new \PHPExiftool\Driver\Tag\ICCProfile\Gamut(),
                'GrayTRC' => new \PHPExiftool\Driver\Tag\ICCProfile\GrayTRC(),
                'Luminance' => new \PHPExiftool\Driver\Tag\ICCProfile\Luminance(),
                'MakeAndModel' => new \PHPExiftool\Driver\Tag\ICCProfile\MakeAndModel(),
                'NamedColor2' => new \PHPExiftool\Driver\Tag\ICCProfile\NamedColor2(),
                'NamedColor' => new \PHPExiftool\Driver\Tag\ICCProfile\NamedColor(),
                'NativeDisplayInfo' => new \PHPExiftool\Driver\Tag\ICCProfile\NativeDisplayInfo(),
                'Preview0' => new \PHPExiftool\Driver\Tag\ICCProfile\Preview0(),
                'Preview1' => new \PHPExiftool\Driver\Tag\ICCProfile\Preview1(),
                'Preview2' => new \PHPExiftool\Driver\Tag\ICCProfile\Preview2(),
                'PS2RenderingIntent' => new \PHPExiftool\Driver\Tag\ICCProfile\PS2RenderingIntent(),
                'PostScript2CSA' => new \PHPExiftool\Driver\Tag\ICCProfile\PostScript2CSA(),
                'PostScript2CRD0' => new \PHPExiftool\Driver\Tag\ICCProfile\PostScript2CRD0(),
                'PostScript2CRD1' => new \PHPExiftool\Driver\Tag\ICCProfile\PostScript2CRD1(),
                'PostScript2CRD2' => new \PHPExiftool\Driver\Tag\ICCProfile\PostScript2CRD2(),
                'ProfileSequenceDesc' => new \PHPExiftool\Driver\Tag\ICCProfile\ProfileSequenceDesc(),
                'ProfileSequenceIdentifier' => new \PHPExiftool\Driver\Tag\ICCProfile\ProfileSequenceIdentifier(),
                'PS2CRDVMSize' => new \PHPExiftool\Driver\Tag\ICCProfile\PS2CRDVMSize(),
                'RedTRC' => new \PHPExiftool\Driver\Tag\ICCProfile\RedTRC(),
                'RedMatrixColumn' => new \PHPExiftool\Driver\Tag\ICCProfile\RedMatrixColumn(),
                'OutputResponse' => new \PHPExiftool\Driver\Tag\ICCProfile\OutputResponse(),
                'ReflectionHardcopyOrigColorimetry' => new \PHPExiftool\Driver\Tag\ICCProfile\ReflectionHardcopyOrigColorimetry(),
                'PerceptualRenderingIntentGamut' => new \PHPExiftool\Driver\Tag\ICCProfile\PerceptualRenderingIntentGamut(),
                'SaturationRenderingIntentGamut' => new \PHPExiftool\Driver\Tag\ICCProfile\SaturationRenderingIntentGamut(),
                'ReflectionPrintOutputColorimetry' => new \PHPExiftool\Driver\Tag\ICCProfile\ReflectionPrintOutputColorimetry(),
                'SceneAppearanceEstimates' => new \PHPExiftool\Driver\Tag\ICCProfile\SceneAppearanceEstimates(),
                'SceneColorimetryEstimates' => new \PHPExiftool\Driver\Tag\ICCProfile\SceneColorimetryEstimates(),
                'ScreeningDesc' => new \PHPExiftool\Driver\Tag\ICCProfile\ScreeningDesc(),
                'Screening' => new \PHPExiftool\Driver\Tag\ICCProfile\Screening(),
                'CharTarget' => new \PHPExiftool\Driver\Tag\ICCProfile\CharTarget(),
                'Technology' => new \PHPExiftool\Driver\Tag\ICCProfile\Technology(),
                'VideoCardGamma' => new \PHPExiftool\Driver\Tag\ICCProfile\VideoCardGamma(),
                'ViewingCondDesc' => new \PHPExiftool\Driver\Tag\ICCProfile\ViewingCondDesc(),
                'MediaWhitePoint' => new \PHPExiftool\Driver\Tag\ICCProfile\MediaWhitePoint(),
            );
        });
        $this['IPTC'] = $this->share(function(){
            return array(
                'IPTC' => new \PHPExiftool\Driver\Tag\IPTC\IPTC(),
                'ApplicationRecordVersion' => new \PHPExiftool\Driver\Tag\IPTC\ApplicationRecordVersion(),
                'ObjectTypeReference' => new \PHPExiftool\Driver\Tag\IPTC\ObjectTypeReference(),
                'ObjectAttributeReference' => new \PHPExiftool\Driver\Tag\IPTC\ObjectAttributeReference(),
                'ObjectName' => new \PHPExiftool\Driver\Tag\IPTC\ObjectName(),
                'EditStatus' => new \PHPExiftool\Driver\Tag\IPTC\EditStatus(),
                'EditorialUpdate' => new \PHPExiftool\Driver\Tag\IPTC\EditorialUpdate(),
                'Urgency' => new \PHPExiftool\Driver\Tag\IPTC\Urgency(),
                'SubjectReference' => new \PHPExiftool\Driver\Tag\IPTC\SubjectReference(),
                'Category' => new \PHPExiftool\Driver\Tag\IPTC\Category(),
                'SupplementalCategories' => new \PHPExiftool\Driver\Tag\IPTC\SupplementalCategories(),
                'FixtureIdentifier' => new \PHPExiftool\Driver\Tag\IPTC\FixtureIdentifier(),
                'Keywords' => new \PHPExiftool\Driver\Tag\IPTC\Keywords(),
                'ContentLocationCode' => new \PHPExiftool\Driver\Tag\IPTC\ContentLocationCode(),
                'ContentLocationName' => new \PHPExiftool\Driver\Tag\IPTC\ContentLocationName(),
                'ReleaseDate' => new \PHPExiftool\Driver\Tag\IPTC\ReleaseDate(),
                'ReleaseTime' => new \PHPExiftool\Driver\Tag\IPTC\ReleaseTime(),
                'ExpirationDate' => new \PHPExiftool\Driver\Tag\IPTC\ExpirationDate(),
                'ExpirationTime' => new \PHPExiftool\Driver\Tag\IPTC\ExpirationTime(),
                'SpecialInstructions' => new \PHPExiftool\Driver\Tag\IPTC\SpecialInstructions(),
                'ActionAdvised' => new \PHPExiftool\Driver\Tag\IPTC\ActionAdvised(),
                'ReferenceService' => new \PHPExiftool\Driver\Tag\IPTC\ReferenceService(),
                'ReferenceDate' => new \PHPExiftool\Driver\Tag\IPTC\ReferenceDate(),
                'ReferenceNumber' => new \PHPExiftool\Driver\Tag\IPTC\ReferenceNumber(),
                'DateCreated' => new \PHPExiftool\Driver\Tag\IPTC\DateCreated(),
                'TimeCreated' => new \PHPExiftool\Driver\Tag\IPTC\TimeCreated(),
                'DigitalCreationDate' => new \PHPExiftool\Driver\Tag\IPTC\DigitalCreationDate(),
                'DigitalCreationTime' => new \PHPExiftool\Driver\Tag\IPTC\DigitalCreationTime(),
                'OriginatingProgram' => new \PHPExiftool\Driver\Tag\IPTC\OriginatingProgram(),
                'ProgramVersion' => new \PHPExiftool\Driver\Tag\IPTC\ProgramVersion(),
                'ObjectCycle' => new \PHPExiftool\Driver\Tag\IPTC\ObjectCycle(),
                'By-line' => new \PHPExiftool\Driver\Tag\IPTC\ByLine(),
                'By-lineTitle' => new \PHPExiftool\Driver\Tag\IPTC\ByLineTitle(),
                'City' => new \PHPExiftool\Driver\Tag\IPTC\City(),
                'Sub-location' => new \PHPExiftool\Driver\Tag\IPTC\SubLocation(),
                'Province-State' => new \PHPExiftool\Driver\Tag\IPTC\ProvinceState(),
                'Country-PrimaryLocationCode' => new \PHPExiftool\Driver\Tag\IPTC\CountryPrimaryLocationCode(),
                'Country-PrimaryLocationName' => new \PHPExiftool\Driver\Tag\IPTC\CountryPrimaryLocationName(),
                'OriginalTransmissionReference' => new \PHPExiftool\Driver\Tag\IPTC\OriginalTransmissionReference(),
                'Headline' => new \PHPExiftool\Driver\Tag\IPTC\Headline(),
                'Credit' => new \PHPExiftool\Driver\Tag\IPTC\Credit(),
                'Source' => new \PHPExiftool\Driver\Tag\IPTC\Source(),
                'CopyrightNotice' => new \PHPExiftool\Driver\Tag\IPTC\CopyrightNotice(),
                'Contact' => new \PHPExiftool\Driver\Tag\IPTC\Contact(),
                'Caption-Abstract' => new \PHPExiftool\Driver\Tag\IPTC\CaptionAbstract(),
                'LocalCaption' => new \PHPExiftool\Driver\Tag\IPTC\LocalCaption(),
                'Writer-Editor' => new \PHPExiftool\Driver\Tag\IPTC\WriterEditor(),
                'RasterizedCaption' => new \PHPExiftool\Driver\Tag\IPTC\RasterizedCaption(),
                'ImageType' => new \PHPExiftool\Driver\Tag\IPTC\ImageType(),
                'ImageOrientation' => new \PHPExiftool\Driver\Tag\IPTC\ImageOrientation(),
                'LanguageIdentifier' => new \PHPExiftool\Driver\Tag\IPTC\LanguageIdentifier(),
                'AudioType' => new \PHPExiftool\Driver\Tag\IPTC\AudioType(),
                'AudioSamplingRate' => new \PHPExiftool\Driver\Tag\IPTC\AudioSamplingRate(),
                'AudioSamplingResolution' => new \PHPExiftool\Driver\Tag\IPTC\AudioSamplingResolution(),
                'AudioDuration' => new \PHPExiftool\Driver\Tag\IPTC\AudioDuration(),
                'AudioOutcue' => new \PHPExiftool\Driver\Tag\IPTC\AudioOutcue(),
                'JobID' => new \PHPExiftool\Driver\Tag\IPTC\JobID(),
                'MasterDocumentID' => new \PHPExiftool\Driver\Tag\IPTC\MasterDocumentID(),
                'ShortDocumentID' => new \PHPExiftool\Driver\Tag\IPTC\ShortDocumentID(),
                'UniqueDocumentID' => new \PHPExiftool\Driver\Tag\IPTC\UniqueDocumentID(),
                'OwnerID' => new \PHPExiftool\Driver\Tag\IPTC\OwnerID(),
                'ObjectPreviewFileFormat' => new \PHPExiftool\Driver\Tag\IPTC\ObjectPreviewFileFormat(),
                'ObjectPreviewFileVersion' => new \PHPExiftool\Driver\Tag\IPTC\ObjectPreviewFileVersion(),
                'ObjectPreviewData' => new \PHPExiftool\Driver\Tag\IPTC\ObjectPreviewData(),
                'Prefs' => new \PHPExiftool\Driver\Tag\IPTC\Prefs(),
                'ClassifyState' => new \PHPExiftool\Driver\Tag\IPTC\ClassifyState(),
                'SimilarityIndex' => new \PHPExiftool\Driver\Tag\IPTC\SimilarityIndex(),
                'DocumentNotes' => new \PHPExiftool\Driver\Tag\IPTC\DocumentNotes(),
                'DocumentHistory' => new \PHPExiftool\Driver\Tag\IPTC\DocumentHistory(),
                'ExifCameraInfo' => new \PHPExiftool\Driver\Tag\IPTC\ExifCameraInfo(),
                'CatalogSets' => new \PHPExiftool\Driver\Tag\IPTC\CatalogSets(),
                'EnvelopeRecordVersion' => new \PHPExiftool\Driver\Tag\IPTC\EnvelopeRecordVersion(),
                'Destination' => new \PHPExiftool\Driver\Tag\IPTC\Destination(),
                'FileFormat' => new \PHPExiftool\Driver\Tag\IPTC\FileFormat(),
                'FileVersion' => new \PHPExiftool\Driver\Tag\IPTC\FileVersion(),
                'ServiceIdentifier' => new \PHPExiftool\Driver\Tag\IPTC\ServiceIdentifier(),
                'EnvelopeNumber' => new \PHPExiftool\Driver\Tag\IPTC\EnvelopeNumber(),
                'ProductID' => new \PHPExiftool\Driver\Tag\IPTC\ProductID(),
                'EnvelopePriority' => new \PHPExiftool\Driver\Tag\IPTC\EnvelopePriority(),
                'DateSent' => new \PHPExiftool\Driver\Tag\IPTC\DateSent(),
                'TimeSent' => new \PHPExiftool\Driver\Tag\IPTC\TimeSent(),
                'CodedCharacterSet' => new \PHPExiftool\Driver\Tag\IPTC\CodedCharacterSet(),
                'UniqueObjectName' => new \PHPExiftool\Driver\Tag\IPTC\UniqueObjectName(),
                'ARMIdentifier' => new \PHPExiftool\Driver\Tag\IPTC\ARMIdentifier(),
                'ARMVersion' => new \PHPExiftool\Driver\Tag\IPTC\ARMVersion(),
                'NewsPhotoVersion' => new \PHPExiftool\Driver\Tag\IPTC\NewsPhotoVersion(),
                'IPTCPictureNumber' => new \PHPExiftool\Driver\Tag\IPTC\IPTCPictureNumber(),
                'IPTCImageWidth' => new \PHPExiftool\Driver\Tag\IPTC\IPTCImageWidth(),
                'IPTCImageHeight' => new \PHPExiftool\Driver\Tag\IPTC\IPTCImageHeight(),
                'IPTCPixelWidth' => new \PHPExiftool\Driver\Tag\IPTC\IPTCPixelWidth(),
                'IPTCPixelHeight' => new \PHPExiftool\Driver\Tag\IPTC\IPTCPixelHeight(),
                'SupplementalType' => new \PHPExiftool\Driver\Tag\IPTC\SupplementalType(),
                'ColorRepresentation' => new \PHPExiftool\Driver\Tag\IPTC\ColorRepresentation(),
                'InterchangeColorSpace' => new \PHPExiftool\Driver\Tag\IPTC\InterchangeColorSpace(),
                'ColorSequence' => new \PHPExiftool\Driver\Tag\IPTC\ColorSequence(),
                'ICC_Profile' => new \PHPExiftool\Driver\Tag\IPTC\ICCProfile(),
                'ColorCalibrationMatrix' => new \PHPExiftool\Driver\Tag\IPTC\ColorCalibrationMatrix(),
                'LookupTable' => new \PHPExiftool\Driver\Tag\IPTC\LookupTable(),
                'NumIndexEntries' => new \PHPExiftool\Driver\Tag\IPTC\NumIndexEntries(),
                'ColorPalette' => new \PHPExiftool\Driver\Tag\IPTC\ColorPalette(),
                'IPTCBitsPerSample' => new \PHPExiftool\Driver\Tag\IPTC\IPTCBitsPerSample(),
                'SampleStructure' => new \PHPExiftool\Driver\Tag\IPTC\SampleStructure(),
                'ScanningDirection' => new \PHPExiftool\Driver\Tag\IPTC\ScanningDirection(),
                'IPTCImageRotation' => new \PHPExiftool\Driver\Tag\IPTC\IPTCImageRotation(),
                'DataCompressionMethod' => new \PHPExiftool\Driver\Tag\IPTC\DataCompressionMethod(),
                'QuantizationMethod' => new \PHPExiftool\Driver\Tag\IPTC\QuantizationMethod(),
                'EndPoints' => new \PHPExiftool\Driver\Tag\IPTC\EndPoints(),
                'ExcursionTolerance' => new \PHPExiftool\Driver\Tag\IPTC\ExcursionTolerance(),
                'BitsPerComponent' => new \PHPExiftool\Driver\Tag\IPTC\BitsPerComponent(),
                'MaximumDensityRange' => new \PHPExiftool\Driver\Tag\IPTC\MaximumDensityRange(),
                'GammaCompensatedValue' => new \PHPExiftool\Driver\Tag\IPTC\GammaCompensatedValue(),
                'SubFile' => new \PHPExiftool\Driver\Tag\IPTC\SubFile(),
                'ConfirmedObjectSize' => new \PHPExiftool\Driver\Tag\IPTC\ConfirmedObjectSize(),
                'SizeMode' => new \PHPExiftool\Driver\Tag\IPTC\SizeMode(),
                'MaxSubfileSize' => new \PHPExiftool\Driver\Tag\IPTC\MaxSubfileSize(),
                'ObjectSizeAnnounced' => new \PHPExiftool\Driver\Tag\IPTC\ObjectSizeAnnounced(),
                'MaximumObjectSize' => new \PHPExiftool\Driver\Tag\IPTC\MaximumObjectSize(),
            );
        });
        $this['XMP'] = $this->share(function(){
            return array(
                'XMP' => new \PHPExiftool\Driver\Tag\XMP\XMP(),
            );
        });
        $this['FLAC'] = $this->share(function(){
            return array(
                'Padding' => new \PHPExiftool\Driver\Tag\FLAC\Padding(),
                'Application' => new \PHPExiftool\Driver\Tag\FLAC\Application(),
                'SeekTable' => new \PHPExiftool\Driver\Tag\FLAC\SeekTable(),
                'CueSheet' => new \PHPExiftool\Driver\Tag\FLAC\CueSheet(),
                'PictureType' => new \PHPExiftool\Driver\Tag\FLAC\PictureType(),
                'PictureMIMEType' => new \PHPExiftool\Driver\Tag\FLAC\PictureMIMEType(),
                'PictureDescription' => new \PHPExiftool\Driver\Tag\FLAC\PictureDescription(),
                'PictureWidth' => new \PHPExiftool\Driver\Tag\FLAC\PictureWidth(),
                'PictureHeight' => new \PHPExiftool\Driver\Tag\FLAC\PictureHeight(),
                'PictureBitsPerPixel' => new \PHPExiftool\Driver\Tag\FLAC\PictureBitsPerPixel(),
                'PictureIndexedColors' => new \PHPExiftool\Driver\Tag\FLAC\PictureIndexedColors(),
                'PictureLength' => new \PHPExiftool\Driver\Tag\FLAC\PictureLength(),
                'Picture' => new \PHPExiftool\Driver\Tag\FLAC\Picture(),
                'BlockSizeMin' => new \PHPExiftool\Driver\Tag\FLAC\BlockSizeMin(),
                'BlockSizeMax' => new \PHPExiftool\Driver\Tag\FLAC\BlockSizeMax(),
                'FrameSizeMin' => new \PHPExiftool\Driver\Tag\FLAC\FrameSizeMin(),
                'FrameSizeMax' => new \PHPExiftool\Driver\Tag\FLAC\FrameSizeMax(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\FLAC\SampleRate(),
                'Channels' => new \PHPExiftool\Driver\Tag\FLAC\Channels(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\FLAC\BitsPerSample(),
                'TotalSamples' => new \PHPExiftool\Driver\Tag\FLAC\TotalSamples(),
            );
        });
        $this['Flash'] = $this->share(function(){
            return array(
                'AudioEncoding' => new \PHPExiftool\Driver\Tag\Flash\AudioEncoding(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\Flash\AudioSampleRate(),
                'AudioBitsPerSample' => new \PHPExiftool\Driver\Tag\Flash\AudioBitsPerSample(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\Flash\AudioChannels(),
                'Name' => new \PHPExiftool\Driver\Tag\Flash\Name(),
                'Time' => new \PHPExiftool\Driver\Tag\Flash\Time(),
                'Type' => new \PHPExiftool\Driver\Tag\Flash\Type(),
                'Compressed' => new \PHPExiftool\Driver\Tag\Flash\Compressed(),
                'Duration' => new \PHPExiftool\Driver\Tag\Flash\Duration(),
                'FlashVersion' => new \PHPExiftool\Driver\Tag\Flash\FlashVersion(),
                'FrameCount' => new \PHPExiftool\Driver\Tag\Flash\FrameCount(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\Flash\FrameRate(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\Flash\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\Flash\ImageWidth(),
                'FlashAttributes' => new \PHPExiftool\Driver\Tag\Flash\FlashAttributes(),
                'AudioCodecID' => new \PHPExiftool\Driver\Tag\Flash\AudioCodecID(),
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\Flash\AudioBitrate(),
                'AudioDelay' => new \PHPExiftool\Driver\Tag\Flash\AudioDelay(),
                'AudioSampleSize' => new \PHPExiftool\Driver\Tag\Flash\AudioSampleSize(),
                'AudioSize' => new \PHPExiftool\Driver\Tag\Flash\AudioSize(),
                'ByteLength' => new \PHPExiftool\Driver\Tag\Flash\ByteLength(),
                'CanSeekToEnd' => new \PHPExiftool\Driver\Tag\Flash\CanSeekToEnd(),
                'CanSeekOnTime' => new \PHPExiftool\Driver\Tag\Flash\CanSeekOnTime(),
                'CreatedBy' => new \PHPExiftool\Driver\Tag\Flash\CreatedBy(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\Flash\CreateDate(),
                'DataSize' => new \PHPExiftool\Driver\Tag\Flash\DataSize(),
                'FileSizeBytes' => new \PHPExiftool\Driver\Tag\Flash\FileSizeBytes(),
                'HasAudio' => new \PHPExiftool\Driver\Tag\Flash\HasAudio(),
                'HasCuePoints' => new \PHPExiftool\Driver\Tag\Flash\HasCuePoints(),
                'HasKeyFrames' => new \PHPExiftool\Driver\Tag\Flash\HasKeyFrames(),
                'HasMetadata' => new \PHPExiftool\Driver\Tag\Flash\HasMetadata(),
                'HasVideo' => new \PHPExiftool\Driver\Tag\Flash\HasVideo(),
                'HTTPHostHeader' => new \PHPExiftool\Driver\Tag\Flash\HTTPHostHeader(),
                'KeyFramePositions' => new \PHPExiftool\Driver\Tag\Flash\KeyFramePositions(),
                'KeyFramesTimes' => new \PHPExiftool\Driver\Tag\Flash\KeyFramesTimes(),
                'LastKeyFrameTime' => new \PHPExiftool\Driver\Tag\Flash\LastKeyFrameTime(),
                'LastTimeStamp' => new \PHPExiftool\Driver\Tag\Flash\LastTimeStamp(),
                'MetadataCreator' => new \PHPExiftool\Driver\Tag\Flash\MetadataCreator(),
                'MetadataDate' => new \PHPExiftool\Driver\Tag\Flash\MetadataDate(),
                'Message' => new \PHPExiftool\Driver\Tag\Flash\Message(),
                'URL' => new \PHPExiftool\Driver\Tag\Flash\URL(),
                'SourceData' => new \PHPExiftool\Driver\Tag\Flash\SourceData(),
                'StartTime' => new \PHPExiftool\Driver\Tag\Flash\StartTime(),
                'Stereo' => new \PHPExiftool\Driver\Tag\Flash\Stereo(),
                'TotalDataRate' => new \PHPExiftool\Driver\Tag\Flash\TotalDataRate(),
                'TotalDuration' => new \PHPExiftool\Driver\Tag\Flash\TotalDuration(),
                'VideoCodecID' => new \PHPExiftool\Driver\Tag\Flash\VideoCodecID(),
                'VideoBitrate' => new \PHPExiftool\Driver\Tag\Flash\VideoBitrate(),
                'VideoSize' => new \PHPExiftool\Driver\Tag\Flash\VideoSize(),
                'VideoEncoding' => new \PHPExiftool\Driver\Tag\Flash\VideoEncoding(),
            );
        });
        $this['FlashPix'] = $this->share(function(){
            return array(
                'CompObjUserTypeLen' => new \PHPExiftool\Driver\Tag\FlashPix\CompObjUserTypeLen(),
                'CompObjUserType' => new \PHPExiftool\Driver\Tag\FlashPix\CompObjUserType(),
                'DataObjectID' => new \PHPExiftool\Driver\Tag\FlashPix\DataObjectID(),
                'LockedPropertyList' => new \PHPExiftool\Driver\Tag\FlashPix\LockedPropertyList(),
                'DataObjectTitle' => new \PHPExiftool\Driver\Tag\FlashPix\DataObjectTitle(),
                'LastModifier' => new \PHPExiftool\Driver\Tag\FlashPix\LastModifier(),
                'RevisionNumber' => new \PHPExiftool\Driver\Tag\FlashPix\RevisionNumber(),
                'DataCreateDate' => new \PHPExiftool\Driver\Tag\FlashPix\DataCreateDate(),
                'DataModifyDate' => new \PHPExiftool\Driver\Tag\FlashPix\DataModifyDate(),
                'CreatingApplication' => new \PHPExiftool\Driver\Tag\FlashPix\CreatingApplication(),
                'DataObjectStatus' => new \PHPExiftool\Driver\Tag\FlashPix\DataObjectStatus(),
                'CreatingTransform' => new \PHPExiftool\Driver\Tag\FlashPix\CreatingTransform(),
                'UsingTransforms' => new \PHPExiftool\Driver\Tag\FlashPix\UsingTransforms(),
                'CachedImageHeight' => new \PHPExiftool\Driver\Tag\FlashPix\CachedImageHeight(),
                'CachedImageWidth' => new \PHPExiftool\Driver\Tag\FlashPix\CachedImageWidth(),
                'Category' => new \PHPExiftool\Driver\Tag\FlashPix\Category(),
                'PresentationTarget' => new \PHPExiftool\Driver\Tag\FlashPix\PresentationTarget(),
                'Bytes' => new \PHPExiftool\Driver\Tag\FlashPix\Bytes(),
                'Lines' => new \PHPExiftool\Driver\Tag\FlashPix\Lines(),
                'Paragraphs' => new \PHPExiftool\Driver\Tag\FlashPix\Paragraphs(),
                'Slides' => new \PHPExiftool\Driver\Tag\FlashPix\Slides(),
                'Notes' => new \PHPExiftool\Driver\Tag\FlashPix\Notes(),
                'HiddenSlides' => new \PHPExiftool\Driver\Tag\FlashPix\HiddenSlides(),
                'MMClips' => new \PHPExiftool\Driver\Tag\FlashPix\MMClips(),
                'ScaleCrop' => new \PHPExiftool\Driver\Tag\FlashPix\ScaleCrop(),
                'HeadingPairs' => new \PHPExiftool\Driver\Tag\FlashPix\HeadingPairs(),
                'TitleOfParts' => new \PHPExiftool\Driver\Tag\FlashPix\TitleOfParts(),
                'Manager' => new \PHPExiftool\Driver\Tag\FlashPix\Manager(),
                'Company' => new \PHPExiftool\Driver\Tag\FlashPix\Company(),
                'LinksUpToDate' => new \PHPExiftool\Driver\Tag\FlashPix\LinksUpToDate(),
                'CharCountWithSpaces' => new \PHPExiftool\Driver\Tag\FlashPix\CharCountWithSpaces(),
                'SharedDoc' => new \PHPExiftool\Driver\Tag\FlashPix\SharedDoc(),
                'HyperlinksChanged' => new \PHPExiftool\Driver\Tag\FlashPix\HyperlinksChanged(),
                'AppVersion' => new \PHPExiftool\Driver\Tag\FlashPix\AppVersion(),
                'Hyperlinks' => new \PHPExiftool\Driver\Tag\FlashPix\Hyperlinks(),
                'HyperlinkBase' => new \PHPExiftool\Driver\Tag\FlashPix\HyperlinkBase(),
                'ExtensionName' => new \PHPExiftool\Driver\Tag\FlashPix\ExtensionName(),
                'ExtensionClassID' => new \PHPExiftool\Driver\Tag\FlashPix\ExtensionClassID(),
                'ExtensionPersistence' => new \PHPExiftool\Driver\Tag\FlashPix\ExtensionPersistence(),
                'ExtensionCreateDate' => new \PHPExiftool\Driver\Tag\FlashPix\ExtensionCreateDate(),
                'ExtensionModifyDate' => new \PHPExiftool\Driver\Tag\FlashPix\ExtensionModifyDate(),
                'ExtensionDescription' => new \PHPExiftool\Driver\Tag\FlashPix\ExtensionDescription(),
                'Storage-StreamPathname' => new \PHPExiftool\Driver\Tag\FlashPix\StorageStreamPathname(),
                'FlashPixStreamPathname' => new \PHPExiftool\Driver\Tag\FlashPix\FlashPixStreamPathname(),
                'FlashPixStreamFieldOffset' => new \PHPExiftool\Driver\Tag\FlashPix\FlashPixStreamFieldOffset(),
                'PropertySetPathname' => new \PHPExiftool\Driver\Tag\FlashPix\PropertySetPathname(),
                'PropertySetIDCodes' => new \PHPExiftool\Driver\Tag\FlashPix\PropertySetIDCodes(),
                'PropertyVectorElements' => new \PHPExiftool\Driver\Tag\FlashPix\PropertyVectorElements(),
                'SubimageResolutions' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageResolutions(),
                'UsedExtensionNumbers' => new \PHPExiftool\Driver\Tag\FlashPix\UsedExtensionNumbers(),
                'TransformedImageTitle' => new \PHPExiftool\Driver\Tag\FlashPix\TransformedImageTitle(),
                'VisibleOutputs' => new \PHPExiftool\Driver\Tag\FlashPix\VisibleOutputs(),
                'MaximumImageIndex' => new \PHPExiftool\Driver\Tag\FlashPix\MaximumImageIndex(),
                'MaximumTransformIndex' => new \PHPExiftool\Driver\Tag\FlashPix\MaximumTransformIndex(),
                'MaximumOperationIndex' => new \PHPExiftool\Driver\Tag\FlashPix\MaximumOperationIndex(),
                'NumberOfResolutions' => new \PHPExiftool\Driver\Tag\FlashPix\NumberOfResolutions(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\FlashPix\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\FlashPix\ImageHeight(),
                'DefaultDisplayHeight' => new \PHPExiftool\Driver\Tag\FlashPix\DefaultDisplayHeight(),
                'DefaultDisplayWidth' => new \PHPExiftool\Driver\Tag\FlashPix\DefaultDisplayWidth(),
                'DisplayUnits' => new \PHPExiftool\Driver\Tag\FlashPix\DisplayUnits(),
                'SubimageWidth' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageWidth(),
                'SubimageHeight' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageHeight(),
                'SubimageColor' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageColor(),
                'SubimageNumericalFormat' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageNumericalFormat(),
                'DecimationMethod' => new \PHPExiftool\Driver\Tag\FlashPix\DecimationMethod(),
                'DecimationPrefilterWidth' => new \PHPExiftool\Driver\Tag\FlashPix\DecimationPrefilterWidth(),
                'SubimageICC_Profile' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageICCProfile(),
                'JPEGTables' => new \PHPExiftool\Driver\Tag\FlashPix\JPEGTables(),
                'MaxJPEGTableIndex' => new \PHPExiftool\Driver\Tag\FlashPix\MaxJPEGTableIndex(),
                'FileSource' => new \PHPExiftool\Driver\Tag\FlashPix\FileSource(),
                'SceneType' => new \PHPExiftool\Driver\Tag\FlashPix\SceneType(),
                'CreationPathVector' => new \PHPExiftool\Driver\Tag\FlashPix\CreationPathVector(),
                'SoftwareRelease' => new \PHPExiftool\Driver\Tag\FlashPix\SoftwareRelease(),
                'UserDefinedID' => new \PHPExiftool\Driver\Tag\FlashPix\UserDefinedID(),
                'SharpnessApproximation' => new \PHPExiftool\Driver\Tag\FlashPix\SharpnessApproximation(),
                'Copyright' => new \PHPExiftool\Driver\Tag\FlashPix\Copyright(),
                'OriginalImageBroker' => new \PHPExiftool\Driver\Tag\FlashPix\OriginalImageBroker(),
                'DigitalImageBroker' => new \PHPExiftool\Driver\Tag\FlashPix\DigitalImageBroker(),
                'Authorship' => new \PHPExiftool\Driver\Tag\FlashPix\Authorship(),
                'IntellectualPropertyNotes' => new \PHPExiftool\Driver\Tag\FlashPix\IntellectualPropertyNotes(),
                'TestTarget' => new \PHPExiftool\Driver\Tag\FlashPix\TestTarget(),
                'GroupCaption' => new \PHPExiftool\Driver\Tag\FlashPix\GroupCaption(),
                'CaptionText' => new \PHPExiftool\Driver\Tag\FlashPix\CaptionText(),
                'People' => new \PHPExiftool\Driver\Tag\FlashPix\People(),
                'Things' => new \PHPExiftool\Driver\Tag\FlashPix\Things(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\FlashPix\DateTimeOriginal(),
                'Events' => new \PHPExiftool\Driver\Tag\FlashPix\Events(),
                'Places' => new \PHPExiftool\Driver\Tag\FlashPix\Places(),
                'ContentDescriptionNotes' => new \PHPExiftool\Driver\Tag\FlashPix\ContentDescriptionNotes(),
                'Make' => new \PHPExiftool\Driver\Tag\FlashPix\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\FlashPix\Model(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\FlashPix\SerialNumber(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\FlashPix\CreateDate(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\FlashPix\ExposureTime(),
                'FNumber' => new \PHPExiftool\Driver\Tag\FlashPix\FNumber(),
                'ExposureProgram' => new \PHPExiftool\Driver\Tag\FlashPix\ExposureProgram(),
                'BrightnessValue' => new \PHPExiftool\Driver\Tag\FlashPix\BrightnessValue(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\FlashPix\ExposureCompensation(),
                'SubjectDistance' => new \PHPExiftool\Driver\Tag\FlashPix\SubjectDistance(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\FlashPix\MeteringMode(),
                'LightSource' => new \PHPExiftool\Driver\Tag\FlashPix\LightSource(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\FlashPix\FocalLength(),
                'MaxApertureValue' => new \PHPExiftool\Driver\Tag\FlashPix\MaxApertureValue(),
                'Flash' => new \PHPExiftool\Driver\Tag\FlashPix\Flash(),
                'FlashEnergy' => new \PHPExiftool\Driver\Tag\FlashPix\FlashEnergy(),
                'FlashReturn' => new \PHPExiftool\Driver\Tag\FlashPix\FlashReturn(),
                'BackLight' => new \PHPExiftool\Driver\Tag\FlashPix\BackLight(),
                'SubjectLocation' => new \PHPExiftool\Driver\Tag\FlashPix\SubjectLocation(),
                'ExposureIndex' => new \PHPExiftool\Driver\Tag\FlashPix\ExposureIndex(),
                'SpecialEffectsOpticalFilter' => new \PHPExiftool\Driver\Tag\FlashPix\SpecialEffectsOpticalFilter(),
                'PerPictureNotes' => new \PHPExiftool\Driver\Tag\FlashPix\PerPictureNotes(),
                'SensingMethod' => new \PHPExiftool\Driver\Tag\FlashPix\SensingMethod(),
                'FocalPlaneXResolution' => new \PHPExiftool\Driver\Tag\FlashPix\FocalPlaneXResolution(),
                'FocalPlaneYResolution' => new \PHPExiftool\Driver\Tag\FlashPix\FocalPlaneYResolution(),
                'FocalPlaneResolutionUnit' => new \PHPExiftool\Driver\Tag\FlashPix\FocalPlaneResolutionUnit(),
                'SpatialFrequencyResponse' => new \PHPExiftool\Driver\Tag\FlashPix\SpatialFrequencyResponse(),
                'CFAPattern' => new \PHPExiftool\Driver\Tag\FlashPix\CFAPattern(),
                'ISO' => new \PHPExiftool\Driver\Tag\FlashPix\ISO(),
                'Opto-ElectricConvFactor' => new \PHPExiftool\Driver\Tag\FlashPix\OptoElectricConvFactor(),
                'FilmBrand' => new \PHPExiftool\Driver\Tag\FlashPix\FilmBrand(),
                'FilmCategory' => new \PHPExiftool\Driver\Tag\FlashPix\FilmCategory(),
                'FilmSize' => new \PHPExiftool\Driver\Tag\FlashPix\FilmSize(),
                'FilmRollNumber' => new \PHPExiftool\Driver\Tag\FlashPix\FilmRollNumber(),
                'FilmFrameNumber' => new \PHPExiftool\Driver\Tag\FlashPix\FilmFrameNumber(),
                'ScannerMake' => new \PHPExiftool\Driver\Tag\FlashPix\ScannerMake(),
                'ScannerModel' => new \PHPExiftool\Driver\Tag\FlashPix\ScannerModel(),
                'ScannerSerialNumber' => new \PHPExiftool\Driver\Tag\FlashPix\ScannerSerialNumber(),
                'ScanSoftware' => new \PHPExiftool\Driver\Tag\FlashPix\ScanSoftware(),
                'ScanSoftwareRevisionDate' => new \PHPExiftool\Driver\Tag\FlashPix\ScanSoftwareRevisionDate(),
                'ServiceOrganizationName' => new \PHPExiftool\Driver\Tag\FlashPix\ServiceOrganizationName(),
                'ScanOperatorID' => new \PHPExiftool\Driver\Tag\FlashPix\ScanOperatorID(),
                'ScanDate' => new \PHPExiftool\Driver\Tag\FlashPix\ScanDate(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\FlashPix\ModifyDate(),
                'ScannerPixelSize' => new \PHPExiftool\Driver\Tag\FlashPix\ScannerPixelSize(),
                'OriginalScannedImageSize' => new \PHPExiftool\Driver\Tag\FlashPix\OriginalScannedImageSize(),
                'OriginalDocumentSize' => new \PHPExiftool\Driver\Tag\FlashPix\OriginalDocumentSize(),
                'OriginalMedium' => new \PHPExiftool\Driver\Tag\FlashPix\OriginalMedium(),
                'TypeOfOriginal' => new \PHPExiftool\Driver\Tag\FlashPix\TypeOfOriginal(),
                'ScreenNail' => new \PHPExiftool\Driver\Tag\FlashPix\ScreenNail(),
                'AudioStream' => new \PHPExiftool\Driver\Tag\FlashPix\AudioStream(),
                'CurrentUser' => new \PHPExiftool\Driver\Tag\FlashPix\CurrentUser(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\FlashPix\PreviewImage(),
                'OperationID' => new \PHPExiftool\Driver\Tag\FlashPix\OperationID(),
                'PreviewImageWidth' => new \PHPExiftool\Driver\Tag\FlashPix\PreviewImageWidth(),
                'PreviewImageHeight' => new \PHPExiftool\Driver\Tag\FlashPix\PreviewImageHeight(),
                'SubimageTileCount' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageTileCount(),
                'SubimageTileWidth' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageTileWidth(),
                'SubimageTileHeight' => new \PHPExiftool\Driver\Tag\FlashPix\SubimageTileHeight(),
                'NumChannels' => new \PHPExiftool\Driver\Tag\FlashPix\NumChannels(),
                'Dictionary' => new \PHPExiftool\Driver\Tag\FlashPix\Dictionary(),
                'CodePage' => new \PHPExiftool\Driver\Tag\FlashPix\CodePage(),
                'Title' => new \PHPExiftool\Driver\Tag\FlashPix\Title(),
                'Subject' => new \PHPExiftool\Driver\Tag\FlashPix\Subject(),
                'Author' => new \PHPExiftool\Driver\Tag\FlashPix\Author(),
                'Keywords' => new \PHPExiftool\Driver\Tag\FlashPix\Keywords(),
                'Comments' => new \PHPExiftool\Driver\Tag\FlashPix\Comments(),
                'Template' => new \PHPExiftool\Driver\Tag\FlashPix\Template(),
                'LastModifiedBy' => new \PHPExiftool\Driver\Tag\FlashPix\LastModifiedBy(),
                'TotalEditTime' => new \PHPExiftool\Driver\Tag\FlashPix\TotalEditTime(),
                'LastPrinted' => new \PHPExiftool\Driver\Tag\FlashPix\LastPrinted(),
                'Pages' => new \PHPExiftool\Driver\Tag\FlashPix\Pages(),
                'Words' => new \PHPExiftool\Driver\Tag\FlashPix\Words(),
                'Characters' => new \PHPExiftool\Driver\Tag\FlashPix\Characters(),
                'ThumbnailClip' => new \PHPExiftool\Driver\Tag\FlashPix\ThumbnailClip(),
                'Software' => new \PHPExiftool\Driver\Tag\FlashPix\Software(),
                'Security' => new \PHPExiftool\Driver\Tag\FlashPix\Security(),
                'LocaleIndicator' => new \PHPExiftool\Driver\Tag\FlashPix\LocaleIndicator(),
                'TransformNodeID' => new \PHPExiftool\Driver\Tag\FlashPix\TransformNodeID(),
                'OperationClassID' => new \PHPExiftool\Driver\Tag\FlashPix\OperationClassID(),
                'TransformTitle' => new \PHPExiftool\Driver\Tag\FlashPix\TransformTitle(),
                'TransformCreateDate' => new \PHPExiftool\Driver\Tag\FlashPix\TransformCreateDate(),
                'TransformModifyDate' => new \PHPExiftool\Driver\Tag\FlashPix\TransformModifyDate(),
                'InputDataObjectList' => new \PHPExiftool\Driver\Tag\FlashPix\InputDataObjectList(),
                'OutputDataObjectList' => new \PHPExiftool\Driver\Tag\FlashPix\OutputDataObjectList(),
                'OperationNumber' => new \PHPExiftool\Driver\Tag\FlashPix\OperationNumber(),
                'ResultAspectRatio' => new \PHPExiftool\Driver\Tag\FlashPix\ResultAspectRatio(),
                'RectangleOfInterest' => new \PHPExiftool\Driver\Tag\FlashPix\RectangleOfInterest(),
                'Filtering' => new \PHPExiftool\Driver\Tag\FlashPix\Filtering(),
                'SpatialOrientation' => new \PHPExiftool\Driver\Tag\FlashPix\SpatialOrientation(),
                'ColorTwistMatrix' => new \PHPExiftool\Driver\Tag\FlashPix\ColorTwistMatrix(),
                'ContrastAdjustment' => new \PHPExiftool\Driver\Tag\FlashPix\ContrastAdjustment(),
            );
        });
        $this['Font'] = $this->share(function(){
            return array(
                'Ascender' => new \PHPExiftool\Driver\Tag\Font\Ascender(),
                'CapHeight' => new \PHPExiftool\Driver\Tag\Font\CapHeight(),
                'CharacterSet' => new \PHPExiftool\Driver\Tag\Font\CharacterSet(),
                'Characters' => new \PHPExiftool\Driver\Tag\Font\Characters(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\Font\CreateDate(),
                'Descender' => new \PHPExiftool\Driver\Tag\Font\Descender(),
                'EncodingScheme' => new \PHPExiftool\Driver\Tag\Font\EncodingScheme(),
                'EscChar' => new \PHPExiftool\Driver\Tag\Font\EscChar(),
                'FontFamily' => new \PHPExiftool\Driver\Tag\Font\FontFamily(),
                'FontName' => new \PHPExiftool\Driver\Tag\Font\FontName(),
                'FullName' => new \PHPExiftool\Driver\Tag\Font\FullName(),
                'IsBaseFont' => new \PHPExiftool\Driver\Tag\Font\IsBaseFont(),
                'IsFixedV' => new \PHPExiftool\Driver\Tag\Font\IsFixedV(),
                'MappingScheme' => new \PHPExiftool\Driver\Tag\Font\MappingScheme(),
                'Notice' => new \PHPExiftool\Driver\Tag\Font\Notice(),
                'Version' => new \PHPExiftool\Driver\Tag\Font\Version(),
                'Weight' => new \PHPExiftool\Driver\Tag\Font\Weight(),
                'XHeight' => new \PHPExiftool\Driver\Tag\Font\XHeight(),
                'NumFonts' => new \PHPExiftool\Driver\Tag\Font\NumFonts(),
                'PostScriptFontName' => new \PHPExiftool\Driver\Tag\Font\PostScriptFontName(),
                'Copyright' => new \PHPExiftool\Driver\Tag\Font\Copyright(),
                'FontSubfamily' => new \PHPExiftool\Driver\Tag\Font\FontSubfamily(),
                'FontSubfamilyID' => new \PHPExiftool\Driver\Tag\Font\FontSubfamilyID(),
                'NameTableVersion' => new \PHPExiftool\Driver\Tag\Font\NameTableVersion(),
                'Trademark' => new \PHPExiftool\Driver\Tag\Font\Trademark(),
                'Manufacturer' => new \PHPExiftool\Driver\Tag\Font\Manufacturer(),
                'Designer' => new \PHPExiftool\Driver\Tag\Font\Designer(),
                'Description' => new \PHPExiftool\Driver\Tag\Font\Description(),
                'VendorURL' => new \PHPExiftool\Driver\Tag\Font\VendorURL(),
                'DesignerURL' => new \PHPExiftool\Driver\Tag\Font\DesignerURL(),
                'License' => new \PHPExiftool\Driver\Tag\Font\License(),
                'LicenseInfoURL' => new \PHPExiftool\Driver\Tag\Font\LicenseInfoURL(),
                'PreferredFamily' => new \PHPExiftool\Driver\Tag\Font\PreferredFamily(),
                'PreferredSubfamily' => new \PHPExiftool\Driver\Tag\Font\PreferredSubfamily(),
                'CompatibleFontName' => new \PHPExiftool\Driver\Tag\Font\CompatibleFontName(),
                'SampleText' => new \PHPExiftool\Driver\Tag\Font\SampleText(),
                'WWSFamilyName' => new \PHPExiftool\Driver\Tag\Font\WWSFamilyName(),
                'WWSSubfamilyName' => new \PHPExiftool\Driver\Tag\Font\WWSSubfamilyName(),
                'PFMVersion' => new \PHPExiftool\Driver\Tag\Font\PFMVersion(),
                'FontType' => new \PHPExiftool\Driver\Tag\Font\FontType(),
                'PointSize' => new \PHPExiftool\Driver\Tag\Font\PointSize(),
                'YResolution' => new \PHPExiftool\Driver\Tag\Font\YResolution(),
                'XResolution' => new \PHPExiftool\Driver\Tag\Font\XResolution(),
                'Ascent' => new \PHPExiftool\Driver\Tag\Font\Ascent(),
                'InternalLeading' => new \PHPExiftool\Driver\Tag\Font\InternalLeading(),
                'ExternalLeading' => new \PHPExiftool\Driver\Tag\Font\ExternalLeading(),
                'Italic' => new \PHPExiftool\Driver\Tag\Font\Italic(),
                'Underline' => new \PHPExiftool\Driver\Tag\Font\Underline(),
                'Strikeout' => new \PHPExiftool\Driver\Tag\Font\Strikeout(),
                'PixWidth' => new \PHPExiftool\Driver\Tag\Font\PixWidth(),
                'PixHeight' => new \PHPExiftool\Driver\Tag\Font\PixHeight(),
                'PitchAndFamily' => new \PHPExiftool\Driver\Tag\Font\PitchAndFamily(),
                'AvgWidth' => new \PHPExiftool\Driver\Tag\Font\AvgWidth(),
                'MaxWidth' => new \PHPExiftool\Driver\Tag\Font\MaxWidth(),
                'FirstChar' => new \PHPExiftool\Driver\Tag\Font\FirstChar(),
                'LastChar' => new \PHPExiftool\Driver\Tag\Font\LastChar(),
                'DefaultChar' => new \PHPExiftool\Driver\Tag\Font\DefaultChar(),
                'BreakChar' => new \PHPExiftool\Driver\Tag\Font\BreakChar(),
                'WidthBytes' => new \PHPExiftool\Driver\Tag\Font\WidthBytes(),
                'FSType' => new \PHPExiftool\Driver\Tag\Font\FSType(),
                'ItalicAngle' => new \PHPExiftool\Driver\Tag\Font\ItalicAngle(),
                'UnderlinePosition' => new \PHPExiftool\Driver\Tag\Font\UnderlinePosition(),
                'UnderlineThickness' => new \PHPExiftool\Driver\Tag\Font\UnderlineThickness(),
                'IsFixedPitch' => new \PHPExiftool\Driver\Tag\Font\IsFixedPitch(),
            );
        });
        $this['FotoStation'] = $this->share(function(){
            return array(
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\FotoStation\ThumbnailImage(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\FotoStation\PreviewImage(),
                'OriginalImageWidth' => new \PHPExiftool\Driver\Tag\FotoStation\OriginalImageWidth(),
                'OriginalImageHeight' => new \PHPExiftool\Driver\Tag\FotoStation\OriginalImageHeight(),
                'ColorPlanes' => new \PHPExiftool\Driver\Tag\FotoStation\ColorPlanes(),
                'XYResolution' => new \PHPExiftool\Driver\Tag\FotoStation\XYResolution(),
                'Rotation' => new \PHPExiftool\Driver\Tag\FotoStation\Rotation(),
                'CropLeft' => new \PHPExiftool\Driver\Tag\FotoStation\CropLeft(),
                'CropTop' => new \PHPExiftool\Driver\Tag\FotoStation\CropTop(),
                'CropRight' => new \PHPExiftool\Driver\Tag\FotoStation\CropRight(),
                'CropBottom' => new \PHPExiftool\Driver\Tag\FotoStation\CropBottom(),
                'CropRotation' => new \PHPExiftool\Driver\Tag\FotoStation\CropRotation(),
            );
        });
        $this['FujiFilm'] = $this->share(function(){
            return array(
                'MovieStreamName' => new \PHPExiftool\Driver\Tag\FujiFilm\MovieStreamName(),
                'Face1Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face1Birthday(),
                'Face1Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face1Category(),
                'Face1Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face1Name(),
                'Face2Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face2Birthday(),
                'Face2Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face2Category(),
                'Face2Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face2Name(),
                'Face3Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face3Birthday(),
                'Face3Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face3Category(),
                'Face3Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face3Name(),
                'Face4Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face4Birthday(),
                'Face4Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face4Category(),
                'Face4Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face4Name(),
                'Face5Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face5Birthday(),
                'Face5Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face5Category(),
                'Face5Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face5Name(),
                'Face6Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face6Birthday(),
                'Face6Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face6Category(),
                'Face6Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face6Name(),
                'Face7Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face7Birthday(),
                'Face7Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face7Category(),
                'Face7Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face7Name(),
                'Face8Birthday' => new \PHPExiftool\Driver\Tag\FujiFilm\Face8Birthday(),
                'Face8Category' => new \PHPExiftool\Driver\Tag\FujiFilm\Face8Category(),
                'Face8Name' => new \PHPExiftool\Driver\Tag\FujiFilm\Face8Name(),
                'Make' => new \PHPExiftool\Driver\Tag\FujiFilm\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\FujiFilm\Model(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\FujiFilm\ExposureTime(),
                'FNumber' => new \PHPExiftool\Driver\Tag\FujiFilm\FNumber(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\FujiFilm\ExposureCompensation(),
                'Version' => new \PHPExiftool\Driver\Tag\FujiFilm\Version(),
                'InternalSerialNumber' => new \PHPExiftool\Driver\Tag\FujiFilm\InternalSerialNumber(),
                'Quality' => new \PHPExiftool\Driver\Tag\FujiFilm\Quality(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\FujiFilm\Sharpness(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\FujiFilm\WhiteBalance(),
                'Saturation' => new \PHPExiftool\Driver\Tag\FujiFilm\Saturation(),
                'Contrast' => new \PHPExiftool\Driver\Tag\FujiFilm\Contrast(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\FujiFilm\ColorTemperature(),
                'WhiteBalanceFineTune' => new \PHPExiftool\Driver\Tag\FujiFilm\WhiteBalanceFineTune(),
                'NoiseReduction' => new \PHPExiftool\Driver\Tag\FujiFilm\NoiseReduction(),
                'HighISONoiseReduction' => new \PHPExiftool\Driver\Tag\FujiFilm\HighISONoiseReduction(),
                'FujiFlashMode' => new \PHPExiftool\Driver\Tag\FujiFilm\FujiFlashMode(),
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\FujiFilm\FlashExposureComp(),
                'Macro' => new \PHPExiftool\Driver\Tag\FujiFilm\Macro(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\FujiFilm\FocusMode(),
                'AFMode' => new \PHPExiftool\Driver\Tag\FujiFilm\AFMode(),
                'FocusPixel' => new \PHPExiftool\Driver\Tag\FujiFilm\FocusPixel(),
                'SlowSync' => new \PHPExiftool\Driver\Tag\FujiFilm\SlowSync(),
                'PictureMode' => new \PHPExiftool\Driver\Tag\FujiFilm\PictureMode(),
                'ExposureCount' => new \PHPExiftool\Driver\Tag\FujiFilm\ExposureCount(),
                'EXRAuto' => new \PHPExiftool\Driver\Tag\FujiFilm\EXRAuto(),
                'EXRMode' => new \PHPExiftool\Driver\Tag\FujiFilm\EXRMode(),
                'ShadowTone' => new \PHPExiftool\Driver\Tag\FujiFilm\ShadowTone(),
                'HighlightTone' => new \PHPExiftool\Driver\Tag\FujiFilm\HighlightTone(),
                'ShutterType' => new \PHPExiftool\Driver\Tag\FujiFilm\ShutterType(),
                'AutoBracketing' => new \PHPExiftool\Driver\Tag\FujiFilm\AutoBracketing(),
                'SequenceNumber' => new \PHPExiftool\Driver\Tag\FujiFilm\SequenceNumber(),
                'AdvancedFilter' => new \PHPExiftool\Driver\Tag\FujiFilm\AdvancedFilter(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\FujiFilm\ColorMode(),
                'BlurWarning' => new \PHPExiftool\Driver\Tag\FujiFilm\BlurWarning(),
                'FocusWarning' => new \PHPExiftool\Driver\Tag\FujiFilm\FocusWarning(),
                'ExposureWarning' => new \PHPExiftool\Driver\Tag\FujiFilm\ExposureWarning(),
                'GEImageSize' => new \PHPExiftool\Driver\Tag\FujiFilm\GEImageSize(),
                'DynamicRange' => new \PHPExiftool\Driver\Tag\FujiFilm\DynamicRange(),
                'FilmMode' => new \PHPExiftool\Driver\Tag\FujiFilm\FilmMode(),
                'DynamicRangeSetting' => new \PHPExiftool\Driver\Tag\FujiFilm\DynamicRangeSetting(),
                'DevelopmentDynamicRange' => new \PHPExiftool\Driver\Tag\FujiFilm\DevelopmentDynamicRange(),
                'MinFocalLength' => new \PHPExiftool\Driver\Tag\FujiFilm\MinFocalLength(),
                'MaxFocalLength' => new \PHPExiftool\Driver\Tag\FujiFilm\MaxFocalLength(),
                'MaxApertureAtMinFocal' => new \PHPExiftool\Driver\Tag\FujiFilm\MaxApertureAtMinFocal(),
                'MaxApertureAtMaxFocal' => new \PHPExiftool\Driver\Tag\FujiFilm\MaxApertureAtMaxFocal(),
                'AutoDynamicRange' => new \PHPExiftool\Driver\Tag\FujiFilm\AutoDynamicRange(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\FujiFilm\ImageStabilization(),
                'Rating' => new \PHPExiftool\Driver\Tag\FujiFilm\Rating(),
                'ImageGeneration' => new \PHPExiftool\Driver\Tag\FujiFilm\ImageGeneration(),
                'ImageCount' => new \PHPExiftool\Driver\Tag\FujiFilm\ImageCount(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\FujiFilm\FrameRate(),
                'FrameWidth' => new \PHPExiftool\Driver\Tag\FujiFilm\FrameWidth(),
                'FrameHeight' => new \PHPExiftool\Driver\Tag\FujiFilm\FrameHeight(),
                'FacesDetected' => new \PHPExiftool\Driver\Tag\FujiFilm\FacesDetected(),
                'FacePositions' => new \PHPExiftool\Driver\Tag\FujiFilm\FacePositions(),
                'FileSource' => new \PHPExiftool\Driver\Tag\FujiFilm\FileSource(),
                'OrderNumber' => new \PHPExiftool\Driver\Tag\FujiFilm\OrderNumber(),
                'FrameNumber' => new \PHPExiftool\Driver\Tag\FujiFilm\FrameNumber(),
                'Parallax' => new \PHPExiftool\Driver\Tag\FujiFilm\Parallax(),
                'RawImageWidth' => new \PHPExiftool\Driver\Tag\FujiFilm\RawImageWidth(),
                'RawImageHeight' => new \PHPExiftool\Driver\Tag\FujiFilm\RawImageHeight(),
            );
        });
        $this['FujiIFD'] = $this->share(function(){
            return array(
                'RawImageFullWidth' => new \PHPExiftool\Driver\Tag\FujiIFD\RawImageFullWidth(),
                'RawImageFullHeight' => new \PHPExiftool\Driver\Tag\FujiIFD\RawImageFullHeight(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\FujiIFD\BitsPerSample(),
                'StripOffsets' => new \PHPExiftool\Driver\Tag\FujiIFD\StripOffsets(),
                'StripByteCounts' => new \PHPExiftool\Driver\Tag\FujiIFD\StripByteCounts(),
                'BlackLevel' => new \PHPExiftool\Driver\Tag\FujiIFD\BlackLevel(),
                'WB_GRBLevelsStandard' => new \PHPExiftool\Driver\Tag\FujiIFD\WBGRBLevelsStandard(),
                'WB_GRBLevelsAuto' => new \PHPExiftool\Driver\Tag\FujiIFD\WBGRBLevelsAuto(),
                'WB_GRBLevels' => new \PHPExiftool\Driver\Tag\FujiIFD\WBGRBLevels(),
            );
        });
        $this['RAF2'] = $this->share(function(){
            return array(
                'RawImageFullSize' => new \PHPExiftool\Driver\Tag\RAF2\RawImageFullSize(),
            );
        });
        $this['RAF'] = $this->share(function(){
            return array(
                'RawImageSize' => new \PHPExiftool\Driver\Tag\RAF\RawImageSize(),
                'FujiLayout' => new \PHPExiftool\Driver\Tag\RAF\FujiLayout(),
                'XTransLayout' => new \PHPExiftool\Driver\Tag\RAF\XTransLayout(),
                'WB_GRGBLevelsAuto' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsAuto(),
                'WB_GRGBLevelsDaylight' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsDaylight(),
                'WB_GRGBLevelsCloudy' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsCloudy(),
                'WB_GRGBLevelsDaylightFluor' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsDaylightFluor(),
                'WB_GRGBLevelsDayWhiteFluor' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsDayWhiteFluor(),
                'WB_GRGBLevelsWhiteFluorescent' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsWhiteFluorescent(),
                'WB_GRGBLevelsWarmWhiteFluor' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsWarmWhiteFluor(),
                'WB_GRGBLevelsLivingRoomWarmWhiteFluor' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsLivingRoomWarmWhiteFluor(),
                'WB_GRGBLevelsTungsten' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevelsTungsten(),
                'WB_GRGBLevels' => new \PHPExiftool\Driver\Tag\RAF\WBGRGBLevels(),
                'RawExposureBias' => new \PHPExiftool\Driver\Tag\RAF\RawExposureBias(),
            );
        });
        $this['GE'] = $this->share(function(){
            return array(
                'Macro' => new \PHPExiftool\Driver\Tag\GE\Macro(),
                'GEModel' => new \PHPExiftool\Driver\Tag\GE\GEModel(),
                'GEMake' => new \PHPExiftool\Driver\Tag\GE\GEMake(),
            );
        });
        $this['GIF'] = $this->share(function(){
            return array(
                'AnimationIterations' => new \PHPExiftool\Driver\Tag\GIF\AnimationIterations(),
                'Comment' => new \PHPExiftool\Driver\Tag\GIF\Comment(),
                'Duration' => new \PHPExiftool\Driver\Tag\GIF\Duration(),
                'FrameCount' => new \PHPExiftool\Driver\Tag\GIF\FrameCount(),
                'GIFVersion' => new \PHPExiftool\Driver\Tag\GIF\GIFVersion(),
                'Text' => new \PHPExiftool\Driver\Tag\GIF\Text(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\GIF\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\GIF\ImageHeight(),
                'HasColorMap' => new \PHPExiftool\Driver\Tag\GIF\HasColorMap(),
                'ColorResolutionDepth' => new \PHPExiftool\Driver\Tag\GIF\ColorResolutionDepth(),
                'BitsPerPixel' => new \PHPExiftool\Driver\Tag\GIF\BitsPerPixel(),
                'BackgroundColor' => new \PHPExiftool\Driver\Tag\GIF\BackgroundColor(),
            );
        });
        $this['GIMP'] = $this->share(function(){
            return array(
                'XCFVersion' => new \PHPExiftool\Driver\Tag\GIMP\XCFVersion(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\GIMP\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\GIMP\ImageHeight(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\GIMP\ColorMode(),
                'Compression' => new \PHPExiftool\Driver\Tag\GIMP\Compression(),
                'Comment' => new \PHPExiftool\Driver\Tag\GIMP\Comment(),
                'ICCProfileName' => new \PHPExiftool\Driver\Tag\GIMP\ICCProfileName(),
                'XResolution' => new \PHPExiftool\Driver\Tag\GIMP\XResolution(),
                'YResolution' => new \PHPExiftool\Driver\Tag\GIMP\YResolution(),
            );
        });
        $this['GPS'] = $this->share(function(){
            return array(
                'GPSVersionID' => new \PHPExiftool\Driver\Tag\GPS\GPSVersionID(),
                'GPSLatitudeRef' => new \PHPExiftool\Driver\Tag\GPS\GPSLatitudeRef(),
                'GPSLatitude' => new \PHPExiftool\Driver\Tag\GPS\GPSLatitude(),
                'GPSLongitudeRef' => new \PHPExiftool\Driver\Tag\GPS\GPSLongitudeRef(),
                'GPSLongitude' => new \PHPExiftool\Driver\Tag\GPS\GPSLongitude(),
                'GPSAltitudeRef' => new \PHPExiftool\Driver\Tag\GPS\GPSAltitudeRef(),
                'GPSAltitude' => new \PHPExiftool\Driver\Tag\GPS\GPSAltitude(),
                'GPSTimeStamp' => new \PHPExiftool\Driver\Tag\GPS\GPSTimeStamp(),
                'GPSSatellites' => new \PHPExiftool\Driver\Tag\GPS\GPSSatellites(),
                'GPSStatus' => new \PHPExiftool\Driver\Tag\GPS\GPSStatus(),
                'GPSMeasureMode' => new \PHPExiftool\Driver\Tag\GPS\GPSMeasureMode(),
                'GPSDOP' => new \PHPExiftool\Driver\Tag\GPS\GPSDOP(),
                'GPSSpeedRef' => new \PHPExiftool\Driver\Tag\GPS\GPSSpeedRef(),
                'GPSSpeed' => new \PHPExiftool\Driver\Tag\GPS\GPSSpeed(),
                'GPSTrackRef' => new \PHPExiftool\Driver\Tag\GPS\GPSTrackRef(),
                'GPSTrack' => new \PHPExiftool\Driver\Tag\GPS\GPSTrack(),
                'GPSImgDirectionRef' => new \PHPExiftool\Driver\Tag\GPS\GPSImgDirectionRef(),
                'GPSImgDirection' => new \PHPExiftool\Driver\Tag\GPS\GPSImgDirection(),
                'GPSMapDatum' => new \PHPExiftool\Driver\Tag\GPS\GPSMapDatum(),
                'GPSDestLatitudeRef' => new \PHPExiftool\Driver\Tag\GPS\GPSDestLatitudeRef(),
                'GPSDestLatitude' => new \PHPExiftool\Driver\Tag\GPS\GPSDestLatitude(),
                'GPSDestLongitudeRef' => new \PHPExiftool\Driver\Tag\GPS\GPSDestLongitudeRef(),
                'GPSDestLongitude' => new \PHPExiftool\Driver\Tag\GPS\GPSDestLongitude(),
                'GPSDestBearingRef' => new \PHPExiftool\Driver\Tag\GPS\GPSDestBearingRef(),
                'GPSDestBearing' => new \PHPExiftool\Driver\Tag\GPS\GPSDestBearing(),
                'GPSDestDistanceRef' => new \PHPExiftool\Driver\Tag\GPS\GPSDestDistanceRef(),
                'GPSDestDistance' => new \PHPExiftool\Driver\Tag\GPS\GPSDestDistance(),
                'GPSProcessingMethod' => new \PHPExiftool\Driver\Tag\GPS\GPSProcessingMethod(),
                'GPSAreaInformation' => new \PHPExiftool\Driver\Tag\GPS\GPSAreaInformation(),
                'GPSDateStamp' => new \PHPExiftool\Driver\Tag\GPS\GPSDateStamp(),
                'GPSDifferential' => new \PHPExiftool\Driver\Tag\GPS\GPSDifferential(),
                'GPSHPositioningError' => new \PHPExiftool\Driver\Tag\GPS\GPSHPositioningError(),
            );
        });
        $this['GeoTiff'] = $this->share(function(){
            return array(
                'GeoTiffVersion' => new \PHPExiftool\Driver\Tag\GeoTiff\GeoTiffVersion(),
                'GTModelType' => new \PHPExiftool\Driver\Tag\GeoTiff\GTModelType(),
                'GTRasterType' => new \PHPExiftool\Driver\Tag\GeoTiff\GTRasterType(),
                'GTCitation' => new \PHPExiftool\Driver\Tag\GeoTiff\GTCitation(),
                'GeographicType' => new \PHPExiftool\Driver\Tag\GeoTiff\GeographicType(),
                'GeogCitation' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogCitation(),
                'GeogGeodeticDatum' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogGeodeticDatum(),
                'GeogPrimeMeridian' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogPrimeMeridian(),
                'GeogLinearUnits' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogLinearUnits(),
                'GeogLinearUnitSize' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogLinearUnitSize(),
                'GeogAngularUnits' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogAngularUnits(),
                'GeogAngularUnitSize' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogAngularUnitSize(),
                'GeogEllipsoid' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogEllipsoid(),
                'GeogSemiMajorAxis' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogSemiMajorAxis(),
                'GeogSemiMinorAxis' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogSemiMinorAxis(),
                'GeogInvFlattening' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogInvFlattening(),
                'GeogAzimuthUnits' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogAzimuthUnits(),
                'GeogPrimeMeridianLong' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogPrimeMeridianLong(),
                'GeogToWGS84' => new \PHPExiftool\Driver\Tag\GeoTiff\GeogToWGS84(),
                'ProjectedCSType' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjectedCSType(),
                'PCSCitation' => new \PHPExiftool\Driver\Tag\GeoTiff\PCSCitation(),
                'Projection' => new \PHPExiftool\Driver\Tag\GeoTiff\Projection(),
                'ProjCoordTrans' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjCoordTrans(),
                'ProjLinearUnits' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjLinearUnits(),
                'ProjLinearUnitSize' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjLinearUnitSize(),
                'ProjStdParallel1' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjStdParallel1(),
                'ProjStdParallel2' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjStdParallel2(),
                'ProjNatOriginLong' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjNatOriginLong(),
                'ProjNatOriginLat' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjNatOriginLat(),
                'ProjFalseEasting' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjFalseEasting(),
                'ProjFalseNorthing' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjFalseNorthing(),
                'ProjFalseOriginLong' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjFalseOriginLong(),
                'ProjFalseOriginLat' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjFalseOriginLat(),
                'ProjFalseOriginEasting' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjFalseOriginEasting(),
                'ProjFalseOriginNorthing' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjFalseOriginNorthing(),
                'ProjCenterLong' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjCenterLong(),
                'ProjCenterLat' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjCenterLat(),
                'ProjCenterEasting' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjCenterEasting(),
                'ProjCenterNorthing' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjCenterNorthing(),
                'ProjScaleAtNatOrigin' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjScaleAtNatOrigin(),
                'ProjScaleAtCenter' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjScaleAtCenter(),
                'ProjAzimuthAngle' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjAzimuthAngle(),
                'ProjStraightVertPoleLong' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjStraightVertPoleLong(),
                'ProjRectifiedGridAngle' => new \PHPExiftool\Driver\Tag\GeoTiff\ProjRectifiedGridAngle(),
                'VerticalCSType' => new \PHPExiftool\Driver\Tag\GeoTiff\VerticalCSType(),
                'VerticalCitation' => new \PHPExiftool\Driver\Tag\GeoTiff\VerticalCitation(),
                'VerticalDatum' => new \PHPExiftool\Driver\Tag\GeoTiff\VerticalDatum(),
                'VerticalUnits' => new \PHPExiftool\Driver\Tag\GeoTiff\VerticalUnits(),
                'ChartFormat' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartFormat(),
                'ChartSource' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartSource(),
                'ChartSourceEdition' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartSourceEdition(),
                'ChartSourceDate' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartSourceDate(),
                'ChartCorrDate' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartCorrDate(),
                'ChartCountryOrigin' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartCountryOrigin(),
                'ChartRasterEdition' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartRasterEdition(),
                'ChartSoundingDatum' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartSoundingDatum(),
                'ChartDepthUnits' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartDepthUnits(),
                'ChartMagVar' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartMagVar(),
                'ChartMagVarYear' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartMagVarYear(),
                'ChartMagVarAnnChange' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartMagVarAnnChange(),
                'ChartWGSNSShift' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartWGSNSShift(),
                'InsetNWPixelX' => new \PHPExiftool\Driver\Tag\GeoTiff\InsetNWPixelX(),
                'InsetNWPixelY' => new \PHPExiftool\Driver\Tag\GeoTiff\InsetNWPixelY(),
                'ChartContourInterval' => new \PHPExiftool\Driver\Tag\GeoTiff\ChartContourInterval(),
            );
        });
        $this['H264'] = $this->share(function(){
            return array(
                'ApertureSetting' => new \PHPExiftool\Driver\Tag\H264\ApertureSetting(),
                'Gain' => new \PHPExiftool\Driver\Tag\H264\Gain(),
                'ExposureProgram' => new \PHPExiftool\Driver\Tag\H264\ExposureProgram(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\H264\WhiteBalance(),
                'Focus' => new \PHPExiftool\Driver\Tag\H264\Focus(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\H264\ImageStabilization(),
                'CaptureFrameRate' => new \PHPExiftool\Driver\Tag\H264\CaptureFrameRate(),
                'VideoFrameRate' => new \PHPExiftool\Driver\Tag\H264\VideoFrameRate(),
                'TimeCode' => new \PHPExiftool\Driver\Tag\H264\TimeCode(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\H264\DateTimeOriginal(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\H264\ExposureTime(),
                'FNumber' => new \PHPExiftool\Driver\Tag\H264\FNumber(),
                'BrightnessValue' => new \PHPExiftool\Driver\Tag\H264\BrightnessValue(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\H264\ExposureCompensation(),
                'MaxApertureValue' => new \PHPExiftool\Driver\Tag\H264\MaxApertureValue(),
                'Flash' => new \PHPExiftool\Driver\Tag\H264\Flash(),
                'CustomRendered' => new \PHPExiftool\Driver\Tag\H264\CustomRendered(),
                'FocalLengthIn35mmFormat' => new \PHPExiftool\Driver\Tag\H264\FocalLengthIn35mmFormat(),
                'SceneCaptureType' => new \PHPExiftool\Driver\Tag\H264\SceneCaptureType(),
                'Model' => new \PHPExiftool\Driver\Tag\H264\Model(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\H264\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\H264\ImageWidth(),
                'Make' => new \PHPExiftool\Driver\Tag\H264\Make(),
                'RecordingMode' => new \PHPExiftool\Driver\Tag\H264\RecordingMode(),
            );
        });
        $this['HP'] = $this->share(function(){
            return array(
                'SerialNumber' => new \PHPExiftool\Driver\Tag\HP\SerialNumber(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\HP\FirmwareVersion(),
                'LensShading' => new \PHPExiftool\Driver\Tag\HP\LensShading(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\HP\PreviewImage(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\HP\MaxAperture(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\HP\ExposureTime(),
                'CameraDateTime' => new \PHPExiftool\Driver\Tag\HP\CameraDateTime(),
                'ISO' => new \PHPExiftool\Driver\Tag\HP\ISO(),
                'FNumber' => new \PHPExiftool\Driver\Tag\HP\FNumber(),
            );
        });
        $this['HTML'] = $this->share(function(){
            return array(
                'Abstract' => new \PHPExiftool\Driver\Tag\HTML\Abstract0(),
                'Author' => new \PHPExiftool\Driver\Tag\HTML\Author(),
                'Classification' => new \PHPExiftool\Driver\Tag\HTML\Classification(),
                'ContentLanguage' => new \PHPExiftool\Driver\Tag\HTML\ContentLanguage(),
                'Copyright' => new \PHPExiftool\Driver\Tag\HTML\Copyright(),
                'Description' => new \PHPExiftool\Driver\Tag\HTML\Description(),
                'Distribution' => new \PHPExiftool\Driver\Tag\HTML\Distribution(),
                'DocClass' => new \PHPExiftool\Driver\Tag\HTML\DocClass(),
                'DocRights' => new \PHPExiftool\Driver\Tag\HTML\DocRights(),
                'DocType' => new \PHPExiftool\Driver\Tag\HTML\DocType(),
                'Formatter' => new \PHPExiftool\Driver\Tag\HTML\Formatter(),
                'Generator' => new \PHPExiftool\Driver\Tag\HTML\Generator(),
                'GeneratorVersion' => new \PHPExiftool\Driver\Tag\HTML\GeneratorVersion(),
                'GoogleBot' => new \PHPExiftool\Driver\Tag\HTML\GoogleBot(),
                'Keywords' => new \PHPExiftool\Driver\Tag\HTML\Keywords(),
                'NoMSSmartTags' => new \PHPExiftool\Driver\Tag\HTML\NoMSSmartTags(),
                'Originator' => new \PHPExiftool\Driver\Tag\HTML\Originator(),
                'Owner' => new \PHPExiftool\Driver\Tag\HTML\Owner(),
                'ProgID' => new \PHPExiftool\Driver\Tag\HTML\ProgID(),
                'Rating' => new \PHPExiftool\Driver\Tag\HTML\Rating(),
                'Refresh' => new \PHPExiftool\Driver\Tag\HTML\Refresh(),
                'ResourceType' => new \PHPExiftool\Driver\Tag\HTML\ResourceType(),
                'RevisitAfter' => new \PHPExiftool\Driver\Tag\HTML\RevisitAfter(),
                'Robots' => new \PHPExiftool\Driver\Tag\HTML\Robots(),
                'Title' => new \PHPExiftool\Driver\Tag\HTML\Title(),
            );
        });
        $this['HTML-office'] = $this->share(function(){
            return array(
                'Author' => new \PHPExiftool\Driver\Tag\HTMLOffice\Author(),
                'Category' => new \PHPExiftool\Driver\Tag\HTMLOffice\Category(),
                'Characters' => new \PHPExiftool\Driver\Tag\HTMLOffice\Characters(),
                'CharactersWithSpaces' => new \PHPExiftool\Driver\Tag\HTMLOffice\CharactersWithSpaces(),
                'Company' => new \PHPExiftool\Driver\Tag\HTMLOffice\Company(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\HTMLOffice\CreateDate(),
                'Description' => new \PHPExiftool\Driver\Tag\HTMLOffice\Description(),
                'Keywords' => new \PHPExiftool\Driver\Tag\HTMLOffice\Keywords(),
                'LastAuthor' => new \PHPExiftool\Driver\Tag\HTMLOffice\LastAuthor(),
                'LastPrinted' => new \PHPExiftool\Driver\Tag\HTMLOffice\LastPrinted(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\HTMLOffice\ModifyDate(),
                'Lines' => new \PHPExiftool\Driver\Tag\HTMLOffice\Lines(),
                'Manager' => new \PHPExiftool\Driver\Tag\HTMLOffice\Manager(),
                'Pages' => new \PHPExiftool\Driver\Tag\HTMLOffice\Pages(),
                'Paragraphs' => new \PHPExiftool\Driver\Tag\HTMLOffice\Paragraphs(),
                'RevisionNumber' => new \PHPExiftool\Driver\Tag\HTMLOffice\RevisionNumber(),
                'Subject' => new \PHPExiftool\Driver\Tag\HTMLOffice\Subject(),
                'Template' => new \PHPExiftool\Driver\Tag\HTMLOffice\Template(),
                'TotalEditTime' => new \PHPExiftool\Driver\Tag\HTMLOffice\TotalEditTime(),
                'Words' => new \PHPExiftool\Driver\Tag\HTMLOffice\Words(),
            );
        });
        $this['HTML-dc'] = $this->share(function(){
            return array(
                'Contributor' => new \PHPExiftool\Driver\Tag\HTMLDc\Contributor(),
                'Coverage' => new \PHPExiftool\Driver\Tag\HTMLDc\Coverage(),
                'Creator' => new \PHPExiftool\Driver\Tag\HTMLDc\Creator(),
                'Date' => new \PHPExiftool\Driver\Tag\HTMLDc\Date(),
                'Description' => new \PHPExiftool\Driver\Tag\HTMLDc\Description(),
                'Format' => new \PHPExiftool\Driver\Tag\HTMLDc\Format(),
                'Identifier' => new \PHPExiftool\Driver\Tag\HTMLDc\Identifier(),
                'Language' => new \PHPExiftool\Driver\Tag\HTMLDc\Language(),
                'Publisher' => new \PHPExiftool\Driver\Tag\HTMLDc\Publisher(),
                'Relation' => new \PHPExiftool\Driver\Tag\HTMLDc\Relation(),
                'Rights' => new \PHPExiftool\Driver\Tag\HTMLDc\Rights(),
                'Source' => new \PHPExiftool\Driver\Tag\HTMLDc\Source(),
                'Subject' => new \PHPExiftool\Driver\Tag\HTMLDc\Subject(),
                'Title' => new \PHPExiftool\Driver\Tag\HTMLDc\Title(),
                'Type' => new \PHPExiftool\Driver\Tag\HTMLDc\Type(),
            );
        });
        $this['HTTP-equiv'] = $this->share(function(){
            return array(
                'CacheControl' => new \PHPExiftool\Driver\Tag\HTTPEquiv\CacheControl(),
                'ContentDisposition' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ContentDisposition(),
                'ContentLanguage' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ContentLanguage(),
                'ContentScriptType' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ContentScriptType(),
                'ContentStyleType' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ContentStyleType(),
                'ContentType' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ContentType(),
                'DefaultStyle' => new \PHPExiftool\Driver\Tag\HTTPEquiv\DefaultStyle(),
                'Expires' => new \PHPExiftool\Driver\Tag\HTTPEquiv\Expires(),
                'ExtCache' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ExtCache(),
                'ImageToolbar' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ImageToolbar(),
                'Lotus' => new \PHPExiftool\Driver\Tag\HTTPEquiv\Lotus(),
                'PageEnter' => new \PHPExiftool\Driver\Tag\HTTPEquiv\PageEnter(),
                'PageExit' => new \PHPExiftool\Driver\Tag\HTTPEquiv\PageExit(),
                'PicsLabel' => new \PHPExiftool\Driver\Tag\HTTPEquiv\PicsLabel(),
                'Pragma' => new \PHPExiftool\Driver\Tag\HTTPEquiv\Pragma(),
                'Refresh' => new \PHPExiftool\Driver\Tag\HTTPEquiv\Refresh(),
                'ReplyTo' => new \PHPExiftool\Driver\Tag\HTTPEquiv\ReplyTo(),
                'SetCookie' => new \PHPExiftool\Driver\Tag\HTTPEquiv\SetCookie(),
                'SiteEnter' => new \PHPExiftool\Driver\Tag\HTTPEquiv\SiteEnter(),
                'SiteExit' => new \PHPExiftool\Driver\Tag\HTTPEquiv\SiteExit(),
                'Vary' => new \PHPExiftool\Driver\Tag\HTTPEquiv\Vary(),
                'WindowTarget' => new \PHPExiftool\Driver\Tag\HTTPEquiv\WindowTarget(),
            );
        });
        $this['HTML-ncc'] = $this->share(function(){
            return array(
                'CharacterSet' => new \PHPExiftool\Driver\Tag\HTMLNcc\CharacterSet(),
                'Depth' => new \PHPExiftool\Driver\Tag\HTMLNcc\Depth(),
                'Files' => new \PHPExiftool\Driver\Tag\HTMLNcc\Files(),
                'Footnotes' => new \PHPExiftool\Driver\Tag\HTMLNcc\Footnotes(),
                'Generator' => new \PHPExiftool\Driver\Tag\HTMLNcc\Generator(),
                'KByteSize' => new \PHPExiftool\Driver\Tag\HTMLNcc\KByteSize(),
                'MaxPageNormal' => new \PHPExiftool\Driver\Tag\HTMLNcc\MaxPageNormal(),
                'MultimediaType' => new \PHPExiftool\Driver\Tag\HTMLNcc\MultimediaType(),
                'Narrator' => new \PHPExiftool\Driver\Tag\HTMLNcc\Narrator(),
                'PageFront' => new \PHPExiftool\Driver\Tag\HTMLNcc\PageFront(),
                'PageNormal' => new \PHPExiftool\Driver\Tag\HTMLNcc\PageNormal(),
                'PageSpecial' => new \PHPExiftool\Driver\Tag\HTMLNcc\PageSpecial(),
                'ProdNotes' => new \PHPExiftool\Driver\Tag\HTMLNcc\ProdNotes(),
                'ProducedDate' => new \PHPExiftool\Driver\Tag\HTMLNcc\ProducedDate(),
                'Producer' => new \PHPExiftool\Driver\Tag\HTMLNcc\Producer(),
                'Revision' => new \PHPExiftool\Driver\Tag\HTMLNcc\Revision(),
                'RevisionDate' => new \PHPExiftool\Driver\Tag\HTMLNcc\RevisionDate(),
                'SetInfo' => new \PHPExiftool\Driver\Tag\HTMLNcc\SetInfo(),
                'Sidebars' => new \PHPExiftool\Driver\Tag\HTMLNcc\Sidebars(),
                'SourceDate' => new \PHPExiftool\Driver\Tag\HTMLNcc\SourceDate(),
                'SourceEdition' => new \PHPExiftool\Driver\Tag\HTMLNcc\SourceEdition(),
                'SourcePublisher' => new \PHPExiftool\Driver\Tag\HTMLNcc\SourcePublisher(),
                'SourceRights' => new \PHPExiftool\Driver\Tag\HTMLNcc\SourceRights(),
                'SourceTitle' => new \PHPExiftool\Driver\Tag\HTMLNcc\SourceTitle(),
                'TOCItems' => new \PHPExiftool\Driver\Tag\HTMLNcc\TOCItems(),
                'Duration' => new \PHPExiftool\Driver\Tag\HTMLNcc\Duration(),
            );
        });
        $this['HTML-prod'] = $this->share(function(){
            return array(
                'RecEngineer' => new \PHPExiftool\Driver\Tag\HTMLProd\RecEngineer(),
                'RecLocation' => new \PHPExiftool\Driver\Tag\HTMLProd\RecLocation(),
            );
        });
        $this['HTML-vw96'] = $this->share(function(){
            return array(
                'ObjectType' => new \PHPExiftool\Driver\Tag\HTMLVw96\ObjectType(),
            );
        });
        $this['ICC-chrm'] = $this->share(function(){
            return array(
                'ChromaticityChannels' => new \PHPExiftool\Driver\Tag\ICCChrm\ChromaticityChannels(),
                'ChromaticityColorant' => new \PHPExiftool\Driver\Tag\ICCChrm\ChromaticityColorant(),
                'ChromaticityChannel1' => new \PHPExiftool\Driver\Tag\ICCChrm\ChromaticityChannel1(),
                'ChromaticityChannel2' => new \PHPExiftool\Driver\Tag\ICCChrm\ChromaticityChannel2(),
                'ChromaticityChannel3' => new \PHPExiftool\Driver\Tag\ICCChrm\ChromaticityChannel3(),
                'ChromaticityChannel4' => new \PHPExiftool\Driver\Tag\ICCChrm\ChromaticityChannel4(),
            );
        });
        $this['ICC-clrt'] = $this->share(function(){
            return array(
                'ColorantCount' => new \PHPExiftool\Driver\Tag\ICCClrt\ColorantCount(),
                'Colorant1Name' => new \PHPExiftool\Driver\Tag\ICCClrt\Colorant1Name(),
                'Colorant1Coordinates' => new \PHPExiftool\Driver\Tag\ICCClrt\Colorant1Coordinates(),
                'Colorant2Name' => new \PHPExiftool\Driver\Tag\ICCClrt\Colorant2Name(),
                'Colorant2Coordinates' => new \PHPExiftool\Driver\Tag\ICCClrt\Colorant2Coordinates(),
                'Colorant3Name' => new \PHPExiftool\Driver\Tag\ICCClrt\Colorant3Name(),
                'Colorant3Coordinates' => new \PHPExiftool\Driver\Tag\ICCClrt\Colorant3Coordinates(),
            );
        });
        $this['ICC-header'] = $this->share(function(){
            return array(
                'ProfileCMMType' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileCMMType(),
                'ProfileVersion' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileVersion(),
                'ProfileClass' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileClass(),
                'ColorSpaceData' => new \PHPExiftool\Driver\Tag\ICCHeader\ColorSpaceData(),
                'ProfileConnectionSpace' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileConnectionSpace(),
                'ProfileDateTime' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileDateTime(),
                'ProfileFileSignature' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileFileSignature(),
                'PrimaryPlatform' => new \PHPExiftool\Driver\Tag\ICCHeader\PrimaryPlatform(),
                'CMMFlags' => new \PHPExiftool\Driver\Tag\ICCHeader\CMMFlags(),
                'DeviceManufacturer' => new \PHPExiftool\Driver\Tag\ICCHeader\DeviceManufacturer(),
                'DeviceModel' => new \PHPExiftool\Driver\Tag\ICCHeader\DeviceModel(),
                'DeviceAttributes' => new \PHPExiftool\Driver\Tag\ICCHeader\DeviceAttributes(),
                'RenderingIntent' => new \PHPExiftool\Driver\Tag\ICCHeader\RenderingIntent(),
                'ConnectionSpaceIlluminant' => new \PHPExiftool\Driver\Tag\ICCHeader\ConnectionSpaceIlluminant(),
                'ProfileCreator' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileCreator(),
                'ProfileID' => new \PHPExiftool\Driver\Tag\ICCHeader\ProfileID(),
            );
        });
        $this['ICC-meas'] = $this->share(function(){
            return array(
                'MeasurementObserver' => new \PHPExiftool\Driver\Tag\ICCMeas\MeasurementObserver(),
                'MeasurementBacking' => new \PHPExiftool\Driver\Tag\ICCMeas\MeasurementBacking(),
                'MeasurementGeometry' => new \PHPExiftool\Driver\Tag\ICCMeas\MeasurementGeometry(),
                'MeasurementFlare' => new \PHPExiftool\Driver\Tag\ICCMeas\MeasurementFlare(),
                'MeasurementIlluminant' => new \PHPExiftool\Driver\Tag\ICCMeas\MeasurementIlluminant(),
            );
        });
        $this['ICC-meta'] = $this->share(function(){
            return array(
                'ManufacturerName' => new \PHPExiftool\Driver\Tag\ICCMeta\ManufacturerName(),
                'MediaColor' => new \PHPExiftool\Driver\Tag\ICCMeta\MediaColor(),
                'MediaWeight' => new \PHPExiftool\Driver\Tag\ICCMeta\MediaWeight(),
            );
        });
        $this['ICC-view'] = $this->share(function(){
            return array(
                'ViewingCondIlluminant' => new \PHPExiftool\Driver\Tag\ICCView\ViewingCondIlluminant(),
                'ViewingCondSurround' => new \PHPExiftool\Driver\Tag\ICCView\ViewingCondSurround(),
                'ViewingCondIlluminantType' => new \PHPExiftool\Driver\Tag\ICCView\ViewingCondIlluminantType(),
            );
        });
        $this['ID3'] = $this->share(function(){
            return array(
                'AverageLevel' => new \PHPExiftool\Driver\Tag\ID3\AverageLevel(),
                'PeakValue' => new \PHPExiftool\Driver\Tag\ID3\PeakValue(),
                'WM_MediaClassPrimaryID' => new \PHPExiftool\Driver\Tag\ID3\WMMediaClassPrimaryID(),
                'WM_MediaClassSecondaryID' => new \PHPExiftool\Driver\Tag\ID3\WMMediaClassSecondaryID(),
                'WM_Provider' => new \PHPExiftool\Driver\Tag\ID3\WMProvider(),
                'WM_CollectionGroupID' => new \PHPExiftool\Driver\Tag\ID3\WMCollectionGroupID(),
                'WM_CollectionID' => new \PHPExiftool\Driver\Tag\ID3\WMCollectionID(),
                'WM_ContentID' => new \PHPExiftool\Driver\Tag\ID3\WMContentID(),
                'SynchronizedLyricsDescription' => new \PHPExiftool\Driver\Tag\ID3\SynchronizedLyricsDescription(),
                'SynchronizedLyricsText' => new \PHPExiftool\Driver\Tag\ID3\SynchronizedLyricsText(),
                'SynchronizedLyricsType' => new \PHPExiftool\Driver\Tag\ID3\SynchronizedLyricsType(),
            );
        });
        $this['ID3v1'] = $this->share(function(){
            return array(
                'Title' => new \PHPExiftool\Driver\Tag\ID3v1\Title(),
                'Artist' => new \PHPExiftool\Driver\Tag\ID3v1\Artist(),
                'Album' => new \PHPExiftool\Driver\Tag\ID3v1\Album(),
                'Year' => new \PHPExiftool\Driver\Tag\ID3v1\Year(),
                'Comment' => new \PHPExiftool\Driver\Tag\ID3v1\Comment(),
                'Track' => new \PHPExiftool\Driver\Tag\ID3v1\Track(),
                'Genre' => new \PHPExiftool\Driver\Tag\ID3v1\Genre(),
            );
        });
        $this['ID3v1_Enh'] = $this->share(function(){
            return array(
                'Title2' => new \PHPExiftool\Driver\Tag\ID3v1Enh\Title2(),
                'Artist2' => new \PHPExiftool\Driver\Tag\ID3v1Enh\Artist2(),
                'Album2' => new \PHPExiftool\Driver\Tag\ID3v1Enh\Album2(),
                'Speed' => new \PHPExiftool\Driver\Tag\ID3v1Enh\Speed(),
                'Genre' => new \PHPExiftool\Driver\Tag\ID3v1Enh\Genre(),
                'StartTime' => new \PHPExiftool\Driver\Tag\ID3v1Enh\StartTime(),
                'EndTime' => new \PHPExiftool\Driver\Tag\ID3v1Enh\EndTime(),
            );
        });
        $this['ID3v2_2'] = $this->share(function(){
            return array(
                'PlayCounter' => new \PHPExiftool\Driver\Tag\ID3v22\PlayCounter(),
                'Comment' => new \PHPExiftool\Driver\Tag\ID3v22\Comment(),
                'InvolvedPeople' => new \PHPExiftool\Driver\Tag\ID3v22\InvolvedPeople(),
                'iTunesU' => new \PHPExiftool\Driver\Tag\ID3v22\ITunesU(),
                'Podcast' => new \PHPExiftool\Driver\Tag\ID3v22\Podcast(),
                'Picture' => new \PHPExiftool\Driver\Tag\ID3v22\Picture(),
                'PictureFormat' => new \PHPExiftool\Driver\Tag\ID3v22\PictureFormat(),
                'PictureType' => new \PHPExiftool\Driver\Tag\ID3v22\PictureType(),
                'PictureDescription' => new \PHPExiftool\Driver\Tag\ID3v22\PictureDescription(),
                'Popularimeter' => new \PHPExiftool\Driver\Tag\ID3v22\Popularimeter(),
                'RelativeVolumeAdjustment' => new \PHPExiftool\Driver\Tag\ID3v22\RelativeVolumeAdjustment(),
                'Album' => new \PHPExiftool\Driver\Tag\ID3v22\Album(),
                'BeatsPerMinute' => new \PHPExiftool\Driver\Tag\ID3v22\BeatsPerMinute(),
                'Composer' => new \PHPExiftool\Driver\Tag\ID3v22\Composer(),
                'Genre' => new \PHPExiftool\Driver\Tag\ID3v22\Genre(),
                'Compilation' => new \PHPExiftool\Driver\Tag\ID3v22\Compilation(),
                'Copyright' => new \PHPExiftool\Driver\Tag\ID3v22\Copyright(),
                'Date' => new \PHPExiftool\Driver\Tag\ID3v22\Date(),
                'PlaylistDelay' => new \PHPExiftool\Driver\Tag\ID3v22\PlaylistDelay(),
                'EncodedBy' => new \PHPExiftool\Driver\Tag\ID3v22\EncodedBy(),
                'FileType' => new \PHPExiftool\Driver\Tag\ID3v22\FileType(),
                'Time' => new \PHPExiftool\Driver\Tag\ID3v22\Time(),
                'InitialKey' => new \PHPExiftool\Driver\Tag\ID3v22\InitialKey(),
                'Language' => new \PHPExiftool\Driver\Tag\ID3v22\Language(),
                'Length' => new \PHPExiftool\Driver\Tag\ID3v22\Length(),
                'Media' => new \PHPExiftool\Driver\Tag\ID3v22\Media(),
                'OriginalArtist' => new \PHPExiftool\Driver\Tag\ID3v22\OriginalArtist(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\ID3v22\OriginalFileName(),
                'OriginalLyricist' => new \PHPExiftool\Driver\Tag\ID3v22\OriginalLyricist(),
                'OriginalReleaseYear' => new \PHPExiftool\Driver\Tag\ID3v22\OriginalReleaseYear(),
                'OriginalAlbum' => new \PHPExiftool\Driver\Tag\ID3v22\OriginalAlbum(),
                'Artist' => new \PHPExiftool\Driver\Tag\ID3v22\Artist(),
                'Band' => new \PHPExiftool\Driver\Tag\ID3v22\Band(),
                'Conductor' => new \PHPExiftool\Driver\Tag\ID3v22\Conductor(),
                'InterpretedBy' => new \PHPExiftool\Driver\Tag\ID3v22\InterpretedBy(),
                'PartOfSet' => new \PHPExiftool\Driver\Tag\ID3v22\PartOfSet(),
                'Publisher' => new \PHPExiftool\Driver\Tag\ID3v22\Publisher(),
                'ISRC' => new \PHPExiftool\Driver\Tag\ID3v22\ISRC(),
                'RecordingDates' => new \PHPExiftool\Driver\Tag\ID3v22\RecordingDates(),
                'Track' => new \PHPExiftool\Driver\Tag\ID3v22\Track(),
                'AlbumArtistSortOrder' => new \PHPExiftool\Driver\Tag\ID3v22\AlbumArtistSortOrder(),
                'AlbumSortOrder' => new \PHPExiftool\Driver\Tag\ID3v22\AlbumSortOrder(),
                'ComposerSortOrder' => new \PHPExiftool\Driver\Tag\ID3v22\ComposerSortOrder(),
                'Size' => new \PHPExiftool\Driver\Tag\ID3v22\Size(),
                'PerformerSortOrder' => new \PHPExiftool\Driver\Tag\ID3v22\PerformerSortOrder(),
                'EncoderSettings' => new \PHPExiftool\Driver\Tag\ID3v22\EncoderSettings(),
                'TitleSortOrder' => new \PHPExiftool\Driver\Tag\ID3v22\TitleSortOrder(),
                'Grouping' => new \PHPExiftool\Driver\Tag\ID3v22\Grouping(),
                'Title' => new \PHPExiftool\Driver\Tag\ID3v22\Title(),
                'Subtitle' => new \PHPExiftool\Driver\Tag\ID3v22\Subtitle(),
                'Lyricist' => new \PHPExiftool\Driver\Tag\ID3v22\Lyricist(),
                'UserDefinedText' => new \PHPExiftool\Driver\Tag\ID3v22\UserDefinedText(),
                'Year' => new \PHPExiftool\Driver\Tag\ID3v22\Year(),
                'Lyrics' => new \PHPExiftool\Driver\Tag\ID3v22\Lyrics(),
                'FileURL' => new \PHPExiftool\Driver\Tag\ID3v22\FileURL(),
                'ArtistURL' => new \PHPExiftool\Driver\Tag\ID3v22\ArtistURL(),
                'SourceURL' => new \PHPExiftool\Driver\Tag\ID3v22\SourceURL(),
                'CommercialURL' => new \PHPExiftool\Driver\Tag\ID3v22\CommercialURL(),
                'CopyrightURL' => new \PHPExiftool\Driver\Tag\ID3v22\CopyrightURL(),
                'PublisherURL' => new \PHPExiftool\Driver\Tag\ID3v22\PublisherURL(),
                'UserDefinedURL' => new \PHPExiftool\Driver\Tag\ID3v22\UserDefinedURL(),
            );
        });
        $this['ID3v2_3'] = $this->share(function(){
            return array(
                'Picture' => new \PHPExiftool\Driver\Tag\ID3v23\Picture(),
                'PictureMIMEType' => new \PHPExiftool\Driver\Tag\ID3v23\PictureMIMEType(),
                'PictureType' => new \PHPExiftool\Driver\Tag\ID3v23\PictureType(),
                'PictureDescription' => new \PHPExiftool\Driver\Tag\ID3v23\PictureDescription(),
                'Comment' => new \PHPExiftool\Driver\Tag\ID3v23\Comment(),
                'InvolvedPeople' => new \PHPExiftool\Driver\Tag\ID3v23\InvolvedPeople(),
                'iTunesU' => new \PHPExiftool\Driver\Tag\ID3v23\ITunesU(),
                'MusicCDIdentifier' => new \PHPExiftool\Driver\Tag\ID3v23\MusicCDIdentifier(),
                'Ownership' => new \PHPExiftool\Driver\Tag\ID3v23\Ownership(),
                'PlayCounter' => new \PHPExiftool\Driver\Tag\ID3v23\PlayCounter(),
                'Podcast' => new \PHPExiftool\Driver\Tag\ID3v23\Podcast(),
                'Popularimeter' => new \PHPExiftool\Driver\Tag\ID3v23\Popularimeter(),
                'Album' => new \PHPExiftool\Driver\Tag\ID3v23\Album(),
                'BeatsPerMinute' => new \PHPExiftool\Driver\Tag\ID3v23\BeatsPerMinute(),
                'PodcastCategory' => new \PHPExiftool\Driver\Tag\ID3v23\PodcastCategory(),
                'Compilation' => new \PHPExiftool\Driver\Tag\ID3v23\Compilation(),
                'Composer' => new \PHPExiftool\Driver\Tag\ID3v23\Composer(),
                'Genre' => new \PHPExiftool\Driver\Tag\ID3v23\Genre(),
                'Copyright' => new \PHPExiftool\Driver\Tag\ID3v23\Copyright(),
                'Date' => new \PHPExiftool\Driver\Tag\ID3v23\Date(),
                'PodcastDescription' => new \PHPExiftool\Driver\Tag\ID3v23\PodcastDescription(),
                'PlaylistDelay' => new \PHPExiftool\Driver\Tag\ID3v23\PlaylistDelay(),
                'EncodedBy' => new \PHPExiftool\Driver\Tag\ID3v23\EncodedBy(),
                'Lyricist' => new \PHPExiftool\Driver\Tag\ID3v23\Lyricist(),
                'FileType' => new \PHPExiftool\Driver\Tag\ID3v23\FileType(),
                'PodcastID' => new \PHPExiftool\Driver\Tag\ID3v23\PodcastID(),
                'Time' => new \PHPExiftool\Driver\Tag\ID3v23\Time(),
                'Grouping' => new \PHPExiftool\Driver\Tag\ID3v23\Grouping(),
                'Title' => new \PHPExiftool\Driver\Tag\ID3v23\Title(),
                'Subtitle' => new \PHPExiftool\Driver\Tag\ID3v23\Subtitle(),
                'InitialKey' => new \PHPExiftool\Driver\Tag\ID3v23\InitialKey(),
                'PodcastKeywords' => new \PHPExiftool\Driver\Tag\ID3v23\PodcastKeywords(),
                'Language' => new \PHPExiftool\Driver\Tag\ID3v23\Language(),
                'Length' => new \PHPExiftool\Driver\Tag\ID3v23\Length(),
                'Media' => new \PHPExiftool\Driver\Tag\ID3v23\Media(),
                'OriginalAlbum' => new \PHPExiftool\Driver\Tag\ID3v23\OriginalAlbum(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\ID3v23\OriginalFileName(),
                'OriginalLyricist' => new \PHPExiftool\Driver\Tag\ID3v23\OriginalLyricist(),
                'OriginalArtist' => new \PHPExiftool\Driver\Tag\ID3v23\OriginalArtist(),
                'OriginalReleaseYear' => new \PHPExiftool\Driver\Tag\ID3v23\OriginalReleaseYear(),
                'FileOwner' => new \PHPExiftool\Driver\Tag\ID3v23\FileOwner(),
                'Artist' => new \PHPExiftool\Driver\Tag\ID3v23\Artist(),
                'Band' => new \PHPExiftool\Driver\Tag\ID3v23\Band(),
                'Conductor' => new \PHPExiftool\Driver\Tag\ID3v23\Conductor(),
                'InterpretedBy' => new \PHPExiftool\Driver\Tag\ID3v23\InterpretedBy(),
                'PartOfSet' => new \PHPExiftool\Driver\Tag\ID3v23\PartOfSet(),
                'Publisher' => new \PHPExiftool\Driver\Tag\ID3v23\Publisher(),
                'Track' => new \PHPExiftool\Driver\Tag\ID3v23\Track(),
                'RecordingDates' => new \PHPExiftool\Driver\Tag\ID3v23\RecordingDates(),
                'InternetRadioStationName' => new \PHPExiftool\Driver\Tag\ID3v23\InternetRadioStationName(),
                'InternetRadioStationOwner' => new \PHPExiftool\Driver\Tag\ID3v23\InternetRadioStationOwner(),
                'Size' => new \PHPExiftool\Driver\Tag\ID3v23\Size(),
                'AlbumArtistSortOrder' => new \PHPExiftool\Driver\Tag\ID3v23\AlbumArtistSortOrder(),
                'ComposerSortOrder' => new \PHPExiftool\Driver\Tag\ID3v23\ComposerSortOrder(),
                'ISRC' => new \PHPExiftool\Driver\Tag\ID3v23\ISRC(),
                'EncoderSettings' => new \PHPExiftool\Driver\Tag\ID3v23\EncoderSettings(),
                'UserDefinedText' => new \PHPExiftool\Driver\Tag\ID3v23\UserDefinedText(),
                'Year' => new \PHPExiftool\Driver\Tag\ID3v23\Year(),
                'TermsOfUse' => new \PHPExiftool\Driver\Tag\ID3v23\TermsOfUse(),
                'Lyrics' => new \PHPExiftool\Driver\Tag\ID3v23\Lyrics(),
                'CommercialURL' => new \PHPExiftool\Driver\Tag\ID3v23\CommercialURL(),
                'CopyrightURL' => new \PHPExiftool\Driver\Tag\ID3v23\CopyrightURL(),
                'PodcastURL' => new \PHPExiftool\Driver\Tag\ID3v23\PodcastURL(),
                'FileURL' => new \PHPExiftool\Driver\Tag\ID3v23\FileURL(),
                'ArtistURL' => new \PHPExiftool\Driver\Tag\ID3v23\ArtistURL(),
                'SourceURL' => new \PHPExiftool\Driver\Tag\ID3v23\SourceURL(),
                'InternetRadioStationURL' => new \PHPExiftool\Driver\Tag\ID3v23\InternetRadioStationURL(),
                'PaymentURL' => new \PHPExiftool\Driver\Tag\ID3v23\PaymentURL(),
                'PublisherURL' => new \PHPExiftool\Driver\Tag\ID3v23\PublisherURL(),
                'UserDefinedURL' => new \PHPExiftool\Driver\Tag\ID3v23\UserDefinedURL(),
                'OriginalReleaseTime' => new \PHPExiftool\Driver\Tag\ID3v23\OriginalReleaseTime(),
                'AlbumSortOrder' => new \PHPExiftool\Driver\Tag\ID3v23\AlbumSortOrder(),
                'PerformerSortOrder' => new \PHPExiftool\Driver\Tag\ID3v23\PerformerSortOrder(),
                'TitleSortOrder' => new \PHPExiftool\Driver\Tag\ID3v23\TitleSortOrder(),
            );
        });
        $this['ID3v2_4'] = $this->share(function(){
            return array(
                'Picture' => new \PHPExiftool\Driver\Tag\ID3v24\Picture(),
                'PictureMIMEType' => new \PHPExiftool\Driver\Tag\ID3v24\PictureMIMEType(),
                'PictureType' => new \PHPExiftool\Driver\Tag\ID3v24\PictureType(),
                'PictureDescription' => new \PHPExiftool\Driver\Tag\ID3v24\PictureDescription(),
                'Comment' => new \PHPExiftool\Driver\Tag\ID3v24\Comment(),
                'iTunesU' => new \PHPExiftool\Driver\Tag\ID3v24\ITunesU(),
                'MusicCDIdentifier' => new \PHPExiftool\Driver\Tag\ID3v24\MusicCDIdentifier(),
                'Ownership' => new \PHPExiftool\Driver\Tag\ID3v24\Ownership(),
                'PlayCounter' => new \PHPExiftool\Driver\Tag\ID3v24\PlayCounter(),
                'Podcast' => new \PHPExiftool\Driver\Tag\ID3v24\Podcast(),
                'Popularimeter' => new \PHPExiftool\Driver\Tag\ID3v24\Popularimeter(),
                'RelativeVolumeAdjustment' => new \PHPExiftool\Driver\Tag\ID3v24\RelativeVolumeAdjustment(),
                'Album' => new \PHPExiftool\Driver\Tag\ID3v24\Album(),
                'BeatsPerMinute' => new \PHPExiftool\Driver\Tag\ID3v24\BeatsPerMinute(),
                'PodcastCategory' => new \PHPExiftool\Driver\Tag\ID3v24\PodcastCategory(),
                'Compilation' => new \PHPExiftool\Driver\Tag\ID3v24\Compilation(),
                'Composer' => new \PHPExiftool\Driver\Tag\ID3v24\Composer(),
                'Genre' => new \PHPExiftool\Driver\Tag\ID3v24\Genre(),
                'Copyright' => new \PHPExiftool\Driver\Tag\ID3v24\Copyright(),
                'EncodingTime' => new \PHPExiftool\Driver\Tag\ID3v24\EncodingTime(),
                'PodcastDescription' => new \PHPExiftool\Driver\Tag\ID3v24\PodcastDescription(),
                'PlaylistDelay' => new \PHPExiftool\Driver\Tag\ID3v24\PlaylistDelay(),
                'OriginalReleaseTime' => new \PHPExiftool\Driver\Tag\ID3v24\OriginalReleaseTime(),
                'RecordingTime' => new \PHPExiftool\Driver\Tag\ID3v24\RecordingTime(),
                'ReleaseTime' => new \PHPExiftool\Driver\Tag\ID3v24\ReleaseTime(),
                'TaggingTime' => new \PHPExiftool\Driver\Tag\ID3v24\TaggingTime(),
                'EncodedBy' => new \PHPExiftool\Driver\Tag\ID3v24\EncodedBy(),
                'Lyricist' => new \PHPExiftool\Driver\Tag\ID3v24\Lyricist(),
                'FileType' => new \PHPExiftool\Driver\Tag\ID3v24\FileType(),
                'PodcastID' => new \PHPExiftool\Driver\Tag\ID3v24\PodcastID(),
                'InvolvedPeople' => new \PHPExiftool\Driver\Tag\ID3v24\InvolvedPeople(),
                'Grouping' => new \PHPExiftool\Driver\Tag\ID3v24\Grouping(),
                'Title' => new \PHPExiftool\Driver\Tag\ID3v24\Title(),
                'Subtitle' => new \PHPExiftool\Driver\Tag\ID3v24\Subtitle(),
                'InitialKey' => new \PHPExiftool\Driver\Tag\ID3v24\InitialKey(),
                'PodcastKeywords' => new \PHPExiftool\Driver\Tag\ID3v24\PodcastKeywords(),
                'Language' => new \PHPExiftool\Driver\Tag\ID3v24\Language(),
                'Length' => new \PHPExiftool\Driver\Tag\ID3v24\Length(),
                'MusicianCredits' => new \PHPExiftool\Driver\Tag\ID3v24\MusicianCredits(),
                'Media' => new \PHPExiftool\Driver\Tag\ID3v24\Media(),
                'Mood' => new \PHPExiftool\Driver\Tag\ID3v24\Mood(),
                'OriginalAlbum' => new \PHPExiftool\Driver\Tag\ID3v24\OriginalAlbum(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\ID3v24\OriginalFileName(),
                'OriginalLyricist' => new \PHPExiftool\Driver\Tag\ID3v24\OriginalLyricist(),
                'OriginalArtist' => new \PHPExiftool\Driver\Tag\ID3v24\OriginalArtist(),
                'FileOwner' => new \PHPExiftool\Driver\Tag\ID3v24\FileOwner(),
                'Artist' => new \PHPExiftool\Driver\Tag\ID3v24\Artist(),
                'Band' => new \PHPExiftool\Driver\Tag\ID3v24\Band(),
                'Conductor' => new \PHPExiftool\Driver\Tag\ID3v24\Conductor(),
                'InterpretedBy' => new \PHPExiftool\Driver\Tag\ID3v24\InterpretedBy(),
                'PartOfSet' => new \PHPExiftool\Driver\Tag\ID3v24\PartOfSet(),
                'ProducedNotice' => new \PHPExiftool\Driver\Tag\ID3v24\ProducedNotice(),
                'Publisher' => new \PHPExiftool\Driver\Tag\ID3v24\Publisher(),
                'Track' => new \PHPExiftool\Driver\Tag\ID3v24\Track(),
                'InternetRadioStationName' => new \PHPExiftool\Driver\Tag\ID3v24\InternetRadioStationName(),
                'InternetRadioStationOwner' => new \PHPExiftool\Driver\Tag\ID3v24\InternetRadioStationOwner(),
                'AlbumArtistSortOrder' => new \PHPExiftool\Driver\Tag\ID3v24\AlbumArtistSortOrder(),
                'AlbumSortOrder' => new \PHPExiftool\Driver\Tag\ID3v24\AlbumSortOrder(),
                'ComposerSortOrder' => new \PHPExiftool\Driver\Tag\ID3v24\ComposerSortOrder(),
                'PerformerSortOrder' => new \PHPExiftool\Driver\Tag\ID3v24\PerformerSortOrder(),
                'TitleSortOrder' => new \PHPExiftool\Driver\Tag\ID3v24\TitleSortOrder(),
                'ISRC' => new \PHPExiftool\Driver\Tag\ID3v24\ISRC(),
                'EncoderSettings' => new \PHPExiftool\Driver\Tag\ID3v24\EncoderSettings(),
                'SetSubtitle' => new \PHPExiftool\Driver\Tag\ID3v24\SetSubtitle(),
                'UserDefinedText' => new \PHPExiftool\Driver\Tag\ID3v24\UserDefinedText(),
                'TermsOfUse' => new \PHPExiftool\Driver\Tag\ID3v24\TermsOfUse(),
                'Lyrics' => new \PHPExiftool\Driver\Tag\ID3v24\Lyrics(),
                'CommercialURL' => new \PHPExiftool\Driver\Tag\ID3v24\CommercialURL(),
                'CopyrightURL' => new \PHPExiftool\Driver\Tag\ID3v24\CopyrightURL(),
                'PodcastURL' => new \PHPExiftool\Driver\Tag\ID3v24\PodcastURL(),
                'FileURL' => new \PHPExiftool\Driver\Tag\ID3v24\FileURL(),
                'ArtistURL' => new \PHPExiftool\Driver\Tag\ID3v24\ArtistURL(),
                'SourceURL' => new \PHPExiftool\Driver\Tag\ID3v24\SourceURL(),
                'InternetRadioStationURL' => new \PHPExiftool\Driver\Tag\ID3v24\InternetRadioStationURL(),
                'PaymentURL' => new \PHPExiftool\Driver\Tag\ID3v24\PaymentURL(),
                'PublisherURL' => new \PHPExiftool\Driver\Tag\ID3v24\PublisherURL(),
                'UserDefinedURL' => new \PHPExiftool\Driver\Tag\ID3v24\UserDefinedURL(),
            );
        });
        $this['ITC'] = $this->share(function(){
            return array(
                'DataType' => new \PHPExiftool\Driver\Tag\ITC\DataType(),
                'LibraryID' => new \PHPExiftool\Driver\Tag\ITC\LibraryID(),
                'TrackID' => new \PHPExiftool\Driver\Tag\ITC\TrackID(),
                'DataLocation' => new \PHPExiftool\Driver\Tag\ITC\DataLocation(),
                'ImageType' => new \PHPExiftool\Driver\Tag\ITC\ImageType(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\ITC\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\ITC\ImageHeight(),
                'ImageData' => new \PHPExiftool\Driver\Tag\ITC\ImageData(),
            );
        });
        $this['JFIF'] = $this->share(function(){
            return array(
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\JFIF\ThumbnailImage(),
                'JFIFVersion' => new \PHPExiftool\Driver\Tag\JFIF\JFIFVersion(),
                'ResolutionUnit' => new \PHPExiftool\Driver\Tag\JFIF\ResolutionUnit(),
                'XResolution' => new \PHPExiftool\Driver\Tag\JFIF\XResolution(),
                'YResolution' => new \PHPExiftool\Driver\Tag\JFIF\YResolution(),
            );
        });
        $this['AVI1'] = $this->share(function(){
            return array(
                'InterleavedField' => new \PHPExiftool\Driver\Tag\AVI1\InterleavedField(),
            );
        });
        $this['AdobeCM'] = $this->share(function(){
            return array(
                'AdobeCMType' => new \PHPExiftool\Driver\Tag\AdobeCM\AdobeCMType(),
            );
        });
        $this['EPPIM'] = $this->share(function(){
            return array(
                'PrintIM' => new \PHPExiftool\Driver\Tag\EPPIM\PrintIM(),
            );
        });
        $this['GraphConv'] = $this->share(function(){
            return array(
                'Quality' => new \PHPExiftool\Driver\Tag\GraphConv\Quality(),
            );
        });
        $this['JPEG-HDR'] = $this->share(function(){
            return array(
                'RatioImage' => new \PHPExiftool\Driver\Tag\JPEGHDR\RatioImage(),
                'Alpha' => new \PHPExiftool\Driver\Tag\JPEGHDR\Alpha(),
                'Beta' => new \PHPExiftool\Driver\Tag\JPEGHDR\Beta(),
                'CorrectionMethod' => new \PHPExiftool\Driver\Tag\JPEGHDR\CorrectionMethod(),
                'Ln0' => new \PHPExiftool\Driver\Tag\JPEGHDR\Ln0(),
                'Ln1' => new \PHPExiftool\Driver\Tag\JPEGHDR\Ln1(),
                'S2n' => new \PHPExiftool\Driver\Tag\JPEGHDR\S2n(),
                'JPEG-HDRVersion' => new \PHPExiftool\Driver\Tag\JPEGHDR\JPEGHDRVersion(),
            );
        });
        $this['JPEG'] = $this->share(function(){
            return array(
                'PreviewImage' => new \PHPExiftool\Driver\Tag\JPEG\PreviewImage(),
                'Comment' => new \PHPExiftool\Driver\Tag\JPEG\Comment(),
                'Adobe' => new \PHPExiftool\Driver\Tag\JPEG\Adobe(),
                'DefineQuantizationTable' => new \PHPExiftool\Driver\Tag\JPEG\DefineQuantizationTable(),
            );
        });
        $this['MediaJukebox'] = $this->share(function(){
            return array(
                'Album' => new \PHPExiftool\Driver\Tag\MediaJukebox\Album(),
                'Caption' => new \PHPExiftool\Driver\Tag\MediaJukebox\Caption(),
                'Date' => new \PHPExiftool\Driver\Tag\MediaJukebox\Date(),
                'Keywords' => new \PHPExiftool\Driver\Tag\MediaJukebox\Keywords(),
                'Name' => new \PHPExiftool\Driver\Tag\MediaJukebox\Name(),
                'People' => new \PHPExiftool\Driver\Tag\MediaJukebox\People(),
                'Places' => new \PHPExiftool\Driver\Tag\MediaJukebox\Places(),
                'Tool_Name' => new \PHPExiftool\Driver\Tag\MediaJukebox\ToolName(),
                'Tool_Version' => new \PHPExiftool\Driver\Tag\MediaJukebox\ToolVersion(),
            );
        });
        $this['NITF'] = $this->share(function(){
            return array(
                'NITFVersion' => new \PHPExiftool\Driver\Tag\NITF\NITFVersion(),
                'ImageFormat' => new \PHPExiftool\Driver\Tag\NITF\ImageFormat(),
                'BlocksPerRow' => new \PHPExiftool\Driver\Tag\NITF\BlocksPerRow(),
                'BlocksPerColumn' => new \PHPExiftool\Driver\Tag\NITF\BlocksPerColumn(),
                'ImageColor' => new \PHPExiftool\Driver\Tag\NITF\ImageColor(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\NITF\BitDepth(),
                'ImageClass' => new \PHPExiftool\Driver\Tag\NITF\ImageClass(),
                'JPEGProcess' => new \PHPExiftool\Driver\Tag\NITF\JPEGProcess(),
                'Quality' => new \PHPExiftool\Driver\Tag\NITF\Quality(),
                'StreamColor' => new \PHPExiftool\Driver\Tag\NITF\StreamColor(),
                'StreamBitDepth' => new \PHPExiftool\Driver\Tag\NITF\StreamBitDepth(),
                'Flags' => new \PHPExiftool\Driver\Tag\NITF\Flags(),
            );
        });
        $this['Ocad'] = $this->share(function(){
            return array(
                'OcadRevision' => new \PHPExiftool\Driver\Tag\Ocad\OcadRevision(),
            );
        });
        $this['SPIFF'] = $this->share(function(){
            return array(
                'SPIFFVersion' => new \PHPExiftool\Driver\Tag\SPIFF\SPIFFVersion(),
                'ProfileID' => new \PHPExiftool\Driver\Tag\SPIFF\ProfileID(),
                'ColorComponents' => new \PHPExiftool\Driver\Tag\SPIFF\ColorComponents(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\SPIFF\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\SPIFF\ImageWidth(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\SPIFF\ColorSpace(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\SPIFF\BitsPerSample(),
                'Compression' => new \PHPExiftool\Driver\Tag\SPIFF\Compression(),
                'ResolutionUnit' => new \PHPExiftool\Driver\Tag\SPIFF\ResolutionUnit(),
                'YResolution' => new \PHPExiftool\Driver\Tag\SPIFF\YResolution(),
                'XResolution' => new \PHPExiftool\Driver\Tag\SPIFF\XResolution(),
            );
        });
        $this['JVC'] = $this->share(function(){
            return array(
                'CPUVersions' => new \PHPExiftool\Driver\Tag\JVC\CPUVersions(),
                'Quality' => new \PHPExiftool\Driver\Tag\JVC\Quality(),
                'MakerNoteVersion' => new \PHPExiftool\Driver\Tag\JVC\MakerNoteVersion(),
            );
        });
        $this['Jpeg2000'] = $this->share(function(){
            return array(
                'CaptureYResolution' => new \PHPExiftool\Driver\Tag\Jpeg2000\CaptureYResolution(),
                'CaptureXResolution' => new \PHPExiftool\Driver\Tag\Jpeg2000\CaptureXResolution(),
                'CaptureYResolutionUnit' => new \PHPExiftool\Driver\Tag\Jpeg2000\CaptureYResolutionUnit(),
                'CaptureXResolutionUnit' => new \PHPExiftool\Driver\Tag\Jpeg2000\CaptureXResolutionUnit(),
                'ColorSpecMethod' => new \PHPExiftool\Driver\Tag\Jpeg2000\ColorSpecMethod(),
                'ColorSpecPrecedence' => new \PHPExiftool\Driver\Tag\Jpeg2000\ColorSpecPrecedence(),
                'ColorSpecApproximation' => new \PHPExiftool\Driver\Tag\Jpeg2000\ColorSpecApproximation(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\Jpeg2000\ColorSpace(),
                'ColorSpecData' => new \PHPExiftool\Driver\Tag\Jpeg2000\ColorSpecData(),
                'DisplayYResolution' => new \PHPExiftool\Driver\Tag\Jpeg2000\DisplayYResolution(),
                'DisplayXResolution' => new \PHPExiftool\Driver\Tag\Jpeg2000\DisplayXResolution(),
                'DisplayYResolutionUnit' => new \PHPExiftool\Driver\Tag\Jpeg2000\DisplayYResolutionUnit(),
                'DisplayXResolutionUnit' => new \PHPExiftool\Driver\Tag\Jpeg2000\DisplayXResolutionUnit(),
                'MajorBrand' => new \PHPExiftool\Driver\Tag\Jpeg2000\MajorBrand(),
                'MinorVersion' => new \PHPExiftool\Driver\Tag\Jpeg2000\MinorVersion(),
                'CompatibleBrands' => new \PHPExiftool\Driver\Tag\Jpeg2000\CompatibleBrands(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\Jpeg2000\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\Jpeg2000\ImageWidth(),
                'NumberOfComponents' => new \PHPExiftool\Driver\Tag\Jpeg2000\NumberOfComponents(),
                'BitsPerComponent' => new \PHPExiftool\Driver\Tag\Jpeg2000\BitsPerComponent(),
                'Compression' => new \PHPExiftool\Driver\Tag\Jpeg2000\Compression(),
                'Association' => new \PHPExiftool\Driver\Tag\Jpeg2000\Association(),
                'BinaryFilter' => new \PHPExiftool\Driver\Tag\Jpeg2000\BinaryFilter(),
                'ComponentDefinition' => new \PHPExiftool\Driver\Tag\Jpeg2000\ComponentDefinition(),
                'ColorGroup' => new \PHPExiftool\Driver\Tag\Jpeg2000\ColorGroup(),
                'DigitalSignature' => new \PHPExiftool\Driver\Tag\Jpeg2000\DigitalSignature(),
                'ComponentMapping' => new \PHPExiftool\Driver\Tag\Jpeg2000\ComponentMapping(),
                'Composition' => new \PHPExiftool\Driver\Tag\Jpeg2000\Composition(),
                'CompositionOptions' => new \PHPExiftool\Driver\Tag\Jpeg2000\CompositionOptions(),
                'Cross-Reference' => new \PHPExiftool\Driver\Tag\Jpeg2000\CrossReference(),
                'CodestreamRegistration' => new \PHPExiftool\Driver\Tag\Jpeg2000\CodestreamRegistration(),
                'DesiredReproductions' => new \PHPExiftool\Driver\Tag\Jpeg2000\DesiredReproductions(),
                'DataReference' => new \PHPExiftool\Driver\Tag\Jpeg2000\DataReference(),
                'FragmentList' => new \PHPExiftool\Driver\Tag\Jpeg2000\FragmentList(),
                'Free' => new \PHPExiftool\Driver\Tag\Jpeg2000\Free(),
                'FragmentTable' => new \PHPExiftool\Driver\Tag\Jpeg2000\FragmentTable(),
                'GraphicsTechnologyStandardOutput' => new \PHPExiftool\Driver\Tag\Jpeg2000\GraphicsTechnologyStandardOutput(),
                'InstructionSet' => new \PHPExiftool\Driver\Tag\Jpeg2000\InstructionSet(),
                'JP2Signature' => new \PHPExiftool\Driver\Tag\Jpeg2000\JP2Signature(),
                'ContiguousCodestream' => new \PHPExiftool\Driver\Tag\Jpeg2000\ContiguousCodestream(),
                'Label' => new \PHPExiftool\Driver\Tag\Jpeg2000\Label(),
                'MediaData' => new \PHPExiftool\Driver\Tag\Jpeg2000\MediaData(),
                'MPEG7Binary' => new \PHPExiftool\Driver\Tag\Jpeg2000\MPEG7Binary(),
                'NumberList' => new \PHPExiftool\Driver\Tag\Jpeg2000\NumberList(),
                'Opacity' => new \PHPExiftool\Driver\Tag\Jpeg2000\Opacity(),
                'Palette' => new \PHPExiftool\Driver\Tag\Jpeg2000\Palette(),
                'Profile' => new \PHPExiftool\Driver\Tag\Jpeg2000\Profile(),
                'ROIDescription' => new \PHPExiftool\Driver\Tag\Jpeg2000\ROIDescription(),
                'ReaderRequirements' => new \PHPExiftool\Driver\Tag\Jpeg2000\ReaderRequirements(),
                'UUIDList' => new \PHPExiftool\Driver\Tag\Jpeg2000\UUIDList(),
                'URL' => new \PHPExiftool\Driver\Tag\Jpeg2000\URL(),
                'UUID-Unknown' => new \PHPExiftool\Driver\Tag\Jpeg2000\UUIDUnknown(),
                'XML' => new \PHPExiftool\Driver\Tag\Jpeg2000\XML(),
            );
        });
        $this['KodakBordersIFD'] = $this->share(function(){
            return array(
                'BordersVersion' => new \PHPExiftool\Driver\Tag\KodakBordersIFD\BordersVersion(),
                'BorderName' => new \PHPExiftool\Driver\Tag\KodakBordersIFD\BorderName(),
                'BorderID' => new \PHPExiftool\Driver\Tag\KodakBordersIFD\BorderID(),
                'BorderLocation' => new \PHPExiftool\Driver\Tag\KodakBordersIFD\BorderLocation(),
                'BorderType' => new \PHPExiftool\Driver\Tag\KodakBordersIFD\BorderType(),
                'WatermarkType' => new \PHPExiftool\Driver\Tag\KodakBordersIFD\WatermarkType(),
            );
        });
        $this['Kodak'] = $this->share(function(){
            return array(
                'SensorWidth' => new \PHPExiftool\Driver\Tag\Kodak\SensorWidth(),
                'SensorHeight' => new \PHPExiftool\Driver\Tag\Kodak\SensorHeight(),
                'BayerPattern' => new \PHPExiftool\Driver\Tag\Kodak\BayerPattern(),
                'SensorFullWidth' => new \PHPExiftool\Driver\Tag\Kodak\SensorFullWidth(),
                'SensorFullHeight' => new \PHPExiftool\Driver\Tag\Kodak\SensorFullHeight(),
                'KodakImageWidth' => new \PHPExiftool\Driver\Tag\Kodak\KodakImageWidth(),
                'KodakImageHeight' => new \PHPExiftool\Driver\Tag\Kodak\KodakImageHeight(),
                'KodakInfoType' => new \PHPExiftool\Driver\Tag\Kodak\KodakInfoType(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\Kodak\SerialNumber(),
                'FNumber' => new \PHPExiftool\Driver\Tag\Kodak\FNumber(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\Kodak\ExposureTime(),
                'ISO' => new \PHPExiftool\Driver\Tag\Kodak\ISO(),
                'CameraByteOrder' => new \PHPExiftool\Driver\Tag\Kodak\CameraByteOrder(),
                'ApertureValue' => new \PHPExiftool\Driver\Tag\Kodak\ApertureValue(),
                'BrightnessValue' => new \PHPExiftool\Driver\Tag\Kodak\BrightnessValue(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\Kodak\ExposureCompensation(),
                'FocalLengthIn35mmFormat' => new \PHPExiftool\Driver\Tag\Kodak\FocalLengthIn35mmFormat(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Kodak\FocalLength(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\Kodak\FirmwareVersion(),
                'ShutterSpeedValue' => new \PHPExiftool\Driver\Tag\Kodak\ShutterSpeedValue(),
                'Make' => new \PHPExiftool\Driver\Tag\Kodak\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\Kodak\Model(),
                'ModelType' => new \PHPExiftool\Driver\Tag\Kodak\ModelType(),
                'KodakModel' => new \PHPExiftool\Driver\Tag\Kodak\KodakModel(),
                'Quality' => new \PHPExiftool\Driver\Tag\Kodak\Quality(),
                'BurstMode' => new \PHPExiftool\Driver\Tag\Kodak\BurstMode(),
                'YearCreated' => new \PHPExiftool\Driver\Tag\Kodak\YearCreated(),
                'MonthDayCreated' => new \PHPExiftool\Driver\Tag\Kodak\MonthDayCreated(),
                'TimeCreated' => new \PHPExiftool\Driver\Tag\Kodak\TimeCreated(),
                'BurstMode2' => new \PHPExiftool\Driver\Tag\Kodak\BurstMode2(),
                'ShutterMode' => new \PHPExiftool\Driver\Tag\Kodak\ShutterMode(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\Kodak\MeteringMode(),
                'SequenceNumber' => new \PHPExiftool\Driver\Tag\Kodak\SequenceNumber(),
                'VariousModes' => new \PHPExiftool\Driver\Tag\Kodak\VariousModes(),
                'Distance1' => new \PHPExiftool\Driver\Tag\Kodak\Distance1(),
                'Distance2' => new \PHPExiftool\Driver\Tag\Kodak\Distance2(),
                'Distance3' => new \PHPExiftool\Driver\Tag\Kodak\Distance3(),
                'Distance4' => new \PHPExiftool\Driver\Tag\Kodak\Distance4(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\Kodak\FocusMode(),
                'VariousModes2' => new \PHPExiftool\Driver\Tag\Kodak\VariousModes2(),
                'PanoramaMode' => new \PHPExiftool\Driver\Tag\Kodak\PanoramaMode(),
                'SubjectDistance' => new \PHPExiftool\Driver\Tag\Kodak\SubjectDistance(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\Kodak\WhiteBalance(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\Kodak\FlashMode(),
                'FlashFired' => new \PHPExiftool\Driver\Tag\Kodak\FlashFired(),
                'ISOSetting' => new \PHPExiftool\Driver\Tag\Kodak\ISOSetting(),
                'TotalZoom' => new \PHPExiftool\Driver\Tag\Kodak\TotalZoom(),
                'DateTimeStamp' => new \PHPExiftool\Driver\Tag\Kodak\DateTimeStamp(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\Kodak\ColorMode(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\Kodak\DigitalZoom(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\Kodak\Sharpness(),
                'WB_RGBLevels' => new \PHPExiftool\Driver\Tag\Kodak\WBRGBLevels(),
                'PreviewImageWidth' => new \PHPExiftool\Driver\Tag\Kodak\PreviewImageWidth(),
                'PreviewImageHeight' => new \PHPExiftool\Driver\Tag\Kodak\PreviewImageHeight(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\Kodak\PreviewImageLength(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\Kodak\PreviewImage(),
                'SceneMode' => new \PHPExiftool\Driver\Tag\Kodak\SceneMode(),
                'OpticalZoom' => new \PHPExiftool\Driver\Tag\Kodak\OpticalZoom(),
                'ThumbnailWidth' => new \PHPExiftool\Driver\Tag\Kodak\ThumbnailWidth(),
                'ThumbnailHeight' => new \PHPExiftool\Driver\Tag\Kodak\ThumbnailHeight(),
                'SceneModeUsed' => new \PHPExiftool\Driver\Tag\Kodak\SceneModeUsed(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\Kodak\MaxAperture(),
                'Kodak_SubIFD3_0x2007' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x2007(),
                'Kodak_SubIFD3_0x2008' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x2008(),
                'Kodak_SubIFD3_0x2009' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x2009(),
                'Kodak_SubIFD3_0x200a' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x200a(),
                'Kodak_SubIFD3_0x200b' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x200b(),
                'Kodak_SubIFD3_0x3020' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x3020(),
                'Kodak_SubIFD3_0x3030' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x3030(),
                'Kodak_SubIFD3_0x3040' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x3040(),
                'Kodak_SubIFD3_0x3050' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x3050(),
                'Kodak_SubIFD3_0x3060' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x3060(),
                'Kodak_SubIFD3_0x8001' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8001(),
                'Kodak_SubIFD3_0x8002' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8002(),
                'Kodak_SubIFD3_0x8003' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8003(),
                'Kodak_SubIFD3_0x8004' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8004(),
                'Kodak_SubIFD3_0x8005' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8005(),
                'Kodak_SubIFD3_0x8006' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8006(),
                'Kodak_SubIFD3_0x8007' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8007(),
                'Kodak_SubIFD3_0x8008' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8008(),
                'Kodak_SubIFD3_0x8009' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x8009(),
                'Kodak_SubIFD3_0x800a' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x800a(),
                'Kodak_SubIFD3_0x800b' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x800b(),
                'Kodak_SubIFD3_0x800c' => new \PHPExiftool\Driver\Tag\Kodak\KodakSubIFD30x800c(),
                'AFMode' => new \PHPExiftool\Driver\Tag\Kodak\AFMode(),
                'ActualCompensation' => new \PHPExiftool\Driver\Tag\Kodak\ActualCompensation(),
                'Aperture' => new \PHPExiftool\Driver\Tag\Kodak\Aperture(),
                'AutoBracket' => new \PHPExiftool\Driver\Tag\Kodak\AutoBracket(),
                'CameraModel' => new \PHPExiftool\Driver\Tag\Kodak\CameraModel(),
                'CameraBody' => new \PHPExiftool\Driver\Tag\Kodak\CameraBody(),
                'Date' => new \PHPExiftool\Driver\Tag\Kodak\Date(),
                'ExposureBias' => new \PHPExiftool\Driver\Tag\Kodak\ExposureBias(),
                'ExposureMode' => new \PHPExiftool\Driver\Tag\Kodak\ExposureMode(),
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\Kodak\FlashExposureComp(),
                'FlashSyncMode' => new \PHPExiftool\Driver\Tag\Kodak\FlashSyncMode(),
                'ImageNumber' => new \PHPExiftool\Driver\Tag\Kodak\ImageNumber(),
                'MeterMode' => new \PHPExiftool\Driver\Tag\Kodak\MeterMode(),
                'MinAperture' => new \PHPExiftool\Driver\Tag\Kodak\MinAperture(),
                'PopupFlash' => new \PHPExiftool\Driver\Tag\Kodak\PopupFlash(),
                'ShootingMode' => new \PHPExiftool\Driver\Tag\Kodak\ShootingMode(),
                'ShutterSpeed' => new \PHPExiftool\Driver\Tag\Kodak\ShutterSpeed(),
                'Temperature' => new \PHPExiftool\Driver\Tag\Kodak\Temperature(),
                'Time' => new \PHPExiftool\Driver\Tag\Kodak\Time(),
                'OtherInfo' => new \PHPExiftool\Driver\Tag\Kodak\OtherInfo(),
                'PreviewImageSize' => new \PHPExiftool\Driver\Tag\Kodak\PreviewImageSize(),
                'PictureEffect' => new \PHPExiftool\Driver\Tag\Kodak\PictureEffect(),
                'KodakMake' => new \PHPExiftool\Driver\Tag\Kodak\KodakMake(),
                'LensSerialNumber' => new \PHPExiftool\Driver\Tag\Kodak\LensSerialNumber(),
                'LensModel' => new \PHPExiftool\Driver\Tag\Kodak\LensModel(),
                'KodakMaker' => new \PHPExiftool\Driver\Tag\Kodak\KodakMaker(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\Kodak\OriginalFileName(),
                'ImageRotated' => new \PHPExiftool\Driver\Tag\Kodak\ImageRotated(),
                'Macro' => new \PHPExiftool\Driver\Tag\Kodak\Macro(),
                'Flash' => new \PHPExiftool\Driver\Tag\Kodak\Flash(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\Kodak\DateTimeOriginal(),
                'UnknownNumber' => new \PHPExiftool\Driver\Tag\Kodak\UnknownNumber(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\Kodak\ThumbnailImage(),
            );
        });
        $this['KodakIFD'] = $this->share(function(){
            return array(
                'UnknownEV' => new \PHPExiftool\Driver\Tag\KodakIFD\UnknownEV(),
                'ExposureValue' => new \PHPExiftool\Driver\Tag\KodakIFD\ExposureValue(),
                'OriginalFileName' => new \PHPExiftool\Driver\Tag\KodakIFD\OriginalFileName(),
                'SensorLeftBorder' => new \PHPExiftool\Driver\Tag\KodakIFD\SensorLeftBorder(),
                'SensorTopBorder' => new \PHPExiftool\Driver\Tag\KodakIFD\SensorTopBorder(),
                'SensorImageWidth' => new \PHPExiftool\Driver\Tag\KodakIFD\SensorImageWidth(),
                'SensorImageHeight' => new \PHPExiftool\Driver\Tag\KodakIFD\SensorImageHeight(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\KodakIFD\WhiteBalance(),
                'Time' => new \PHPExiftool\Driver\Tag\KodakIFD\Time(),
                'CameraTemperature' => new \PHPExiftool\Driver\Tag\KodakIFD\CameraTemperature(),
                'AdapterVoltage' => new \PHPExiftool\Driver\Tag\KodakIFD\AdapterVoltage(),
                'BatteryVoltage' => new \PHPExiftool\Driver\Tag\KodakIFD\BatteryVoltage(),
                'NCDFileInfo' => new \PHPExiftool\Driver\Tag\KodakIFD\NCDFileInfo(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\KodakIFD\ColorTemperature(),
                'WB_RGBLevelsDaylight' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBLevelsDaylight(),
                'WB_RGBLevelsTungsten' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBLevelsTungsten(),
                'WB_RGBLevelsFluorescent' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBLevelsFluorescent(),
                'WB_RGBLevelsFlash' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBLevelsFlash(),
                'WB_RGBLevelsCustom' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBLevelsCustom(),
                'WB_RGBLevelsAuto' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBLevelsAuto(),
                'WB_RGBMul0' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBMul0(),
                'WB_RGBMul1' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBMul1(),
                'WB_RGBMul2' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBMul2(),
                'WB_RGBMul3' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBMul3(),
                'WB_RGBCoeffs0' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBCoeffs0(),
                'WB_RGBCoeffs1' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBCoeffs1(),
                'WB_RGBCoeffs2' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBCoeffs2(),
                'WB_RGBCoeffs3' => new \PHPExiftool\Driver\Tag\KodakIFD\WBRGBCoeffs3(),
                'BaseISO' => new \PHPExiftool\Driver\Tag\KodakIFD\BaseISO(),
                'SensorSerialNumber' => new \PHPExiftool\Driver\Tag\KodakIFD\SensorSerialNumber(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\KodakIFD\FirmwareVersion(),
                'KodakLook' => new \PHPExiftool\Driver\Tag\KodakIFD\KodakLook(),
                'InputProfile' => new \PHPExiftool\Driver\Tag\KodakIFD\InputProfile(),
                'KodakLookProfile' => new \PHPExiftool\Driver\Tag\KodakIFD\KodakLookProfile(),
                'OutputProfile' => new \PHPExiftool\Driver\Tag\KodakIFD\OutputProfile(),
                'ToneCurveFileName' => new \PHPExiftool\Driver\Tag\KodakIFD\ToneCurveFileName(),
                'ISO' => new \PHPExiftool\Driver\Tag\KodakIFD\ISO(),
            );
        });
        $this['KDC_IFD'] = $this->share(function(){
            return array(
                'SerialNumber' => new \PHPExiftool\Driver\Tag\KDCIFD\SerialNumber(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\KDCIFD\WhiteBalance(),
                'WB_RGBLevelsAuto' => new \PHPExiftool\Driver\Tag\KDCIFD\WBRGBLevelsAuto(),
                'WB_RGBLevelsTungsten' => new \PHPExiftool\Driver\Tag\KDCIFD\WBRGBLevelsTungsten(),
                'WB_RGBLevelsFluorescent' => new \PHPExiftool\Driver\Tag\KDCIFD\WBRGBLevelsFluorescent(),
                'WB_RGBLevelsDaylight' => new \PHPExiftool\Driver\Tag\KDCIFD\WBRGBLevelsDaylight(),
                'WB_RGBLevelsShade' => new \PHPExiftool\Driver\Tag\KDCIFD\WBRGBLevelsShade(),
            );
        });
        $this['MetaIFD'] = $this->share(function(){
            return array(
                'FilmProductCode' => new \PHPExiftool\Driver\Tag\MetaIFD\FilmProductCode(),
                'ImageSourceEK' => new \PHPExiftool\Driver\Tag\MetaIFD\ImageSourceEK(),
                'CaptureConditionsPAR' => new \PHPExiftool\Driver\Tag\MetaIFD\CaptureConditionsPAR(),
                'CameraOwner' => new \PHPExiftool\Driver\Tag\MetaIFD\CameraOwner(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\MetaIFD\SerialNumber(),
                'UserSelectGroupTitle' => new \PHPExiftool\Driver\Tag\MetaIFD\UserSelectGroupTitle(),
                'DealerIDNumber' => new \PHPExiftool\Driver\Tag\MetaIFD\DealerIDNumber(),
                'CaptureDeviceFID' => new \PHPExiftool\Driver\Tag\MetaIFD\CaptureDeviceFID(),
                'EnvelopeNumber' => new \PHPExiftool\Driver\Tag\MetaIFD\EnvelopeNumber(),
                'FrameNumber' => new \PHPExiftool\Driver\Tag\MetaIFD\FrameNumber(),
                'FilmCategory' => new \PHPExiftool\Driver\Tag\MetaIFD\FilmCategory(),
                'FilmGencode' => new \PHPExiftool\Driver\Tag\MetaIFD\FilmGencode(),
                'ModelAndVersion' => new \PHPExiftool\Driver\Tag\MetaIFD\ModelAndVersion(),
                'FilmSize' => new \PHPExiftool\Driver\Tag\MetaIFD\FilmSize(),
                'SBA_RGBShifts' => new \PHPExiftool\Driver\Tag\MetaIFD\SBARGBShifts(),
                'SBAInputImageColorspace' => new \PHPExiftool\Driver\Tag\MetaIFD\SBAInputImageColorspace(),
                'SBAInputImageBitDepth' => new \PHPExiftool\Driver\Tag\MetaIFD\SBAInputImageBitDepth(),
                'SBAExposureRecord' => new \PHPExiftool\Driver\Tag\MetaIFD\SBAExposureRecord(),
                'UserAdjSBA_RGBShifts' => new \PHPExiftool\Driver\Tag\MetaIFD\UserAdjSBARGBShifts(),
                'ImageRotationStatus' => new \PHPExiftool\Driver\Tag\MetaIFD\ImageRotationStatus(),
                'RollGuidElements' => new \PHPExiftool\Driver\Tag\MetaIFD\RollGuidElements(),
                'MetadataNumber' => new \PHPExiftool\Driver\Tag\MetaIFD\MetadataNumber(),
                'EditTagArray' => new \PHPExiftool\Driver\Tag\MetaIFD\EditTagArray(),
                'Magnification' => new \PHPExiftool\Driver\Tag\MetaIFD\Magnification(),
                'NativeXResolution' => new \PHPExiftool\Driver\Tag\MetaIFD\NativeXResolution(),
                'NativeYResolution' => new \PHPExiftool\Driver\Tag\MetaIFD\NativeYResolution(),
                'NativeResolutionUnit' => new \PHPExiftool\Driver\Tag\MetaIFD\NativeResolutionUnit(),
                'SourceImageDirectory' => new \PHPExiftool\Driver\Tag\MetaIFD\SourceImageDirectory(),
                'SourceImageFileName' => new \PHPExiftool\Driver\Tag\MetaIFD\SourceImageFileName(),
                'SourceImageVolumeName' => new \PHPExiftool\Driver\Tag\MetaIFD\SourceImageVolumeName(),
                'PrintQuality' => new \PHPExiftool\Driver\Tag\MetaIFD\PrintQuality(),
                'ImagePrintStatus' => new \PHPExiftool\Driver\Tag\MetaIFD\ImagePrintStatus(),
            );
        });
        $this['KodakEffectsIFD'] = $this->share(function(){
            return array(
                'DigitalEffectsVersion' => new \PHPExiftool\Driver\Tag\KodakEffectsIFD\DigitalEffectsVersion(),
                'DigitalEffectsName' => new \PHPExiftool\Driver\Tag\KodakEffectsIFD\DigitalEffectsName(),
                'DigitalEffectsType' => new \PHPExiftool\Driver\Tag\KodakEffectsIFD\DigitalEffectsType(),
            );
        });
        $this['KyoceraRaw'] = $this->share(function(){
            return array(
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\KyoceraRaw\FirmwareVersion(),
                'Model' => new \PHPExiftool\Driver\Tag\KyoceraRaw\Model(),
                'Make' => new \PHPExiftool\Driver\Tag\KyoceraRaw\Make(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\KyoceraRaw\DateTimeOriginal(),
                'ISO' => new \PHPExiftool\Driver\Tag\KyoceraRaw\ISO(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\KyoceraRaw\ExposureTime(),
                'WB_RGGBLevels' => new \PHPExiftool\Driver\Tag\KyoceraRaw\WBRGGBLevels(),
                'FNumber' => new \PHPExiftool\Driver\Tag\KyoceraRaw\FNumber(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\KyoceraRaw\MaxAperture(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\KyoceraRaw\FocalLength(),
                'Lens' => new \PHPExiftool\Driver\Tag\KyoceraRaw\Lens(),
            );
        });
        $this['LNK'] = $this->share(function(){
            return array(
                'FillAttributes' => new \PHPExiftool\Driver\Tag\LNK\FillAttributes(),
                'PopupFillAttributes' => new \PHPExiftool\Driver\Tag\LNK\PopupFillAttributes(),
                'ScreenBufferSize' => new \PHPExiftool\Driver\Tag\LNK\ScreenBufferSize(),
                'WindowSize' => new \PHPExiftool\Driver\Tag\LNK\WindowSize(),
                'WindowOrigin' => new \PHPExiftool\Driver\Tag\LNK\WindowOrigin(),
                'FontSize' => new \PHPExiftool\Driver\Tag\LNK\FontSize(),
                'FontFamily' => new \PHPExiftool\Driver\Tag\LNK\FontFamily(),
                'FontWeight' => new \PHPExiftool\Driver\Tag\LNK\FontWeight(),
                'FontName' => new \PHPExiftool\Driver\Tag\LNK\FontName(),
                'CursorSize' => new \PHPExiftool\Driver\Tag\LNK\CursorSize(),
                'FullScreen' => new \PHPExiftool\Driver\Tag\LNK\FullScreen(),
                'QuickEdit' => new \PHPExiftool\Driver\Tag\LNK\QuickEdit(),
                'InsertMode' => new \PHPExiftool\Driver\Tag\LNK\InsertMode(),
                'WindowOriginAuto' => new \PHPExiftool\Driver\Tag\LNK\WindowOriginAuto(),
                'HistoryBufferSize' => new \PHPExiftool\Driver\Tag\LNK\HistoryBufferSize(),
                'NumHistoryBuffers' => new \PHPExiftool\Driver\Tag\LNK\NumHistoryBuffers(),
                'RemoveHistoryDuplicates' => new \PHPExiftool\Driver\Tag\LNK\RemoveHistoryDuplicates(),
                'CodePage' => new \PHPExiftool\Driver\Tag\LNK\CodePage(),
                'TargetFileDOSName' => new \PHPExiftool\Driver\Tag\LNK\TargetFileDOSName(),
                'CommonNetworkRelLink' => new \PHPExiftool\Driver\Tag\LNK\CommonNetworkRelLink(),
                'CommonPathSuffix' => new \PHPExiftool\Driver\Tag\LNK\CommonPathSuffix(),
                'DeviceName' => new \PHPExiftool\Driver\Tag\LNK\DeviceName(),
                'DriveSerialNumber' => new \PHPExiftool\Driver\Tag\LNK\DriveSerialNumber(),
                'DriveType' => new \PHPExiftool\Driver\Tag\LNK\DriveType(),
                'LocalBasePath' => new \PHPExiftool\Driver\Tag\LNK\LocalBasePath(),
                'NetName' => new \PHPExiftool\Driver\Tag\LNK\NetName(),
                'NetProviderType' => new \PHPExiftool\Driver\Tag\LNK\NetProviderType(),
                'VolumeID' => new \PHPExiftool\Driver\Tag\LNK\VolumeID(),
                'VolumeLabel' => new \PHPExiftool\Driver\Tag\LNK\VolumeLabel(),
                'Flags' => new \PHPExiftool\Driver\Tag\LNK\Flags(),
                'FileAttributes' => new \PHPExiftool\Driver\Tag\LNK\FileAttributes(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\LNK\CreateDate(),
                'AccessDate' => new \PHPExiftool\Driver\Tag\LNK\AccessDate(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\LNK\ModifyDate(),
                'TargetFileSize' => new \PHPExiftool\Driver\Tag\LNK\TargetFileSize(),
                'IconIndex' => new \PHPExiftool\Driver\Tag\LNK\IconIndex(),
                'RunWindow' => new \PHPExiftool\Driver\Tag\LNK\RunWindow(),
                'HotKey' => new \PHPExiftool\Driver\Tag\LNK\HotKey(),
                'Description' => new \PHPExiftool\Driver\Tag\LNK\Description(),
                'RelativePath' => new \PHPExiftool\Driver\Tag\LNK\RelativePath(),
                'WorkingDirectory' => new \PHPExiftool\Driver\Tag\LNK\WorkingDirectory(),
                'CommandLineArguments' => new \PHPExiftool\Driver\Tag\LNK\CommandLineArguments(),
                'IconFileName' => new \PHPExiftool\Driver\Tag\LNK\IconFileName(),
                'MachineID' => new \PHPExiftool\Driver\Tag\LNK\MachineID(),
            );
        });
        $this['Leaf'] = $this->share(function(){
            return array(
                'CameraBackType' => new \PHPExiftool\Driver\Tag\Leaf\CameraBackType(),
                'CameraName' => new \PHPExiftool\Driver\Tag\Leaf\CameraName(),
                'CameraType' => new \PHPExiftool\Driver\Tag\Leaf\CameraType(),
                'CameraProfileVersion' => new \PHPExiftool\Driver\Tag\Leaf\CameraProfileVersion(),
                'ISOSpeed' => new \PHPExiftool\Driver\Tag\Leaf\ISOSpeed(),
                'CameraObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\CameraObjBackType(),
                'LensID' => new \PHPExiftool\Driver\Tag\Leaf\LensID(),
                'LensType' => new \PHPExiftool\Driver\Tag\Leaf\LensType(),
                'CameraObjName' => new \PHPExiftool\Driver\Tag\Leaf\CameraObjName(),
                'Strobe' => new \PHPExiftool\Driver\Tag\Leaf\Strobe(),
                'CameraObjType' => new \PHPExiftool\Driver\Tag\Leaf\CameraObjType(),
                'CameraObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\CameraObjVersion(),
                'CCDRect' => new \PHPExiftool\Driver\Tag\Leaf\CCDRect(),
                'CCDValidRect' => new \PHPExiftool\Driver\Tag\Leaf\CCDValidRect(),
                'CCDVideoRect' => new \PHPExiftool\Driver\Tag\Leaf\CCDVideoRect(),
                'CaptProfBackType' => new \PHPExiftool\Driver\Tag\Leaf\CaptProfBackType(),
                'CenterDarkRect' => new \PHPExiftool\Driver\Tag\Leaf\CenterDarkRect(),
                'ColorAverages' => new \PHPExiftool\Driver\Tag\Leaf\ColorAverages(),
                'ColorMatrix' => new \PHPExiftool\Driver\Tag\Leaf\ColorMatrix(),
                'DarkCorrectionType' => new \PHPExiftool\Driver\Tag\Leaf\DarkCorrectionType(),
                'ImageBounds' => new \PHPExiftool\Driver\Tag\Leaf\ImageBounds(),
                'ImageFields' => new \PHPExiftool\Driver\Tag\Leaf\ImageFields(),
                'ImageOffset' => new \PHPExiftool\Driver\Tag\Leaf\ImageOffset(),
                'LeftDarkRect' => new \PHPExiftool\Driver\Tag\Leaf\LeftDarkRect(),
                'LuminanceConsts' => new \PHPExiftool\Driver\Tag\Leaf\LuminanceConsts(),
                'MosaicPattern' => new \PHPExiftool\Driver\Tag\Leaf\MosaicPattern(),
                'CaptProfName' => new \PHPExiftool\Driver\Tag\Leaf\CaptProfName(),
                'NumberOfPlanes' => new \PHPExiftool\Driver\Tag\Leaf\NumberOfPlanes(),
                'RawDataRotation' => new \PHPExiftool\Driver\Tag\Leaf\RawDataRotation(),
                'ReconstructionType' => new \PHPExiftool\Driver\Tag\Leaf\ReconstructionType(),
                'RightDarkRect' => new \PHPExiftool\Driver\Tag\Leaf\RightDarkRect(),
                'CaptureSerial' => new \PHPExiftool\Driver\Tag\Leaf\CaptureSerial(),
                'CaptProfType' => new \PHPExiftool\Driver\Tag\Leaf\CaptProfType(),
                'CaptProfVersion' => new \PHPExiftool\Driver\Tag\Leaf\CaptProfVersion(),
                'XYOffsetInfo' => new \PHPExiftool\Driver\Tag\Leaf\XYOffsetInfo(),
                'MultiQuality' => new \PHPExiftool\Driver\Tag\Leaf\MultiQuality(),
                'CaptureObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\CaptureObjBackType(),
                'CaptureObjName' => new \PHPExiftool\Driver\Tag\Leaf\CaptureObjName(),
                'SingleQuality' => new \PHPExiftool\Driver\Tag\Leaf\SingleQuality(),
                'CaptureObjType' => new \PHPExiftool\Driver\Tag\Leaf\CaptureObjType(),
                'CaptureObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\CaptureObjVersion(),
                'ColorObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\ColorObjBackType(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\Leaf\ColorMode(),
                'ColorType' => new \PHPExiftool\Driver\Tag\Leaf\ColorType(),
                'HasICC' => new \PHPExiftool\Driver\Tag\Leaf\HasICC(),
                'InputProfile' => new \PHPExiftool\Driver\Tag\Leaf\InputProfile(),
                'ColorObjName' => new \PHPExiftool\Driver\Tag\Leaf\ColorObjName(),
                'OutputProfile' => new \PHPExiftool\Driver\Tag\Leaf\OutputProfile(),
                'ColorObjType' => new \PHPExiftool\Driver\Tag\Leaf\ColorObjType(),
                'ColorObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\ColorObjVersion(),
                'ImgProfBackType' => new \PHPExiftool\Driver\Tag\Leaf\ImgProfBackType(),
                'ImageStatus' => new \PHPExiftool\Driver\Tag\Leaf\ImageStatus(),
                'ImgProfName' => new \PHPExiftool\Driver\Tag\Leaf\ImgProfName(),
                'RotationAngle' => new \PHPExiftool\Driver\Tag\Leaf\RotationAngle(),
                'ImgProfType' => new \PHPExiftool\Driver\Tag\Leaf\ImgProfType(),
                'ImgProfVersion' => new \PHPExiftool\Driver\Tag\Leaf\ImgProfVersion(),
                'LookHeadBackType' => new \PHPExiftool\Driver\Tag\Leaf\LookHeadBackType(),
                'LookHeadName' => new \PHPExiftool\Driver\Tag\Leaf\LookHeadName(),
                'LookHeadType' => new \PHPExiftool\Driver\Tag\Leaf\LookHeadType(),
                'LookHeadVersion' => new \PHPExiftool\Driver\Tag\Leaf\LookHeadVersion(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\Leaf\PreviewImage(),
                'PreviewInfo' => new \PHPExiftool\Driver\Tag\Leaf\PreviewInfo(),
                'PDAHistogram' => new \PHPExiftool\Driver\Tag\Leaf\PDAHistogram(),
                'BackSerial' => new \PHPExiftool\Driver\Tag\Leaf\BackSerial(),
                'ToneMatrix' => new \PHPExiftool\Driver\Tag\Leaf\ToneMatrix(),
                'ToneSpaceFlow' => new \PHPExiftool\Driver\Tag\Leaf\ToneSpaceFlow(),
                'PatternAngle' => new \PHPExiftool\Driver\Tag\Leaf\PatternAngle(),
                'NeutObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\NeutObjBackType(),
                'ColorCasts' => new \PHPExiftool\Driver\Tag\Leaf\ColorCasts(),
                'HighlightEndPoints' => new \PHPExiftool\Driver\Tag\Leaf\HighlightEndPoints(),
                'NeutObjName' => new \PHPExiftool\Driver\Tag\Leaf\NeutObjName(),
                'Neutrals' => new \PHPExiftool\Driver\Tag\Leaf\Neutrals(),
                'ShadowEndPoints' => new \PHPExiftool\Driver\Tag\Leaf\ShadowEndPoints(),
                'NeutObjType' => new \PHPExiftool\Driver\Tag\Leaf\NeutObjType(),
                'NeutObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\NeutObjVersion(),
                'SaveObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\SaveObjBackType(),
                'LeafAutoActive' => new \PHPExiftool\Driver\Tag\Leaf\LeafAutoActive(),
                'LeafAutoBaseName' => new \PHPExiftool\Driver\Tag\Leaf\LeafAutoBaseName(),
                'LeafHotFolder' => new \PHPExiftool\Driver\Tag\Leaf\LeafHotFolder(),
                'LeafOpenProcHDR' => new \PHPExiftool\Driver\Tag\Leaf\LeafOpenProcHDR(),
                'LeafOutputFileType' => new \PHPExiftool\Driver\Tag\Leaf\LeafOutputFileType(),
                'LeafSaveSelection' => new \PHPExiftool\Driver\Tag\Leaf\LeafSaveSelection(),
                'SaveObjName' => new \PHPExiftool\Driver\Tag\Leaf\SaveObjName(),
                'StdAutoActive' => new \PHPExiftool\Driver\Tag\Leaf\StdAutoActive(),
                'StdBaseName' => new \PHPExiftool\Driver\Tag\Leaf\StdBaseName(),
                'StdHotFolder' => new \PHPExiftool\Driver\Tag\Leaf\StdHotFolder(),
                'StdOpenInPhotoshop' => new \PHPExiftool\Driver\Tag\Leaf\StdOpenInPhotoshop(),
                'StdOutputBitDepth' => new \PHPExiftool\Driver\Tag\Leaf\StdOutputBitDepth(),
                'StdOutputColorMode' => new \PHPExiftool\Driver\Tag\Leaf\StdOutputColorMode(),
                'StdOutputFileType' => new \PHPExiftool\Driver\Tag\Leaf\StdOutputFileType(),
                'StdOxygen' => new \PHPExiftool\Driver\Tag\Leaf\StdOxygen(),
                'StdSaveSelection' => new \PHPExiftool\Driver\Tag\Leaf\StdSaveSelection(),
                'StdScaledOutput' => new \PHPExiftool\Driver\Tag\Leaf\StdScaledOutput(),
                'StdSharpenOutput' => new \PHPExiftool\Driver\Tag\Leaf\StdSharpenOutput(),
                'SaveObjType' => new \PHPExiftool\Driver\Tag\Leaf\SaveObjType(),
                'SaveObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\SaveObjVersion(),
                'SelObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\SelObjBackType(),
                'Locks' => new \PHPExiftool\Driver\Tag\Leaf\Locks(),
                'SelObjName' => new \PHPExiftool\Driver\Tag\Leaf\SelObjName(),
                'Orientation' => new \PHPExiftool\Driver\Tag\Leaf\Orientation(),
                'Rect' => new \PHPExiftool\Driver\Tag\Leaf\Rect(),
                'Resolution' => new \PHPExiftool\Driver\Tag\Leaf\Resolution(),
                'Scale' => new \PHPExiftool\Driver\Tag\Leaf\Scale(),
                'SelObjType' => new \PHPExiftool\Driver\Tag\Leaf\SelObjType(),
                'SelObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\SelObjVersion(),
                'SharpObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\SharpObjBackType(),
                'DataLen' => new \PHPExiftool\Driver\Tag\Leaf\DataLen(),
                'SharpObjName' => new \PHPExiftool\Driver\Tag\Leaf\SharpObjName(),
                'SharpInfo' => new \PHPExiftool\Driver\Tag\Leaf\SharpInfo(),
                'SharpMethod' => new \PHPExiftool\Driver\Tag\Leaf\SharpMethod(),
                'SharpObjType' => new \PHPExiftool\Driver\Tag\Leaf\SharpObjType(),
                'SharpObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\SharpObjVersion(),
                'ShootObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\ShootObjBackType(),
                'ShootObjName' => new \PHPExiftool\Driver\Tag\Leaf\ShootObjName(),
                'ShootObjType' => new \PHPExiftool\Driver\Tag\Leaf\ShootObjType(),
                'ShootObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\ShootObjVersion(),
                'ToneObjBackType' => new \PHPExiftool\Driver\Tag\Leaf\ToneObjBackType(),
                'Gamma' => new \PHPExiftool\Driver\Tag\Leaf\Gamma(),
                'ToneObjName' => new \PHPExiftool\Driver\Tag\Leaf\ToneObjName(),
                'Npts' => new \PHPExiftool\Driver\Tag\Leaf\Npts(),
                'Tones' => new \PHPExiftool\Driver\Tag\Leaf\Tones(),
                'ToneObjType' => new \PHPExiftool\Driver\Tag\Leaf\ToneObjType(),
                'ToneObjVersion' => new \PHPExiftool\Driver\Tag\Leaf\ToneObjVersion(),
            );
        });
        $this['Lytro'] = $this->share(function(){
            return array(
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\Lytro\FirmwareVersion(),
                'Make' => new \PHPExiftool\Driver\Tag\Lytro\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\Lytro\Model(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\Lytro\SerialNumber(),
                'AccelerometerTime' => new \PHPExiftool\Driver\Tag\Lytro\AccelerometerTime(),
                'AccelerometerX' => new \PHPExiftool\Driver\Tag\Lytro\AccelerometerX(),
                'AccelerometerY' => new \PHPExiftool\Driver\Tag\Lytro\AccelerometerY(),
                'AccelerometerZ' => new \PHPExiftool\Driver\Tag\Lytro\AccelerometerZ(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\Lytro\DateTimeOriginal(),
                'FNumber' => new \PHPExiftool\Driver\Tag\Lytro\FNumber(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Lytro\FocalLength(),
                'LensTemperature' => new \PHPExiftool\Driver\Tag\Lytro\LensTemperature(),
                'ISO' => new \PHPExiftool\Driver\Tag\Lytro\ISO(),
                'FocalPlaneXResolution' => new \PHPExiftool\Driver\Tag\Lytro\FocalPlaneXResolution(),
                'SensorSerialNumber' => new \PHPExiftool\Driver\Tag\Lytro\SensorSerialNumber(),
                'FrameExposureTime' => new \PHPExiftool\Driver\Tag\Lytro\FrameExposureTime(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\Lytro\ExposureTime(),
                'SocTemperature' => new \PHPExiftool\Driver\Tag\Lytro\SocTemperature(),
                'EmbeddedImage' => new \PHPExiftool\Driver\Tag\Lytro\EmbeddedImage(),
                'ImageLimitExposureBias' => new \PHPExiftool\Driver\Tag\Lytro\ImageLimitExposureBias(),
                'ImageModulationExposureBias' => new \PHPExiftool\Driver\Tag\Lytro\ImageModulationExposureBias(),
                'Orientation' => new \PHPExiftool\Driver\Tag\Lytro\Orientation(),
                'JSONMetadata' => new \PHPExiftool\Driver\Tag\Lytro\JSONMetadata(),
                'CameraType' => new \PHPExiftool\Driver\Tag\Lytro\CameraType(),
            );
        });
        $this['AC3'] = $this->share(function(){
            return array(
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\AC3\AudioBitrate(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\AC3\AudioChannels(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\AC3\AudioSampleRate(),
                'SurroundMode' => new \PHPExiftool\Driver\Tag\AC3\SurroundMode(),
            );
        });
        $this['M2TS'] = $this->share(function(){
            return array(
                'AudioStreamType' => new \PHPExiftool\Driver\Tag\M2TS\AudioStreamType(),
                'Duration' => new \PHPExiftool\Driver\Tag\M2TS\Duration(),
                'VideoStreamType' => new \PHPExiftool\Driver\Tag\M2TS\VideoStreamType(),
            );
        });
        $this['MIE-Audio'] = $this->share(function(){
            return array(
                'RelatedAudioFileType' => new \PHPExiftool\Driver\Tag\MIEAudio\RelatedAudioFileType(),
                'RelatedAudioFileName' => new \PHPExiftool\Driver\Tag\MIEAudio\RelatedAudioFileName(),
                'Channels' => new \PHPExiftool\Driver\Tag\MIEAudio\Channels(),
                'AudioCompression' => new \PHPExiftool\Driver\Tag\MIEAudio\AudioCompression(),
                'Duration' => new \PHPExiftool\Driver\Tag\MIEAudio\Duration(),
                'SampleBits' => new \PHPExiftool\Driver\Tag\MIEAudio\SampleBits(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\MIEAudio\SampleRate(),
                'RelatedAudioFile' => new \PHPExiftool\Driver\Tag\MIEAudio\RelatedAudioFile(),
            );
        });
        $this['MIE-Camera'] = $this->share(function(){
            return array(
                'Brightness' => new \PHPExiftool\Driver\Tag\MIECamera\Brightness(),
                'ColorBalance' => new \PHPExiftool\Driver\Tag\MIECamera\ColorBalance(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\MIECamera\ColorTemperature(),
                'Contrast' => new \PHPExiftool\Driver\Tag\MIECamera\Contrast(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\MIECamera\DigitalZoom(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\MIECamera\ExposureCompensation(),
                'ExposureMode' => new \PHPExiftool\Driver\Tag\MIECamera\ExposureMode(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\MIECamera\ExposureTime(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\MIECamera\FirmwareVersion(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\MIECamera\FocusMode(),
                'ISO' => new \PHPExiftool\Driver\Tag\MIECamera\ISO(),
                'ISOSetting' => new \PHPExiftool\Driver\Tag\MIECamera\ISOSetting(),
                'ImageNumber' => new \PHPExiftool\Driver\Tag\MIECamera\ImageNumber(),
                'ImageQuality' => new \PHPExiftool\Driver\Tag\MIECamera\ImageQuality(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\MIECamera\ImageStabilization(),
                'Make' => new \PHPExiftool\Driver\Tag\MIECamera\Make(),
                'MeasuredEV' => new \PHPExiftool\Driver\Tag\MIECamera\MeasuredEV(),
                'Model' => new \PHPExiftool\Driver\Tag\MIECamera\Model(),
                'OwnerName' => new \PHPExiftool\Driver\Tag\MIECamera\OwnerName(),
                'Saturation' => new \PHPExiftool\Driver\Tag\MIECamera\Saturation(),
                'SensorSize' => new \PHPExiftool\Driver\Tag\MIECamera\SensorSize(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\MIECamera\SerialNumber(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\MIECamera\Sharpness(),
                'ShootingMode' => new \PHPExiftool\Driver\Tag\MIECamera\ShootingMode(),
            );
        });
        $this['MIE-Doc'] = $this->share(function(){
            return array(
                'Author' => new \PHPExiftool\Driver\Tag\MIEDoc\Author(),
                'Comment' => new \PHPExiftool\Driver\Tag\MIEDoc\Comment(),
                'Contributors' => new \PHPExiftool\Driver\Tag\MIEDoc\Contributors(),
                'Copyright' => new \PHPExiftool\Driver\Tag\MIEDoc\Copyright(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\MIEDoc\CreateDate(),
                'Email' => new \PHPExiftool\Driver\Tag\MIEDoc\Email(),
                'Keywords' => new \PHPExiftool\Driver\Tag\MIEDoc\Keywords(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\MIEDoc\ModifyDate(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\MIEDoc\DateTimeOriginal(),
                'PhoneNumber' => new \PHPExiftool\Driver\Tag\MIEDoc\PhoneNumber(),
                'References' => new \PHPExiftool\Driver\Tag\MIEDoc\References(),
                'Software' => new \PHPExiftool\Driver\Tag\MIEDoc\Software(),
                'Title' => new \PHPExiftool\Driver\Tag\MIEDoc\Title(),
                'URL' => new \PHPExiftool\Driver\Tag\MIEDoc\URL(),
            );
        });
        $this['MIE-Extender'] = $this->share(function(){
            return array(
                'ExtenderMagnification' => new \PHPExiftool\Driver\Tag\MIEExtender\ExtenderMagnification(),
                'ExtenderMake' => new \PHPExiftool\Driver\Tag\MIEExtender\ExtenderMake(),
                'ExtenderModel' => new \PHPExiftool\Driver\Tag\MIEExtender\ExtenderModel(),
                'ExtenderSerialNumber' => new \PHPExiftool\Driver\Tag\MIEExtender\ExtenderSerialNumber(),
            );
        });
        $this['MIE-Flash'] = $this->share(function(){
            return array(
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashExposureComp(),
                'FlashFired' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashFired(),
                'FlashGuideNumber' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashGuideNumber(),
                'FlashMake' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashMake(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashMode(),
                'FlashModel' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashModel(),
                'FlashSerialNumber' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashSerialNumber(),
                'FlashType' => new \PHPExiftool\Driver\Tag\MIEFlash\FlashType(),
            );
        });
        $this['MIE-GPS'] = $this->share(function(){
            return array(
                'GPSAltitude' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSAltitude(),
                'GPSDestBearing' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSDestBearing(),
                'GPSDateTime' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSDateTime(),
                'GPSMapDatum' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSMapDatum(),
                'GPSDifferential' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSDifferential(),
                'GPSDestDistance' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSDestDistance(),
                'GPSTrack' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSTrack(),
                'GPSLatitude' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSLatitude(),
                'GPSLongitude' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSLongitude(),
                'GPSMeasureMode' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSMeasureMode(),
                'GPSSatellites' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSSatellites(),
                'GPSSpeed' => new \PHPExiftool\Driver\Tag\MIEGPS\GPSSpeed(),
            );
        });
        $this['MIE-Geo'] = $this->share(function(){
            return array(
                'Address' => new \PHPExiftool\Driver\Tag\MIEGeo\Address(),
                'City' => new \PHPExiftool\Driver\Tag\MIEGeo\City(),
                'Country' => new \PHPExiftool\Driver\Tag\MIEGeo\Country(),
                'PostalCode' => new \PHPExiftool\Driver\Tag\MIEGeo\PostalCode(),
                'State' => new \PHPExiftool\Driver\Tag\MIEGeo\State(),
            );
        });
        $this['MIE-Image'] = $this->share(function(){
            return array(
                'FullSizeImageType' => new \PHPExiftool\Driver\Tag\MIEImage\FullSizeImageType(),
                'FullSizeImageName' => new \PHPExiftool\Driver\Tag\MIEImage\FullSizeImageName(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\MIEImage\BitDepth(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\MIEImage\ColorSpace(),
                'ComponentsConfiguration' => new \PHPExiftool\Driver\Tag\MIEImage\ComponentsConfiguration(),
                'CompressionRatio' => new \PHPExiftool\Driver\Tag\MIEImage\CompressionRatio(),
                'ImageSize' => new \PHPExiftool\Driver\Tag\MIEImage\ImageSize(),
                'Resolution' => new \PHPExiftool\Driver\Tag\MIEImage\Resolution(),
                'FullSizeImage' => new \PHPExiftool\Driver\Tag\MIEImage\FullSizeImage(),
            );
        });
        $this['MIE-Lens'] = $this->share(function(){
            return array(
                'FNumber' => new \PHPExiftool\Driver\Tag\MIELens\FNumber(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\MIELens\FocalLength(),
                'FocusDistance' => new \PHPExiftool\Driver\Tag\MIELens\FocusDistance(),
                'LensMake' => new \PHPExiftool\Driver\Tag\MIELens\LensMake(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\MIELens\MaxAperture(),
                'MaxApertureAtMaxFocal' => new \PHPExiftool\Driver\Tag\MIELens\MaxApertureAtMaxFocal(),
                'MaxFocalLength' => new \PHPExiftool\Driver\Tag\MIELens\MaxFocalLength(),
                'MinAperture' => new \PHPExiftool\Driver\Tag\MIELens\MinAperture(),
                'MinFocalLength' => new \PHPExiftool\Driver\Tag\MIELens\MinFocalLength(),
                'LensModel' => new \PHPExiftool\Driver\Tag\MIELens\LensModel(),
                'OpticalZoom' => new \PHPExiftool\Driver\Tag\MIELens\OpticalZoom(),
                'LensSerialNumber' => new \PHPExiftool\Driver\Tag\MIELens\LensSerialNumber(),
            );
        });
        $this['MIE-Main'] = $this->share(function(){
            return array(
                'SubfileType' => new \PHPExiftool\Driver\Tag\MIEMain\SubfileType(),
                'MIEVersion' => new \PHPExiftool\Driver\Tag\MIEMain\MIEVersion(),
                'SubfileDirectory' => new \PHPExiftool\Driver\Tag\MIEMain\SubfileDirectory(),
                'SubfileName' => new \PHPExiftool\Driver\Tag\MIEMain\SubfileName(),
                'SubfileMIMEType' => new \PHPExiftool\Driver\Tag\MIEMain\SubfileMIMEType(),
                'SubfileData' => new \PHPExiftool\Driver\Tag\MIEMain\SubfileData(),
                'SubfileResource' => new \PHPExiftool\Driver\Tag\MIEMain\SubfileResource(),
                'MD5Digest' => new \PHPExiftool\Driver\Tag\MIEMain\MD5Digest(),
                'TrailerSignature' => new \PHPExiftool\Driver\Tag\MIEMain\TrailerSignature(),
            );
        });
        $this['MIE-Orient'] = $this->share(function(){
            return array(
                'Azimuth' => new \PHPExiftool\Driver\Tag\MIEOrient\Azimuth(),
                'Declination' => new \PHPExiftool\Driver\Tag\MIEOrient\Declination(),
                'Elevation' => new \PHPExiftool\Driver\Tag\MIEOrient\Elevation(),
                'RightAscension' => new \PHPExiftool\Driver\Tag\MIEOrient\RightAscension(),
                'Rotation' => new \PHPExiftool\Driver\Tag\MIEOrient\Rotation(),
            );
        });
        $this['MIE-Preview'] = $this->share(function(){
            return array(
                'PreviewImageType' => new \PHPExiftool\Driver\Tag\MIEPreview\PreviewImageType(),
                'PreviewImageName' => new \PHPExiftool\Driver\Tag\MIEPreview\PreviewImageName(),
                'PreviewImageSize' => new \PHPExiftool\Driver\Tag\MIEPreview\PreviewImageSize(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\MIEPreview\PreviewImage(),
            );
        });
        $this['MIE-Thumbnail'] = $this->share(function(){
            return array(
                'ThumbnailImageType' => new \PHPExiftool\Driver\Tag\MIEThumbnail\ThumbnailImageType(),
                'ThumbnailImageName' => new \PHPExiftool\Driver\Tag\MIEThumbnail\ThumbnailImageName(),
                'ThumbnailImageSize' => new \PHPExiftool\Driver\Tag\MIEThumbnail\ThumbnailImageSize(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\MIEThumbnail\ThumbnailImage(),
            );
        });
        $this['MIE-UTM'] = $this->share(function(){
            return array(
                'UTMMapDatum' => new \PHPExiftool\Driver\Tag\MIEUTM\UTMMapDatum(),
                'UTMEasting' => new \PHPExiftool\Driver\Tag\MIEUTM\UTMEasting(),
                'UTMNorthing' => new \PHPExiftool\Driver\Tag\MIEUTM\UTMNorthing(),
                'UTMZone' => new \PHPExiftool\Driver\Tag\MIEUTM\UTMZone(),
            );
        });
        $this['MIE-Video'] = $this->share(function(){
            return array(
                'RelatedVideoFileType' => new \PHPExiftool\Driver\Tag\MIEVideo\RelatedVideoFileType(),
                'RelatedVideoFileName' => new \PHPExiftool\Driver\Tag\MIEVideo\RelatedVideoFileName(),
                'Codec' => new \PHPExiftool\Driver\Tag\MIEVideo\Codec(),
                'Duration' => new \PHPExiftool\Driver\Tag\MIEVideo\Duration(),
                'RelatedVideoFile' => new \PHPExiftool\Driver\Tag\MIEVideo\RelatedVideoFile(),
            );
        });
        $this['MIFF'] = $this->share(function(){
            return array(
                'BackgroundColor' => new \PHPExiftool\Driver\Tag\MIFF\BackgroundColor(),
                'BluePrimary' => new \PHPExiftool\Driver\Tag\MIFF\BluePrimary(),
                'BorderColor' => new \PHPExiftool\Driver\Tag\MIFF\BorderColor(),
                'Class' => new \PHPExiftool\Driver\Tag\MIFF\Class0(),
                'Colors' => new \PHPExiftool\Driver\Tag\MIFF\Colors(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\MIFF\ColorSpace(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\MIFF\ImageWidth(),
                'Compression' => new \PHPExiftool\Driver\Tag\MIFF\Compression(),
                'Delay' => new \PHPExiftool\Driver\Tag\MIFF\Delay(),
                'Depth' => new \PHPExiftool\Driver\Tag\MIFF\Depth(),
                'Dispose' => new \PHPExiftool\Driver\Tag\MIFF\Dispose(),
                'Gamma' => new \PHPExiftool\Driver\Tag\MIFF\Gamma(),
                'GreenPrimary' => new \PHPExiftool\Driver\Tag\MIFF\GreenPrimary(),
                'ID' => new \PHPExiftool\Driver\Tag\MIFF\ID(),
                'Iterations' => new \PHPExiftool\Driver\Tag\MIFF\Iterations(),
                'Label' => new \PHPExiftool\Driver\Tag\MIFF\Label(),
                'MattColor' => new \PHPExiftool\Driver\Tag\MIFF\MattColor(),
                'Matte' => new \PHPExiftool\Driver\Tag\MIFF\Matte(),
                'Montage' => new \PHPExiftool\Driver\Tag\MIFF\Montage(),
                'Packets' => new \PHPExiftool\Driver\Tag\MIFF\Packets(),
                'Page' => new \PHPExiftool\Driver\Tag\MIFF\Page(),
                'RedPrimary' => new \PHPExiftool\Driver\Tag\MIFF\RedPrimary(),
                'RenderingIntent' => new \PHPExiftool\Driver\Tag\MIFF\RenderingIntent(),
                'Resolution' => new \PHPExiftool\Driver\Tag\MIFF\Resolution(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\MIFF\ImageHeight(),
                'Scene' => new \PHPExiftool\Driver\Tag\MIFF\Scene(),
                'Signature' => new \PHPExiftool\Driver\Tag\MIFF\Signature(),
                'Units' => new \PHPExiftool\Driver\Tag\MIFF\Units(),
                'WhitePoint' => new \PHPExiftool\Driver\Tag\MIFF\WhitePoint(),
            );
        });
        $this['MNG'] = $this->share(function(){
            return array(
                'BackgroundColor' => new \PHPExiftool\Driver\Tag\MNG\BackgroundColor(),
                'MandatoryBackground' => new \PHPExiftool\Driver\Tag\MNG\MandatoryBackground(),
                'BackgroundImageID' => new \PHPExiftool\Driver\Tag\MNG\BackgroundImageID(),
                'BackgroundTiling' => new \PHPExiftool\Driver\Tag\MNG\BackgroundTiling(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\MNG\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\MNG\ImageHeight(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\MNG\BitDepth(),
                'ColorType' => new \PHPExiftool\Driver\Tag\MNG\ColorType(),
                'Compression' => new \PHPExiftool\Driver\Tag\MNG\Compression(),
                'Filter' => new \PHPExiftool\Driver\Tag\MNG\Filter(),
                'Interlace' => new \PHPExiftool\Driver\Tag\MNG\Interlace(),
                'RedSample' => new \PHPExiftool\Driver\Tag\MNG\RedSample(),
                'GreenSample' => new \PHPExiftool\Driver\Tag\MNG\GreenSample(),
                'BlueSample' => new \PHPExiftool\Driver\Tag\MNG\BlueSample(),
                'AlphaSample' => new \PHPExiftool\Driver\Tag\MNG\AlphaSample(),
                'Viewable' => new \PHPExiftool\Driver\Tag\MNG\Viewable(),
                'FirstObject' => new \PHPExiftool\Driver\Tag\MNG\FirstObject(),
                'LastObject' => new \PHPExiftool\Driver\Tag\MNG\LastObject(),
                'DeltaType' => new \PHPExiftool\Driver\Tag\MNG\DeltaType(),
                'ClipBoundary' => new \PHPExiftool\Driver\Tag\MNG\ClipBoundary(),
                'SourceID' => new \PHPExiftool\Driver\Tag\MNG\SourceID(),
                'CloneID' => new \PHPExiftool\Driver\Tag\MNG\CloneID(),
                'CloneType' => new \PHPExiftool\Driver\Tag\MNG\CloneType(),
                'DoNotShow' => new \PHPExiftool\Driver\Tag\MNG\DoNotShow(),
                'ConcreteFlag' => new \PHPExiftool\Driver\Tag\MNG\ConcreteFlag(),
                'LocalDeltaType' => new \PHPExiftool\Driver\Tag\MNG\LocalDeltaType(),
                'DeltaXY' => new \PHPExiftool\Driver\Tag\MNG\DeltaXY(),
                'ObjectID' => new \PHPExiftool\Driver\Tag\MNG\ObjectID(),
                'XYLocation' => new \PHPExiftool\Driver\Tag\MNG\XYLocation(),
                'ClippingBoundary' => new \PHPExiftool\Driver\Tag\MNG\ClippingBoundary(),
                'ImageType' => new \PHPExiftool\Driver\Tag\MNG\ImageType(),
                'BlockSize' => new \PHPExiftool\Driver\Tag\MNG\BlockSize(),
                'BlockLocation' => new \PHPExiftool\Driver\Tag\MNG\BlockLocation(),
                'SnapshotID' => new \PHPExiftool\Driver\Tag\MNG\SnapshotID(),
                'SnapshotName' => new \PHPExiftool\Driver\Tag\MNG\SnapshotName(),
                'Priority' => new \PHPExiftool\Driver\Tag\MNG\Priority(),
                'AlphaBitDepth' => new \PHPExiftool\Driver\Tag\MNG\AlphaBitDepth(),
                'AlphaCompression' => new \PHPExiftool\Driver\Tag\MNG\AlphaCompression(),
                'AlphaFilter' => new \PHPExiftool\Driver\Tag\MNG\AlphaFilter(),
                'AlphaInterlace' => new \PHPExiftool\Driver\Tag\MNG\AlphaInterlace(),
                'NestLevel' => new \PHPExiftool\Driver\Tag\MNG\NestLevel(),
                'IterationCount' => new \PHPExiftool\Driver\Tag\MNG\IterationCount(),
                'TerminationCondition' => new \PHPExiftool\Driver\Tag\MNG\TerminationCondition(),
                'IterationMinMax' => new \PHPExiftool\Driver\Tag\MNG\IterationMinMax(),
                'SignalNumber' => new \PHPExiftool\Driver\Tag\MNG\SignalNumber(),
                'TicksPerSecond' => new \PHPExiftool\Driver\Tag\MNG\TicksPerSecond(),
                'NominalLayerCount' => new \PHPExiftool\Driver\Tag\MNG\NominalLayerCount(),
                'NominalFrameCount' => new \PHPExiftool\Driver\Tag\MNG\NominalFrameCount(),
                'NominalPlayTime' => new \PHPExiftool\Driver\Tag\MNG\NominalPlayTime(),
                'SimplicityProfile' => new \PHPExiftool\Driver\Tag\MNG\SimplicityProfile(),
                'FirstObjectID' => new \PHPExiftool\Driver\Tag\MNG\FirstObjectID(),
                'LastObjectID' => new \PHPExiftool\Driver\Tag\MNG\LastObjectID(),
                'XMethod' => new \PHPExiftool\Driver\Tag\MNG\XMethod(),
                'XMag' => new \PHPExiftool\Driver\Tag\MNG\XMag(),
                'YMag' => new \PHPExiftool\Driver\Tag\MNG\YMag(),
                'LeftMag' => new \PHPExiftool\Driver\Tag\MNG\LeftMag(),
                'RightMag' => new \PHPExiftool\Driver\Tag\MNG\RightMag(),
                'TopMag' => new \PHPExiftool\Driver\Tag\MNG\TopMag(),
                'BottomMag' => new \PHPExiftool\Driver\Tag\MNG\BottomMag(),
                'YMethod' => new \PHPExiftool\Driver\Tag\MNG\YMethod(),
                'DropByKeyword' => new \PHPExiftool\Driver\Tag\MNG\DropByKeyword(),
                'DiscardObjects' => new \PHPExiftool\Driver\Tag\MNG\DiscardObjects(),
                'DropChunks' => new \PHPExiftool\Driver\Tag\MNG\DropChunks(),
                'Frame' => new \PHPExiftool\Driver\Tag\MNG\Frame(),
                'OrderingRestrictions' => new \PHPExiftool\Driver\Tag\MNG\OrderingRestrictions(),
                'PartialPalette' => new \PHPExiftool\Driver\Tag\MNG\PartialPalette(),
                'SaveObjects' => new \PHPExiftool\Driver\Tag\MNG\SaveObjects(),
                'SeekPoint' => new \PHPExiftool\Driver\Tag\MNG\SeekPoint(),
                'ResourcesNeeded' => new \PHPExiftool\Driver\Tag\MNG\ResourcesNeeded(),
                'DestinationID' => new \PHPExiftool\Driver\Tag\MNG\DestinationID(),
                'TargetDeltaType' => new \PHPExiftool\Driver\Tag\MNG\TargetDeltaType(),
                'TargetXY' => new \PHPExiftool\Driver\Tag\MNG\TargetXY(),
                'CompositionMode' => new \PHPExiftool\Driver\Tag\MNG\CompositionMode(),
                'Orientation' => new \PHPExiftool\Driver\Tag\MNG\Orientation(),
                'OffsetOrigin' => new \PHPExiftool\Driver\Tag\MNG\OffsetOrigin(),
                'OffsetXY' => new \PHPExiftool\Driver\Tag\MNG\OffsetXY(),
                'BoundaryOrigin' => new \PHPExiftool\Driver\Tag\MNG\BoundaryOrigin(),
                'PastClippingBoundary' => new \PHPExiftool\Driver\Tag\MNG\PastClippingBoundary(),
                'NewColorType' => new \PHPExiftool\Driver\Tag\MNG\NewColorType(),
                'NewBitDepth' => new \PHPExiftool\Driver\Tag\MNG\NewBitDepth(),
                'FillMethod' => new \PHPExiftool\Driver\Tag\MNG\FillMethod(),
                'ShowMode' => new \PHPExiftool\Driver\Tag\MNG\ShowMode(),
                'TerminationAction' => new \PHPExiftool\Driver\Tag\MNG\TerminationAction(),
                'IterationEndAction' => new \PHPExiftool\Driver\Tag\MNG\IterationEndAction(),
                'Delay' => new \PHPExiftool\Driver\Tag\MNG\Delay(),
                'IterationMax' => new \PHPExiftool\Driver\Tag\MNG\IterationMax(),
            );
        });
        $this['MOI'] = $this->share(function(){
            return array(
                'MOIVersion' => new \PHPExiftool\Driver\Tag\MOI\MOIVersion(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\MOI\DateTimeOriginal(),
                'Duration' => new \PHPExiftool\Driver\Tag\MOI\Duration(),
                'AspectRatio' => new \PHPExiftool\Driver\Tag\MOI\AspectRatio(),
                'AudioCodec' => new \PHPExiftool\Driver\Tag\MOI\AudioCodec(),
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\MOI\AudioBitrate(),
                'VideoBitrate' => new \PHPExiftool\Driver\Tag\MOI\VideoBitrate(),
            );
        });
        $this['MPC'] = $this->share(function(){
            return array(
                'TotalFrames' => new \PHPExiftool\Driver\Tag\MPC\TotalFrames(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\MPC\SampleRate(),
                'Quality' => new \PHPExiftool\Driver\Tag\MPC\Quality(),
                'MaxBand' => new \PHPExiftool\Driver\Tag\MPC\MaxBand(),
                'ReplayGainTrackPeak' => new \PHPExiftool\Driver\Tag\MPC\ReplayGainTrackPeak(),
                'ReplayGainTrackGain' => new \PHPExiftool\Driver\Tag\MPC\ReplayGainTrackGain(),
                'ReplayGainAlbumPeak' => new \PHPExiftool\Driver\Tag\MPC\ReplayGainAlbumPeak(),
                'ReplayGainAlbumGain' => new \PHPExiftool\Driver\Tag\MPC\ReplayGainAlbumGain(),
                'FastSeek' => new \PHPExiftool\Driver\Tag\MPC\FastSeek(),
                'Gapless' => new \PHPExiftool\Driver\Tag\MPC\Gapless(),
                'EncoderVersion' => new \PHPExiftool\Driver\Tag\MPC\EncoderVersion(),
            );
        });
        $this['MPEG'] = $this->share(function(){
            return array(
                'MPEGAudioVersion' => new \PHPExiftool\Driver\Tag\MPEG\MPEGAudioVersion(),
                'AudioLayer' => new \PHPExiftool\Driver\Tag\MPEG\AudioLayer(),
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\MPEG\AudioBitrate(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\MPEG\SampleRate(),
                'ChannelMode' => new \PHPExiftool\Driver\Tag\MPEG\ChannelMode(),
                'MSStereo' => new \PHPExiftool\Driver\Tag\MPEG\MSStereo(),
                'ModeExtension' => new \PHPExiftool\Driver\Tag\MPEG\ModeExtension(),
                'IntensityStereo' => new \PHPExiftool\Driver\Tag\MPEG\IntensityStereo(),
                'CopyrightFlag' => new \PHPExiftool\Driver\Tag\MPEG\CopyrightFlag(),
                'OriginalMedia' => new \PHPExiftool\Driver\Tag\MPEG\OriginalMedia(),
                'Emphasis' => new \PHPExiftool\Driver\Tag\MPEG\Emphasis(),
                'LameMethod' => new \PHPExiftool\Driver\Tag\MPEG\LameMethod(),
                'LameLowPassFilter' => new \PHPExiftool\Driver\Tag\MPEG\LameLowPassFilter(),
                'LameBitrate' => new \PHPExiftool\Driver\Tag\MPEG\LameBitrate(),
                'LameStereoMode' => new \PHPExiftool\Driver\Tag\MPEG\LameStereoMode(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\MPEG\ImageWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\MPEG\ImageHeight(),
                'AspectRatio' => new \PHPExiftool\Driver\Tag\MPEG\AspectRatio(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\MPEG\FrameRate(),
                'VideoBitrate' => new \PHPExiftool\Driver\Tag\MPEG\VideoBitrate(),
                'VBRFrames' => new \PHPExiftool\Driver\Tag\MPEG\VBRFrames(),
                'VBRBytes' => new \PHPExiftool\Driver\Tag\MPEG\VBRBytes(),
                'VBRScale' => new \PHPExiftool\Driver\Tag\MPEG\VBRScale(),
                'Encoder' => new \PHPExiftool\Driver\Tag\MPEG\Encoder(),
                'LameVBRQuality' => new \PHPExiftool\Driver\Tag\MPEG\LameVBRQuality(),
                'LameQuality' => new \PHPExiftool\Driver\Tag\MPEG\LameQuality(),
            );
        });
        $this['MPImage'] = $this->share(function(){
            return array(
                'MPImageFlags' => new \PHPExiftool\Driver\Tag\MPImage\MPImageFlags(),
                'MPImageFormat' => new \PHPExiftool\Driver\Tag\MPImage\MPImageFormat(),
                'MPImageType' => new \PHPExiftool\Driver\Tag\MPImage\MPImageType(),
                'MPImageLength' => new \PHPExiftool\Driver\Tag\MPImage\MPImageLength(),
                'MPImageStart' => new \PHPExiftool\Driver\Tag\MPImage\MPImageStart(),
                'DependentImage1EntryNumber' => new \PHPExiftool\Driver\Tag\MPImage\DependentImage1EntryNumber(),
                'DependentImage2EntryNumber' => new \PHPExiftool\Driver\Tag\MPImage\DependentImage2EntryNumber(),
            );
        });
        $this['MPF0'] = $this->share(function(){
            return array(
                'MPFVersion' => new \PHPExiftool\Driver\Tag\MPF0\MPFVersion(),
                'NumberOfImages' => new \PHPExiftool\Driver\Tag\MPF0\NumberOfImages(),
                'ImageUIDList' => new \PHPExiftool\Driver\Tag\MPF0\ImageUIDList(),
                'TotalFrames' => new \PHPExiftool\Driver\Tag\MPF0\TotalFrames(),
                'MPIndividualNum' => new \PHPExiftool\Driver\Tag\MPF0\MPIndividualNum(),
                'PanOrientation' => new \PHPExiftool\Driver\Tag\MPF0\PanOrientation(),
                'PanOverlapH' => new \PHPExiftool\Driver\Tag\MPF0\PanOverlapH(),
                'PanOverlapV' => new \PHPExiftool\Driver\Tag\MPF0\PanOverlapV(),
                'BaseViewpointNum' => new \PHPExiftool\Driver\Tag\MPF0\BaseViewpointNum(),
                'ConvergenceAngle' => new \PHPExiftool\Driver\Tag\MPF0\ConvergenceAngle(),
                'BaselineLength' => new \PHPExiftool\Driver\Tag\MPF0\BaselineLength(),
                'VerticalDivergence' => new \PHPExiftool\Driver\Tag\MPF0\VerticalDivergence(),
                'AxisDistanceX' => new \PHPExiftool\Driver\Tag\MPF0\AxisDistanceX(),
                'AxisDistanceY' => new \PHPExiftool\Driver\Tag\MPF0\AxisDistanceY(),
                'AxisDistanceZ' => new \PHPExiftool\Driver\Tag\MPF0\AxisDistanceZ(),
                'YawAngle' => new \PHPExiftool\Driver\Tag\MPF0\YawAngle(),
                'PitchAngle' => new \PHPExiftool\Driver\Tag\MPF0\PitchAngle(),
                'RollAngle' => new \PHPExiftool\Driver\Tag\MPF0\RollAngle(),
            );
        });
        $this['XMP-mwg-coll'] = $this->share(function(){
            return array(
                'Collections' => new \PHPExiftool\Driver\Tag\XMPMwgColl\Collections(),
                'CollectionName' => new \PHPExiftool\Driver\Tag\XMPMwgColl\CollectionName(),
                'CollectionURI' => new \PHPExiftool\Driver\Tag\XMPMwgColl\CollectionURI(),
            );
        });
        $this['XMP-mwg-kw'] = $this->share(function(){
            return array(
                'KeywordInfo' => new \PHPExiftool\Driver\Tag\XMPMwgKw\KeywordInfo(),
                'HierarchicalKeywords' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords(),
                'HierarchicalKeywords1Applied' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords1Applied(),
                'HierarchicalKeywords1Children' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords1Children(),
                'HierarchicalKeywords2Applied' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords2Applied(),
                'HierarchicalKeywords2Children' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords2Children(),
                'HierarchicalKeywords3Applied' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords3Applied(),
                'HierarchicalKeywords3Children' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords3Children(),
                'HierarchicalKeywords4Applied' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords4Applied(),
                'HierarchicalKeywords4Children' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords4Children(),
                'HierarchicalKeywords5Applied' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords5Applied(),
                'HierarchicalKeywords5Children' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords5Children(),
                'HierarchicalKeywords6Applied' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords6Applied(),
                'HierarchicalKeywords6' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords6(),
                'HierarchicalKeywords5' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords5(),
                'HierarchicalKeywords4' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords4(),
                'HierarchicalKeywords3' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords3(),
                'HierarchicalKeywords2' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords2(),
                'HierarchicalKeywords1' => new \PHPExiftool\Driver\Tag\XMPMwgKw\HierarchicalKeywords1(),
            );
        });
        $this['XMP-mwg-rs'] = $this->share(function(){
            return array(
                'RegionInfo' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionInfo(),
                'RegionAppliedToDimensions' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAppliedToDimensions(),
                'RegionAppliedToDimensionsH' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAppliedToDimensionsH(),
                'RegionAppliedToDimensionsUnit' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAppliedToDimensionsUnit(),
                'RegionAppliedToDimensionsW' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAppliedToDimensionsW(),
                'RegionList' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionList(),
                'RegionArea' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionArea(),
                'RegionAreaD' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAreaD(),
                'RegionAreaH' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAreaH(),
                'RegionAreaUnit' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAreaUnit(),
                'RegionAreaW' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAreaW(),
                'RegionAreaX' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAreaX(),
                'RegionAreaY' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionAreaY(),
                'RegionBarCodeValue' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionBarCodeValue(),
                'RegionDescription' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionDescription(),
                'RegionExtensions' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionExtensions(),
                'RegionFocusUsage' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionFocusUsage(),
                'RegionName' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionName(),
                'RegionRotation' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionRotation(),
                'RegionSeeAlso' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionSeeAlso(),
                'RegionType' => new \PHPExiftool\Driver\Tag\XMPMwgRs\RegionType(),
            );
        });
        $this['MXF'] = $this->share(function(){
            return array(
                'MXFVersion' => new \PHPExiftool\Driver\Tag\MXF\MXFVersion(),
                'FooterPosition' => new \PHPExiftool\Driver\Tag\MXF\FooterPosition(),
                'HeaderSize' => new \PHPExiftool\Driver\Tag\MXF\HeaderSize(),
                'OrganizationID' => new \PHPExiftool\Driver\Tag\MXF\OrganizationID(),
                'UPID' => new \PHPExiftool\Driver\Tag\MXF\UPID(),
                'UPN' => new \PHPExiftool\Driver\Tag\MXF\UPN(),
                'IBTN' => new \PHPExiftool\Driver\Tag\MXF\IBTN(),
                'ISAN' => new \PHPExiftool\Driver\Tag\MXF\ISAN(),
                'ISBN' => new \PHPExiftool\Driver\Tag\MXF\ISBN(),
                'ISSN' => new \PHPExiftool\Driver\Tag\MXF\ISSN(),
                'ISWC' => new \PHPExiftool\Driver\Tag\MXF\ISWC(),
                'ISMN' => new \PHPExiftool\Driver\Tag\MXF\ISMN(),
                'ISCI' => new \PHPExiftool\Driver\Tag\MXF\ISCI(),
                'ISRC' => new \PHPExiftool\Driver\Tag\MXF\ISRC(),
                'ISRN' => new \PHPExiftool\Driver\Tag\MXF\ISRN(),
                'ISBD' => new \PHPExiftool\Driver\Tag\MXF\ISBD(),
                'ISTC' => new \PHPExiftool\Driver\Tag\MXF\ISTC(),
                'SICI' => new \PHPExiftool\Driver\Tag\MXF\SICI(),
                'BICI' => new \PHPExiftool\Driver\Tag\MXF\BICI(),
                'AICI' => new \PHPExiftool\Driver\Tag\MXF\AICI(),
                'PII' => new \PHPExiftool\Driver\Tag\MXF\PII(),
                'DOI' => new \PHPExiftool\Driver\Tag\MXF\DOI(),
                'InstanceUID' => new \PHPExiftool\Driver\Tag\MXF\InstanceUID(),
                'PackageID' => new \PHPExiftool\Driver\Tag\MXF\PackageID(),
                'DeviceDesignation' => new \PHPExiftool\Driver\Tag\MXF\DeviceDesignation(),
                'DeviceModel' => new \PHPExiftool\Driver\Tag\MXF\DeviceModel(),
                'DeviceSerialNumber' => new \PHPExiftool\Driver\Tag\MXF\DeviceSerialNumber(),
                'URL' => new \PHPExiftool\Driver\Tag\MXF\URL(),
                'PURL' => new \PHPExiftool\Driver\Tag\MXF\PURL(),
                'URN' => new \PHPExiftool\Driver\Tag\MXF\URN(),
                'TransmissionID' => new \PHPExiftool\Driver\Tag\MXF\TransmissionID(),
                'ArchiveID' => new \PHPExiftool\Driver\Tag\MXF\ArchiveID(),
                'ItemID' => new \PHPExiftool\Driver\Tag\MXF\ItemID(),
                'AccountingReferenceNumber' => new \PHPExiftool\Driver\Tag\MXF\AccountingReferenceNumber(),
                'TrafficID' => new \PHPExiftool\Driver\Tag\MXF\TrafficID(),
                'ReelOrRollNumber' => new \PHPExiftool\Driver\Tag\MXF\ReelOrRollNumber(),
                'LocalTapeNumber' => new \PHPExiftool\Driver\Tag\MXF\LocalTapeNumber(),
                'LUID' => new \PHPExiftool\Driver\Tag\MXF\LUID(),
                'PackageName' => new \PHPExiftool\Driver\Tag\MXF\PackageName(),
                'LocalFilePath' => new \PHPExiftool\Driver\Tag\MXF\LocalFilePath(),
                'EdgeCode' => new \PHPExiftool\Driver\Tag\MXF\EdgeCode(),
                'FrameCode' => new \PHPExiftool\Driver\Tag\MXF\FrameCode(),
                'KeyCode' => new \PHPExiftool\Driver\Tag\MXF\KeyCode(),
                'InkNumber' => new \PHPExiftool\Driver\Tag\MXF\InkNumber(),
                'KeyText' => new \PHPExiftool\Driver\Tag\MXF\KeyText(),
                'KeyFrame' => new \PHPExiftool\Driver\Tag\MXF\KeyFrame(),
                'KeySound' => new \PHPExiftool\Driver\Tag\MXF\KeySound(),
                'KeyDataOrProgram' => new \PHPExiftool\Driver\Tag\MXF\KeyDataOrProgram(),
                'TitleKind' => new \PHPExiftool\Driver\Tag\MXF\TitleKind(),
                'MainTitle' => new \PHPExiftool\Driver\Tag\MXF\MainTitle(),
                'SecondaryTitle' => new \PHPExiftool\Driver\Tag\MXF\SecondaryTitle(),
                'SeriesNumber' => new \PHPExiftool\Driver\Tag\MXF\SeriesNumber(),
                'EpisodeNumber' => new \PHPExiftool\Driver\Tag\MXF\EpisodeNumber(),
                'SceneNumber' => new \PHPExiftool\Driver\Tag\MXF\SceneNumber(),
                'TakeNumber' => new \PHPExiftool\Driver\Tag\MXF\TakeNumber(),
                'CISACLegalEntityID' => new \PHPExiftool\Driver\Tag\MXF\CISACLegalEntityID(),
                'AGICOAID' => new \PHPExiftool\Driver\Tag\MXF\AGICOAID(),
                'SourceOrganization' => new \PHPExiftool\Driver\Tag\MXF\SourceOrganization(),
                'SupplyContractNumber' => new \PHPExiftool\Driver\Tag\MXF\SupplyContractNumber(),
                'OriginalProducerName' => new \PHPExiftool\Driver\Tag\MXF\OriginalProducerName(),
                'TotalEpisodeCount' => new \PHPExiftool\Driver\Tag\MXF\TotalEpisodeCount(),
                'CopyrightStatus' => new \PHPExiftool\Driver\Tag\MXF\CopyrightStatus(),
                'CopyrightOwnerName' => new \PHPExiftool\Driver\Tag\MXF\CopyrightOwnerName(),
                'IntellectualPropertyDescription' => new \PHPExiftool\Driver\Tag\MXF\IntellectualPropertyDescription(),
                'IntellectualPropertyRights' => new \PHPExiftool\Driver\Tag\MXF\IntellectualPropertyRights(),
                'Rightsholder' => new \PHPExiftool\Driver\Tag\MXF\Rightsholder(),
                'RightsManagementAuthority' => new \PHPExiftool\Driver\Tag\MXF\RightsManagementAuthority(),
                'InterestedPartyName' => new \PHPExiftool\Driver\Tag\MXF\InterestedPartyName(),
                'MaximumUseCount' => new \PHPExiftool\Driver\Tag\MXF\MaximumUseCount(),
                'LicenseOptionsDescription' => new \PHPExiftool\Driver\Tag\MXF\LicenseOptionsDescription(),
                'CurrencyCode' => new \PHPExiftool\Driver\Tag\MXF\CurrencyCode(),
                'RoyaltyPaymentInformation' => new \PHPExiftool\Driver\Tag\MXF\RoyaltyPaymentInformation(),
                'RoyaltyIncomeInformation' => new \PHPExiftool\Driver\Tag\MXF\RoyaltyIncomeInformation(),
                'RestrictionsonUse' => new \PHPExiftool\Driver\Tag\MXF\RestrictionsonUse(),
                'ExCCIData' => new \PHPExiftool\Driver\Tag\MXF\ExCCIData(),
                'UserName' => new \PHPExiftool\Driver\Tag\MXF\UserName(),
                'Password' => new \PHPExiftool\Driver\Tag\MXF\Password(),
                'ScramblingKeyKind' => new \PHPExiftool\Driver\Tag\MXF\ScramblingKeyKind(),
                'ScramblingKeyValue' => new \PHPExiftool\Driver\Tag\MXF\ScramblingKeyValue(),
                'BroadcastOrganizationName' => new \PHPExiftool\Driver\Tag\MXF\BroadcastOrganizationName(),
                'BroadcastChannel' => new \PHPExiftool\Driver\Tag\MXF\BroadcastChannel(),
                'BroadcastMediumKind' => new \PHPExiftool\Driver\Tag\MXF\BroadcastMediumKind(),
                'BroadcastRegion' => new \PHPExiftool\Driver\Tag\MXF\BroadcastRegion(),
                'FirstBroadcastFlag' => new \PHPExiftool\Driver\Tag\MXF\FirstBroadcastFlag(),
                'CurrentRepeatNumber' => new \PHPExiftool\Driver\Tag\MXF\CurrentRepeatNumber(),
                'PreviousRepeatNumber' => new \PHPExiftool\Driver\Tag\MXF\PreviousRepeatNumber(),
                'AudienceRating' => new \PHPExiftool\Driver\Tag\MXF\AudienceRating(),
                'AudienceReach' => new \PHPExiftool\Driver\Tag\MXF\AudienceReach(),
                'NatureOfPersonality' => new \PHPExiftool\Driver\Tag\MXF\NatureOfPersonality(),
                'ContributionStatus' => new \PHPExiftool\Driver\Tag\MXF\ContributionStatus(),
                'SupportOrAdministrationStatus' => new \PHPExiftool\Driver\Tag\MXF\SupportOrAdministrationStatus(),
                'OrganizationKind' => new \PHPExiftool\Driver\Tag\MXF\OrganizationKind(),
                'ProductionOrganizationRole' => new \PHPExiftool\Driver\Tag\MXF\ProductionOrganizationRole(),
                'SupportOrganizationRole' => new \PHPExiftool\Driver\Tag\MXF\SupportOrganizationRole(),
                'JobFunctionName' => new \PHPExiftool\Driver\Tag\MXF\JobFunctionName(),
                'RoleName' => new \PHPExiftool\Driver\Tag\MXF\RoleName(),
                'ContactKind' => new \PHPExiftool\Driver\Tag\MXF\ContactKind(),
                'ContactDepartmentName' => new \PHPExiftool\Driver\Tag\MXF\ContactDepartmentName(),
                'FamilyName' => new \PHPExiftool\Driver\Tag\MXF\FamilyName(),
                'FirstGivenName' => new \PHPExiftool\Driver\Tag\MXF\FirstGivenName(),
                'SecondGivenName' => new \PHPExiftool\Driver\Tag\MXF\SecondGivenName(),
                'ThirdGivenName' => new \PHPExiftool\Driver\Tag\MXF\ThirdGivenName(),
                'MainName' => new \PHPExiftool\Driver\Tag\MXF\MainName(),
                'SupplementaryName' => new \PHPExiftool\Driver\Tag\MXF\SupplementaryName(),
                'OrganizationMainName' => new \PHPExiftool\Driver\Tag\MXF\OrganizationMainName(),
                'SupplementaryOrganizationName' => new \PHPExiftool\Driver\Tag\MXF\SupplementaryOrganizationName(),
                'ISO3166CountryCode' => new \PHPExiftool\Driver\Tag\MXF\ISO3166CountryCode(),
                'ISO639-1LanguageCode' => new \PHPExiftool\Driver\Tag\MXF\ISO6391LanguageCode(),
                'OperatingSystemInterpretations' => new \PHPExiftool\Driver\Tag\MXF\OperatingSystemInterpretations(),
                'ByteOrder' => new \PHPExiftool\Driver\Tag\MXF\ByteOrder(),
                'EssenceIsIdentified' => new \PHPExiftool\Driver\Tag\MXF\EssenceIsIdentified(),
                'LengthSystemName' => new \PHPExiftool\Driver\Tag\MXF\LengthSystemName(),
                'LengthUnitKind' => new \PHPExiftool\Driver\Tag\MXF\LengthUnitKind(),
                'AngularUnitKind' => new \PHPExiftool\Driver\Tag\MXF\AngularUnitKind(),
                'TimeSystemOffset' => new \PHPExiftool\Driver\Tag\MXF\TimeSystemOffset(),
                'TimeUnitKind' => new \PHPExiftool\Driver\Tag\MXF\TimeUnitKind(),
                'ContentCodingSystem' => new \PHPExiftool\Driver\Tag\MXF\ContentCodingSystem(),
                'ProgramKind' => new \PHPExiftool\Driver\Tag\MXF\ProgramKind(),
                'Genre' => new \PHPExiftool\Driver\Tag\MXF\Genre(),
                'TargetAudience' => new \PHPExiftool\Driver\Tag\MXF\TargetAudience(),
                'CatalogDataStatus' => new \PHPExiftool\Driver\Tag\MXF\CatalogDataStatus(),
                'ThesaurusName' => new \PHPExiftool\Driver\Tag\MXF\ThesaurusName(),
                'Theme' => new \PHPExiftool\Driver\Tag\MXF\Theme(),
                'ContentClassification' => new \PHPExiftool\Driver\Tag\MXF\ContentClassification(),
                'Keywords' => new \PHPExiftool\Driver\Tag\MXF\Keywords(),
                'KeyFrames' => new \PHPExiftool\Driver\Tag\MXF\KeyFrames(),
                'KeySounds' => new \PHPExiftool\Driver\Tag\MXF\KeySounds(),
                'KeyData' => new \PHPExiftool\Driver\Tag\MXF\KeyData(),
                'Abstract' => new \PHPExiftool\Driver\Tag\MXF\Abstract0(),
                'Purpose' => new \PHPExiftool\Driver\Tag\MXF\Purpose(),
                'Description' => new \PHPExiftool\Driver\Tag\MXF\Description(),
                'ColorDescriptor' => new \PHPExiftool\Driver\Tag\MXF\ColorDescriptor(),
                'FormatDescriptor' => new \PHPExiftool\Driver\Tag\MXF\FormatDescriptor(),
                'StratumKind' => new \PHPExiftool\Driver\Tag\MXF\StratumKind(),
                'IndividualAwardName' => new \PHPExiftool\Driver\Tag\MXF\IndividualAwardName(),
                'ProgramAwardName' => new \PHPExiftool\Driver\Tag\MXF\ProgramAwardName(),
                'AssetValue' => new \PHPExiftool\Driver\Tag\MXF\AssetValue(),
                'ContentValue' => new \PHPExiftool\Driver\Tag\MXF\ContentValue(),
                'CulturalValue' => new \PHPExiftool\Driver\Tag\MXF\CulturalValue(),
                'AestheticValue' => new \PHPExiftool\Driver\Tag\MXF\AestheticValue(),
                'HistoricalValue' => new \PHPExiftool\Driver\Tag\MXF\HistoricalValue(),
                'TechnicalValue' => new \PHPExiftool\Driver\Tag\MXF\TechnicalValue(),
                'OtherValues' => new \PHPExiftool\Driver\Tag\MXF\OtherValues(),
                'CatalogingSystemName' => new \PHPExiftool\Driver\Tag\MXF\CatalogingSystemName(),
                'ComputedKeywords' => new \PHPExiftool\Driver\Tag\MXF\ComputedKeywords(),
                'ComputedKeyFrames' => new \PHPExiftool\Driver\Tag\MXF\ComputedKeyFrames(),
                'ComputedKeySounds' => new \PHPExiftool\Driver\Tag\MXF\ComputedKeySounds(),
                'ComputedKeyData' => new \PHPExiftool\Driver\Tag\MXF\ComputedKeyData(),
                'ComputedStratumKind' => new \PHPExiftool\Driver\Tag\MXF\ComputedStratumKind(),
                'PresentationAspectRatio' => new \PHPExiftool\Driver\Tag\MXF\PresentationAspectRatio(),
                'CaptureAspectRatio' => new \PHPExiftool\Driver\Tag\MXF\CaptureAspectRatio(),
                'CaptureGammaEquation' => new \PHPExiftool\Driver\Tag\MXF\CaptureGammaEquation(),
                'LumaEquation' => new \PHPExiftool\Driver\Tag\MXF\LumaEquation(),
                'ColorimetryCode' => new \PHPExiftool\Driver\Tag\MXF\ColorimetryCode(),
                'SignalFormCode' => new \PHPExiftool\Driver\Tag\MXF\SignalFormCode(),
                'ColorFieldCode' => new \PHPExiftool\Driver\Tag\MXF\ColorFieldCode(),
                'FieldRate' => new \PHPExiftool\Driver\Tag\MXF\FieldRate(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\MXF\FrameRate(),
                'FrameLayout' => new \PHPExiftool\Driver\Tag\MXF\FrameLayout(),
                'SamplingStructureCode' => new \PHPExiftool\Driver\Tag\MXF\SamplingStructureCode(),
                'TotalLinesperFrame' => new \PHPExiftool\Driver\Tag\MXF\TotalLinesperFrame(),
                'ActiveLinesperFrame' => new \PHPExiftool\Driver\Tag\MXF\ActiveLinesperFrame(),
                'LeadingLines' => new \PHPExiftool\Driver\Tag\MXF\LeadingLines(),
                'TrailingLines' => new \PHPExiftool\Driver\Tag\MXF\TrailingLines(),
                'AnalogVideoSystemName' => new \PHPExiftool\Driver\Tag\MXF\AnalogVideoSystemName(),
                'LuminanceSampleRate' => new \PHPExiftool\Driver\Tag\MXF\LuminanceSampleRate(),
                'ActiveSamplesperLine' => new \PHPExiftool\Driver\Tag\MXF\ActiveSamplesperLine(),
                'TotalSamplesperLine' => new \PHPExiftool\Driver\Tag\MXF\TotalSamplesperLine(),
                'SamplingHierarchyCode' => new \PHPExiftool\Driver\Tag\MXF\SamplingHierarchyCode(),
                'HorizontalSubsampling' => new \PHPExiftool\Driver\Tag\MXF\HorizontalSubsampling(),
                'ColorSiting' => new \PHPExiftool\Driver\Tag\MXF\ColorSiting(),
                'SampledHeight' => new \PHPExiftool\Driver\Tag\MXF\SampledHeight(),
                'SampledWidth' => new \PHPExiftool\Driver\Tag\MXF\SampledWidth(),
                'SampledXOffset' => new \PHPExiftool\Driver\Tag\MXF\SampledXOffset(),
                'SampledYOffset' => new \PHPExiftool\Driver\Tag\MXF\SampledYOffset(),
                'DisplayHeight' => new \PHPExiftool\Driver\Tag\MXF\DisplayHeight(),
                'DisplayWidth' => new \PHPExiftool\Driver\Tag\MXF\DisplayWidth(),
                'DisplayXOffset' => new \PHPExiftool\Driver\Tag\MXF\DisplayXOffset(),
                'DisplayYOffset' => new \PHPExiftool\Driver\Tag\MXF\DisplayYOffset(),
                'FilteringCode' => new \PHPExiftool\Driver\Tag\MXF\FilteringCode(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\MXF\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\MXF\ImageWidth(),
                'BitsPerPixel' => new \PHPExiftool\Driver\Tag\MXF\BitsPerPixel(),
                'RoundingMethodCode' => new \PHPExiftool\Driver\Tag\MXF\RoundingMethodCode(),
                'BlackReferenceLevel' => new \PHPExiftool\Driver\Tag\MXF\BlackReferenceLevel(),
                'WhiteReferenceLevel' => new \PHPExiftool\Driver\Tag\MXF\WhiteReferenceLevel(),
                'FieldFrameTypeCode' => new \PHPExiftool\Driver\Tag\MXF\FieldFrameTypeCode(),
                'PulldownSequence' => new \PHPExiftool\Driver\Tag\MXF\PulldownSequence(),
                'PulldownFieldDominance' => new \PHPExiftool\Driver\Tag\MXF\PulldownFieldDominance(),
                'VideoAndFilmFrameRelationship' => new \PHPExiftool\Driver\Tag\MXF\VideoAndFilmFrameRelationship(),
                'CaptureFilmFrameRate' => new \PHPExiftool\Driver\Tag\MXF\CaptureFilmFrameRate(),
                'TransferFilmFrameRate' => new \PHPExiftool\Driver\Tag\MXF\TransferFilmFrameRate(),
                'VideoTestParameter' => new \PHPExiftool\Driver\Tag\MXF\VideoTestParameter(),
                'VideoTestResult' => new \PHPExiftool\Driver\Tag\MXF\VideoTestResult(),
                'FilmTestParameter' => new \PHPExiftool\Driver\Tag\MXF\FilmTestParameter(),
                'FilmTestResult' => new \PHPExiftool\Driver\Tag\MXF\FilmTestResult(),
                'ElectrospatialFormulation' => new \PHPExiftool\Driver\Tag\MXF\ElectrospatialFormulation(),
                'FilteringApplied' => new \PHPExiftool\Driver\Tag\MXF\FilteringApplied(),
                'AudioReferenceLevel' => new \PHPExiftool\Driver\Tag\MXF\AudioReferenceLevel(),
                'AudioMonoChannelCount' => new \PHPExiftool\Driver\Tag\MXF\AudioMonoChannelCount(),
                'AudioStereoChannelCount' => new \PHPExiftool\Driver\Tag\MXF\AudioStereoChannelCount(),
                'AnalogSystem' => new \PHPExiftool\Driver\Tag\MXF\AnalogSystem(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\MXF\AudioSampleRate(),
                'BitsPerSample' => new \PHPExiftool\Driver\Tag\MXF\BitsPerSample(),
                'RoundingLaw' => new \PHPExiftool\Driver\Tag\MXF\RoundingLaw(),
                'Dither' => new \PHPExiftool\Driver\Tag\MXF\Dither(),
                'OpticalTrack' => new \PHPExiftool\Driver\Tag\MXF\OpticalTrack(),
                'MagneticTrack' => new \PHPExiftool\Driver\Tag\MXF\MagneticTrack(),
                'Signal-to-NoiseRatio' => new \PHPExiftool\Driver\Tag\MXF\SignalToNoiseRatio(),
                'Weighting' => new \PHPExiftool\Driver\Tag\MXF\Weighting(),
                'AnalogDataCodingKind' => new \PHPExiftool\Driver\Tag\MXF\AnalogDataCodingKind(),
                'TimecodeKind' => new \PHPExiftool\Driver\Tag\MXF\TimecodeKind(),
                'TimecodeTimebase' => new \PHPExiftool\Driver\Tag\MXF\TimecodeTimebase(),
                'TimecodeUserBitsFlag' => new \PHPExiftool\Driver\Tag\MXF\TimecodeUserBitsFlag(),
                'IncludeSync' => new \PHPExiftool\Driver\Tag\MXF\IncludeSync(),
                'DropFrame' => new \PHPExiftool\Driver\Tag\MXF\DropFrame(),
                'TimecodeSourceKind' => new \PHPExiftool\Driver\Tag\MXF\TimecodeSourceKind(),
                'AnalogMetadataCarrier' => new \PHPExiftool\Driver\Tag\MXF\AnalogMetadataCarrier(),
                'DigitalMetadataCarrier' => new \PHPExiftool\Driver\Tag\MXF\DigitalMetadataCarrier(),
                'AnalogMonitoringAndControlCodingKind' => new \PHPExiftool\Driver\Tag\MXF\AnalogMonitoringAndControlCodingKind(),
                'SampleRate' => new \PHPExiftool\Driver\Tag\MXF\SampleRate(),
                'EssenceLength' => new \PHPExiftool\Driver\Tag\MXF\EssenceLength(),
                'FilmColorProcess' => new \PHPExiftool\Driver\Tag\MXF\FilmColorProcess(),
                'EdgeCodeFormat' => new \PHPExiftool\Driver\Tag\MXF\EdgeCodeFormat(),
                'FilmFormatName' => new \PHPExiftool\Driver\Tag\MXF\FilmFormatName(),
                'FilmStockKind' => new \PHPExiftool\Driver\Tag\MXF\FilmStockKind(),
                'FilmStockManufacturerName' => new \PHPExiftool\Driver\Tag\MXF\FilmStockManufacturerName(),
                'PhysicalMediaLength' => new \PHPExiftool\Driver\Tag\MXF\PhysicalMediaLength(),
                'FilmCaptureAperture' => new \PHPExiftool\Driver\Tag\MXF\FilmCaptureAperture(),
                'ImageCategory' => new \PHPExiftool\Driver\Tag\MXF\ImageCategory(),
                'ImageSourceDeviceKind' => new \PHPExiftool\Driver\Tag\MXF\ImageSourceDeviceKind(),
                'OpticalTestParameterName' => new \PHPExiftool\Driver\Tag\MXF\OpticalTestParameterName(),
                'OpticalTestResult' => new \PHPExiftool\Driver\Tag\MXF\OpticalTestResult(),
                'SensorType' => new \PHPExiftool\Driver\Tag\MXF\SensorType(),
                'PolarCharacteristic' => new \PHPExiftool\Driver\Tag\MXF\PolarCharacteristic(),
                'IntegrationIndication' => new \PHPExiftool\Driver\Tag\MXF\IntegrationIndication(),
                'EventIndication' => new \PHPExiftool\Driver\Tag\MXF\EventIndication(),
                'QualityFlag' => new \PHPExiftool\Driver\Tag\MXF\QualityFlag(),
                'PhysicalInstanceKind' => new \PHPExiftool\Driver\Tag\MXF\PhysicalInstanceKind(),
                'DigitalOrAnalogOrigination' => new \PHPExiftool\Driver\Tag\MXF\DigitalOrAnalogOrigination(),
                'MicrophonePlacementTechniques' => new \PHPExiftool\Driver\Tag\MXF\MicrophonePlacementTechniques(),
                'SimpleFlaggingCount' => new \PHPExiftool\Driver\Tag\MXF\SimpleFlaggingCount(),
                'CopyCount' => new \PHPExiftool\Driver\Tag\MXF\CopyCount(),
                'CloneCount' => new \PHPExiftool\Driver\Tag\MXF\CloneCount(),
                'Work-in-ProgressFlag' => new \PHPExiftool\Driver\Tag\MXF\WorkInProgressFlag(),
                'VideoOrImageCompressionAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\VideoOrImageCompressionAlgorithm(),
                'SplicingMetadata' => new \PHPExiftool\Driver\Tag\MXF\SplicingMetadata(),
                'AudioCompressionAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\AudioCompressionAlgorithm(),
                'VideoNoiseReductionAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\VideoNoiseReductionAlgorithm(),
                'AudioNoiseReductionAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\AudioNoiseReductionAlgorithm(),
                'EnhancementOrModificationDescription' => new \PHPExiftool\Driver\Tag\MXF\EnhancementOrModificationDescription(),
                'VideoDeviceKind' => new \PHPExiftool\Driver\Tag\MXF\VideoDeviceKind(),
                'VideoDeviceParameterName' => new \PHPExiftool\Driver\Tag\MXF\VideoDeviceParameterName(),
                'VideoDeviceParameterSetting' => new \PHPExiftool\Driver\Tag\MXF\VideoDeviceParameterSetting(),
                'AudioEnhancementOrModificationDescription' => new \PHPExiftool\Driver\Tag\MXF\AudioEnhancementOrModificationDescription(),
                'AudioFirstMix-DownProcess' => new \PHPExiftool\Driver\Tag\MXF\AudioFirstMixDownProcess(),
                'AudioDeviceKind' => new \PHPExiftool\Driver\Tag\MXF\AudioDeviceKind(),
                'AudioDeviceParameter' => new \PHPExiftool\Driver\Tag\MXF\AudioDeviceParameter(),
                'AudioDeviceParameterSetting' => new \PHPExiftool\Driver\Tag\MXF\AudioDeviceParameterSetting(),
                'DataEnhancementOrModificationDescription' => new \PHPExiftool\Driver\Tag\MXF\DataEnhancementOrModificationDescription(),
                'DataDeviceKind' => new \PHPExiftool\Driver\Tag\MXF\DataDeviceKind(),
                'DataDeviceParameterName' => new \PHPExiftool\Driver\Tag\MXF\DataDeviceParameterName(),
                'DataDeviceParameterSetting' => new \PHPExiftool\Driver\Tag\MXF\DataDeviceParameterSetting(),
                'DefaultFadeType' => new \PHPExiftool\Driver\Tag\MXF\DefaultFadeType(),
                'ActiveState' => new \PHPExiftool\Driver\Tag\MXF\ActiveState(),
                'Fade-InType' => new \PHPExiftool\Driver\Tag\MXF\FadeInType(),
                'Fade-OutType' => new \PHPExiftool\Driver\Tag\MXF\FadeOutType(),
                'SpeedChangeEffectFlag' => new \PHPExiftool\Driver\Tag\MXF\SpeedChangeEffectFlag(),
                'InputSegmentCount' => new \PHPExiftool\Driver\Tag\MXF\InputSegmentCount(),
                'Bypass' => new \PHPExiftool\Driver\Tag\MXF\Bypass(),
                'VideoCompressionAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\VideoCompressionAlgorithm(),
                'MPEGVideoRecodingDataset' => new \PHPExiftool\Driver\Tag\MXF\MPEGVideoRecodingDataset(),
                'UpstreamAudioCompressionAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\UpstreamAudioCompressionAlgorithm(),
                'MPEGAudioRecodingDataset' => new \PHPExiftool\Driver\Tag\MXF\MPEGAudioRecodingDataset(),
                'ProgramSupportMaterialReference' => new \PHPExiftool\Driver\Tag\MXF\ProgramSupportMaterialReference(),
                'AdvertisingMaterialReference' => new \PHPExiftool\Driver\Tag\MXF\AdvertisingMaterialReference(),
                'ProgramCommercialMaterialReference' => new \PHPExiftool\Driver\Tag\MXF\ProgramCommercialMaterialReference(),
                'ContiguousDataFlag' => new \PHPExiftool\Driver\Tag\MXF\ContiguousDataFlag(),
                'PositionInSequence' => new \PHPExiftool\Driver\Tag\MXF\PositionInSequence(),
                'RelativePositionInSequenceOffset' => new \PHPExiftool\Driver\Tag\MXF\RelativePositionInSequenceOffset(),
                'RelativePositionInSequenceName' => new \PHPExiftool\Driver\Tag\MXF\RelativePositionInSequenceName(),
                'ImageCoordinateSystem' => new \PHPExiftool\Driver\Tag\MXF\ImageCoordinateSystem(),
                'MapDatumUsed' => new \PHPExiftool\Driver\Tag\MXF\MapDatumUsed(),
                'LocalDatumAbsolutePositionAccuracy' => new \PHPExiftool\Driver\Tag\MXF\LocalDatumAbsolutePositionAccuracy(),
                'DeviceAbsolutePositionalAccuracy' => new \PHPExiftool\Driver\Tag\MXF\DeviceAbsolutePositionalAccuracy(),
                'DeviceAltitude' => new \PHPExiftool\Driver\Tag\MXF\DeviceAltitude(),
                'DeviceLatitude' => new \PHPExiftool\Driver\Tag\MXF\DeviceLatitude(),
                'DeviceLongitude' => new \PHPExiftool\Driver\Tag\MXF\DeviceLongitude(),
                'DeviceXDimension' => new \PHPExiftool\Driver\Tag\MXF\DeviceXDimension(),
                'DeviceYDimension' => new \PHPExiftool\Driver\Tag\MXF\DeviceYDimension(),
                'FramePositionalAccuracy' => new \PHPExiftool\Driver\Tag\MXF\FramePositionalAccuracy(),
                'FrameCenterLatitude' => new \PHPExiftool\Driver\Tag\MXF\FrameCenterLatitude(),
                'FrameCenterLongitude' => new \PHPExiftool\Driver\Tag\MXF\FrameCenterLongitude(),
                'FrameCenterLatitudeLongitude' => new \PHPExiftool\Driver\Tag\MXF\FrameCenterLatitudeLongitude(),
                'LocalDatumRelativePositionAccuracy' => new \PHPExiftool\Driver\Tag\MXF\LocalDatumRelativePositionAccuracy(),
                'DeviceRelativePositionalAccuracy' => new \PHPExiftool\Driver\Tag\MXF\DeviceRelativePositionalAccuracy(),
                'DeviceRelativePositionX' => new \PHPExiftool\Driver\Tag\MXF\DeviceRelativePositionX(),
                'DeviceRelativePositionY' => new \PHPExiftool\Driver\Tag\MXF\DeviceRelativePositionY(),
                'DeviceRelativePositionZ' => new \PHPExiftool\Driver\Tag\MXF\DeviceRelativePositionZ(),
                'SubjectRelativePositionalAccuracy' => new \PHPExiftool\Driver\Tag\MXF\SubjectRelativePositionalAccuracy(),
                'PositionWithinViewportImageXCoordinate' => new \PHPExiftool\Driver\Tag\MXF\PositionWithinViewportImageXCoordinate(),
                'PositionWithinViewportImageYCoordinate' => new \PHPExiftool\Driver\Tag\MXF\PositionWithinViewportImageYCoordinate(),
                'SourceImageCenterXCoordinate' => new \PHPExiftool\Driver\Tag\MXF\SourceImageCenterXCoordinate(),
                'SourceImageCenterYCoordinate' => new \PHPExiftool\Driver\Tag\MXF\SourceImageCenterYCoordinate(),
                'ViewportImageCenterCCoordinate' => new \PHPExiftool\Driver\Tag\MXF\ViewportImageCenterCCoordinate(),
                'ViewportImageCenterYCoordinate' => new \PHPExiftool\Driver\Tag\MXF\ViewportImageCenterYCoordinate(),
                'DeviceAbsoluteSpeed' => new \PHPExiftool\Driver\Tag\MXF\DeviceAbsoluteSpeed(),
                'DeviceAbsoluteHeading' => new \PHPExiftool\Driver\Tag\MXF\DeviceAbsoluteHeading(),
                'SubjectAbsoluteSpeed' => new \PHPExiftool\Driver\Tag\MXF\SubjectAbsoluteSpeed(),
                'SubjectAbsoluteHeading' => new \PHPExiftool\Driver\Tag\MXF\SubjectAbsoluteHeading(),
                'DeviceRelativeSpeed' => new \PHPExiftool\Driver\Tag\MXF\DeviceRelativeSpeed(),
                'DeviceRelativeHeading' => new \PHPExiftool\Driver\Tag\MXF\DeviceRelativeHeading(),
                'SubjectRelativeSpeed' => new \PHPExiftool\Driver\Tag\MXF\SubjectRelativeSpeed(),
                'SubjectRelativeHeading' => new \PHPExiftool\Driver\Tag\MXF\SubjectRelativeHeading(),
                'SlantRange' => new \PHPExiftool\Driver\Tag\MXF\SlantRange(),
                'TargetWidth' => new \PHPExiftool\Driver\Tag\MXF\TargetWidth(),
                'ViewportHeight' => new \PHPExiftool\Driver\Tag\MXF\ViewportHeight(),
                'ViewportWidth' => new \PHPExiftool\Driver\Tag\MXF\ViewportWidth(),
                'SensorRollAngle' => new \PHPExiftool\Driver\Tag\MXF\SensorRollAngle(),
                'AngleToNorth' => new \PHPExiftool\Driver\Tag\MXF\AngleToNorth(),
                'ObliquityAngle' => new \PHPExiftool\Driver\Tag\MXF\ObliquityAngle(),
                'PlaceKeyword' => new \PHPExiftool\Driver\Tag\MXF\PlaceKeyword(),
                'ObjectCountryCode' => new \PHPExiftool\Driver\Tag\MXF\ObjectCountryCode(),
                'ShootingCountryCode' => new \PHPExiftool\Driver\Tag\MXF\ShootingCountryCode(),
                'SettingCountryCode' => new \PHPExiftool\Driver\Tag\MXF\SettingCountryCode(),
                'CopyrightLicenseCountryCode' => new \PHPExiftool\Driver\Tag\MXF\CopyrightLicenseCountryCode(),
                'IntellectualPropertyLicenseCountryCode' => new \PHPExiftool\Driver\Tag\MXF\IntellectualPropertyLicenseCountryCode(),
                'ObjectRegionCode' => new \PHPExiftool\Driver\Tag\MXF\ObjectRegionCode(),
                'ShootingRegionCode' => new \PHPExiftool\Driver\Tag\MXF\ShootingRegionCode(),
                'SettingRegionCode' => new \PHPExiftool\Driver\Tag\MXF\SettingRegionCode(),
                'CopyrightLicenseRegionCode' => new \PHPExiftool\Driver\Tag\MXF\CopyrightLicenseRegionCode(),
                'IntellectualPropertyLicenseRegionCode' => new \PHPExiftool\Driver\Tag\MXF\IntellectualPropertyLicenseRegionCode(),
                'RoomNumber' => new \PHPExiftool\Driver\Tag\MXF\RoomNumber(),
                'StreetNumber' => new \PHPExiftool\Driver\Tag\MXF\StreetNumber(),
                'StreetName' => new \PHPExiftool\Driver\Tag\MXF\StreetName(),
                'PostalTown' => new \PHPExiftool\Driver\Tag\MXF\PostalTown(),
                'CityName' => new \PHPExiftool\Driver\Tag\MXF\CityName(),
                'StateOrProvinceOrCountyName' => new \PHPExiftool\Driver\Tag\MXF\StateOrProvinceOrCountyName(),
                'PostalCode' => new \PHPExiftool\Driver\Tag\MXF\PostalCode(),
                'CountryName' => new \PHPExiftool\Driver\Tag\MXF\CountryName(),
                'SettingRoomNumber' => new \PHPExiftool\Driver\Tag\MXF\SettingRoomNumber(),
                'SettingStreetNumberOrBuildingName' => new \PHPExiftool\Driver\Tag\MXF\SettingStreetNumberOrBuildingName(),
                'SettingStreetName' => new \PHPExiftool\Driver\Tag\MXF\SettingStreetName(),
                'SettingTownName' => new \PHPExiftool\Driver\Tag\MXF\SettingTownName(),
                'SettingCityName' => new \PHPExiftool\Driver\Tag\MXF\SettingCityName(),
                'SettingStateOrProvinceOrCountyName' => new \PHPExiftool\Driver\Tag\MXF\SettingStateOrProvinceOrCountyName(),
                'SettingPostalCode' => new \PHPExiftool\Driver\Tag\MXF\SettingPostalCode(),
                'SettingCountryName' => new \PHPExiftool\Driver\Tag\MXF\SettingCountryName(),
                'TelephoneNumber' => new \PHPExiftool\Driver\Tag\MXF\TelephoneNumber(),
                'FaxNumber' => new \PHPExiftool\Driver\Tag\MXF\FaxNumber(),
                'E-mailAddress' => new \PHPExiftool\Driver\Tag\MXF\EMailAddress(),
                'SettingDescription' => new \PHPExiftool\Driver\Tag\MXF\SettingDescription(),
                'UTCUserDateTime' => new \PHPExiftool\Driver\Tag\MXF\UTCUserDateTime(),
                'LocalUserDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalUserDateTime(),
                'SMPTE309MUserDateTime' => new \PHPExiftool\Driver\Tag\MXF\SMPTE309MUserDateTime(),
                'SMPTE12MUserDateTime' => new \PHPExiftool\Driver\Tag\MXF\SMPTE12MUserDateTime(),
                'UTCStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\UTCStartDateTime(),
                'LocalStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalStartDateTime(),
                'TimecodeStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\TimecodeStartDateTime(),
                'UTCEndDateTime' => new \PHPExiftool\Driver\Tag\MXF\UTCEndDateTime(),
                'LocalEndDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalEndDateTime(),
                'TimecodeEndDateTime' => new \PHPExiftool\Driver\Tag\MXF\TimecodeEndDateTime(),
                'UTCLastModifyDate' => new \PHPExiftool\Driver\Tag\MXF\UTCLastModifyDate(),
                'LocalLastModifyDate' => new \PHPExiftool\Driver\Tag\MXF\LocalLastModifyDate(),
                'TimecodeLastModifyDate' => new \PHPExiftool\Driver\Tag\MXF\TimecodeLastModifyDate(),
                'UTCEventStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\UTCEventStartDateTime(),
                'LocalEventStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalEventStartDateTime(),
                'TimecodeEventStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\TimecodeEventStartDateTime(),
                'UTCEventEndDateTime' => new \PHPExiftool\Driver\Tag\MXF\UTCEventEndDateTime(),
                'LocalEventEndDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalEventEndDateTime(),
                'TimecodeEventEndDateTime' => new \PHPExiftool\Driver\Tag\MXF\TimecodeEventEndDateTime(),
                'StartTimeRelativeToReference' => new \PHPExiftool\Driver\Tag\MXF\StartTimeRelativeToReference(),
                'StartTimecodeRelativeToReference' => new \PHPExiftool\Driver\Tag\MXF\StartTimecodeRelativeToReference(),
                'MaterialEndTimeOffset' => new \PHPExiftool\Driver\Tag\MXF\MaterialEndTimeOffset(),
                'MaterialEndTimecodeOffset' => new \PHPExiftool\Driver\Tag\MXF\MaterialEndTimecodeOffset(),
                'EventStartTimeOffset' => new \PHPExiftool\Driver\Tag\MXF\EventStartTimeOffset(),
                'EventStartTimecodeOffset' => new \PHPExiftool\Driver\Tag\MXF\EventStartTimecodeOffset(),
                'EventEndTimeOffset' => new \PHPExiftool\Driver\Tag\MXF\EventEndTimeOffset(),
                'EventEndTimecodeOffset' => new \PHPExiftool\Driver\Tag\MXF\EventEndTimecodeOffset(),
                'FrameCountOffset' => new \PHPExiftool\Driver\Tag\MXF\FrameCountOffset(),
                'TimePeriodName' => new \PHPExiftool\Driver\Tag\MXF\TimePeriodName(),
                'LocalCreationDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalCreationDateTime(),
                'TimecodeCreationDateTime' => new \PHPExiftool\Driver\Tag\MXF\TimecodeCreationDateTime(),
                'LocalModifyDate' => new \PHPExiftool\Driver\Tag\MXF\LocalModifyDate(),
                'TimecodeModifyDate' => new \PHPExiftool\Driver\Tag\MXF\TimecodeModifyDate(),
                'FrameCount' => new \PHPExiftool\Driver\Tag\MXF\FrameCount(),
                'MaterialAbsoluteDuration' => new \PHPExiftool\Driver\Tag\MXF\MaterialAbsoluteDuration(),
                'TextlessBlackDuration' => new \PHPExiftool\Driver\Tag\MXF\TextlessBlackDuration(),
                'EventAbsoluteDurationFrameCount' => new \PHPExiftool\Driver\Tag\MXF\EventAbsoluteDurationFrameCount(),
                'EventAbsoluteDuration' => new \PHPExiftool\Driver\Tag\MXF\EventAbsoluteDuration(),
                'BufferDelay' => new \PHPExiftool\Driver\Tag\MXF\BufferDelay(),
                'ProgramIdentifier' => new \PHPExiftool\Driver\Tag\MXF\ProgramIdentifier(),
                'ProgramIdentifierString' => new \PHPExiftool\Driver\Tag\MXF\ProgramIdentifierString(),
                'ShimName' => new \PHPExiftool\Driver\Tag\MXF\ShimName(),
                'SignalStandard' => new \PHPExiftool\Driver\Tag\MXF\SignalStandard(),
                'IntendedAFD' => new \PHPExiftool\Driver\Tag\MXF\IntendedAFD(),
                'SlateTitle' => new \PHPExiftool\Driver\Tag\MXF\SlateTitle(),
                'NOLACode' => new \PHPExiftool\Driver\Tag\MXF\NOLACode(),
                'Rating' => new \PHPExiftool\Driver\Tag\MXF\Rating(),
                'NielsenStreamIdentifier' => new \PHPExiftool\Driver\Tag\MXF\NielsenStreamIdentifier(),
                'IsRecording' => new \PHPExiftool\Driver\Tag\MXF\IsRecording(),
                'IsLiveProduction' => new \PHPExiftool\Driver\Tag\MXF\IsLiveProduction(),
                'IsLiveTransmission' => new \PHPExiftool\Driver\Tag\MXF\IsLiveTransmission(),
                'IsDubbed' => new \PHPExiftool\Driver\Tag\MXF\IsDubbed(),
                'IsVoiceover' => new \PHPExiftool\Driver\Tag\MXF\IsVoiceover(),
                'HasAudioWatermark' => new \PHPExiftool\Driver\Tag\MXF\HasAudioWatermark(),
                'AudioWatermarkKind' => new \PHPExiftool\Driver\Tag\MXF\AudioWatermarkKind(),
                'HasVideoWatermark' => new \PHPExiftool\Driver\Tag\MXF\HasVideoWatermark(),
                'VideoWatermarkKind' => new \PHPExiftool\Driver\Tag\MXF\VideoWatermarkKind(),
                'SubtitlesPresent' => new \PHPExiftool\Driver\Tag\MXF\SubtitlesPresent(),
                'CaptionTitles' => new \PHPExiftool\Driver\Tag\MXF\CaptionTitles(),
                'CaptionsViaTeletext' => new \PHPExiftool\Driver\Tag\MXF\CaptionsViaTeletext(),
                'TextlessMaterial' => new \PHPExiftool\Driver\Tag\MXF\TextlessMaterial(),
                'StorageDeviceKind' => new \PHPExiftool\Driver\Tag\MXF\StorageDeviceKind(),
                'StorageMediaKind' => new \PHPExiftool\Driver\Tag\MXF\StorageMediaKind(),
                'StorageMediaID' => new \PHPExiftool\Driver\Tag\MXF\StorageMediaID(),
                'BroadcastDate' => new \PHPExiftool\Driver\Tag\MXF\BroadcastDate(),
                'BroadcastTime' => new \PHPExiftool\Driver\Tag\MXF\BroadcastTime(),
                'IsRepeat' => new \PHPExiftool\Driver\Tag\MXF\IsRepeat(),
                'FirstTransmissionInfo' => new \PHPExiftool\Driver\Tag\MXF\FirstTransmissionInfo(),
                'TeletextSubtitlesAvailable' => new \PHPExiftool\Driver\Tag\MXF\TeletextSubtitlesAvailable(),
                'SeasonEpisodeNumber' => new \PHPExiftool\Driver\Tag\MXF\SeasonEpisodeNumber(),
                'SeasonEpisodeTitle' => new \PHPExiftool\Driver\Tag\MXF\SeasonEpisodeTitle(),
                'EPGProgramSynopsis' => new \PHPExiftool\Driver\Tag\MXF\EPGProgramSynopsis(),
                'DVBParentalRating' => new \PHPExiftool\Driver\Tag\MXF\DVBParentalRating(),
                'ContentMaturityRating' => new \PHPExiftool\Driver\Tag\MXF\ContentMaturityRating(),
                'ContentMaturityDescription' => new \PHPExiftool\Driver\Tag\MXF\ContentMaturityDescription(),
                'ContentMaturityGraphic' => new \PHPExiftool\Driver\Tag\MXF\ContentMaturityGraphic(),
                'ContractEntity' => new \PHPExiftool\Driver\Tag\MXF\ContractEntity(),
                'ContractTypeLink' => new \PHPExiftool\Driver\Tag\MXF\ContractTypeLink(),
                'ConsumerRightsToCopy' => new \PHPExiftool\Driver\Tag\MXF\ConsumerRightsToCopy(),
                'BroadcasterRightsToCopy' => new \PHPExiftool\Driver\Tag\MXF\BroadcasterRightsToCopy(),
                'DirectorName' => new \PHPExiftool\Driver\Tag\MXF\DirectorName(),
                'ProducerName' => new \PHPExiftool\Driver\Tag\MXF\ProducerName(),
                'FemaleLeadActressName' => new \PHPExiftool\Driver\Tag\MXF\FemaleLeadActressName(),
                'MaleLeadActorName' => new \PHPExiftool\Driver\Tag\MXF\MaleLeadActorName(),
                'PresenterName' => new \PHPExiftool\Driver\Tag\MXF\PresenterName(),
                'MainSponsorName' => new \PHPExiftool\Driver\Tag\MXF\MainSponsorName(),
                'VoiceTalentName' => new \PHPExiftool\Driver\Tag\MXF\VoiceTalentName(),
                'PostboxNumber' => new \PHPExiftool\Driver\Tag\MXF\PostboxNumber(),
                'PostCodeForPostbox' => new \PHPExiftool\Driver\Tag\MXF\PostCodeForPostbox(),
                'ProgramNumber' => new \PHPExiftool\Driver\Tag\MXF\ProgramNumber(),
                'DefinitionObjectID' => new \PHPExiftool\Driver\Tag\MXF\DefinitionObjectID(),
                'IEEEDeviceID' => new \PHPExiftool\Driver\Tag\MXF\IEEEDeviceID(),
                'ProjectNumber' => new \PHPExiftool\Driver\Tag\MXF\ProjectNumber(),
                'EdgeCodeHeader' => new \PHPExiftool\Driver\Tag\MXF\EdgeCodeHeader(),
                'ChannelHandle' => new \PHPExiftool\Driver\Tag\MXF\ChannelHandle(),
                'PhysicalMediaLocation' => new \PHPExiftool\Driver\Tag\MXF\PhysicalMediaLocation(),
                'MediaLocation' => new \PHPExiftool\Driver\Tag\MXF\MediaLocation(),
                'TrackNumber' => new \PHPExiftool\Driver\Tag\MXF\TrackNumber(),
                'EdgeCodeStart' => new \PHPExiftool\Driver\Tag\MXF\EdgeCodeStart(),
                'VersionTitle' => new \PHPExiftool\Driver\Tag\MXF\VersionTitle(),
                'TrackID' => new \PHPExiftool\Driver\Tag\MXF\TrackID(),
                'TrackName' => new \PHPExiftool\Driver\Tag\MXF\TrackName(),
                'DefinitionObjectName' => new \PHPExiftool\Driver\Tag\MXF\DefinitionObjectName(),
                'ContentPackageMetadataLink' => new \PHPExiftool\Driver\Tag\MXF\ContentPackageMetadataLink(),
                'DefinedName' => new \PHPExiftool\Driver\Tag\MXF\DefinedName(),
                'DeviceManufacturerName' => new \PHPExiftool\Driver\Tag\MXF\DeviceManufacturerName(),
                'ManufacturerID' => new \PHPExiftool\Driver\Tag\MXF\ManufacturerID(),
                'IEEEManufacturerID' => new \PHPExiftool\Driver\Tag\MXF\IEEEManufacturerID(),
                'AAFManufacturerID' => new \PHPExiftool\Driver\Tag\MXF\AAFManufacturerID(),
                'SupplyingDepartmentName' => new \PHPExiftool\Driver\Tag\MXF\SupplyingDepartmentName(),
                'AudienceShare' => new \PHPExiftool\Driver\Tag\MXF\AudienceShare(),
                'AudienceAppreciation' => new \PHPExiftool\Driver\Tag\MXF\AudienceAppreciation(),
                'Salutation' => new \PHPExiftool\Driver\Tag\MXF\Salutation(),
                'HonorsAndQualifications' => new \PHPExiftool\Driver\Tag\MXF\HonorsAndQualifications(),
                'ObjectModelVersion' => new \PHPExiftool\Driver\Tag\MXF\ObjectModelVersion(),
                'SDKVersion' => new \PHPExiftool\Driver\Tag\MXF\SDKVersion(),
                'IsOptional' => new \PHPExiftool\Driver\Tag\MXF\IsOptional(),
                'IsSearchable' => new \PHPExiftool\Driver\Tag\MXF\IsSearchable(),
                'UseDefaultValue' => new \PHPExiftool\Driver\Tag\MXF\UseDefaultValue(),
                'DefaultDataValue' => new \PHPExiftool\Driver\Tag\MXF\DefaultDataValue(),
                'Size' => new \PHPExiftool\Driver\Tag\MXF\Size(),
                'IsSigned' => new \PHPExiftool\Driver\Tag\MXF\IsSigned(),
                'ElementCount' => new \PHPExiftool\Driver\Tag\MXF\ElementCount(),
                'ElementNameList' => new \PHPExiftool\Driver\Tag\MXF\ElementNameList(),
                'TypeDefinitionElementValueList' => new \PHPExiftool\Driver\Tag\MXF\TypeDefinitionElementValueList(),
                'MemberNameList' => new \PHPExiftool\Driver\Tag\MXF\MemberNameList(),
                'ExtendibleElementNameList' => new \PHPExiftool\Driver\Tag\MXF\ExtendibleElementNameList(),
                'TypeDefinitionExtendibleElementValues' => new \PHPExiftool\Driver\Tag\MXF\TypeDefinitionExtendibleElementValues(),
                'TargetSet' => new \PHPExiftool\Driver\Tag\MXF\TargetSet(),
                'FillerData' => new \PHPExiftool\Driver\Tag\MXF\FillerData(),
                'KLVDataValue' => new \PHPExiftool\Driver\Tag\MXF\KLVDataValue(),
                'PackageKLVData' => new \PHPExiftool\Driver\Tag\MXF\PackageKLVData(),
                'ComponentKLVData' => new \PHPExiftool\Driver\Tag\MXF\ComponentKLVData(),
                'AssignedCategoryName' => new \PHPExiftool\Driver\Tag\MXF\AssignedCategoryName(),
                'AssignedCategoryValue' => new \PHPExiftool\Driver\Tag\MXF\AssignedCategoryValue(),
                'ShotList' => new \PHPExiftool\Driver\Tag\MXF\ShotList(),
                'PackageUserComments' => new \PHPExiftool\Driver\Tag\MXF\PackageUserComments(),
                'Cue-InWords' => new \PHPExiftool\Driver\Tag\MXF\CueInWords(),
                'Cue-OutWords' => new \PHPExiftool\Driver\Tag\MXF\CueOutWords(),
                'ObjectKind' => new \PHPExiftool\Driver\Tag\MXF\ObjectKind(),
                'ObjectDescription' => new \PHPExiftool\Driver\Tag\MXF\ObjectDescription(),
                'ObjectName' => new \PHPExiftool\Driver\Tag\MXF\ObjectName(),
                'MetadataItemName' => new \PHPExiftool\Driver\Tag\MXF\MetadataItemName(),
                'ShotCommentKind' => new \PHPExiftool\Driver\Tag\MXF\ShotCommentKind(),
                'ShotComment' => new \PHPExiftool\Driver\Tag\MXF\ShotComment(),
                'ComputedObjectKind' => new \PHPExiftool\Driver\Tag\MXF\ComputedObjectKind(),
                'VersionNumberString' => new \PHPExiftool\Driver\Tag\MXF\VersionNumberString(),
                'VersionNumber' => new \PHPExiftool\Driver\Tag\MXF\VersionNumber(),
                'WAVESummary' => new \PHPExiftool\Driver\Tag\MXF\WAVESummary(),
                'AIFCSummary' => new \PHPExiftool\Driver\Tag\MXF\AIFCSummary(),
                'TIFFSummary' => new \PHPExiftool\Driver\Tag\MXF\TIFFSummary(),
                'ViewportAspectRatio' => new \PHPExiftool\Driver\Tag\MXF\ViewportAspectRatio(),
                'PresentationGammaEquation' => new \PHPExiftool\Driver\Tag\MXF\PresentationGammaEquation(),
                'FieldDominance' => new \PHPExiftool\Driver\Tag\MXF\FieldDominance(),
                'VideoLineMap' => new \PHPExiftool\Driver\Tag\MXF\VideoLineMap(),
                'VerticalSub-sampling' => new \PHPExiftool\Driver\Tag\MXF\VerticalSubSampling(),
                'ColorRangeLevels' => new \PHPExiftool\Driver\Tag\MXF\ColorRangeLevels(),
                'PixelLayout' => new \PHPExiftool\Driver\Tag\MXF\PixelLayout(),
                'AlphaSampleDepth' => new \PHPExiftool\Driver\Tag\MXF\AlphaSampleDepth(),
                'Palette' => new \PHPExiftool\Driver\Tag\MXF\Palette(),
                'PaletteLayout' => new \PHPExiftool\Driver\Tag\MXF\PaletteLayout(),
                'ComponentDepth' => new \PHPExiftool\Driver\Tag\MXF\ComponentDepth(),
                'VideoCodingSchemeID' => new \PHPExiftool\Driver\Tag\MXF\VideoCodingSchemeID(),
                'RoundedCaptureFilmFrameRate' => new \PHPExiftool\Driver\Tag\MXF\RoundedCaptureFilmFrameRate(),
                'AudioAverageBitrate' => new \PHPExiftool\Driver\Tag\MXF\AudioAverageBitrate(),
                'AudioFixedBitrateFlag' => new \PHPExiftool\Driver\Tag\MXF\AudioFixedBitrateFlag(),
                'CodingLawKind' => new \PHPExiftool\Driver\Tag\MXF\CodingLawKind(),
                'AudioCodingSchemeID' => new \PHPExiftool\Driver\Tag\MXF\AudioCodingSchemeID(),
                'LayerNumber' => new \PHPExiftool\Driver\Tag\MXF\LayerNumber(),
                'RoundedTimecodeTimebase' => new \PHPExiftool\Driver\Tag\MXF\RoundedTimecodeTimebase(),
                'ComponentDataDefinition' => new \PHPExiftool\Driver\Tag\MXF\ComponentDataDefinition(),
                'StreamData' => new \PHPExiftool\Driver\Tag\MXF\StreamData(),
                'TimecodeStreamData' => new \PHPExiftool\Driver\Tag\MXF\TimecodeStreamData(),
                'RecordedFormat' => new \PHPExiftool\Driver\Tag\MXF\RecordedFormat(),
                'TapeShellKind' => new \PHPExiftool\Driver\Tag\MXF\TapeShellKind(),
                'TapeFormulation' => new \PHPExiftool\Driver\Tag\MXF\TapeFormulation(),
                'TapeCapacity' => new \PHPExiftool\Driver\Tag\MXF\TapeCapacity(),
                'TapeManufacturer' => new \PHPExiftool\Driver\Tag\MXF\TapeManufacturer(),
                'TapeStock' => new \PHPExiftool\Driver\Tag\MXF\TapeStock(),
                'TapeBatchNumber' => new \PHPExiftool\Driver\Tag\MXF\TapeBatchNumber(),
                'PerforationsPerFrame' => new \PHPExiftool\Driver\Tag\MXF\PerforationsPerFrame(),
                'FilmBatchNumber' => new \PHPExiftool\Driver\Tag\MXF\FilmBatchNumber(),
                'FilmGauge' => new \PHPExiftool\Driver\Tag\MXF\FilmGauge(),
                'EdgeCodeFilmGauge' => new \PHPExiftool\Driver\Tag\MXF\EdgeCodeFilmGauge(),
                'ExposedAspectRatio' => new \PHPExiftool\Driver\Tag\MXF\ExposedAspectRatio(),
                'ImageAlignmentOffset' => new \PHPExiftool\Driver\Tag\MXF\ImageAlignmentOffset(),
                'ImageStartOffset' => new \PHPExiftool\Driver\Tag\MXF\ImageStartOffset(),
                'ImageEndOffset' => new \PHPExiftool\Driver\Tag\MXF\ImageEndOffset(),
                'PaddingBits' => new \PHPExiftool\Driver\Tag\MXF\PaddingBits(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\MXF\FocalLength(),
                'SensorSize' => new \PHPExiftool\Driver\Tag\MXF\SensorSize(),
                'FNumber' => new \PHPExiftool\Driver\Tag\MXF\FNumber(),
                'SensorTypeCode' => new \PHPExiftool\Driver\Tag\MXF\SensorTypeCode(),
                'FieldOfViewHorizontal' => new \PHPExiftool\Driver\Tag\MXF\FieldOfViewHorizontal(),
                'AnamorphicLensCharacteristic' => new \PHPExiftool\Driver\Tag\MXF\AnamorphicLensCharacteristic(),
                'UniformDataFlag' => new \PHPExiftool\Driver\Tag\MXF\UniformDataFlag(),
                'JPEGTableID' => new \PHPExiftool\Driver\Tag\MXF\JPEGTableID(),
                'AlphaTransparency' => new \PHPExiftool\Driver\Tag\MXF\AlphaTransparency(),
                'GenerationID' => new \PHPExiftool\Driver\Tag\MXF\GenerationID(),
                'ApplicationSupplierName' => new \PHPExiftool\Driver\Tag\MXF\ApplicationSupplierName(),
                'ApplicationName' => new \PHPExiftool\Driver\Tag\MXF\ApplicationName(),
                'ApplicationVersionNumber' => new \PHPExiftool\Driver\Tag\MXF\ApplicationVersionNumber(),
                'ApplicationVersionString' => new \PHPExiftool\Driver\Tag\MXF\ApplicationVersionString(),
                'ApplicationPlatform' => new \PHPExiftool\Driver\Tag\MXF\ApplicationPlatform(),
                'ApplicationProductID' => new \PHPExiftool\Driver\Tag\MXF\ApplicationProductID(),
                'LinkedGenerationID' => new \PHPExiftool\Driver\Tag\MXF\LinkedGenerationID(),
                'ContainerVersion' => new \PHPExiftool\Driver\Tag\MXF\ContainerVersion(),
                'ToolkitVersion' => new \PHPExiftool\Driver\Tag\MXF\ToolkitVersion(),
                'Plug-InCategoryID' => new \PHPExiftool\Driver\Tag\MXF\PlugInCategoryID(),
                'Plug-InPlatformID' => new \PHPExiftool\Driver\Tag\MXF\PlugInPlatformID(),
                'MinimumSupportedPlatformVersion' => new \PHPExiftool\Driver\Tag\MXF\MinimumSupportedPlatformVersion(),
                'MaximumSupportedPlatformVersion' => new \PHPExiftool\Driver\Tag\MXF\MaximumSupportedPlatformVersion(),
                'Plug-InEngineID' => new \PHPExiftool\Driver\Tag\MXF\PlugInEngineID(),
                'MinimumSupportedEngineVersion' => new \PHPExiftool\Driver\Tag\MXF\MinimumSupportedEngineVersion(),
                'MaximumSupportedEngineVersion' => new \PHPExiftool\Driver\Tag\MXF\MaximumSupportedEngineVersion(),
                'Plug-InAPIID' => new \PHPExiftool\Driver\Tag\MXF\PlugInAPIID(),
                'MinimumAPIVersion' => new \PHPExiftool\Driver\Tag\MXF\MinimumAPIVersion(),
                'MaximumAPIVersion' => new \PHPExiftool\Driver\Tag\MXF\MaximumAPIVersion(),
                'Software-OnlySupportFlag' => new \PHPExiftool\Driver\Tag\MXF\SoftwareOnlySupportFlag(),
                'HardwareAcceleratorFlag' => new \PHPExiftool\Driver\Tag\MXF\HardwareAcceleratorFlag(),
                'Plug-InLocatorSet' => new \PHPExiftool\Driver\Tag\MXF\PlugInLocatorSet(),
                'AuthenticationFlag' => new \PHPExiftool\Driver\Tag\MXF\AuthenticationFlag(),
                'AssociatedMetadataDefinition' => new \PHPExiftool\Driver\Tag\MXF\AssociatedMetadataDefinition(),
                'EventTrackEditRate' => new \PHPExiftool\Driver\Tag\MXF\EventTrackEditRate(),
                'DefaultFadeEditRate' => new \PHPExiftool\Driver\Tag\MXF\DefaultFadeEditRate(),
                'EditingEventComment' => new \PHPExiftool\Driver\Tag\MXF\EditingEventComment(),
                'EditRate' => new \PHPExiftool\Driver\Tag\MXF\EditRate(),
                'OperationDefinitionID' => new \PHPExiftool\Driver\Tag\MXF\OperationDefinitionID(),
                'Value' => new \PHPExiftool\Driver\Tag\MXF\Value(),
                'EditHint' => new \PHPExiftool\Driver\Tag\MXF\EditHint(),
                'OperationDataDefinition' => new \PHPExiftool\Driver\Tag\MXF\OperationDataDefinition(),
                'OperationCategory' => new \PHPExiftool\Driver\Tag\MXF\OperationCategory(),
                'DisplayUnits' => new \PHPExiftool\Driver\Tag\MXF\DisplayUnits(),
                'BypassOverride' => new \PHPExiftool\Driver\Tag\MXF\BypassOverride(),
                'TimepointValue' => new \PHPExiftool\Driver\Tag\MXF\TimepointValue(),
                'BeginAnchor' => new \PHPExiftool\Driver\Tag\MXF\BeginAnchor(),
                'EndAnchor' => new \PHPExiftool\Driver\Tag\MXF\EndAnchor(),
                'FilmToVideoTransferDirection' => new \PHPExiftool\Driver\Tag\MXF\FilmToVideoTransferDirection(),
                'FilmToVideoTransferKind' => new \PHPExiftool\Driver\Tag\MXF\FilmToVideoTransferKind(),
                'FilmToVideoTransferPhase' => new \PHPExiftool\Driver\Tag\MXF\FilmToVideoTransferPhase(),
                'TeletextSubtitlesFlag' => new \PHPExiftool\Driver\Tag\MXF\TeletextSubtitlesFlag(),
                'SubtitleDatafileFlag' => new \PHPExiftool\Driver\Tag\MXF\SubtitleDatafileFlag(),
                'ClosedCaptionSubtitlesFlag' => new \PHPExiftool\Driver\Tag\MXF\ClosedCaptionSubtitlesFlag(),
                'SampleIndex' => new \PHPExiftool\Driver\Tag\MXF\SampleIndex(),
                'SourcePackageID' => new \PHPExiftool\Driver\Tag\MXF\SourcePackageID(),
                'SourceTrackID' => new \PHPExiftool\Driver\Tag\MXF\SourceTrackID(),
                'RelativeScope' => new \PHPExiftool\Driver\Tag\MXF\RelativeScope(),
                'RelativeTrack' => new \PHPExiftool\Driver\Tag\MXF\RelativeTrack(),
                'ObjectClass' => new \PHPExiftool\Driver\Tag\MXF\ObjectClass(),
                'EssenceContainerFormat' => new \PHPExiftool\Driver\Tag\MXF\EssenceContainerFormat(),
                'CodecDefinition' => new \PHPExiftool\Driver\Tag\MXF\CodecDefinition(),
                'ParameterDefinition' => new \PHPExiftool\Driver\Tag\MXF\ParameterDefinition(),
                'Interpolation' => new \PHPExiftool\Driver\Tag\MXF\Interpolation(),
                'ParameterDataType' => new \PHPExiftool\Driver\Tag\MXF\ParameterDataType(),
                'CodecEssenceDescriptor' => new \PHPExiftool\Driver\Tag\MXF\CodecEssenceDescriptor(),
                'ContentStorage' => new \PHPExiftool\Driver\Tag\MXF\ContentStorage(),
                'Dictionary' => new \PHPExiftool\Driver\Tag\MXF\Dictionary(),
                'EssenceDescription' => new \PHPExiftool\Driver\Tag\MXF\EssenceDescription(),
                'Sequence' => new \PHPExiftool\Driver\Tag\MXF\Sequence(),
                'TransitionEffect' => new \PHPExiftool\Driver\Tag\MXF\TransitionEffect(),
                'EffectRendering' => new \PHPExiftool\Driver\Tag\MXF\EffectRendering(),
                'InputSegment' => new \PHPExiftool\Driver\Tag\MXF\InputSegment(),
                'StillFrame' => new \PHPExiftool\Driver\Tag\MXF\StillFrame(),
                'Selected' => new \PHPExiftool\Driver\Tag\MXF\Selected(),
                'Annotation' => new \PHPExiftool\Driver\Tag\MXF\Annotation(),
                'ManufacturerInformationObject' => new \PHPExiftool\Driver\Tag\MXF\ManufacturerInformationObject(),
                'CodecEssenceKinds' => new \PHPExiftool\Driver\Tag\MXF\CodecEssenceKinds(),
                'OperationParameters' => new \PHPExiftool\Driver\Tag\MXF\OperationParameters(),
                'DegradedEffects' => new \PHPExiftool\Driver\Tag\MXF\DegradedEffects(),
                'Packages' => new \PHPExiftool\Driver\Tag\MXF\Packages(),
                'EssenceData' => new \PHPExiftool\Driver\Tag\MXF\EssenceData(),
                'OperationDefinitions' => new \PHPExiftool\Driver\Tag\MXF\OperationDefinitions(),
                'ParameterDefinitions' => new \PHPExiftool\Driver\Tag\MXF\ParameterDefinitions(),
                'DataDefinitions' => new \PHPExiftool\Driver\Tag\MXF\DataDefinitions(),
                'Plug-InDefinitions' => new \PHPExiftool\Driver\Tag\MXF\PlugInDefinitions(),
                'CodecDefinitions' => new \PHPExiftool\Driver\Tag\MXF\CodecDefinitions(),
                'ContainerDefinitions' => new \PHPExiftool\Driver\Tag\MXF\ContainerDefinitions(),
                'InterpolationDefinitions' => new \PHPExiftool\Driver\Tag\MXF\InterpolationDefinitions(),
                'AvailableRepresentations' => new \PHPExiftool\Driver\Tag\MXF\AvailableRepresentations(),
                'InputSegments' => new \PHPExiftool\Driver\Tag\MXF\InputSegments(),
                'EssenceLocators' => new \PHPExiftool\Driver\Tag\MXF\EssenceLocators(),
                'IdentificationList' => new \PHPExiftool\Driver\Tag\MXF\IdentificationList(),
                'Tracks' => new \PHPExiftool\Driver\Tag\MXF\Tracks(),
                'ControlPointList' => new \PHPExiftool\Driver\Tag\MXF\ControlPointList(),
                'PackageTracks' => new \PHPExiftool\Driver\Tag\MXF\PackageTracks(),
                'Alternates' => new \PHPExiftool\Driver\Tag\MXF\Alternates(),
                'ComponentsInSequence' => new \PHPExiftool\Driver\Tag\MXF\ComponentsInSequence(),
                'Parameters' => new \PHPExiftool\Driver\Tag\MXF\Parameters(),
                'LinkedPackageID' => new \PHPExiftool\Driver\Tag\MXF\LinkedPackageID(),
                'ParentClass' => new \PHPExiftool\Driver\Tag\MXF\ParentClass(),
                'Properties' => new \PHPExiftool\Driver\Tag\MXF\Properties(),
                'IsConcrete' => new \PHPExiftool\Driver\Tag\MXF\IsConcrete(),
                'PropertyType' => new \PHPExiftool\Driver\Tag\MXF\PropertyType(),
                'LocalID' => new \PHPExiftool\Driver\Tag\MXF\LocalID(),
                'IsUniqueIdentifier' => new \PHPExiftool\Driver\Tag\MXF\IsUniqueIdentifier(),
                'ClassDefinitions' => new \PHPExiftool\Driver\Tag\MXF\ClassDefinitions(),
                'TypeDefinitions' => new \PHPExiftool\Driver\Tag\MXF\TypeDefinitions(),
                'TargetClassOfStrongReference' => new \PHPExiftool\Driver\Tag\MXF\TargetClassOfStrongReference(),
                'TargetClassOfWeakReference' => new \PHPExiftool\Driver\Tag\MXF\TargetClassOfWeakReference(),
                'EnumerationUnderlyingIntegerType' => new \PHPExiftool\Driver\Tag\MXF\EnumerationUnderlyingIntegerType(),
                'FixedArrayElementType' => new \PHPExiftool\Driver\Tag\MXF\FixedArrayElementType(),
                'VariableArrayElementType' => new \PHPExiftool\Driver\Tag\MXF\VariableArrayElementType(),
                'SetElementType' => new \PHPExiftool\Driver\Tag\MXF\SetElementType(),
                'StringElementType' => new \PHPExiftool\Driver\Tag\MXF\StringElementType(),
                'StreamElementType' => new \PHPExiftool\Driver\Tag\MXF\StreamElementType(),
                'MemberTypes' => new \PHPExiftool\Driver\Tag\MXF\MemberTypes(),
                'RenamedType' => new \PHPExiftool\Driver\Tag\MXF\RenamedType(),
                'DictionaryIdentifier' => new \PHPExiftool\Driver\Tag\MXF\DictionaryIdentifier(),
                'DictionaryDescription' => new \PHPExiftool\Driver\Tag\MXF\DictionaryDescription(),
                'BlockContinuityCount' => new \PHPExiftool\Driver\Tag\MXF\BlockContinuityCount(),
                'StreamPositionIndicator' => new \PHPExiftool\Driver\Tag\MXF\StreamPositionIndicator(),
                'Origin' => new \PHPExiftool\Driver\Tag\MXF\Origin(),
                'StartTimecode' => new \PHPExiftool\Driver\Tag\MXF\StartTimecode(),
                'CutPoint' => new \PHPExiftool\Driver\Tag\MXF\CutPoint(),
                'EventStart' => new \PHPExiftool\Driver\Tag\MXF\EventStart(),
                'ControlPointTime' => new \PHPExiftool\Driver\Tag\MXF\ControlPointTime(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\MXF\CreateDate(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\MXF\ModifyDate(),
                'ContainerLastModifyDate' => new \PHPExiftool\Driver\Tag\MXF\ContainerLastModifyDate(),
                'PackageLastModifyDate' => new \PHPExiftool\Driver\Tag\MXF\PackageLastModifyDate(),
                'Duration' => new \PHPExiftool\Driver\Tag\MXF\Duration(),
                'DefaultFadeDuration' => new \PHPExiftool\Driver\Tag\MXF\DefaultFadeDuration(),
                'Fade-InDuration' => new \PHPExiftool\Driver\Tag\MXF\FadeInDuration(),
                'Fade-OutDuration' => new \PHPExiftool\Driver\Tag\MXF\FadeOutDuration(),
                'TapeFormat' => new \PHPExiftool\Driver\Tag\MXF\TapeFormat(),
                'GlobalNumber' => new \PHPExiftool\Driver\Tag\MXF\GlobalNumber(),
                'DeviceIDKind' => new \PHPExiftool\Driver\Tag\MXF\DeviceIDKind(),
                'DeviceKind' => new \PHPExiftool\Driver\Tag\MXF\DeviceKind(),
                'DeviceKindCode' => new \PHPExiftool\Driver\Tag\MXF\DeviceKindCode(),
                'PlatformDesignation' => new \PHPExiftool\Driver\Tag\MXF\PlatformDesignation(),
                'PlatformModel' => new \PHPExiftool\Driver\Tag\MXF\PlatformModel(),
                'PlatformSerialNumber' => new \PHPExiftool\Driver\Tag\MXF\PlatformSerialNumber(),
                'LocalTargetID' => new \PHPExiftool\Driver\Tag\MXF\LocalTargetID(),
                'MagneticDiskNumber' => new \PHPExiftool\Driver\Tag\MXF\MagneticDiskNumber(),
                'OpticalDiscNumber' => new \PHPExiftool\Driver\Tag\MXF\OpticalDiscNumber(),
                'StreamID' => new \PHPExiftool\Driver\Tag\MXF\StreamID(),
                'TransportStreamID' => new \PHPExiftool\Driver\Tag\MXF\TransportStreamID(),
                'OrganizationalProgramNumber' => new \PHPExiftool\Driver\Tag\MXF\OrganizationalProgramNumber(),
                'ItemDesignatorID' => new \PHPExiftool\Driver\Tag\MXF\ItemDesignatorID(),
                'MissionID' => new \PHPExiftool\Driver\Tag\MXF\MissionID(),
                'RecordingLabelName' => new \PHPExiftool\Driver\Tag\MXF\RecordingLabelName(),
                'CollectionName' => new \PHPExiftool\Driver\Tag\MXF\CollectionName(),
                'OriginCode' => new \PHPExiftool\Driver\Tag\MXF\OriginCode(),
                'MainCatalogNumber' => new \PHPExiftool\Driver\Tag\MXF\MainCatalogNumber(),
                'CatalogPrefixNumber' => new \PHPExiftool\Driver\Tag\MXF\CatalogPrefixNumber(),
                'SideNumber' => new \PHPExiftool\Driver\Tag\MXF\SideNumber(),
                'RecordedTrackNumber' => new \PHPExiftool\Driver\Tag\MXF\RecordedTrackNumber(),
                'SeriesinaSeriesGroupCount' => new \PHPExiftool\Driver\Tag\MXF\SeriesinaSeriesGroupCount(),
                'ProgrammingGroupKind' => new \PHPExiftool\Driver\Tag\MXF\ProgrammingGroupKind(),
                'PurchasingOrganizationName' => new \PHPExiftool\Driver\Tag\MXF\PurchasingOrganizationName(),
                'SalesContractNumber' => new \PHPExiftool\Driver\Tag\MXF\SalesContractNumber(),
                'PurchasingDepartment' => new \PHPExiftool\Driver\Tag\MXF\PurchasingDepartment(),
                'ContractType' => new \PHPExiftool\Driver\Tag\MXF\ContractType(),
                'ContractTypeCode' => new \PHPExiftool\Driver\Tag\MXF\ContractTypeCode(),
                'ContractClauseDescription' => new \PHPExiftool\Driver\Tag\MXF\ContractClauseDescription(),
                'ContractLineCode' => new \PHPExiftool\Driver\Tag\MXF\ContractLineCode(),
                'ContractLineName' => new \PHPExiftool\Driver\Tag\MXF\ContractLineName(),
                'ContractTermsOfBusiness' => new \PHPExiftool\Driver\Tag\MXF\ContractTermsOfBusiness(),
                'ContractInstallmentPercentage' => new \PHPExiftool\Driver\Tag\MXF\ContractInstallmentPercentage(),
                'Jurisdiction' => new \PHPExiftool\Driver\Tag\MXF\Jurisdiction(),
                'RightsConditionDescription' => new \PHPExiftool\Driver\Tag\MXF\RightsConditionDescription(),
                'CurrencyName' => new \PHPExiftool\Driver\Tag\MXF\CurrencyName(),
                'TotalPayment' => new \PHPExiftool\Driver\Tag\MXF\TotalPayment(),
                'PayeeAccountName' => new \PHPExiftool\Driver\Tag\MXF\PayeeAccountName(),
                'PayeeAccountNumber' => new \PHPExiftool\Driver\Tag\MXF\PayeeAccountNumber(),
                'PayeeAccountSortCode' => new \PHPExiftool\Driver\Tag\MXF\PayeeAccountSortCode(),
                'TotalIncome' => new \PHPExiftool\Driver\Tag\MXF\TotalIncome(),
                'PayerAccountName' => new \PHPExiftool\Driver\Tag\MXF\PayerAccountName(),
                'PayerAccountNumber' => new \PHPExiftool\Driver\Tag\MXF\PayerAccountNumber(),
                'PayerAccountSortCode' => new \PHPExiftool\Driver\Tag\MXF\PayerAccountSortCode(),
                'SecurityClassification' => new \PHPExiftool\Driver\Tag\MXF\SecurityClassification(),
                'SecurityClassificationCaveats' => new \PHPExiftool\Driver\Tag\MXF\SecurityClassificationCaveats(),
                'ClassifiedBy' => new \PHPExiftool\Driver\Tag\MXF\ClassifiedBy(),
                'ClassificationReason' => new \PHPExiftool\Driver\Tag\MXF\ClassificationReason(),
                'DeclassificationDate' => new \PHPExiftool\Driver\Tag\MXF\DeclassificationDate(),
                'DerivedFrom' => new \PHPExiftool\Driver\Tag\MXF\DerivedFrom(),
                'ClassificationComment' => new \PHPExiftool\Driver\Tag\MXF\ClassificationComment(),
                'ClassificationAndMarkingSystem' => new \PHPExiftool\Driver\Tag\MXF\ClassificationAndMarkingSystem(),
                'BroadcastServiceName' => new \PHPExiftool\Driver\Tag\MXF\BroadcastServiceName(),
                'BroadcastMediumCode' => new \PHPExiftool\Driver\Tag\MXF\BroadcastMediumCode(),
                'JobFunctionCode' => new \PHPExiftool\Driver\Tag\MXF\JobFunctionCode(),
                'JobTitle' => new \PHPExiftool\Driver\Tag\MXF\JobTitle(),
                'PersonDescription' => new \PHPExiftool\Driver\Tag\MXF\PersonDescription(),
                'RegionCode' => new \PHPExiftool\Driver\Tag\MXF\RegionCode(),
                'RegionName' => new \PHPExiftool\Driver\Tag\MXF\RegionName(),
                'LanguageName' => new \PHPExiftool\Driver\Tag\MXF\LanguageName(),
                'TerminatingFillerData' => new \PHPExiftool\Driver\Tag\MXF\TerminatingFillerData(),
                'TimingBiasCorrection' => new \PHPExiftool\Driver\Tag\MXF\TimingBiasCorrection(),
                'TimingBiasCorrectionDescription' => new \PHPExiftool\Driver\Tag\MXF\TimingBiasCorrectionDescription(),
                'ProgramMaterialClassificationCode' => new \PHPExiftool\Driver\Tag\MXF\ProgramMaterialClassificationCode(),
                'SubjectName' => new \PHPExiftool\Driver\Tag\MXF\SubjectName(),
                'KeyFrameSampleCount' => new \PHPExiftool\Driver\Tag\MXF\KeyFrameSampleCount(),
                'IntentDescriptor' => new \PHPExiftool\Driver\Tag\MXF\IntentDescriptor(),
                'TextualDescriptionKind' => new \PHPExiftool\Driver\Tag\MXF\TextualDescriptionKind(),
                'FestivalName' => new \PHPExiftool\Driver\Tag\MXF\FestivalName(),
                'ObjectDescriptionCode' => new \PHPExiftool\Driver\Tag\MXF\ObjectDescriptionCode(),
                'DescriptionKind' => new \PHPExiftool\Driver\Tag\MXF\DescriptionKind(),
                'DescriptiveComment' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveComment(),
                'ContextDescription' => new \PHPExiftool\Driver\Tag\MXF\ContextDescription(),
                'ObjectIdentificationConfidence' => new \PHPExiftool\Driver\Tag\MXF\ObjectIdentificationConfidence(),
                'ObjectHorizontalAverageDimension' => new \PHPExiftool\Driver\Tag\MXF\ObjectHorizontalAverageDimension(),
                'ObjectVerticalAverageDimension' => new \PHPExiftool\Driver\Tag\MXF\ObjectVerticalAverageDimension(),
                'ObjectAreaDimension' => new \PHPExiftool\Driver\Tag\MXF\ObjectAreaDimension(),
                'HorizontalActionSafePercentage' => new \PHPExiftool\Driver\Tag\MXF\HorizontalActionSafePercentage(),
                'VerticalActionSafePercentage' => new \PHPExiftool\Driver\Tag\MXF\VerticalActionSafePercentage(),
                'HorizontalGraphicsSafePercentage' => new \PHPExiftool\Driver\Tag\MXF\HorizontalGraphicsSafePercentage(),
                'VerticalGraphicsSafePercentage' => new \PHPExiftool\Driver\Tag\MXF\VerticalGraphicsSafePercentage(),
                'PerceivedDisplayFormatName' => new \PHPExiftool\Driver\Tag\MXF\PerceivedDisplayFormatName(),
                'PerceivedDisplayFormatCode' => new \PHPExiftool\Driver\Tag\MXF\PerceivedDisplayFormatCode(),
                'VideoColorKind' => new \PHPExiftool\Driver\Tag\MXF\VideoColorKind(),
                'PictureDisplayRate' => new \PHPExiftool\Driver\Tag\MXF\PictureDisplayRate(),
                'VideoAverageBitrate' => new \PHPExiftool\Driver\Tag\MXF\VideoAverageBitrate(),
                'VideoFixedBitrate' => new \PHPExiftool\Driver\Tag\MXF\VideoFixedBitrate(),
                'DigitalVideoFileFormat' => new \PHPExiftool\Driver\Tag\MXF\DigitalVideoFileFormat(),
                'CodingLawName' => new \PHPExiftool\Driver\Tag\MXF\CodingLawName(),
                'AudioCodingSchemeCode' => new \PHPExiftool\Driver\Tag\MXF\AudioCodingSchemeCode(),
                'AudioCodingSchemeName' => new \PHPExiftool\Driver\Tag\MXF\AudioCodingSchemeName(),
                'DigitalEncodingBitrate' => new \PHPExiftool\Driver\Tag\MXF\DigitalEncodingBitrate(),
                'DataEssenceCodingID' => new \PHPExiftool\Driver\Tag\MXF\DataEssenceCodingID(),
                'StorageKind' => new \PHPExiftool\Driver\Tag\MXF\StorageKind(),
                'StorageKindCode' => new \PHPExiftool\Driver\Tag\MXF\StorageKindCode(),
                'TapePartitionCapacity' => new \PHPExiftool\Driver\Tag\MXF\TapePartitionCapacity(),
                'DiscPartitionCapacity' => new \PHPExiftool\Driver\Tag\MXF\DiscPartitionCapacity(),
                'FieldOfViewVertical' => new \PHPExiftool\Driver\Tag\MXF\FieldOfViewVertical(),
                'SystemNameOrNumber' => new \PHPExiftool\Driver\Tag\MXF\SystemNameOrNumber(),
                'LogoFlag' => new \PHPExiftool\Driver\Tag\MXF\LogoFlag(),
                'GraphicKind' => new \PHPExiftool\Driver\Tag\MXF\GraphicKind(),
                'GraphicUsageKind' => new \PHPExiftool\Driver\Tag\MXF\GraphicUsageKind(),
                'SignatureTuneFlag' => new \PHPExiftool\Driver\Tag\MXF\SignatureTuneFlag(),
                'BackgroundMusicFlag' => new \PHPExiftool\Driver\Tag\MXF\BackgroundMusicFlag(),
                'ProductionScriptReference' => new \PHPExiftool\Driver\Tag\MXF\ProductionScriptReference(),
                'TranscriptReference' => new \PHPExiftool\Driver\Tag\MXF\TranscriptReference(),
                'HorizontalDatum' => new \PHPExiftool\Driver\Tag\MXF\HorizontalDatum(),
                'VerticalDatum' => new \PHPExiftool\Driver\Tag\MXF\VerticalDatum(),
                'CornerLatitudePoint1' => new \PHPExiftool\Driver\Tag\MXF\CornerLatitudePoint1(),
                'CornerLatitudePoint2' => new \PHPExiftool\Driver\Tag\MXF\CornerLatitudePoint2(),
                'CornerLatitudePoint3' => new \PHPExiftool\Driver\Tag\MXF\CornerLatitudePoint3(),
                'CornerLatitudePoint4' => new \PHPExiftool\Driver\Tag\MXF\CornerLatitudePoint4(),
                'CornerLongitudePoint1' => new \PHPExiftool\Driver\Tag\MXF\CornerLongitudePoint1(),
                'CornerLongitudePoint2' => new \PHPExiftool\Driver\Tag\MXF\CornerLongitudePoint2(),
                'CornerLongitudePoint3' => new \PHPExiftool\Driver\Tag\MXF\CornerLongitudePoint3(),
                'CornerLongitudePoint4' => new \PHPExiftool\Driver\Tag\MXF\CornerLongitudePoint4(),
                'SubjectDistance' => new \PHPExiftool\Driver\Tag\MXF\SubjectDistance(),
                'ObjectCountryCodeMethod' => new \PHPExiftool\Driver\Tag\MXF\ObjectCountryCodeMethod(),
                'CountryCodeMethod' => new \PHPExiftool\Driver\Tag\MXF\CountryCodeMethod(),
                'Non-USClassifyingCountryCode' => new \PHPExiftool\Driver\Tag\MXF\NonUSClassifyingCountryCode(),
                'ReleasableCountryCode' => new \PHPExiftool\Driver\Tag\MXF\ReleasableCountryCode(),
                'ObjectRegionName' => new \PHPExiftool\Driver\Tag\MXF\ObjectRegionName(),
                'ShootingRegionName' => new \PHPExiftool\Driver\Tag\MXF\ShootingRegionName(),
                'SettingRegionName' => new \PHPExiftool\Driver\Tag\MXF\SettingRegionName(),
                'CopyrightLicenseRegionName' => new \PHPExiftool\Driver\Tag\MXF\CopyrightLicenseRegionName(),
                'IntellectualPropertyLicenseRegionName' => new \PHPExiftool\Driver\Tag\MXF\IntellectualPropertyLicenseRegionName(),
                'POSIXMicroseconds' => new \PHPExiftool\Driver\Tag\MXF\POSIXMicroseconds(),
                'EventElapsedTimeToStart' => new \PHPExiftool\Driver\Tag\MXF\EventElapsedTimeToStart(),
                'EventElapsedTimeToEnd' => new \PHPExiftool\Driver\Tag\MXF\EventElapsedTimeToEnd(),
                'OrganizationIDKind' => new \PHPExiftool\Driver\Tag\MXF\OrganizationIDKind(),
                'SMPTEUL' => new \PHPExiftool\Driver\Tag\MXF\SMPTEUL(),
                'EssenceContainerArray' => new \PHPExiftool\Driver\Tag\MXF\EssenceContainerArray(),
                'EssenceStreamID' => new \PHPExiftool\Driver\Tag\MXF\EssenceStreamID(),
                'IndexStreamID' => new \PHPExiftool\Driver\Tag\MXF\IndexStreamID(),
                'WorkingTitle' => new \PHPExiftool\Driver\Tag\MXF\WorkingTitle(),
                'OriginalTitle' => new \PHPExiftool\Driver\Tag\MXF\OriginalTitle(),
                'ClipNumber' => new \PHPExiftool\Driver\Tag\MXF\ClipNumber(),
                'DescriptiveMetadataTrackIDs' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataTrackIDs(),
                'IdentifierKind' => new \PHPExiftool\Driver\Tag\MXF\IdentifierKind(),
                'IdentifierValue' => new \PHPExiftool\Driver\Tag\MXF\IdentifierValue(),
                'OrganizationCode' => new \PHPExiftool\Driver\Tag\MXF\OrganizationCode(),
                'SupplierIdentificationKind' => new \PHPExiftool\Driver\Tag\MXF\SupplierIdentificationKind(),
                'SupplierIdentificationValue' => new \PHPExiftool\Driver\Tag\MXF\SupplierIdentificationValue(),
                'SupplierAccountNumber' => new \PHPExiftool\Driver\Tag\MXF\SupplierAccountNumber(),
                'SupplierAccountName' => new \PHPExiftool\Driver\Tag\MXF\SupplierAccountName(),
                'EpisodeStartNumber' => new \PHPExiftool\Driver\Tag\MXF\EpisodeStartNumber(),
                'EpisodeEndNumber' => new \PHPExiftool\Driver\Tag\MXF\EpisodeEndNumber(),
                'PurchaserIdentificationKind' => new \PHPExiftool\Driver\Tag\MXF\PurchaserIdentificationKind(),
                'PurchaserIdentificationValue' => new \PHPExiftool\Driver\Tag\MXF\PurchaserIdentificationValue(),
                'PurchaserAccountNumber' => new \PHPExiftool\Driver\Tag\MXF\PurchaserAccountNumber(),
                'PurchaserAccountName' => new \PHPExiftool\Driver\Tag\MXF\PurchaserAccountName(),
                'TotalCurrencyAmount' => new \PHPExiftool\Driver\Tag\MXF\TotalCurrencyAmount(),
                'InstallmentNumber' => new \PHPExiftool\Driver\Tag\MXF\InstallmentNumber(),
                'IdentifierIssuingAuthority' => new \PHPExiftool\Driver\Tag\MXF\IdentifierIssuingAuthority(),
                'PublishingOrganizationName' => new \PHPExiftool\Driver\Tag\MXF\PublishingOrganizationName(),
                'PublishingServiceName' => new \PHPExiftool\Driver\Tag\MXF\PublishingServiceName(),
                'PublishingMediumName' => new \PHPExiftool\Driver\Tag\MXF\PublishingMediumName(),
                'PublishingRegionName' => new \PHPExiftool\Driver\Tag\MXF\PublishingRegionName(),
                'OtherGivenNames' => new \PHPExiftool\Driver\Tag\MXF\OtherGivenNames(),
                'AlternateName' => new \PHPExiftool\Driver\Tag\MXF\AlternateName(),
                'ISO639TextLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\ISO639TextLanguageCode(),
                'ISO639CaptionsLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\ISO639CaptionsLanguageCode(),
                'PrimarySpokenLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\PrimarySpokenLanguageCode(),
                'SecondarySpokenLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\SecondarySpokenLanguageCode(),
                'PrimaryOriginalLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\PrimaryOriginalLanguageCode(),
                'SecondaryOriginalLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\SecondaryOriginalLanguageCode(),
                'MajorVersion' => new \PHPExiftool\Driver\Tag\MXF\MajorVersion(),
                'MinorVersion' => new \PHPExiftool\Driver\Tag\MXF\MinorVersion(),
                'SectorSize' => new \PHPExiftool\Driver\Tag\MXF\SectorSize(),
                'ElementLength' => new \PHPExiftool\Driver\Tag\MXF\ElementLength(),
                'KeypointKind' => new \PHPExiftool\Driver\Tag\MXF\KeypointKind(),
                'KeypointValue' => new \PHPExiftool\Driver\Tag\MXF\KeypointValue(),
                'AwardName' => new \PHPExiftool\Driver\Tag\MXF\AwardName(),
                'AwardCategory' => new \PHPExiftool\Driver\Tag\MXF\AwardCategory(),
                'SlateInformation' => new \PHPExiftool\Driver\Tag\MXF\SlateInformation(),
                'LockedIndicator' => new \PHPExiftool\Driver\Tag\MXF\LockedIndicator(),
                'BitsPerAudioSample' => new \PHPExiftool\Driver\Tag\MXF\BitsPerAudioSample(),
                'CaptionKind' => new \PHPExiftool\Driver\Tag\MXF\CaptionKind(),
                'SliceCount' => new \PHPExiftool\Driver\Tag\MXF\SliceCount(),
                'SliceNumber' => new \PHPExiftool\Driver\Tag\MXF\SliceNumber(),
                'ElementDelta' => new \PHPExiftool\Driver\Tag\MXF\ElementDelta(),
                'PositionTableIndexing' => new \PHPExiftool\Driver\Tag\MXF\PositionTableIndexing(),
                'SliceOffsetList' => new \PHPExiftool\Driver\Tag\MXF\SliceOffsetList(),
                'PosTableArray' => new \PHPExiftool\Driver\Tag\MXF\PosTableArray(),
                'StreamOffset' => new \PHPExiftool\Driver\Tag\MXF\StreamOffset(),
                'EditUnitFlags' => new \PHPExiftool\Driver\Tag\MXF\EditUnitFlags(),
                'TemporalOffset' => new \PHPExiftool\Driver\Tag\MXF\TemporalOffset(),
                'AnchorOffset' => new \PHPExiftool\Driver\Tag\MXF\AnchorOffset(),
                'EditUnitLength' => new \PHPExiftool\Driver\Tag\MXF\EditUnitLength(),
                'HeaderByteCount' => new \PHPExiftool\Driver\Tag\MXF\HeaderByteCount(),
                'IndexByteCount' => new \PHPExiftool\Driver\Tag\MXF\IndexByteCount(),
                'PackLength' => new \PHPExiftool\Driver\Tag\MXF\PackLength(),
                'PrimaryPackage' => new \PHPExiftool\Driver\Tag\MXF\PrimaryPackage(),
                'DescriptiveMetadataSets' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataSets(),
                'DescriptiveMetadataSetReferences' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataSetReferences(),
                'FileDescriptors' => new \PHPExiftool\Driver\Tag\MXF\FileDescriptors(),
                'OffsetToMetadata' => new \PHPExiftool\Driver\Tag\MXF\OffsetToMetadata(),
                'OffsetToIndexTable' => new \PHPExiftool\Driver\Tag\MXF\OffsetToIndexTable(),
                'ByteOffset' => new \PHPExiftool\Driver\Tag\MXF\ByteOffset(),
                'ReversePlay' => new \PHPExiftool\Driver\Tag\MXF\ReversePlay(),
                'FirstNumberInSequence' => new \PHPExiftool\Driver\Tag\MXF\FirstNumberInSequence(),
                'PreviousNumberInSequence' => new \PHPExiftool\Driver\Tag\MXF\PreviousNumberInSequence(),
                'CurrentNumberInSequence' => new \PHPExiftool\Driver\Tag\MXF\CurrentNumberInSequence(),
                'NextNumberInSequence' => new \PHPExiftool\Driver\Tag\MXF\NextNumberInSequence(),
                'LastNumberInSequence' => new \PHPExiftool\Driver\Tag\MXF\LastNumberInSequence(),
                'CentralTelephoneNumber' => new \PHPExiftool\Driver\Tag\MXF\CentralTelephoneNumber(),
                'MobileTelephoneNumber' => new \PHPExiftool\Driver\Tag\MXF\MobileTelephoneNumber(),
                'LocationDescription' => new \PHPExiftool\Driver\Tag\MXF\LocationDescription(),
                'LocationKind' => new \PHPExiftool\Driver\Tag\MXF\LocationKind(),
                'KeyTimePoint' => new \PHPExiftool\Driver\Tag\MXF\KeyTimePoint(),
                'SettingDateTime' => new \PHPExiftool\Driver\Tag\MXF\SettingDateTime(),
                'ContractDateTime' => new \PHPExiftool\Driver\Tag\MXF\ContractDateTime(),
                'RightsStartDateTime' => new \PHPExiftool\Driver\Tag\MXF\RightsStartDateTime(),
                'RightsStopDateTime' => new \PHPExiftool\Driver\Tag\MXF\RightsStopDateTime(),
                'PaymentDueDateTime' => new \PHPExiftool\Driver\Tag\MXF\PaymentDueDateTime(),
                'ClipID' => new \PHPExiftool\Driver\Tag\MXF\ClipID(),
                'DeviceAssetNumber' => new \PHPExiftool\Driver\Tag\MXF\DeviceAssetNumber(),
                'IdentificationUL' => new \PHPExiftool\Driver\Tag\MXF\IdentificationUL(),
                'OperationalPatternUL' => new \PHPExiftool\Driver\Tag\MXF\OperationalPatternUL(),
                'EssenceContainers' => new \PHPExiftool\Driver\Tag\MXF\EssenceContainers(),
                'DescriptiveMetadataSchemes' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataSchemes(),
                'ProjectName' => new \PHPExiftool\Driver\Tag\MXF\ProjectName(),
                'LocalTagValue' => new \PHPExiftool\Driver\Tag\MXF\LocalTagValue(),
                'LocalTagUniqueID' => new \PHPExiftool\Driver\Tag\MXF\LocalTagUniqueID(),
                'BrandMainTitle' => new \PHPExiftool\Driver\Tag\MXF\BrandMainTitle(),
                'BrandOriginalTitle' => new \PHPExiftool\Driver\Tag\MXF\BrandOriginalTitle(),
                'FrameworkTitle' => new \PHPExiftool\Driver\Tag\MXF\FrameworkTitle(),
                'SourceTrackIDs' => new \PHPExiftool\Driver\Tag\MXF\SourceTrackIDs(),
                'ShotTrackIDs' => new \PHPExiftool\Driver\Tag\MXF\ShotTrackIDs(),
                'ProgrammingGroupTitle' => new \PHPExiftool\Driver\Tag\MXF\ProgrammingGroupTitle(),
                'LinkingName' => new \PHPExiftool\Driver\Tag\MXF\LinkingName(),
                'NameSuffix' => new \PHPExiftool\Driver\Tag\MXF\NameSuffix(),
                'FormerFamilyName' => new \PHPExiftool\Driver\Tag\MXF\FormerFamilyName(),
                'Nationality' => new \PHPExiftool\Driver\Tag\MXF\Nationality(),
                'Citizenship' => new \PHPExiftool\Driver\Tag\MXF\Citizenship(),
                'FrameworkTextLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\FrameworkTextLanguageCode(),
                'KAGSize' => new \PHPExiftool\Driver\Tag\MXF\KAGSize(),
                'ReversedByteOrder' => new \PHPExiftool\Driver\Tag\MXF\ReversedByteOrder(),
                'ItemName' => new \PHPExiftool\Driver\Tag\MXF\ItemName(),
                'ItemValue' => new \PHPExiftool\Driver\Tag\MXF\ItemValue(),
                'XMLDocumentText' => new \PHPExiftool\Driver\Tag\MXF\XMLDocumentText(),
                'FrameworkThesaurusName' => new \PHPExiftool\Driver\Tag\MXF\FrameworkThesaurusName(),
                'GroupSynopsis' => new \PHPExiftool\Driver\Tag\MXF\GroupSynopsis(),
                'AnnotationSynopsis' => new \PHPExiftool\Driver\Tag\MXF\AnnotationSynopsis(),
                'AnnotationDescription' => new \PHPExiftool\Driver\Tag\MXF\AnnotationDescription(),
                'ScriptingKind' => new \PHPExiftool\Driver\Tag\MXF\ScriptingKind(),
                'ScriptingText' => new \PHPExiftool\Driver\Tag\MXF\ScriptingText(),
                'ShotDescription' => new \PHPExiftool\Driver\Tag\MXF\ShotDescription(),
                'AnnotationKind' => new \PHPExiftool\Driver\Tag\MXF\AnnotationKind(),
                'RelatedMaterialDescription' => new \PHPExiftool\Driver\Tag\MXF\RelatedMaterialDescription(),
                'ClipKind' => new \PHPExiftool\Driver\Tag\MXF\ClipKind(),
                'DeviceUsageDescription' => new \PHPExiftool\Driver\Tag\MXF\DeviceUsageDescription(),
                'DisplayF2Offset' => new \PHPExiftool\Driver\Tag\MXF\DisplayF2Offset(),
                'StoredF2Offset' => new \PHPExiftool\Driver\Tag\MXF\StoredF2Offset(),
                'ActiveFormatDescriptor' => new \PHPExiftool\Driver\Tag\MXF\ActiveFormatDescriptor(),
                'LineNumber' => new \PHPExiftool\Driver\Tag\MXF\LineNumber(),
                'ScanningDirection' => new \PHPExiftool\Driver\Tag\MXF\ScanningDirection(),
                'ComponentMaximumRef' => new \PHPExiftool\Driver\Tag\MXF\ComponentMaximumRef(),
                'ComponentMinimumRef' => new \PHPExiftool\Driver\Tag\MXF\ComponentMinimumRef(),
                'AlphaMaximumRef' => new \PHPExiftool\Driver\Tag\MXF\AlphaMaximumRef(),
                'AlphaMinimumRef' => new \PHPExiftool\Driver\Tag\MXF\AlphaMinimumRef(),
                'VideoPayloadIdentifier' => new \PHPExiftool\Driver\Tag\MXF\VideoPayloadIdentifier(),
                'VideoPayloadIdentifier2002' => new \PHPExiftool\Driver\Tag\MXF\VideoPayloadIdentifier2002(),
                'SingleSequenceFlag' => new \PHPExiftool\Driver\Tag\MXF\SingleSequenceFlag(),
                'ConstantBPictureFlag' => new \PHPExiftool\Driver\Tag\MXF\ConstantBPictureFlag(),
                'CodedContentScanningKind' => new \PHPExiftool\Driver\Tag\MXF\CodedContentScanningKind(),
                'LowDelayIndicator' => new \PHPExiftool\Driver\Tag\MXF\LowDelayIndicator(),
                'ClosedGOPIndicator' => new \PHPExiftool\Driver\Tag\MXF\ClosedGOPIndicator(),
                'IdenticalGOPIndicator' => new \PHPExiftool\Driver\Tag\MXF\IdenticalGOPIndicator(),
                'MaximumGOPSize' => new \PHPExiftool\Driver\Tag\MXF\MaximumGOPSize(),
                'MaximumBPictureCount' => new \PHPExiftool\Driver\Tag\MXF\MaximumBPictureCount(),
                'ProfileAndLevel' => new \PHPExiftool\Driver\Tag\MXF\ProfileAndLevel(),
                'Bitrate' => new \PHPExiftool\Driver\Tag\MXF\Bitrate(),
                'ChannelCount' => new \PHPExiftool\Driver\Tag\MXF\ChannelCount(),
                'PeakEnvelope' => new \PHPExiftool\Driver\Tag\MXF\PeakEnvelope(),
                'PeakEnvelopeData' => new \PHPExiftool\Driver\Tag\MXF\PeakEnvelopeData(),
                'BlockAlign' => new \PHPExiftool\Driver\Tag\MXF\BlockAlign(),
                'SequenceOffset' => new \PHPExiftool\Driver\Tag\MXF\SequenceOffset(),
                'BlockStartOffset' => new \PHPExiftool\Driver\Tag\MXF\BlockStartOffset(),
                'FileSecurityReport' => new \PHPExiftool\Driver\Tag\MXF\FileSecurityReport(),
                'FileSecurityWave' => new \PHPExiftool\Driver\Tag\MXF\FileSecurityWave(),
                'AverageBytesPerSecond' => new \PHPExiftool\Driver\Tag\MXF\AverageBytesPerSecond(),
                'AuxiliaryBitsMode' => new \PHPExiftool\Driver\Tag\MXF\AuxiliaryBitsMode(),
                'ChannelStatusMode' => new \PHPExiftool\Driver\Tag\MXF\ChannelStatusMode(),
                'FixedChannelStatusData' => new \PHPExiftool\Driver\Tag\MXF\FixedChannelStatusData(),
                'UserDataMode' => new \PHPExiftool\Driver\Tag\MXF\UserDataMode(),
                'FixedUserData' => new \PHPExiftool\Driver\Tag\MXF\FixedUserData(),
                'Emphasis' => new \PHPExiftool\Driver\Tag\MXF\Emphasis(),
                'BextCodingHistory' => new \PHPExiftool\Driver\Tag\MXF\BextCodingHistory(),
                'QltyBasicData' => new \PHPExiftool\Driver\Tag\MXF\QltyBasicData(),
                'QltyStartOfModulation' => new \PHPExiftool\Driver\Tag\MXF\QltyStartOfModulation(),
                'QltyQualityEvent' => new \PHPExiftool\Driver\Tag\MXF\QltyQualityEvent(),
                'QltyEndOfModulation' => new \PHPExiftool\Driver\Tag\MXF\QltyEndOfModulation(),
                'QltyQualityParameter' => new \PHPExiftool\Driver\Tag\MXF\QltyQualityParameter(),
                'QltyOperatorComment' => new \PHPExiftool\Driver\Tag\MXF\QltyOperatorComment(),
                'QltyCueSheet' => new \PHPExiftool\Driver\Tag\MXF\QltyCueSheet(),
                'DialNorm' => new \PHPExiftool\Driver\Tag\MXF\DialNorm(),
                'DataEssenceCoding' => new \PHPExiftool\Driver\Tag\MXF\DataEssenceCoding(),
                'DateTimeRate' => new \PHPExiftool\Driver\Tag\MXF\DateTimeRate(),
                'DateTimeDropFrameFlag' => new \PHPExiftool\Driver\Tag\MXF\DateTimeDropFrameFlag(),
                'DateTimeEmbeddedFlag' => new \PHPExiftool\Driver\Tag\MXF\DateTimeEmbeddedFlag(),
                'DateTimeKind' => new \PHPExiftool\Driver\Tag\MXF\DateTimeKind(),
                'DeltaEntryArray' => new \PHPExiftool\Driver\Tag\MXF\DeltaEntryArray(),
                'PositionTableCount' => new \PHPExiftool\Driver\Tag\MXF\PositionTableCount(),
                'PositionTable' => new \PHPExiftool\Driver\Tag\MXF\PositionTable(),
                'IndexEntryArray' => new \PHPExiftool\Driver\Tag\MXF\IndexEntryArray(),
                'DataDefinition' => new \PHPExiftool\Driver\Tag\MXF\DataDefinition(),
                'GenerationCopyNumber' => new \PHPExiftool\Driver\Tag\MXF\GenerationCopyNumber(),
                'GenerationCloneNumber' => new \PHPExiftool\Driver\Tag\MXF\GenerationCloneNumber(),
                'ThemeMusicFlag' => new \PHPExiftool\Driver\Tag\MXF\ThemeMusicFlag(),
                'InsertMusicFlag' => new \PHPExiftool\Driver\Tag\MXF\InsertMusicFlag(),
                'IndexEditRate' => new \PHPExiftool\Driver\Tag\MXF\IndexEditRate(),
                'LinkedTrackID' => new \PHPExiftool\Driver\Tag\MXF\LinkedTrackID(),
                'DescriptiveMetadataFramework' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataFramework(),
                'GroupSet' => new \PHPExiftool\Driver\Tag\MXF\GroupSet(),
                'BankDetailsSet' => new \PHPExiftool\Driver\Tag\MXF\BankDetailsSet(),
                'ImageFormatSet' => new \PHPExiftool\Driver\Tag\MXF\ImageFormatSet(),
                'ProcessingSet' => new \PHPExiftool\Driver\Tag\MXF\ProcessingSet(),
                'ProjectSet' => new \PHPExiftool\Driver\Tag\MXF\ProjectSet(),
                'ContactsListSet' => new \PHPExiftool\Driver\Tag\MXF\ContactsListSet(),
                'AnnotationCueWordsSet' => new \PHPExiftool\Driver\Tag\MXF\AnnotationCueWordsSet(),
                'ShotCueWordsSet' => new \PHPExiftool\Driver\Tag\MXF\ShotCueWordsSet(),
                'AwardParticipantSets' => new \PHPExiftool\Driver\Tag\MXF\AwardParticipantSets(),
                'ContractParticipantSets' => new \PHPExiftool\Driver\Tag\MXF\ContractParticipantSets(),
                'PersonSets' => new \PHPExiftool\Driver\Tag\MXF\PersonSets(),
                'ParticipantOrganizationSets' => new \PHPExiftool\Driver\Tag\MXF\ParticipantOrganizationSets(),
                'PersonOrganizationSets' => new \PHPExiftool\Driver\Tag\MXF\PersonOrganizationSets(),
                'LocationSets' => new \PHPExiftool\Driver\Tag\MXF\LocationSets(),
                'TitlesSets' => new \PHPExiftool\Driver\Tag\MXF\TitlesSets(),
                'GroupSets' => new \PHPExiftool\Driver\Tag\MXF\GroupSets(),
                'IdentificationSets' => new \PHPExiftool\Driver\Tag\MXF\IdentificationSets(),
                'EpisodicItemSets' => new \PHPExiftool\Driver\Tag\MXF\EpisodicItemSets(),
                'BrandingSets' => new \PHPExiftool\Driver\Tag\MXF\BrandingSets(),
                'EventSets' => new \PHPExiftool\Driver\Tag\MXF\EventSets(),
                'PublicationSets' => new \PHPExiftool\Driver\Tag\MXF\PublicationSets(),
                'AwardSets' => new \PHPExiftool\Driver\Tag\MXF\AwardSets(),
                'CaptionDescriptionSets' => new \PHPExiftool\Driver\Tag\MXF\CaptionDescriptionSets(),
                'AnnotationSets' => new \PHPExiftool\Driver\Tag\MXF\AnnotationSets(),
                'ProductionSettingPeriodSets' => new \PHPExiftool\Driver\Tag\MXF\ProductionSettingPeriodSets(),
                'SceneSettingPeriodSets' => new \PHPExiftool\Driver\Tag\MXF\SceneSettingPeriodSets(),
                'ScriptingSets' => new \PHPExiftool\Driver\Tag\MXF\ScriptingSets(),
                'ClassificationSets' => new \PHPExiftool\Driver\Tag\MXF\ClassificationSets(),
                'SceneShotSets' => new \PHPExiftool\Driver\Tag\MXF\SceneShotSets(),
                'ClipShotSets' => new \PHPExiftool\Driver\Tag\MXF\ClipShotSets(),
                'KeyPointSets' => new \PHPExiftool\Driver\Tag\MXF\KeyPointSets(),
                'ShotParticipantRoleSets' => new \PHPExiftool\Driver\Tag\MXF\ShotParticipantRoleSets(),
                'ShotPersonSets' => new \PHPExiftool\Driver\Tag\MXF\ShotPersonSets(),
                'OrganizationSets' => new \PHPExiftool\Driver\Tag\MXF\OrganizationSets(),
                'ShotLocationSets' => new \PHPExiftool\Driver\Tag\MXF\ShotLocationSets(),
                'AddressSets' => new \PHPExiftool\Driver\Tag\MXF\AddressSets(),
                'CommunicationSets' => new \PHPExiftool\Driver\Tag\MXF\CommunicationSets(),
                'ContractSets' => new \PHPExiftool\Driver\Tag\MXF\ContractSets(),
                'RightsSets' => new \PHPExiftool\Driver\Tag\MXF\RightsSets(),
                'PaymentsSets' => new \PHPExiftool\Driver\Tag\MXF\PaymentsSets(),
                'DeviceParametersSets' => new \PHPExiftool\Driver\Tag\MXF\DeviceParametersSets(),
                'ClassificationNameValueSets' => new \PHPExiftool\Driver\Tag\MXF\ClassificationNameValueSets(),
                'ContactNameValueSets' => new \PHPExiftool\Driver\Tag\MXF\ContactNameValueSets(),
                'DeviceParameterNameValueSets' => new \PHPExiftool\Driver\Tag\MXF\DeviceParameterNameValueSets(),
                'MetadataServerLocators' => new \PHPExiftool\Driver\Tag\MXF\MetadataServerLocators(),
                'RelatedMaterialLocators' => new \PHPExiftool\Driver\Tag\MXF\RelatedMaterialLocators(),
                'LocalTagEntries' => new \PHPExiftool\Driver\Tag\MXF\LocalTagEntries(),
                'TotalNumberInSequence' => new \PHPExiftool\Driver\Tag\MXF\TotalNumberInSequence(),
                'RoomOrSuiteName' => new \PHPExiftool\Driver\Tag\MXF\RoomOrSuiteName(),
                'BuildingName' => new \PHPExiftool\Driver\Tag\MXF\BuildingName(),
                'LocalFestivalDateTime' => new \PHPExiftool\Driver\Tag\MXF\LocalFestivalDateTime(),
                'ShotStartPosition' => new \PHPExiftool\Driver\Tag\MXF\ShotStartPosition(),
                'IndexingStartPosition' => new \PHPExiftool\Driver\Tag\MXF\IndexingStartPosition(),
                'EventOrigin' => new \PHPExiftool\Driver\Tag\MXF\EventOrigin(),
                'SettingPeriodDescription' => new \PHPExiftool\Driver\Tag\MXF\SettingPeriodDescription(),
                'IndexDuration' => new \PHPExiftool\Driver\Tag\MXF\IndexDuration(),
                'ShotDuration' => new \PHPExiftool\Driver\Tag\MXF\ShotDuration(),
                'ExtendedClipID' => new \PHPExiftool\Driver\Tag\MXF\ExtendedClipID(),
                'ClipIDArray' => new \PHPExiftool\Driver\Tag\MXF\ClipIDArray(),
                'ExtendedClipIDArray' => new \PHPExiftool\Driver\Tag\MXF\ExtendedClipIDArray(),
                'TrackNumberBatch' => new \PHPExiftool\Driver\Tag\MXF\TrackNumberBatch(),
                'ExtendedTextLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\ExtendedTextLanguageCode(),
                'ExtendedCaptionsLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\ExtendedCaptionsLanguageCode(),
                'FrameworkExtendedTextLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\FrameworkExtendedTextLanguageCode(),
                'PrimaryExtendedSpokenLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\PrimaryExtendedSpokenLanguageCode(),
                'SecondaryExtendedSpokenLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\SecondaryExtendedSpokenLanguageCode(),
                'OriginalExtendedSpokenPrimaryLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\OriginalExtendedSpokenPrimaryLanguageCode(),
                'SecondaryOriginalExtendedSpokenLanguageCode' => new \PHPExiftool\Driver\Tag\MXF\SecondaryOriginalExtendedSpokenLanguageCode(),
                'KLVMetadataSequence' => new \PHPExiftool\Driver\Tag\MXF\KLVMetadataSequence(),
                'PackageAttributes' => new \PHPExiftool\Driver\Tag\MXF\PackageAttributes(),
                'ComponentAttributes' => new \PHPExiftool\Driver\Tag\MXF\ComponentAttributes(),
                'MPEG7BiMDecoderInitFrame1' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame1(),
                'MPEG7BiMDecoderInitFrame2' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame2(),
                'MPEG7BiMDecoderInitFrame3' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame3(),
                'MPEG7BiMDecoderInitFrame4' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame4(),
                'MPEG7BiMDecoderInitFrame5' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame5(),
                'MPEG7BiMDecoderInitFrame6' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame6(),
                'MPEG7BiMDecoderInitFrame7' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame7(),
                'MPEG7BiMDecoderInitFrame8' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMDecoderInitFrame8(),
                'MPEG7BiMAccessUnitFrame1' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame1(),
                'MPEG7BiMAccessUnitFrame2' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame2(),
                'MPEG7BiMAccessUnitFrame3' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame3(),
                'MPEG7BiMAccessUnitFrame4' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame4(),
                'MPEG7BiMAccessUnitFrame5' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame5(),
                'MPEG7BiMAccessUnitFrame6' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame6(),
                'MPEG7BiMAccessUnitFrame7' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame7(),
                'MPEG7BiMAccessUnitFrame8' => new \PHPExiftool\Driver\Tag\MXF\MPEG7BiMAccessUnitFrame8(),
                'ComponentUserComments' => new \PHPExiftool\Driver\Tag\MXF\ComponentUserComments(),
                'SensorMode' => new \PHPExiftool\Driver\Tag\MXF\SensorMode(),
                'ChannelAssignment' => new \PHPExiftool\Driver\Tag\MXF\ChannelAssignment(),
                'ContentPackageIndexArray' => new \PHPExiftool\Driver\Tag\MXF\ContentPackageIndexArray(),
                'VideoIndexArray' => new \PHPExiftool\Driver\Tag\MXF\VideoIndexArray(),
                'ApproximateImageContainerSize' => new \PHPExiftool\Driver\Tag\MXF\ApproximateImageContainerSize(),
                'MetadataEncodingSchemeCode' => new \PHPExiftool\Driver\Tag\MXF\MetadataEncodingSchemeCode(),
                'MIMEMediaType' => new \PHPExiftool\Driver\Tag\MXF\MIMEMediaType(),
                'FieldOfViewVerticalFP' => new \PHPExiftool\Driver\Tag\MXF\FieldOfViewVerticalFP(),
                'PackageUsageKind' => new \PHPExiftool\Driver\Tag\MXF\PackageUsageKind(),
                'ChannelID' => new \PHPExiftool\Driver\Tag\MXF\ChannelID(),
                'ChannelIDs' => new \PHPExiftool\Driver\Tag\MXF\ChannelIDs(),
                'KLVDataType' => new \PHPExiftool\Driver\Tag\MXF\KLVDataType(),
                'KLVDataParentProperties' => new \PHPExiftool\Driver\Tag\MXF\KLVDataParentProperties(),
                'TaggedValueParentProperties' => new \PHPExiftool\Driver\Tag\MXF\TaggedValueParentProperties(),
                'AnnotationParticipantSets' => new \PHPExiftool\Driver\Tag\MXF\AnnotationParticipantSets(),
                'KLVDataDefinitions' => new \PHPExiftool\Driver\Tag\MXF\KLVDataDefinitions(),
                'TaggedValueDefinitions' => new \PHPExiftool\Driver\Tag\MXF\TaggedValueDefinitions(),
                'AddressNameValueSets' => new \PHPExiftool\Driver\Tag\MXF\AddressNameValueSets(),
                'NMEADocumentText' => new \PHPExiftool\Driver\Tag\MXF\NMEADocumentText(),
                'PlatformRollAngle' => new \PHPExiftool\Driver\Tag\MXF\PlatformRollAngle(),
                'PlatformPitchAngle' => new \PHPExiftool\Driver\Tag\MXF\PlatformPitchAngle(),
                'PlatformHeadingAngle' => new \PHPExiftool\Driver\Tag\MXF\PlatformHeadingAngle(),
                'AddressLine' => new \PHPExiftool\Driver\Tag\MXF\AddressLine(),
                'PlaceName' => new \PHPExiftool\Driver\Tag\MXF\PlaceName(),
                'GeographicalCoordinates' => new \PHPExiftool\Driver\Tag\MXF\GeographicalCoordinates(),
                'AstronomicalBodyName' => new \PHPExiftool\Driver\Tag\MXF\AstronomicalBodyName(),
                'TimecodeArray' => new \PHPExiftool\Driver\Tag\MXF\TimecodeArray(),
                'MarkIn' => new \PHPExiftool\Driver\Tag\MXF\MarkIn(),
                'UserPosition' => new \PHPExiftool\Driver\Tag\MXF\UserPosition(),
                'MarkOut' => new \PHPExiftool\Driver\Tag\MXF\MarkOut(),
                'ClipCreationDateTime' => new \PHPExiftool\Driver\Tag\MXF\ClipCreationDateTime(),
                'VideoClipDuration' => new \PHPExiftool\Driver\Tag\MXF\VideoClipDuration(),
                'ParticipantID' => new \PHPExiftool\Driver\Tag\MXF\ParticipantID(),
                'ContactID' => new \PHPExiftool\Driver\Tag\MXF\ContactID(),
                'DefaultNamespaceURI' => new \PHPExiftool\Driver\Tag\MXF\DefaultNamespaceURI(),
                'NamespaceURI' => new \PHPExiftool\Driver\Tag\MXF\NamespaceURI(),
                'NamespaceURIs' => new \PHPExiftool\Driver\Tag\MXF\NamespaceURIs(),
                'HTMLDOCTYPE' => new \PHPExiftool\Driver\Tag\MXF\HTMLDOCTYPE(),
                'NamespacePrefix' => new \PHPExiftool\Driver\Tag\MXF\NamespacePrefix(),
                'NamespacePrefixes' => new \PHPExiftool\Driver\Tag\MXF\NamespacePrefixes(),
                'RightsComment' => new \PHPExiftool\Driver\Tag\MXF\RightsComment(),
                'NominationCategory' => new \PHPExiftool\Driver\Tag\MXF\NominationCategory(),
                'PeakEnvelopeVersion' => new \PHPExiftool\Driver\Tag\MXF\PeakEnvelopeVersion(),
                'PeakEnvelopeFormat' => new \PHPExiftool\Driver\Tag\MXF\PeakEnvelopeFormat(),
                'PointsPerPeakValue' => new \PHPExiftool\Driver\Tag\MXF\PointsPerPeakValue(),
                'PeakEnvelopeBlockSize' => new \PHPExiftool\Driver\Tag\MXF\PeakEnvelopeBlockSize(),
                'PeakChannelCount' => new \PHPExiftool\Driver\Tag\MXF\PeakChannelCount(),
                'PeakFrameCount' => new \PHPExiftool\Driver\Tag\MXF\PeakFrameCount(),
                'PeakOfPeaksPosition' => new \PHPExiftool\Driver\Tag\MXF\PeakOfPeaksPosition(),
                'PeakEnvelopeTimestamp' => new \PHPExiftool\Driver\Tag\MXF\PeakEnvelopeTimestamp(),
                'RIFFChunkID' => new \PHPExiftool\Driver\Tag\MXF\RIFFChunkID(),
                'RIFFChunkLength' => new \PHPExiftool\Driver\Tag\MXF\RIFFChunkLength(),
                'RIFFChunkData' => new \PHPExiftool\Driver\Tag\MXF\RIFFChunkData(),
                'MIMECharSet' => new \PHPExiftool\Driver\Tag\MXF\MIMECharSet(),
                'MIMEEncoding' => new \PHPExiftool\Driver\Tag\MXF\MIMEEncoding(),
                'MonoSourceTrackIDs' => new \PHPExiftool\Driver\Tag\MXF\MonoSourceTrackIDs(),
                'CompositionRendering' => new \PHPExiftool\Driver\Tag\MXF\CompositionRendering(),
                'CaptionsDescriptionParticipantSets' => new \PHPExiftool\Driver\Tag\MXF\CaptionsDescriptionParticipantSets(),
                'EventAnnotationSets' => new \PHPExiftool\Driver\Tag\MXF\EventAnnotationSets(),
                'ScriptingLocators' => new \PHPExiftool\Driver\Tag\MXF\ScriptingLocators(),
                'UnknownBWFChunks' => new \PHPExiftool\Driver\Tag\MXF\UnknownBWFChunks(),
                'CryptographicContextID' => new \PHPExiftool\Driver\Tag\MXF\CryptographicContextID(),
                'NITFLayerTargetID' => new \PHPExiftool\Driver\Tag\MXF\NITFLayerTargetID(),
                'RP217DataStreamPID' => new \PHPExiftool\Driver\Tag\MXF\RP217DataStreamPID(),
                'RP217VideoStreamPID' => new \PHPExiftool\Driver\Tag\MXF\RP217VideoStreamPID(),
                'CipherAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\CipherAlgorithm(),
                'CryptographicKeyID' => new \PHPExiftool\Driver\Tag\MXF\CryptographicKeyID(),
                'EncryptedSourceValue' => new \PHPExiftool\Driver\Tag\MXF\EncryptedSourceValue(),
                'MICAlgorithm' => new \PHPExiftool\Driver\Tag\MXF\MICAlgorithm(),
                'MIC' => new \PHPExiftool\Driver\Tag\MXF\MIC(),
                'JFIFMarkerDescription' => new \PHPExiftool\Driver\Tag\MXF\JFIFMarkerDescription(),
                'HTMLMetaDescription' => new \PHPExiftool\Driver\Tag\MXF\HTMLMetaDescription(),
                'ColorPrimaries' => new \PHPExiftool\Driver\Tag\MXF\ColorPrimaries(),
                'ProductFormat' => new \PHPExiftool\Driver\Tag\MXF\ProductFormat(),
                'SourceLength' => new \PHPExiftool\Driver\Tag\MXF\SourceLength(),
                'SourceContainerFormat' => new \PHPExiftool\Driver\Tag\MXF\SourceContainerFormat(),
                'SourceKey' => new \PHPExiftool\Driver\Tag\MXF\SourceKey(),
                'DynamicSourcePackageID' => new \PHPExiftool\Driver\Tag\MXF\DynamicSourcePackageID(),
                'DynamicSourceTrackIDs' => new \PHPExiftool\Driver\Tag\MXF\DynamicSourceTrackIDs(),
                'SourceIndex' => new \PHPExiftool\Driver\Tag\MXF\SourceIndex(),
                'SourceSpecies' => new \PHPExiftool\Driver\Tag\MXF\SourceSpecies(),
                'SourceValue' => new \PHPExiftool\Driver\Tag\MXF\SourceValue(),
                'CryptographicContextObject' => new \PHPExiftool\Driver\Tag\MXF\CryptographicContextObject(),
                'mixed' => new \PHPExiftool\Driver\Tag\MXF\SubDescriptors(),
                'EncryptedTrackFileID' => new \PHPExiftool\Driver\Tag\MXF\EncryptedTrackFileID(),
                'CryptographicContextLink' => new \PHPExiftool\Driver\Tag\MXF\CryptographicContextLink(),
                'PlaintextOffset' => new \PHPExiftool\Driver\Tag\MXF\PlaintextOffset(),
                'TripletSequenceNumber' => new \PHPExiftool\Driver\Tag\MXF\TripletSequenceNumber(),
                'BoundingRectangle' => new \PHPExiftool\Driver\Tag\MXF\BoundingRectangle(),
                'GeographicLocation' => new \PHPExiftool\Driver\Tag\MXF\GeographicLocation(),
                'GeographicPolygonCoordinates' => new \PHPExiftool\Driver\Tag\MXF\GeographicPolygonCoordinates(),
                'GeographicAreaNorthwest' => new \PHPExiftool\Driver\Tag\MXF\GeographicAreaNorthwest(),
                'GeographicAreaSoutheast' => new \PHPExiftool\Driver\Tag\MXF\GeographicAreaSoutheast(),
                'GeographicAreaSourceDatum' => new \PHPExiftool\Driver\Tag\MXF\GeographicAreaSourceDatum(),
                'GeographicPolygonSourceDatum' => new \PHPExiftool\Driver\Tag\MXF\GeographicPolygonSourceDatum(),
                'ClassifyingCountryCode' => new \PHPExiftool\Driver\Tag\MXF\ClassifyingCountryCode(),
                'UTCInstantDateTime' => new \PHPExiftool\Driver\Tag\MXF\UTCInstantDateTime(),
                'ToleranceMode' => new \PHPExiftool\Driver\Tag\MXF\ToleranceMode(),
                'ToleranceWindow' => new \PHPExiftool\Driver\Tag\MXF\ToleranceWindow(),
                'ToleranceInterpolationMethod' => new \PHPExiftool\Driver\Tag\MXF\ToleranceInterpolationMethod(),
                'VBILineCount' => new \PHPExiftool\Driver\Tag\MXF\VBILineCount(),
                'StoredVBILineNumber' => new \PHPExiftool\Driver\Tag\MXF\StoredVBILineNumber(),
                'VBIWrappingType' => new \PHPExiftool\Driver\Tag\MXF\VBIWrappingType(),
                'VBIPayloadSampleCount' => new \PHPExiftool\Driver\Tag\MXF\VBIPayloadSampleCount(),
                'VBIPayloadByteArray' => new \PHPExiftool\Driver\Tag\MXF\VBIPayloadByteArray(),
                'ANCPacketCount' => new \PHPExiftool\Driver\Tag\MXF\ANCPacketCount(),
                'StoredANCLineNumber' => new \PHPExiftool\Driver\Tag\MXF\StoredANCLineNumber(),
                'ANCWrappingType' => new \PHPExiftool\Driver\Tag\MXF\ANCWrappingType(),
                'ANCPayloadSampleCount' => new \PHPExiftool\Driver\Tag\MXF\ANCPayloadSampleCount(),
                'ANCPayloadByteArray' => new \PHPExiftool\Driver\Tag\MXF\ANCPayloadByteArray(),
                'VBIPayloadSampleCoding' => new \PHPExiftool\Driver\Tag\MXF\VBIPayloadSampleCoding(),
                'ANCPayloadSampleCoding' => new \PHPExiftool\Driver\Tag\MXF\ANCPayloadSampleCoding(),
                'Rsiz' => new \PHPExiftool\Driver\Tag\MXF\Rsiz(),
                'Xsiz' => new \PHPExiftool\Driver\Tag\MXF\Xsiz(),
                'Ysiz' => new \PHPExiftool\Driver\Tag\MXF\Ysiz(),
                'XOsiz' => new \PHPExiftool\Driver\Tag\MXF\XOsiz(),
                'YOsiz' => new \PHPExiftool\Driver\Tag\MXF\YOsiz(),
                'XTsiz' => new \PHPExiftool\Driver\Tag\MXF\XTsiz(),
                'YTsiz' => new \PHPExiftool\Driver\Tag\MXF\YTsiz(),
                'XTOsiz' => new \PHPExiftool\Driver\Tag\MXF\XTOsiz(),
                'YTOsiz' => new \PHPExiftool\Driver\Tag\MXF\YTOsiz(),
                'Csiz' => new \PHPExiftool\Driver\Tag\MXF\Csiz(),
                'PictureComponentSizing' => new \PHPExiftool\Driver\Tag\MXF\PictureComponentSizing(),
                'CodingStyleDefault' => new \PHPExiftool\Driver\Tag\MXF\CodingStyleDefault(),
                'QuantizationDefault' => new \PHPExiftool\Driver\Tag\MXF\QuantizationDefault(),
                'MPEGAudioBitrate' => new \PHPExiftool\Driver\Tag\MXF\MPEGAudioBitrate(),
                'CBEStartOffset' => new \PHPExiftool\Driver\Tag\MXF\CBEStartOffset(),
                'VBEEndOffset' => new \PHPExiftool\Driver\Tag\MXF\VBEEndOffset(),
                'SubDescriptor' => new \PHPExiftool\Driver\Tag\MXF\SubDescriptor(),
                'RootMetaDictionary' => new \PHPExiftool\Driver\Tag\MXF\RootMetaDictionary(),
                'RootPreface' => new \PHPExiftool\Driver\Tag\MXF\RootPreface(),
                'RootObjectDirectory' => new \PHPExiftool\Driver\Tag\MXF\RootObjectDirectory(),
                'RootFormatVersion' => new \PHPExiftool\Driver\Tag\MXF\RootFormatVersion(),
                'FrameCenterElevation' => new \PHPExiftool\Driver\Tag\MXF\FrameCenterElevation(),
                'PackageMarkInPosition' => new \PHPExiftool\Driver\Tag\MXF\PackageMarkInPosition(),
                'PackageMarkOutPosition' => new \PHPExiftool\Driver\Tag\MXF\PackageMarkOutPosition(),
                'Ad-ID' => new \PHPExiftool\Driver\Tag\MXF\AdID(),
                'ResourceID' => new \PHPExiftool\Driver\Tag\MXF\ResourceID(),
                'AncillaryResourceID' => new \PHPExiftool\Driver\Tag\MXF\AncillaryResourceID(),
                'ApplicationSchemeBatch' => new \PHPExiftool\Driver\Tag\MXF\ApplicationSchemeBatch(),
                'RegisterKind' => new \PHPExiftool\Driver\Tag\MXF\RegisterKind(),
                'RegisterVersion' => new \PHPExiftool\Driver\Tag\MXF\RegisterVersion(),
                'RegisterEditorName' => new \PHPExiftool\Driver\Tag\MXF\RegisterEditorName(),
                'RegisterStatusKind' => new \PHPExiftool\Driver\Tag\MXF\RegisterStatusKind(),
                'RegisterItemName' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemName(),
                'RegisterItemDefinition' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemDefinition(),
                'RegisterItemSymbol' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemSymbol(),
                'RegisterItemDefiningDocumentName' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemDefiningDocumentName(),
                'RegisterItemUL' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemUL(),
                'RegisterItemNotes' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemNotes(),
                'RegisterItemIntroductionVersion' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemIntroductionVersion(),
                'RegisterItemHierarchyLevel' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemHierarchyLevel(),
                'RegisterEntryStatus' => new \PHPExiftool\Driver\Tag\MXF\RegisterEntryStatus(),
                'RegisterAction' => new \PHPExiftool\Driver\Tag\MXF\RegisterAction(),
                'RegisterApproverName' => new \PHPExiftool\Driver\Tag\MXF\RegisterApproverName(),
                'RegisterCreationTime' => new \PHPExiftool\Driver\Tag\MXF\RegisterCreationTime(),
                'RegistrantName' => new \PHPExiftool\Driver\Tag\MXF\RegistrantName(),
                'RegisterItemOriginatorName' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemOriginatorName(),
                'RegisterUserName' => new \PHPExiftool\Driver\Tag\MXF\RegisterUserName(),
                'RegisterUserTime' => new \PHPExiftool\Driver\Tag\MXF\RegisterUserTime(),
                'RegisterAdministrationNotes' => new \PHPExiftool\Driver\Tag\MXF\RegisterAdministrationNotes(),
                'AFDAndBarData' => new \PHPExiftool\Driver\Tag\MXF\AFDAndBarData(),
                'PanScanInformation' => new \PHPExiftool\Driver\Tag\MXF\PanScanInformation(),
                'VC-1InitializationMetadata' => new \PHPExiftool\Driver\Tag\MXF\VC1InitializationMetadata(),
                'VC-1SingleSequence' => new \PHPExiftool\Driver\Tag\MXF\VC1SingleSequence(),
                'VC-1CodedContentType' => new \PHPExiftool\Driver\Tag\MXF\VC1CodedContentType(),
                'VC-1IdenticalGOP' => new \PHPExiftool\Driver\Tag\MXF\VC1IdenticalGOP(),
                'VC-1MaximumGOP' => new \PHPExiftool\Driver\Tag\MXF\VC1MaximumGOP(),
                'VC-1BPictureCount' => new \PHPExiftool\Driver\Tag\MXF\VC1BPictureCount(),
                'VC-1AverageBitrate' => new \PHPExiftool\Driver\Tag\MXF\VC1AverageBitrate(),
                'VC-1MaximumBitrate' => new \PHPExiftool\Driver\Tag\MXF\VC1MaximumBitrate(),
                'VC-1Profile' => new \PHPExiftool\Driver\Tag\MXF\VC1Profile(),
                'VC-1Level' => new \PHPExiftool\Driver\Tag\MXF\VC1Level(),
                'LinkedTimecodeTrackID' => new \PHPExiftool\Driver\Tag\MXF\LinkedTimecodeTrackID(),
                'SMPTE337MDataStreamNumber' => new \PHPExiftool\Driver\Tag\MXF\SMPTE337MDataStreamNumber(),
                'ApplicationScheme' => new \PHPExiftool\Driver\Tag\MXF\ApplicationScheme(),
                'DescriptiveMetadataScheme' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataScheme(),
                'UCSEncoding' => new \PHPExiftool\Driver\Tag\MXF\UCSEncoding(),
                'LinkedApplicationPlug-InInstanceID' => new \PHPExiftool\Driver\Tag\MXF\LinkedApplicationPlugInInstanceID(),
                'LinkedDescriptiveFrameworkPlug-InID' => new \PHPExiftool\Driver\Tag\MXF\LinkedDescriptiveFrameworkPlugInID(),
                'ApplicationPlug-InInstanceID' => new \PHPExiftool\Driver\Tag\MXF\ApplicationPlugInInstanceID(),
                'DescriptiveMetadataPlug-InID' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataPlugInID(),
                'ApplicationEnvironmentID' => new \PHPExiftool\Driver\Tag\MXF\ApplicationEnvironmentID(),
                'DescriptiveMetadataApplicationEnvironmentID' => new \PHPExiftool\Driver\Tag\MXF\DescriptiveMetadataApplicationEnvironmentID(),
                'LinkedDescriptiveObjectPlug-InID' => new \PHPExiftool\Driver\Tag\MXF\LinkedDescriptiveObjectPlugInID(),
                'TimebaseReferenceTrackID' => new \PHPExiftool\Driver\Tag\MXF\TimebaseReferenceTrackID(),
                'ObjectClassDefinition' => new \PHPExiftool\Driver\Tag\MXF\ObjectClassDefinition(),
                'ApplicationPlug-InBatch' => new \PHPExiftool\Driver\Tag\MXF\ApplicationPlugInBatch(),
                'PackageMarker' => new \PHPExiftool\Driver\Tag\MXF\PackageMarker(),
                'PackageTimelineMarkerRef' => new \PHPExiftool\Driver\Tag\MXF\PackageTimelineMarkerRef(),
                'RegisterAdministrationObject' => new \PHPExiftool\Driver\Tag\MXF\RegisterAdministrationObject(),
                'RegisterEntryAdministrationObject' => new \PHPExiftool\Driver\Tag\MXF\RegisterEntryAdministrationObject(),
                'GenericPayloads' => new \PHPExiftool\Driver\Tag\MXF\GenericPayloads(),
                'RegisterEntryArray' => new \PHPExiftool\Driver\Tag\MXF\RegisterEntryArray(),
                'RegisterAdministrationArray' => new \PHPExiftool\Driver\Tag\MXF\RegisterAdministrationArray(),
                'ApplicationInformationArray' => new \PHPExiftool\Driver\Tag\MXF\ApplicationInformationArray(),
                'RegisterChildEntryArray' => new \PHPExiftool\Driver\Tag\MXF\RegisterChildEntryArray(),
                'RegisterReleaseDateTime' => new \PHPExiftool\Driver\Tag\MXF\RegisterReleaseDateTime(),
                'RegisterItemStatusChangeDateTime' => new \PHPExiftool\Driver\Tag\MXF\RegisterItemStatusChangeDateTime(),
                'OpenBodyPartition' => new \PHPExiftool\Driver\Tag\MXF\OpenBodyPartition(),
                'ClosedBodyPartition' => new \PHPExiftool\Driver\Tag\MXF\ClosedBodyPartition(),
                'OpenCompleteBodyPartition' => new \PHPExiftool\Driver\Tag\MXF\OpenCompleteBodyPartition(),
                'ClosedCompleteBodyPartition' => new \PHPExiftool\Driver\Tag\MXF\ClosedCompleteBodyPartition(),
                'Footer' => new \PHPExiftool\Driver\Tag\MXF\Footer(),
                'CompleteFooter' => new \PHPExiftool\Driver\Tag\MXF\CompleteFooter(),
                'RandomIndexMetadataV10' => new \PHPExiftool\Driver\Tag\MXF\RandomIndexMetadataV10(),
                'RandomIndexMetadata' => new \PHPExiftool\Driver\Tag\MXF\RandomIndexMetadata(),
                'PartitionMetadata' => new \PHPExiftool\Driver\Tag\MXF\PartitionMetadata(),
                'SourceClip' => new \PHPExiftool\Driver\Tag\MXF\SourceClip(),
                'V10IndexTableSegment' => new \PHPExiftool\Driver\Tag\MXF\V10IndexTableSegment(),
                'IndexTableSegment' => new \PHPExiftool\Driver\Tag\MXF\IndexTableSegment(),
                'DefaultObject' => new \PHPExiftool\Driver\Tag\MXF\DefaultObject(),
                'CipherAlgorithmAES128CBC' => new \PHPExiftool\Driver\Tag\MXF\CipherAlgorithmAES128CBC(),
                'HMACAlgorithmSHA1128' => new \PHPExiftool\Driver\Tag\MXF\HMACAlgorithmSHA1128(),
                'EncryptedContainerLabel' => new \PHPExiftool\Driver\Tag\MXF\EncryptedContainerLabel(),
                'CryptographicFrameworkLabel' => new \PHPExiftool\Driver\Tag\MXF\CryptographicFrameworkLabel(),
            );
        });
        $this['Matroska'] = $this->share(function(){
            return array(
                'TrackType' => new \PHPExiftool\Driver\Tag\Matroska\TrackType(),
                'ChapterString' => new \PHPExiftool\Driver\Tag\Matroska\ChapterString(),
                'VideoCodecID' => new \PHPExiftool\Driver\Tag\Matroska\VideoCodecID(),
                'AudioCodecID' => new \PHPExiftool\Driver\Tag\Matroska\AudioCodecID(),
                'CodecID' => new \PHPExiftool\Driver\Tag\Matroska\CodecID(),
                'TrackDefault' => new \PHPExiftool\Driver\Tag\Matroska\TrackDefault(),
                'ChapterTrackNumber' => new \PHPExiftool\Driver\Tag\Matroska\ChapterTrackNumber(),
                'ChapterTimeStart' => new \PHPExiftool\Driver\Tag\Matroska\ChapterTimeStart(),
                'ChapterTimeEnd' => new \PHPExiftool\Driver\Tag\Matroska\ChapterTimeEnd(),
                'CueRefTime' => new \PHPExiftool\Driver\Tag\Matroska\CueRefTime(),
                'CueRefCluster' => new \PHPExiftool\Driver\Tag\Matroska\CueRefCluster(),
                'ChapterFlagHidden' => new \PHPExiftool\Driver\Tag\Matroska\ChapterFlagHidden(),
                'VideoScanType' => new \PHPExiftool\Driver\Tag\Matroska\VideoScanType(),
                'BlockDuration' => new \PHPExiftool\Driver\Tag\Matroska\BlockDuration(),
                'TrackLacing' => new \PHPExiftool\Driver\Tag\Matroska\TrackLacing(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\Matroska\AudioChannels(),
                'Block' => new \PHPExiftool\Driver\Tag\Matroska\Block(),
                'BlockVirtual' => new \PHPExiftool\Driver\Tag\Matroska\BlockVirtual(),
                'SimpleBlock' => new \PHPExiftool\Driver\Tag\Matroska\SimpleBlock(),
                'CodecState' => new \PHPExiftool\Driver\Tag\Matroska\CodecState(),
                'BlockAdditional' => new \PHPExiftool\Driver\Tag\Matroska\BlockAdditional(),
                'Position' => new \PHPExiftool\Driver\Tag\Matroska\Position(),
                'CodecDecodeAll' => new \PHPExiftool\Driver\Tag\Matroska\CodecDecodeAll(),
                'PrevSize' => new \PHPExiftool\Driver\Tag\Matroska\PrevSize(),
                'EncryptedBlock' => new \PHPExiftool\Driver\Tag\Matroska\EncryptedBlock(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\Matroska\ImageWidth(),
                'CueTime' => new \PHPExiftool\Driver\Tag\Matroska\CueTime(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\Matroska\AudioSampleRate(),
                'TrackUsed' => new \PHPExiftool\Driver\Tag\Matroska\TrackUsed(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\Matroska\ImageHeight(),
                'CRC-32' => new \PHPExiftool\Driver\Tag\Matroska\CRC32(),
                'BlockAdditionalID' => new \PHPExiftool\Driver\Tag\Matroska\BlockAdditionalID(),
                'LaceNumber' => new \PHPExiftool\Driver\Tag\Matroska\LaceNumber(),
                'FrameNumber' => new \PHPExiftool\Driver\Tag\Matroska\FrameNumber(),
                'Delay' => new \PHPExiftool\Driver\Tag\Matroska\Delay(),
                'ClusterDuration' => new \PHPExiftool\Driver\Tag\Matroska\ClusterDuration(),
                'TrackNumber' => new \PHPExiftool\Driver\Tag\Matroska\TrackNumber(),
                'TimeCode' => new \PHPExiftool\Driver\Tag\Matroska\TimeCode(),
                'CueCodecState' => new \PHPExiftool\Driver\Tag\Matroska\CueCodecState(),
                'CueRefCodecState' => new \PHPExiftool\Driver\Tag\Matroska\CueRefCodecState(),
                'Void' => new \PHPExiftool\Driver\Tag\Matroska\Void(),
                'BlockAddID' => new \PHPExiftool\Driver\Tag\Matroska\BlockAddID(),
                'CueClusterPosition' => new \PHPExiftool\Driver\Tag\Matroska\CueClusterPosition(),
                'CueTrack' => new \PHPExiftool\Driver\Tag\Matroska\CueTrack(),
                'ReferencePriority' => new \PHPExiftool\Driver\Tag\Matroska\ReferencePriority(),
                'ReferenceBlock' => new \PHPExiftool\Driver\Tag\Matroska\ReferenceBlock(),
                'ReferenceVirtual' => new \PHPExiftool\Driver\Tag\Matroska\ReferenceVirtual(),
                'ContentCompressionAlgorithm' => new \PHPExiftool\Driver\Tag\Matroska\ContentCompressionAlgorithm(),
                'ContentCompressionSettings' => new \PHPExiftool\Driver\Tag\Matroska\ContentCompressionSettings(),
                'DocType' => new \PHPExiftool\Driver\Tag\Matroska\DocType(),
                'DocTypeReadVersion' => new \PHPExiftool\Driver\Tag\Matroska\DocTypeReadVersion(),
                'EBMLVersion' => new \PHPExiftool\Driver\Tag\Matroska\EBMLVersion(),
                'DocTypeVersion' => new \PHPExiftool\Driver\Tag\Matroska\DocTypeVersion(),
                'EBMLMaxIDLength' => new \PHPExiftool\Driver\Tag\Matroska\EBMLMaxIDLength(),
                'EBMLMaxSizeLength' => new \PHPExiftool\Driver\Tag\Matroska\EBMLMaxSizeLength(),
                'EBMLReadVersion' => new \PHPExiftool\Driver\Tag\Matroska\EBMLReadVersion(),
                'ChapterLanguage' => new \PHPExiftool\Driver\Tag\Matroska\ChapterLanguage(),
                'ChapterCountry' => new \PHPExiftool\Driver\Tag\Matroska\ChapterCountry(),
                'SegmentFamily' => new \PHPExiftool\Driver\Tag\Matroska\SegmentFamily(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\Matroska\DateTimeOriginal(),
                'TagLanguage' => new \PHPExiftool\Driver\Tag\Matroska\TagLanguage(),
                'TagDefault' => new \PHPExiftool\Driver\Tag\Matroska\TagDefault(),
                'TagBinary' => new \PHPExiftool\Driver\Tag\Matroska\TagBinary(),
                'TagString' => new \PHPExiftool\Driver\Tag\Matroska\TagString(),
                'Duration' => new \PHPExiftool\Driver\Tag\Matroska\Duration(),
                'ChapterProcessPrivate' => new \PHPExiftool\Driver\Tag\Matroska\ChapterProcessPrivate(),
                'ChapterFlagEnabled' => new \PHPExiftool\Driver\Tag\Matroska\ChapterFlagEnabled(),
                'TagName' => new \PHPExiftool\Driver\Tag\Matroska\TagName(),
                'EditionUID' => new \PHPExiftool\Driver\Tag\Matroska\EditionUID(),
                'EditionFlagHidden' => new \PHPExiftool\Driver\Tag\Matroska\EditionFlagHidden(),
                'EditionFlagDefault' => new \PHPExiftool\Driver\Tag\Matroska\EditionFlagDefault(),
                'EditionFlagOrdered' => new \PHPExiftool\Driver\Tag\Matroska\EditionFlagOrdered(),
                'AttachedFileData' => new \PHPExiftool\Driver\Tag\Matroska\AttachedFileData(),
                'AttachedFileMIMEType' => new \PHPExiftool\Driver\Tag\Matroska\AttachedFileMIMEType(),
                'AttachedFileName' => new \PHPExiftool\Driver\Tag\Matroska\AttachedFileName(),
                'AttachedFileReferral' => new \PHPExiftool\Driver\Tag\Matroska\AttachedFileReferral(),
                'AttachedFileDescription' => new \PHPExiftool\Driver\Tag\Matroska\AttachedFileDescription(),
                'AttachedFileUID' => new \PHPExiftool\Driver\Tag\Matroska\AttachedFileUID(),
                'ContentEncryptionAlgorithm' => new \PHPExiftool\Driver\Tag\Matroska\ContentEncryptionAlgorithm(),
                'ContentEncryptionKeyID' => new \PHPExiftool\Driver\Tag\Matroska\ContentEncryptionKeyID(),
                'ContentSignature' => new \PHPExiftool\Driver\Tag\Matroska\ContentSignature(),
                'ContentSignatureKeyID' => new \PHPExiftool\Driver\Tag\Matroska\ContentSignatureKeyID(),
                'ContentSignatureAlgorithm' => new \PHPExiftool\Driver\Tag\Matroska\ContentSignatureAlgorithm(),
                'ContentSignatureHashAlgorithm' => new \PHPExiftool\Driver\Tag\Matroska\ContentSignatureHashAlgorithm(),
                'MuxingApp' => new \PHPExiftool\Driver\Tag\Matroska\MuxingApp(),
                'ContentEncodingOrder' => new \PHPExiftool\Driver\Tag\Matroska\ContentEncodingOrder(),
                'ContentEncodingScope' => new \PHPExiftool\Driver\Tag\Matroska\ContentEncodingScope(),
                'ContentEncodingType' => new \PHPExiftool\Driver\Tag\Matroska\ContentEncodingType(),
                'CueRefNumber' => new \PHPExiftool\Driver\Tag\Matroska\CueRefNumber(),
                'TrackName' => new \PHPExiftool\Driver\Tag\Matroska\TrackName(),
                'CueBlockNumber' => new \PHPExiftool\Driver\Tag\Matroska\CueBlockNumber(),
                'TrackOffset' => new \PHPExiftool\Driver\Tag\Matroska\TrackOffset(),
                'SeekID' => new \PHPExiftool\Driver\Tag\Matroska\SeekID(),
                'SeekPosition' => new \PHPExiftool\Driver\Tag\Matroska\SeekPosition(),
                'Stereo3DMode' => new \PHPExiftool\Driver\Tag\Matroska\Stereo3DMode(),
                'CropBottom' => new \PHPExiftool\Driver\Tag\Matroska\CropBottom(),
                'DisplayWidth' => new \PHPExiftool\Driver\Tag\Matroska\DisplayWidth(),
                'DisplayUnit' => new \PHPExiftool\Driver\Tag\Matroska\DisplayUnit(),
                'AspectRatioType' => new \PHPExiftool\Driver\Tag\Matroska\AspectRatioType(),
                'DisplayHeight' => new \PHPExiftool\Driver\Tag\Matroska\DisplayHeight(),
                'CropTop' => new \PHPExiftool\Driver\Tag\Matroska\CropTop(),
                'CropLeft' => new \PHPExiftool\Driver\Tag\Matroska\CropLeft(),
                'CropRight' => new \PHPExiftool\Driver\Tag\Matroska\CropRight(),
                'TrackForced' => new \PHPExiftool\Driver\Tag\Matroska\TrackForced(),
                'MaxBlockAdditionID' => new \PHPExiftool\Driver\Tag\Matroska\MaxBlockAdditionID(),
                'WritingApp' => new \PHPExiftool\Driver\Tag\Matroska\WritingApp(),
                'SilentTrackNumber' => new \PHPExiftool\Driver\Tag\Matroska\SilentTrackNumber(),
                'AudioBitsPerSample' => new \PHPExiftool\Driver\Tag\Matroska\AudioBitsPerSample(),
                'CodecPrivate' => new \PHPExiftool\Driver\Tag\Matroska\CodecPrivate(),
                'ChapterPhysicalEquivalent' => new \PHPExiftool\Driver\Tag\Matroska\ChapterPhysicalEquivalent(),
                'TagChapterUID' => new \PHPExiftool\Driver\Tag\Matroska\TagChapterUID(),
                'TagTrackUID' => new \PHPExiftool\Driver\Tag\Matroska\TagTrackUID(),
                'TagAttachmentUID' => new \PHPExiftool\Driver\Tag\Matroska\TagAttachmentUID(),
                'TagEditionUID' => new \PHPExiftool\Driver\Tag\Matroska\TagEditionUID(),
                'TargetType' => new \PHPExiftool\Driver\Tag\Matroska\TargetType(),
                'SignedElement' => new \PHPExiftool\Driver\Tag\Matroska\SignedElement(),
                'TrackTranslateTrackID' => new \PHPExiftool\Driver\Tag\Matroska\TrackTranslateTrackID(),
                'TrackTranslateCodec' => new \PHPExiftool\Driver\Tag\Matroska\TrackTranslateCodec(),
                'TrackTranslateEditionUID' => new \PHPExiftool\Driver\Tag\Matroska\TrackTranslateEditionUID(),
                'TargetTypeValue' => new \PHPExiftool\Driver\Tag\Matroska\TargetTypeValue(),
                'ChapterProcessTime' => new \PHPExiftool\Driver\Tag\Matroska\ChapterProcessTime(),
                'ChapterProcessData' => new \PHPExiftool\Driver\Tag\Matroska\ChapterProcessData(),
                'ChapterProcessCodecID' => new \PHPExiftool\Driver\Tag\Matroska\ChapterProcessCodecID(),
                'ChapterTranslateID' => new \PHPExiftool\Driver\Tag\Matroska\ChapterTranslateID(),
                'ChapterTranslateCodec' => new \PHPExiftool\Driver\Tag\Matroska\ChapterTranslateCodec(),
                'ChapterTranslateEditionUID' => new \PHPExiftool\Driver\Tag\Matroska\ChapterTranslateEditionUID(),
                'MinCache' => new \PHPExiftool\Driver\Tag\Matroska\MinCache(),
                'MaxCache' => new \PHPExiftool\Driver\Tag\Matroska\MaxCache(),
                'ChapterSegmentUID' => new \PHPExiftool\Driver\Tag\Matroska\ChapterSegmentUID(),
                'ChapterSegmentEditionUID' => new \PHPExiftool\Driver\Tag\Matroska\ChapterSegmentEditionUID(),
                'TrackOverlay' => new \PHPExiftool\Driver\Tag\Matroska\TrackOverlay(),
                'SegmentFileName' => new \PHPExiftool\Driver\Tag\Matroska\SegmentFileName(),
                'SegmentUID' => new \PHPExiftool\Driver\Tag\Matroska\SegmentUID(),
                'ChapterUID' => new \PHPExiftool\Driver\Tag\Matroska\ChapterUID(),
                'TrackUID' => new \PHPExiftool\Driver\Tag\Matroska\TrackUID(),
                'TrackAttachmentUID' => new \PHPExiftool\Driver\Tag\Matroska\TrackAttachmentUID(),
                'OutputAudioSampleRate' => new \PHPExiftool\Driver\Tag\Matroska\OutputAudioSampleRate(),
                'Title' => new \PHPExiftool\Driver\Tag\Matroska\Title(),
                'ChannelPositions' => new \PHPExiftool\Driver\Tag\Matroska\ChannelPositions(),
                'SignatureAlgo' => new \PHPExiftool\Driver\Tag\Matroska\SignatureAlgo(),
                'SignatureHash' => new \PHPExiftool\Driver\Tag\Matroska\SignatureHash(),
                'SignaturePublicKey' => new \PHPExiftool\Driver\Tag\Matroska\SignaturePublicKey(),
                'Signature' => new \PHPExiftool\Driver\Tag\Matroska\Signature(),
                'TrackLanguage' => new \PHPExiftool\Driver\Tag\Matroska\TrackLanguage(),
                'TrackTimecodeScale' => new \PHPExiftool\Driver\Tag\Matroska\TrackTimecodeScale(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\Matroska\FrameRate(),
                'VideoFrameRate' => new \PHPExiftool\Driver\Tag\Matroska\VideoFrameRate(),
                'DefaultDuration' => new \PHPExiftool\Driver\Tag\Matroska\DefaultDuration(),
                'VideoCodecName' => new \PHPExiftool\Driver\Tag\Matroska\VideoCodecName(),
                'AudioCodecName' => new \PHPExiftool\Driver\Tag\Matroska\AudioCodecName(),
                'CodecName' => new \PHPExiftool\Driver\Tag\Matroska\CodecName(),
                'CodecDownloadURL' => new \PHPExiftool\Driver\Tag\Matroska\CodecDownloadURL(),
                'TimecodeScale' => new \PHPExiftool\Driver\Tag\Matroska\TimecodeScale(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\Matroska\ColorSpace(),
                'Gamma' => new \PHPExiftool\Driver\Tag\Matroska\Gamma(),
                'CodecSettings' => new \PHPExiftool\Driver\Tag\Matroska\CodecSettings(),
                'CodecInfoURL' => new \PHPExiftool\Driver\Tag\Matroska\CodecInfoURL(),
                'PrevFileName' => new \PHPExiftool\Driver\Tag\Matroska\PrevFileName(),
                'PrevUID' => new \PHPExiftool\Driver\Tag\Matroska\PrevUID(),
                'NextFileName' => new \PHPExiftool\Driver\Tag\Matroska\NextFileName(),
                'NextUID' => new \PHPExiftool\Driver\Tag\Matroska\NextUID(),
            );
        });
        $this['XMP-MP'] = $this->share(function(){
            return array(
                'RegionInfoMP' => new \PHPExiftool\Driver\Tag\XMPMP\RegionInfoMP(),
                'RegionInfoDateRegionsValid' => new \PHPExiftool\Driver\Tag\XMPMP\RegionInfoDateRegionsValid(),
                'RegionInfoRegions' => new \PHPExiftool\Driver\Tag\XMPMP\RegionInfoRegions(),
                'RegionPersonDisplayName' => new \PHPExiftool\Driver\Tag\XMPMP\RegionPersonDisplayName(),
                'RegionPersonEmailDigest' => new \PHPExiftool\Driver\Tag\XMPMP\RegionPersonEmailDigest(),
                'RegionPersonLiveIdCID' => new \PHPExiftool\Driver\Tag\XMPMP\RegionPersonLiveIdCID(),
                'RegionPersonSourceID' => new \PHPExiftool\Driver\Tag\XMPMP\RegionPersonSourceID(),
                'RegionRectangle' => new \PHPExiftool\Driver\Tag\XMPMP\RegionRectangle(),
            );
        });
        $this['XMP-MP1'] = $this->share(function(){
            return array(
                'Brightness' => new \PHPExiftool\Driver\Tag\XMPMP1\Brightness(),
                'CameraModelID' => new \PHPExiftool\Driver\Tag\XMPMP1\CameraModelID(),
                'Contrast' => new \PHPExiftool\Driver\Tag\XMPMP1\Contrast(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\XMPMP1\ExposureCompensation(),
                'PanoramicStitchCameraMotion' => new \PHPExiftool\Driver\Tag\XMPMP1\PanoramicStitchCameraMotion(),
                'PanoramicStitchMapType' => new \PHPExiftool\Driver\Tag\XMPMP1\PanoramicStitchMapType(),
                'PanoramicStitchPhi0' => new \PHPExiftool\Driver\Tag\XMPMP1\PanoramicStitchPhi0(),
                'PanoramicStitchPhi1' => new \PHPExiftool\Driver\Tag\XMPMP1\PanoramicStitchPhi1(),
                'PanoramicStitchTheta0' => new \PHPExiftool\Driver\Tag\XMPMP1\PanoramicStitchTheta0(),
                'PanoramicStitchTheta1' => new \PHPExiftool\Driver\Tag\XMPMP1\PanoramicStitchTheta1(),
                'PipelineVersion' => new \PHPExiftool\Driver\Tag\XMPMP1\PipelineVersion(),
                'StreamType' => new \PHPExiftool\Driver\Tag\XMPMP1\StreamType(),
                'WhiteBalance0' => new \PHPExiftool\Driver\Tag\XMPMP1\WhiteBalance0(),
                'WhiteBalance1' => new \PHPExiftool\Driver\Tag\XMPMP1\WhiteBalance1(),
                'WhiteBalance2' => new \PHPExiftool\Driver\Tag\XMPMP1\WhiteBalance2(),
            );
        });
        $this['Microsoft'] = $this->share(function(){
            return array(
                'PanoramicStitchVersion' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchVersion(),
                'PanoramicStitchCameraMotion' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchCameraMotion(),
                'PanoramicStitchMapType' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchMapType(),
                'PanoramicStitchTheta0' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchTheta0(),
                'PanoramicStitchTheta1' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchTheta1(),
                'PanoramicStitchPhi0' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchPhi0(),
                'PanoramicStitchPhi1' => new \PHPExiftool\Driver\Tag\Microsoft\PanoramicStitchPhi1(),
                'Abstract' => new \PHPExiftool\Driver\Tag\Microsoft\Abstract0(),
                'AcquisitionTime' => new \PHPExiftool\Driver\Tag\Microsoft\AcquisitionTime(),
                'AcquisitionTimeDay' => new \PHPExiftool\Driver\Tag\Microsoft\AcquisitionTimeDay(),
                'AcquisitionTimeMonth' => new \PHPExiftool\Driver\Tag\Microsoft\AcquisitionTimeMonth(),
                'AcquisitionTimeYear' => new \PHPExiftool\Driver\Tag\Microsoft\AcquisitionTimeYear(),
                'AcquisitionTimeYearMonth' => new \PHPExiftool\Driver\Tag\Microsoft\AcquisitionTimeYearMonth(),
                'AcquisitionTimeYearMonthDay' => new \PHPExiftool\Driver\Tag\Microsoft\AcquisitionTimeYearMonthDay(),
                'AlbumArtistSortOrder' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumArtistSortOrder(),
                'AlbumID' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumID(),
                'AlbumIDAlbumArtist' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumIDAlbumArtist(),
                'AlbumTitleSortOrder' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumTitleSortOrder(),
                'AlternateSourceURL' => new \PHPExiftool\Driver\Tag\Microsoft\AlternateSourceURL(),
                'AudioBitrate' => new \PHPExiftool\Driver\Tag\Microsoft\AudioBitrate(),
                'AudioFormat' => new \PHPExiftool\Driver\Tag\Microsoft\AudioFormat(),
                'Author' => new \PHPExiftool\Driver\Tag\Microsoft\Author(),
                'AuthorSortOrder' => new \PHPExiftool\Driver\Tag\Microsoft\AuthorSortOrder(),
                'AverageLevel' => new \PHPExiftool\Driver\Tag\Microsoft\AverageLevel(),
                'Bitrate' => new \PHPExiftool\Driver\Tag\Microsoft\Bitrate(),
                'BuyNow' => new \PHPExiftool\Driver\Tag\Microsoft\BuyNow(),
                'BuyTickets' => new \PHPExiftool\Driver\Tag\Microsoft\BuyTickets(),
                'CDTrackEnabled' => new \PHPExiftool\Driver\Tag\Microsoft\CDTrackEnabled(),
                'CallLetters' => new \PHPExiftool\Driver\Tag\Microsoft\CallLetters(),
                'CameraManufacturer' => new \PHPExiftool\Driver\Tag\Microsoft\CameraManufacturer(),
                'CameraModel' => new \PHPExiftool\Driver\Tag\Microsoft\CameraModel(),
                'Channels' => new \PHPExiftool\Driver\Tag\Microsoft\Channels(),
                'Comment' => new \PHPExiftool\Driver\Tag\Microsoft\Comment(),
                'ContentDistributorDuration' => new \PHPExiftool\Driver\Tag\Microsoft\ContentDistributorDuration(),
                'Copyright' => new \PHPExiftool\Driver\Tag\Microsoft\Copyright(),
                'Count' => new \PHPExiftool\Driver\Tag\Microsoft\Count(),
                'CurrentBitrate' => new \PHPExiftool\Driver\Tag\Microsoft\CurrentBitrate(),
                'DLNAServerUDN' => new \PHPExiftool\Driver\Tag\Microsoft\DLNAServerUDN(),
                'DLNASourceURI' => new \PHPExiftool\Driver\Tag\Microsoft\DLNASourceURI(),
                'DRMIndividualizedVersion' => new \PHPExiftool\Driver\Tag\Microsoft\DRMIndividualizedVersion(),
                'DRMKeyID' => new \PHPExiftool\Driver\Tag\Microsoft\DRMKeyID(),
                'DTCPIPHost' => new \PHPExiftool\Driver\Tag\Microsoft\DTCPIPHost(),
                'DTCPIPPort' => new \PHPExiftool\Driver\Tag\Microsoft\DTCPIPPort(),
                'DVDID' => new \PHPExiftool\Driver\Tag\Microsoft\DVDID(),
                'Description' => new \PHPExiftool\Driver\Tag\Microsoft\Description(),
                'DisplayArtist' => new \PHPExiftool\Driver\Tag\Microsoft\DisplayArtist(),
                'Duration' => new \PHPExiftool\Driver\Tag\Microsoft\Duration(),
                'Event' => new \PHPExiftool\Driver\Tag\Microsoft\Event(),
                'FileSize' => new \PHPExiftool\Driver\Tag\Microsoft\FileSize(),
                'FileType' => new \PHPExiftool\Driver\Tag\Microsoft\FileType(),
                'FormatTag' => new \PHPExiftool\Driver\Tag\Microsoft\FormatTag(),
                'FourCC' => new \PHPExiftool\Driver\Tag\Microsoft\FourCC(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\Microsoft\FrameRate(),
                'Frequency' => new \PHPExiftool\Driver\Tag\Microsoft\Frequency(),
                'IsNetworkFeed' => new \PHPExiftool\Driver\Tag\Microsoft\IsNetworkFeed(),
                'IsVBR' => new \PHPExiftool\Driver\Tag\Microsoft\IsVBR(),
                'IsProtected' => new \PHPExiftool\Driver\Tag\Microsoft\IsProtected(),
                'LeadPerformer' => new \PHPExiftool\Driver\Tag\Microsoft\LeadPerformer(),
                'LibraryID' => new \PHPExiftool\Driver\Tag\Microsoft\LibraryID(),
                'LibraryName' => new \PHPExiftool\Driver\Tag\Microsoft\LibraryName(),
                'Location' => new \PHPExiftool\Driver\Tag\Microsoft\Location(),
                'MediaContentTypes' => new \PHPExiftool\Driver\Tag\Microsoft\MediaContentTypes(),
                'MediaType' => new \PHPExiftool\Driver\Tag\Microsoft\MediaType(),
                'ModifiedBy' => new \PHPExiftool\Driver\Tag\Microsoft\ModifiedBy(),
                'MoreInfo' => new \PHPExiftool\Driver\Tag\Microsoft\MoreInfo(),
                'PartOfSet' => new \PHPExiftool\Driver\Tag\Microsoft\PartOfSet(),
                'PeakValue' => new \PHPExiftool\Driver\Tag\Microsoft\PeakValue(),
                'PixelAspectRatioX' => new \PHPExiftool\Driver\Tag\Microsoft\PixelAspectRatioX(),
                'PixelAspectRatioY' => new \PHPExiftool\Driver\Tag\Microsoft\PixelAspectRatioY(),
                'PlaylistIndex' => new \PHPExiftool\Driver\Tag\Microsoft\PlaylistIndex(),
                'Provider' => new \PHPExiftool\Driver\Tag\Microsoft\Provider(),
                'ProviderLogoURL' => new \PHPExiftool\Driver\Tag\Microsoft\ProviderLogoURL(),
                'ProviderURL' => new \PHPExiftool\Driver\Tag\Microsoft\ProviderURL(),
                'RadioBand' => new \PHPExiftool\Driver\Tag\Microsoft\RadioBand(),
                'RadioFormat' => new \PHPExiftool\Driver\Tag\Microsoft\RadioFormat(),
                'RatingOrg' => new \PHPExiftool\Driver\Tag\Microsoft\RatingOrg(),
                'RecordingTime' => new \PHPExiftool\Driver\Tag\Microsoft\RecordingTime(),
                'RecordingTimeDay' => new \PHPExiftool\Driver\Tag\Microsoft\RecordingTimeDay(),
                'RecordingTimeMonth' => new \PHPExiftool\Driver\Tag\Microsoft\RecordingTimeMonth(),
                'RecordingTimeYear' => new \PHPExiftool\Driver\Tag\Microsoft\RecordingTimeYear(),
                'RecordingTimeYearMonth' => new \PHPExiftool\Driver\Tag\Microsoft\RecordingTimeYearMonth(),
                'RecordingTimeYearMonthDay' => new \PHPExiftool\Driver\Tag\Microsoft\RecordingTimeYearMonthDay(),
                'ReleaseDate' => new \PHPExiftool\Driver\Tag\Microsoft\ReleaseDate(),
                'ReleaseDateDay' => new \PHPExiftool\Driver\Tag\Microsoft\ReleaseDateDay(),
                'ReleaseDateMonth' => new \PHPExiftool\Driver\Tag\Microsoft\ReleaseDateMonth(),
                'ReleaseDateYear' => new \PHPExiftool\Driver\Tag\Microsoft\ReleaseDateYear(),
                'ReleaseDateYearMonth' => new \PHPExiftool\Driver\Tag\Microsoft\ReleaseDateYearMonth(),
                'ReleaseDateYearMonthDay' => new \PHPExiftool\Driver\Tag\Microsoft\ReleaseDateYearMonthDay(),
                'RequestState' => new \PHPExiftool\Driver\Tag\Microsoft\RequestState(),
                'ShadowFilePath' => new \PHPExiftool\Driver\Tag\Microsoft\ShadowFilePath(),
                'SourceURL' => new \PHPExiftool\Driver\Tag\Microsoft\SourceURL(),
                'Subject' => new \PHPExiftool\Driver\Tag\Microsoft\Subject(),
                'Sync01' => new \PHPExiftool\Driver\Tag\Microsoft\Sync01(),
                'Sync02' => new \PHPExiftool\Driver\Tag\Microsoft\Sync02(),
                'Sync03' => new \PHPExiftool\Driver\Tag\Microsoft\Sync03(),
                'Sync04' => new \PHPExiftool\Driver\Tag\Microsoft\Sync04(),
                'Sync05' => new \PHPExiftool\Driver\Tag\Microsoft\Sync05(),
                'Sync06' => new \PHPExiftool\Driver\Tag\Microsoft\Sync06(),
                'Sync07' => new \PHPExiftool\Driver\Tag\Microsoft\Sync07(),
                'Sync08' => new \PHPExiftool\Driver\Tag\Microsoft\Sync08(),
                'Sync09' => new \PHPExiftool\Driver\Tag\Microsoft\Sync09(),
                'Sync10' => new \PHPExiftool\Driver\Tag\Microsoft\Sync10(),
                'Sync11' => new \PHPExiftool\Driver\Tag\Microsoft\Sync11(),
                'Sync12' => new \PHPExiftool\Driver\Tag\Microsoft\Sync12(),
                'Sync13' => new \PHPExiftool\Driver\Tag\Microsoft\Sync13(),
                'Sync14' => new \PHPExiftool\Driver\Tag\Microsoft\Sync14(),
                'Sync15' => new \PHPExiftool\Driver\Tag\Microsoft\Sync15(),
                'Sync16' => new \PHPExiftool\Driver\Tag\Microsoft\Sync16(),
                'SyncOnly' => new \PHPExiftool\Driver\Tag\Microsoft\SyncOnly(),
                'SyncState' => new \PHPExiftool\Driver\Tag\Microsoft\SyncState(),
                'Temporary' => new \PHPExiftool\Driver\Tag\Microsoft\Temporary(),
                'Title' => new \PHPExiftool\Driver\Tag\Microsoft\Title(),
                'TitleSortOrder' => new \PHPExiftool\Driver\Tag\Microsoft\TitleSortOrder(),
                'TotalDuration' => new \PHPExiftool\Driver\Tag\Microsoft\TotalDuration(),
                'TrackingID' => new \PHPExiftool\Driver\Tag\Microsoft\TrackingID(),
                'UserCustom1' => new \PHPExiftool\Driver\Tag\Microsoft\UserCustom1(),
                'UserCustom2' => new \PHPExiftool\Driver\Tag\Microsoft\UserCustom2(),
                'UserEffectiveRating' => new \PHPExiftool\Driver\Tag\Microsoft\UserEffectiveRating(),
                'UserLastPlayedTime' => new \PHPExiftool\Driver\Tag\Microsoft\UserLastPlayedTime(),
                'UserPlayCount' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlayCount(),
                'UserPlaycountAfternoon' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlaycountAfternoon(),
                'UserPlaycountEvening' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlaycountEvening(),
                'UserPlaycountMorning' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlaycountMorning(),
                'UserPlaycountNight' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlaycountNight(),
                'UserPlaycountWeekday' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlaycountWeekday(),
                'UserPlaycountWeekend' => new \PHPExiftool\Driver\Tag\Microsoft\UserPlaycountWeekend(),
                'UserRating' => new \PHPExiftool\Driver\Tag\Microsoft\UserRating(),
                'UserServiceRating' => new \PHPExiftool\Driver\Tag\Microsoft\UserServiceRating(),
                'VideoBitrate' => new \PHPExiftool\Driver\Tag\Microsoft\VideoBitrate(),
                'VideoFormat' => new \PHPExiftool\Driver\Tag\Microsoft\VideoFormat(),
                'AlbumArtist' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumArtist(),
                'AlbumCoverURL' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumCoverURL(),
                'AlbumTitle' => new \PHPExiftool\Driver\Tag\Microsoft\AlbumTitle(),
                'mixed' => new \PHPExiftool\Driver\Tag\Microsoft\BeatsPerMinute(),
                'Category' => new \PHPExiftool\Driver\Tag\Microsoft\Category(),
                'Composer' => new \PHPExiftool\Driver\Tag\Microsoft\Composer(),
                'Conductor' => new \PHPExiftool\Driver\Tag\Microsoft\Conductor(),
                'ContentDistributor' => new \PHPExiftool\Driver\Tag\Microsoft\ContentDistributor(),
                'ContentDistributorType' => new \PHPExiftool\Driver\Tag\Microsoft\ContentDistributorType(),
                'ContentGroupDescription' => new \PHPExiftool\Driver\Tag\Microsoft\ContentGroupDescription(),
                'Director' => new \PHPExiftool\Driver\Tag\Microsoft\Director(),
                'EncodingTime' => new \PHPExiftool\Driver\Tag\Microsoft\EncodingTime(),
                'Genre' => new \PHPExiftool\Driver\Tag\Microsoft\Genre(),
                'GenreID' => new \PHPExiftool\Driver\Tag\Microsoft\GenreID(),
                'InitialKey' => new \PHPExiftool\Driver\Tag\Microsoft\InitialKey(),
                'Language' => new \PHPExiftool\Driver\Tag\Microsoft\Language(),
                'Lyrics' => new \PHPExiftool\Driver\Tag\Microsoft\Lyrics(),
                'MCDI' => new \PHPExiftool\Driver\Tag\Microsoft\MCDI(),
                'MediaClassPrimaryID' => new \PHPExiftool\Driver\Tag\Microsoft\MediaClassPrimaryID(),
                'MediaClassSecondaryID' => new \PHPExiftool\Driver\Tag\Microsoft\MediaClassSecondaryID(),
                'MediaOriginalBroadcastDateTime' => new \PHPExiftool\Driver\Tag\Microsoft\MediaOriginalBroadcastDateTime(),
                'MediaOriginalChannel' => new \PHPExiftool\Driver\Tag\Microsoft\MediaOriginalChannel(),
                'MediaStationName' => new \PHPExiftool\Driver\Tag\Microsoft\MediaStationName(),
                'Mood' => new \PHPExiftool\Driver\Tag\Microsoft\Mood(),
                'OriginalAlbumTitle' => new \PHPExiftool\Driver\Tag\Microsoft\OriginalAlbumTitle(),
                'OriginalArtist' => new \PHPExiftool\Driver\Tag\Microsoft\OriginalArtist(),
                'OriginalLyricist' => new \PHPExiftool\Driver\Tag\Microsoft\OriginalLyricist(),
                'ParentalRating' => new \PHPExiftool\Driver\Tag\Microsoft\ParentalRating(),
                'Period' => new \PHPExiftool\Driver\Tag\Microsoft\Period(),
                'Producer' => new \PHPExiftool\Driver\Tag\Microsoft\Producer(),
                'ProtectionType' => new \PHPExiftool\Driver\Tag\Microsoft\ProtectionType(),
                'ProviderRating' => new \PHPExiftool\Driver\Tag\Microsoft\ProviderRating(),
                'ProviderStyle' => new \PHPExiftool\Driver\Tag\Microsoft\ProviderStyle(),
                'Publisher' => new \PHPExiftool\Driver\Tag\Microsoft\Publisher(),
                'SharedUserRating' => new \PHPExiftool\Driver\Tag\Microsoft\SharedUserRating(),
                'Subtitle' => new \PHPExiftool\Driver\Tag\Microsoft\Subtitle(),
                'SubtitleDescription' => new \PHPExiftool\Driver\Tag\Microsoft\SubtitleDescription(),
                'SubscriptionContentID' => new \PHPExiftool\Driver\Tag\Microsoft\SubscriptionContentID(),
                'TrackNumber' => new \PHPExiftool\Driver\Tag\Microsoft\TrackNumber(),
                'UniqueFileIdentifier' => new \PHPExiftool\Driver\Tag\Microsoft\UniqueFileIdentifier(),
                'VideoFrameRate' => new \PHPExiftool\Driver\Tag\Microsoft\VideoFrameRate(),
                'VideoHeight' => new \PHPExiftool\Driver\Tag\Microsoft\VideoHeight(),
                'VideoWidth' => new \PHPExiftool\Driver\Tag\Microsoft\VideoWidth(),
                'WMCollectionGroupID' => new \PHPExiftool\Driver\Tag\Microsoft\WMCollectionGroupID(),
                'WMCollectionID' => new \PHPExiftool\Driver\Tag\Microsoft\WMCollectionID(),
                'WMContentID' => new \PHPExiftool\Driver\Tag\Microsoft\WMContentID(),
                'WMShadowFileSourceDRMType' => new \PHPExiftool\Driver\Tag\Microsoft\WMShadowFileSourceDRMType(),
                'WMShadowFileSourceFileType' => new \PHPExiftool\Driver\Tag\Microsoft\WMShadowFileSourceFileType(),
                'Writer' => new \PHPExiftool\Driver\Tag\Microsoft\Writer(),
                'Year' => new \PHPExiftool\Driver\Tag\Microsoft\Year(),
                'ChapterNum' => new \PHPExiftool\Driver\Tag\Microsoft\ChapterNum(),
                'TitleNum' => new \PHPExiftool\Driver\Tag\Microsoft\TitleNum(),
                'Resources' => new \PHPExiftool\Driver\Tag\Microsoft\Resources(),
                'Complete' => new \PHPExiftool\Driver\Tag\Microsoft\Complete(),
                'HomeCountry-Region' => new \PHPExiftool\Driver\Tag\Microsoft\HomeCountryRegion(),
                'TaskOwner' => new \PHPExiftool\Driver\Tag\Microsoft\TaskOwner(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\Microsoft\MaxAperture(),
                'OptionalAttendees' => new \PHPExiftool\Driver\Tag\Microsoft\OptionalAttendees(),
                'HomeStreet' => new \PHPExiftool\Driver\Tag\Microsoft\HomeStreet(),
                'RequiredAttendeeAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\RequiredAttendeeAddresses(),
                'SenderAddress' => new \PHPExiftool\Driver\Tag\Microsoft\SenderAddress(),
                'FileVersion' => new \PHPExiftool\Driver\Tag\Microsoft\FileVersion(),
                'ProductName' => new \PHPExiftool\Driver\Tag\Microsoft\ProductName(),
                'ProductVersion' => new \PHPExiftool\Driver\Tag\Microsoft\ProductVersion(),
                'LegalTrademarks' => new \PHPExiftool\Driver\Tag\Microsoft\LegalTrademarks(),
                'SenderName' => new \PHPExiftool\Driver\Tag\Microsoft\SenderName(),
                'ParentalRatingReason' => new \PHPExiftool\Driver\Tag\Microsoft\ParentalRatingReason(),
                'FirstName' => new \PHPExiftool\Driver\Tag\Microsoft\FirstName(),
                'DateImported' => new \PHPExiftool\Driver\Tag\Microsoft\DateImported(),
                'CameraMaker' => new \PHPExiftool\Driver\Tag\Microsoft\CameraMaker(),
                'Orientation' => new \PHPExiftool\Driver\Tag\Microsoft\Orientation(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\Microsoft\ExposureTime(),
                'F-stop' => new \PHPExiftool\Driver\Tag\Microsoft\FStop(),
                'ExposureProgram' => new \PHPExiftool\Driver\Tag\Microsoft\ExposureProgram(),
                'ISOSpeed' => new \PHPExiftool\Driver\Tag\Microsoft\ISOSpeed(),
                'DatePictureTaken' => new \PHPExiftool\Driver\Tag\Microsoft\DatePictureTaken(),
                'ExposureBias' => new \PHPExiftool\Driver\Tag\Microsoft\ExposureBias(),
                'SubjectDistance' => new \PHPExiftool\Driver\Tag\Microsoft\SubjectDistance(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\Microsoft\MeteringMode(),
                'LightSource' => new \PHPExiftool\Driver\Tag\Microsoft\LightSource(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\Microsoft\FlashMode(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Microsoft\FocalLength(),
                'HomePhone' => new \PHPExiftool\Driver\Tag\Microsoft\HomePhone(),
                'PrimaryPhone' => new \PHPExiftool\Driver\Tag\Microsoft\PrimaryPhone(),
                'CellPhone' => new \PHPExiftool\Driver\Tag\Microsoft\CellPhone(),
                'Birthday' => new \PHPExiftool\Driver\Tag\Microsoft\Birthday(),
                'PrimaryE-mail' => new \PHPExiftool\Driver\Tag\Microsoft\PrimaryEMail(),
                'JobTitle' => new \PHPExiftool\Driver\Tag\Microsoft\JobTitle(),
                'HomeCity' => new \PHPExiftool\Driver\Tag\Microsoft\HomeCity(),
                'PersonalTitle' => new \PHPExiftool\Driver\Tag\Microsoft\PersonalTitle(),
                'OfficeLocation' => new \PHPExiftool\Driver\Tag\Microsoft\OfficeLocation(),
                'GivenName' => new \PHPExiftool\Driver\Tag\Microsoft\GivenName(),
                'MiddleName' => new \PHPExiftool\Driver\Tag\Microsoft\MiddleName(),
                'Suffix' => new \PHPExiftool\Driver\Tag\Microsoft\Suffix(),
                'Nickname' => new \PHPExiftool\Driver\Tag\Microsoft\Nickname(),
                'PostalCode' => new \PHPExiftool\Driver\Tag\Microsoft\PostalCode(),
                'StationName' => new \PHPExiftool\Driver\Tag\Microsoft\StationName(),
                'Division' => new \PHPExiftool\Driver\Tag\Microsoft\Division(),
                'Kinds' => new \PHPExiftool\Driver\Tag\Microsoft\Kinds(),
                'ClientID' => new \PHPExiftool\Driver\Tag\Microsoft\ClientID(),
                'Type' => new \PHPExiftool\Driver\Tag\Microsoft\Type(),
                'FileCount' => new \PHPExiftool\Driver\Tag\Microsoft\FileCount(),
                'TotalFileSize' => new \PHPExiftool\Driver\Tag\Microsoft\TotalFileSize(),
                'Computer' => new \PHPExiftool\Driver\Tag\Microsoft\Computer(),
                'PerceivedType' => new \PHPExiftool\Driver\Tag\Microsoft\PerceivedType(),
                'DateAcquired' => new \PHPExiftool\Driver\Tag\Microsoft\DateAcquired(),
                'MediaCreated' => new \PHPExiftool\Driver\Tag\Microsoft\MediaCreated(),
                'IsRecurring' => new \PHPExiftool\Driver\Tag\Microsoft\IsRecurring(),
                'Incomplete' => new \PHPExiftool\Driver\Tag\Microsoft\Incomplete(),
                'E-mail2' => new \PHPExiftool\Driver\Tag\Microsoft\EMail2(),
                'Project' => new \PHPExiftool\Driver\Tag\Microsoft\Project(),
                'Gender' => new \PHPExiftool\Driver\Tag\Microsoft\Gender(),
                'DueDate' => new \PHPExiftool\Driver\Tag\Microsoft\DueDate(),
                'BusinessCity' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessCity(),
                'WindowsFileName' => new \PHPExiftool\Driver\Tag\Microsoft\WindowsFileName(),
                'DateArchived' => new \PHPExiftool\Driver\Tag\Microsoft\DateArchived(),
                'BusinessStateOrProvince' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessStateOrProvince(),
                'BroadcastDate' => new \PHPExiftool\Driver\Tag\Microsoft\BroadcastDate(),
                'Color' => new \PHPExiftool\Driver\Tag\Microsoft\Color(),
                'StartDate' => new \PHPExiftool\Driver\Tag\Microsoft\StartDate(),
                'Saturation' => new \PHPExiftool\Driver\Tag\Microsoft\Saturation(),
                'SearchRanking' => new \PHPExiftool\Driver\Tag\Microsoft\SearchRanking(),
                'OtherAddress' => new \PHPExiftool\Driver\Tag\Microsoft\OtherAddress(),
                'AutoSummary' => new \PHPExiftool\Driver\Tag\Microsoft\AutoSummary(),
                'Summary' => new \PHPExiftool\Driver\Tag\Microsoft\Summary(),
                'BusinessHomePage' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessHomePage(),
                'Artist' => new \PHPExiftool\Driver\Tag\Microsoft\Artist(),
                'Conductors' => new \PHPExiftool\Driver\Tag\Microsoft\Conductors(),
                'Free-busyStatus' => new \PHPExiftool\Driver\Tag\Microsoft\FreeBusyStatus(),
                'URL' => new \PHPExiftool\Driver\Tag\Microsoft\URL(),
                'DateVisited' => new \PHPExiftool\Driver\Tag\Microsoft\DateVisited(),
                'IsDeleted' => new \PHPExiftool\Driver\Tag\Microsoft\IsDeleted(),
                'HasFlag' => new \PHPExiftool\Driver\Tag\Microsoft\HasFlag(),
                'Hobbies' => new \PHPExiftool\Driver\Tag\Microsoft\Hobbies(),
                'FullName' => new \PHPExiftool\Driver\Tag\Microsoft\FullName(),
                'Street' => new \PHPExiftool\Driver\Tag\Microsoft\Street(),
                'Dimensions' => new \PHPExiftool\Driver\Tag\Microsoft\Dimensions(),
                'Untitled0' => new \PHPExiftool\Driver\Tag\Microsoft\Untitled0(),
                'Untitled1' => new \PHPExiftool\Driver\Tag\Microsoft\Untitled1(),
                'HorizontalResolution' => new \PHPExiftool\Driver\Tag\Microsoft\HorizontalResolution(),
                'VerticalResolution' => new \PHPExiftool\Driver\Tag\Microsoft\VerticalResolution(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\Microsoft\BitDepth(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\Microsoft\AudioSampleRate(),
                'AudioSampleSize' => new \PHPExiftool\Driver\Tag\Microsoft\AudioSampleSize(),
                'VideoCompression' => new \PHPExiftool\Driver\Tag\Microsoft\VideoCompression(),
                'FrameWidth' => new \PHPExiftool\Driver\Tag\Microsoft\FrameWidth(),
                'FrameHeight' => new \PHPExiftool\Driver\Tag\Microsoft\FrameHeight(),
                'TotalBitrate' => new \PHPExiftool\Driver\Tag\Microsoft\TotalBitrate(),
                'DataRate' => new \PHPExiftool\Driver\Tag\Microsoft\DataRate(),
                'Composers' => new \PHPExiftool\Driver\Tag\Microsoft\Composers(),
                'Directors' => new \PHPExiftool\Driver\Tag\Microsoft\Directors(),
                'Producers' => new \PHPExiftool\Driver\Tag\Microsoft\Producers(),
                'Writers' => new \PHPExiftool\Driver\Tag\Microsoft\Writers(),
                'UserWebURL' => new \PHPExiftool\Driver\Tag\Microsoft\UserWebURL(),
                'EncodedBy' => new \PHPExiftool\Driver\Tag\Microsoft\EncodedBy(),
                'Rating' => new \PHPExiftool\Driver\Tag\Microsoft\Rating(),
                'E-mail3' => new \PHPExiftool\Driver\Tag\Microsoft\EMail3(),
                'HomeFax' => new \PHPExiftool\Driver\Tag\Microsoft\HomeFax(),
                'Source' => new \PHPExiftool\Driver\Tag\Microsoft\Source(),
                'FlagColor' => new \PHPExiftool\Driver\Tag\Microsoft\FlagColor(),
                'BusinessPhone' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessPhone(),
                'ProgramMode' => new \PHPExiftool\Driver\Tag\Microsoft\ProgramMode(),
                'OfflineStatus' => new \PHPExiftool\Driver\Tag\Microsoft\OfflineStatus(),
                'ClosedCaptioning' => new \PHPExiftool\Driver\Tag\Microsoft\ClosedCaptioning(),
                'Rerun' => new \PHPExiftool\Driver\Tag\Microsoft\Rerun(),
                'SAP' => new \PHPExiftool\Driver\Tag\Microsoft\SAP(),
                'EpisodeName' => new \PHPExiftool\Driver\Tag\Microsoft\EpisodeName(),
                'ProgramDescription' => new \PHPExiftool\Driver\Tag\Microsoft\ProgramDescription(),
                'StationCallSign' => new \PHPExiftool\Driver\Tag\Microsoft\StationCallSign(),
                'ChannelNumber' => new \PHPExiftool\Driver\Tag\Microsoft\ChannelNumber(),
                'OtherCity' => new \PHPExiftool\Driver\Tag\Microsoft\OtherCity(),
                'OtherStateOrProvince' => new \PHPExiftool\Driver\Tag\Microsoft\OtherStateOrProvince(),
                'Profession' => new \PHPExiftool\Driver\Tag\Microsoft\Profession(),
                'DateCompleted' => new \PHPExiftool\Driver\Tag\Microsoft\DateCompleted(),
                'ReminderTime' => new \PHPExiftool\Driver\Tag\Microsoft\ReminderTime(),
                'BusinessAddress' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessAddress(),
                'OrganizerAddress' => new \PHPExiftool\Driver\Tag\Microsoft\OrganizerAddress(),
                'HomePOBox' => new \PHPExiftool\Driver\Tag\Microsoft\HomePOBox(),
                'E-mailList' => new \PHPExiftool\Driver\Tag\Microsoft\EMailList(),
                'CompanyMainPhone' => new \PHPExiftool\Driver\Tag\Microsoft\CompanyMainPhone(),
                'HomePostalCode' => new \PHPExiftool\Driver\Tag\Microsoft\HomePostalCode(),
                'OtherPOBox' => new \PHPExiftool\Driver\Tag\Microsoft\OtherPOBox(),
                'OtherCountry-Region' => new \PHPExiftool\Driver\Tag\Microsoft\OtherCountryRegion(),
                'LastName' => new \PHPExiftool\Driver\Tag\Microsoft\LastName(),
                'CarPhone' => new \PHPExiftool\Driver\Tag\Microsoft\CarPhone(),
                'BusinessFax' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessFax(),
                'EntryType' => new \PHPExiftool\Driver\Tag\Microsoft\EntryType(),
                'OtherPostalCode' => new \PHPExiftool\Driver\Tag\Microsoft\OtherPostalCode(),
                'Label' => new \PHPExiftool\Driver\Tag\Microsoft\Label(),
                'HomeAddress' => new \PHPExiftool\Driver\Tag\Microsoft\HomeAddress(),
                'AssistantsPhone' => new \PHPExiftool\Driver\Tag\Microsoft\AssistantsPhone(),
                'Anniversary' => new \PHPExiftool\Driver\Tag\Microsoft\Anniversary(),
                'Owner' => new \PHPExiftool\Driver\Tag\Microsoft\Owner(),
                'SpaceFree' => new \PHPExiftool\Driver\Tag\Microsoft\SpaceFree(),
                'TotalSize' => new \PHPExiftool\Driver\Tag\Microsoft\TotalSize(),
                'SpaceUsed' => new \PHPExiftool\Driver\Tag\Microsoft\SpaceUsed(),
                'Priority' => new \PHPExiftool\Driver\Tag\Microsoft\Priority(),
                'HasAttachments' => new \PHPExiftool\Driver\Tag\Microsoft\HasAttachments(),
                'Spouse' => new \PHPExiftool\Driver\Tag\Microsoft\Spouse(),
                'FocalLength35mm' => new \PHPExiftool\Driver\Tag\Microsoft\FocalLength35mm(),
                'IsCompleted' => new \PHPExiftool\Driver\Tag\Microsoft\IsCompleted(),
                'OfflineAvailability' => new \PHPExiftool\Driver\Tag\Microsoft\OfflineAvailability(),
                'OrganizerName' => new \PHPExiftool\Driver\Tag\Microsoft\OrganizerName(),
                'TTY-TTDPhone' => new \PHPExiftool\Driver\Tag\Microsoft\TTYTTDPhone(),
                'Protected' => new \PHPExiftool\Driver\Tag\Microsoft\Protected0(),
                'BusinessCountry-Region' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessCountryRegion(),
                'RequiredAttendees' => new \PHPExiftool\Driver\Tag\Microsoft\RequiredAttendees(),
                'Name' => new \PHPExiftool\Driver\Tag\Microsoft\Name(),
                'Size' => new \PHPExiftool\Driver\Tag\Microsoft\Size(),
                'Attributes' => new \PHPExiftool\Driver\Tag\Microsoft\Attributes(),
                'DateModified' => new \PHPExiftool\Driver\Tag\Microsoft\DateModified(),
                'DateCreated' => new \PHPExiftool\Driver\Tag\Microsoft\DateCreated(),
                'DateAccessed' => new \PHPExiftool\Driver\Tag\Microsoft\DateAccessed(),
                'FolderName' => new \PHPExiftool\Driver\Tag\Microsoft\FolderName(),
                'LinkTarget' => new \PHPExiftool\Driver\Tag\Microsoft\LinkTarget(),
                'LinkStatus' => new \PHPExiftool\Driver\Tag\Microsoft\LinkStatus(),
                'BusinessPOBox' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessPOBox(),
                'ToDoTitle' => new \PHPExiftool\Driver\Tag\Microsoft\ToDoTitle(),
                'CallbackNumber' => new \PHPExiftool\Driver\Tag\Microsoft\CallbackNumber(),
                'IsOnline' => new \PHPExiftool\Driver\Tag\Microsoft\IsOnline(),
                'MailingAddress' => new \PHPExiftool\Driver\Tag\Microsoft\MailingAddress(),
                'Telex' => new \PHPExiftool\Driver\Tag\Microsoft\Telex(),
                'EndDate' => new \PHPExiftool\Driver\Tag\Microsoft\EndDate(),
                'HomeStateOrProvince' => new \PHPExiftool\Driver\Tag\Microsoft\HomeStateOrProvince(),
                'City' => new \PHPExiftool\Driver\Tag\Microsoft\City(),
                'E-mailDisplayName' => new \PHPExiftool\Driver\Tag\Microsoft\EMailDisplayName(),
                'AssistantsName' => new \PHPExiftool\Driver\Tag\Microsoft\AssistantsName(),
                'Creator' => new \PHPExiftool\Driver\Tag\Microsoft\Creator(),
                'ExifVersion' => new \PHPExiftool\Driver\Tag\Microsoft\ExifVersion(),
                'BillingInformation' => new \PHPExiftool\Driver\Tag\Microsoft\BillingInformation(),
                'Children' => new \PHPExiftool\Driver\Tag\Microsoft\Children(),
                'Participants' => new \PHPExiftool\Driver\Tag\Microsoft\Participants(),
                'OptionalAttendeeAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\OptionalAttendeeAddresses(),
                'Company' => new \PHPExiftool\Driver\Tag\Microsoft\Company(),
                'ContentType' => new \PHPExiftool\Driver\Tag\Microsoft\ContentType(),
                'Status' => new \PHPExiftool\Driver\Tag\Microsoft\Status(),
                'Slides' => new \PHPExiftool\Driver\Tag\Microsoft\Slides(),
                'Pager' => new \PHPExiftool\Driver\Tag\Microsoft\Pager(),
                'IMAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\IMAddresses(),
                'Folder' => new \PHPExiftool\Driver\Tag\Microsoft\Folder(),
                'ConversationID' => new \PHPExiftool\Driver\Tag\Microsoft\ConversationID(),
                'BusinessStreet' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessStreet(),
                'DateReleased' => new \PHPExiftool\Driver\Tag\Microsoft\DateReleased(),
                'POBox' => new \PHPExiftool\Driver\Tag\Microsoft\POBox(),
                'ContactNames' => new \PHPExiftool\Driver\Tag\Microsoft\ContactNames(),
                'DocumentID' => new \PHPExiftool\Driver\Tag\Microsoft\DocumentID(),
                'LensModel' => new \PHPExiftool\Driver\Tag\Microsoft\LensModel(),
                'BusinessPostalCode' => new \PHPExiftool\Driver\Tag\Microsoft\BusinessPostalCode(),
                'ReadStatus' => new \PHPExiftool\Driver\Tag\Microsoft\ReadStatus(),
                'Importance' => new \PHPExiftool\Driver\Tag\Microsoft\Importance(),
                'FlagStatus' => new \PHPExiftool\Driver\Tag\Microsoft\FlagStatus(),
                'FromAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\FromAddresses(),
                'FromNames' => new \PHPExiftool\Driver\Tag\Microsoft\FromNames(),
                'Store' => new \PHPExiftool\Driver\Tag\Microsoft\Store(),
                'ToAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\ToAddresses(),
                'ToNames' => new \PHPExiftool\Driver\Tag\Microsoft\ToNames(),
                'Webpage' => new \PHPExiftool\Driver\Tag\Microsoft\Webpage(),
                'DateSent' => new \PHPExiftool\Driver\Tag\Microsoft\DateSent(),
                'BccAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\BccAddresses(),
                'DateReceived' => new \PHPExiftool\Driver\Tag\Microsoft\DateReceived(),
                'Attachments' => new \PHPExiftool\Driver\Tag\Microsoft\Attachments(),
                'BccNames' => new \PHPExiftool\Driver\Tag\Microsoft\BccNames(),
                'CcAddresses' => new \PHPExiftool\Driver\Tag\Microsoft\CcAddresses(),
                'CcNames' => new \PHPExiftool\Driver\Tag\Microsoft\CcNames(),
                'FolderPath' => new \PHPExiftool\Driver\Tag\Microsoft\FolderPath(),
                'Path' => new \PHPExiftool\Driver\Tag\Microsoft\Path(),
                'AccountName' => new \PHPExiftool\Driver\Tag\Microsoft\AccountName(),
                'Country-Region' => new \PHPExiftool\Driver\Tag\Microsoft\CountryRegion(),
                'LensMaker' => new \PHPExiftool\Driver\Tag\Microsoft\LensMaker(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\Microsoft\WhiteBalance(),
                'Shared' => new \PHPExiftool\Driver\Tag\Microsoft\Shared(),
                'SharedWith' => new \PHPExiftool\Driver\Tag\Microsoft\SharedWith(),
                'StateOrProvince' => new \PHPExiftool\Driver\Tag\Microsoft\StateOrProvince(),
                'FileAs' => new \PHPExiftool\Driver\Tag\Microsoft\FileAs(),
                'IsAttachment' => new \PHPExiftool\Driver\Tag\Microsoft\IsAttachment(),
                'TotalEditingTime' => new \PHPExiftool\Driver\Tag\Microsoft\TotalEditingTime(),
                'LastPrinted' => new \PHPExiftool\Driver\Tag\Microsoft\LastPrinted(),
                'Untitled2' => new \PHPExiftool\Driver\Tag\Microsoft\Untitled2(),
                'DateLastSaved' => new \PHPExiftool\Driver\Tag\Microsoft\DateLastSaved(),
                'Pages' => new \PHPExiftool\Driver\Tag\Microsoft\Pages(),
                'WordCount' => new \PHPExiftool\Driver\Tag\Microsoft\WordCount(),
                'ProgramName' => new \PHPExiftool\Driver\Tag\Microsoft\ProgramName(),
                'Keywords' => new \PHPExiftool\Driver\Tag\Microsoft\Keywords(),
                'Comments' => new \PHPExiftool\Driver\Tag\Microsoft\Comments(),
                'Contributors' => new \PHPExiftool\Driver\Tag\Microsoft\Contributors(),
                'Initials' => new \PHPExiftool\Driver\Tag\Microsoft\Initials(),
                'Date' => new \PHPExiftool\Driver\Tag\Microsoft\Date(),
                'Sensitivity' => new \PHPExiftool\Driver\Tag\Microsoft\Sensitivity(),
                'E-mailAddress' => new \PHPExiftool\Driver\Tag\Microsoft\EMailAddress(),
                'Department' => new \PHPExiftool\Driver\Tag\Microsoft\Department(),
                'Mileage' => new \PHPExiftool\Driver\Tag\Microsoft\Mileage(),
                'OtherStreet' => new \PHPExiftool\Driver\Tag\Microsoft\OtherStreet(),
            );
        });
        $this['XMP-microsoft'] = $this->share(function(){
            return array(
                'CameraSerialNumber' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\CameraSerialNumber(),
                'CreatorAppID' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\CreatorAppID(),
                'CreatorOpenWithUIOptions' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\CreatorOpenWithUIOptions(),
                'DateAcquired' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\DateAcquired(),
                'FlashManufacturer' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\FlashManufacturer(),
                'FlashModel' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\FlashModel(),
                'LastKeywordIPTC' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\LastKeywordIPTC(),
                'LastKeywordXMP' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\LastKeywordXMP(),
                'LensManufacturer' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\LensManufacturer(),
                'LensModel' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\LensModel(),
                'RatingPercent' => new \PHPExiftool\Driver\Tag\XMPMicrosoft\RatingPercent(),
            );
        });
        $this['Minolta'] = $this->share(function(){
            return array(
                'AFSensorActive' => new \PHPExiftool\Driver\Tag\Minolta\AFSensorActive(),
                'AFStatusActiveSensor' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusActiveSensor(),
                'AFStatusTop-right' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusTopRight(),
                'AFStatusBottom-right' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusBottomRight(),
                'AFStatusBottom' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusBottom(),
                'AFStatusMiddleHorizontal' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusMiddleHorizontal(),
                'AFStatusCenterVertical' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusCenterVertical(),
                'AFStatusTop' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusTop(),
                'AFStatusTop-left' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusTopLeft(),
                'AFStatusBottom-left' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusBottomLeft(),
                'FocusLocked' => new \PHPExiftool\Driver\Tag\Minolta\FocusLocked(),
                'AFPoint' => new \PHPExiftool\Driver\Tag\Minolta\AFPoint(),
                'AFMode' => new \PHPExiftool\Driver\Tag\Minolta\AFMode(),
                'AFStatusLeft' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusLeft(),
                'AFStatusCenterHorizontal' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusCenterHorizontal(),
                'AFStatusRight' => new \PHPExiftool\Driver\Tag\Minolta\AFStatusRight(),
                'AFAreaMode' => new \PHPExiftool\Driver\Tag\Minolta\AFAreaMode(),
                'ExposureMode' => new \PHPExiftool\Driver\Tag\Minolta\ExposureMode(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\Minolta\FlashMode(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\Minolta\WhiteBalance(),
                'MinoltaImageSize' => new \PHPExiftool\Driver\Tag\Minolta\MinoltaImageSize(),
                'MinoltaQuality' => new \PHPExiftool\Driver\Tag\Minolta\MinoltaQuality(),
                'DriveMode' => new \PHPExiftool\Driver\Tag\Minolta\DriveMode(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\Minolta\MeteringMode(),
                'ISO' => new \PHPExiftool\Driver\Tag\Minolta\ISO(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\Minolta\ExposureTime(),
                'FNumber' => new \PHPExiftool\Driver\Tag\Minolta\FNumber(),
                'MacroMode' => new \PHPExiftool\Driver\Tag\Minolta\MacroMode(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\Minolta\DigitalZoom(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\Minolta\ExposureCompensation(),
                'BracketStep' => new \PHPExiftool\Driver\Tag\Minolta\BracketStep(),
                'IntervalLength' => new \PHPExiftool\Driver\Tag\Minolta\IntervalLength(),
                'IntervalNumber' => new \PHPExiftool\Driver\Tag\Minolta\IntervalNumber(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Minolta\FocalLength(),
                'FocusDistance' => new \PHPExiftool\Driver\Tag\Minolta\FocusDistance(),
                'FlashFired' => new \PHPExiftool\Driver\Tag\Minolta\FlashFired(),
                'MinoltaDate' => new \PHPExiftool\Driver\Tag\Minolta\MinoltaDate(),
                'MinoltaTime' => new \PHPExiftool\Driver\Tag\Minolta\MinoltaTime(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\Minolta\MaxAperture(),
                'FileNumberMemory' => new \PHPExiftool\Driver\Tag\Minolta\FileNumberMemory(),
                'LastFileNumber' => new \PHPExiftool\Driver\Tag\Minolta\LastFileNumber(),
                'ColorBalanceRed' => new \PHPExiftool\Driver\Tag\Minolta\ColorBalanceRed(),
                'ColorBalanceGreen' => new \PHPExiftool\Driver\Tag\Minolta\ColorBalanceGreen(),
                'ColorBalanceBlue' => new \PHPExiftool\Driver\Tag\Minolta\ColorBalanceBlue(),
                'Saturation' => new \PHPExiftool\Driver\Tag\Minolta\Saturation(),
                'Contrast' => new \PHPExiftool\Driver\Tag\Minolta\Contrast(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\Minolta\Sharpness(),
                'SubjectProgram' => new \PHPExiftool\Driver\Tag\Minolta\SubjectProgram(),
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\Minolta\FlashExposureComp(),
                'ISOSetting' => new \PHPExiftool\Driver\Tag\Minolta\ISOSetting(),
                'MinoltaModelID' => new \PHPExiftool\Driver\Tag\Minolta\MinoltaModelID(),
                'IntervalMode' => new \PHPExiftool\Driver\Tag\Minolta\IntervalMode(),
                'FolderName' => new \PHPExiftool\Driver\Tag\Minolta\FolderName(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\Minolta\ColorMode(),
                'ColorFilter' => new \PHPExiftool\Driver\Tag\Minolta\ColorFilter(),
                'BWFilter' => new \PHPExiftool\Driver\Tag\Minolta\BWFilter(),
                'InternalFlash' => new \PHPExiftool\Driver\Tag\Minolta\InternalFlash(),
                'Brightness' => new \PHPExiftool\Driver\Tag\Minolta\Brightness(),
                'SpotFocusPointX' => new \PHPExiftool\Driver\Tag\Minolta\SpotFocusPointX(),
                'SpotFocusPointY' => new \PHPExiftool\Driver\Tag\Minolta\SpotFocusPointY(),
                'WideFocusZone' => new \PHPExiftool\Driver\Tag\Minolta\WideFocusZone(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\Minolta\FocusMode(),
                'FocusArea' => new \PHPExiftool\Driver\Tag\Minolta\FocusArea(),
                'DECPosition' => new \PHPExiftool\Driver\Tag\Minolta\DECPosition(),
                'ColorProfile' => new \PHPExiftool\Driver\Tag\Minolta\ColorProfile(),
                'DataImprint' => new \PHPExiftool\Driver\Tag\Minolta\DataImprint(),
                'FlashMetering' => new \PHPExiftool\Driver\Tag\Minolta\FlashMetering(),
                'Flash' => new \PHPExiftool\Driver\Tag\Minolta\Flash(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\Minolta\ColorSpace(),
                'FreeMemoryCardImages' => new \PHPExiftool\Driver\Tag\Minolta\FreeMemoryCardImages(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\Minolta\ColorTemperature(),
                'HueAdjustment' => new \PHPExiftool\Driver\Tag\Minolta\HueAdjustment(),
                'Rotation' => new \PHPExiftool\Driver\Tag\Minolta\Rotation(),
                'PictureFinish' => new \PHPExiftool\Driver\Tag\Minolta\PictureFinish(),
                'ImageNumber' => new \PHPExiftool\Driver\Tag\Minolta\ImageNumber(),
                'NoiseReduction' => new \PHPExiftool\Driver\Tag\Minolta\NoiseReduction(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\Minolta\ImageStabilization(),
                'AFPoints' => new \PHPExiftool\Driver\Tag\Minolta\AFPoints(),
                'ImageNumber2' => new \PHPExiftool\Driver\Tag\Minolta\ImageNumber2(),
                'ZoneMatchingOn' => new \PHPExiftool\Driver\Tag\Minolta\ZoneMatchingOn(),
                'ExposureCompensationSetting' => new \PHPExiftool\Driver\Tag\Minolta\ExposureCompensationSetting(),
                'HighSpeedSync' => new \PHPExiftool\Driver\Tag\Minolta\HighSpeedSync(),
                'ShutterSpeedSetting' => new \PHPExiftool\Driver\Tag\Minolta\ShutterSpeedSetting(),
                'ApertureSetting' => new \PHPExiftool\Driver\Tag\Minolta\ApertureSetting(),
                'DriveMode2' => new \PHPExiftool\Driver\Tag\Minolta\DriveMode2(),
                'AFPointSelected' => new \PHPExiftool\Driver\Tag\Minolta\AFPointSelected(),
                'FlashExposureCompSet' => new \PHPExiftool\Driver\Tag\Minolta\FlashExposureCompSet(),
                'ZoneMatchingMode' => new \PHPExiftool\Driver\Tag\Minolta\ZoneMatchingMode(),
                'DynamicRangeOptimizer' => new \PHPExiftool\Driver\Tag\Minolta\DynamicRangeOptimizer(),
                'PrioritySetupShutterRelease' => new \PHPExiftool\Driver\Tag\Minolta\PrioritySetupShutterRelease(),
                'SelfTimerTime' => new \PHPExiftool\Driver\Tag\Minolta\SelfTimerTime(),
                'ContinuousBracketing' => new \PHPExiftool\Driver\Tag\Minolta\ContinuousBracketing(),
                'SingleFrameBracketing' => new \PHPExiftool\Driver\Tag\Minolta\SingleFrameBracketing(),
                'WhiteBalanceBracketing' => new \PHPExiftool\Driver\Tag\Minolta\WhiteBalanceBracketing(),
                'WhiteBalanceSetting' => new \PHPExiftool\Driver\Tag\Minolta\WhiteBalanceSetting(),
                'PresetWhiteBalance' => new \PHPExiftool\Driver\Tag\Minolta\PresetWhiteBalance(),
                'ColorTemperatureSetting' => new \PHPExiftool\Driver\Tag\Minolta\ColorTemperatureSetting(),
                'CustomWBSetting' => new \PHPExiftool\Driver\Tag\Minolta\CustomWBSetting(),
                'DynamicRangeOptimizerSetting' => new \PHPExiftool\Driver\Tag\Minolta\DynamicRangeOptimizerSetting(),
                'CustomWBRedLevel' => new \PHPExiftool\Driver\Tag\Minolta\CustomWBRedLevel(),
                'CustomWBGreenLevel' => new \PHPExiftool\Driver\Tag\Minolta\CustomWBGreenLevel(),
                'CustomWBBlueLevel' => new \PHPExiftool\Driver\Tag\Minolta\CustomWBBlueLevel(),
                'CustomWBError' => new \PHPExiftool\Driver\Tag\Minolta\CustomWBError(),
                'WhiteBalanceFineTune' => new \PHPExiftool\Driver\Tag\Minolta\WhiteBalanceFineTune(),
                'ColorCompensationFilter' => new \PHPExiftool\Driver\Tag\Minolta\ColorCompensationFilter(),
                'SonyImageSize' => new \PHPExiftool\Driver\Tag\Minolta\SonyImageSize(),
                'SonyQuality' => new \PHPExiftool\Driver\Tag\Minolta\SonyQuality(),
                'InstantPlaybackTime' => new \PHPExiftool\Driver\Tag\Minolta\InstantPlaybackTime(),
                'InstantPlaybackSetup' => new \PHPExiftool\Driver\Tag\Minolta\InstantPlaybackSetup(),
                'EyeStartAF' => new \PHPExiftool\Driver\Tag\Minolta\EyeStartAF(),
                'RedEyeReduction' => new \PHPExiftool\Driver\Tag\Minolta\RedEyeReduction(),
                'FlashDefault' => new \PHPExiftool\Driver\Tag\Minolta\FlashDefault(),
                'AutoBracketOrder' => new \PHPExiftool\Driver\Tag\Minolta\AutoBracketOrder(),
                'FocusHoldButton' => new \PHPExiftool\Driver\Tag\Minolta\FocusHoldButton(),
                'AELButton' => new \PHPExiftool\Driver\Tag\Minolta\AELButton(),
                'ControlDialSet' => new \PHPExiftool\Driver\Tag\Minolta\ControlDialSet(),
                'ExposureCompensationMode' => new \PHPExiftool\Driver\Tag\Minolta\ExposureCompensationMode(),
                'AFAssist' => new \PHPExiftool\Driver\Tag\Minolta\AFAssist(),
                'CardShutterLock' => new \PHPExiftool\Driver\Tag\Minolta\CardShutterLock(),
                'LensShutterLock' => new \PHPExiftool\Driver\Tag\Minolta\LensShutterLock(),
                'AFAreaIllumination' => new \PHPExiftool\Driver\Tag\Minolta\AFAreaIllumination(),
                'MonitorDisplayOff' => new \PHPExiftool\Driver\Tag\Minolta\MonitorDisplayOff(),
                'RecordDisplay' => new \PHPExiftool\Driver\Tag\Minolta\RecordDisplay(),
                'PlayDisplay' => new \PHPExiftool\Driver\Tag\Minolta\PlayDisplay(),
                'ExposureIndicator' => new \PHPExiftool\Driver\Tag\Minolta\ExposureIndicator(),
                'AELExposureIndicator' => new \PHPExiftool\Driver\Tag\Minolta\AELExposureIndicator(),
                'ExposureBracketingIndicatorLast' => new \PHPExiftool\Driver\Tag\Minolta\ExposureBracketingIndicatorLast(),
                'MeteringOffScaleIndicator' => new \PHPExiftool\Driver\Tag\Minolta\MeteringOffScaleIndicator(),
                'FlashExposureIndicator' => new \PHPExiftool\Driver\Tag\Minolta\FlashExposureIndicator(),
                'FlashExposureIndicatorNext' => new \PHPExiftool\Driver\Tag\Minolta\FlashExposureIndicatorNext(),
                'FlashExposureIndicatorLast' => new \PHPExiftool\Driver\Tag\Minolta\FlashExposureIndicatorLast(),
                'FocusModeSwitch' => new \PHPExiftool\Driver\Tag\Minolta\FocusModeSwitch(),
                'FlashType' => new \PHPExiftool\Driver\Tag\Minolta\FlashType(),
                'AELock' => new \PHPExiftool\Driver\Tag\Minolta\AELock(),
                'BatteryState' => new \PHPExiftool\Driver\Tag\Minolta\BatteryState(),
                'Make' => new \PHPExiftool\Driver\Tag\Minolta\Make(),
                'SoftwareVersion' => new \PHPExiftool\Driver\Tag\Minolta\SoftwareVersion(),
                'ModelType' => new \PHPExiftool\Driver\Tag\Minolta\ModelType(),
                'MakerNoteVersion' => new \PHPExiftool\Driver\Tag\Minolta\MakerNoteVersion(),
                'CompressedImageSize' => new \PHPExiftool\Driver\Tag\Minolta\CompressedImageSize(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\Minolta\PreviewImage(),
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\Minolta\PreviewImageStart(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\Minolta\PreviewImageLength(),
                'SceneMode' => new \PHPExiftool\Driver\Tag\Minolta\SceneMode(),
                'Teleconverter' => new \PHPExiftool\Driver\Tag\Minolta\Teleconverter(),
                'RawAndJpgRecording' => new \PHPExiftool\Driver\Tag\Minolta\RawAndJpgRecording(),
                'ZoneMatching' => new \PHPExiftool\Driver\Tag\Minolta\ZoneMatching(),
                'LensType' => new \PHPExiftool\Driver\Tag\Minolta\LensType(),
                'MinoltaCameraSettings2' => new \PHPExiftool\Driver\Tag\Minolta\MinoltaCameraSettings2(),
                'ImageStabilizationSetting' => new \PHPExiftool\Driver\Tag\Minolta\ImageStabilizationSetting(),
                'DynamicRangeOptimizerMode' => new \PHPExiftool\Driver\Tag\Minolta\DynamicRangeOptimizerMode(),
                'WBBracketShotNumber' => new \PHPExiftool\Driver\Tag\Minolta\WBBracketShotNumber(),
                'ExposureBracketShotNumber' => new \PHPExiftool\Driver\Tag\Minolta\ExposureBracketShotNumber(),
                'FlashFunction' => new \PHPExiftool\Driver\Tag\Minolta\FlashFunction(),
                'AverageLV' => new \PHPExiftool\Driver\Tag\Minolta\AverageLV(),
                'FrameNumber' => new \PHPExiftool\Driver\Tag\Minolta\FrameNumber(),
                'WB_RGBLevels' => new \PHPExiftool\Driver\Tag\Minolta\WBRGBLevels(),
                'WB_GBRGLevels' => new \PHPExiftool\Driver\Tag\Minolta\WBGBRGLevels(),
                'WB_RedLevelsTungsten' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsTungsten(),
                'WB_BlueLevelsTungsten' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsTungsten(),
                'WB_RedLevelsDaylight' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsDaylight(),
                'WB_BlueLevelsDaylight' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsDaylight(),
                'WB_RedLevelsCloudy' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsCloudy(),
                'WB_BlueLevelsCloudy' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsCloudy(),
                'WB_RedLevelsFlash' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsFlash(),
                'WB_BlueLevelsFlash' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsFlash(),
                'WB_RedLevelsFluorescent' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsFluorescent(),
                'WB_BlueLevelsFluorescent' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsFluorescent(),
                'WB_RedLevelsShade' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsShade(),
                'WB_BlueLevelsShade' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsShade(),
                'WB_RedLevel6500K' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevel6500K(),
                'WB_BlueLevel6500K' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevel6500K(),
                'WB_RedLevelCustom' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelCustom(),
                'WB_BlueLevelCustom' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelCustom(),
                'WB_RedLevel3500K' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevel3500K(),
                'WB_BlueLevel3500K' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevel3500K(),
                'WB_RedLevelsKelvin' => new \PHPExiftool\Driver\Tag\Minolta\WBRedLevelsKelvin(),
                'WB_BlueLevelsKelvin' => new \PHPExiftool\Driver\Tag\Minolta\WBBlueLevelsKelvin(),
                'WB_RBLevelsFlash' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsFlash(),
                'WB_RBLevelsCoolWhiteF' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsCoolWhiteF(),
                'WB_RBLevelsTungsten' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsTungsten(),
                'WB_RBLevelsDaylight' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsDaylight(),
                'WB_RBLevelsCloudy' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsCloudy(),
                'WB_RBLevelsShade' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsShade(),
                'WB_RBLevels6500K' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevels6500K(),
                'WB_RBLevelsCustom' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevelsCustom(),
                'WB_RBLevels3500K' => new \PHPExiftool\Driver\Tag\Minolta\WBRBLevels3500K(),
                'AEMeteringSegments' => new \PHPExiftool\Driver\Tag\Minolta\AEMeteringSegments(),
                'MeasuredLV' => new \PHPExiftool\Driver\Tag\Minolta\MeasuredLV(),
                'BrightnessValue' => new \PHPExiftool\Driver\Tag\Minolta\BrightnessValue(),
                'TiffMeteringImage' => new \PHPExiftool\Driver\Tag\Minolta\TiffMeteringImage(),
                'InternalSerialNumber' => new \PHPExiftool\Driver\Tag\Minolta\InternalSerialNumber(),
            );
        });
        $this['MinoltaRaw'] = $this->share(function(){
            return array(
                'FirmwareID' => new \PHPExiftool\Driver\Tag\MinoltaRaw\FirmwareID(),
                'SensorHeight' => new \PHPExiftool\Driver\Tag\MinoltaRaw\SensorHeight(),
                'SensorWidth' => new \PHPExiftool\Driver\Tag\MinoltaRaw\SensorWidth(),
                'ImageHeight' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ImageHeight(),
                'ImageWidth' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ImageWidth(),
                'RawDepth' => new \PHPExiftool\Driver\Tag\MinoltaRaw\RawDepth(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\MinoltaRaw\BitDepth(),
                'StorageMethod' => new \PHPExiftool\Driver\Tag\MinoltaRaw\StorageMethod(),
                'BayerPattern' => new \PHPExiftool\Driver\Tag\MinoltaRaw\BayerPattern(),
                'Saturation' => new \PHPExiftool\Driver\Tag\MinoltaRaw\Saturation(),
                'Contrast' => new \PHPExiftool\Driver\Tag\MinoltaRaw\Contrast(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\MinoltaRaw\Sharpness(),
                'WBMode' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBMode(),
                'ProgramMode' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ProgramMode(),
                'ISOSetting' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ISOSetting(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ColorMode(),
                'WB_RBLevelsTungsten' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsTungsten(),
                'WB_RBLevelsDaylight' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsDaylight(),
                'WB_RBLevelsCloudy' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsCloudy(),
                'WB_RBLevelsCoolWhiteF' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsCoolWhiteF(),
                'WB_RBLevelsFlash' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsFlash(),
                'WB_RBLevelsUnknown' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsUnknown(),
                'WB_RBLevelsShade' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsShade(),
                'WB_RBLevelsDaylightF' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsDaylightF(),
                'WB_RBLevelsDayWhiteF' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsDayWhiteF(),
                'WB_RBLevelsWhiteF' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRBLevelsWhiteF(),
                'ColorFilter' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ColorFilter(),
                'BWFilter' => new \PHPExiftool\Driver\Tag\MinoltaRaw\BWFilter(),
                'ZoneMatching' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ZoneMatching(),
                'Hue' => new \PHPExiftool\Driver\Tag\MinoltaRaw\Hue(),
                'ColorTemperature' => new \PHPExiftool\Driver\Tag\MinoltaRaw\ColorTemperature(),
                'RawDataLength' => new \PHPExiftool\Driver\Tag\MinoltaRaw\RawDataLength(),
                'WBScale' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBScale(),
                'WB_GBRGLevels' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBGBRGLevels(),
                'WB_RGGBLevels' => new \PHPExiftool\Driver\Tag\MinoltaRaw\WBRGGBLevels(),
            );
        });
        $this['Motorola'] = $this->share(function(){
            return array(
                'Sensor' => new \PHPExiftool\Driver\Tag\Motorola\Sensor(),
                'ManufactureDate' => new \PHPExiftool\Driver\Tag\Motorola\ManufactureDate(),
            );
        });
        $this['Nikon'] = $this->share(function(){
            return array(
                'AFAreaMode' => new \PHPExiftool\Driver\Tag\Nikon\AFAreaMode(),
                'AFPoint' => new \PHPExiftool\Driver\Tag\Nikon\AFPoint(),
                'AFPointsInFocus' => new \PHPExiftool\Driver\Tag\Nikon\AFPointsInFocus(),
                'AFInfo2Version' => new \PHPExiftool\Driver\Tag\Nikon\AFInfo2Version(),
                'ContrastDetectAF' => new \PHPExiftool\Driver\Tag\Nikon\ContrastDetectAF(),
                'PhaseDetectAF' => new \PHPExiftool\Driver\Tag\Nikon\PhaseDetectAF(),
                'PrimaryAFPoint' => new \PHPExiftool\Driver\Tag\Nikon\PrimaryAFPoint(),
                'AFPointsUsed' => new \PHPExiftool\Driver\Tag\Nikon\AFPointsUsed(),
                'AFImageWidth' => new \PHPExiftool\Driver\Tag\Nikon\AFImageWidth(),
                'AFImageHeight' => new \PHPExiftool\Driver\Tag\Nikon\AFImageHeight(),
                'AFAreaXPosition' => new \PHPExiftool\Driver\Tag\Nikon\AFAreaXPosition(),
                'AFAreaYPosition' => new \PHPExiftool\Driver\Tag\Nikon\AFAreaYPosition(),
                'AFAreaWidth' => new \PHPExiftool\Driver\Tag\Nikon\AFAreaWidth(),
                'AFAreaHeight' => new \PHPExiftool\Driver\Tag\Nikon\AFAreaHeight(),
                'ContrastDetectAFInFocus' => new \PHPExiftool\Driver\Tag\Nikon\ContrastDetectAFInFocus(),
                'AFFineTune' => new \PHPExiftool\Driver\Tag\Nikon\AFFineTune(),
                'AFFineTuneIndex' => new \PHPExiftool\Driver\Tag\Nikon\AFFineTuneIndex(),
                'AFFineTuneAdj' => new \PHPExiftool\Driver\Tag\Nikon\AFFineTuneAdj(),
                'ThumbnailImage' => new \PHPExiftool\Driver\Tag\Nikon\ThumbnailImage(),
                'PreviewImage' => new \PHPExiftool\Driver\Tag\Nikon\PreviewImage(),
                'Make' => new \PHPExiftool\Driver\Tag\Nikon\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\Nikon\Model(),
                'Software' => new \PHPExiftool\Driver\Tag\Nikon\Software(),
                'Equipment' => new \PHPExiftool\Driver\Tag\Nikon\Equipment(),
                'Orientation' => new \PHPExiftool\Driver\Tag\Nikon\Orientation(),
                'ExposureTime' => new \PHPExiftool\Driver\Tag\Nikon\ExposureTime(),
                'FNumber' => new \PHPExiftool\Driver\Tag\Nikon\FNumber(),
                'ExposureCompensation' => new \PHPExiftool\Driver\Tag\Nikon\ExposureCompensation(),
                'MaxApertureValue' => new \PHPExiftool\Driver\Tag\Nikon\MaxApertureValue(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\Nikon\MeteringMode(),
                'Nikon_AVITags_0x000d' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x000d(),
                'Nikon_AVITags_0x000e' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x000e(),
                'FocalLength' => new \PHPExiftool\Driver\Tag\Nikon\FocalLength(),
                'XResolution' => new \PHPExiftool\Driver\Tag\Nikon\XResolution(),
                'YResolution' => new \PHPExiftool\Driver\Tag\Nikon\YResolution(),
                'ResolutionUnit' => new \PHPExiftool\Driver\Tag\Nikon\ResolutionUnit(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\Nikon\DateTimeOriginal(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\Nikon\CreateDate(),
                'Nikon_AVITags_0x0015' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x0015(),
                'Duration' => new \PHPExiftool\Driver\Tag\Nikon\Duration(),
                'Nikon_AVITags_0x0017' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x0017(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\Nikon\FocusMode(),
                'Nikon_AVITags_0x0019' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x0019(),
                'DigitalZoom' => new \PHPExiftool\Driver\Tag\Nikon\DigitalZoom(),
                'Nikon_AVITags_0x001c' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x001c(),
                'ColorMode' => new \PHPExiftool\Driver\Tag\Nikon\ColorMode(),
                'Sharpness' => new \PHPExiftool\Driver\Tag\Nikon\Sharpness(),
                'WhiteBalance' => new \PHPExiftool\Driver\Tag\Nikon\WhiteBalance(),
                'NoiseReduction' => new \PHPExiftool\Driver\Tag\Nikon\NoiseReduction(),
                'Nikon_AVITags_0x801a' => new \PHPExiftool\Driver\Tag\Nikon\NikonAVITags0x801a(),
                'MakerNoteType' => new \PHPExiftool\Driver\Tag\Nikon\MakerNoteType(),
                'MakerNoteVersion' => new \PHPExiftool\Driver\Tag\Nikon\MakerNoteVersion(),
                'BarometerInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\BarometerInfoVersion(),
                'Altitude' => new \PHPExiftool\Driver\Tag\Nikon\Altitude(),
                'IFD0_Offset' => new \PHPExiftool\Driver\Tag\Nikon\IFD0Offset(),
                'PreviewIFD_Offset' => new \PHPExiftool\Driver\Tag\Nikon\PreviewIFDOffset(),
                'SubIFD_Offset' => new \PHPExiftool\Driver\Tag\Nikon\SubIFDOffset(),
                'OutputImageWidth' => new \PHPExiftool\Driver\Tag\Nikon\OutputImageWidth(),
                'OutputImageHeight' => new \PHPExiftool\Driver\Tag\Nikon\OutputImageHeight(),
                'OutputResolution' => new \PHPExiftool\Driver\Tag\Nikon\OutputResolution(),
                'WB_RBGGLevels' => new \PHPExiftool\Driver\Tag\Nikon\WBRBGGLevels(),
                'WB_RGGBLevels' => new \PHPExiftool\Driver\Tag\Nikon\WBRGGBLevels(),
                'WB_RGBGLevels' => new \PHPExiftool\Driver\Tag\Nikon\WBRGBGLevels(),
                'WB_GRBGLevels' => new \PHPExiftool\Driver\Tag\Nikon\WBGRBGLevels(),
                'RedBalance' => new \PHPExiftool\Driver\Tag\Nikon\RedBalance(),
                'BlueBalance' => new \PHPExiftool\Driver\Tag\Nikon\BlueBalance(),
                'ColorBalanceVersion' => new \PHPExiftool\Driver\Tag\Nikon\ColorBalanceVersion(),
                'DistortionVersion' => new \PHPExiftool\Driver\Tag\Nikon\DistortionVersion(),
                'AutoDistortionControl' => new \PHPExiftool\Driver\Tag\Nikon\AutoDistortionControl(),
                'FaceDetectFrameSize' => new \PHPExiftool\Driver\Tag\Nikon\FaceDetectFrameSize(),
                'FacesDetected' => new \PHPExiftool\Driver\Tag\Nikon\FacesDetected(),
                'Face1Position' => new \PHPExiftool\Driver\Tag\Nikon\Face1Position(),
                'Face2Position' => new \PHPExiftool\Driver\Tag\Nikon\Face2Position(),
                'Face3Position' => new \PHPExiftool\Driver\Tag\Nikon\Face3Position(),
                'Face4Position' => new \PHPExiftool\Driver\Tag\Nikon\Face4Position(),
                'Face5Position' => new \PHPExiftool\Driver\Tag\Nikon\Face5Position(),
                'Face6Position' => new \PHPExiftool\Driver\Tag\Nikon\Face6Position(),
                'Face7Position' => new \PHPExiftool\Driver\Tag\Nikon\Face7Position(),
                'Face8Position' => new \PHPExiftool\Driver\Tag\Nikon\Face8Position(),
                'Face9Position' => new \PHPExiftool\Driver\Tag\Nikon\Face9Position(),
                'Face10Position' => new \PHPExiftool\Driver\Tag\Nikon\Face10Position(),
                'Face11Position' => new \PHPExiftool\Driver\Tag\Nikon\Face11Position(),
                'Face12Position' => new \PHPExiftool\Driver\Tag\Nikon\Face12Position(),
                'FileInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\FileInfoVersion(),
                'DirectoryNumber' => new \PHPExiftool\Driver\Tag\Nikon\DirectoryNumber(),
                'FileNumber' => new \PHPExiftool\Driver\Tag\Nikon\FileNumber(),
                'FlashInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\FlashInfoVersion(),
                'FlashSource' => new \PHPExiftool\Driver\Tag\Nikon\FlashSource(),
                'ExternalFlashFirmware' => new \PHPExiftool\Driver\Tag\Nikon\ExternalFlashFirmware(),
                'ExternalFlashFlags' => new \PHPExiftool\Driver\Tag\Nikon\ExternalFlashFlags(),
                'FlashCommanderMode' => new \PHPExiftool\Driver\Tag\Nikon\FlashCommanderMode(),
                'FlashControlMode' => new \PHPExiftool\Driver\Tag\Nikon\FlashControlMode(),
                'FlashOutput' => new \PHPExiftool\Driver\Tag\Nikon\FlashOutput(),
                'FlashCompensation' => new \PHPExiftool\Driver\Tag\Nikon\FlashCompensation(),
                'FlashFocalLength' => new \PHPExiftool\Driver\Tag\Nikon\FlashFocalLength(),
                'RepeatingFlashRate' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashRate(),
                'RepeatingFlashCount' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashCount(),
                'FlashGNDistance' => new \PHPExiftool\Driver\Tag\Nikon\FlashGNDistance(),
                'FlashGroupAControlMode' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupAControlMode(),
                'FlashGroupBControlMode' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupBControlMode(),
                'FlashGroupAOutput' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupAOutput(),
                'FlashGroupACompensation' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupACompensation(),
                'FlashGroupBOutput' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupBOutput(),
                'FlashGroupBCompensation' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupBCompensation(),
                'FlashGroupCControlMode' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupCControlMode(),
                'FlashGroupCOutput' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupCOutput(),
                'FlashGroupCCompensation' => new \PHPExiftool\Driver\Tag\Nikon\FlashGroupCCompensation(),
                'FlashColorFilter' => new \PHPExiftool\Driver\Tag\Nikon\FlashColorFilter(),
                'ExternalFlashCompensation' => new \PHPExiftool\Driver\Tag\Nikon\ExternalFlashCompensation(),
                'FlashExposureComp3' => new \PHPExiftool\Driver\Tag\Nikon\FlashExposureComp3(),
                'FlashExposureComp4' => new \PHPExiftool\Driver\Tag\Nikon\FlashExposureComp4(),
                'HDRInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\HDRInfoVersion(),
                'HDR' => new \PHPExiftool\Driver\Tag\Nikon\HDR(),
                'HDRLevel' => new \PHPExiftool\Driver\Tag\Nikon\HDRLevel(),
                'HDRSmoothing' => new \PHPExiftool\Driver\Tag\Nikon\HDRSmoothing(),
                'HDRLevel2' => new \PHPExiftool\Driver\Tag\Nikon\HDRLevel2(),
                'ISO' => new \PHPExiftool\Driver\Tag\Nikon\ISO(),
                'ISOExpansion' => new \PHPExiftool\Driver\Tag\Nikon\ISOExpansion(),
                'ISO2' => new \PHPExiftool\Driver\Tag\Nikon\ISO2(),
                'ISOExpansion2' => new \PHPExiftool\Driver\Tag\Nikon\ISOExpansion2(),
                'LensDataVersion' => new \PHPExiftool\Driver\Tag\Nikon\LensDataVersion(),
                'LensIDNumber' => new \PHPExiftool\Driver\Tag\Nikon\LensIDNumber(),
                'LensFStops' => new \PHPExiftool\Driver\Tag\Nikon\LensFStops(),
                'MinFocalLength' => new \PHPExiftool\Driver\Tag\Nikon\MinFocalLength(),
                'MaxFocalLength' => new \PHPExiftool\Driver\Tag\Nikon\MaxFocalLength(),
                'MaxApertureAtMinFocal' => new \PHPExiftool\Driver\Tag\Nikon\MaxApertureAtMinFocal(),
                'MaxApertureAtMaxFocal' => new \PHPExiftool\Driver\Tag\Nikon\MaxApertureAtMaxFocal(),
                'MCUVersion' => new \PHPExiftool\Driver\Tag\Nikon\MCUVersion(),
                'ExitPupilPosition' => new \PHPExiftool\Driver\Tag\Nikon\ExitPupilPosition(),
                'AFAperture' => new \PHPExiftool\Driver\Tag\Nikon\AFAperture(),
                'FocusPosition' => new \PHPExiftool\Driver\Tag\Nikon\FocusPosition(),
                'FocusDistance' => new \PHPExiftool\Driver\Tag\Nikon\FocusDistance(),
                'EffectiveMaxAperture' => new \PHPExiftool\Driver\Tag\Nikon\EffectiveMaxAperture(),
                'LensModel' => new \PHPExiftool\Driver\Tag\Nikon\LensModel(),
                'LocationInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\LocationInfoVersion(),
                'TextEncoding' => new \PHPExiftool\Driver\Tag\Nikon\TextEncoding(),
                'CountryCode' => new \PHPExiftool\Driver\Tag\Nikon\CountryCode(),
                'POILevel' => new \PHPExiftool\Driver\Tag\Nikon\POILevel(),
                'Location' => new \PHPExiftool\Driver\Tag\Nikon\Location(),
                'Quality' => new \PHPExiftool\Driver\Tag\Nikon\Quality(),
                'FlashSetting' => new \PHPExiftool\Driver\Tag\Nikon\FlashSetting(),
                'FlashType' => new \PHPExiftool\Driver\Tag\Nikon\FlashType(),
                'WhiteBalanceFineTune' => new \PHPExiftool\Driver\Tag\Nikon\WhiteBalanceFineTune(),
                'WB_RBLevels' => new \PHPExiftool\Driver\Tag\Nikon\WBRBLevels(),
                'ProgramShift' => new \PHPExiftool\Driver\Tag\Nikon\ProgramShift(),
                'ExposureDifference' => new \PHPExiftool\Driver\Tag\Nikon\ExposureDifference(),
                'ISOSelection' => new \PHPExiftool\Driver\Tag\Nikon\ISOSelection(),
                'DataDump' => new \PHPExiftool\Driver\Tag\Nikon\DataDump(),
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\Nikon\FlashExposureComp(),
                'ISOSetting' => new \PHPExiftool\Driver\Tag\Nikon\ISOSetting(),
                'NRWData' => new \PHPExiftool\Driver\Tag\Nikon\NRWData(),
                'ImageBoundary' => new \PHPExiftool\Driver\Tag\Nikon\ImageBoundary(),
                'ExternalFlashExposureComp' => new \PHPExiftool\Driver\Tag\Nikon\ExternalFlashExposureComp(),
                'FlashExposureBracketValue' => new \PHPExiftool\Driver\Tag\Nikon\FlashExposureBracketValue(),
                'ExposureBracketValue' => new \PHPExiftool\Driver\Tag\Nikon\ExposureBracketValue(),
                'ImageProcessing' => new \PHPExiftool\Driver\Tag\Nikon\ImageProcessing(),
                'CropHiSpeed' => new \PHPExiftool\Driver\Tag\Nikon\CropHiSpeed(),
                'ExposureTuning' => new \PHPExiftool\Driver\Tag\Nikon\ExposureTuning(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\Nikon\SerialNumber(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\Nikon\ColorSpace(),
                'ImageAuthentication' => new \PHPExiftool\Driver\Tag\Nikon\ImageAuthentication(),
                'ActiveD-Lighting' => new \PHPExiftool\Driver\Tag\Nikon\ActiveDLighting(),
                'PictureControlData' => new \PHPExiftool\Driver\Tag\Nikon\PictureControlData(),
                'VignetteControl' => new \PHPExiftool\Driver\Tag\Nikon\VignetteControl(),
                'BlackLevel' => new \PHPExiftool\Driver\Tag\Nikon\BlackLevel(),
                'ImageAdjustment' => new \PHPExiftool\Driver\Tag\Nikon\ImageAdjustment(),
                'ToneComp' => new \PHPExiftool\Driver\Tag\Nikon\ToneComp(),
                'AuxiliaryLens' => new \PHPExiftool\Driver\Tag\Nikon\AuxiliaryLens(),
                'LensType' => new \PHPExiftool\Driver\Tag\Nikon\LensType(),
                'Lens' => new \PHPExiftool\Driver\Tag\Nikon\Lens(),
                'ManualFocusDistance' => new \PHPExiftool\Driver\Tag\Nikon\ManualFocusDistance(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\Nikon\FlashMode(),
                'ShootingMode' => new \PHPExiftool\Driver\Tag\Nikon\ShootingMode(),
                'ContrastCurve' => new \PHPExiftool\Driver\Tag\Nikon\ContrastCurve(),
                'ColorHue' => new \PHPExiftool\Driver\Tag\Nikon\ColorHue(),
                'SceneMode' => new \PHPExiftool\Driver\Tag\Nikon\SceneMode(),
                'LightSource' => new \PHPExiftool\Driver\Tag\Nikon\LightSource(),
                'HueAdjustment' => new \PHPExiftool\Driver\Tag\Nikon\HueAdjustment(),
                'NEFCompression' => new \PHPExiftool\Driver\Tag\Nikon\NEFCompression(),
                'Saturation' => new \PHPExiftool\Driver\Tag\Nikon\Saturation(),
                'NEFLinearizationTable' => new \PHPExiftool\Driver\Tag\Nikon\NEFLinearizationTable(),
                'RawImageCenter' => new \PHPExiftool\Driver\Tag\Nikon\RawImageCenter(),
                'SensorPixelSize' => new \PHPExiftool\Driver\Tag\Nikon\SensorPixelSize(),
                'SceneAssist' => new \PHPExiftool\Driver\Tag\Nikon\SceneAssist(),
                'RetouchHistory' => new \PHPExiftool\Driver\Tag\Nikon\RetouchHistory(),
                'ImageDataSize' => new \PHPExiftool\Driver\Tag\Nikon\ImageDataSize(),
                'ImageCount' => new \PHPExiftool\Driver\Tag\Nikon\ImageCount(),
                'DeletedImageCount' => new \PHPExiftool\Driver\Tag\Nikon\DeletedImageCount(),
                'ShutterCount' => new \PHPExiftool\Driver\Tag\Nikon\ShutterCount(),
                'ImageOptimization' => new \PHPExiftool\Driver\Tag\Nikon\ImageOptimization(),
                'VariProgram' => new \PHPExiftool\Driver\Tag\Nikon\VariProgram(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\Nikon\ImageStabilization(),
                'AFResponse' => new \PHPExiftool\Driver\Tag\Nikon\AFResponse(),
                'HighISONoiseReduction' => new \PHPExiftool\Driver\Tag\Nikon\HighISONoiseReduction(),
                'ToningEffect' => new \PHPExiftool\Driver\Tag\Nikon\ToningEffect(),
                'PowerUpTime' => new \PHPExiftool\Driver\Tag\Nikon\PowerUpTime(),
                'NikonCaptureData' => new \PHPExiftool\Driver\Tag\Nikon\NikonCaptureData(),
                'NikonCaptureVersion' => new \PHPExiftool\Driver\Tag\Nikon\NikonCaptureVersion(),
                'NikonCaptureEditVersions' => new \PHPExiftool\Driver\Tag\Nikon\NikonCaptureEditVersions(),
                'NikonICCProfile' => new \PHPExiftool\Driver\Tag\Nikon\NikonICCProfile(),
                'NikonCaptureOutput' => new \PHPExiftool\Driver\Tag\Nikon\NikonCaptureOutput(),
                'NEFBitDepth' => new \PHPExiftool\Driver\Tag\Nikon\NEFBitDepth(),
                'MultiExposureVersion' => new \PHPExiftool\Driver\Tag\Nikon\MultiExposureVersion(),
                'MultiExposureMode' => new \PHPExiftool\Driver\Tag\Nikon\MultiExposureMode(),
                'MultiExposureShots' => new \PHPExiftool\Driver\Tag\Nikon\MultiExposureShots(),
                'MultiExposureAutoGain' => new \PHPExiftool\Driver\Tag\Nikon\MultiExposureAutoGain(),
                'FrameCount' => new \PHPExiftool\Driver\Tag\Nikon\FrameCount(),
                'FrameRate' => new \PHPExiftool\Driver\Tag\Nikon\FrameRate(),
                'FrameWidth' => new \PHPExiftool\Driver\Tag\Nikon\FrameWidth(),
                'FrameHeight' => new \PHPExiftool\Driver\Tag\Nikon\FrameHeight(),
                'AudioChannels' => new \PHPExiftool\Driver\Tag\Nikon\AudioChannels(),
                'AudioBitsPerSample' => new \PHPExiftool\Driver\Tag\Nikon\AudioBitsPerSample(),
                'AudioSampleRate' => new \PHPExiftool\Driver\Tag\Nikon\AudioSampleRate(),
                'ExposureProgram' => new \PHPExiftool\Driver\Tag\Nikon\ExposureProgram(),
                'PictureControlVersion' => new \PHPExiftool\Driver\Tag\Nikon\PictureControlVersion(),
                'PictureControlName' => new \PHPExiftool\Driver\Tag\Nikon\PictureControlName(),
                'PictureControlBase' => new \PHPExiftool\Driver\Tag\Nikon\PictureControlBase(),
                'PictureControlAdjust' => new \PHPExiftool\Driver\Tag\Nikon\PictureControlAdjust(),
                'PictureControlQuickAdjust' => new \PHPExiftool\Driver\Tag\Nikon\PictureControlQuickAdjust(),
                'Contrast' => new \PHPExiftool\Driver\Tag\Nikon\Contrast(),
                'Brightness' => new \PHPExiftool\Driver\Tag\Nikon\Brightness(),
                'FilterEffect' => new \PHPExiftool\Driver\Tag\Nikon\FilterEffect(),
                'ToningSaturation' => new \PHPExiftool\Driver\Tag\Nikon\ToningSaturation(),
                'RetouchInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\RetouchInfoVersion(),
                'RetouchNEFProcessing' => new \PHPExiftool\Driver\Tag\Nikon\RetouchNEFProcessing(),
                'ShotInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\ShotInfoVersion(),
                'FirmwareVersion' => new \PHPExiftool\Driver\Tag\Nikon\FirmwareVersion(),
                'DistortionControl' => new \PHPExiftool\Driver\Tag\Nikon\DistortionControl(),
                'VR_0x66' => new \PHPExiftool\Driver\Tag\Nikon\VR0x66(),
                'VibrationReduction' => new \PHPExiftool\Driver\Tag\Nikon\VibrationReduction(),
                'ImageArea' => new \PHPExiftool\Driver\Tag\Nikon\ImageArea(),
                'NikonImageSize' => new \PHPExiftool\Driver\Tag\Nikon\NikonImageSize(),
                'ImageQuality' => new \PHPExiftool\Driver\Tag\Nikon\ImageQuality(),
                'PreFlashReturnStrength' => new \PHPExiftool\Driver\Tag\Nikon\PreFlashReturnStrength(),
                'RollAngle' => new \PHPExiftool\Driver\Tag\Nikon\RollAngle(),
                'PitchAngle' => new \PHPExiftool\Driver\Tag\Nikon\PitchAngle(),
                'YawAngle' => new \PHPExiftool\Driver\Tag\Nikon\YawAngle(),
                'Rotation' => new \PHPExiftool\Driver\Tag\Nikon\Rotation(),
                'FlashFired' => new \PHPExiftool\Driver\Tag\Nikon\FlashFired(),
                'RepeatingFlashOutputExternal' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashOutputExternal(),
                'RepeatingFlashRateExternal' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashRateExternal(),
                'RepeatingFlashCountExternal' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashCountExternal(),
                'FlashExposureComp2' => new \PHPExiftool\Driver\Tag\Nikon\FlashExposureComp2(),
                'RepeatingFlashRateBuilt-in' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashRateBuiltIn(),
                'RepeatingFlashCountBuilt-in' => new \PHPExiftool\Driver\Tag\Nikon\RepeatingFlashCountBuiltIn(),
                'SequenceNumber' => new \PHPExiftool\Driver\Tag\Nikon\SequenceNumber(),
                'CustomSettingsOffset' => new \PHPExiftool\Driver\Tag\Nikon\CustomSettingsOffset(),
                'D810MeteringMode' => new \PHPExiftool\Driver\Tag\Nikon\D810MeteringMode(),
                'CCDSensitivity' => new \PHPExiftool\Driver\Tag\Nikon\CCDSensitivity(),
                'Focus' => new \PHPExiftool\Driver\Tag\Nikon\Focus(),
                'Converter' => new \PHPExiftool\Driver\Tag\Nikon\Converter(),
                'UnknownInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\UnknownInfoVersion(),
                'UnknownInfo2Version' => new \PHPExiftool\Driver\Tag\Nikon\UnknownInfo2Version(),
                'VRInfoVersion' => new \PHPExiftool\Driver\Tag\Nikon\VRInfoVersion(),
                'VRMode' => new \PHPExiftool\Driver\Tag\Nikon\VRMode(),
                'TimeZone' => new \PHPExiftool\Driver\Tag\Nikon\TimeZone(),
                'DaylightSavings' => new \PHPExiftool\Driver\Tag\Nikon\DaylightSavings(),
                'DateDisplayFormat' => new \PHPExiftool\Driver\Tag\Nikon\DateDisplayFormat(),
            );
        });
        $this['NikonScan'] = $this->share(function(){
            return array(
                'DigitalGEM' => new \PHPExiftool\Driver\Tag\NikonScan\DigitalGEM(),
                'DigitalROC' => new \PHPExiftool\Driver\Tag\NikonScan\DigitalROC(),
                'FilmType' => new \PHPExiftool\Driver\Tag\NikonScan\FilmType(),
                'MultiSample' => new \PHPExiftool\Driver\Tag\NikonScan\MultiSample(),
                'BitDepth' => new \PHPExiftool\Driver\Tag\NikonScan\BitDepth(),
                'MasterGain' => new \PHPExiftool\Driver\Tag\NikonScan\MasterGain(),
                'ColorGain' => new \PHPExiftool\Driver\Tag\NikonScan\ColorGain(),
                'ScanImageEnhancer' => new \PHPExiftool\Driver\Tag\NikonScan\ScanImageEnhancer(),
                'DigitalICE' => new \PHPExiftool\Driver\Tag\NikonScan\DigitalICE(),
                'DigitalDEEShadowAdj' => new \PHPExiftool\Driver\Tag\NikonScan\DigitalDEEShadowAdj(),
                'DigitalDEEThreshold' => new \PHPExiftool\Driver\Tag\NikonScan\DigitalDEEThreshold(),
                'DigitalDEEHighlightAdj' => new \PHPExiftool\Driver\Tag\NikonScan\DigitalDEEHighlightAdj(),
            );
        });
        $this['PreviewIFD'] = $this->share(function(){
            return array(
                'SubfileType' => new \PHPExiftool\Driver\Tag\PreviewIFD\SubfileType(),
                'Compression' => new \PHPExiftool\Driver\Tag\PreviewIFD\Compression(),
                'XResolution' => new \PHPExiftool\Driver\Tag\PreviewIFD\XResolution(),
                'YResolution' => new \PHPExiftool\Driver\Tag\PreviewIFD\YResolution(),
                'ResolutionUnit' => new \PHPExiftool\Driver\Tag\PreviewIFD\ResolutionUnit(),
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\PreviewIFD\PreviewImageStart(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\PreviewIFD\PreviewImageLength(),
                'YCbCrPositioning' => new \PHPExiftool\Driver\Tag\PreviewIFD\YCbCrPositioning(),
            );
        });
        $this['NikonCustom'] = $this->share(function(){
            return array(
                'MultiSelectorLiveViewMode' => new \PHPExiftool\Driver\Tag\NikonCustom\MultiSelectorLiveViewMode(),
                'CustomSettingsBank' => new \PHPExiftool\Driver\Tag\NikonCustom\CustomSettingsBank(),
                'CustomSettingsAllDefault' => new \PHPExiftool\Driver\Tag\NikonCustom\CustomSettingsAllDefault(),
                'AF-CPrioritySelection' => new \PHPExiftool\Driver\Tag\NikonCustom\AFCPrioritySelection(),
                'AF-SPrioritySelection' => new \PHPExiftool\Driver\Tag\NikonCustom\AFSPrioritySelection(),
                'AFPointSelection' => new \PHPExiftool\Driver\Tag\NikonCustom\AFPointSelection(),
                'DynamicAFArea' => new \PHPExiftool\Driver\Tag\NikonCustom\DynamicAFArea(),
                'FocusTrackingLockOn' => new \PHPExiftool\Driver\Tag\NikonCustom\FocusTrackingLockOn(),
                'AFActivation' => new \PHPExiftool\Driver\Tag\NikonCustom\AFActivation(),
                'FocusPointWrap' => new \PHPExiftool\Driver\Tag\NikonCustom\FocusPointWrap(),
                'AFPointIllumination' => new \PHPExiftool\Driver\Tag\NikonCustom\AFPointIllumination(),
                'AFPointBrightness' => new \PHPExiftool\Driver\Tag\NikonCustom\AFPointBrightness(),
                'AFAssist' => new \PHPExiftool\Driver\Tag\NikonCustom\AFAssist(),
                'AFOnButton' => new \PHPExiftool\Driver\Tag\NikonCustom\AFOnButton(),
                'VerticalAFOnButton' => new \PHPExiftool\Driver\Tag\NikonCustom\VerticalAFOnButton(),
                'AF-OnForMB-D10' => new \PHPExiftool\Driver\Tag\NikonCustom\AFOnForMBD10(),
                'AssignBktButton' => new \PHPExiftool\Driver\Tag\NikonCustom\AssignBktButton(),
                'MultiSelectorLiveView' => new \PHPExiftool\Driver\Tag\NikonCustom\MultiSelectorLiveView(),
                'InitialZoomLiveView' => new \PHPExiftool\Driver\Tag\NikonCustom\InitialZoomLiveView(),
                'ISOStepSize' => new \PHPExiftool\Driver\Tag\NikonCustom\ISOStepSize(),
                'ExposureControlStepSize' => new \PHPExiftool\Driver\Tag\NikonCustom\ExposureControlStepSize(),
                'ExposureCompStepSize' => new \PHPExiftool\Driver\Tag\NikonCustom\ExposureCompStepSize(),
                'EasyExposureCompensation' => new \PHPExiftool\Driver\Tag\NikonCustom\EasyExposureCompensation(),
                'CenterWeightedAreaSize' => new \PHPExiftool\Driver\Tag\NikonCustom\CenterWeightedAreaSize(),
                'FineTuneOptCenterWeighted' => new \PHPExiftool\Driver\Tag\NikonCustom\FineTuneOptCenterWeighted(),
                'FineTuneOptMatrixMetering' => new \PHPExiftool\Driver\Tag\NikonCustom\FineTuneOptMatrixMetering(),
                'FineTuneOptSpotMetering' => new \PHPExiftool\Driver\Tag\NikonCustom\FineTuneOptSpotMetering(),
                'MultiSelectorShootMode' => new \PHPExiftool\Driver\Tag\NikonCustom\MultiSelectorShootMode(),
                'MultiSelectorPlaybackMode' => new \PHPExiftool\Driver\Tag\NikonCustom\MultiSelectorPlaybackMode(),
                'InitialZoomSetting' => new \PHPExiftool\Driver\Tag\NikonCustom\InitialZoomSetting(),
                'MultiSelector' => new \PHPExiftool\Driver\Tag\NikonCustom\MultiSelector(),
                'ExposureDelayMode' => new \PHPExiftool\Driver\Tag\NikonCustom\ExposureDelayMode(),
                'CLModeShootingSpeed' => new \PHPExiftool\Driver\Tag\NikonCustom\CLModeShootingSpeed(),
                'CHModeShootingSpeed' => new \PHPExiftool\Driver\Tag\NikonCustom\CHModeShootingSpeed(),
                'MaxContinuousRelease' => new \PHPExiftool\Driver\Tag\NikonCustom\MaxContinuousRelease(),
                'ReverseIndicators' => new \PHPExiftool\Driver\Tag\NikonCustom\ReverseIndicators(),
                'FileNumberSequence' => new \PHPExiftool\Driver\Tag\NikonCustom\FileNumberSequence(),
                'RearDisplay' => new \PHPExiftool\Driver\Tag\NikonCustom\RearDisplay(),
                'ViewfinderDisplay' => new \PHPExiftool\Driver\Tag\NikonCustom\ViewfinderDisplay(),
                'BatteryOrder' => new \PHPExiftool\Driver\Tag\NikonCustom\BatteryOrder(),
                'MB-D10Batteries' => new \PHPExiftool\Driver\Tag\NikonCustom\MBD10Batteries(),
                'ScreenTips' => new \PHPExiftool\Driver\Tag\NikonCustom\ScreenTips(),
                'Beep' => new \PHPExiftool\Driver\Tag\NikonCustom\Beep(),
                'ShootingInfoDisplay' => new \PHPExiftool\Driver\Tag\NikonCustom\ShootingInfoDisplay(),
                'GridDisplay' => new \PHPExiftool\Driver\Tag\NikonCustom\GridDisplay(),
                'ViewfinderWarning' => new \PHPExiftool\Driver\Tag\NikonCustom\ViewfinderWarning(),
                'PreviewButton' => new \PHPExiftool\Driver\Tag\NikonCustom\PreviewButton(),
                'FuncButton' => new \PHPExiftool\Driver\Tag\NikonCustom\FuncButton(),
                'PreviewButtonPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\PreviewButtonPlusDials(),
                'FuncButtonPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\FuncButtonPlusDials(),
                'AELockButton' => new \PHPExiftool\Driver\Tag\NikonCustom\AELockButton(),
                'AELockButtonPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\AELockButtonPlusDials(),
                'CommandDialsReverseRotation' => new \PHPExiftool\Driver\Tag\NikonCustom\CommandDialsReverseRotation(),
                'CommandDialsChangeMainSub' => new \PHPExiftool\Driver\Tag\NikonCustom\CommandDialsChangeMainSub(),
                'CommandDialsApertureSetting' => new \PHPExiftool\Driver\Tag\NikonCustom\CommandDialsApertureSetting(),
                'CommandDialsMenuAndPlayback' => new \PHPExiftool\Driver\Tag\NikonCustom\CommandDialsMenuAndPlayback(),
                'LCDIllumination' => new \PHPExiftool\Driver\Tag\NikonCustom\LCDIllumination(),
                'PhotoInfoPlayback' => new \PHPExiftool\Driver\Tag\NikonCustom\PhotoInfoPlayback(),
                'ShutterReleaseButtonAE-L' => new \PHPExiftool\Driver\Tag\NikonCustom\ShutterReleaseButtonAEL(),
                'ReleaseButtonToUseDial' => new \PHPExiftool\Driver\Tag\NikonCustom\ReleaseButtonToUseDial(),
                'SelfTimerTime' => new \PHPExiftool\Driver\Tag\NikonCustom\SelfTimerTime(),
                'MonitorOffTime' => new \PHPExiftool\Driver\Tag\NikonCustom\MonitorOffTime(),
                'FlashSyncSpeed' => new \PHPExiftool\Driver\Tag\NikonCustom\FlashSyncSpeed(),
                'FlashShutterSpeed' => new \PHPExiftool\Driver\Tag\NikonCustom\FlashShutterSpeed(),
                'AutoBracketSet' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoBracketSet(),
                'AutoBracketModeM' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoBracketModeM(),
                'AutoBracketOrder' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoBracketOrder(),
                'ModelingFlash' => new \PHPExiftool\Driver\Tag\NikonCustom\ModelingFlash(),
                'NoMemoryCard' => new \PHPExiftool\Driver\Tag\NikonCustom\NoMemoryCard(),
                'MeteringTime' => new \PHPExiftool\Driver\Tag\NikonCustom\MeteringTime(),
                'InternalFlash' => new \PHPExiftool\Driver\Tag\NikonCustom\InternalFlash(),
                'ImageReviewTime' => new \PHPExiftool\Driver\Tag\NikonCustom\ImageReviewTime(),
                'PlaybackMonitorOffTime' => new \PHPExiftool\Driver\Tag\NikonCustom\PlaybackMonitorOffTime(),
                'MenuMonitorOffTime' => new \PHPExiftool\Driver\Tag\NikonCustom\MenuMonitorOffTime(),
                'ShootingInfoMonitorOffTime' => new \PHPExiftool\Driver\Tag\NikonCustom\ShootingInfoMonitorOffTime(),
                'Pitch' => new \PHPExiftool\Driver\Tag\NikonCustom\Pitch(),
                'StandbyTimer' => new \PHPExiftool\Driver\Tag\NikonCustom\StandbyTimer(),
                'SelfTimerShotCount' => new \PHPExiftool\Driver\Tag\NikonCustom\SelfTimerShotCount(),
                'SelfTimerShotInterval' => new \PHPExiftool\Driver\Tag\NikonCustom\SelfTimerShotInterval(),
                'ImageReviewMonitorOffTime' => new \PHPExiftool\Driver\Tag\NikonCustom\ImageReviewMonitorOffTime(),
                'LiveViewMonitorOffTime' => new \PHPExiftool\Driver\Tag\NikonCustom\LiveViewMonitorOffTime(),
                'PlaybackZoom' => new \PHPExiftool\Driver\Tag\NikonCustom\PlaybackZoom(),
                'ShutterSpeedLock' => new \PHPExiftool\Driver\Tag\NikonCustom\ShutterSpeedLock(),
                'ApertureLock' => new \PHPExiftool\Driver\Tag\NikonCustom\ApertureLock(),
                'MovieShutterButton' => new \PHPExiftool\Driver\Tag\NikonCustom\MovieShutterButton(),
                'FlashExposureCompArea' => new \PHPExiftool\Driver\Tag\NikonCustom\FlashExposureCompArea(),
                'MovieFunctionButton' => new \PHPExiftool\Driver\Tag\NikonCustom\MovieFunctionButton(),
                'MoviePreviewButton' => new \PHPExiftool\Driver\Tag\NikonCustom\MoviePreviewButton(),
                'VerticalMultiSelector' => new \PHPExiftool\Driver\Tag\NikonCustom\VerticalMultiSelector(),
                'VerticalFuncButton' => new \PHPExiftool\Driver\Tag\NikonCustom\VerticalFuncButton(),
                'VerticalFuncButtonPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\VerticalFuncButtonPlusDials(),
                'AssignMovieRecordButton' => new \PHPExiftool\Driver\Tag\NikonCustom\AssignMovieRecordButton(),
                'DynamicAreaAFDisplay' => new \PHPExiftool\Driver\Tag\NikonCustom\DynamicAreaAFDisplay(),
                'StoreByOrientation' => new \PHPExiftool\Driver\Tag\NikonCustom\StoreByOrientation(),
                'GroupAreaAFIllumination' => new \PHPExiftool\Driver\Tag\NikonCustom\GroupAreaAFIllumination(),
                'SubSelectorAssignment' => new \PHPExiftool\Driver\Tag\NikonCustom\SubSelectorAssignment(),
                'MovieSubSelectorAssignment' => new \PHPExiftool\Driver\Tag\NikonCustom\MovieSubSelectorAssignment(),
                'SubSelector' => new \PHPExiftool\Driver\Tag\NikonCustom\SubSelector(),
                'SubSelectorPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\SubSelectorPlusDials(),
                'MatrixMetering' => new \PHPExiftool\Driver\Tag\NikonCustom\MatrixMetering(),
                'LiveViewButtonOptions' => new \PHPExiftool\Driver\Tag\NikonCustom\LiveViewButtonOptions(),
                'AFModeRestrictions' => new \PHPExiftool\Driver\Tag\NikonCustom\AFModeRestrictions(),
                'LimitAFAreaModeSelection' => new \PHPExiftool\Driver\Tag\NikonCustom\LimitAFAreaModeSelection(),
                'MovieFunctionButtonPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\MovieFunctionButtonPlusDials(),
                'MoviePreviewButtonPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\MoviePreviewButtonPlusDials(),
                'MovieSubSelectorAssignmentPlusDials' => new \PHPExiftool\Driver\Tag\NikonCustom\MovieSubSelectorAssignmentPlusDials(),
                'AssignRemoteFnButton' => new \PHPExiftool\Driver\Tag\NikonCustom\AssignRemoteFnButton(),
                'LensFocusFunctionButtons' => new \PHPExiftool\Driver\Tag\NikonCustom\LensFocusFunctionButtons(),
                'ImageReview' => new \PHPExiftool\Driver\Tag\NikonCustom\ImageReview(),
                'AutoISO' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoISO(),
                'AutoISOMax' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoISOMax(),
                'AutoISOMinShutterSpeed' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoISOMinShutterSpeed(),
                'RemoteOnDuration' => new \PHPExiftool\Driver\Tag\NikonCustom\RemoteOnDuration(),
                'AELock' => new \PHPExiftool\Driver\Tag\NikonCustom\AELock(),
                'ShootingModeSetting' => new \PHPExiftool\Driver\Tag\NikonCustom\ShootingModeSetting(),
                'TimerFunctionButton' => new \PHPExiftool\Driver\Tag\NikonCustom\TimerFunctionButton(),
                'Metering' => new \PHPExiftool\Driver\Tag\NikonCustom\Metering(),
                'ManualFlashOutput' => new \PHPExiftool\Driver\Tag\NikonCustom\ManualFlashOutput(),
                'FlashLevel' => new \PHPExiftool\Driver\Tag\NikonCustom\FlashLevel(),
                'FocusModeSetting' => new \PHPExiftool\Driver\Tag\NikonCustom\FocusModeSetting(),
                'AFAreaModeSetting' => new \PHPExiftool\Driver\Tag\NikonCustom\AFAreaModeSetting(),
                'ISODisplay' => new \PHPExiftool\Driver\Tag\NikonCustom\ISODisplay(),
                'RangeFinder' => new \PHPExiftool\Driver\Tag\NikonCustom\RangeFinder(),
                'DateImprint' => new \PHPExiftool\Driver\Tag\NikonCustom\DateImprint(),
                'EVStepSize' => new \PHPExiftool\Driver\Tag\NikonCustom\EVStepSize(),
                'PlaybackMenusTime' => new \PHPExiftool\Driver\Tag\NikonCustom\PlaybackMenusTime(),
                'LiveViewAF' => new \PHPExiftool\Driver\Tag\NikonCustom\LiveViewAF(),
                'NumberOfFocusPoints' => new \PHPExiftool\Driver\Tag\NikonCustom\NumberOfFocusPoints(),
                'ReverseExposureCompDial' => new \PHPExiftool\Driver\Tag\NikonCustom\ReverseExposureCompDial(),
                'ReverseShutterSpeedAperture' => new \PHPExiftool\Driver\Tag\NikonCustom\ReverseShutterSpeedAperture(),
                'FunctionButton' => new \PHPExiftool\Driver\Tag\NikonCustom\FunctionButton(),
                'MB-D10BatteryType' => new \PHPExiftool\Driver\Tag\NikonCustom\MBD10BatteryType(),
                'FlashControlBuilt-in' => new \PHPExiftool\Driver\Tag\NikonCustom\FlashControlBuiltIn(),
                'RepeatingFlashOutput' => new \PHPExiftool\Driver\Tag\NikonCustom\RepeatingFlashOutput(),
                'RepeatingFlashCount' => new \PHPExiftool\Driver\Tag\NikonCustom\RepeatingFlashCount(),
                'RepeatingFlashRate' => new \PHPExiftool\Driver\Tag\NikonCustom\RepeatingFlashRate(),
                'CommanderInternalTTLChannel' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalTTLChannel(),
                'CommanderInternalTTLCompBuiltin' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalTTLCompBuiltin(),
                'CommanderInternalTTLCompGroupA' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalTTLCompGroupA(),
                'CommanderInternalTTLCompGroupB' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalTTLCompGroupB(),
                'AF-OnForMB-D11' => new \PHPExiftool\Driver\Tag\NikonCustom\AFOnForMBD11(),
                'MB-D11BatteryType' => new \PHPExiftool\Driver\Tag\NikonCustom\MBD11BatteryType(),
                'BeepPitch' => new \PHPExiftool\Driver\Tag\NikonCustom\BeepPitch(),
                'BeepVolume' => new \PHPExiftool\Driver\Tag\NikonCustom\BeepVolume(),
                'ExposureControlStep' => new \PHPExiftool\Driver\Tag\NikonCustom\ExposureControlStep(),
                'ISOSensitivityStep' => new \PHPExiftool\Driver\Tag\NikonCustom\ISOSensitivityStep(),
                'OKButton' => new \PHPExiftool\Driver\Tag\NikonCustom\OKButton(),
                'SelfTimerInterval' => new \PHPExiftool\Driver\Tag\NikonCustom\SelfTimerInterval(),
                'FlashWarning' => new \PHPExiftool\Driver\Tag\NikonCustom\FlashWarning(),
                'LiveViewAFAreaMode' => new \PHPExiftool\Driver\Tag\NikonCustom\LiveViewAFAreaMode(),
                'LiveViewAFMode' => new \PHPExiftool\Driver\Tag\NikonCustom\LiveViewAFMode(),
                'Illumination' => new \PHPExiftool\Driver\Tag\NikonCustom\Illumination(),
                'MainDialExposureComp' => new \PHPExiftool\Driver\Tag\NikonCustom\MainDialExposureComp(),
                'CommandDials' => new \PHPExiftool\Driver\Tag\NikonCustom\CommandDials(),
                'MB-D80Batteries' => new \PHPExiftool\Driver\Tag\NikonCustom\MBD80Batteries(),
                'AutoFP' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoFP(),
                'CommanderChannel' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderChannel(),
                'CommanderInternalFlash' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalFlash(),
                'CommanderGroupAMode' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupAMode(),
                'CommanderGroupBMode' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupBMode(),
                'CommanderInternalTTLComp' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalTTLComp(),
                'CommanderInternalManualOutput' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderInternalManualOutput(),
                'CommanderGroupA_TTL-AAComp' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupATTLAAComp(),
                'CommanderGroupAManualOutput' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupAManualOutput(),
                'CommanderGroupB_TTL-AAComp' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupBTTLAAComp(),
                'CommanderGroupBManualOutput' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupBManualOutput(),
                'CenterAFArea' => new \PHPExiftool\Driver\Tag\NikonCustom\CenterAFArea(),
                'FocusAreaSelection' => new \PHPExiftool\Driver\Tag\NikonCustom\FocusAreaSelection(),
                'AFAreaIllumination' => new \PHPExiftool\Driver\Tag\NikonCustom\AFAreaIllumination(),
                'AutoBracketingSet' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoBracketingSet(),
                'AutoBracketingMode' => new \PHPExiftool\Driver\Tag\NikonCustom\AutoBracketingMode(),
                'LightSwitch' => new \PHPExiftool\Driver\Tag\NikonCustom\LightSwitch(),
                'MB-D12BatteryType' => new \PHPExiftool\Driver\Tag\NikonCustom\MBD12BatteryType(),
                'ElectronicFront-CurtainShutter' => new \PHPExiftool\Driver\Tag\NikonCustom\ElectronicFrontCurtainShutter(),
                'MovieAELockButtonAssignment' => new \PHPExiftool\Driver\Tag\NikonCustom\MovieAELockButtonAssignment(),
                'FineTuneOptHighlightWeighted' => new \PHPExiftool\Driver\Tag\NikonCustom\FineTuneOptHighlightWeighted(),
                'AF-OnForMB-D12' => new \PHPExiftool\Driver\Tag\NikonCustom\AFOnForMBD12(),
                'CenterFocusPoint' => new \PHPExiftool\Driver\Tag\NikonCustom\CenterFocusPoint(),
                'AELockForMB-D80' => new \PHPExiftool\Driver\Tag\NikonCustom\AELockForMBD80(),
                'MB-D80BatteryType' => new \PHPExiftool\Driver\Tag\NikonCustom\MBD80BatteryType(),
                'EasyExposureComp' => new \PHPExiftool\Driver\Tag\NikonCustom\EasyExposureComp(),
                'CommanderGroupA_TTLComp' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupATTLComp(),
                'CommanderGroupB_TTLComp' => new \PHPExiftool\Driver\Tag\NikonCustom\CommanderGroupBTTLComp(),
            );
        });
        $this['NikonCapture'] = $this->share(function(){
            return array(
                'BrightnessAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\BrightnessAdj(),
                'EnhanceDarkTones' => new \PHPExiftool\Driver\Tag\NikonCapture\EnhanceDarkTones(),
                'ColorBoostType' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorBoostType(),
                'ColorBoostLevel' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorBoostLevel(),
                'CropLeft' => new \PHPExiftool\Driver\Tag\NikonCapture\CropLeft(),
                'CropTop' => new \PHPExiftool\Driver\Tag\NikonCapture\CropTop(),
                'CropRight' => new \PHPExiftool\Driver\Tag\NikonCapture\CropRight(),
                'CropBottom' => new \PHPExiftool\Driver\Tag\NikonCapture\CropBottom(),
                'CropOutputWidthInches' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputWidthInches(),
                'CropOutputHeightInches' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputHeightInches(),
                'CropScaledResolution' => new \PHPExiftool\Driver\Tag\NikonCapture\CropScaledResolution(),
                'CropSourceResolution' => new \PHPExiftool\Driver\Tag\NikonCapture\CropSourceResolution(),
                'CropOutputResolution' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputResolution(),
                'CropOutputScale' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputScale(),
                'CropOutputWidth' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputWidth(),
                'CropOutputHeight' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputHeight(),
                'CropOutputPixels' => new \PHPExiftool\Driver\Tag\NikonCapture\CropOutputPixels(),
                'D-LightingHQShadow' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHQShadow(),
                'D-LightingHQHighlight' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHQHighlight(),
                'D-LightingHQColorBoost' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHQColorBoost(),
                'D-LightingHSAdjustment' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHSAdjustment(),
                'D-LightingHSColorBoost' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHSColorBoost(),
                'ExposureAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\ExposureAdj(),
                'ExposureAdj2' => new \PHPExiftool\Driver\Tag\NikonCapture\ExposureAdj2(),
                'ActiveD-Lighting' => new \PHPExiftool\Driver\Tag\NikonCapture\ActiveDLighting(),
                'ActiveD-LightingMode' => new \PHPExiftool\Driver\Tag\NikonCapture\ActiveDLightingMode(),
                'ShadowProtection' => new \PHPExiftool\Driver\Tag\NikonCapture\ShadowProtection(),
                'SaturationAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\SaturationAdj(),
                'HighlightProtection' => new \PHPExiftool\Driver\Tag\NikonCapture\HighlightProtection(),
                'LCHEditor' => new \PHPExiftool\Driver\Tag\NikonCapture\LCHEditor(),
                'HistogramXML' => new \PHPExiftool\Driver\Tag\NikonCapture\HistogramXML(),
                'ColorAberrationControl' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorAberrationControl(),
                'D-LightingHQ' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHQ(),
                'StraightenAngle' => new \PHPExiftool\Driver\Tag\NikonCapture\StraightenAngle(),
                'EditVersionName' => new \PHPExiftool\Driver\Tag\NikonCapture\EditVersionName(),
                'QuickFix' => new \PHPExiftool\Driver\Tag\NikonCapture\QuickFix(),
                'ColorBooster' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorBooster(),
                'D-LightingHQSelected' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHQSelected(),
                'NoiseReduction' => new \PHPExiftool\Driver\Tag\NikonCapture\NoiseReduction(),
                'UnsharpMask' => new \PHPExiftool\Driver\Tag\NikonCapture\UnsharpMask(),
                'Curves' => new \PHPExiftool\Driver\Tag\NikonCapture\Curves(),
                'ColorBalanceAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorBalanceAdj(),
                'AdvancedRaw' => new \PHPExiftool\Driver\Tag\NikonCapture\AdvancedRaw(),
                'WhiteBalanceAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\WhiteBalanceAdj(),
                'VignetteControl' => new \PHPExiftool\Driver\Tag\NikonCapture\VignetteControl(),
                'FlipHorizontal' => new \PHPExiftool\Driver\Tag\NikonCapture\FlipHorizontal(),
                'Rotation' => new \PHPExiftool\Driver\Tag\NikonCapture\Rotation(),
                'PhotoEffects' => new \PHPExiftool\Driver\Tag\NikonCapture\PhotoEffects(),
                'VignetteControlIntensity' => new \PHPExiftool\Driver\Tag\NikonCapture\VignetteControlIntensity(),
                'D-LightingHS' => new \PHPExiftool\Driver\Tag\NikonCapture\DLightingHS(),
                'PictureControl' => new \PHPExiftool\Driver\Tag\NikonCapture\PictureControl(),
                'PhotoEffectHistoryXML' => new \PHPExiftool\Driver\Tag\NikonCapture\PhotoEffectHistoryXML(),
                'AutoRedEye' => new \PHPExiftool\Driver\Tag\NikonCapture\AutoRedEye(),
                'ImageDustOff' => new \PHPExiftool\Driver\Tag\NikonCapture\ImageDustOff(),
                'EdgeNoiseReduction' => new \PHPExiftool\Driver\Tag\NikonCapture\EdgeNoiseReduction(),
                'ColorMoireReductionMode' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorMoireReductionMode(),
                'NoiseReductionIntensity' => new \PHPExiftool\Driver\Tag\NikonCapture\NoiseReductionIntensity(),
                'NoiseReductionSharpness' => new \PHPExiftool\Driver\Tag\NikonCapture\NoiseReductionSharpness(),
                'NoiseReductionMethod' => new \PHPExiftool\Driver\Tag\NikonCapture\NoiseReductionMethod(),
                'ColorMoireReduction' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorMoireReduction(),
                'ColorNoiseReductionIntensity' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorNoiseReductionIntensity(),
                'ColorNoiseReductionSharpness' => new \PHPExiftool\Driver\Tag\NikonCapture\ColorNoiseReductionSharpness(),
                'PhotoEffectsType' => new \PHPExiftool\Driver\Tag\NikonCapture\PhotoEffectsType(),
                'PhotoEffectsRed' => new \PHPExiftool\Driver\Tag\NikonCapture\PhotoEffectsRed(),
                'PhotoEffectsGreen' => new \PHPExiftool\Driver\Tag\NikonCapture\PhotoEffectsGreen(),
                'PhotoEffectsBlue' => new \PHPExiftool\Driver\Tag\NikonCapture\PhotoEffectsBlue(),
                'PictureControlActive' => new \PHPExiftool\Driver\Tag\NikonCapture\PictureControlActive(),
                'PictureControlMode' => new \PHPExiftool\Driver\Tag\NikonCapture\PictureControlMode(),
                'QuickAdjust' => new \PHPExiftool\Driver\Tag\NikonCapture\QuickAdjust(),
                'SharpeningAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\SharpeningAdj(),
                'ContrastAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\ContrastAdj(),
                'HueAdj' => new \PHPExiftool\Driver\Tag\NikonCapture\HueAdj(),
                'RedEyeCorrection' => new \PHPExiftool\Driver\Tag\NikonCapture\RedEyeCorrection(),
                'UnsharpCount' => new \PHPExiftool\Driver\Tag\NikonCapture\UnsharpCount(),
                'Unsharp1Color' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp1Color(),
                'Unsharp1Intensity' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp1Intensity(),
                'Unsharp1HaloWidth' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp1HaloWidth(),
                'Unsharp1Threshold' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp1Threshold(),
                'Unsharp2Color' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp2Color(),
                'Unsharp2Intensity' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp2Intensity(),
                'Unsharp2HaloWidth' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp2HaloWidth(),
                'Unsharp2Threshold' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp2Threshold(),
                'Unsharp3Color' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp3Color(),
                'Unsharp3Intensity' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp3Intensity(),
                'Unsharp3HaloWidth' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp3HaloWidth(),
                'Unsharp3Threshold' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp3Threshold(),
                'Unsharp4Color' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp4Color(),
                'Unsharp4Intensity' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp4Intensity(),
                'Unsharp4HaloWidth' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp4HaloWidth(),
                'Unsharp4Threshold' => new \PHPExiftool\Driver\Tag\NikonCapture\Unsharp4Threshold(),
                'WBAdjRedBalance' => new \PHPExiftool\Driver\Tag\NikonCapture\WBAdjRedBalance(),
                'WBAdjBlueBalance' => new \PHPExiftool\Driver\Tag\NikonCapture\WBAdjBlueBalance(),
                'WBAdjMode' => new \PHPExiftool\Driver\Tag\NikonCapture\WBAdjMode(),
                'WBAdjLighting' => new \PHPExiftool\Driver\Tag\NikonCapture\WBAdjLighting(),
                'WBAdjTemperature' => new \PHPExiftool\Driver\Tag\NikonCapture\WBAdjTemperature(),
                'WBAdjTint' => new \PHPExiftool\Driver\Tag\NikonCapture\WBAdjTint(),
            );
        });
        $this['Nintendo'] = $this->share(function(){
            return array(
                'ModelID' => new \PHPExiftool\Driver\Tag\Nintendo\ModelID(),
                'TimeStamp' => new \PHPExiftool\Driver\Tag\Nintendo\TimeStamp(),
                'InternalSerialNumber' => new \PHPExiftool\Driver\Tag\Nintendo\InternalSerialNumber(),
                'Parallax' => new \PHPExiftool\Driver\Tag\Nintendo\Parallax(),
                'Category' => new \PHPExiftool\Driver\Tag\Nintendo\Category(),
            );
        });
        $this['XML'] = $this->share(function(){
            return array(
                'AppVersion' => new \PHPExiftool\Driver\Tag\XML\AppVersion(),
                'Application' => new \PHPExiftool\Driver\Tag\XML\Application(),
                'Characters' => new \PHPExiftool\Driver\Tag\XML\Characters(),
                'CharactersWithSpaces' => new \PHPExiftool\Driver\Tag\XML\CharactersWithSpaces(),
                'CheckedBy' => new \PHPExiftool\Driver\Tag\XML\CheckedBy(),
                'Client' => new \PHPExiftool\Driver\Tag\XML\Client(),
                'Company' => new \PHPExiftool\Driver\Tag\XML\Company(),
                'DateCompleted' => new \PHPExiftool\Driver\Tag\XML\DateCompleted(),
                'Department' => new \PHPExiftool\Driver\Tag\XML\Department(),
                'Destination' => new \PHPExiftool\Driver\Tag\XML\Destination(),
                'Disposition' => new \PHPExiftool\Driver\Tag\XML\Disposition(),
                'Division' => new \PHPExiftool\Driver\Tag\XML\Division(),
                'DocSecurity' => new \PHPExiftool\Driver\Tag\XML\DocSecurity(),
                'DocumentNumber' => new \PHPExiftool\Driver\Tag\XML\DocumentNumber(),
                'Editor' => new \PHPExiftool\Driver\Tag\XML\Editor(),
                'ForwardTo' => new \PHPExiftool\Driver\Tag\XML\ForwardTo(),
                'Group' => new \PHPExiftool\Driver\Tag\XML\Group(),
                'HeadingPairs' => new \PHPExiftool\Driver\Tag\XML\HeadingPairs(),
                'HiddenSlides' => new \PHPExiftool\Driver\Tag\XML\HiddenSlides(),
                'HyperlinkBase' => new \PHPExiftool\Driver\Tag\XML\HyperlinkBase(),
                'HyperlinksChanged' => new \PHPExiftool\Driver\Tag\XML\HyperlinksChanged(),
                'Language' => new \PHPExiftool\Driver\Tag\XML\Language(),
                'Lines' => new \PHPExiftool\Driver\Tag\XML\Lines(),
                'LinksUpToDate' => new \PHPExiftool\Driver\Tag\XML\LinksUpToDate(),
                'MMClips' => new \PHPExiftool\Driver\Tag\XML\MMClips(),
                'Mailstop' => new \PHPExiftool\Driver\Tag\XML\Mailstop(),
                'Manager' => new \PHPExiftool\Driver\Tag\XML\Manager(),
                'Matter' => new \PHPExiftool\Driver\Tag\XML\Matter(),
                'Notes' => new \PHPExiftool\Driver\Tag\XML\Notes(),
                'Office' => new \PHPExiftool\Driver\Tag\XML\Office(),
                'Owner' => new \PHPExiftool\Driver\Tag\XML\Owner(),
                'Pages' => new \PHPExiftool\Driver\Tag\XML\Pages(),
                'Paragraphs' => new \PHPExiftool\Driver\Tag\XML\Paragraphs(),
                'PresentationFormat' => new \PHPExiftool\Driver\Tag\XML\PresentationFormat(),
                'Project' => new \PHPExiftool\Driver\Tag\XML\Project(),
                'Publisher' => new \PHPExiftool\Driver\Tag\XML\Publisher(),
                'Purpose' => new \PHPExiftool\Driver\Tag\XML\Purpose(),
                'ReceivedFrom' => new \PHPExiftool\Driver\Tag\XML\ReceivedFrom(),
                'RecordedBy' => new \PHPExiftool\Driver\Tag\XML\RecordedBy(),
                'RecordedDate' => new \PHPExiftool\Driver\Tag\XML\RecordedDate(),
                'Reference' => new \PHPExiftool\Driver\Tag\XML\Reference(),
                'ScaleCrop' => new \PHPExiftool\Driver\Tag\XML\ScaleCrop(),
                'SharedDoc' => new \PHPExiftool\Driver\Tag\XML\SharedDoc(),
                'Slides' => new \PHPExiftool\Driver\Tag\XML\Slides(),
                'Source' => new \PHPExiftool\Driver\Tag\XML\Source(),
                'Status' => new \PHPExiftool\Driver\Tag\XML\Status(),
                'TelephoneNumber' => new \PHPExiftool\Driver\Tag\XML\TelephoneNumber(),
                'Template' => new \PHPExiftool\Driver\Tag\XML\Template(),
                'TitlesOfParts' => new \PHPExiftool\Driver\Tag\XML\TitlesOfParts(),
                'TotalEditTime' => new \PHPExiftool\Driver\Tag\XML\TotalEditTime(),
                'Typist' => new \PHPExiftool\Driver\Tag\XML\Typist(),
                'Words' => new \PHPExiftool\Driver\Tag\XML\Words(),
                'Category' => new \PHPExiftool\Driver\Tag\XML\Category(),
                'CreateDate' => new \PHPExiftool\Driver\Tag\XML\CreateDate(),
                'CreatedType' => new \PHPExiftool\Driver\Tag\XML\CreatedType(),
                'Keywords' => new \PHPExiftool\Driver\Tag\XML\Keywords(),
                'LastModifiedBy' => new \PHPExiftool\Driver\Tag\XML\LastModifiedBy(),
                'LastPrinted' => new \PHPExiftool\Driver\Tag\XML\LastPrinted(),
                'ModifyDate' => new \PHPExiftool\Driver\Tag\XML\ModifyDate(),
                'ModifiedType' => new \PHPExiftool\Driver\Tag\XML\ModifiedType(),
                'RevisionNumber' => new \PHPExiftool\Driver\Tag\XML\RevisionNumber(),
                'DateTimeOriginal' => new \PHPExiftool\Driver\Tag\XML\DateTimeOriginal(),
                'Duration' => new \PHPExiftool\Driver\Tag\XML\Duration(),
                'GPSLatitude' => new \PHPExiftool\Driver\Tag\XML\GPSLatitude(),
                'GPSLongitude' => new \PHPExiftool\Driver\Tag\XML\GPSLongitude(),
                'GPSMapDatum' => new \PHPExiftool\Driver\Tag\XML\GPSMapDatum(),
                'XMLFileType' => new \PHPExiftool\Driver\Tag\XML\XMLFileType(),
                'Cast' => new \PHPExiftool\Driver\Tag\XML\Cast(),
                'Codirectors' => new \PHPExiftool\Driver\Tag\XML\Codirectors(),
                'Directors' => new \PHPExiftool\Driver\Tag\XML\Directors(),
                'Producers' => new \PHPExiftool\Driver\Tag\XML\Producers(),
                'Screenwriters' => new \PHPExiftool\Driver\Tag\XML\Screenwriters(),
                'Studio' => new \PHPExiftool\Driver\Tag\XML\Studio(),
                'LastUpdate' => new \PHPExiftool\Driver\Tag\XML\LastUpdate(),
                'Author' => new \PHPExiftool\Driver\Tag\XML\Author(),
                'Comment' => new \PHPExiftool\Driver\Tag\XML\Comment(),
                'Copyright' => new \PHPExiftool\Driver\Tag\XML\Copyright(),
                'Projects' => new \PHPExiftool\Driver\Tag\XML\Projects(),
                'Title' => new \PHPExiftool\Driver\Tag\XML\Title(),
            );
        });
        $this['Olympus'] = $this->share(function(){
            return array(
                'Make' => new \PHPExiftool\Driver\Tag\Olympus\Make(),
                'Model' => new \PHPExiftool\Driver\Tag\Olympus\Model(),
                'FNumber' => new \PHPExiftool\Driver\Tag\Olympus\FNumber(),
                'DateTime1' => new \PHPExiftool\Driver\Tag\Olympus\DateTime1(),
                'DateTime2' => new \PHPExiftool\Driver\Tag\Olympus\DateTime2(),
                'CameraSettingsVersion' => new \PHPExiftool\Driver\Tag\Olympus\CameraSettingsVersion(),
                'PreviewImageValid' => new \PHPExiftool\Driver\Tag\Olympus\PreviewImageValid(),
                'PreviewImageStart' => new \PHPExiftool\Driver\Tag\Olympus\PreviewImageStart(),
                'PreviewImageLength' => new \PHPExiftool\Driver\Tag\Olympus\PreviewImageLength(),
                'ExposureMode' => new \PHPExiftool\Driver\Tag\Olympus\ExposureMode(),
                'AELock' => new \PHPExiftool\Driver\Tag\Olympus\AELock(),
                'MeteringMode' => new \PHPExiftool\Driver\Tag\Olympus\MeteringMode(),
                'ExposureShift' => new \PHPExiftool\Driver\Tag\Olympus\ExposureShift(),
                'NDFilter' => new \PHPExiftool\Driver\Tag\Olympus\NDFilter(),
                'MacroMode' => new \PHPExiftool\Driver\Tag\Olympus\MacroMode(),
                'FocusMode' => new \PHPExiftool\Driver\Tag\Olympus\FocusMode(),
                'FocusProcess' => new \PHPExiftool\Driver\Tag\Olympus\FocusProcess(),
                'AFSearch' => new \PHPExiftool\Driver\Tag\Olympus\AFSearch(),
                'AFAreas' => new \PHPExiftool\Driver\Tag\Olympus\AFAreas(),
                'AFPointSelected' => new \PHPExiftool\Driver\Tag\Olympus\AFPointSelected(),
                'AFFineTune' => new \PHPExiftool\Driver\Tag\Olympus\AFFineTune(),
                'AFFineTuneAdj' => new \PHPExiftool\Driver\Tag\Olympus\AFFineTuneAdj(),
                'FlashMode' => new \PHPExiftool\Driver\Tag\Olympus\FlashMode(),
                'FlashExposureComp' => new \PHPExiftool\Driver\Tag\Olympus\FlashExposureComp(),
                'FlashRemoteControl' => new \PHPExiftool\Driver\Tag\Olympus\FlashRemoteControl(),
                'FlashControlMode' => new \PHPExiftool\Driver\Tag\Olympus\FlashControlMode(),
                'FlashIntensity' => new \PHPExiftool\Driver\Tag\Olympus\FlashIntensity(),
                'ManualFlashStrength' => new \PHPExiftool\Driver\Tag\Olympus\ManualFlashStrength(),
                'WhiteBalance2' => new \PHPExiftool\Driver\Tag\Olympus\WhiteBalance2(),
                'WhiteBalanceTemperature' => new \PHPExiftool\Driver\Tag\Olympus\WhiteBalanceTemperature(),
                'WhiteBalanceBracket' => new \PHPExiftool\Driver\Tag\Olympus\WhiteBalanceBracket(),
                'CustomSaturation' => new \PHPExiftool\Driver\Tag\Olympus\CustomSaturation(),
                'ModifiedSaturation' => new \PHPExiftool\Driver\Tag\Olympus\ModifiedSaturation(),
                'ContrastSetting' => new \PHPExiftool\Driver\Tag\Olympus\ContrastSetting(),
                'SharpnessSetting' => new \PHPExiftool\Driver\Tag\Olympus\SharpnessSetting(),
                'ColorSpace' => new \PHPExiftool\Driver\Tag\Olympus\ColorSpace(),
                'SceneMode' => new \PHPExiftool\Driver\Tag\Olympus\SceneMode(),
                'NoiseReduction' => new \PHPExiftool\Driver\Tag\Olympus\NoiseReduction(),
                'DistortionCorrection' => new \PHPExiftool\Driver\Tag\Olympus\DistortionCorrection(),
                'ShadingCompensation' => new \PHPExiftool\Driver\Tag\Olympus\ShadingCompensation(),
                'CompressionFactor' => new \PHPExiftool\Driver\Tag\Olympus\CompressionFactor(),
                'Gradation' => new \PHPExiftool\Driver\Tag\Olympus\Gradation(),
                'PictureMode' => new \PHPExiftool\Driver\Tag\Olympus\PictureMode(),
                'PictureModeSaturation' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeSaturation(),
                'PictureModeHue' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeHue(),
                'PictureModeContrast' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeContrast(),
                'PictureModeSharpness' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeSharpness(),
                'PictureModeBWFilter' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeBWFilter(),
                'PictureModeTone' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeTone(),
                'NoiseFilter' => new \PHPExiftool\Driver\Tag\Olympus\NoiseFilter(),
                'ArtFilter' => new \PHPExiftool\Driver\Tag\Olympus\ArtFilter(),
                'MagicFilter' => new \PHPExiftool\Driver\Tag\Olympus\MagicFilter(),
                'PictureModeEffect' => new \PHPExiftool\Driver\Tag\Olympus\PictureModeEffect(),
                'ToneLevel' => new \PHPExiftool\Driver\Tag\Olympus\ToneLevel(),
                'ArtFilterEffect' => new \PHPExiftool\Driver\Tag\Olympus\ArtFilterEffect(),
                'DriveMode' => new \PHPExiftool\Driver\Tag\Olympus\DriveMode(),
                'PanoramaMode' => new \PHPExiftool\Driver\Tag\Olympus\PanoramaMode(),
                'ImageQuality2' => new \PHPExiftool\Driver\Tag\Olympus\ImageQuality2(),
                'ImageStabilization' => new \PHPExiftool\Driver\Tag\Olympus\ImageStabilization(),
                'StackedImage' => new \PHPExiftool\Driver\Tag\Olympus\StackedImage(),
                'ManometerPressure' => new \PHPExiftool\Driver\Tag\Olympus\ManometerPressure(),
                'ManometerReading' => new \PHPExiftool\Driver\Tag\Olympus\ManometerReading(),
                'ExtendedWBDetect' => new \PHPExiftool\Driver\Tag\Olympus\ExtendedWBDetect(),
                'RollAngle' => new \PHPExiftool\Driver\Tag\Olympus\RollAngle(),
                'PitchAngle' => new \PHPExiftool\Driver\Tag\Olympus\PitchAngle(),
                'DateTimeUTC' => new \PHPExiftool\Driver\Tag\Olympus\DateTimeUTC(),
                'StartTime' => new \PHPExiftool\Driver\Tag\Olympus\StartTime(),
                'EndTime' => new \PHPExiftool\Driver\Tag\Olympus\EndTime(),
                'Duration' => new \PHPExiftool\Driver\Tag\Olympus\Duration(),
                'Comment' => new \PHPExiftool\Driver\Tag\Olympus\Comment(),
                'EquipmentVersion' => new \PHPExiftool\Driver\Tag\Olympus\EquipmentVersion(),
                'CameraType2' => new \PHPExiftool\Driver\Tag\Olympus\CameraType2(),
                'SerialNumber' => new \PHPExiftool\Driver\Tag\Olympus\SerialNumber(),
                'InternalSerialNumber' => new \PHPExiftool\Driver\Tag\Olympus\InternalSerialNumber(),
                'FocalPlaneDiagonal' => new \PHPExiftool\Driver\Tag\Olympus\FocalPlaneDiagonal(),
                'BodyFirmwareVersion' => new \PHPExiftool\Driver\Tag\Olympus\BodyFirmwareVersion(),
                'LensType' => new \PHPExiftool\Driver\Tag\Olympus\LensType(),
                'LensSerialNumber' => new \PHPExiftool\Driver\Tag\Olympus\LensSerialNumber(),
                'LensModel' => new \PHPExiftool\Driver\Tag\Olympus\LensModel(),
                'LensFirmwareVersion' => new \PHPExiftool\Driver\Tag\Olympus\LensFirmwareVersion(),
                'MaxApertureAtMinFocal' => new \PHPExiftool\Driver\Tag\Olympus\MaxApertureAtMinFocal(),
                'MaxApertureAtMaxFocal' => new \PHPExiftool\Driver\Tag\Olympus\MaxApertureAtMaxFocal(),
                'MinFocalLength' => new \PHPExiftool\Driver\Tag\Olympus\MinFocalLength(),
                'MaxFocalLength' => new \PHPExiftool\Driver\Tag\Olympus\MaxFocalLength(),
                'MaxAperture' => new \PHPExiftool\Driver\Tag\Olympus\MaxAperture(),
                'LensProperties' => new \PHPExiftool\Driver\Tag\Olympus\LensProperties(),
                'Extender' => new \PHPExiftool\Driver\Tag\Olympus\Extender(),
                'ExtenderSerialNumber' => new \PHPExiftool\Driver\Tag\Olympus\ExtenderSerialNumber(),
                'ExtenderModel' => new \PHPExiftool\Driver\Tag\Olympus\ExtenderModel(),
                'ExtenderFirmwareVersion' => new \PHPExiftool\Driver\Tag\Olympus\ExtenderFirmwareVersion(),
                'ConversionLens' => new \PHPExiftool\Driver\Tag\Olympus\ConversionLens(),
                'FlashType' => new \PHPExiftool\Driver\Tag\Olympus\FlashType(),
                'FlashModel' => new \PHPExiftool\Driver\Tag\Olympus\FlashModel(),
                'FlashFirmwareVersion' => new \PHPExiftool\Driver\Tag\Olympus\FlashFirmwareVersion(),
                'FlashSerialNumber' => new \PHPExiftool\Driver\Tag\Olympus\FlashSerialNumber(),
                'FocusInfoVersion' => new \PHPExiftool\Driver\Tag\Olympus\FocusInfoVersion(),
                'AutoFocus' => new \PHPExiftool\Driver\Tag\Olympus\AutoFocus(),
                'SceneDetect' => new \PHPExiftool\Driver\Tag\Olympus\SceneDetect(),
                'SceneArea' => new \PHPExiftool\Driver\Tag\Olympus\SceneArea(),
                'SceneDetectData' => new \PHPExiftool\Driver\Tag\Olympus\SceneDetectData(),
                'ZoomStepCount' => new \PHPExiftool\Driver\Tag\Olympus\ZoomStepCount(),
                'FocusStepCount' => new \PHPExiftool\Driver\Tag\Olympus\FocusStepCount(),
                'FocusStepInfinity' => new \PHPExiftool\Driver\Tag\Olympus\FocusStepInfinity(),
                'FocusStepNear' => new \PHPExiftool\Driver\Tag\Olympus\FocusStepNear(),
                'FocusDistance' => new \PHPExiftool\Driver\Tag\Olympus\FocusDistance(),
                'AFPoint' => new \PHPExiftool\Driver\Tag\Olympus\AFPoint(),
                'ExternalFlash' => new \PHPExiftool\Driver\Tag\Olympus\ExternalFlash(),
                'ExternalFlashGuideNumber' => new \PHPExiftool\Driver\Tag\Olympus\ExternalFlashGuideNumber(),
                'ExternalFlashBounce' => new \PHPExiftool\Driver\Tag\Olympus\ExternalFlashBounce(),
                'ExternalFlashZoom' => new \PHPExiftool\Driver\Tag\Olympus\ExternalFlashZoom(),
                'InternalFlash' => new \PHPExiftool\Driver\Tag\Olympus\InternalFlash(),
                'ManualFlash' => new \PHPExiftool\Driver\Tag\Olympus\ManualFlash(),
                'MacroLED' => new \PHPExiftool\Driver\Tag\Olympus\MacroLED(),
                'SensorTemperature' => new \PHPExiftool\Driver\Tag\Olympus\SensorTemperature(),
                'ImageProcessingVersion' => new \PHPExiftool\Driver\Tag\Olympus\ImageProcessingVersion(),
                'WB_RBLevels' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels(),
                'WB_RBLevels3000K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels3000K(),
                'WB_RBLevels3300K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels3300K(),
                'WB_RBLevels3600K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels3600K(),
                'WB_RBLevels3900K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels3900K(),
                'WB_RBLevels4000K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels4000K(),
                'WB_RBLevels4300K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels4300K(),
                'WB_RBLevels4500K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels4500K(),
                'WB_RBLevels4800K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels4800K(),
                'WB_RBLevels5300K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels5300K(),
                'WB_RBLevels6000K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels6000K(),
                'WB_RBLevels6600K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels6600K(),
                'WB_RBLevels7500K' => new \PHPExiftool\Driver\Tag\Olympus\WBRBLevels7500K(),
                'WB_RBLevelsCWB1