/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.sound;

import com.flagstone.transform.util.sound.SoundDecoder;
import com.flagstone.transform.util.sound.SoundEncoding;
import com.flagstone.transform.util.sound.SoundProvider;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SoundRegistry {
    private static Map<String, SoundProvider> providers = new LinkedHashMap<String, SoundProvider>();

    public static void registerProvider(String mimeType, SoundProvider decoder) {
        providers.put(mimeType, decoder);
    }

    public static SoundDecoder getSoundProvider(String mimeType) {
        if (providers.containsKey(mimeType)) {
            return providers.get(mimeType).newDecoder();
        }
        throw new IllegalArgumentException();
    }

    private SoundRegistry() {
    }

    static {
        for (SoundEncoding encoding : SoundEncoding.values()) {
            SoundRegistry.registerProvider(encoding.getMimeType(), encoding.getProvider());
        }
    }
}

