/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.exception.IllegalArgumentValueException;
import com.flagstone.transform.sound.SoundFormat;
import java.io.IOException;
import java.util.Arrays;

public final class DefineSound
implements DefineTag {
    private static final String FORMAT = "DefineSound: { identifier=%d; format=%s; rate=%d; channelCount=%d; sampleSize=%d; sampleCount=%d}";
    private int identifier;
    private int format;
    private int rate;
    private int channelCount;
    private int sampleSize;
    private int sampleCount;
    private byte[] sound;
    private transient int length;

    public DefineSound(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        int info = coder.readByte();
        this.format = (info & 0xF0) >> 4;
        switch (info & 0xC) {
            case 0: {
                this.rate = 5512;
                break;
            }
            case 4: {
                this.rate = 11025;
                break;
            }
            case 8: {
                this.rate = 22050;
                break;
            }
            case 12: {
                this.rate = 44100;
                break;
            }
            default: {
                this.rate = 0;
            }
        }
        this.sampleSize = ((info & 2) >> 1) + 1;
        this.channelCount = (info & 1) + 1;
        this.sampleCount = coder.readInt();
        this.sound = coder.readBytes(new byte[this.length - coder.bytesRead()]);
        coder.unmark();
    }

    public DefineSound(int uid, SoundFormat aFormat, int playbackRate, int channels, int size, int count, byte[] bytes) {
        this.setIdentifier(uid);
        this.setFormat(aFormat);
        this.setRate(playbackRate);
        this.setChannelCount(channels);
        this.setSampleSize(size);
        this.setSampleCount(count);
        this.setSound(bytes);
    }

    public DefineSound(DefineSound object) {
        this.identifier = object.identifier;
        this.format = object.format;
        this.rate = object.rate;
        this.channelCount = object.channelCount;
        this.sampleSize = object.sampleSize;
        this.sampleCount = object.sampleCount;
        this.sound = object.sound;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public SoundFormat getFormat() {
        return SoundFormat.fromInt(this.format);
    }

    public int getRate() {
        return this.rate;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public byte[] getSound() {
        return Arrays.copyOf(this.sound, this.sound.length);
    }

    public void setFormat(SoundFormat encoding) {
        this.format = encoding.getValue();
    }

    public void setRate(int samplingRate) {
        if (samplingRate != 5512 && samplingRate != 11025 && samplingRate != 22050 && samplingRate != 44100) {
            throw new IllegalArgumentValueException(new int[]{5512, 11025, 22050, 44100}, samplingRate);
        }
        this.rate = samplingRate;
    }

    public void setChannelCount(int channels) {
        if (channels < 1 || channels > 2) {
            throw new IllegalArgumentRangeException(1, 2, channels);
        }
        this.channelCount = channels;
    }

    public void setSampleSize(int size) {
        if (size < 1 || size > 2) {
            throw new IllegalArgumentRangeException(1, 2, size);
        }
        this.sampleSize = size;
    }

    public void setSampleCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentRangeException(1, Integer.MAX_VALUE, count);
        }
        this.sampleCount = count;
    }

    public void setSound(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.sound = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public DefineSound copy() {
        return new DefineSound(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.format, this.rate, this.channelCount, this.sampleSize, this.sampleCount);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 7;
        this.length += this.sound.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(959);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x380 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        int bits = this.format << 4;
        switch (this.rate) {
            case 11025: {
                bits |= 4;
                break;
            }
            case 22050: {
                bits |= 8;
                break;
            }
            case 44100: {
                bits |= 4;
                bits |= 8;
                break;
            }
        }
        bits |= this.sampleSize - 1 << 1;
        coder.writeByte(bits |= this.channelCount - 1);
        coder.writeInt(this.sampleCount);
        coder.writeBytes(this.sound);
        coder.check(this.length);
        coder.unmark();
    }
}

