/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.movieclip;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.ActionData;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class InitializeMovieClip
implements MovieTag {
    private static final String FORMAT = "Initialize: { identifier=%d; actions=%s}";
    private int identifier;
    private List<Action> actions;
    private transient int length;

    public InitializeMovieClip(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.actions = new ArrayList<Action>();
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        if (decoder == null) {
            this.actions.add(new ActionData(coder.readBytes(new byte[this.length - 2])));
        } else {
            while (coder.bytesRead() < this.length) {
                decoder.getObject(this.actions, coder, context);
            }
        }
        coder.unmark();
    }

    public InitializeMovieClip(int uid, List<Action> list) {
        this.setIdentifier(uid);
        this.setActions(list);
    }

    public InitializeMovieClip(InitializeMovieClip object) {
        this.identifier = object.identifier;
        this.actions = new ArrayList<Action>(object.actions);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public InitializeMovieClip add(Action anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException();
        }
        this.actions.add(anAction);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    @Override
    public InitializeMovieClip copy() {
        return new InitializeMovieClip(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.actions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        for (Action action : this.actions) {
            this.length += action.prepareToEncode(context);
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(3839);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xEC0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }
}

