/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import java.util.LinkedHashMap;
import java.util.Map;

public enum Interpolation {
    NORMAL(0),
    LINEAR(16);

    private static final Map<Integer, Interpolation> TABLE;
    private final int value;

    public static Interpolation fromInt(int value) {
        return TABLE.get(value);
    }

    private Interpolation(int spread) {
        this.value = spread;
    }

    public int getValue() {
        return this.value;
    }

    static {
        TABLE = new LinkedHashMap<Integer, Interpolation>();
        for (Interpolation action : Interpolation.values()) {
            TABLE.put(action.value, action);
        }
    }
}

