/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import java.io.IOException;

public final class BitmapFill
implements FillStyle {
    private static final String FORMAT = "BitmapFill: { identifier=%d; transform=%s}";
    private static final int CLIPPED_MASK = 1;
    private static final int SMOOTHED_MASK = 2;
    private transient int type;
    private int identifier;
    private CoordTransform transform;

    public BitmapFill(int fillType, SWFDecoder coder) throws IOException {
        this.type = fillType;
        this.identifier = coder.readUnsignedShort();
        this.transform = new CoordTransform(coder);
    }

    public BitmapFill(boolean tiled, boolean smoothed, int uid, CoordTransform position) {
        this.type = 64;
        this.setTiled(tiled);
        this.setSmoothed(smoothed);
        this.setIdentifier(uid);
        this.setTransform(position);
    }

    public BitmapFill(BitmapFill object) {
        this.type = object.type;
        this.identifier = object.identifier;
        this.transform = object.transform;
    }

    public boolean isTiled() {
        return (this.type & 1) != 0;
    }

    public void setTiled(boolean tiled) {
        this.type = tiled ? (this.type &= 0xFFFFFFFE) : (this.type |= 1);
    }

    public boolean isSmoothed() {
        return (this.type & 2) != 0;
    }

    public void setSmoothed(boolean smoothed) {
        this.type = smoothed ? (this.type &= 0xFFFFFFFD) : (this.type |= 2);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public void setTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.transform = matrix;
    }

    @Override
    public BitmapFill copy() {
        return new BitmapFill(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.transform);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 3 + this.transform.prepareToEncode(context);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.type);
        coder.writeShort(this.identifier);
        this.transform.encode(coder, context);
    }
}

