/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

import com.flagstone.transform.CharacterEncoding;
import com.flagstone.transform.coder.DecoderRegistry;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Context {
    public static final int VERSION = 1;
    public static final int TYPE = 2;
    public static final int TRANSPARENT = 3;
    public static final int WIDE_CODES = 4;
    public static final int ARRAY_EXTENDED = 8;
    public static final int POSTSCRIPT = 9;
    public static final int SCALING_STROKE = 10;
    public static final int FILL_SIZE = 11;
    public static final int LINE_SIZE = 12;
    public static final int ADVANCE_SIZE = 13;
    public static final int GLYPH_SIZE = 14;
    public static final int SHAPE_SIZE = 15;
    public static final int LAST = 16;
    public static final int COMPRESSED = 17;
    public static final int MENU_BUTTON = 18;
    private String encoding = CharacterEncoding.UTF8.toString();
    private DecoderRegistry registry;
    private final transient Map<Integer, Integer> variables = new LinkedHashMap<Integer, Integer>();

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String charSet) {
        if (!Charset.isSupported(charSet)) {
            throw new UnsupportedCharsetException(charSet);
        }
        this.encoding = charSet;
    }

    public final int strlen(String string) {
        try {
            return string.getBytes(this.encoding).length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final DecoderRegistry getRegistry() {
        return this.registry;
    }

    public final void setRegistry(DecoderRegistry decoderRegistry) {
        this.registry = decoderRegistry;
    }

    public final boolean contains(Integer key) {
        return this.variables.containsKey(key);
    }

    public final void remove(Integer key) {
        this.variables.remove(key);
    }

    public final Integer get(Integer key) {
        return this.variables.get(key);
    }

    public final Context put(Integer key, Integer value) {
        this.variables.put(key, value);
        return this;
    }
}

