/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class NewFunction
implements Action {
    private static final String FORMAT = "NewFunction: { name=%s; arguments=%s; actions=%s}";
    private final transient String name;
    private final transient List<String> arguments;
    private final transient List<Action> actions;
    private transient int length;
    private transient int actionsLength;

    public NewFunction(Builder builder) {
        this.name = builder.name;
        this.arguments = new ArrayList<String>(builder.arguments);
        this.actions = new ArrayList<Action>(builder.actions);
    }

    public NewFunction(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort();
        this.name = coder.readString();
        int argumentCount = coder.readUnsignedShort();
        this.arguments = new ArrayList<String>(argumentCount);
        if (argumentCount > 0) {
            for (int i = argumentCount; i > 0; --i) {
                this.arguments.add(coder.readString());
            }
        }
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        this.actions = new ArrayList<Action>();
        this.actionsLength = coder.readUnsignedShort();
        coder.mark();
        while (coder.bytesRead() < this.actionsLength) {
            decoder.getObject(this.actions, coder, context);
        }
        coder.unmark();
    }

    public NewFunction(String aString, List<String> argumentArray, List<Action> actionArray) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
        if (argumentArray == null) {
            throw new IllegalArgumentException();
        }
        this.arguments = argumentArray;
        if (actionArray == null) {
            throw new IllegalArgumentException();
        }
        this.actions = actionArray;
    }

    public NewFunction(List<String> argumentArray, List<Action> actionArray) {
        this("", argumentArray, actionArray);
    }

    public NewFunction(NewFunction object) {
        this.name = object.name;
        this.arguments = new ArrayList<String>(object.arguments);
        this.actions = new ArrayList<Action>(object.actions);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getArguments() {
        return new ArrayList<String>(this.arguments);
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    @Override
    public NewFunction copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.name, this.arguments, this.actions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2 + context.strlen(this.name);
        for (String argument : this.arguments) {
            this.length += context.strlen(argument);
        }
        this.length += 2;
        this.actionsLength = 0;
        for (Action action : this.actions) {
            this.actionsLength += action.prepareToEncode(context);
        }
        return 3 + this.length + this.actionsLength;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(155);
        coder.writeShort(this.length);
        coder.writeString(this.name);
        coder.writeShort(this.arguments.size());
        for (String argument : this.arguments) {
            coder.writeString(argument);
        }
        coder.writeShort(this.actionsLength);
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
    }

    public static final class Builder {
        private transient String name = "";
        private final transient List<String> arguments = new ArrayList<String>();
        private final transient List<Action> actions = new ArrayList<Action>();

        public Builder setName(String aString) {
            if (aString == null || aString.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = aString;
            return this;
        }

        public Builder setArgument(String argName) {
            if (argName == null || argName.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.arguments.add(argName);
            return this;
        }

        public Builder addAction(Action action) {
            if (action == null) {
                throw new IllegalArgumentException();
            }
            this.actions.add(action);
            return this;
        }

        public NewFunction build() {
            return new NewFunction(this);
        }
    }
}

